/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainMessageBodyReader<T>
implements MessageBodyReader<T> {
    private final Logger logger = LoggerFactory.getLogger(PlainMessageBodyReader.class);

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        byte[] data = PlainMessageBodyReader.data(entityStream);
        this.logger.debug("Received: type={}, genericType={}, annotations={}, mediaType={}, httpHeaders={}", new Object[]{type, genericType, annotations, mediaType, httpHeaders});
        if (type.equals(String.class) || genericType.equals(String.class)) {
            return (T)new String(data, StandardCharsets.UTF_8);
        }
        if (type.equals(byte[].class) || genericType.equals(byte[].class)) {
            return (T)data;
        }
        if (type.equals(Byte[].class) || genericType.equals(Byte[].class)) {
            Byte[] dataB = new Byte[data.length];
            int i = 0;
            while (i < data.length) {
                dataB[i] = data[i];
                ++i;
            }
            return (T)dataB;
        }
        throw new InternalServerErrorException(String.format("Cannot assign text plain to type \"%s\", generic type: \"%s\".", type, genericType));
    }

    private static byte[] data(InputStream is) throws IOException {
        int read;
        ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((read = is.read(buffer)) != -1) {
            outputBytes.write(buffer, 0, read);
        }
        return outputBytes.toByteArray();
    }
}

