/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0u | (~ uvec2(38u, 35u))) => uvec2(4294967257u, 4294967260u)
 * (0u | (~ uvec2(64u, 9u))) => uvec2(4294967231u, 4294967286u)
 * (6u | (~ uvec2(38u, 35u))) => uvec2(4294967263u, 4294967262u)
 * (6u | (~ uvec2(64u, 9u))) => uvec2(4294967231u, 4294967286u)
 * (12u | (~ uvec2(38u, 35u))) => uvec2(4294967261u, 4294967260u)
 * (12u | (~ uvec2(64u, 9u))) => uvec2(4294967231u, 4294967294u)
 * (32u | (~ uvec2(38u, 35u))) => uvec2(4294967289u, 4294967292u)
 * (32u | (~ uvec2(64u, 9u))) => uvec2(4294967231u, 4294967286u)
 * (74u | (~ uvec2(38u, 35u))) => uvec2(4294967259u, 4294967262u)
 * (74u | (~ uvec2(64u, 9u))) => uvec2(4294967295u, 4294967294u)
 */
#version 130

void main()
{
  float[all(equal((0u | (~ uvec2(38u, 35u))), uvec2(4294967257u, 4294967260u))) ? 1 : -1] array0;
  float[all(equal((0u | (~ uvec2(64u, 9u))), uvec2(4294967231u, 4294967286u))) ? 1 : -1] array1;
  float[all(equal((6u | (~ uvec2(38u, 35u))), uvec2(4294967263u, 4294967262u))) ? 1 : -1] array2;
  float[all(equal((6u | (~ uvec2(64u, 9u))), uvec2(4294967231u, 4294967286u))) ? 1 : -1] array3;
  float[all(equal((12u | (~ uvec2(38u, 35u))), uvec2(4294967261u, 4294967260u))) ? 1 : -1] array4;
  float[all(equal((12u | (~ uvec2(64u, 9u))), uvec2(4294967231u, 4294967294u))) ? 1 : -1] array5;
  float[all(equal((32u | (~ uvec2(38u, 35u))), uvec2(4294967289u, 4294967292u))) ? 1 : -1] array6;
  float[all(equal((32u | (~ uvec2(64u, 9u))), uvec2(4294967231u, 4294967286u))) ? 1 : -1] array7;
  float[all(equal((74u | (~ uvec2(38u, 35u))), uvec2(4294967259u, 4294967262u))) ? 1 : -1] array8;
  float[all(equal((74u | (~ uvec2(64u, 9u))), uvec2(4294967295u, 4294967294u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
