/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Graphics2D;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.util.JRStyledText;

public class TextRenderer {
    private Graphics2D grx = null;
    private int x = 0;
    private int y = 0;
    private int topPadding = 0;
    private int leftPadding = 0;
    private float formatWidth = 0.0f;
    private float verticalOffset = 0.0f;
    private float floatLineSpacing = 0.0f;
    private int maxHeight = 0;
    private float drawPosY = 0.0f;
    private float drawPosX = 0.0f;
    private boolean isMaxHeightReached = false;
    private byte horizontalAlignment = 0;

    public void render(Graphics2D initGrx, int initX, int initY, int initWidth, int initHeight, int initTopPadding, int initLeftPadding, int initBottomPadding, int initRightPadding, float initTextHeight, byte initHorizontalAlignment, byte initVerticalAlignment, byte initLineSpacing, JRStyledText styledText, String allText) {
        this.initialize(initGrx, initX, initY, initWidth, initHeight, initTopPadding, initLeftPadding, initBottomPadding, initRightPadding, initTextHeight, initHorizontalAlignment, initVerticalAlignment, initLineSpacing);
        AttributedCharacterIterator allParagraphs = styledText.getAttributedString().getIterator();
        int tokenPosition = 0;
        int lastParagraphStart = 0;
        String lastParagraphText = null;
        StringTokenizer tkzer = new StringTokenizer(allText, "\n", true);
        while (tkzer.hasMoreTokens() && !this.isMaxHeightReached) {
            String token = tkzer.nextToken();
            if ("\n".equals(token)) {
                this.renderParagraph(allParagraphs, lastParagraphStart, lastParagraphText);
                lastParagraphStart = tokenPosition;
                lastParagraphText = null;
            } else {
                lastParagraphStart = tokenPosition;
                lastParagraphText = token;
            }
            tokenPosition += token.length();
        }
        if (!this.isMaxHeightReached && lastParagraphStart < allText.length()) {
            this.renderParagraph(allParagraphs, lastParagraphStart, lastParagraphText);
        }
    }

    private void initialize(Graphics2D initGrx, int initX, int initY, int initWidth, int initHeight, int initTopPadding, int initLeftPadding, int initBottomPadding, int initRightPadding, float initTextHeight, byte initHorizontalAlignment, byte initVerticalAlignment, byte initLineSpacing) {
        this.grx = initGrx;
        this.horizontalAlignment = initHorizontalAlignment;
        this.verticalOffset = 0.0f;
        switch (initVerticalAlignment) {
            case 1: {
                this.verticalOffset = 0.0f;
                break;
            }
            case 2: {
                this.verticalOffset = ((float)(initHeight - initTopPadding - initBottomPadding) - initTextHeight) / 2.0f;
                break;
            }
            case 3: {
                this.verticalOffset = (float)(initHeight - initTopPadding - initBottomPadding) - initTextHeight;
                break;
            }
            default: {
                this.verticalOffset = 0.0f;
            }
        }
        this.floatLineSpacing = 1.0f;
        switch (initLineSpacing) {
            case 0: {
                this.floatLineSpacing = 1.0f;
                break;
            }
            case 1: {
                this.floatLineSpacing = 1.5f;
                break;
            }
            case 2: {
                this.floatLineSpacing = 2.0f;
                break;
            }
            default: {
                this.floatLineSpacing = 1.0f;
            }
        }
        this.x = initX;
        this.y = initY;
        this.topPadding = initTopPadding;
        this.leftPadding = initLeftPadding;
        this.formatWidth = initWidth - initLeftPadding - initRightPadding;
        this.formatWidth = this.formatWidth < 0.0f ? 0.0f : this.formatWidth;
        this.maxHeight = initHeight - initTopPadding - initBottomPadding;
        this.maxHeight = this.maxHeight < 0 ? 0 : this.maxHeight;
        this.drawPosY = 0.0f;
        this.drawPosX = 0.0f;
        this.isMaxHeightReached = false;
    }

    private void renderParagraph(AttributedCharacterIterator allParagraphs, int lastParagraphStart, String lastParagraphText) {
        AttributedCharacterIterator paragraph = null;
        paragraph = lastParagraphText == null ? new AttributedString(" ", new AttributedString(allParagraphs, lastParagraphStart, lastParagraphStart + 1).getIterator().getAttributes()).getIterator() : new AttributedString(allParagraphs, lastParagraphStart, lastParagraphStart + lastParagraphText.length()).getIterator();
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, this.grx.getFontRenderContext());
        while (lineMeasurer.getPosition() < paragraph.getEndIndex() && !this.isMaxHeightReached) {
            int startIndex = lineMeasurer.getPosition();
            TextLayout layout = lineMeasurer.nextLayout(this.formatWidth);
            AttributedString tmpText = new AttributedString(paragraph, startIndex, startIndex + layout.getCharacterCount());
            layout = new TextLayout(tmpText.getIterator(), this.grx.getFontRenderContext());
            this.drawPosY += layout.getLeading() + this.floatLineSpacing * layout.getAscent();
            if (this.drawPosY + layout.getDescent() <= (float)this.maxHeight) {
                switch (this.horizontalAlignment) {
                    case 4: {
                        this.drawPosX = layout.isLeftToRight() ? 0.0f : this.formatWidth - layout.getAdvance();
                        if (lineMeasurer.getPosition() >= paragraph.getEndIndex()) break;
                        layout = layout.getJustifiedLayout(this.formatWidth);
                        break;
                    }
                    case 3: {
                        this.drawPosX = this.formatWidth - layout.getAdvance();
                        break;
                    }
                    case 2: {
                        this.drawPosX = (this.formatWidth - layout.getAdvance()) / 2.0f;
                        break;
                    }
                    default: {
                        this.drawPosX = 0.0f;
                    }
                }
                this.draw(layout);
                this.drawPosY += layout.getDescent();
                continue;
            }
            this.drawPosY -= layout.getLeading() + this.floatLineSpacing * layout.getAscent();
            this.isMaxHeightReached = true;
        }
    }

    public float getTextHeight() {
        return this.drawPosY + 1.0f;
    }

    public void draw(TextLayout layout) {
        layout.draw(this.grx, this.drawPosX + (float)this.x + (float)this.leftPadding, this.drawPosY + (float)this.y + (float)this.topPadding + this.verticalOffset);
    }
}

