/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.generic.model.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.graalvm.visualvm.jfr.generic.model.impl.DisplayableSupport;
import org.graalvm.visualvm.jfr.model.JFRDataDescriptor;
import org.graalvm.visualvm.jfr.model.JFREventType;
import org.openjdk.jmc.common.item.IAccessorKey;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.flightrecorder.messages.internal.Messages;

final class JFRGenericEventType
extends JFREventType {
    static final String EXPERIMENTAL_PREFIX = Messages.getString("TypeManager_EXPERIMENTAL_TYPE").replace("{0}", "").trim();
    private final long typeId;
    private final IType type;
    private final String[] category;

    JFRGenericEventType(long typeId, IType<IItem> type, String[] category) {
        this.typeId = typeId;
        this.type = type;
        this.category = category;
    }

    public long getId() {
        return this.typeId;
    }

    public String getName() {
        return this.type.getIdentifier();
    }

    public String getDisplayName() {
        return this.type.getName();
    }

    public String getDescription() {
        return this.type.getDescription();
    }

    public List<String> getCategory() {
        return Arrays.asList(this.category);
    }

    public List<JFRDataDescriptor> getDisplayableDataDescriptors(boolean includeExperimental) {
        ArrayList<JFRDataDescriptor> descriptors = new ArrayList<JFRDataDescriptor>();
        Iterator<IAccessorKey> keys = DisplayableSupport.displayableAccessorKeys(this.type, includeExperimental);
        while (keys.hasNext()) {
            descriptors.add(DisplayableSupport.getDataDescriptor(keys.next()));
        }
        return descriptors;
    }

    public boolean isExperimental() {
        return this.type.getName().startsWith(EXPERIMENTAL_PREFIX);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof JFRGenericEventType && this.type.equals(((JFRGenericEventType)((Object)o)).type);
    }
}

