/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.AWTException;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import org.netbeans.core.windows.options.WinSysPrefs;

class WindowSnapper {
    private Robot robot = new Robot();
    private Point lastCursorLocation;
    private static final int SNAP_LIMIT = WinSysPrefs.HANDLER.getInt("snapping.active.size", 20);

    public void cursorMoved() {
        this.lastCursorLocation = this.getCurrentCursorLocation();
    }

    public boolean snapToScreenEdges(Rectangle rectangle) {
        if (null == this.lastCursorLocation) {
            this.lastCursorLocation = this.getCurrentCursorLocation();
            return false;
        }
        Rectangle rectangle2 = rectangle;
        Rectangle rectangle3 = this.getScreenBounds();
        Point point = this.getCurrentCursorLocation();
        if (null == point || null == rectangle3) {
            return false;
        }
        int n = point.x - this.lastCursorLocation.x;
        int n2 = point.y - this.lastCursorLocation.y;
        int n3 = point.x - rectangle2.x;
        int n4 = point.y - rectangle2.y;
        boolean bl = false;
        int n5 = point.x;
        int n6 = point.y;
        if (rectangle2.x < rectangle3.x + SNAP_LIMIT && rectangle2.x >= rectangle3.x - SNAP_LIMIT && n < 0) {
            n5 = rectangle3.x + n3;
            bl = true;
        } else if (rectangle2.x + rectangle2.width > rectangle3.x + rectangle3.width - SNAP_LIMIT && rectangle2.x + rectangle2.width <= rectangle3.x + rectangle3.width + SNAP_LIMIT && n > 0) {
            n5 = rectangle3.x + rectangle3.width - rectangle2.width + n3;
            bl = true;
        }
        if (rectangle2.y < rectangle3.y + SNAP_LIMIT && rectangle2.y >= rectangle3.y - SNAP_LIMIT && n2 < 0) {
            n6 = rectangle3.y + n4;
            bl = true;
        } else if (rectangle2.y + rectangle2.height > rectangle3.y + rectangle3.height - SNAP_LIMIT && rectangle2.y + rectangle2.height <= rectangle3.y + rectangle3.height + SNAP_LIMIT && n2 > 0) {
            n6 = rectangle3.y + rectangle3.height - rectangle2.height + n4;
            bl = true;
        }
        if (bl) {
            this.robot.mouseMove(n5, n6);
        }
        return bl;
    }

    public boolean snapTo(Rectangle rectangle, Rectangle rectangle2) {
        boolean bl = false;
        if (null != this.lastCursorLocation) {
            Point point = this.getCurrentCursorLocation();
            if (null == point) {
                return false;
            }
            int n = point.x - this.lastCursorLocation.x;
            int n2 = point.y - this.lastCursorLocation.y;
            int n3 = point.x - rectangle.x;
            int n4 = point.y - rectangle.y;
            int n5 = point.x;
            int n6 = point.y;
            if (rectangle.x < rectangle2.x + rectangle2.width + SNAP_LIMIT && rectangle.x >= rectangle2.x + rectangle2.width - SNAP_LIMIT && this.isVerticalProximity(rectangle, rectangle2) && n < 0) {
                n5 = rectangle2.x + rectangle2.width + n3;
                bl = true;
            } else if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width - SNAP_LIMIT && rectangle.x + rectangle.width <= rectangle2.x + rectangle2.width + SNAP_LIMIT && (rectangle.y == rectangle2.y + rectangle2.height || rectangle.y + rectangle.height == rectangle2.y) && n > 0) {
                n5 = rectangle2.x + rectangle2.width - rectangle.width + n3;
                bl = true;
            } else if (rectangle.x + rectangle.width > rectangle2.x - SNAP_LIMIT && rectangle.x + rectangle.width <= rectangle2.x + SNAP_LIMIT && this.isVerticalProximity(rectangle, rectangle2) && n > 0) {
                n5 = rectangle2.x - rectangle.width + n3;
                bl = true;
            } else if (rectangle.x < rectangle2.x + SNAP_LIMIT && rectangle.x >= rectangle2.x - SNAP_LIMIT && (rectangle.y == rectangle2.y + rectangle2.height || rectangle.y + rectangle.height == rectangle2.y) && n < 0) {
                n5 = rectangle2.x + n3;
                bl = true;
            }
            if (rectangle.y + rectangle.height > rectangle2.y - SNAP_LIMIT && rectangle.y + rectangle.height <= rectangle2.y + SNAP_LIMIT && this.isHorizontalProximity(rectangle, rectangle2) && n2 > 0) {
                n6 = rectangle2.y - rectangle.height + n4;
                bl = true;
            } else if (rectangle.y < rectangle2.y + SNAP_LIMIT && rectangle.y >= rectangle2.y - SNAP_LIMIT && (rectangle.x == rectangle2.x + rectangle2.width || rectangle.x + rectangle.width == rectangle2.x) && n2 < 0) {
                n6 = rectangle2.y + n4;
                bl = true;
            } else if (rectangle.y < rectangle2.y + rectangle2.height + SNAP_LIMIT && rectangle.y >= rectangle2.y + rectangle2.height - SNAP_LIMIT && this.isHorizontalProximity(rectangle, rectangle2) && n2 < 0) {
                n6 = rectangle2.y + rectangle2.height + n4;
                bl = true;
            } else if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height - SNAP_LIMIT && rectangle.y + rectangle.height <= rectangle2.y + rectangle2.height + SNAP_LIMIT && (rectangle.x == rectangle2.x + rectangle2.width || rectangle.x + rectangle.width == rectangle2.x) && n2 > 0) {
                n6 = rectangle2.y + rectangle2.height - rectangle.height + n4;
                bl = true;
            }
            if (bl) {
                this.robot.mouseMove(n5, n6);
                this.lastCursorLocation = this.getCurrentCursorLocation();
            }
        }
        return bl;
    }

    private Point getCurrentCursorLocation() {
        Point point = null;
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (null != pointerInfo) {
            point = pointerInfo.getLocation();
        }
        return point;
    }

    private Rectangle getScreenBounds() {
        GraphicsConfiguration graphicsConfiguration;
        GraphicsDevice graphicsDevice;
        Rectangle rectangle = null;
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (null != pointerInfo && (graphicsDevice = pointerInfo.getDevice()) != null && (graphicsConfiguration = graphicsDevice.getDefaultConfiguration()) != null) {
            rectangle = graphicsConfiguration.getBounds();
        }
        return rectangle;
    }

    private boolean isVerticalProximity(Rectangle rectangle, Rectangle rectangle2) {
        rectangle = new Rectangle(rectangle);
        rectangle2 = new Rectangle(rectangle2);
        rectangle.x = 0;
        rectangle.width = 1;
        rectangle2.x = 0;
        rectangle2.width = 1;
        return rectangle.intersection((Rectangle)rectangle2).height > 0;
    }

    private boolean isHorizontalProximity(Rectangle rectangle, Rectangle rectangle2) {
        rectangle = new Rectangle(rectangle);
        rectangle2 = new Rectangle(rectangle2);
        rectangle.y = 0;
        rectangle.height = 1;
        rectangle2.y = 0;
        rectangle2.height = 1;
        return rectangle.intersection((Rectangle)rectangle2).width > 0;
    }
}

