/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.search;

import org.netbeans.api.search.Bundle;

public final class SearchPattern {
    private String searchExpression;
    private boolean wholeWords;
    private boolean matchCase;
    private MatchType matchType;

    private SearchPattern(String string, boolean bl, boolean bl2, MatchType matchType) {
        this.searchExpression = string;
        this.wholeWords = bl;
        this.matchCase = bl2;
        this.matchType = matchType;
    }

    public static SearchPattern create(String string, boolean bl, boolean bl2, boolean bl3) {
        return new SearchPattern(string, bl, bl2, bl3 ? MatchType.REGEXP : MatchType.LITERAL);
    }

    public static SearchPattern create(String string, boolean bl, boolean bl2, MatchType matchType) {
        return new SearchPattern(string, bl, bl2, matchType);
    }

    public String getSearchExpression() {
        return this.searchExpression;
    }

    public boolean isWholeWords() {
        return this.wholeWords;
    }

    public boolean isMatchCase() {
        return this.matchCase;
    }

    public boolean isRegExp() {
        return this.matchType == MatchType.REGEXP;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SearchPattern)) {
            return false;
        }
        SearchPattern searchPattern = (SearchPattern)object;
        return this.searchExpression.equals(searchPattern.getSearchExpression()) && this.wholeWords == searchPattern.isWholeWords() && this.matchCase == searchPattern.isMatchCase() && this.matchType == searchPattern.matchType;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + (this.wholeWords ? 1 : 0);
        n = 37 * n + (this.matchCase ? 1 : 0);
        n = 37 * n + this.matchType.hashCode();
        n = 37 * n + this.searchExpression.hashCode();
        return n;
    }

    public SearchPattern changeSearchExpression(String string) {
        if (string == null && this.searchExpression == null || string != null && string.equals(this.searchExpression)) {
            return this;
        }
        return SearchPattern.create(string, this.wholeWords, this.matchCase, this.matchType);
    }

    public SearchPattern changeWholeWords(boolean bl) {
        if (this.wholeWords == bl) {
            return this;
        }
        return SearchPattern.create(this.searchExpression, bl, this.matchCase, this.matchType);
    }

    public SearchPattern changeMatchCase(boolean bl) {
        if (this.matchCase == bl) {
            return this;
        }
        return SearchPattern.create(this.searchExpression, this.wholeWords, bl, this.matchType);
    }

    public SearchPattern changeRegExp(boolean bl) {
        if (this.isRegExp() == bl) {
            return this;
        }
        return SearchPattern.create(this.searchExpression, this.wholeWords, this.matchCase, bl);
    }

    public SearchPattern changeMatchType(MatchType matchType) {
        if (this.matchType == matchType) {
            return this;
        }
        return SearchPattern.create(this.searchExpression, this.wholeWords, this.matchCase, matchType);
    }

    String toCanonicalString() {
        char c = this.isMatchCase() ? (char)'M' : 'm';
        char c2 = this.matchType.getCanonicalPatternFlag();
        char c3 = this.isWholeWords() ? (char)'W' : 'w';
        return "" + c + c2 + c3 + "-" + this.getSearchExpression();
    }

    static SearchPattern parsePattern(String string) {
        if (string == null || Character.toUpperCase(string.charAt(0)) != 'M' || !MatchType.isCanonicalPatternFlag(string.charAt(1)) || Character.toUpperCase(string.charAt(2)) != 'W' || string.charAt(3) != '-') {
            return null;
        }
        boolean bl = Character.isUpperCase(string.charAt(0));
        MatchType matchType = MatchType.fromCanonicalPatternFlag(string.charAt(1));
        boolean bl2 = Character.isUpperCase(string.charAt(2));
        String string2 = string.substring(4);
        return new SearchPattern(string2, bl2, bl, matchType);
    }

    public static enum MatchType {
        LITERAL(Bundle.LBL_MatchType_Literal(), 'L'),
        BASIC(Bundle.LBL_MatchType_Basic_Wildcards(), 'r'),
        REGEXP(Bundle.LBL_MatchType_Regular_Expression(), 'R');

        private final String displayName;
        private final char canonicalPatternFlag;

        private MatchType(String string2, char c) {
            this.displayName = string2;
            this.canonicalPatternFlag = c;
        }

        public String toString() {
            return this.displayName;
        }

        private char getCanonicalPatternFlag() {
            return this.canonicalPatternFlag;
        }

        private static MatchType fromCanonicalPatternFlag(char c) {
            switch (c) {
                case 'R': {
                    return REGEXP;
                }
                case 'r': {
                    return BASIC;
                }
                case 'L': {
                    return LITERAL;
                }
            }
            return BASIC;
        }

        private static boolean isCanonicalPatternFlag(char c) {
            for (MatchType matchType : MatchType.values()) {
                if (matchType.getCanonicalPatternFlag() != c) continue;
                return true;
            }
            return false;
        }
    }
}

