/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import org.glassfish.jersey.internal.Errors;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.model.AbstractResourceModelVisitor;
import org.glassfish.jersey.server.model.Resource;

class ResourceValidator
extends AbstractResourceModelVisitor {
    ResourceValidator() {
    }

    @Override
    public void visitResource(Resource resource2) {
        this.checkResource(resource2);
    }

    private void checkResource(Resource resource2) {
        if (!resource2.getResourceMethods().isEmpty() && resource2.getResourceLocator() != null) {
            Errors.warning(resource2, LocalizationMessages.RESOURCE_CONTAINS_RES_METHODS_AND_LOCATOR(resource2, resource2.getPath()));
        }
        if (resource2.getPath() != null && resource2.getResourceMethods().isEmpty() && resource2.getChildResources().isEmpty() && resource2.getResourceLocator() == null) {
            Errors.warning(resource2, LocalizationMessages.RESOURCE_EMPTY(resource2, resource2.getPath()));
        }
    }

    @Override
    public void visitChildResource(Resource resource2) {
        this.checkResource(resource2);
    }
}

