/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Data;

class DataListener
extends AbstractIqRequestHandler {
    private final InBandBytestreamManager manager;

    DataListener(InBandBytestreamManager manager) {
        super("data", "http://jabber.org/protocol/ibb", IQ.Type.set, IQRequestHandler.Mode.async);
        this.manager = manager;
    }

    @Override
    public IQ handleIQRequest(IQ iqRequest) {
        Data data2 = (Data)iqRequest;
        InBandBytestreamSession ibbSession = this.manager.getSessions().get(data2.getDataPacketExtension().getSessionID());
        try {
            if (ibbSession == null) {
                this.manager.replyItemNotFoundPacket(data2);
            } else {
                ibbSession.processIQPacket(data2);
            }
        }
        catch (InterruptedException | SmackException.NotConnectedException | SmackException.NotLoggedInException e) {
            return null;
        }
        return null;
    }
}

