/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class KeyedSemaphore {
    ConcurrentHashMap<String, Semaphore> map = new ConcurrentHashMap();
    static StackLogger logger = CommonLogger.getLogger(KeyedSemaphore.class);

    public void leaveIOCriticalSection(String key) {
        Semaphore creationSemaphore = this.map.get(key);
        if (creationSemaphore != null) {
            creationSemaphore.release();
        }
    }

    public void remove(String key) {
        if (this.map.get(key) != null) {
            this.map.get(key).release();
            this.map.remove(key);
        }
    }

    public void enterIOCriticalSection(String key) throws IOException {
        Semaphore newCreationSemaphore;
        Semaphore creationSemaphore = this.map.get(key);
        if (creationSemaphore == null && (creationSemaphore = this.map.putIfAbsent(key, newCreationSemaphore = new Semaphore(1, true))) == null) {
            creationSemaphore = newCreationSemaphore;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("new Semaphore added for key " + key);
            }
        }
        try {
            boolean retval = creationSemaphore.tryAcquire(10L, TimeUnit.SECONDS);
            if (!retval) {
                throw new IOException("Could not acquire IO Semaphore'" + key + "' after 10 seconds -- giving up ");
            }
        }
        catch (InterruptedException e) {
            throw new IOException("exception in acquiring sem");
        }
    }
}

