/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.debugger;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.util.ObservableReader;
import org.jivesoftware.smack.util.ObservableWriter;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.xml.splitter.XmlPrettyPrinter;
import org.jxmpp.xml.splitter.XmppXmlSplitter;

public abstract class SmackDebugger {
    protected final XMPPConnection connection;
    private XmppXmlSplitter outgoingStreamSplitterForPrettyPrinting;
    private XmppXmlSplitter incomingStreamSplitterForPrettyPrinting;

    protected SmackDebugger(XMPPConnection connection) {
        this.connection = connection;
    }

    public abstract void userHasLogged(EntityFullJid var1);

    public abstract void outgoingStreamSink(CharSequence var1);

    public void onOutgoingElementCompleted() {
    }

    public abstract void incomingStreamSink(CharSequence var1);

    public void onIncomingElementCompleted() {
    }

    public final Reader newConnectionReader(Reader reader) {
        XmlPrettyPrinter xmlPrettyPrinter = XmlPrettyPrinter.builder().setPrettyWriter(sb -> this.incomingStreamSink(sb)).build();
        this.incomingStreamSplitterForPrettyPrinting = new XmppXmlSplitter(xmlPrettyPrinter);
        ObservableReader observableReader = new ObservableReader(reader);
        observableReader.addReaderListener(readString -> {
            try {
                this.incomingStreamSplitterForPrettyPrinting.append(readString);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        });
        return observableReader;
    }

    public final Writer newConnectionWriter(Writer writer) {
        XmlPrettyPrinter xmlPrettyPrinter = XmlPrettyPrinter.builder().setPrettyWriter(sb -> this.outgoingStreamSink(sb)).build();
        this.outgoingStreamSplitterForPrettyPrinting = new XmppXmlSplitter(xmlPrettyPrinter);
        ObservableWriter observableWriter = new ObservableWriter(writer);
        observableWriter.addWriterListener(writtenString -> {
            try {
                this.outgoingStreamSplitterForPrettyPrinting.append(writtenString);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        });
        return observableWriter;
    }

    public abstract void onIncomingStreamElement(TopLevelStreamElement var1);

    public abstract void onOutgoingStreamElement(TopLevelStreamElement var1);
}

