/*
    SPDX-FileCopyrightText: 2021 Alexander Lohnau <alexander.lohnau@gmx.de>
    SPDX-License-Identifier: LGPL-2.0-or-later
*/

#include <QPluginLoader>
#include <kcoreaddons_export.h>

/*
 * Used by K_IMPORT_PLUGIN
 * @internal
 * @since 5.89
 */
void KCOREADDONS_EXPORT kRegisterStaticPluginFunction(const QString &directory, QStaticPlugin plugin);

/**
 * This macro imports the plugin that corresponds with the name of the class
 * that declares metadata for the plugin with Q_PLUGIN_METADATA().
 * To query the available plugins, @ref KPluginMetaData::findPlugins or @ref KPluginMetaData::findPluginById
 * can be used with the same namespace parameter.
 *
 * @note The K_IMPORT_PLUGIN statements should be generated by the kcoreaddons_add_plugin and kcoreaddons_target_static_plugins
 * cmake macros.
 * @since 5.89
 */
#define K_IMPORT_PLUGIN(NAMESPACE, PLUGIN)                                                                                                                     \
    extern const QT_PREPEND_NAMESPACE(QStaticPlugin) qt_static_plugin_##PLUGIN();                                                                              \
    class Static##PLUGIN##PluginInstance                                                                                                                       \
    {                                                                                                                                                          \
    public:                                                                                                                                                    \
        Static##PLUGIN##PluginInstance()                                                                                                                       \
        {                                                                                                                                                      \
            kRegisterStaticPluginFunction(NAMESPACE, qt_static_plugin_##PLUGIN());                                                                             \
        }                                                                                                                                                      \
    };                                                                                                                                                         \
    static Static##PLUGIN##PluginInstance static##PLUGIN##Instance;
