# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_policy.orgs.projects.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class Infra(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.infra'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _InfraStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            org_id,
            project_id,
            base_path=None,
            filter=None,
            type_filter=None,
            ):
        """
        Read infra. Returns only the infra related properties. Inner object are
        not populated.

        :type  org_id: :class:`str`
        :param org_id: The organization ID (required)
        :type  project_id: :class:`str`
        :param project_id: The project ID (required)
        :type  base_path: :class:`str` or ``None``
        :param base_path: Base Path for retrieving hierarchical intent (optional)
        :type  filter: :class:`str` or ``None``
        :param filter: Filter string as java regex (optional)
        :type  type_filter: :class:`str` or ``None``
        :param type_filter: Filter string to retrieve hierarchy. (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Infra`
        :return: com.vmware.nsx_policy.model.Infra
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'base_path': base_path,
                            'filter': filter,
                            'type_filter': type_filter,
                            })

    def patch(self,
              org_id,
              project_id,
              infra,
              enforce_revision_check=None,
              ):
        """
        Patch API at infra level can be used in two flavours 1. Like a regular
        API to update Infra object 2. Hierarchical API: To create/update/delete
        entire or part of intent hierarchy Hierarchical API: Provides users a
        way to create entire or part of intent in single API invocation. Input
        is expressed in a tree format. Each node in tree can have multiple
        children of different types. System will resolve the dependencies of
        nodes within the intent tree and will create the model. Children for
        any node can be specified using ChildResourceReference or
        ChildPolicyConfigResource. If a resource is specified using
        ChildResourceReference then it will not be updated only its children
        will be updated. If Object is specified using
        ChildPolicyConfigResource, object along with its children will be
        updated. Hierarchical API can also be used to delete any sub-branch of
        entire tree.

        :type  org_id: :class:`str`
        :param org_id: The organization ID (required)
        :type  project_id: :class:`str`
        :param project_id: The project ID (required)
        :type  infra: :class:`com.vmware.nsx_policy.model_client.Infra`
        :param infra: (required)
        :type  enforce_revision_check: :class:`bool` or ``None``
        :param enforce_revision_check: Force revision check (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'infra': infra,
                            'enforce_revision_check': enforce_revision_check,
                            })
class QuotaStats(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.quota_stats'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _QuotaStatsStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            org_id,
            project_id,
            path_prefix,
            constraint_path=None,
            ):
        """
        Get quota details To create, update, list and delete the Quota, please
        refer to Constraint APIs with 'constraint_expressions' as
        'EntityInstanceCountConstraintExpression'.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  path_prefix: :class:`str`
        :param path_prefix: Path prefix for retriving the quota details. (required)
        :type  constraint_path: :class:`str` or ``None``
        :param constraint_path: Constraint path to retrive the quota details. (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.QuotaStatsListResult`
        :return: com.vmware.nsx_policy.model.QuotaStatsListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'path_prefix': path_prefix,
                            'constraint_path': constraint_path,
                            })
class SharedWithMe(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.shared_with_me'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SharedWithMeStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             org_id,
             project_id,
             resource_type=None,
             ):
        """
        Get the list of resource shared with a given project.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  resource_type: :class:`str` or ``None``
        :param resource_type: resource type (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.SharedResourceListResult`
        :return: com.vmware.nsx_policy.model.SharedResourceListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'resource_type': resource_type,
                            })
class Vpcs(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_policy.orgs.projects.vpcs'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _VpcsStub)
        self._VAPI_OPERATION_IDS = {}


    def delete(self,
               org_id,
               project_id,
               vpc_id,
               ):
        """
        Delete VPC.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  vpc_id: :class:`str`
        :param vpc_id: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('delete',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'vpc_id': vpc_id,
                            })

    def get(self,
            org_id,
            project_id,
            vpc_id,
            ):
        """
        Get VPC

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  vpc_id: :class:`str`
        :param vpc_id: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Vpc`
        :return: com.vmware.nsx_policy.model.Vpc
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('get',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'vpc_id': vpc_id,
                            })

    def list(self,
             org_id,
             project_id,
             cursor=None,
             include_mark_for_delete_objects=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Paginated list of VPC.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  include_mark_for_delete_objects: :class:`bool` or ``None``
        :param include_mark_for_delete_objects: Include objects that are marked for deletion in results (optional,
            default to false)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx_policy.model_client.VpcListResult`
        :return: com.vmware.nsx_policy.model.VpcListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'cursor': cursor,
                            'include_mark_for_delete_objects': include_mark_for_delete_objects,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def patch(self,
              org_id,
              project_id,
              vpc_id,
              vpc,
              ):
        """
        If a VPC with the vpc-id is not already present, create a new VPC. If
        it already exists, update the VPC.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  vpc_id: :class:`str`
        :param vpc_id: (required)
        :type  vpc: :class:`com.vmware.nsx_policy.model_client.Vpc`
        :param vpc: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('patch',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'vpc_id': vpc_id,
                            'vpc': vpc,
                            })

    def update(self,
               org_id,
               project_id,
               vpc_id,
               vpc,
               ):
        """
        Update the VPC.

        :type  org_id: :class:`str`
        :param org_id: (required)
        :type  project_id: :class:`str`
        :param project_id: (required)
        :type  vpc_id: :class:`str`
        :param vpc_id: (required)
        :type  vpc: :class:`com.vmware.nsx_policy.model_client.Vpc`
        :param vpc: (required)
        :rtype: :class:`com.vmware.nsx_policy.model_client.Vpc`
        :return: com.vmware.nsx_policy.model.Vpc
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'org_id': org_id,
                            'project_id': project_id,
                            'vpc_id': vpc_id,
                            'vpc': vpc,
                            })
class _InfraStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'base_path': type.OptionalType(type.StringType()),
            'filter': type.OptionalType(type.StringType()),
            'type_filter': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/infra',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
            },
             header_parameters={
                       },
            query_parameters={
                'base_path': 'base_path',
                'filter': 'filter',
                'type_filter': 'type_filter',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'infra': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Infra'),
            'enforce_revision_check': type.OptionalType(type.BooleanType()),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/infra',
            request_body_parameter='infra',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
            },
             header_parameters={
                     },
            query_parameters={
                'enforce_revision_check': 'enforce_revision_check',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Infra'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
            'patch': patch_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.infra',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _QuotaStatsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'path_prefix': type.StringType(),
            'constraint_path': type.OptionalType(type.StringType()),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/quota-stats',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
            },
             header_parameters={
                     },
            query_parameters={
                'path_prefix': 'path_prefix',
                'constraint_path': 'constraint_path',
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'QuotaStatsListResult'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.quota_stats',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _SharedWithMeStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'resource_type': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/shared-with-me',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
            },
             header_parameters={
                   },
            query_parameters={
                'resource_type': 'resource_type',
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'SharedResourceListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.shared_with_me',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _VpcsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'vpc_id': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs/{vpc-id}',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'vpc_id': 'vpc-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'vpc_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
            HasFieldsOfValidator()
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs/{vpc-id}',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'vpc_id': 'vpc-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'include_mark_for_delete_objects': type.OptionalType(type.BooleanType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
            HasFieldsOfValidator()
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
            },
             header_parameters={
                             },
            query_parameters={
                'cursor': 'cursor',
                'include_mark_for_delete_objects': 'include_mark_for_delete_objects',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for patch operation
        patch_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'vpc_id': type.StringType(),
            'vpc': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Vpc'),
        })
        patch_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        patch_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        patch_output_validator_list = [
        ]
        patch_rest_metadata = OperationRestMetadata(
            http_method='PATCH',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs/{vpc-id}',
            request_body_parameter='vpc',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'vpc_id': 'vpc-id',
            },
             header_parameters={
                     },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'org_id': type.StringType(),
            'project_id': type.StringType(),
            'vpc_id': type.StringType(),
            'vpc': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Vpc'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
            HasFieldsOfValidator()
        ]
        update_output_validator_list = [
            HasFieldsOfValidator()
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/policy/api/v1/orgs/{org-id}/projects/{project-id}/vpcs/{vpc-id}',
            request_body_parameter='vpc',
            path_variables={
                'org_id': 'org-id',
                'project_id': 'project-id',
                'vpc_id': 'vpc-id',
            },
             header_parameters={
                     },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Vpc'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'VpcListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'patch': {
                'input_type': patch_input_type,
                'output_type': type.VoidType(),
                'errors': patch_error_dict,
                'input_value_validator_list': patch_input_value_validator_list,
                'output_validator_list': patch_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_policy.model_client', 'Vpc'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'patch': patch_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_policy.orgs.projects.vpcs',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'Infra': Infra,
        'QuotaStats': QuotaStats,
        'SharedWithMe': SharedWithMe,
        'Vpcs': Vpcs,
        'aaa': 'com.vmware.nsx_policy.orgs.projects.aaa_client.StubFactory',
        'infra': 'com.vmware.nsx_policy.orgs.projects.infra_client.StubFactory',
        'vpcs': 'com.vmware.nsx_policy.orgs.projects.vpcs_client.StubFactory',
    }

