// Copyright 2014 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Created by postproc-cld2 4.0 on 2014-10-16 11:27:48
// From command line:
//  --cld2 --cc --just_read_raw --delta_octa 
//  --wrt=cld2_generated_quadchrome1015_2.bin --standard --minchars=5 
//  --mincount=2 --max_items_per_langscript=300 --flatmap --rr_alloc 
//  --freq_alloc --boostcloseweakerpercent=00 --indirectbits=12 --thresh=224 
//  --v25 --kentries=16 --tablename=DeltaOctaChrome1015 
//  --remap=xxx-Latn=>ut-Latn tw-Latn=>ak-Latn nd-Latn=>nr-Latn 
//  blu-Latn=>hmn-Latn nn-Latn=>no-Latn  --include=af-Latn ar-Arab be-Cyrl 
//  bg-Cyrl bs-Latn ca-Latn cs-Latn cy-Latn   da-Latn de-Latn el-Grek 
//  en-Latn es-Latn et-Latn fa-Arab fi-Latn fr-Latn   ga-Latn gd-Latn 
//  hi-Deva hr-Latn hu-Latn id-Latn is-Latn it-Latn iw-Hebr   ja-Hani 
//  ko-Hani lg-Latn lt-Latn lv-Latn mk-Cyrl ms-Latn nl-Latn no-Latn   
//  pl-Latn pt-Latn ro-Latn ro-Cyrl ru-Cyrl rw-Latn sh-Cyrl sh-Latn sk-Latn 
//  sl-Latn sr-Cyrl   sv-Latn sw-Latn th-Thai tl-Latn tr-Latn uk-Cyrl 
//  vi-Latn yi-Hebr   zh-Hani zh-TW zhT-Hani   sq-Latn az-Latn eu-Latn 
//  bn-Beng gl-Latn ht-Latn mt-Latn sr-Latn ur-Arab   bh-Deva mr-Deva 
//  ne-Deva lg-Latn rw-Latn gd-Latn   ut-Latn ut-Deva   ceb-Latn blu-Latn 
//  hmn-Latn jw-Latn   kk-Cyrl ku-Latn ky-Cyrl mg-Latn ny-Latn st-Latn 
//  su-Latn tg-Cyrl uz-Latn uz-Cyrl  --ko_english --force_to_lang_soft 
//  --nosoft_cram2 --nomsidlevel --shapeflatprob --langpriorpercent=10 
//  --skipnuc --noshapeforcetop --noshapeeventop --noshapesteep2 --spread=15 
//  --nodoubleclose --langcounts --writebin --list_items=120 
//  /hdb1/cld2/probs/p90_raw_octagrams_2014b.utf8 
// 
// CLD2_pslangs
// 
// See compact_lang_det.cc for usage
// 
#include "cld2tablesummary.h"
namespace CLD2 {

static const uint32 kDeltaOctaChrome1015BuildDate = 20141016;    // yyyymmdd


// Of 24401 offered items into 16384 table entries:
// 15322 filled (62%), 4 merged (0%), 9075 dropped (37%)

// Nil-grams: 19 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI 
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE 
//     SYRIAC LIMBU ORIYA INUKTITUT 

// Uni-grams: 4 languages
//     Japanese Korean Chinese ChineseT 

// Words/Quads: 75 languages in range ENGLISH..NYANJA:
//     ENGLISH DANISH DUTCH FINNISH FRENCH GERMAN HEBREW ITALIAN 
//     NORWEGIAN POLISH PORTUGUESE RUSSIAN SPANISH SWEDISH CZECH 
//     ICELANDIC LATVIAN LITHUANIAN ROMANIAN HUNGARIAN ESTONIAN 
//     Unknown BULGARIAN CROATIAN SERBIAN IRISH GALICIAN TAGALOG 
//     TURKISH UKRAINIAN HINDI MACEDONIAN BENGALI INDONESIAN MALAY 
//     WELSH NEPALI ALBANIAN BELARUSIAN JAVANESE URDU BIHARI ARABIC 
//     CATALAN BASQUE SCOTS_GAELIC SWAHILI SLOVENIAN MARATHI MALTESE 
//     VIETNAMESE SLOVAK SUNDANESE UZBEK AZERBAIJANI PERSIAN BOSNIAN 
//     SESOTHO KYRGYZ YIDDISH KURDISH MONGOLIAN AFRIKAANS KAZAKH 
//     TAJIK HAITIAN_CREOLE KINYARWANDA MALAGASY GANDA CEBUANO HMONG 
//     NYANJA 

// TopLanguage  TokenCount
//  ENGLISH 185
//  DANISH 188
//  DUTCH 183
//  FINNISH 193
//  FRENCH 183
//  GERMAN 181
//  HEBREW 190
//  ITALIAN 183
//  Japanese 179
//  Korean 185
//  NORWEGIAN 199
//  POLISH 171
//  PORTUGUESE 215
//  RUSSIAN 203
//  SPANISH 187
//  SWEDISH 171
//  Chinese 190
//  CZECH 358
//  ICELANDIC 195
//  LATVIAN 194
//  LITHUANIAN 187
//  ROMANIAN 372
//  HUNGARIAN 184
//  ESTONIAN 176
//  Unknown 6
//  BULGARIAN 192
//  CROATIAN 359
//  SERBIAN 400
//  IRISH 188
//  GALICIAN 188
//  TAGALOG 183
//  TURKISH 199
//  UKRAINIAN 194
//  HINDI 383
//  MACEDONIAN 186
//  BENGALI 185
//  INDONESIAN 365
//  MALAY 335
//  WELSH 188
//  NEPALI 181
//  ALBANIAN 179
//  BELARUSIAN 186
//  JAVANESE 181
//  URDU 178
//  BIHARI 265
//  ARABIC 188
//  CATALAN 186
//  BASQUE 193
//  SCOTS_GAELIC 177
//  SWAHILI 189
//  SLOVENIAN 196
//  MARATHI 185
//  MALTESE 187
//  VIETNAMESE 189
//  SLOVAK 339
//  SUNDANESE 194
//  UZBEK 369
//  AZERBAIJANI 182
//  PERSIAN 174
//  BOSNIAN 189
//  SESOTHO 186
//  KYRGYZ 196
//  YIDDISH 193
//  KURDISH 189
//  MONGOLIAN 4
//  AFRIKAANS 193
//  KAZAKH 180
//  TAJIK 184
//  HAITIAN_CREOLE 186
//  KINYARWANDA 193
//  MALAGASY 172
//  GANDA 186
//  CEBUANO 177
//  HMONG 188
//  NYANJA 189



// Recognized language-script combinations [78]:
static const char* const kDeltaOctaChrome1015RecognizedLangScripts = 
  "af-Latn ar-Arab az-Latn be-Cyrl bg-Cyrl bh-Deva bn-Beng bs-Latn "
  "ca-Latn ceb-Latn cs-Latn cy-Latn da-Latn de-Latn en-Latn es-Latn "
  "et-Latn eu-Latn fa-Arab fi-Latn fr-Latn ga-Latn gd-Latn gl-Latn "
  "hi-Deva hmn-Latn hr-Latn ht-Latn hu-Latn id-Latn is-Latn it-Latn "
  "iw-Hebr ja-Hani jw-Latn kk-Cyrl ko-Hani ku-Latn ky-Cyrl lg-Latn "
  "lt-Latn lv-Latn mg-Latn mk-Cyrl mn-Latn mr-Deva ms-Latn mt-Latn "
  "ne-Deva nl-Latn no-Latn ny-Latn pl-Latn pt-Latn ro-Cyrl ro-Latn "
  "ru-Cyrl rw-Latn sk-Latn sl-Latn sq-Latn sr-Cyrl sr-Latn st-Latn "
  "su-Latn sv-Latn sw-Latn tg-Cyrl tl-Latn tr-Latn uk-Cyrl un-Latn "
  "ur-Arab uz-Cyrl uz-Latn vi-Latn yi-Hebr zh-Hani ";

static const uint32 kDeltaOctaChrome1015Size = 4096;    // Bucket count
static const uint32 kDeltaOctaChrome1015KeyMask = 0xfffff000;    // Mask hash key

static const IndirectProbBucket4 kDeltaOctaChrome1015[kDeltaOctaChrome1015Size] = {
  // hash_indirect[4], tokens[4] in UTF-8
   {{0x1682b002,0x53576003,0x527fe003,0xe3eb4004}},	// [000] _उमराव_, _þremur_, _vatni_, _vietoj_, 
   {{0x67c95005,0x00000000,0x00000000,0x00000000}},	//   _zastosow, --, --, --, 
   {{0x3a4ba006,0x29edc007,0x17cda008,0x9e1ac009}},	//   _בלילה_, _finitura_, _чиқмайди_, _kecelaka, 
   {{0x627ef00a,0x5292500b,0x23f8500c,0x2249700d}},	//   _ikinci_, _intara_, _palun_, _agamba_, 
   {{0x72d9f00e,0x21940006,0x9b7dd00f,0xb27f8010}},	//   _kuten_, _גרסאות_, _prenumer, _marni_, 
   {{0x7e716011,0x83eb9012,0x94f30013,0x00000000}},	//   _karaoké_, _nesta_, _shembull_, --, 
   {{0x52b15014,0xc1833015,0xee040016,0xc1758017}},	//   _mostrará_, _плате_, _ערנסטע_, _מועצת_, 
   {{0xd201900e,0x02002018,0xb2900019,0x5118101a}},	//   _ensin_, _zikir_, _asiat_, _заңға_, 
   {{0x6290201b,0xf2b1d01c,0x8a3e500a,0x2387401d}},	//   _bikar_, _bendova_, _haritası_, _cierto_, 
   {{0x2d5dc01e,0xa2d5501f,0x53f82020,0x03869021}},	//   _북마크하기_, _ratonga_, _pakub_, _nyari_, 
   {{0xf2919022,0x02cb8023,0xf6d2c024,0xdb615025}},	//   _insan_, _berdi_, _ताहिक_, _सनसनी_, 
   {{0xe2fc9026,0x72728027,0x53866028,0x22925029}},	//   _intaneti_, _povedať_, _exora_, _mutati_, 
   {{0xbc67202a,0x6b9a202b,0xf248902c,0x23f9f02d}},	//   _другие_, _ekonomic, _esame_, _butun_, 
   {{0xbceb302e,0xeccea02f,0x7e562030,0x39fe0031}},	//   _मदनमोहन_, _县级以上地方人民, _мартын_, _novament, 
   {{0xf1c92032,0x6e059033,0xd3ebe034,0x70d12035}},	//   _доста_, _kendaraa, _detto_, _この人とブロとも, 
   {{0x627ef036,0x53ebe037,0x0d692038,0xe3a7e039}},	//   _nyingi_, _letto_, _kulturës_, _مجموعی_, 
   {{0xf27ed03a,0xb3eb903b,0x8849b03c,0xcc7d703d}},	// [010] _ocena_, _besta_, _コメント記入欄を, _versija_, 
   {{0x32d9f03e,0x6219e03f,0xaf3a5040,0x8ceba041}},	//   _guten_, _podnikán, _hellenic_, _pestsawg_, 
   {{0xd3eb9042,0x841a6043,0x437b1044,0x48739024}},	//   _desta_, _правилам, _gyfaill_, _बेंगलुरु_, 
   {{0xa200c03b,0x92019045,0x5f914046,0x9e72c047}},	//   _undir_, _ansin_, _phẩm_, _डार्क_, 
   {{0xba53b048,0x67f55049,0x32da904a,0x0e59804b}},	//   _menerima_, _helbestv, _amplify_, _pembinaa, 
   {{0x03ea604c,0xe25a6020,0x0ad2004d,0x2792004e}},	//   _multe_, _mulle_, _gratuite, _gratuiti, 
   {{0x1201801b,0x5dd4e04f,0x6394e050,0xd37f5051}},	//   _kirin_, _verkocht_, _naiste_, _obrazac_, 
   {{0x52240052,0x5c09c053,0xe2918054,0x85e36035}},	//   _olika_, _sempena_, _jiran_, _広告掲載について_, 
   {{0x43eb903b,0x00000000,0x00000000,0x00000000}},	//   _besti_, --, --, --, 
   {{0xa25b9047,0x32245055,0x00000000,0x00000000}},	//   _jesli_, _kelke_, --, --, 
   {{0x15011056,0xfa647050,0xa99c802a,0x52d71057}},	//   _espesyal_, _lääne_, _последст, _murongo_, 
   {{0x62d9f058,0xcd971023,0x54b82059,0xa290e05a}},	//   _zuten_, _salohiya, _लेटेस्ट_, _binada_, 
   {{0xb25a605b,0xa247b004,0x0845c05c,0x83eb905d}},	//   _julle_, _bendruom, _главна_, _festi_, 
   {{0x6325803f,0xf321905e,0xde48205f,0x00000000}},	//   _tiscali_, _risya_, _البطولات_, --, 
   {{0x82018060,0x5e1ba009,0xa8c4e050,0x5d54c061}},	//   _birin_, _kesepaka, _arvestad, _आवागमन_, 
   {{0xd2935062,0x6201c037,0x92912063,0x115d9017}},	//   _가능합니다_, _invia_, _hnyav_, _situatio, 
   {{0x4139e064,0xccf0e065,0x9ec0002b,0x04cbf066}},	// [020] _радиоста, _ملاحظہ_, _nebezpeč, _चदरिया_, 
   {{0xa2905038,0x527ff067,0x42912068,0xc2005038}},	//   _cilat_, _jaunu_, _siyah_, _cilit_, 
   {{0xe60be069,0x995be069,0xea7f406a,0xe68a706b}},	//   _معاہدے_, _معاہدہ_, _barabara_, _презимен, 
   {{0xeebc106c,0xb291806d,0x1048506e,0xfc6c103e}},	//   _aktuelle_, _giran_, _naturaln, _aktuell_, 
   {{0x22f2906f,0xc2d46070,0x9fd60071,0x00000000}},	//   _lleihau_, _berdua_, _pojemnoś, --, 
   {{0xa27ee00e,0x6f64d072,0x73962027,0x03eaf012}},	//   _nainen_, _экспертт, _mursí_, _manter_, 
   {{0x267a9073,0x04ddd074,0xa8229075,0xcf53d076}},	//   _अभिप्राय_, _французы_, _অতঃপর_, _домашни_, 
   {{0xf8a7d077,0x93200078,0x4f946079,0x12d8d07a}},	//   _फोटोफिचर_, _abiye_, _апелулуй_, _breek_, 
   {{0xce35207b,0x53ba107c,0xa230b05f,0x9b60b05f}},	//   _skladova, _виноград, _الآراء_, _الآداب_, 
   {{0xc6e8007d,0xd290107e,0x22919068,0xc2fce07f}},	//   _контроль_, _wahai_, _nisan_, _tengok_, 
   {{0x83eb905c,0x19ba3080,0x82903005,0x0cd7205f}},	//   _vesti_, _privacid, _ramach_, _لعلاج_, 
   {{0x049ea075,0x6a6cc081,0x325ab082,0x2e559083}},	//   _সোশ্যাল_, _abaminis, _çelik_, _katangia, 
   {{0x2201c084,0x0b6ca085,0x00000000,0x00000000}},	//   _envia_, _pantalla_, --, --, 
   {{0xb2909086,0x637fe087,0xf94b7088,0xb3cf7089}},	//   _kijana_, _domača_, _総合ポイント_, _stavio_, 
   {{0x720b608a,0x142b7027,0x225ae08b,0x72d9f08c}},	//   _аппараты_, _podarilo_, _taille_, _lutem_, 
   {{0x8394708d,0x117db08e,0x2efe901e,0x84fc108f}},	//   _mense_, _זיווג_, _이용하시기_, _установк, 
   {{0x22a69090,0xea977091,0x8d30c092,0x891d0035}},	// [030] _životní_, _veličinu_, _vlastnic, _ご利用ガイド_, 
   {{0xb2ecc093,0xc08cc094,0x97a6b095,0xd8b2c02f}},	//   _алмай_, _илова_, _protivni, _查看详细资料_, 
   {{0x427f7096,0x1b597097,0x2b61e003,0x0ff4d098}},	//   _cuando_, _tentunya_, _regluger, _эксплуат, 
   {{0xf8a41099,0xef1f2035,0x15d5909a,0xa290509b}},	//   _प्रश्नोत, _お気に入りに登録, _batangiy, _tilas_, 
   {{0x32cad09c,0x6b117033,0x2321209d,0xf25a909e}},	//   _reeds_, _मंडणगड_, _ysbyty_, _atali_, 
   {{0x32911060,0x6175109f,0x5e6770a0,0x44521072}},	//   _encama_, _pročitaj_, _autorizē, _окшош_, 
   {{0xb368a0a1,0xd39490a2,0xb3eb90a3,0x82ca70a4}},	//   _органдар, _edasi_, _mestu_, _hunde_, 
   {{0xe22490a5,0xd22470a6,0x9b5530a7,0xf2d990a8}},	//   _svaku_, _denke_, _firmalar, _museu_, 
   {{0xa0c5a072,0x729020a9,0xe3f8d0aa,0x07b9e038}},	//   _электр_, _pakai_, _budur_, _komuniki, 
   {{0x82d800ab,0x9ae1d0ac,0xd698102a,0xa9da70ad}},	//   _remonts_, _modelars, _контроля_, _enterije, 
   {{0x307af0ae,0xf30e10af,0x340c60b0,0x37253016}},	//   _besplatn, _arabela_, _ngoặt_, _אנטשולדי, 
   {{0xb2484023,0xf99520b1,0x3e5d40b2,0xb2d9a0b3}},	//   _hamma_, _znakomst, _treballa, _srpen_, 
   {{0x429190b4,0x47876047,0xa28cc05f,0x00000000}},	//   _pisan_, _सर्विस_, _الثمن_, --, 
   {{0x1b38801a,0x262d10b5,0xc2d8f07a,0xdd2b30b6}},	//   _театры_, _лінгвіст, _erger_, _acontece_, 
   {{0x0da770b7,0xb8b740b8,0x72905052,0x42c5c0b9}},	//   _caffeine_, _kostumer_, _bilar_, _deklare_, 
   {{0x629090ba,0xd76c20bb,0xdc16509f,0x850c208f}},	//   _vijana_, _पद्धत_, _sigurnos, _установл, 
   {{0x83e55075,0xaf697033,0xa3cef02a,0x5db4b07f}},	// [040] _চিৎকার_, _वाढदिवस_, _voivat_, _meriwaya, 
   {{0xf3ea90bc,0x23ebe0bd,0xb943f0be,0x526e001c}},	//   _ngata_, _sette_, _počasie_, _tipove_, 
   {{0xaf212032,0x1108d030,0x4c16b071,0xa27eb09f}},	//   _esperien, _абеба_, _ofertę_, _jednim_, 
   {{0xa9e70027,0xdb0c7084,0x8ae1f00f,0x73f96055}},	//   _ospraved, _possible, _kostnade, _liguri_, 
   {{0xb291e098,0x4c6aa0bf,0x22419005,0x97f070b1}},	//   _antaa_, _गुल्मी_, _मनाली_, _yaratilg, 
   {{0x620070b9,0x1e6f903a,0xa50160c0,0xe325701a}},	//   _minis_, _व्यक्तिय, _materjal_, _шектеулі_, 
   {{0x4224906a,0x7b5db0c1,0xf200c0c2,0x52915068}},	//   _mwaka_, _navijačk, _sidik_, _sigara_, 
   {{0x571200c3,0x6e46d0c4,0x5d2e402f,0xf7e730c5}},	//   _החרדית_, _stratega, _承担一切因您的行, _रिचर्ड_, 
   {{0xf2d80046,0x839600c6,0x0c0730c7,0x7591c0c8}},	//   _phien_, _besser_, _partiyas, _입력하세요_, 
   {{0x025a00c9,0x6c56906c,0x23ea009c,0x921390ca}},	//   _buile_, _lettere_, _buite_, _mosha_, 
   {{0xb239f04c,0x127ef0cb,0xf2da7027,0x64a310cc}},	//   _termeni_, _seinem_, _vpredu_, _proyekto_, 
   {{0xf2ecf0cd,0x129030ce,0x39ca30cf,0x425b702d}},	//   _миграция_, _cumann_, _जबर्दस्त_, _ingliz_, 
   {{0x4c5740bc,0x03eb903b,0x23ea60d0,0x386b30b2}},	//   _hostele_, _bestu_, _utoto_, _aconsegu, 
   {{0xf248d084,0xc2d98021,0x90279016,0xf38b9065}},	//   _premi_, _surel_, _טעקעס_, _máris_, 
   {{0x86e710d1,0x995e10d2,0x84862015,0x03f85026}},	//   _circunci, _transmet, _stručnja, _kalua_, 
   {{0x0ab0c0d3,0x7486c00c,0x4c7630d4,0x129110d5}},	//   _संस्कृति_, _निशानी_, _दुल्हन_, _nicaea_, 
   {{0xb7b130a5,0x82d570d6,0x00000000,0x00000000}},	// [050] _izostavi, _seromba_, --, --, 
   {{0xb387f0d7,0x7b5520d8,0xf7cad0d9,0xe29070da}},	//   _nzuri_, _अप्लिकेश, _vanskeli, _hinar_, 
   {{0x5d85d01e,0x5d47d065,0x9e9e30db,0xbb661006}},	//   _카테고리의_, _دراصل_, _erstellt_, _הסטטוס_, 
   {{0x92d9906c,0xebe660dc,0xe3417078,0x6b051047}},	//   _huset_, _cyberpor, _diferan_, _अनुभाग_, 
   {{0xe6a220dd,0x6317c023,0x53a3a0de,0x442aa069}},	//   _институц, _madaniy_, _hoppa_, _ہوسکتا_, 
   {{0xf3f8a07f,0x22e950df,0x6a7ae035,0x427f409e}},	//   _rabun_, _istisqa_, _エグザイル_, _abenda_, 
   {{0x029010e0,0xe2a710e1,0x5e96c069,0xf9cda08b}},	//   _faham_, _часова_, _برسوں_, _interdit, 
   {{0x23eae0e2,0x3e0a40e3,0xe3f960e4,0xe51550e5}},	//   _contoh_, _тропикал, _siguri_, _जल्दिए_, 
   {{0x3265c01a,0x389b2045,0x2c6050de,0x3b0a3088}},	//   _егемен_, _مراسيل_, _platser_, _下記のボタンを押, 
   {{0x9d5f902e,0xbb62a0e6,0x829020a5,0x171da0e7}},	//   _टर्निंग_, _भयानक_, _takav_, _actuació, 
   {{0x8212b032,0xa29040e8,0x7b6c60c4,0x721200e9}},	//   _anche_, _ramai_, _pharetra_, _aniha_, 
   {{0x025b70ea,0x13076053,0x6ab990eb,0x4101f0eb}},	//   _avalia_, _bimbang_, _политике_, _истину_, 
   {{0x727ef0e9,0xa02d6035,0x7f2380ec,0xcab7c0ed}},	//   _ikindi_, _コミュニティ_, _semelhan, _मुखड़ा_, 
   {{0x63f8a068,0x82008086,0x820020ee,0xf36f20ef}},	//   _kabul_, _rahisi_, _dakit_, _hangtot_, 
   {{0x020030f0,0x9c54f0f1,0x00000000,0x00000000}},	//   _kamida_, _prachtig_, --, --, 
   {{0x82902068,0x0250c0f2,0xec6a8071,0x522400f3}},	//   _fakat_, _governem, _systemy_, _klike_, 
   {{0x43f450f4,0x93eaf018,0xa8db902f,0xe2001022}},	// [060] _akutte_, _baitku_, _胶南市城建局_, _sahil_, 
   {{0xb2d02006,0x6fb2b017,0xcae15075,0x79c89069}},	//   _המגזין_, _ויטמינים_, _হেফাজত_, _automata_, 
   {{0x12d800f5,0x00000000,0x00000000,0x00000000}},	//   _thiel_, --, --, --, 
   {{0x598ae09f,0x0291806d,0x234fc0f6,0xf292602d}},	//   _sviđa_, _xirab_, _estekak_, _borada_, 
   {{0x1e54e019,0xbe1590f7,0xfaa9f0f8,0xeb84e02a}},	//   _экономич, _активног, _মুন্সীগঞ, _экологич, 
   {{0xb201105a,0x937f20f9,0xf5a5e0fa,0x46948063}},	//   _bizim_, _астанада_, _niektorý, _cawmseej_, 
   {{0xab9e003a,0xd4ecb03c,0xcbf540fb,0x1c6170fc}},	//   _गुरुवार_, _ファッション_, _espectac, _siguran_, 
   {{0x92cf00f3,0x00000000,0x00000000,0x00000000}},	//   _volonte_, --, --, --, 
   {{0xe3ebe052,0x5883c08b,0x346ed0fd,0xa23fb05c}},	//   _detta_, _您现在的位置_, _храме_, _filmovi_, 
   {{0x8291e0f3,0xb2002060,0x337880fe,0xe5d470ff}},	//   _antan_, _nakim_, _gunakan_, _redaksiy, 
   {{0x93ea9037,0x02020100,0x42786101,0x22494102}},	//   _stato_, _musiqi_, _kurnia_, _vremea_, 
   {{0x4eafb03c,0x93193045,0xfe5230a9,0x5202503d}},	//   _知的財産本部_, _إيجاد_, _dikataka, _notika_, 
   {{0xf2d51103,0xd38c204c,0xe2007104,0x1082802c}},	//   _sellest_, _лутер_, _vinir_, _бенгальс, 
   {{0x0c766105,0x7291c02a,0x89cff106,0x92026107}},	//   _første_, _aivan_, _stretnut, _aktier_, 
   {{0x025a6108,0xf2014109,0x523f810a,0xb157010b}},	//   _sulla_, _breith_, _оставете_, _उपलब्धता_, 
   {{0x26ce310c,0xa2595032,0x92ea70e0,0xac770071}},	//   _detaljni, _particol, _petikan_, _damskie_, 
   {{0xc291c0f3,0x9bccb0b5,0x2236010d,0xefd05004}},	// [070] _vivan_, _studijų_, _ujiji_, _maždaug_, 
   {{0xd2caf0a2,0x1a08910e,0x7f5f307a,0x03f8810f}},	//   _kuidas_, _laharana_, _hospitaa, _hukuka_, 
   {{0x259ca018,0x52918110,0x5f28e07f,0x4347d027}},	//   _ditubuhk, _ziyara_, _cintaila, _balenia_, 
   {{0x42d9f07c,0x89787111,0x125a6112,0x1e5d8113}},	//   _etter_, _velikost, _tulla_, _traballa, 
   {{0xd7c2d085,0xb2cac0c6,0xd290b041,0x2291e0b9}},	//   _বাইরে_, _melden_, _licas_, _mitan_, 
   {{0x952ef06d,0xa1b5c114,0x2b60a115,0x42b60116}},	//   _bernamey, _клиник_, _bayesian_, _muscat_, 
   {{0xc2a6c117,0xaf91f080,0x337950a7,0x3d153118}},	//   _member_, _condenar_, _antalya_, _футболе_, 
   {{0xa3ea0119,0x89c9f11a,0x03f9811b,0xa290c083}},	//   _muita_, _germania_, _guruh_, _kilala_, 
   {{0x960bc108,0x02902110,0xa1c3c11c,0x59a34045}},	//   _вчера_, _arkay_, _полония_, _limistéa, 
   {{0xf3874086,0x52d9211d,0x2200411e,0x3c5b111f}},	//   _sheria_, _quyet_, _mamit_, _zahtjev_, 
   {{0xa584f01e,0xf2ca0037,0x64816120,0xdf7b405f}},	//   _브라우저입니다_, _guida_, _दरवाजा_, _مفاتيح_, 
   {{0xf2cae121,0xf2e1a089,0x5a73a122,0xd9d1a089}},	//   _tindak_, _kolovoz_, _бозгашт_, _kolovoza_, 
   {{0xcc618043,0x08518123,0x637f80f5,0xaa977124}},	//   _sverige_, _sveriges_, _hahaaaa_, _veličina_, 
   {{0x63ebe03b,0x9d560125,0xa927a126,0x817ec008}},	//   _setti_, _लैंगिक_, _шиканҷа_, _тавба_, 
   {{0x29991079,0x04891079,0x568130cf,0x998ec127}},	//   _интерн_, _интерв_, _जिहाद_, _табиб_, 
   {{0xa3ea6128,0xdd260030,0xcd7f5129,0x774a812a}},	//   _multo_, _europene_, _विश्रांत, _спортове_, 
   {{0x22902087,0x6226712b,0x03940109,0xea977089}},	// [080] _zakaj_, _verkar_, _coise_, _veličine_, 
   {{0x920040cb,0x3e70d066,0xd291e01f,0x53eaf003}},	//   _damit_, _गिद्ध_, _hitan_, _vantar_, 
   {{0x82249110,0xf2ca70a9,0x48c7b12c,0x5f5db102}},	//   _mwake_, _sunda_, _मणिपुर_, _raspunde_, 
   {{0x2224909f,0x027ec0b9,0x72a6c06d,0x9e83c0ce}},	//   _svaki_, _anonse_, _hember_, _عائشة_, 
   {{0x83ea712d,0x73f8312e,0x3e0f212f,0x1fa9e0a1}},	//   _xunta_, _simula_, _comentea, _тергеу_, 
   {{0xd21390bc,0x0d5fd130,0x59c170b8,0x92b400c6}},	//   _moshe_, _विक्रमाद, _filefact, _klick_, 
   {{0xa2489131,0x8344a0c3,0x01976098,0x120190ba}},	//   _maama_, _מאַטעריא, _телефоны_, _hisia_, 
   {{0x43866123,0x12918132,0xfa439133,0x8f802134}},	//   _gjort_, _sirah_, _konkrétn, _prochain, 
   {{0xb2d8b135,0x77e79136,0x4f4a404d,0x130ff137}},	//   _madera_, _स्वर्ण_, _personna, _bolesť_, 
   {{0x0a350138,0xf2dfa079,0x4e1c70a5,0xbba31081}},	//   _straitéi, _аместеку, _prekršaj, _imihango_, 
   {{0x71862015,0x526c5139,0xb290f0f0,0x6f6f313a}},	//   _економск, _selon_, _uzgan_, _komandas_, 
   {{0xf6de5038,0x9291d06f,0x5200f13b,0xe233013c}},	//   _futbolli, _siwan_, _dihina_, _kêmtir_, 
   {{0xb291e01f,0x1f9c6035,0x1631a13d,0xe387013e}},	//   _vitan_, _このブログをリン, _economai, _librin_, 
   {{0xf75d9006,0x02b400c6,0x02d1013f,0x815b4119}},	//   _גבינת_, _blick_, _povodom_, _myydään_, 
   {{0x7200b140,0x03f0c072,0x556ff141,0xda00a05f}},	//   _raditi_, _америкад, _posvetio_, _النغمات_, 
   {{0xcc1d3008,0xd2d3d0b4,0x130ff128,0x00000000}},	//   _suratlar, _koropak_, _nahanap_, --, 
   {{0x62249135,0x3724c142,0xd913c0fd,0x3b25b051}},	// [090] _kwake_, _मुखमैथुन_, _пульт_, _priprema_, 
   {{0x1200c038,0x00000000,0x00000000,0x00000000}},	//   _midis_, --, --, --, 
   {{0x551140d1,0x93ea6143,0xbc53b0eb,0x6e959006}},	//   _cobrando_, _grote_, _реализов, _עוררו_, 
   {{0x427f4144,0xa37f311a,0x454f10cc,0xd2cae0ef}},	//   _svensk_, _comanda_, _methamph, _xvideo_, 
   {{0x9b111138,0x1ce05030,0x02b4e11d,0x8c339017}},	//   _الطائف_, _унижений_, _vincom_, _גאליס_, 
   {{0xa37d40fa,0xd9a7a008,0x93800145,0x5cb6a0a9}},	//   _zdravie_, _инқилоби_, _vopred_, _bengkulu_, 
   {{0xf239f146,0xe29040e5,0xc2005128,0x0200c086}},	//   _termini_, _samal_, _galit_, _halisi_, 
   {{0x5ec3a08d,0x69c40050,0x6f47b09f,0x9d3af08b}},	//   _christus_, _moderaat, _državu_, _domicile_, 
   {{0x48d480e6,0xa20ec147,0x800ee148,0x2ff24075}},	//   _चर्चित_, _задан_, _potvrden, _থাকছে_, 
   {{0x5018c149,0x295410c3,0x935f304d,0xe290514a}},	//   _preporuč, _גרופּע_, _origine_, _kalat_, 
   {{0x2236014b,0x712d30fd,0xc27a8035,0xfc66a107}},	//   _dvije_, _шахты_, _氏名又は名称_, _hurtigt_, 
   {{0xc413c14c,0x425ad084,0xa654a01a,0x00000000}},	//   _човека_, _taller_, _бейсенбі_, --, 
   {{0xa25a914d,0x6202714e,0xbc1a1002,0x00000000}},	//   _suala_, _arriti_, _energias, --, 
   {{0x87cd013b,0xb2caf06d,0x20605088,0x9a27f14f}},	//   _wassalam_, _bandor_, _このカテゴリから_, _बाईबिल_, 
   {{0x7e3ff150,0xb34e60df,0x6a65c151,0x4ad8e06c}},	//   _pananamp, _diketuk_, _有难题就提问_, _umiddelb, 
   {{0xf394000e,0xa213e109,0x8c5d20ee,0x151530cd}},	//   _olisi_, _motha_, _bertako_, _нерселер_, 
   {{0xe27e014a,0x229070fd,0x6af7b116,0xe8caa152}},	// [0a0] _aming_, _manau_, _konsumat, _статусе_, 
   {{0x7233000f,0x728e30a5,0x975ab092,0xeaf7b12f}},	//   _exempel_, _svakako_, _सुर्खेत_, _consumat, 
   {{0xb201e153,0x92fc5068,0x92005154,0xd6bad155}},	//   _sitio_, _belge_, _kalim_, _javascri, 
   {{0xe2fc706a,0xc39f3121,0xe3c8f156,0xb0f660fe}},	//   _lengo_, _اصناف_, _форумите_, _menimbul, 
   {{0xf18620a8,0x0d9a3157,0xbb482006,0xf0cce075}},	//   _экономик, _tomonida, _עגבניות_, _হাদীস_, 
   {{0x1940d158,0x25b5e152,0x827f413d,0x6318d159}},	//   _počinje_, _пунктам_, _brenin_, _pabcuam_, 
   {{0xa2486038,0xf992e00f,0xd0a9e076,0x49d41023}},	//   _akoma_, _verklige, _пропуска, _tillarda_, 
   {{0xce627117,0x135f115a,0x32d8c15b,0x00000000}},	//   _practice_, _jongste_, _palesa_, --, 
   {{0xda7b0009,0xa907b15c,0x79425134,0x00000000}},	//   _औरंगाबाद_, _redakteu, _quartier_, --, 
   {{0x2879315d,0xd68c615e,0x437a013b,0x529190fd}},	//   _хавфсизл, _सलवार_, _juragan_, _visai_, 
   {{0xa155209f,0xe683b0e5,0xed88b15f,0xa6b40022}},	//   _mogućnos, _सोनार_, _салоҳият, _abdullay, 
   {{0x98d8c147,0x9f98e0eb,0xfecc5160,0x225a615c}},	//   _сентябр_, _политику_, _papildus_, _bulle_, 
   {{0xd291f161,0x72da509a,0x111c1098,0x9485d111}},	//   _anuas_, _gutera_, _основани, _उत्थान_, 
   {{0x0a835075,0x4c23103c,0x9d2310bd,0x1ae32162}},	//   _স্বেচ্ছা, _mulighed_, _mulighet_, _cuplikan_, 
   {{0x123c6062,0x53e73163,0x3200b081,0xc2fcb164}},	//   _감사합니다_, _måtte_, _padiri_, _odraziti_, 
   {{0x12907022,0xefe9e0a9,0x58c6e165,0x00000000}},	//   _manat_, _बाजारात_, _innehold, --, 
   {{0x425a00d2,0x22639166,0xd4132065,0xb386d167}},	// [0b0] _prill_, _definiti_, _والدہ_, _gjera_, 
   {{0x6c519168,0x368c7169,0x6f38d16a,0x52dc216b}},	//   _taktika_, _तलवार_, _देखिन्छ_, _партнера_, 
   {{0x1c7af16c,0x72e8716d,0x0b0af16e,0xfbd8c098}},	//   _vlasnik_, _higiena_, _vlasnika_, _сначала_, 
   {{0xa26c116f,0xdc80c015,0x5aea814c,0x00000000}},	//   _behov_, _девет_, _trattame, --, 
   {{0x125bf13d,0x92903170,0xd2da5171,0x73949030}},	//   _teulu_, _pajak_, _atrodas_, _clasa_, 
   {{0x90674172,0x31588173,0xfae4f075,0x03ec6174}},	//   _झांसी_, _javouhey_, _উদযাপন_, _pebruari_, 
   {{0x42dab006,0x62da6071,0x9d6a1175,0xd3207010}},	//   _october_, _strefa_, _atomique_, _banyu_, 
   {{0xb2130023,0x4c71200c,0x0a816176,0xb378e0fe}},	//   _shahar_, _बाल्टी_, _impormas, _balasan_, 
   {{0x966d3177,0x43b11178,0x820020e6,0xca0f7179}},	//   _الجسم_, _mecque_, _komise_, _zapadnoe, 
   {{0xee73603a,0xa6b9901a,0xed60b151,0x8394e05f}},	//   _पार्क_, _уәкілетт, _香港紫金碳雕加盟, _paiste_, 
   {{0x8d8e417a,0x425a6076,0xe200501c,0x6c5c6075}},	//   _encontra, _sulle_, _palim_, _সমগ্র_, 
   {{0x37dd3087,0xf395217b,0x00000000,0x00000000}},	//   _obravnav, _kdysi_, --, --, 
   {{0x02d8e17c,0x62fc717d,0xd0dda016,0x6dda9149}},	//   _manera_, _tengo_, _חשובע_, _naglašav, 
   {{0x5e68c17e,0xc355209d,0x8394e088,0xb2ca9006}},	//   _menciona, _calendr_, _uanset_, _trade_, 
   {{0x4f44501a,0xe7d0c0b0,0x62b67072,0xc3f8c132}},	//   _энциклоп, _congdong, _tercer_, _kadua_, 
   {{0xca830052,0xb2e30038,0xfed30038,0xc066d094}},	//   _familjen_, _familje_, _familjes_, _фурӯши_, 
   {{0x8a176050,0xa2902095,0x829030b4,0xc27130c9}},	// [0c0] _हार्डकोर_, _iskaz_, _kamana_, _evangeli_, 
   {{0x2f19817e,0x629040fd,0x620050b1,0x7920f17f}},	//   _располаг, _namai_, _jalik_, _адверсар, 
   {{0x327f717e,0xc2d9f0e6,0x43aa4180,0x3c4cc14c}},	//   _quando_, _autem_, _pravice_, _спортни_, 
   {{0x54866025,0x8e683181,0xf5e07002,0x3ba3d094}},	//   _दोबारा_, _अनुभूति_, _कण्ट्रोल_, _моддаи_, 
   {{0x4290e109,0x77573182,0xd200c06d,0xf29050b4}},	//   _manach_, _негры_, _saliya_, _halah_, 
   {{0xb2903178,0x53167074,0x03f40183,0x6201f184}},	//   _namana_, _экспертн, _gister_, _vizita_, 
   {{0x725a4036,0xba08e098,0xb2468033,0x7c75f185}},	//   _jumla_, _salasana_, _चिखली_, _स्प्रे_, 
   {{0x36313186,0xeedba187,0xaad02121,0x327ff188}},	//   _お問い合わせ_, _těhotens, _برزیل_, _jauns_, 
   {{0x285f0189,0x5224018a,0x949c90a3,0x00000000}},	//   _empresas_, _aliko_, _naročilu_, --, 
   {{0xe1dc2093,0x8ad71116,0x5da7818b,0x83ea918c}},	//   _клубы_, _letterat, _हॉटशॉट्स_, _ngati_, 
   {{0x93f9818d,0x3248918e,0x7290b0f5,0x90b15042}},	//   _turut_, _akama_, _ascas_, _gráfico_, 
   {{0x3c59f170,0x0290e115,0x4cd2b18f,0x2881315d}},	//   _listrik_, _janari_, _पोटेन्शि, _тарғиб_, 
   {{0x839540fa,0xb290e0db,0xe3f45190,0xb7b6500f}},	//   _presne_, _danach_, _nyttig_, _utrustni, 
   {{0xe697506c,0xd3a23070,0xf3f9803d,0xe3805191}},	//   _offentli, _tampak_, _kurus_, _netral_, 
   {{0xcb765084,0x025a60af,0x4dbbf192,0x4da20193}},	//   _declarac, _kgolo_, _argentín, _prensipa, 
   {{0xe30e417d,0x0300510d,0x43ea715c,0x62161017}},	//   _estamos_, _kulaani_, _punte_, _אספנות_, 
   {{0x5bf08174,0x92d800ef,0x801f50f6,0xb04c3194}},	// [0d0] _سیمبیان_, _chieu_, _handiago, _politisk_, 
   {{0xd20ec084,0x52485142,0x420250b2,0x5e923195}},	//   _санаа_, _filmy_, _antiga_, _потреба_, 
   {{0x5f453100,0x09ec4171,0xef2bc075,0xa290e008}},	//   _formalaş, _kabineta_, _কল্পনা_, _sanasi_, 
   {{0x8108a05f,0x22489038,0x00000000,0x00000000}},	//   _مذكرات_, _dhamo_, --, --, 
   {{0x7417c196,0x02d80197,0xb25a6198,0x42da6106}},	//   _kudingek, _okien_, _nulla_, _streda_, 
   {{0x92920199,0x920090bc,0x6242806a,0x92007071}},	//   _strany_, _dikimi_, _soomaali_, _zanim_, 
   {{0xd2d5202b,0x5b55200f,0x82fc70a4,0x6ac1a02f}},	//   _kontakty_, _kontakta_, _penge_, _情节严重的_, 
   {{0xaeea40b1,0x6db3a182,0x2061c07d,0xa2ea719a}},	//   _бағишлан, _negalite_, _стати_, _butiran_, 
   {{0x1291919b,0x9e4ac19c,0x3683207c,0xc3b1c02a}},	//   _nisam_, _статей_, _послуги_, _территор, 
   {{0x36f7819d,0x17ada007,0xa25a619e,0x4179510e}},	//   _परिवहन_, _direttiv, _mulla_, _andininy_, 
   {{0xdf1c9079,0xfc07b028,0x18c53138,0x6dce119f}},	//   _формулат, _khasiat_, _spreagad, _лицей_, 
   {{0xa2d80046,0xb24881a0,0x77bdb1a1,0xd9801092}},	//   _thieu_, _zehmet_, _खड़गपुर_, _भूकम्प_, 
   {{0x32b28119,0xc546c133,0xd700f138,0xdeac1098}},	//   _voidaan_, _zároveň_, _struchtú, _источник, 
   {{0x1b07d043,0x6263105f,0xd3f471a2,0xf3a351a3}},	//   _тиждень_, _تهنئة_, _unutar_, _riepas_, 
   {{0xe7dec041,0x3b192078,0xf290306d,0x620110b9}},	//   _epiphani, _depatman_, _ramana_, _vizit_, 
   {{0x93e5d0e3,0x53ea90e9,0x4dd2d019,0x00000000}},	//   _către_, _itatu_, _стиле_, --, 
   {{0xf92d701e,0xd9c7c17e,0x07b7c1a4,0xa18800a0}},	// [0e0] _자바스크립트를_, _самата_, _самите_, _festivāl, 
   {{0x234c7006,0xe27eb09f,0x329091a5,0xb8b4d008}},	//   _several_, _jednoj_, _mojang_, _вужудга_, 
   {{0xc25a9037,0xadff50fe,0xf6527050,0xf3784005}},	//   _quale_, _pandanga, _बाँधे_, _badania_, 
   {{0x8290c1a6,0x00000000,0x00000000,0x00000000}},	//   _balaga_, --, --, --, 
   {{0x629071a7,0xe3e550c7,0x0c0561a8,0x5147c19f}},	//   _kanak_, _mətni_, _экология, _талибан_, 
   {{0x7b37915d,0xd290212e,0xf3f8f1a9,0xea8cd07f}},	//   _ҳажвия_, _lakas_, _dhiubh_, _sayyidat, 
   {{0x824d71aa,0x73eaf07f,0xc3f9f0a9,0xc2de5100}},	//   _vozforum, _hantar_, _butuh_, _dilində_, 
   {{0x7d297075,0xeaf3509f,0x62caf0b4,0x24f7a19c}},	//   _রাজাকার_, _ugostite, _kandar_, _методики_, 
   {{0xa33a51ab,0xe3f8d173,0xd3ea91ac,0x00000000}},	//   _وردپرس_, _rieux_, _atatu_, --, 
   {{0x2248d1ad,0x569961ae,0xa378e1af,0x085981b0}},	//   _czemu_, _antenimi, _pelakon_, _upozorav, 
   {{0x92d801aa,0xf2da61b1,0x3ceed019,0x7771f0e6}},	//   _thiet_, _berean_, _среди_, _ब्रह्माण, 
   {{0x72ca70b1,0x00000000,0x00000000,0x00000000}},	//   _kunda_, --, --, --, 
   {{0xb2b6a07a,0x2c2431b2,0x5d1b61b3,0x49db61b3}},	//   _verdere_, _फ्रेवुअर, _porodice_, _porodica_, 
   {{0x65b8502f,0x92ca71b4,0x397e21b5,0x625a00b4}},	//   _构成犯罪的_, _munda_, _групе_, _ngilu_, 
   {{0xc73f0098,0x524a61b6,0x727eb1b7,0xcbd4b010}},	//   _оставить_, _ferman_, _niente_, _مناجات_, 
   {{0xf6e7603c,0xc2d89044,0xa212b08b,0x9621313d}},	//   _人が役に立つと評, _chael_, _fiche_, _ewropeai, 
   {{0x627ff102,0xf3a381b8,0xb6be3094,0xb39491b9}},	// [0f0] _spune_, _corpo_, _забонҳои_, _clase_, 
   {{0x03877194,0x329010c2,0x0a5f2049,0x726c205b}},	//   _starte_, _dahar_, _naveroka_, _gekom_, 
   {{0xd201118a,0x89b8e12a,0x82d8807a,0xb2911057}},	//   _kabiri_, _татуиров, _sekere_, _kabari_, 
   {{0xca0f80f5,0xd513c075,0x33203063,0xed27a01a}},	//   _hahahaaa_, _নোয়াখাল, _lwmyam_, _гранты_, 
   {{0x12fc7023,0x7c27b0c3,0xa24a0173,0x2b077003}},	//   _menga_, _נאַציאָנ, _kasmas_, _samskipt, 
   {{0x07ed61ba,0x92019009,0x33ead1bb,0x02fc7162}},	//   _kapanlag, _fisik_, _frete_, _lenga_, 
   {{0xc3a26177,0xb20011bc,0x127f71bd,0x2476b069}},	//   _siopa_, _zahir_, _slanje_, _hirtelen_, 
   {{0xc25a90f4,0x93c2c12a,0xff30202a,0x00000000}},	//   _ngalo_, _оказа_, _редакции_, --, 
   {{0xce48117a,0x3f9b11be,0xa3eb7138,0xb2ca71bf}},	//   _capacida, _हस्तकला_, _reatha_, _gundi_, 
   {{0xf341b1c0,0x62002115,0xb2aad191,0x00000000}},	//   _pokezoo_, _rakit_, _پروتئین_, --, 
   {{0xd1c371c1,0xa6abf033,0x13487016,0x03e651c2}},	//   _postupak_, _सणासुदीच, _מערדער_, _महामंत्र, 
   {{0x01e6b0c5,0x85411138,0xf34fa038,0x02513075}},	//   _टिहरी_, _الذاتية_, _komenti_, _বাচ্চা_, 
   {{0x3ff0110a,0xb31731c3,0x82fc7110,0x022201c4}},	//   _мерки_, _concile_, _denga_, _استفتائا, 
   {{0xe03be0c3,0xb2d831c5,0x489e4019,0x82902128}},	//   _אפיציעלע_, _samedi_, _закладки_, _wakas_, 
   {{0x246131c6,0xd290c08d,0x4642b11a,0x3fae107c}},	//   _америкал, _nadat_, _местоиме, _матки_, 
   {{0xa369c174,0x2c6ad142,0xfb1a011b,0x10513098}},	//   _pinggir_, _किन्तु_, _mutaxass, _истории_, 
   {{0x1290806a,0x6407d128,0x3a8cb0cb,0x00000000}},	// [100] _jakaya_, _tulungan_, _springen_, --, 
   {{0xf3f8d0b9,0xb60cd1c7,0x6f73a024,0xb290e0c2}},	//   _abouti_, _avtomati, _समर्थकों_, _kunaon_, 
   {{0x825b70cc,0xe3dcd173,0x62cae1c8,0xe2fc7121}},	//   _italya_, _brower_, _mendon_, _bengi_, 
   {{0xf2cad07a,0x52bca010,0xb6d241c9,0x1212d05e}},	//   _vrede_, _jendral_, _morgannw, _zhohir_, 
   {{0xe3f471ca,0x827e6063,0xc5d991cb,0xd82ac008}},	//   _nostra_, _hmong_, _инверс_, _арабисто, 
   {{0x13ead0f3,0x125a91bc,0x4e7141cc,0xbf5cf1b7}},	//   _trete_, _kuala_, _अगस्ट_, _компютър, 
   {{0xc29551cd,0x0291c039,0x00000000,0x00000000}},	//   _probleem, _divat_, --, --, 
   {{0xc3ea61b2,0xa2ca90a6,0x62e970e2,0xe3ea90db}},	//   _proto_, _stadt_, _dirinya_, _statt_, 
   {{0xa29021ce,0x027ee071,0x1307f0d5,0x569da050}},	//   _zakar_, _opinia_, _hhaahah_, _direktii, 
   {{0xaf3cb05e,0xbf282084,0xf27e61cf,0x1638e098}},	//   _kesusaha, _expressa, _omong_, _perintei, 
   {{0x12915115,0x4f5f50b0,0x26fd6092,0xfa15106e}},	//   _sigana_, _uppppppp, _nakupová, _redakcja_, 
   {{0x71772031,0x65be217e,0x927e61d0,0xc26c51d1}},	//   _место_, _друго_, _imong_, _celou_, 
   {{0x63f431d2,0xf2fc9109,0x3e83d069,0x2f4481d3}},	//   _posté_, _beaga_, _مارشل_, _constaba, 
   {{0xa3442158,0x0fac6138,0xa5507037,0xec90a0a2}},	//   _prodaju_, _مغامرات_, _società_, _क्षोभ_, 
   {{0x4212b023,0x78a3e035,0xb7c61033,0x7869b0b2}},	//   _ancha_, _メロディアス_, _हळूहळू_, _династия, 
   {{0x6290c140,0xa236d1c5,0x82ca7050,0x32fd60b4}},	//   _nadam_, _projet_, _tundi_, _angger_, 
   {{0x7356d121,0xecbcd108,0x3eb721d4,0x62904115}},	// [110] _مرحله_, _участие_, _consulte_, _camat_, 
   {{0x05df40cd,0xa9398092,0x336e906e,0x629271d5}},	//   _telenotí, _prohlédn, _पक्षियों_, _rosato_, 
   {{0xc1eb10dd,0xfc18f0f1,0xc26c409f,0xde461016}},	//   _европе_, _verander, _nemoj_, _עיפריל_, 
   {{0xff3ca1d6,0x629021d7,0xde71b129,0x11214164}},	//   _perusaha, _vakar_, _टुर्स_, _grožđa_, 
   {{0xeff79016,0x122470af,0x5c6911d8,0xc249819e}},	//   _מעניו_, _sonke_, _cerrado_, _varma_, 
   {{0x32fc714d,0xf843301e,0xb2020086,0xa626101e}},	//   _wengi_, _되었습니다_, _kusini_, _미디어다음_, 
   {{0x9326d075,0xf20040a9,0x4bb1217a,0xe2e861d9}},	//   _অপটিমাইজ, _kamis_, _conjunto_, _airfon_, 
   {{0x701d10ab,0xd0ae1006,0xf290c0ab,0x125b10f3}},	//   _nacionāl, _מוציאות_, _gadam_, _biblik_, 
   {{0x60708075,0xda3c3126,0x03ea01da,0x95962127}},	//   _একুশে_, _дучор_, _aritu_, _дилшод_, 
   {{0x13ea71db,0x6dc20048,0xd2ca70f6,0xfa94c065}},	//   _muntu_, _meningka, _mundu_, _háztartá, 
   {{0x8386e1dc,0xdda2400e,0xa2fd3146,0x8c61615a}},	//   _shirin_, _kirosana, _pilastri_, _gestuur_, 
   {{0x19bf0035,0x23e8617e,0x6a8a4072,0x2290317d}},	//   _に選ばれた回答_, _decoraçã, _барактык, _bajar_, 
   {{0x929040f6,0xbec761bc,0x63eb9005,0x9d265095}},	//   _hamar_, _menyerta, _testy_, _istočne_, 
   {{0x020ed023,0x3c6161dd,0x00000000,0x00000000}},	//   _қадар_, _bestuur_, --, --, 
   {{0x91f9d079,0x625a6043,0xa354b062,0xeae2f1b5}},	//   _министра, _fullt_, _terecht_, _umetnost, 
   {{0x02d8c17e,0x3175a016,0x9301f04b,0x2c2cf069}},	//   _menores_, _מוקצה_, _perangi_, _bruttó_, 
   {{0xd7b6105d,0x9956a06c,0x1291514d,0x0ccf802f}},	// [120] _trasferi, _millione, _nafasi_, _如要投诉或提出意, 
   {{0x63f470a8,0x52905083,0x00000000,0x00000000}},	//   _vostra_, _balat_, --, --, 
   {{0x1ab6a02f,0x85418075,0x7fad7126,0x17aa8011}},	//   _添加到搜藏_, _সাংস্কৃত, _дархости_, _kastosli, 
   {{0x411b61de,0x82d8b14c,0xc667902a,0x426c5175}},	//   _سرپرستی_, _vedere_, _наверх_, _celom_, 
   {{0xd290e02d,0x0e507023,0x82905038,0x6983d1df}},	//   _yanada_, _masalala, _falas_, _модерна_, 
   {{0xc29041d6,0x5166008e,0x0e4ca170,0x51001006}},	//   _kamar_, _חילוקי_, _pelayana, _רמקולים_, 
   {{0x6c4b11e0,0x813e70fa,0x13949006,0x3ae54081}},	//   _tentang_, _svietidl, _flash_, _itsembab, 
   {{0xa290504a,0xe2eb207d,0x3da47092,0x7378c033}},	//   _halas_, _abonner_, _nesouhla, _kemaren_, 
   {{0x52925095,0x0119205c,0xb200914d,0x806e91ad}},	//   _litara_, _технике_, _majina_, _klasyczn, 
   {{0x5af73094,0x42786110,0x1200c1e1,0xbf2c6015}},	//   _далели_, _chunga_, _miliki_, _bijeljin, 
   {{0xf23b70ce,0x82005004,0x62e97196,0x82d5902f}},	//   _nollaig_, _dalis_, _sisinya_, _凡本网注明_, 
   {{0x2edc51c6,0xf61f41e2,0xb5241093,0x99d221e3}},	//   _racistes_, _exposici, _әңгіме_, _erregist, 
   {{0x774ed1cb,0x02d6f1e4,0x69c100dc,0x226cf1c6}},	//   _граве_, _achlais_, _capegate, _segon_, 
   {{0x5200c1e5,0x82d841e6,0x5290400c,0x42903128}},	//   _kaliya_, _ahmet_, _samas_, _kumain_, 
   {{0x7e4de01e,0x025a9037,0x1b9a2179,0xced6d1e7}},	//   _대학보고서_, _quali_, _ispisano_, _regierun, 
   {{0xe2fe61c6,0x5200d07a,0x5290507f,0xcc55b140}},	//   _visites_, _koning_, _ralat_, _pratite_, 
   {{0x42905018,0xb386d13e,0xd2cae0db,0xc291e048}},	// [130] _balas_, _njeri_, _beiden_, _hitam_, 
   {{0x7394711e,0x4affa1b0,0x735ca1e8,0xf31be1e9}},	//   _konsa_, _zabranje, _партнери_, _дозволяє, 
   {{0x75a8801a,0x73eae1ea,0x143ec019,0xe2d8d032}},	//   _марапатт, _tenten_, _равно_, _genere_, 
   {{0x36d711eb,0x75ea3003,0x72905012,0x9f4f007a}},	//   _descobri, _heiminum_, _falar_, _spesiale_, 
   {{0x820050c4,0x7290806a,0xe27e9033,0x31b34075}},	//   _talis_, _makala_, _emang_, _রাশেদ_, 
   {{0x1c764172,0x4a93d079,0x4290f083,0x13077109}},	//   _बॉम्बे_, _фонетик_, _dagat_, _aghaigh_, 
   {{0xa7c520c3,0x699880a5,0xbbcfd0a9,0xdc49d035}},	//   _אנטיסעמי, _lakše_, _श्रीराम_, _みんなへの一言_, 
   {{0x8290806a,0x5426d047,0x726e71ec,0x9dc200fe}},	//   _nakala_, _archiwiz, _masomo_, _peningka, 
   {{0x925ac1ed,0x7379a049,0x0290802a,0x63eaf04d}},	//   _mellan_, _dizanin_, _takana_, _faites_, 
   {{0xe20270b8,0x527f7110,0x19cd30e8,0x5113f17c}},	//   _bisita_, _mpanda_, _seumpama_, _мухаммед_, 
   {{0x41351005,0x04551168,0x742921ce,0x1e951188}},	//   _produkty_, _produkto_, _tempatan_, _produkts_, 
   {{0xac3201c7,0x5263c024,0xc200b087,0x9383a118}},	//   _kombinir, _आरुषि_, _bodite_, _sutrikim, 
   {{0xb291e071,0xe85571ee,0x724a70b4,0x82ca0045}},	//   _witam_, _rendkívü, _saumur_, _faide_, 
   {{0x8ff9702e,0x22cae0db,0x22a77152,0x3a01201f}},	//   _विलायती_, _senden_, _ансамбля_, _mahagaga_, 
   {{0x56e8e015,0xb5d5a0b7,0xa3f9f0c2,0x63a5a1ef}},	//   _манастир, _garantiy, _tutut_, _garantij, 
   {{0x137950b4,0x2ffc1006,0x33eae0cb,0xcf358003}},	//   _mudahan_, _שפורסמו_, _seiten_, _meistara, 
   {{0xedbd11f0,0x03ea00bc,0xeae64032,0xe5ebf079}},	// [140] _दुर्योधन, _esita_, _strument, _докторат, 
   {{0x7b51c1f1,0x2db7d1f2,0x80b80006,0x93b5e07b}},	//   _територі, _activida, _התעופה_, _cloveka_, 
   {{0x18b6b08b,0x92fca1f3,0x67eee035,0xbc3ba1f4}},	//   _partager_, _medidas_, _ブログトップ_, _उत्साहित_, 
   {{0x222b41f5,0x52905052,0x7daa7100,0x00000000}},	//   _zoradiť_, _talar_, _sistemlə, --, 
   {{0xc394d087,0x7f5751f6,0xaabdc14c,0x5be5b004}},	//   _prosim_, _जिनगी_, _кабинета_, _kalendor, 
   {{0xd882d075,0x966d3191,0x7771c1f7,0x743c20f8}},	//   _বাড়ছে_, _الکسا_, _व्याभिचा, _তামিম_, 
   {{0xc3e360ed,0xc2d81052,0x0ea6b05f,0x0290703d}},	//   _सत्येन्द, _nyhet_, _مانشستر_, _manas_, 
   {{0x8e17702f,0x536f2173,0x0386906c,0x030cf0ab}},	//   _中华人民共和国商, _mongkut_, _svare_, _nevarat_, 
   {{0xa387f057,0x0a901136,0xa47690eb,0x1290c06a}},	//   _ukuri_, _मधुमेह_, _процеса_, _madai_, 
   {{0x5a0bf1f8,0x16816136,0x734971f9,0x329261fa}},	//   _אפֿשר_, _ज्ञात_, _handray_, _kirara_, 
   {{0xbbe53004,0xb20110c2,0xd2d9f1fb,0x41290015}},	//   _aksesuar, _kacida_, _muter_, _доступан_, 
   {{0x8290f0fd,0x926c700f,0x833010e6,0x030e51fc}},	//   _pagal_, _genom_, _व्याख्या_, _trebala_, 
   {{0x5d8f5176,0xf6645050,0xcf1b208f,0x72bf3039}},	//   _kailanga, _miljardi, _украине_, _لمحات_, 
   {{0x737b807f,0x29e23182,0x1395907c,0x4200c095}},	//   _semalam_, _istorija_, _desse_, _volite_, 
   {{0x7290709f,0x469a203a,0x03eb908b,0x06c8a0c8}},	//   _danas_, _chomikuj_, _juste_, _반송비용은_, 
   {{0xec0781fd,0xc30c21d8,0x02ade108,0x829081fe}},	//   _oneshot_, _semanas_, _всъщност_, _hakaba_, 
   {{0x700d8180,0xff9a31ff,0x02498200,0x32917100}},	// [150] _življenj, _भक्तिमय_, _varme_, _rabitə_, 
   {{0xeae53201,0x70f78172,0x26af30b5,0xf8281006}},	//   _siguient, _मद्रास_, _ісуса_, _התיכון_, 
   {{0x53f890bc,0x17108072,0x538d1170,0x8290c13b}},	//   _bakuli_, _империяс, _properti_, _kalana_, 
   {{0x9127c147,0x1bd120b5,0x7fa73202,0xae729047}},	//   _навори_, _klientų_, _aumentar_, _युद्घ_, 
   {{0x729070a7,0xa85d9203,0x1290c0f2,0xd141e024}},	//   _sanat_, _רשעים_, _dalana_, _पाएंगे_, 
   {{0xf20180f3,0x03738095,0xb7b6b075,0x693a01dc}},	//   _diris_, _zadatke_, _বিকেলে_, _харажатл, 
   {{0x6d5a6138,0x125a61b1,0xde17c204,0x00000000}},	//   _leathnú_, _urola_, _nimenoma, --, 
   {{0xc37ca09f,0x82fcd173,0xc477a098,0xecf50148}},	//   _pitanje_, _langid_, _проекта_, _ostatným, 
   {{0xd06c802f,0x83ea0045,0x2ee3d0cf,0xf461d01e}},	//   _第二十四条_, _frith_, _पृथ्वीरा, _medewerk, 
   {{0x62b52205,0x1fe7b019,0xdc6970f3,0xd29191a7}},	//   _prodeje_, _править_, _zantray_, _risau_, 
   {{0x1b551206,0x1200c131,0xeb8ac0b1,0xd2924053}},	//   _kinderen_, _balina_, _холос_, _nawawi_, 
   {{0x075f0071,0x78c4e053,0xdc4b1115,0xec1930f6}},	//   _जिन्हें_, _dikehend, _genteng_, _gainditu_, 
   {{0xd20e10bd,0xc290708c,0x8a502121,0xa2b4e1a7}},	//   _зараз_, _janar_, _خلاقانه_, _kancil_, 
   {{0x114630ed,0x6b78b0a8,0x8378e207,0x121bb0e6}},	//   _नालंदा_, _партияла, _silakan_, _austráli, 
   {{0x925a2208,0xe3167170,0xdd8da03f,0xee516004}},	//   _dakle_, _pribadi_, _televize_, _patarima, 
   {{0xbc651209,0x01f9701e,0xae9510b2,0xe575120a}},	//   _contact_, _스크랩하기_, _contacte_, _contacto_, 
   {{0x2290809a,0xe3ea2038,0x777c50f9,0x97ece191}},	// [160] _bakaba_, _fakte_, _лауреаты_, _pekarang, 
   {{0xc4fdb1b7,0xfbc8c1b2,0xd2a6520b,0x863f320c}},	//   _позволяв, _कालीकोट_, _seljaci_, _podijeli, 
   {{0x8d198019,0x32fe6177,0x12d9a09d,0xca9730c6}},	//   _различны, _airgid_, _capel_, _zumindes, 
   {{0x629071d9,0xe64140c5,0xa3b601ed,0x00000000}},	//   _sanas_, _हड्डी_, _gravida_, --, 
   {{0xf387f081,0xc7df1136,0x85a79075,0x12d9c05f}},	//   _nkuru_, _छुटकारा_, _বুঝলাম_, _naven_, 
   {{0x837c70f1,0x12018078,0x2e3bc1e9,0x7b2ac1df}},	//   _locatie_, _viris_, _основног, _основнот, 
   {{0xd3209086,0xe20180ba,0xd2240164,0xd7cae02a}},	//   _mbaya_, _muziki_, _sliku_, _opiskeli, 
   {{0xa29120b4,0xa1c64027,0x2a143182,0xc29240bc}},	//   _hayam_, _otvorená_, _negalima_, _fetang_, 
   {{0x83ea020d,0x2febb18b,0x72cad008,0x1f86505f}},	//   _eriti_, _menyenan, _xuddi_, _لاجهزة_, 
   {{0x22ca9100,0x0b5ed20e,0xf2d990db,0xae50006a}},	//   _orada_, _храна_, _essen_, _mahakama, 
   {{0xa3eb720f,0xa2ca9164,0xea5390c1,0x720190ff}},	//   _beatha_, _grada_, _kolegama_, _misir_, 
   {{0x5752d006,0x4fa9303c,0x63e90210,0x2ad0f04d}},	//   _קייטרינג_, _インテリア_, _эритроци, _pratique, 
   {{0x5b3e3006,0x84d7e19f,0x83ea9211,0x42ca9082}},	//   _אוזניות_, _барады_, _arata_, _arada_, 
   {{0xb2cf81aa,0x4cf50148,0xfdf5002b,0xddd2709f}},	//   _afamily_, _ostatnýc, _ostatníc, _utakmice_, 
   {{0xd641c14c,0xf636a03f,0x82a88075,0x3200c212}},	//   _втора_, _त्यहाँ_, _উবুন্টু_, _talina_, 
   {{0x42026110,0x62d9f1f2,0x9f1e315c,0xea5be128}},	//   _siriya_, _usted_, _handelin, _pangarap_, 
   {{0x9290b086,0x5ba670c5,0xa8a3c07d,0xd3575213}},	// [170] _badala_, _व्यतीत_, _команд_, _कल्ले_, 
   {{0xc68e1006,0x92e990a7,0x0f6911a7,0x9953201a}},	//   _שוקולד_, _haziran_, _sepatutn, _тығыз_, 
   {{0xc4e3e075,0x4310e214,0xb7b5f0a6,0x22ba7215}},	//   _পোশাক_, _detaily_, _startsei, _kendini_, 
   {{0xf29190ab,0x73ead1f5,0x65278140,0x629241a7}},	//   _visas_, _preto_, _napravio_, _petang_, 
   {{0x996e7216,0x8d6b408c,0x00000000,0x00000000}},	//   _donnerst, _martesë_, --, --, 
   {{0xcd90c1a8,0xa2d6c004,0x7637607d,0xc3449134}},	//   _кейде_, _stilius_, _властиво, _vitesse_, 
   {{0x8c683034,0x42eab217,0xe2d9e0f1,0x02ca708b}},	//   _доставка_, _prensas_, _laten_, _lundi_, 
   {{0xa168b218,0xf3bff219,0x0395421a,0x919b4052}},	//   _програму, _midwife_, _nyeste_, _speciell, 
   {{0x8cf2c045,0xe2e820de,0x9290106f,0xb7ff9006}},	//   _فاطمة_, _sociala_, _uchaf_, _ומידע_, 
   {{0x22d870bf,0x1394e19e,0xb20ec084,0x00000000}},	//   _oknem_, _toista_, _кадам_, --, 
   {{0x52018021,0xc386c09c,0xf394d029,0xfdf8b01e}},	//   _mirip_, _storie_, _alesi_, _빌라연립다세대_, 
   {{0x09a41015,0xfac8121b,0xc37a712e,0xfb0d712f}},	//   _април_, _dozvolje, _katawan_, _cumparat, 
   {{0x92cae1c8,0x92fc706a,0xec7e9150,0x59dcd0dd}},	//   _vendin_, _mengi_, _apostol_, _последиц, 
   {{0xf2bb9173,0x62d9e21c,0x72b470e6,0x82fc7003}},	//   _sagesse_, _daten_, _konce_, _lengi_, 
   {{0x1859717a,0xd34a909f,0x3e2f021d,0x63aa121e}},	//   _retratos_, _između_, _células_, _vlasništ, 
   {{0x42cad07b,0xf386d037,0xa47ac043,0xd170421f}},	//   _vtedy_, _avere_, _промисло, _مشتقات_, 
   {{0x329011ae,0xf4d770c3,0xd290c131,0x00000000}},	// [180] _mahay_, _אנציקלאפ, _balala_, --, 
   {{0x72489110,0x7fc23220,0x1e57d069,0x728c205f}},	//   _nyama_, _ناموس_, _کرپشن_, _القمة_, 
   {{0x5c6e302f,0xe291900f,0xd2fcd1a5,0xad98e15d}},	//   _我来说两句_, _visar_, _mangle_, _yaponiya, 
   {{0x42d9e0f6,0x72905221,0x42786081,0x26c6f0b4}},	//   _baten_, _eblas_, _ubundi_, _kapanggi, 
   {{0xd6b75024,0x549c90a3,0x0093c039,0x12019083}},	//   _obserwow, _naročila_, _عطارد_, _iisip_, 
   {{0xf2366087,0xd394e204,0x512d217e,0xe2b54087}},	//   _svojo_, _poista_, _расте_, _precej_, 
   {{0xb291a1c8,0x82901150,0x02d9e083,0x6da1b006}},	//   _sipas_, _bahay_, _mateo_, _principa, 
   {{0xbb4690e1,0xf47370dd,0x22918222,0xf3f1b0b8}},	//   _privatna_, _partizan_, _garai_, _layering_, 
   {{0x6b7d3170,0x67b44223,0x0d86f035,0x628d609d}},	//   _terutama_, _механико, _明日の日経平均を, _archebu_, 
   {{0xf1539098,0xad445019,0xf16960fe,0xaaf5e017}},	//   _модель_, _уникальн, _perintah_, _attribut, 
   {{0x5e525048,0xb3f4002b,0x816350c3,0x6a6040e5}},	//   _sedangka, _postup_, _רעפערענצ, _koolitus, 
   {{0xedb9711a,0xe290a121,0xf580d1ad,0x425a00f6}},	//   _califica, _babar_, _matematy, _saila_, 
   {{0xa2fe51ed,0x243930c8,0x43dc60af,0x00000000}},	//   _inrikes_, _인천광역시_, _utlwa_, --, 
   {{0xb2e680a6,0xe317a13d,0x1a82c030,0x7292617c}},	//   _bringen_, _merched_, _алуминиу_, _mirada_, 
   {{0xd217d12b,0x42d8d06f,0x88f42102,0x00000000}},	//   _прогноз_, _teledu_, _алтфел_, --, 
   {{0x49c7c0a1,0x9197c094,0x52ab1053,0x72241065}},	//   _замана_, _замоне_, _gendang_, _leginkáb, 
   {{0xbbf451ad,0x23790046,0xdecdc171,0x92fdc092}},	// [190] _akceptac, _megafun_, _ministrs_, _ministr_, 
   {{0x53eb9224,0x226d8225,0xc52de02a,0xe290b1ea}},	//   _cesty_, _meron_, _позволяе, _frekans_, 
   {{0xc2d9e215,0x2290e0f2,0xc29271ba,0x729260fb}},	//   _zaten_, _tanana_, _gesang_, _usuari_, 
   {{0x026cd226,0x31b02069,0xa772f033,0xf847d122}},	//   _manome_, _پچھلا_, _प्राण्या, _задании_, 
   {{0xa25a5037,0xfd86b084,0x68361006,0x0a93d227}},	//   _dalle_, _setembre_, _מסמכים_, _музиката_, 
   {{0x163f01f5,0x704dc1f1,0xb37a607f,0x7200c0fe}},	//   _komentár_, _проти_, _lawatan_, _gadis_, 
   {{0xc3940161,0xb3b4c004,0xc3bb21f2,0x120ec076}},	//   _poist_, _pasaulyj, _través_, _пазар_, 
   {{0x3c5c107a,0x3291b0b7,0x3af22228,0xbc323008}},	//   _bestaan_, _movado_, _imoralit, _шўртан_, 
   {{0x9290c02b,0xf53b102f,0xf2fc6229,0x22c1d1c7}},	//   _zadat_, _内容读取中_, _stoga_, _okolica_, 
   {{0x01b6405d,0xd38720ff,0xd45ec0a5,0x5290f027}},	//   _permessi_, _idarə_, _pružaju_, _oznamy_, 
   {{0xe241d17e,0x494e922a,0x9bf6b0c5,0xaea4c11a}},	//   _дестинац, _učlanjen, _बर्खास्त_, _алергам_, 
   {{0xfc801084,0x52ec622b,0x00000000,0x00000000}},	//   _берем_, _febroary_, --, --, 
   {{0xe04410c3,0x22c5a109,0x71cd31eb,0x29e76017}},	//   _פרידמאן_, _bremner_, _ашуун_, _performe, 
   {{0xf291c171,0x0d787046,0xec7ea05d,0x5387404d}},	//   _divas_, _quăng_, _kunsill_, _guerre_, 
   {{0xf2fc9060,0x5225f0f6,0x7907c0ce,0x7200c1e0}},	//   _dengê_, _eduki_, _تعتبر_, _hadir_, 
   {{0x1eb14155,0x63f1422c,0x730e6035,0x557740f6}},	//   _importan, _importaz, _悩みを聞いて_, _instalaz, 
   {{0x5cdae0fa,0x4305b1b6,0x42cad13a,0x7586f194}},	// [1a0] _katalóg_, _kesekî_, _valdes_, _overrask, 
   {{0xf39540de,0x8386906a,0x49e81017,0xbc361017}},	//   _flesta_, _idara_, _העירייה_, _לשיקולי_, 
   {{0x6290f0af,0x9fe08170,0xb26c422d,0x6248d22e}},	//   _mahala_, _संयुक्ता_, _temos_, _maombi_, 
   {{0x99ecc02f,0x9f5bf140,0xe2df9180,0xf3eb714c}},	//   _魔兽野怪介绍_, _ponašanj, _nogomet_, _tratta_, 
   {{0x95f2e02f,0xde1ac22f,0xd969517a,0x36839119}},	//   _获取免费代码_, _diberika, _similare, _войдите_, 
   {{0x330d21ce,0x8aca4099,0x3c9e0017,0x62da7199}},	//   _pelayar_, _warmińsk, _כוסיות_, _musela_, 
   {{0xac6c5230,0x9290a1de,0xcfffd04c,0xa2c1c01c}},	//   _dakujem_, _abban_, _аджария_, _stolova_, 
   {{0x08abd062,0x1e916006,0x43ea600f,0x1b8901f9}},	//   _자기소개서_, _abstract_, _trots_, _misioner, 
   {{0xe9e3722c,0x23fa6160,0xa1296231,0x12637232}},	//   _limitata_, _datums_, _štvorkol, _limitati_, 
   {{0x1d6c10cd,0xc290b033,0x39873075,0x617880eb}},	//   _партиясы_, _pacar_, _সমিতির_, _контроле_, 
   {{0x2290c1d9,0x8225f206,0xd2344173,0x2b238016}},	//   _eadar_, _leuke_, _khammee_, _קאַמף_, 
   {{0x8bd6a01e,0x029270fd,0x027f7043,0x00000000}},	//   _광고제휴문의_, _visada_, _spania_, --, 
   {{0xa3dc91cf,0xa9896046,0xbd295041,0xd3f10191}},	//   _atawa_, _chính_, _antipope_, _magelang_, 
   {{0x0f391092,0x90105121,0x32da000a,0x2291f233}},	//   _milionů_, _خلاقیت_, _liseli_, _nhuan_, 
   {{0x43c05234,0xf3ea904d,0x32ea10ff,0x95658235}},	//   _प्रस्तुत_, _santé_, _birinin_, _privukao_, 
   {{0x83cf5236,0x9213e0d0,0xdff9a0a9,0x34efd0c8}},	//   _elever_, _dothi_, _स्मारके_, _관련사이트_, 
   {{0x32ca70b9,0x93eb921c,0x14ba4187,0x13eb1040}},	// [1b0] _mande_, _erste_, _प्रेषित_, _pectin_, 
   {{0x0201e030,0x368e2151,0x00000000,0x00000000}},	//   _citit_, _查看该会员企业网, --, --, 
   {{0x0225903b,0x73ff022c,0x9682400c,0x00000000}},	//   _elska_, _sproporz, _भुलाई_, --, 
   {{0x314540cf,0x2c1db1b1,0x161180be,0x99482071}},	//   _अहिंसा_, _ullamcor, _klientom_, _सांसदों_, 
   {{0x9ac8f0b1,0xc22ac17e,0x37cf9019,0x2291a0b9}},	//   _маслаҳат, _добар_, _varsinki, _espas_, 
   {{0x5ef3120d,0x01dcb098,0x3ee480a1,0x67ccb01e}},	//   _अधिका_, _картинки_, _автоматт, _노튼주니어_, 
   {{0x73f13169,0x73a4121b,0x32250010,0x7f641004}},	//   _श्रीदेवी_, _finansij, _ngakak_, _finansin, 
   {{0x5291e237,0xb355a102,0xf30e5004,0x9395f15c}},	//   _kitas_, _супорт_, _paramos_, _keuse_, 
   {{0xd38ba098,0x87e0c033,0xb29ec147,0x834aa191}},	//   _станет_, _सावरकर_, _дидан_, _پروجکشن_, 
   {{0xced1601e,0xb2b470b3,0x1e396052,0x02b4911d}},	//   _상품가치가_, _konci_, _relatera, _hoach_, 
   {{0xf843e238,0xbc53e239,0xe291d1ce,0x63a2d23a}},	//   _últimos_, _último_, _diwar_, _eropah_, 
   {{0xd1e2b098,0x1b7be0b4,0xa290319e,0x720ec031}},	//   _техничес, _pangeran_, _samaan_, _давал_, 
   {{0xaf5bb23b,0xfc4460b2,0xfa017104,0x12912041}},	//   _jonathan, _serveis_, _allavega_, _obyam_, 
   {{0x5f02d23c,0x9d85e0f4,0xe2ca709c,0x43eb8182}},	//   _सिद्दीकी_, _makerere_, _hande_, _turto_, 
   {{0x23f8c0a5,0x336be048,0x1efe6004,0xdbffb23a}},	//   _odluke_, _lengkap_, _elektros_, _pengajar, 
   {{0xe291e022,0x43ea71fd,0x573ad23d,0xd8c210c8}},	//   _sitat_, _puntu_, _мозгу_, _자세히보기_, 
   {{0x8317406d,0xd291e03d,0xe290c0b1,0x726c50d1}},	// [1c0] _derbarê_, _citas_, _qadar_, _pelos_, 
   {{0x7201e109,0x9561d112,0x73ea321b,0x626c7042}},	//   _litir_, _mielestä, _sajta_, _nenos_, 
   {{0xcb865095,0xad265095,0x72e37155,0xa1ec101c}},	//   _dovoljno_, _dovoljne_, _believe_, _najgorih_, 
   {{0x3ea18062,0xe6889157,0x2b358098,0x04b301de}},	//   _부동산써브_, _гипермар, _tavallis, _jellegű_, 
   {{0x73eb9154,0x32010128,0x82cad06b,0xc290f039}},	//   _gusto_, _kabila_, _sreda_, _magas_, 
   {{0xc25a0138,0x1200c0aa,0xf2020193,0xd3a240e2}},	//   _gaile_, _sadiq_, _depite_, _mimpi_, 
   {{0x526c7189,0x2316023e,0x541d707a,0xc6cb904c}},	//   _menos_, _ndizo_, _verstaan_, _оказия_, 
   {{0xf3a4223f,0x42cb8190,0xce542006,0x2486e0c5}},	//   _financij, _burde_, _financia, _प्राप्_, 
   {{0x5290e0f2,0xeeb4e1c6,0xe2903240,0x1b5b7166}},	//   _asiana_, _diverses_, _komast_, _komunita_, 
   {{0xe2cfc03f,0xf9ae7069,0xa290d0db,0x1ad300b3}},	//   _kancelář, _چیزیں_, _monate_, _dostanet, 
   {{0xe57521f3,0x42d9f039,0x9c07b1c9,0x0e679165}},	//   _contrato_, _isten_, _cyrsiau_, _redaktør_, 
   {{0xba7b2241,0x52901242,0xf29031a7,0x59787103}},	//   _prošle_, _nchai_, _kilang_, _valimist, 
   {{0x526a1243,0x45a9003f,0x3982801a,0x625a91a6}},	//   _заборави, _formulář_, _докторы_, _asala_, 
   {{0x50d10138,0x4ea7c023,0x8317b06b,0x92d951b6}},	//   _الأغاني_, _тараққиё, _тренера_, _vegere_, 
   {{0xc2aa80b2,0x627e9225,0x84080138,0xf0ce20b8}},	//   _министрл, _umano_, _اونلاين_, _ribonucl, 
   {{0xd24941b9,0xbe5631f1,0x42a6c12e,0x20f5216a}},	//   _tiempo_, _частина_, _bilbil_, _अप्रिल_, 
   {{0x1d3d3092,0xfa000027,0xc26cb1c9,0x00000000}},	// [1d0] _politice_, _dražba_, _ofcom_, --, 
   {{0x4e9530af,0x6609e179,0x5be16197,0x70d9e19b}},	//   _mpumalan, _zaboravi, _navigáci, _zaboravl, 
   {{0xc29031e0,0x8a012128,0xe2003083,0x72a66006}},	//   _hilang_, _mahalaga_, _hiling_, _adobe_, 
   {{0xfb7e61c8,0x62903244,0x14292053,0x33eaf188}},	//   _profilin_, _bilang_, _jemputan_, _saites_, 
   {{0x22fcd0a2,0xd2d91245,0x137a21a5,0xc857b015}},	//   _keegi_, _babeli_, _disalin_, _културно, 
   {{0x7394019e,0x537a5246,0xcc43a024,0x32b4004d}},	//   _voisi_, _izjavio_, _पनडुब्बी_, _voici_, 
   {{0xd975b0d2,0x1ae8408d,0x0f17b1e1,0xc9c84062}},	//   _kuriozit, _verdiens, _mendoron, _verdiene, 
   {{0xa3ea0171,0x6951f0e5,0xa2da023b,0x93f401eb}},	//   _saite_, _kvalitee, _rupela_, _pistes_, 
   {{0x6c87b108,0x03ea90e2,0x5459c0d1,0xc2026057}},	//   _времето_, _suatu_, _objetivo_, _kiriya_, 
   {{0xfbeec126,0x03dc1247,0xd290800c,0x00000000}},	//   _садои_, _nthwv_, _sakala_, --, 
   {{0xb26cd1c3,0xd3fd4138,0x22d8d173,0x720030cc}},	//   _proofs_, _بقراءة_, _nkees_, _ailing_, 
   {{0x54c71223,0x2290f1f1,0x7291910f,0xd2920178}},	//   _гардид_, _dagar_, _yasal_, _marary_, 
   {{0x2291e068,0x22e0909f,0xf7c2f075,0x5290f0ea}},	//   _kitap_, _poznato_, _মিসরে_, _vagas_, 
   {{0x2dcdc084,0x754d70de,0xc65b912e,0x23ea7084}},	//   _коалиция, _verksamh, _halimbaw, _punts_, 
   {{0xbc6821b9,0xb2903248,0x92ab9151,0x83a3a0ef}},	//   _febrero_, _संयोजन_, _并不代表本站及其, _coppy_, 
   {{0xb9d73050,0x00000000,0x00000000,0x00000000}},	//   _kustutad, --, --, --, 
   {{0xdc530087,0x1652d037,0x32026057,0x6145c142}},	// [1e0] _obstaja_, _стига_, _biriya_, _हुकूमत_, 
   {{0x047211e0,0xd2018010,0xb2b4617c,0x86360016}},	//   _disebabk, _narik_, _blocs_, _ייִוואָ_, 
   {{0x13657051,0xf548c024,0x0c0be249,0x627f4034}},	//   _drugima_, _चाहेंगे_, _европу_, _eventi_, 
   {{0xad19a173,0xa37950a9,0x1eb0b219,0x5012f148}},	//   _crosswor, _matanya_, _laesense_, _predpiso, 
   {{0x03ea9045,0xb57fb110,0xb83b8024,0x930fe032}},	//   _brath_, _oosthuiz, _अरबपति_, _bambino_, 
   {{0x170ba006,0xd96da006,0x730c6109,0x62486029}},	//   _ההבדל_, _פשוטה_, _adabroc_, _nyomi_, 
   {{0x9c67c14c,0x1201800c,0x4665d24a,0x42d9012a}},	//   _телефона_, _parim_, _сфері_, _libero_, 
   {{0x2dd2d019,0x2f38324b,0xdc1da03e,0x9ae8804f}},	//   _стали_, _दायित्व_, _aktualis, _geworden_, 
   {{0xc26450bd,0x25583032,0x72901242,0x32fc4092}},	//   _skulle_, _понякога_, _nphau_, _designu_, 
   {{0x837950e8,0xb4375121,0xff37b1a2,0x798680c5}},	//   _katanya_, _واردات_, _pristupa, _ताजमहल_, 
   {{0xd368a1dd,0xd7c2f075,0xc2cad13d,0xa10431e9}},	//   _vergeet_, _মিশরে_, _credu_, _методичн, 
   {{0xc5ce40e6,0xe200b0f1,0xa4f69079,0x6290c09f}},	//   _प्रदर्शन, _kleine_, _графия_, _dolaze_, 
   {{0x727ed110,0xbe2bf03b,0xbd3a21ad,0x6189a126}},	//   _ubongo_, _laugarda, _napisane_, _фармонде, 
   {{0x726ca24c,0xdd28901a,0xfec39006,0xcc6f21ab}},	//   _sebou_, _насихатт, _באתרי_, _محیطی_, 
   {{0xe9a9c24d,0x11f5d0fd,0x7291624e,0xb3dc9057}},	//   _विद्यालय_, _субота_, _magana_, _ntawe_, 
   {{0x5fe9b0a2,0xec03d01a,0x134c324f,0x120090f5}},	//   _मुहावरा_, _телеарна, _मासूम_, _ncaig_, 
   {{0xb469d10a,0x3e7a8035,0x320080ba,0x72e951e1}},	// [1f0] _годината_, _アイコンの説明_, _hakika_, _hatinya_, 
   {{0x6ecd2060,0xc25a9166,0x00000000,0x00000000}},	//   _daristan, _orali_, --, --, 
   {{0x8291a084,0x4650c0c8,0xa2d87071,0x15d7918b}},	//   _espai_, _전자상거래_, _rynek_, _pencerah, 
   {{0x5eba10e1,0x729181e0,0x00000000,0x00000000}},	//   _дошли_, _marah_, --, --, 
   {{0x120181b1,0xc8640250,0x00e1f071,0xe608a251}},	//   _barik_, _fernánde, _ewentual, _zdravím_, 
   {{0x9fd68043,0x83ac01d7,0x92b4e1b7,0x4ecc51e9}},	//   _кваліфік, _grupę_, _clicca_, _основном, 
   {{0xb2f3f252,0xe7b89057,0xace8b02a,0xd2009011}},	//   _sedikit_, _repubuli, _доставки_, _npaim_, 
   {{0xb2e82253,0x4291213b,0xfc47c1c6,0xf3ea019e}},	//   _içinde_, _mayar_, _жазган_, _laita_, 
   {{0xd91b80c3,0xd39491c1,0x3d89f1cb,0x2c99f108}},	//   _בפֿרט_, _vlast_, _техниче_, _техните_, 
   {{0x2f63f0c8,0x0292500d,0xefeeb022,0xd2010087}},	//   _참고하시기_, _mitala_, _partlayı, _dobite_, 
   {{0xaceee1b5,0xe96b50db,0x00000000,0x00000000}},	//   _среду_, _meinunge, --, --, 
   {{0x925a50db,0xd2907104,0xc300707d,0x3f49f254}},	//   _hallo_, _sambandi_, _samband_, _perpadua, 
   {{0x4291f189,0x43ea01da,0x14fdc1ab,0x66137017}},	//   _estas_, _baita_, _مجددا_, _festival_, 
   {{0x82498142,0xe7047074,0x1f072031,0x1b0280b5}},	//   _firmy_, _венгерск, _disponív, _розуму_, 
   {{0xd57fc1c4,0x29ce4008,0xb200b089,0xc5d59049}},	//   _مصاحف_, _televide, _radila_, _potansiy, 
   {{0x72019255,0x2ebc0256,0x22c3f015,0xf1c9500c}},	//   _kasih_, _opportun, _користи_, _पद्मविभू, 
   {{0x42ca0086,0x02a64110,0xcff4d1d7,0x8dd4d069}},	// [200] _faida_, _jembe_, _techniko, _technika, 
   {{0xc27e900b,0x225b5043,0x0b7c1151,0x00000000}},	//   _imana_, _spelar_, _如果您没能找到需, --, 
   {{0x3ddcc220,0xf3a95150,0x9291a1fd,0x00000000}},	//   _ملحوظ_, _madaling_, _mapak_, --, 
   {{0x12911257,0x2290c1a6,0xbb0d80b7,0x1deb50ea}},	//   _yazar_, _walala_, _kissimme, _municípi, 
   {{0xd3f4713e,0x4c53e258,0xb4b1517e,0xf3ac71b9}},	//   _pastaj_, _राकेश_, _descriçã, _grupos_, 
   {{0x820260f4,0x82927259,0xa387f081,0x99fca04e}},	//   _birina_, _disana_, _ijuru_, _palament, 
   {{0xf4a900ee,0x7d3a2142,0x73f0a033,0x00000000}},	//   _pasahitz, _zapisane_, _ग्रॅम_, --, 
   {{0xe92850cd,0x626e10cc,0xdc664022,0xd5b27092}},	//   _партияны, _riport_, _tutulub_, _pronájmu_, 
   {{0x230c425a,0x00000000,0x00000000,0x00000000}},	//   _impamvu_, --, --, --, 
   {{0xa51e10ff,0xdc5501d9,0x3b7e1071,0xb291225b}},	//   _ekologiy, _ailtire_, _ekologic, _tayar_, 
   {{0xb386603b,0x429840fa,0x1643b1d7,0x32025110}},	//   _hvort_, _dňami_, _susitiki, _mitima_, 
   {{0xf8852103,0xf3eb900e,0x9236c0e5,0x0c480035}},	//   _श्रीवास्, _musta_, _hiljem_, _エレクトロニクス_, 
   {{0x3dd2207d,0x4517b129,0x03ea90fd,0xc291325c}},	//   _доступ_, _समृद्ध_, _esate_, _taxas_, 
   {{0xe25a4105,0x52cd8008,0x46052124,0xe5c55075}},	//   _gamle_, _босқич_, _prodajem_, _কামরুল_, 
   {{0x5200c1ef,0x93eb925d,0x32ff416d,0x8c87a108}},	//   _galima_, _gusta_, _maribor_, _аромат_, 
   {{0x88409069,0xf291f1e4,0xdf4eb193,0x0200c132}},	//   _سیکرٹری_, _astar_, _respekte_, _salila_, 
   {{0x5291c100,0xd166303a,0x3315325e,0xb37a11a7}},	// [210] _davam_, _प्रतिबंध_, _تواضع_, _pasaran_, 
   {{0x00a610c3,0x920260f3,0xfd8750b2,0x42fc3173}},	//   _עסקנים_, _merite_, _desembre_, _melikas_, 
   {{0xa3ee1099,0xc27e9086,0x5e227024,0xd2919182}},	//   _zakończo, _amani_, _आमतौर_, _pasak_, 
   {{0x63ac71fd,0x239470cb,0xa35be057,0x42afb042}},	//   _turpis_, _sonst_, _kangura_, _módulo_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x72009173,0xb166008e,0xc2f0d0e0,0xd047f024}},	//   _ncaim_, _איסורים_, _fatimah_, _मुसलिम_, 
   {{0x13eb9010,0xe8b5901e,0x0236925f,0xbe072175}},	//   _gusti_, _전체평가보기_, _miljö_, _dospelýc, 
   {{0x02ab107a,0xa2e0e0ff,0x1d97a05f,0x723c90c8}},	//   _leiding_, _cənubi_, _القهوة_, _생성합니다_, 
   {{0xb8345006,0x3290104d,0x82c21150,0x1561a260}},	//   _מהתגובות_, _achat_, _bibliya_, _proviamo_, 
   {{0xe9a5f106,0xcd236193,0x374ab224,0xfde5f106}},	//   _diskusia_, _konsantr, _upozorni, _diskusie_, 
   {{0x1593a261,0x8c90b136,0xe2fd81e0,0x9492e0fe}},	//   _prilikom_, _क्रोम_, _pergi_, _tinggalk, 
   {{0xe2ca90a2,0x93947109,0xc896315d,0x739491ad}},	//   _saada_, _innse_, _мактуб_, _klasy_, 
   {{0x42fd80aa,0x960b906d,0xa292515b,0xd9de1116}},	//   _vergi_, _dermanki, _aitaba_, _multimid, 
   {{0x94730053,0x33ebf0f4,0x6f207259,0x82025116}},	//   _pastikan_, _butto_, _mendukun, _antika_, 
   {{0xa37a21ce,0xbce62159,0xa27ed110,0x82b40032}},	//   _paparan_, _cwjvuamc, _amene_, _unico_, 
   {{0x6291f0ef,0x42d9d262,0x1e622184,0xe00350c8}},	//   _lazada_, _skynyrd_, _imobilia, _인기검색어_, 
   {{0x4fe87033,0x33ea9263,0xf394d264,0x1200c1ac}},	// [220] _वाचायला_, _taata_, _pulsuz_, _salima_, 
   {{0x15144217,0x5df53137,0xe980504c,0x3880504c}},	//   _resumido_, _pridajte_, _articole, _articolu, 
   {{0x0c574013,0x4e9741c8,0xa26e60a2,0x6386807f}},	//   _postime_, _postimet_, _parool_, _ghazali_, 
   {{0x59a3f14c,0xac75e0bf,0x91ec80cf,0xfc045104}},	//   _лекарств, _डोल्पा_, _मातरम_, _vinstri_, 
   {{0x721c722e,0x5feda017,0x4169109d,0xb2ca50f7}},	//   _rushwa_, _מסביב_, _pennaeth_, _valde_, 
   {{0xe12d30fd,0x6053d195,0x803400c3,0x6626412f}},	//   _факты_, _мобилен_, _קאמאנס_, _sistemul_, 
   {{0xb25a5050,0x877f50c8,0xb2e831a9,0xc291e254}},	//   _talle_, _서울대학교_, _fàilte_, _tatau_, 
   {{0x3200e089,0x3ed350e3,0xca02f18b,0x00000000}},	//   _danima_, _иеромона, _tetangga_, --, 
   {{0x6d30e06a,0x9201a095,0x3387821a,0xe63651a7}},	//   _hatimaye_, _ispit_, _styrke_, _kaunseli, 
   {{0x32ca7265,0xf37971e1,0x6b5280f7,0xd2d8d247}},	//   _cando_, _rasanya_, _почуття_, _xyeem_, 
   {{0x47fae035,0x995ce087,0x5cf161fe,0x03fa5257}},	//   _コメントありがと, _nadomest, _imiterer, _fatura_, 
   {{0xc38af20f,0xd2da5081,0xd233d054,0x00000000}},	//   _mòran_, _gatera_, _olivenol, --, 
   {{0x7379123e,0x138690e6,0x22aba260,0x902d2230}},	//   _kupanga_, _tvaru_, _beading_, _zemplíns, 
   {{0x5ceed015,0xd4661006,0xa357f046,0x8290e057}},	//   _града_, _חייבים_, _xenforo_, _kanama_, 
   {{0xb27421ab,0xa201f09f,0x4a05f17e,0x06109116}},	//   _جوملا_, _obzira_, _embalage, _tajlandi, 
   {{0xc855a201,0x3fe91266,0xc290c110,0x56b9707a}},	//   _আধুনিক_, _फ्रान्स_, _balaka_, _benaderi, 
   {{0x423171bc,0x327e0221,0xa855d035,0x910740a5}},	// [230] _bermula_, _seinn_, _ああっ名無しさま, _pronađi_, 
   {{0x937a60e8,0xa25a504d,0x3c64a03f,0x52220267}},	//   _kawasan_, _salle_, _situace_, _birżebbu, 
   {{0x2249400e,0x54901024,0x5b6c70cf,0xeb971174}},	//   _hieman_, _चम्मच_, _वासना_, _شاعران_, 
   {{0xe3f461b3,0x94d6c14f,0x00000000,0x00000000}},	//   _ujutru_, _बुढिया_, --, --, 
   {{0x7493f01e,0xd7e270f5,0x9f3dd268,0xeb0de151}},	//   _블로거뉴스_, _cinplaim_, _क्षितिज_, _违反本法规定_, 
   {{0x2394902b,0x1d5b8046,0x4ecda0d2,0x82cad0a7}},	//   _vlasy_, _tính_, _komision, _kredi_, 
   {{0x82da5269,0x82249121,0x93ea3069,0x2e8ad00c}},	//   _batera_, _anake_, _fajta_, _भारतीयन_, 
   {{0xfe9ba26a,0x826c9026,0x325bf1a6,0x03cf4193}},	//   _seguinte_, _inkosi_, _tuulo_, _preval_, 
   {{0x43ea70b4,0x0675c151,0x6e3b010e,0x00000000}},	//   _panto_, _经典艺术片_, _varavara, --, 
   {{0x46d6126b,0x520260f4,0x722b91c5,0xa2e2020a}},	//   _discussi, _kiriba_, _exemple_, _calidad_, 
   {{0x23ead08c,0x2291e033,0x64121220,0x00000000}},	//   _rreth_, _batam_, _محققین_, --, 
   {{0x1db8e069,0x9be5b26c,0x47e8c104,0x81cc2136}},	//   _valamint_, _randamac, _alvarleg, _धरोहर_, 
   {{0x3c76326d,0xdc6f7199,0xb30cb26e,0xf168e0c5}},	//   _मुद्रा_, _heureka_, _poradit_, _आश्चर्यज, 
   {{0x438060b9,0x44769098,0xd3fa5188,0x00000000}},	//   _sourit_, _процесс_, _satura_, --, 
   {{0xc3960173,0x9089c1b5,0x143ec17e,0x6b17c26f}},	//   _lossis_, _режима_, _разни_, _раздел_, 
   {{0x829d807b,0x8c59d07a,0x6378109a,0x5c621124}},	//   _všade_, _vertrek_, _rubanda_, _izgubio_, 
   {{0xa272a270,0x0ebca005,0x43ead06f,0x327e0271}},	// [240] _tűnik_, _publiczn, _treth_, _reino_, 
   {{0xada8d0fb,0x776e8155,0x925a4052,0x9b67f1d9}},	//   _activita, _universi, _gamla_, _innealan_, 
   {{0x2b81b1f5,0xa9f081e1,0x9316b148,0x00000000}},	//   _sledovať_, _hasilnya_, _cudzie_, --, 
   {{0x41272008,0x82aa31c0,0xe2927232,0x00000000}},	//   _ғаройиб_, _vneconom, _rurali_, --, 
   {{0x46658024,0x93fa7010,0x00000000,0x00000000}},	//   _आईएसआई_, _kusuma_, --, --, 
   {{0x76e400ba,0x92fdf0ba,0x3afdf16f,0x7eb06134}},	//   _kimataif, _ndugu_, _prosjekt, _recomman, 
   {{0x4dc3a02b,0x93944272,0xf386900f,0x5215a187}},	//   _podobné_, _komst_, _svart_, _oddělení_, 
   {{0x66414075,0x01e19002,0xb2d5120d,0x6dbb8035}},	//   _যথেষ্ট_, _मदारी_, _millest_, _アニメ感想_, 
   {{0x8c00b072,0xc061d152,0x36942016,0x72f0d1bc}},	//   _passant_, _штату_, _סאלדאטן_, _fatihah_, 
   {{0x23a8e083,0x220270ba,0x07b2d16b,0x00000000}},	//   _malaking_, _hariri_, _штаба_, --, 
   {{0x6bcf5273,0xa2ca711e,0xb291e0b4,0xe0b6d02e}},	//   _श्रीनगर_, _tande_, _matak_, _नेचुरल_, 
   {{0x99c2900c,0x9a51f0a9,0x9ed6016e,0x6290e00b}},	//   _kindlast, _व्यंगचित, _kažem_, _kanaka_, 
   {{0xb27e00e5,0xfbdff197,0xc291f164,0xe01fa1d7}},	//   _teine_, _aplikáci, _brzaka_, _investuo, 
   {{0x82ca5192,0x8f7041b4,0xdc74d099,0x9f2fc0cb}},	//   _halda_, _luscious_, _एंट्री_, _anwendun, 
   {{0x13ac70ab,0xfea28104,0x7be41006,0x6c5a91bf}},	//   _grupas_, _landsins_, _האלבום_, _awatali_, 
   {{0x227e9040,0xe2018052,0x42025037,0xed5b705f}},	//   _ilang_, _varit_, _ultimo_, _aistriú_, 
   {{0x450fb0e8,0xb278e110,0x1154f09f,0x13f96150}},	// [250] _komersil_, _miliyoni_, _budućnos, _siguro_, 
   {{0xbc8590c3,0x9d72c274,0xb4b9f275,0x41b9f084}},	//   _רוסיש_, _राष्ट्रध, _मंगेशकर_, _direcció_, 
   {{0xd200c1a7,0xc2d99022,0xf25ad1cd,0x2c307075}},	//   _talian_, _aysel_, _kallis_, _ভাইয়ের_, 
   {{0x10978075,0xb968a0a6,0x029101e3,0xbc87a0eb}},	//   _কৌতুক_, _informie, _zabala_, _примите_, 
   {{0x3dab5240,0x29d5c033,0x00000000,0x00000000}},	//   _menninga, _आशियात_, --, --, 
   {{0xd3ea7055,0xb15c2133,0xa291a063,0x97a86276}},	//   _sante_, _oficiáln, _ntxawm_, _nastavni, 
   {{0x52dc5277,0x489b4035,0xfd6b4038,0xc6fa60c8}},	//   _søndag_, _レストラン_, _partisë_, _실시간환전게임_, 
   {{0xc18ac138,0xa27e021c,0x52c2702b,0x2684400d}},	//   _وكذلك_, _seine_, _kvalita_, _oluvanny, 
   {{0x625a5032,0x6e6da0a5,0xbc98003b,0xb2480087}},	//   _dalla_, _proizvođ, _spurning_, _njimi_, 
   {{0xbb617278,0x69d310a9,0xf2024042,0x1225009f}},	//   _bystrica_, _pokoknya_, _ética_, _ovakav_, 
   {{0x1c483279,0xcebe2132,0x73ebf046,0x0ff5f035}},	//   _अभिनंदन_, _sanggeus_, _btttt_, _ランキング一覧_, 
   {{0x1b9de030,0x56820169,0xc200b1b7,0xa2019068}},	//   _кишиневе_, _विराट_, _codice_, _basit_, 
   {{0x2291e128,0xbb77f0f9,0x229191a3,0x00000000}},	//   _tatak_, _артады_, _masas_, --, 
   {{0x257da006,0x41bd800e,0x2cbe102a,0x66e40006}},	//   _רביעי_, _развития_, _затем_, _בנתניה_, 
   {{0x03d7103c,0xe98400a5,0xe1b2b035,0x8201f072}},	//   _参考になった_, _godinama_, _名無しさん_, _estiu_, 
   {{0x92366092,0x526c2095,0xa380527a,0x3e84a094}},	//   _svoji_, _mukom_, _catrin_, _ҷустуҷӯ_, 
   {{0x48662039,0x118d6277,0x7291e068,0x32d8f166}},	// [260] _مکتوب_, _forbehol, _yatak_, _rekords_, 
   {{0xc2da00f3,0x1394d086,0x3201e0a7,0xaf69b087}},	//   _repete_, _agosti_, _fatih_, _porodniš, 
   {{0x96b00006,0x329251f2,0xf4682017,0xa3732042}},	//   _סמסונג_, _estaba_, _התהליך_, _adiante_, 
   {{0x0291a13a,0x12018010,0xf291827b,0x11389010}},	//   _lapas_, _karir_, _karar_, _ابراهیم_, 
   {{0xa1692157,0x21a22129,0x2a1071fe,0x4225b0d5}},	//   _методик_, _भारतातील_, _kambanda_, _xavkom_, 
   {{0x8290d27c,0xe793700e,0xe5dfc05f,0xd9183126}},	//   _allahu_, _moottori, _بحاجة_, _беҳуда_, 
   {{0xfeaa809a,0xd2cad27d,0x4c9c311b,0x53a2511b}},	//   _baturage_, _rhodri_, _озарий_, _yalpi_, 
   {{0xe3ebf1bf,0xb236011e,0x376a20b0,0x63ea900c}},	//   _kutta_, _blije_, _đường_, _saate_, 
   {{0xc2240116,0xc278b043,0xd3965133,0xd341c072}},	//   _unika_, _закарпат, _zkuste_, _adreça_, 
   {{0x03ebf019,0x5999701e,0x83ebf0b0,0xf2017030}},	//   _mutta_, _미디어로그_, _stttt_, _traian_, 
   {{0x1291a27e,0x13dde15b,0xe29180a7,0x7306400c}},	//   _mapas_, _fetwa_, _zarar_, _सुचित्रा_, 
   {{0xe730e027,0x5b38a1ab,0x62ca7199,0xa4e81191}},	//   _novostav, _زولبیا_, _bundy_, _خوشمزه_, 
   {{0x52918054,0xc2817041,0x8ede2122,0x0501d164}},	//   _paras_, _hahhaah_, _зиёде_, _početka_, 
   {{0xe2b4c199,0xb2e8025f,0x22cae13d,0x9291a128}},	//   _plocha_, _länder_, _beidio_, _tapat_, 
   {{0x66374092,0x22d5d17c,0x2f5d31b0,0x2819f0c8}},	//   _पेजहरु_, _benefici_, _opravdan, _크리스마스_, 
   {{0x3247f17e,0x83ebf03b,0xfc5e308d,0x3f21212a}},	//   _кариера_, _stutt_, _kasteel_, _acquista, 
   {{0xd607c27f,0x22ab7167,0x83a29193,0x7290b280}},	// [270] _आबादी_, _melding_, _chape_, _andare_, 
   {{0x39aac127,0xce5820f9,0xa27ee04d,0x646db281}},	//   _комил_, _құнды_, _bonnes_, _aprendiz, 
   {{0xe2d910fa,0x625aa282,0x502c201a,0x83fa6074}},	//   _chcela_, _table_, _ықпал_, _forumo_, 
   {{0x3c617022,0x569c2098,0xac532283,0x54017022}},	//   _forumda_, _достаточ, _विषेश_, _forumdan_, 
   {{0x1f19e1bb,0x8639402b,0xb6a0f010,0x526c61ba}},	//   _permitir_, _materiál_, _الزامی_, _kulon_, 
   {{0x9d0a1232,0x07b61284,0x77201282,0x00000000}},	//   _segretar, _levering, _במגוון_, --, 
   {{0x6386d285,0x734290cf,0x9753a0c5,0x158740d2}},	//   _hvert_, _सरपंच_, _युधिष्ठि, _arrestoh, 
   {{0x6867e0b5,0x1d5ac12b,0x9c528019,0x00000000}},	//   _органам_, _кожен_, _hintaan_, --, 
   {{0xa2918176,0x320ec0cd,0x5f48b07a,0x9303c0c6}},	//   _harap_, _канат_, _kunstena, _gekauft_, 
   {{0xe348c0c0,0x72e80286,0x8c70f041,0x5291a010}},	//   _offerti_, _händer_, _kajsiab_, _papat_, 
   {{0x7346307a,0xd34040e1,0xf9bdf151,0x835421ef}},	//   _kinders_, _nedelja_, _中国气象局_, _numeris_, 
   {{0x53eb80fd,0xf2f21147,0x32002057,0xb6835151}},	//   _kurti_, _акрам_, _komine_, _福星上战场_, 
   {{0x3e260006,0x5dfb904c,0x00000000,0x00000000}},	//   _משפחתי_, _diferite_, --, --, 
   {{0x14a2c019,0x00000000,0x00000000,0x00000000}},	//   _ткани_, --, --, --, 
   {{0x325bf0a2,0xa2b5c09f,0xda001287,0xa27e31c8}},	//   _juuli_, _novca_, _kayaknya_, _bejne_, 
   {{0x4cc6c08a,0x436ef09f,0x270e2017,0x1a0a11f9}},	//   _мигрант_, _njegovu_, _בוודאי_, _misahana_, 
   {{0xb29ee04f,0x437b2288,0x9387013b,0x927e00fb}},	// [280] _miljoen_, _impacto_, _amarah_, _feina_, 
   {{0x42d98137,0xffa541ce,0x94b28032,0xf3ea9137}},	//   _okrem_, _disember_, _organizz, _zajtra_, 
   {{0xcc80d0cd,0x426d90a9,0xb2ab8045,0x0dd620ee}},	//   _кедей_, _besok_, _cábla_, _deskriba, 
   {{0x218c600c,0x847ed289,0x023ca094,0x00000000}},	//   _सर्वर_, _видов_, _системаи_, --, 
   {{0x03ced1c3,0xa291c022,0xb2fd804c,0xd4730199}},	//   _clovis_, _banklar_, _mergi_, _estetick, 
   {{0x227f00c1,0x5386d240,0xf3959060,0x00000000}},	//   _hranom_, _hvers_, _mosse_, --, 
   {{0xa2b5728a,0x63bff032,0x956ff032,0xb15c2147}},	//   _chache_, _servizi_, _servizio_, _русал_, 
   {{0xa2d980e6,0x4213927c,0x02fc70b7,0x52fc01f1}},	//   _okres_, _kisha_, _tunga_, _origo_, 
   {{0xcb7bd071,0x8097d17e,0x827e7240,0x6b993087}},	//   _दर्शकों_, _промена_, _renna_, _socialno_, 
   {{0xa341021f,0x56d12024,0x3316c027,0x622401a6}},	//   _بنياد_, _टैरिफ_, _kedze_, _riika_, 
   {{0x526da170,0x3302d05e,0x0c75420a,0x75a03033}},	//   _depok_, _jikalau_, _algunas_, _रेवती_, 
   {{0xeebb20f5,0xfacde156,0x714d61c7,0x32cac068}},	//   _excommun, _посещени, _obvestil, _cadde_, 
   {{0x17601121,0x5386d28b,0x448101ad,0x63954124}},	//   _دلخواه_, _tvorba_, _मिलाकर_, _umesto_, 
   {{0xcb0f2006,0x012a21d7,0x8ad02094,0xb2d95121}},	//   _corporat, _эстрадны, _ихроҷ_, _sugeng_, 
   {{0xc61a601f,0x9489f151,0xa2d70110,0x1b2f8134}},	//   _manodidi, _新用户注册_, _matondo_, _considér, 
   {{0xfff79203,0xefaa703b,0x57eca28c,0x2a31c075}},	//   _תענית_, _nemendur_, _belakang, _পিডিএফ_, 
   {{0x730c3271,0x191e1016,0x85a1105f,0x2b94b28d}},	// [290] _relatos_, _זונטיק_, _الاصلي_, _dagirkir, 
   {{0x3e95301a,0xe3317151,0x2300b1df,0x00000000}},	//   _еуразия_, _国家粮食局_, _имигрант, --, 
   {{0xd37fc158,0x3c6a8087,0x52d9d13d,0x00000000}},	//   _zemalja_, _forumov_, _hywel_, --, 
   {{0x785be160,0x826cc01f,0x00000000,0x00000000}},	//   _nedrīkst_, _veloma_, --, --, 
   {{0xd3ead0cb,0x0317e164,0x00000000,0x00000000}},	//   _montag_, _potiskuj, --, --, 
   {{0x12f1e099,0x225bf10f,0xb53e4009,0x4363628e}},	//   _pomocą_, _mutlu_, _ceritany, _singgah_, 
   {{0x65793035,0x00000000,0x00000000,0x00000000}},	//   _酢酸ビニル共重合, --, --, --, 
   {{0xfc590173,0xadc5a017,0x09e451e1,0xa8e7f12a}},	//   _khouang_, _christia, _diantara_, _затвори_, 
   {{0x8c67f098,0x02ca6044,0x3cdd1075,0xc377c191}},	//   _minulla_, _chodi_, _হালকা_, _قرائت_, 
   {{0x5efee28f,0x9535a008,0x04fd105f,0xfb273068}},	//   _nóvember_, _муддат_, _بجودة_, _cumartes, 
   {{0x12e9705d,0xcfb86035,0x4ed0e092,0x00000000}},	//   _tariffa_, _産学連携組織_, _policejn, --, 
   {{0x63f8c290,0xb2c3a1e3,0xe5acd0fd,0xadc53094}},	//   _deluje_, _mailako_, _племя_, _аксҳои_, 
   {{0x6f5020ef,0xfd3820c3,0x62fc7034,0xbdbcf148}},	//   _sohanews_, _געביידע_, _lungo_, _intenzív, 
   {{0xd201811a,0x3291d0cc,0x72caa1ec,0x7a49e151}},	//   _scrie_, _lawas_, _labda_, _个国家中排名第_, 
   {{0x539481ae,0xc0e9e00e,0x3980e1dc,0x5c9d3036}},	//   _kristy_, _принадле, _зелемхон_, _marehemu_, 
   {{0x3559e079,0x22f1c022,0x1ebba1b5,0x00000000}},	//   _проблеме, _sevimli_, _sportske_, --, 
   {{0x327e90bc,0x3dd60059,0x05f4212a,0xba9631e9}},	// [2a0] _teana_, _केजरीवाल_, _случва_, _варіант_, 
   {{0xecd73010,0x99df5075,0xc913923a,0x0dbbb145}},	//   _اعلام_, _চারুকলা_, _merangku, _objektív, 
   {{0xc155d024,0xf46e803c,0x62d8c291,0x00000000}},	//   _इसीलिए_, _frederik, _lyder_, --, 
   {{0xa2786083,0xa291d14a,0xc3ea9109,0x7228803b}},	//   _ngunit_, _bawat_, _chath_, _tókst_, 
   {{0x6347a01a,0x00000000,0x00000000,0x00000000}},	//   _оқулықта, --, --, --, 
   {{0x230e7292,0x2c692095,0x4c52e240,0x3b97c015}},	//   _arabera_, _zapravo_, _boltinn_, _семинара_, 
   {{0x72ca907a,0x4290d086,0xe9a5c094,0x00000000}},	//   _skade_, _mkoani_, _аллакай_, --, 
   {{0x01a3a075,0xc81c6022,0x3c9c603a,0x62da6195}},	//   _তাপমাত্র, _çalanşik_, _मुल्यांक, _direto_, 
   {{0x67cc6200,0x84ead02f,0xa56ad02f,0x429181f2}},	//   _personli, _第二十二条_, _第二十五条_, _obras_, 
   {{0x0eda917e,0xc25ad219,0xd5d530eb,0x2387413e}},	//   _втората_, _tsela_, _туризма_, _ndersa_, 
   {{0x02a6909e,0xc68e4008,0xe8580072,0xdd36814c}},	//   _alaba_, _teleradi, _процесст, _opinione_, 
   {{0x5977f285,0x0c753072,0x12ca9029,0xa2da00b9}},	//   _menneske, _этникалы, _khadi_, _lapolis_, 
   {{0x0b5e5079,0x1255a25e,0xc1b03069,0x72d1f053}},	//   _фамилией_, _problémá, _پچھلے_, _tentulah_, 
   {{0xe2fc921c,0xcf25b032,0x2f116032,0x8344b017}},	//   _frage_, _selezion, _contatta, _disease_, 
   {{0x5399325f,0xf27f706a,0xc2781170,0x13a8d152}},	//   _måste_, _mpango_, _pengirim, _армянска, 
   {{0xefd71251,0xc2b7200c,0xb6dc4066,0xbe53918b}},	//   _protože_, _क्रिएटिव_, _बैरिन_, _berangka, 
   {{0xe291d0b4,0xdda4724c,0x022ac0fd,0x038750cb}},	// [2b0] _hawar_, _reagovat_, _домам_, _zuerst_, 
   {{0xbc6af071,0xd2573293,0xe3ce5105,0x327e0294}},	//   _dostawy_, _føler_, _selve_, _meint_, 
   {{0x33a22295,0xa212d0f5,0xa20ec084,0x8200c036}},	//   _compte_, _ehehe_, _далай_, _kuliko_, 
   {{0xa291c03d,0x038d122c,0x4386000e,0xf50a0045}},	//   _savas_, _proposti_, _koira_, _gaillimh, 
   {{0xa3065296,0x6b3c9035,0xa36e3297,0xb3e9200c}},	//   _menarik_, _解決済みの質問_, _songoku_, _वेबसाइटन_, 
   {{0xd291e0cc,0x9738817c,0x927e904e,0xe2fc7128}},	//   _gatas_, _галереяс, _leano_, _tungo_, 
   {{0xc48530ed,0x4200c1e0,0x5c64304d,0xd7b1101a}},	//   _देहाती_, _kalian_, _contenu_, _жұқпалы_, 
   {{0xaa162140,0xb3062089,0x52926054,0x32eac02c}},	//   _podataka_, _podatak_, _korang_, _джаза_, 
   {{0x1936e004,0x62fcf0bd,0x5386f17c,0xeffab025}},	//   _struktūr, _ganger_, _negre_, _मुहावरे_, 
   {{0x2dc4514c,0xd2d67298,0x02d9600c,0x00000000}},	//   _европейс, _פישינג_, _sageli_, --, 
   {{0xb43ec019,0x22a0707f,0x5ee36299,0x94861024}},	//   _давно_, _serbuk_, _spokojen, _मोटापा_, 
   {{0xd26e60ab,0x00000000,0x00000000,0x00000000}},	//   _autors_, --, --, --, 
   {{0x03ac71ca,0x38ff00c8,0xd3ea929a,0xac210071}},	//   _respon_, _프로그램의_, _chati_, _montaż_, 
   {{0xe7cd3075,0x786380f5,0xf8999079,0xf200b09a}},	//   _তাঁরা_, _haistias_, _универс_, _radiyo_, 
   {{0xa13cf060,0x70d53008,0x9bede033,0x65dd40c8}},	//   _ewropayê_, _журнали_, _diperkir, _처갓집양념통닭_, 
   {{0x62aa3138,0xbdc3929b,0x22fc729a,0x9e539170}},	//   _وسهلا_, _peringka, _bunge_, _perangka, 
   {{0x8291e150,0xe99d1093,0xd200c0b7,0x5200c14d}},	// [2c0] _batas_, _нағыз_, _dalian_, _malipo_, 
   {{0x82cac00f,0x48fdb104,0x139580b4,0x82ca9140}},	//   _ladda_, _skipulag, _korsi_, _ikada_, 
   {{0x7201817a,0x8fae0087,0xe1481230,0xc84a11b7}},	//   _abrir_, _odgovoro, _kartónov, _пазарджи, 
   {{0xf34391b2,0x52d7429c,0x19f0a02a,0x337a501e}},	//   _युकून_, _beslist_, _kunnolla_, _bewaren_, 
   {{0x7e0370e1,0xcc15200c,0xdaf6029d,0x6aeed25d}},	//   _uključen_, _विक्रान्, _emprende, _tratamie, 
   {{0x73ea6282,0xdb5bf091,0xd373004d,0x9b1141c6}},	//   _photo_, _pretraga_, _domaine_, _campanya_, 
   {{0x5eae0016,0xc27e7065,0xd2fe00c4,0xc2da6030}},	//   _אוצרות_, _benne_, _casglu_, _cerere_, 
   {{0x6f5100c8,0x4f1171e2,0xe3f43082,0x864ca0d4}},	//   _등록하시면_, _rendemen, _kartı_, _मर्डर_, 
   {{0x3e923064,0x624a729e,0xedb4b07f,0x7394d0c8}},	//   _порталы_, _permet_, _diriwaya, _moest_, 
   {{0x98065139,0xa3c87155,0x723880b0,0xdd7a9072}},	//   _décembre_, _server_, _teamobi_, _diumenge_, 
   {{0xc0321187,0x225a9083,0xe396029f,0x925a02a0}},	//   _रौतहट_, _akala_, _visser_, _skila_, 
   {{0x52dc619c,0x920031b9,0x7f0fd0be,0xb2e39055}},	//   _måndag_, _camino_, _opatrova, _latitid_, 
   {{0xacd202a1,0x22a64026,0x2396626f,0x0632a1b1}},	//   _विशेषाधि, _gombe_, _alusta_, _nabigazi, 
   {{0xdc1e2134,0x338bc19c,0x00000000,0x00000000}},	//   _compris_, _våren_, --, --, 
   {{0x6fcc612f,0xf2d8c116,0x14acd2a2,0x00000000}},	//   _mobilier_, _mument_, _vozidiel_, --, 
   {{0x73aa1225,0x358a11e8,0xe615e122,0xc56cc003}},	//   _maraming_, _проблеми, _мудири_, _framleið, 
   {{0x8e9050b8,0x59874071,0x13a222a3,0x364920c8}},	// [2d0] _cordless_, _हंसमुख_, _compre_, _촛불문화제_, 
   {{0xeecb40a5,0x52baa044,0xe2896010,0xf0db505f}},	//   _priznaje_, _garedig_, _bashkir_, _طرابلس_, 
   {{0x4eff8063,0xf37a509f,0xebca117e,0x5c7f1231}},	//   _gaojmoob_, _objavio_, _продавни, _tehulky_, 
   {{0xb63aa075,0xb321f07f,0x2c914059,0xca66206b}},	//   _স্বরাষ্ট, _abuya_, _कंडोम_, _вируса_, 
   {{0xd38691fa,0x93ce01ea,0x3e24d033,0x327ec0ac}},	//   _umaru_, _swivi_, _पृथ्वीतल, _redna_, 
   {{0xd2d3407f,0xc25a4043,0xc3b33015,0x00000000}},	//   _dikenali_, _оригінал, _турци_, --, 
   {{0xe20090f5,0x62e800cb,0xf29210af,0x6c77f04d}},	//   _nqaim_, _männer_, _baqala_, _presque_, 
   {{0x2e71d0cf,0xf757c015,0x79c4a0c0,0x1aae60f3}},	//   _लॉन्च_, _jedinstv, _rilevant, _eleksyon_, 
   {{0xfc35e075,0xea1280a3,0x5e3972a4,0xf201e022}},	//   _ইলিয়াস_, _zdravlje, _pelabura, _xatir_, 
   {{0x62b400b2,0x82026081,0x42eb50f3,0x5fcff0c8}},	//   _inici_, _kariya_, _voanews_, _마이페이지_, 
   {{0xe292606a,0x8c80f069,0x3b47c008,0xff1e10de}},	//   _baraza_, _سالگرہ_, _саддам_, _landstin, 
   {{0x562300c4,0xc28af0b1,0xa292406a,0x0786812b}},	//   _naturiol_, _samarali_, _hawana_, _ansvarli, 
   {{0xfa4ba006,0xa2f04022,0x726d91c6,0xf6d8a0cd}},	//   _פלילי_, _colibri_, _mesos_, _лидерлер, 
   {{0xa2a052a5,0x82910032,0xb290b1e3,0x9ed8f129}},	//   _futbal_, _sabato_, _badago_, _berikutn, 
   {{0x4641c015,0x32da50ef,0xa386d06f,0x1d80c0ff}},	//   _старо_, _aptech_, _clerc_, _mövqelər, 
   {{0x76df3140,0x5a1f3089,0xcf63c2a6,0x42eba07a}},	//   _najbolji, _najbolje, _समस्याएं_, _teenoor_, 
   {{0x0b6300c4,0xe099a006,0x12b4e029,0xbce800cf}},	// [2e0] _materion_, _לחסוך_, _benchi_, _अनामिका_, 
   {{0x1f1500de,0xc27e915b,0x9815d030,0xe9840069}},	//   _fortfara, _twana_, _буката_, _دہشتگردو, 
   {{0xc2ea1060,0x9b630044,0xc3ec6007,0x00000000}},	//   _karibin_, _faterion_, _espressi_, --, 
   {{0x17b71076,0x7b09d035,0xfa93c195,0x0f31a193}},	//   _парите_, _サインイン_, _совети_, _konfidan, 
   {{0x36dd9008,0x62bc2017,0x3e0d201e,0x42f0509e}},	//   _мўлжалла, _מליסינג_, _landscha, _kilindi_, 
   {{0xcbda61d7,0xd0d33015,0x6c26a092,0x225a51ae}},	//   _конкурсе_, _власт_, _titulů_, _sylla_, 
   {{0x74a3101e,0xa305a1ea,0xc9c5d01a,0xe2d440ac}},	//   _대구광역시_, _almanak_, _әуезов_, _podobna_, 
   {{0xc224500f,0x820141c0,0x00000000,0x00000000}},	//   _vilka_, _pleiku_, --, --, 
   {{0x43b262a7,0x2fb291cb,0xe212b0f1,0x22caf1cf}},	//   _porque_, _музикант_, _nacht_, _handap_, 
   {{0x1249f2a8,0xe532407d,0x82927083,0x803bd1df}},	//   _nyuma_, _централь, _masaya_, _станал_, 
   {{0x72fcf240,0xbf3880b1,0x2f221017,0xf5016042}},	//   _langar_, _resursla, _מקליקים_, _forestal_, 
   {{0x0f63c1ad,0xb26d800f,0xb3eaf0e2,0x023fc0c8}},	//   _समस्याओं_, _beror_, _mantap_, _사용합니다_, 
   {{0x22be6220,0x5c76d024,0x00000000,0x00000000}},	//   _majdnem_, _छेड़छाड़_, --, --, 
   {{0x5547c075,0xf2f3f1bc,0xec4a713d,0x56e8a151}},	//   _ষড়যন্ত্র_, _didapati_, _pentref_, _国家工商行政管理, 
   {{0xc291e225,0xa85ef0ea,0x82fc7280,0x00000000}},	//   _patay_, _forneced, _lunga_, --, 
   {{0x62018060,0xe29242a9,0x2c18f043,0xcb55c024}},	//   _dayika_, _nawala_, _arranger, _एप्लीकेश, 
   {{0x22e760b9,0xf395812a,0xd27f4267,0x22b4004c}},	// [2f0] _trennen_, _corso_, _emenda_, _unici_, 
   {{0xff58e02f,0xc201e062,0x32918100,0x00000000}},	//   _notammen, _actie_, _haray_, --, 
   {{0x95ae005d,0x127e7104,0x4e40505f,0x73ebf0f4}},	//   _preparaz, _kenna_, _بجامعة_, _lutti_, 
   {{0xb0148035,0x1379105e,0x72927180,0xd8973079}},	//   _このブログの更新, _syaaban_, _hkrati_, _аштерне_, 
   {{0x5b0b5035,0xc2fe4282,0x6c6b2268,0xa2da72aa}},	//   _アプワイザ_, _various_, _टोक्यो_, _bereit_, 
   {{0xfc530022,0x43a2e09c,0x26d3e031,0x87b39016}},	//   _dostuna_, _klippe_, _гордост_, _שאנסן_, 
   {{0xc9f39198,0xb1c3d098,0xa73ba027,0xe36251da}},	//   _неприятн, _говорит_, _tajomstv, _hangoak_, 
   {{0xb386d052,0x720162a0,0x229180cc,0xa7e140e5}},	//   _flera_, _daginn_, _garay_, _परार्थ_, 
   {{0x2c763025,0xef51601e,0xc73b202f,0x0af7c12a}},	//   _मंत्री_, _클릭하시면_, _第二十九条_, _галерия_, 
   {{0x5be281b5,0xfa5c80f8,0x20bf9042,0x00000000}},	//   _херцегов, _হাঙ্গরিক, _plástica, --, 
   {{0x527ed200,0x56f6a033,0xe83831b7,0x00000000}},	//   _kroner_, _सुरवात_, _ястия_, --, 
   {{0x9386d261,0xc26c402d,0xc66730e6,0x7dddc035}},	//   _utorak_, _lumot_, _राजस्व_, _すべての質問_, 
   {{0xa27e7052,0xb2eb31b0,0xc711e071,0x9d37f195}},	//   _denna_, _napisao_, _भद्दी_, _личност_, 
   {{0x22a5f0b5,0x8ceab024,0xb8fb62ab,0xe25a9117}},	//   _станісла, _पाठमाला_, _क्षेत्रा_, _shall_, 
   {{0x827e013d,0x12fcd096,0xa303012e,0xc27e709e}},	//   _meini_, _luego_, _malapit_, _fenna_, 
   {{0x3343617e,0x6349f019,0xb26d9052,0x926e60b3}},	//   _governo_, _resepti_, _resor_, _motory_, 
   {{0x890b10c8,0xe0e9d035,0xcfb92288,0x12486276}},	// [300] _감사드립니다_, _とりあえず_, _métodos_, _ovome_, 
   {{0x425db118,0x42925110,0x726e6196,0x826c003b}},	//   _sprendim, _satana_, _aarone_, _arion_, 
   {{0xec66b0a6,0x172b0038,0x00000000,0x00000000}},	//   _besteht_, _ekspertë, --, --, 
   {{0xe401f0cc,0xa26c2124,0x00000000,0x00000000}},	//   _androgen_, _rukom_, --, --, 
   {{0xd692e113,0xa24a7054,0x6f6c6295,0xcc7c52ac}},	//   _navegaci, _permit_, _vacances_, _guardar_, 
   {{0xf6a2601c,0xc01d003c,0x8c0580c0,0x13a2f104}},	//   _pogledaj_, _もっと見る_, _massimi_, _skipti_, 
   {{0xd2927110,0x73032045,0x3b2f2267,0x1c19b152}},	//   _masana_, _fanacht_, _għajnuna_, _tekstą_, 
   {{0x6290b071,0x83401222,0xcc04709f,0x5c7740aa}},	//   _dodane_, _taberna_, _rođen_, _tutulur_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xa2d95144,0x326e6166,0x3686c07a,0x00000000}},	//   _offert_, _deroga_, _hinderni, --, 
   {{0xc3811083,0x10b800c3,0x12d450a3,0x23334030}},	//   _kanyang_, _געכאפט_, _ljudje_, _албастру_, 
   {{0xcd9d720d,0x7a0b0010,0xf2ebd1d3,0xdc5312ad}},	//   _tunnista, _surakart, _aibidil_, _óptica_, 
   {{0x0753407d,0xbb35a10a,0xa27f00f3,0x9201a096}},	//   _barnehag, _máquina_, _blanch_, _éxito_, 
   {{0xe5e80264,0xb2247074,0x221d20e1,0xd163c008}},	//   _silahlı_, _tinka_, _датум_, _қуруқ_, 
   {{0x430d22ae,0x53f47032,0xd8ff4124,0x00000000}},	//   _pelajar_, _nostro_, _raspolag, --, 
   {{0xf3552087,0x00000000,0x00000000,0x00000000}},	//   _koledar_, --, --, --, 
   {{0xf341503e,0x8b8c32af,0x525b414c,0x00ee90fa}},	// [310] _anderen_, _राजमा_, _quella_, _priniesl, 
   {{0xb3eb81a5,0xa20c9215,0x01660006,0x52916138}},	//   _sarta_, _herhangi_, _איתותים_, _tagann_, 
   {{0xb057c084,0x625b81c6,0xf29110b4,0xc035f027}},	//   _милиция_, _parla_, _macaan_, _svetovej_, 
   {{0xcc16700c,0x5394d087,0xcb7d30b3,0x9386611a}},	//   _मृत्युन्, _prosti_, _finanční_, _flori_, 
   {{0x3bd7618f,0x2f23102d,0xc25b8104,0x43869173}},	//   _जटायू_, _хоразм_, _varla_, _xmary_, 
   {{0xbdbf80c3,0x642e71c2,0x500b9035,0x81a4c024}},	//   _פּרעזידע, _प्रतिभाग, _質問投稿日時_, _dokonać_, 
   {{0x7567e0c3,0x493f00aa,0x0f2242b0,0xe0e10075}},	//   _באַציִונ, _olimpiya_, _stornowa, _হেফাজতের_, 
   {{0xe2cae039,0x320101b0,0xf26e629e,0x72fd629c}},	//   _minden_, _dobije_, _autour_, _leggen_, 
   {{0x4291105e,0x190a717e,0x124a6006,0x0f81f1ad}},	//   _bacaan_, _последен_, _normal_, _धक्के_, 
   {{0xa3eb92b1,0x27c711df,0xcc52c2b2,0xa3fbc075}},	//   _casta_, _начини_, _वारेन_, _স্মার্টফ, 
   {{0xc2fc7026,0x5394906a,0x327f42b3,0xb8542006}},	//   _lungu_, _siasa_, _dienst_, _קרדיטים_, 
   {{0x5373c196,0xf9aac030,0x9fd780be,0x2341c038}},	//   _johanne_, _ловим_, _pretože_, _komento_, 
   {{0x127b71b2,0x0639303c,0x056b51ad,0x0397c0a4}},	//   _komentář, _ブログ内検索_, _napisał_, _medarbej, 
   {{0x130da282,0x025a9043,0xe764c009,0xb9183079}},	//   _מייפל_, _skall_, _पौष्टिक_, _депута_, 
   {{0x287131e8,0xe29080f4,0x4202616d,0x00000000}},	//   _останат_, _kakano_, _darila_, --, 
   {{0x55da61e9,0x00000000,0x00000000,0x00000000}},	//   _проблемн, --, --, --, 
   {{0x719ba0e3,0xd3945045,0x02494193,0xf2bc604d}},	// [320] _консекут, _ailse_, _chemen_, _médias_, 
   {{0x0f4680ff,0x3c7de056,0x00000000,0x00000000}},	//   _konfrans_, _proseso_, --, --, 
   {{0x7fcb00f2,0x65c0f075,0xb39e109f,0xf3fa12b4}},	//   _verindro, _মিশরের_, _stvaranj, _popull_, 
   {{0x7200d1d7,0x839d80ee,0xab0d80ee,0x0248d004}},	//   _toliau_, _proposam, _proposat, _tuomet_, 
   {{0xc2cae02a,0x82e1800c,0xcd03305f,0x17f9208a}},	//   _niiden_, _चौबीस_, _أدناه_, _жартыжыл, 
   {{0xc030c1b0,0xecf741da,0x9fbff004,0x4c66d173}},	//   _prethodn, _sistemar, _асфальта_, _mentsis_, 
   {{0x5e3dd0a8,0xe320b20a,0x00000000,0x00000000}},	//   _долларда, _precios_, --, --, 
   {{0x9b5c42b5,0xb2d900de,0x6cd34092,0xd341c2b6}},	//   _političk, _arbete_, _kvalitě_, _fomento_, 
   {{0xc27f01db,0x62b472b7,0xe2fc50cb,0x13eb81d7}},	//   _abantu_, _cinco_, _richtig_, _karto_, 
   {{0x53ebe03e,0x3c60f29c,0x52025140,0xb26a2151}},	//   _hatte_, _minuten_, _istina_, _编辑个人资料_, 
   {{0x1519f17e,0xedbce057,0xb26cf2b8,0x597a624a}},	//   _рецепта_, _athanase_, _tugon_, _продемон, 
   {{0x1249421c,0x726de16d,0x025a6087,0xce431128}},	//   _themen_, _letos_, _okoli_, _kalagaya, 
   {{0x7b83e02e,0xf4db302a,0x12787134,0x00000000}},	//   _दुसमन_, _обратить, _jeunes_, --, 
   {{0xddfb20c3,0xb33c20b5,0xd2da70ac,0x2d28c043}},	//   _אַלגעמיי, _слёзы_, _besede_, _називают, 
   {{0x5f25b1bb,0x4a6a21be,0xc2959251,0x93ced260}},	//   _selecion, _प्रशस्त_, _स्लोली_, _reeve_, 
   {{0x83ead034,0x101fa031,0xc1dcd09f,0x429261ad}},	//   _mentre_, _endereço_, _istovrem, _sprawa_, 
   {{0x19f9e050,0xfc7ca0cc,0xf26d8199,0x1f2bb05f}},	// [330] _tavalise, _seksyon_, _kandidát, _انتهاء_, 
   {{0xbe19f2b9,0x030de07f,0x4399c293,0xa5797118}},	//   _menemuka, _sekadar_, _læste_, _матэрыял, 
   {{0x82cae14e,0xdf4db0c3,0x2212b06a,0x5236c2ba}},	//   _vendet_, _מיזרח_, _machi_, _biljke_, 
   {{0xf386d2bb,0x7236722b,0xd26dc0a6,0x00000000}},	//   _flere_, _monja_, _bevor_, --, 
   {{0xfdbca12e,0x1b11410f,0x3f80b0a4,0x2f514033}},	//   _pilipina, _kampanya_, _placerin, _kampanye_, 
   {{0xc2927225,0x3c29a0dc,0x3bcc5171,0x00000000}},	//   _masama_, _agosetos, _priekšā_, --, 
   {{0x5c05a0b3,0x5ea6a07d,0x130d2048,0xc3ea60d7}},	//   _rubriky_, _fortsatt_, _pelapor_, _vyote_, 
   {{0xbd8d5057,0x53ebf08b,0xd097e12a,0x5690709c}},	//   _demokara, _haute_, _франция_, _landbouw, 
   {{0x02f7c019,0xdc7511dd,0xcdd040f5,0xdf4511dd}},	//   _никогда_, _ernstig_, _motherna, _ernstige_, 
   {{0xf35f3045,0x63023044,0x4fd2b0a2,0xef41c17b}},	//   _taighde_, _ariannu_, _सारगर्भि, _prosince_, 
   {{0xb63361c1,0x22d4c1c1,0x638690b1,0x226d20b1}},	//   _stanovni, _priliku_, _zlari_, _buyon_, 
   {{0x9e66d0a1,0x5340a032,0xd1ad71e6,0x02b6b06d}},	//   _мультиме, _diventa_, _kazandır, _derdixe_, 
   {{0x6bc4e024,0xc2267236,0x426d8095,0xd369c010}},	//   _होम्योपै, _virker_, _otrov_, _cangkir_, 
   {{0x656e3119,0x01513079,0xfb5c41c1,0x427e70a6}},	//   _компьюте, _струс_, _političa, _kennt_, 
   {{0xf2fce170,0xf5190193,0x77a86190,0x92e712b0}},	//   _pengen_, _eternulo_, _erstatni, _amannan_, 
   {{0x7c5e607b,0x5c7c72bc,0xcdae6133,0x7c6f01b1}},	//   _portál_, _glasova_, _portálu_, _korrika_, 
   {{0x150bf091,0xc0480045,0xa6f80045,0xb2f7d0e6}},	// [340] _postavio_, _موضوعي_, _موضوعك_, _उजुरी_, 
   {{0xe5b19106,0x10951022,0x8c0d7204,0xd27ec299}},	//   _technoló, _hadisələ, _tampere_, _ledna_, 
   {{0xc77f502f,0x127e02bd,0x7bfd5004,0x38a3b05f}},	//   _请输入上图中的验, _ating_, _balandži, _بينهما_, 
   {{0xd3eb81ad,0x22ecb006,0xdf1e0016,0x7e57920e}},	//   _warto_, _למכשירים_, _רוסישער_, _металург_, 
   {{0x212d3023,0x7305c010,0xb100801a,0x612d30cd}},	//   _сайти_, _اوراق_, _пәнінің_, _балта_, 
   {{0xabf511b2,0x03eb91c1,0x7349e053,0xd26cc270}},	//   _produktů_, _zasto_, _bererti_, _komoly_, 
   {{0xdb43c1de,0x246140f6,0x329262a2,0x328c10ba}},	//   _اُردو_, _baldintz, _sprava_, _uhakika_, 
   {{0xf3eb8134,0x827e0240,0xef4e011a,0xd3cec158}},	//   _carte_, _beint_, _persoane_, _jedva_, 
   {{0x01013015,0x38ab702f,0x8228325f,0x6bfb702f}},	//   _свети_, _第二十一条_, _söker_, _第二十三条_, 
   {{0xaad712be,0xe2eb114c,0x8490e2bf,0xa46510fe}},	//   _litterat, _periodo_, _गनीमत_, _ditetapk, 
   {{0x828d4034,0x2dafd09f,0x82255188,0x00000000}},	//   _appartam, _smatraju_, _liekas_, --, 
   {{0xd25ad027,0x1386d1d4,0x1a080216,0x8b39a023}},	//   _biely_, _acordo_, _verbesse, _повороте_, 
   {{0x39d0a0e5,0xc3866183,0xdfe82024,0xe8104151}},	//   _investee, _moord_, _रिलायंस_, _分类精彩知识问答_, 
   {{0x42fba032,0x222491ae,0xa24c524f,0x0b6d3095}},	//   _потребит, _tiako_, _पायलट_, _razmiric, 
   {{0x1ca66182,0x325b6111,0xfdd0c243,0xab614194}},	//   _журналіс, _anglii_, _острови_, _billiger, 
   {{0xd386609c,0x026d8005,0xd18c011b,0x00000000}},	//   _noord_, _stron_, _мукаммал_, --, 
   {{0xe2075288,0x025b80fd,0x80330031,0x63247069}},	// [350] _democrát, _varle_, _postagen, _nézni_, 
   {{0xc9058009,0xe3eae25e,0x354781eb,0xa178c0b9}},	//   _sekaligu, _mintha_, _үлгүсү_, _rechèch_, 
   {{0xc2cb82c0,0x0d0a1103,0x7ad630e6,0x22da5081}},	//   _tarde_, _तत्वाधान_, _कच्ची_, _intego_, 
   {{0xb2b47045,0xc2eb5082,0x00000000,0x00000000}},	//   _rince_, _orjinal_, --, --, 
   {{0x02ec002e,0x8c00d121,0x1a8cc19c,0xbc01c023}},	//   _भाषीय_, _دخالت_, _retnings, _alisher_, 
   {{0xeb42c289,0x0c0bd145,0x2bcf3129,0x7989e293}},	//   _екипи_, _najbližš, _श्रीमंत_, _forholde, 
   {{0xcc77409a,0x06d2b03f,0x5db4205f,0x7a8e9033}},	//   _cyumweru_, _धादिङ_, _موقوف_, _changmin_, 
   {{0xa2245146,0xa8ba4084,0x8290c183,0xa26c7095}},	//   _dilka_, _колледжи_, _eiland_, _punom_, 
   {{0xac5c2006,0xa283f027,0xf3800151,0x5425416b}},	//   _ספונטני_, _funkcia_, _常州组织工作_, _dezinfik, 
   {{0x427ee144,0x627f71fe,0x03656108,0x3e3b20fd}},	//   _kvinna_, _imanza_, _съвремен, _remontas_, 
   {{0x927f711e,0x538691d8,0xc2cbf140,0x690cc02a}},	//   _chante_, _claro_, _grudi_, _покупате, 
   {{0xd9dd81c1,0x25eda016,0xad59a26c,0x2d70a2b0}},	//   _zemljama_, _טיקעט_, _sainmhín, _achmhasa, 
   {{0x7200c01b,0x8532e03c,0xf27ed123,0xb4a40017}},	//   _bilind_, _この回答へのお礼_, _kronor_, _באשדוד_, 
   {{0xfa8a9112,0xd20252c1,0xd290f1b4,0x0ebd020b}},	//   _августа_, _artigo_, _yohane_, _apsolutn, 
   {{0xf8fbd07b,0xe291e2c2,0x53eac046,0xdb6e306b}},	//   _mojasvad, _batay_, _tamtay_, _лиценцом_, 
   {{0x73f46194,0x85532079,0x00000000,0x00000000}},	//   _morten_, _андрееск, --, --, 
   {{0xfb0ae2c3,0x5292502d,0x930d10b4,0xe255d033}},	// [360] _conselle, _parchasi_, _dumasar_, _यथादृश्य_, 
   {{0x2d865048,0x6395f232,0x79d762c4,0xd2d8e20a}},	//   _permaina, _fluss_, _सामयिक_, _quiere_, 
   {{0xff5b70b1,0x626de03c,0xd9d3e072,0x00000000}},	//   _samarqan, _netop_, _борбор_, --, 
   {{0xe31a1083,0xbb1780bc,0x4aea61f1,0x16039043}},	//   _sariling_, _kakarets, _fortelle, _поверх_, 
   {{0xf2fce0e2,0xf26d00a5,0x82caf071,0xae006206}},	//   _dengan_, _subota_, _nigdy_, _donderda, 
   {{0xd2ce5050,0x707d3122,0xd300c037,0x286e41ae}},	//   _reklaam_, _баҳси_, _infatti_, _herinand, 
   {{0x437800cc,0x53f94100,0x02d462c5,0xe347c0d2}},	//   _subasta_, _ordusu_, _jorden_, _menduar_, 
   {{0x8394d188,0x42926052,0xdd0550e5,0x5ba530f1}},	//   _tiesa_, _totalt_, _populaar, _praktisc, 
   {{0xd75c0016,0xb2b511c8,0xe213e1ba,0x5a4a30bf}},	//   _ספינקא_, _vendeve_, _lithi_, _परिषदको_, 
   {{0x101a21c1,0x284a31ca,0xf63eb1e6,0xbec621de}},	//   _životinj, _жокко_, _hamileli, _نکلنے_, 
   {{0xac4d7256,0x5d1e2245,0xe8dce07f,0xb49e6116}},	//   _privacy_, _monoxide_, _bergantu, _apparenz, 
   {{0xe24800a5,0xb378313c,0xaa00828c,0x02027161}},	//   _svima_, _temenê_, _dasarnya_, _scrios_, 
   {{0xe386c1f1,0x20d24008,0x00f2b275,0x42494134}},	//   _aldri_, _farovonl, _सजावट_, _chemin_, 
   {{0x9c4991cb,0x42d20036,0x5ede2127,0xe5b420c3}},	//   _реколта_, _marekani_, _зиёда_, _גאזאלין_, 
   {{0xdc5bf09f,0x9981717e,0xad3e1006,0xb2cbf2c6}},	//   _postovi_, _equipame, _שוטרים_, _poslovi_, 
   {{0x225ac013,0x2458f171,0x00000000,0x00000000}},	//   _fillon_, _ikdienā_, --, --, 
   {{0x018930ce,0xa22a815c,0x4380d063,0xff945043}},	// [370] _مقاطع_, _niemand_, _havzoov_, _величезн, 
   {{0x71541006,0x92ddc07d,0x42c5900c,0x228e1017}},	//   _בניגוד_, _трохи_, _inglise_, _בודפשט_, 
   {{0xe33d321f,0x2afe80a9,0xf28810cd,0x3fc9a122}},	//   _حیران_, _aparteme, _айран_, _бардошта, 
   {{0x5847c147,0x8394e19e,0xf2fc7131,0x180bc024}},	//   _талаби_, _toisen_, _kungi_, _मिज़ोरम_, 
   {{0xd35bf181,0xf9667164,0xb5811114,0xb2ca7240}},	//   _उद्देश्य_, _natoplje, _европада_, _mynda_, 
   {{0x72d9a078,0x1ad6a01c,0x5476b29c,0x1ed642c7}},	//   _revele_, _čekajući_, _gisteren_, _mientras_, 
   {{0x42f12087,0x6a898023,0x00000000,0x00000000}},	//   _očitno_, _сайланга, --, --, 
   {{0x9dafd01e,0x53954145,0xf5d07171,0xbe541179}},	//   _가맹점가입안내_, _miesta_, _komentēt_, _ostavile_, 
   {{0x620110b3,0x4ceb3169,0xe87ba12a,0x00000000}},	//   _mobilu_, _मुहम्मद_, _известна_, --, 
   {{0xb1e3c169,0x926d80ac,0xc26c4089,0x62cae2c8}},	//   _उतारा_, _otrok_, _samog_, _pandai_, 
   {{0x9c26c015,0x32b491c1,0xdaf72102,0x3394b2c9}},	//   _природе_, _znaci_, _материй_, _pjesme_, 
   {{0x53f4729c,0x8033d17e,0x5291814a,0xce98c182}},	//   _kosten_, _помогне_, _hayaan_, _маршрута, 
   {{0xc25b40fa,0x43a0b042,0x92c5c034,0xb27e725e}},	//   _nielen_, _máximo_, _чувствит, _menni_, 
   {{0x250b91bb,0xd233c03c,0x1581f1dc,0xb3ebf1cb}},	//   _saturado_, _ショッピング_, _berdimuh, _cauta_, 
   {{0xc2b4d197,0xe224d0fd,0x55beb0b2,0xdc1c0006}},	//   _nieco_, _nieko_, _аппаратт, _מפתחים_, 
   {{0x1f6971fb,0x9758e1d6,0x00000000,0x00000000}},	//   _sembaran, _चमत्कार_, --, --, 
   {{0xe1fd60ce,0xb2911108,0x8603c094,0x626ab1a2}},	// [380] _ballstái, _locale_, _зойиров_, _učiniti_, 
   {{0x625a904e,0x9047c2ca,0x52a7c0fd,0x52f0d055}},	//   _nyala_, _законом_, _законам_, _viginti_, 
   {{0xb3947086,0xe7d96210,0xe20da298,0xa39490f2}},	//   _jinsi_, _критерий, _ויקהל_, _hiasa_, 
   {{0xe27f71de,0x3afa2229,0x926ce2cb,0x1526817e}},	//   _tegnap_, _razumije, _sgioba_, _стабилно, 
   {{0x327ee109,0x23a3705e,0x0f5b70e2,0xfd9e0151}},	//   _bainne_, _suapan_, _memandan, _belgique_, 
   {{0xf3949178,0xe25e2188,0xb9b8a12a,0xa081f07d}},	//   _miasa_, _ventspil, _ситуация, _інноваці, 
   {{0xc3d122cc,0xa3fb600f,0x7b1fc255,0x9c1be01a}},	//   _história_, _människo, _kematian_, _ойдағыда, 
   {{0x03eb91f2,0x6ed07255,0x22d5a2cd,0x739e109f}},	//   _hasta_, _penyakit_, _millət_, _otvaranj, 
   {{0x8ab4202e,0x43dc406a,0xb2d8e20f,0xb25bf072}},	//   _चौकड़ी_, _kamwe_, _aineol_, _taula_, 
   {{0x12cac052,0xb30a10de,0x66c7d2ce,0x0ac980c5}},	//   _bilden_, _fotboll_, _пропала_, _रूपरेखा_, 
   {{0x038602cf,0x1416a02f,0x439470c7,0x02b4704c}},	//   _toirt_, _依法追究刑事责任_, _cinsi_, _cinci_, 
   {{0x62f16075,0xf3ebe023,0xf0fe10c3,0x42d9a285}},	//   _উপভোগ_, _hatto_, _צוטאגס_, _typer_, 
   {{0x1a4350c8,0x73c70045,0x00000000,0x00000000}},	//   _찾아오시는길_, _corparái, --, --, 
   {{0x5d983147,0x7b035098,0x9a968171,0xfc0c0143}},	//   _нестанд_, _prosentt, _novembrī_, _webshop_, 
   {{0x16242277,0x62da524e,0xc200e0d1,0xeda2d069}},	//   _økonomis, _inteko_, _único_, _فائنل_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x7d76d065,0xef6f2033,0x2f27118e,0x8fd0b0c1}},	// [390] _فرانس_, _कलादालन_, _ikaretsa, _postiže_, 
   {{0xb27e80e6,0x5b4a8114,0x329241cf,0x00000000}},	//   _denně_, _касалхон, _sawala_, --, 
   {{0x8487324b,0x22e85087,0x573e824a,0x85d9d079}},	//   _स्टाइल_, _naslednj, _востаннє_, _анализэ_, 
   {{0x14d4d0ed,0x82d5b1fa,0xcc6bc023,0xe3dbc023}},	//   _कोचिंग_, _obulamu_, _hukumat_, _hukumati_, 
   {{0x00f11138,0xf4173294,0x00000000,0x00000000}},	//   _الطعام_, _menschen_, --, --, 
   {{0x8d0f2121,0xb146f084,0x1cfdc0dd,0x916f305f}},	//   _بارسلونا_, _ingresso, _прича_, _نماذج_, 
   {{0xb290f262,0x0ce4f092,0x19310100,0x737a2083}},	//   _triall_, _podobně_, _heyəti_, _basahin_, 
   {{0xf27f714d,0xfd810038,0x33a01017,0x8d2e700c}},	//   _mwanza_, _realizua, _מצליחה_, _analüüsi, 
   {{0xa2e9e2a9,0xc760101e,0x9e753125,0x82480057}},	//   _peligro_, _크리에이티브_, _दिग्दर्श, _ndimi_, 
   {{0xcceec16b,0x28c351e9,0x3200a09f,0x93d94005}},	//   _америке_, _генераль, _knjigu_, _tematów_, 
   {{0xb3eb0053,0x86aed150,0xebf3d27a,0x00000000}},	//   _apatah_, _nagustuh, _ymhellac, --, 
   {{0x8a63605c,0xd1841262,0xa106e1a9,0xd2026083}},	//   _интереса, _sheasamh_, _mechthil, _narito_, 
   {{0x027f707a,0x83e16010,0x0e46e023,0x00000000}},	//   _maande_, _ditutupi_, _beradiga, --, 
   {{0xd27f7086,0x1f62806e,0x6379009a,0x00000000}},	//   _kwanza_, _संस्थाएं_, _basanga_, --, 
   {{0x9bc7d167,0x2e97607f,0x34d71072,0x7c5c104d}},	//   _продаж_, _permohon, _баскан_, _gestion_, 
   {{0x7200b2cb,0x3209d024,0x43dd909a,0xb2f312d0}},	//   _ridire_, _परिजनों_, _ruswa_, _bonitet_, 
   {{0x4a3b210a,0x33954037,0x3fcfd2c6,0x03957053}},	// [3a0] _студии_, _questi_, _ministar_, _ulasan_, 
   {{0xc9fe404e,0xec51f1fb,0x6197812a,0x637fd03b}},	//   _parament, _cantona_, _групата_, _einasta_, 
   {{0xf20802d1,0xb301718f,0x8c055142,0xc8caa0eb}},	//   _informác, _स्निग्धा_, _choroby_, _статуса_, 
   {{0x9290b19c,0xe4d7c152,0x2753e015,0x9440d191}},	//   _vidare_, _балконы_, _рехабили, _قلمروی_, 
   {{0x08fdd085,0x73f90121,0x0e1dd122,0xf7beb02f}},	//   _ফলাফল_, _gabung_, _иҷроияи_, _违者本网将依法追, 
   {{0x46011138,0xec52718a,0x29cd32d2,0x825a9240}},	//   _بنفسك_, _amatora_, _ढाँचा_, _skalt_, 
   {{0xe27f7057,0xdfa112d3,0x93b11113,0x14f8c151}},	//   _mwanya_, _servizos_, _servizo_, _第四十二条_, 
   {{0xcf0b0288,0x4ae2f138,0xc3e5a171,0x69c41053}},	//   _promover_, _pholainn_, _oktobrī_, _wallahua_, 
   {{0xc26c2196,0xf2e81242,0x3c537089,0xaf5bf01f}},	//   _eskom_, _jacinta_, _nastupa_, _fijalian, 
   {{0x50b5f024,0x5f628047,0x526df00c,0x00000000}},	//   _चाकुओं_, _संस्थाओं_, _autod_, --, 
   {{0x52f071ac,0xb77b8138,0x4c53e030,0x668d6103}},	//   _danieli_, _tromchúi, _албастрэ_, _बनवास_, 
   {{0xb201811a,0xb25a908c,0x73431033,0x52e3c185}},	//   _scris_, _fjale_, _तिथून_, _रजनीश_, 
   {{0x563c919c,0x5e52901e,0xd9d6317f,0xd2fc90a4}},	//   _літерату, _써브를시작페이지, _натурал_, _fragt_, 
   {{0x2ca620cd,0x8a715140,0xb2f151c1,0x19bed05f}},	//   _барсан_, _članova_, _članovi_, _تحشيش_, 
   {{0x9394719c,0xefc0002f,0x174c305f,0x00000000}},	//   _minst_, _提问者对于答案的, _العفو_, --, 
   {{0x72cae29c,0x8394d030,0xc3dc10f5,0x2c4cb03f}},	//   _vinden_, _piese_, _tshwm_, _partneři_, 
   {{0x32fc72c5,0x32cff02f,0x426e6032,0x3485900c}},	// [3b0] _mange_, _只显示最新_, _parole_, _दिवाना_, 
   {{0x62dab1b3,0x97280043,0x5224b0d2,0x7386d106}},	//   _oktobar_, _продукці, _dicka_, _utorok_, 
   {{0x62bb1027,0x600d20a7,0xac773176,0x884d227e}},	//   _balenie_, _vatandaş, _mensahe_, _destinos_, 
   {{0x1beec23d,0x8f550040,0xc37a70f1,0x727ef019}},	//   _малой_, _kompanya, _betalen_, _kunnes_, 
   {{0xac5250f2,0x2956a019,0x69241122,0x00000000}},	//   _aretina_, _sellaine, _ояндасоз_, --, 
   {{0xb9403069,0xa292618e,0xab99a064,0x32fc910f}},	//   _اپريل_, _karama_, _тарапына, _irtibat_, 
   {{0x54dac19e,0x72458133,0x2d3631ee,0x6387f08b}},	//   _можно_, _rámci_, _افروز_, _heure_, 
   {{0x17a201b1,0x59d20155,0x468120e6,0x10d471d7}},	//   _interesg, _interest, _ज्यान_, _ангельск, 
   {{0x286d72d4,0x020252d5,0x526d7110,0x2ebd708c}},	//   _personas_, _estivo_, _ataona_, _personat_, 
   {{0x734c40fa,0xebf51004,0xd6ec205f,0x9378112f}},	//   _francúzs, _produktų_, _وتصميم_, _vacanta_, 
   {{0xd26c2095,0xb9d7a00c,0x3ec00148,0xaec7c07b}},	//   _nakon_, _प्रयास_, _zabezpeč, _vzdialen, 
   {{0x327e0177,0xc89ac11a,0x23f4611e,0x42fc71fa}},	//   _duine_, _стихией_, _mouton_, _nange_, 
   {{0xf9aac0b1,0x2280b0f3,0x2fc4c0ed,0x8fa0a191}},	//   _мобил_, _diskite_, _अधकचरा_, _رجیستری_, 
   {{0x61901008,0x02cbf0f6,0x7defd0c8,0x00000000}},	//   _mahalliy_, _gaude_, _하이파이브_, --, 
   {{0xc9b1424c,0xbe714148,0xef24009f,0xbfa0b21b}},	//   _ostatní_, _ostatné_, _došao_, _novembar_, 
   {{0xcc93c045,0x1cf74098,0x517e026f,0xf975d00c}},	//   _ساعات_, _электрич, _поколени, _एसोसियेश, 
   {{0x13433138,0x117da006,0xe2da6068,0xc250e134}},	// [3c0] _والذي_, _קיבוץ_, _derece_, _directem, 
   {{0xf84c201e,0x9c18f060,0x950a4179,0x8e77d093}},	//   _있었습니다_, _beramber, _protivio_, _сауықтыр, 
   {{0xf6048075,0x44ce4015,0x23d00016,0x60e4d268}},	//   _সাবস্ক্র, _написани_, _הצניעות_, _आईसीसी_, 
   {{0xd2fc909a,0x99fa413e,0xedd9b182,0x91c9224a}},	//   _isaga_, _pershend, _схемах_, _кошти_, 
   {{0x5b1c00c8,0xbe0200f3,0x1c532109,0xee7c619d}},	//   _적극적으로_, _enteresa, _chatain_, _पॉर्न_, 
   {{0xc61a702f,0xd19b52ac,0xb29270ac,0x48d741de}},	//   _评论内容只代表网, _mercadol, _shrani_, _ناگزیر_, 
   {{0x5290b0e5,0xd3950007,0x0493e07d,0xae0c4035}},	//   _endale_, _prassi_, _стратегі, _バでブログを書こ, 
   {{0xcb9090c3,0x22d9109c,0x22254206,0xb4e800c3}},	//   _סטודענטן_, _gebeur_, _boeken_, _טערמין_, 
   {{0xdb57c01f,0x1577c01f,0x9c47718a,0xd9e890b0}},	//   _fantatra_, _fantatro_, _intwaro_, _thegioit, 
   {{0x0548a07d,0x794e4088,0x00000000,0x00000000}},	//   _листопад, _質問した人からの, --, --, 
   {{0xfbf1f103,0xd6d072d6,0xf793d008,0x8fe142d7}},	//   _postitus, _जैविक_, _йўлнома_, _maskiner_, 
   {{0xa1ff7118,0x6c381148,0x920e2084,0x011961c6}},	//   _papildom, _generáci, _качат_, _эгемендү, 
   {{0x93dc92d8,0xbcd3201e,0x52fc909a,0xff6091f8}},	//   _asawa_, _부담하셔야_, _asaga_, _יאָאַכים_, 
   {{0xd23650a3,0xbb89d2d9,0x8ae6b23a,0x1a179017}},	//   _voljo_, _noviembr, _parlimen_, _calculat, 
   {{0x1301f0c4,0xbd5820cd,0x72017045,0xbdbf80b1}},	//   _paratoi_, _кетсек_, _cnaipe_, _muhabbat_, 
   {{0x7f06002f,0xe25bf171,0xc2331288,0xd00b3075}},	//   _采煤工作面_, _saule_, _formado_, _চাঁপাইনব, 
   {{0xd29210dc,0x81521151,0xad03926f,0x2a2a621c}},	// [3d0] _inpact_, _已经本网协议授权, _регулярн, _maschine, 
   {{0xf3c32045,0x52da52da,0x326c2038,0x45a6d02a}},	//   _عُمان_, _hotell_, _takon_, _классиче, 
   {{0x32c381b0,0x23cf80a2,0x8bf7c1cb,0xdd5ac0fd}},	//   _ukoliko_, _terve_, _билете_, _болей_, 
   {{0xe2ea20bc,0x72fc61ad,0xdc5ae2a4,0x427e629c}},	//   _lebitso_, _drogi_, _khutbah_, _stond_, 
   {{0xe33cc14c,0x1a7391a2,0x226c21da,0x1fd39017}},	//   _близо_, _obično_, _sakon_, _פנסיה_, 
   {{0x88db113d,0xd6015006,0x364cb258,0x9f4a22db}},	//   _gwleidyd, _commerci, _मण्डल_, _रामधारी_, 
   {{0x09b732dc,0x72fce276,0xb3b5e1b5,0x00000000}},	//   _polasaí_, _stigla_, _čoveka_, --, 
   {{0x0e553248,0xd2da6155,0x73ced1fa,0x8cbec079}},	//   _महत्वपूर, _reports_, _leevi_, _базей_, 
   {{0x67a8211a,0x1201f18a,0x0c70a2db,0xe2947230}},	//   _februari, _muziko_, _मुर्गा_, _funkcii_, 
   {{0x93fac14c,0x726dc0e1,0xaf83c0c5,0xcc5490f1}},	//   _вторник_, _prvog_, _लश्कर_, _korting_, 
   {{0x658ed100,0xdc7102dd,0x8ee920fe,0x00000000}},	//   _akademiy, _मान्छे_, _berkuran, --, 
   {{0x525a0247,0x330cc053,0xa29271a6,0x83eb7084}},	//   _exile_, _isyarat_, _masaka_, _teatre_, 
   {{0x199900a5,0x174c6024,0x726d101c,0x9ec5c195}},	//   _traži_, _poniżej_, _guzom_, _славни_, 
   {{0xeae2f0a5,0xb41fe01c,0xbadf4008,0x888fe114}},	//   _pretpost, _psiholoz, _delegats, _psixolog, 
   {{0x43ebe02d,0xbef08004,0xdbfb819f,0x1a6700c8}},	//   _katta_, _elektrin, _фольклор, _드리겠습니다_, 
   {{0x020801f3,0xac61514e,0x521c6011,0x320260f2}},	//   _informát, _situata_, _nathis_, _tarika_, 
   {{0x425be04e,0x9d3630fb,0xf25a90d0,0x626ca2b8}},	// [3e0] _matla_, _кантип_, _ukali_, _lubos_, 
   {{0x126d825d,0xfbf131de,0xded800b3,0xed5ac094}},	//   _otros_, _بھگدڑ_, _princezn, _роҷеъ_, 
   {{0x729b70ef,0x406da006,0xb94de075,0xba34d035}},	//   _linkhay_, _הסיבה_, _ধারনা_, _をご覧ください_, 
   {{0x03fc105d,0x02cae0b1,0xf200a1e0,0x2d038240}},	//   _naturali_, _dindan_, _ambil_, _bolungar, 
   {{0x63eae22f,0x738d6065,0x82e0619b,0xe27c20ef}},	//   _lantai_, _kulturál, _jednako_, _lênin_, 
   {{0x00e1a017,0xdaecd017,0x00000000,0x00000000}},	//   _לדאוג_, _accessib, --, --, 
   {{0x22da7052,0x9dc77297,0xa3ebe1a6,0x1f5d10c7}},	//   _adress_, _hihihehe_, _batta_, _kitabxan, 
   {{0x5faa502f,0x73cf0031,0xf13ba017,0x00000000}},	//   _字母不区分大小写_, _gravar_, _ללחוץ_, --, 
   {{0x87d0d23d,0x726cb2c6,0x33545069,0x41458203}},	//   _снегу_, _radova_, _بہتیرن_, _בושות_, 
   {{0x32cbf03d,0x8fcc5138,0x00000000,0x00000000}},	//   _nauda_, _trína_, --, --, 
   {{0x77fd0045,0x4b2ad0eb,0xb051d128,0x00000000}},	//   _اتفاقية_, _сцене_, _panginoo, --, 
   {{0x64b9a1cb,0x52fc9173,0x43e58071,0xb26c5038}},	//   _деметра_, _iragi_, _wątek_, _kalon_, 
   {{0x225bf132,0x74d690e6,0xfb2b225e,0x9b5ed05c}},	//   _kaula_, _मिडिया_, _paradics, _брани_, 
   {{0x3291425f,0x62d85065,0x8373a0ac,0x60761138}},	//   _endast_, _meleg_, _domače_, _seapáini, 
   {{0x23869052,0x764f20b2,0x62bbd05b,0x5dd2d019}},	//   _klart_, _аппараты, _bekende_, _стало_, 
   {{0x02fd7045,0xd27ed191,0xc3f1a03a,0x47132069}},	//   _leagan_, _adonan_, _मध्यस्थत, _تھوڑی_, 
   {{0xee5180a9,0x8037312a,0xc30eb123,0xfa03b016}},	// [3f0] _काव्यप्र, _ristoran, _betalar_, _פרוכט_, 
   {{0x13875047,0x6fb08114,0x62026121,0x665d4024}},	//   _oferty_, _иборат_, _miring_, _समाधि_, 
   {{0x32fca10a,0x00000000,0x00000000,0x00000000}},	//   _pedidos_, --, --, --, 
   {{0x0624b1ab,0xf20261ce,0x022501ea,0x0c83505f}},	//   _مناسبت_, _carian_, _shakur_, _بصراحة_, 
   {{0x62fd7109,0x1b26c0eb,0x00000000,0x00000000}},	//   _beagan_, _одбор_, --, --, 
   {{0x427e9138,0xf22460f2,0xa84710f9,0x00000000}},	//   _seans_, _azoko_, _фараби_, --, 
   {{0x11cc3038,0xeaa64099,0x6f1fa2de,0x0ff31005}},	//   _policisë_, _राज्यसभा_, _vurderin, _कलाकारों_, 
   {{0x3aa1c099,0xeeefc0e1,0x115d10af,0x22926010}},	//   _licytuje, _одобри_, _adiology_, _kirang_, 
   {{0x726c509d,0xa3786083,0x115fc0e1,0x23dd9063}},	//   _galon_, _maganda_, _односи_, _ntsws_, 
   {{0xcf33c085,0x43b9a2df,0xb957219e,0xdaf3c006}},	//   _presenta, _serveru_, _edelline, _presente, 
   {{0xa2926083,0x62b63079,0x9a4f41b4,0x70edc0f0}},	//   _paraan_, _антериор_, _haleluya_, _озгина_, 
   {{0x84b3a121,0xd20e1147,0xe3947057,0x240e72e0}},	//   _تمرینات_, _дарак_, _minsi_, _zadržana_, 
   {{0xc650d033,0x32ca70da,0x785e1035,0x2da11050}},	//   _शब्दापुढ, _myndi_, _産学連携本部_, _fotograa, 
   {{0xf30a5246,0x206d8124,0xd92c50af,0x5e4f60fe}},	//   _najnovij, _propisan, _adimilwe, _kegagala, 
   {{0xe48740ed,0x526d8112,0x08dd903c,0xb201a124}},	//   _नाजायज_, _euroa_, _ベストアンサ_, _novine_, 
   {{0x69bce032,0xd1868230,0x00000000,0x00000000}},	//   _коментир, _otvoriť_, --, --, 
  
   {{0x77f22198,0x53a1d19e,0x00000000,0x00000000}},	// [400] _дърво_, _kaupunki_, --, --, 
   {{0xd485200c,0xc2fc7110,0x0d7bf1a8,0x9103109f}},	//   _संपादक_, _zanga_, _комитеті, _građana_, 
   {{0x1097e00e,0x03eb9005,0x2677203c,0xac5280f3}},	//   _времени_, _listy_, _高等専門学校_, _haitian_, 
   {{0x039501f5,0xa0ce70e1,0x127e0006,0x00000000}},	//   _časti_, _sadržaja_, _bring_, --, 
   {{0xe387e084,0x02026060,0x6a7041d0,0xa72c12e1}},	//   _altra_, _giring_, _amygdala_, _miloševi, 
   {{0xa14522b2,0xf98360e5,0x3cf02005,0x1200d29e}},	//   _materjal, _konkreet, _युवकों_, _milieu_, 
   {{0x2224018c,0xc27e60ef,0xf37860f4,0x11bc1119}},	//   _usiku_, _huong_, _baganda_, _täynnä_, 
   {{0xd2cb4062,0xf4a6819d,0x5d00c0f8,0x00000000}},	//   _bieden_, _सौराष्ट्, _পরাজিত_, --, 
   {{0x4394d0fa,0x7a5d20fe,0x875440e2,0xe2fc30b1}},	//   _miest_, _diterima_, _keuntung, _palatasi_, 
   {{0x7c69f00b,0x3948f14c,0x03c871a1,0xcfbd70b1}},	//   _burundi_, _комплект_, _tervis_, _партияси_, 
   {{0xa2b5812a,0x175d0287,0x5236d1ce,0x427ef095}},	//   _circa_, _कार्ड्स_, _projek_, _skinem_, 
   {{0x6e4242d2,0x49c192e2,0x62ca3050,0xd25ae098}},	//   _संस्थाहर, _साँचो_, _üldse_, _meille_, 
   {{0xcedb91e0,0x0c4b1010,0x4f859017,0x72d302a4}},	//   _kenyataa, _lintang_, _מורשה_, _mestilah_, 
   {{0x434d526d,0x4e0b10cf,0x92fc7110,0x026ca039}},	//   _महसूस_, _प्रीमियम_, _wanga_, _újonc_, 
   {{0x742a6019,0x62ea6032,0x253b9255,0x62014027}},	//   _правильн, _affitto_, _menyatak, _vidiet_, 
   {{0x627e612e,0x72926010,0x7b1971a7,0xc1897128}},	//   _buong_, _pirang_, _barangan_, _barangay_, 
   {{0x72d82030,0xb7bbb006,0x8226d05f,0x13788100}},	// [410] _camere_, _בפועל_, _مراكز_, _kazanda_, 
   {{0x2ea7310e,0xe394d03d,0x4c18e060,0x161b80ce}},	//   _parleman, _viesu_, _seranser, _parlaimi, 
   {{0xc39400b1,0x00000000,0x00000000,0x00000000}},	//   _raisi_, --, --, --, 
   {{0xf26df098,0x2c6210aa,0x8a9aa033,0xd394000e}},	//   _auton_, _forumun_, _दुसऱ्या_, _saisi_, 
   {{0xae38f216,0x648722af,0x52025006,0xb27e60b0}},	//   _veransta, _निभावत_, _entire_, _guong_, 
   {{0x225a3158,0x00000000,0x00000000,0x00000000}},	//   _zemlju_, --, --, --, 
   {{0xe2255035,0x8568d191,0xc27e0084,0x841a207a}},	//   _でご注文いただく, _پذیرایی_, _quina_, _moontlik, 
   {{0x93a92006,0x427ee0da,0xfcdff069,0x00000000}},	//   _private_, _seinna_, _kreatív_, --, 
   {{0xc27e6046,0x608c005f,0x73fe1151,0x5290f089}},	//   _xuong_, _بيقولوا_, _日一周时政要闻_, _nemaš_, 
   {{0xa59c902f,0xde9b1040,0xee50a0bf,0xb7aa607a}},	//   _修改删除记录_, _bindings_, _कृष्णप्र, _letterli, 
   {{0x585c902a,0x00000000,0x00000000,0x00000000}},	//   _maalisku, --, --, --, 
   {{0x23eaf2ad,0x459ef03c,0xd2fb01d9,0xaae3e17e}},	//   _editar_, _クレジットカ_, _tighinn_, _интереси, 
   {{0xf22b41f5,0x6747c06b,0x53131096,0x72d80034}},	//   _upraviť_, _милиона_, _cambiar_, _красавиц, 
   {{0x32365140,0xa2901060,0xbcaba244,0x7f1652e3}},	//   _bolji_, _mehan_, _menyadar, _maatskap, 
   {{0x29d01122,0x727e61aa,0x24f85215,0x32ebb2a4}},	//   _серия_, _suong_, _otomobil_, _fizikal_, 
   {{0x42d60049,0x62efe1ba,0x5ac05050,0xc6545034}},	//   _mirovan_, _menimpa_, _pakkumis, _революци, 
   {{0x63dc2196,0xd863209e,0x00000000,0x00000000}},	// [420] _bakwa_, _abengand, --, --, 
   {{0x224a623e,0x73f46107,0xab7512ca,0xc9c4b12f}},	//   _nyumba_, _nettet_, _квалитет, _rezervat, 
   {{0xb24a52e4,0x42d5123e,0x42fc7026,0xa575b195}},	//   _resolusi_, _kuponya_, _dango_, _utilizaç, 
   {{0xcea1f11f,0xfde7f10a,0x6829e20f,0xb611f14b}},	//   _posljedn, _личните_, _thàinig_, _posljedi, 
   {{0x32cb706c,0xa3a410c3,0x53f872aa,0x41b3d280}},	//   _stadig_, _אנטהאלט_, _genug_, _доволен_, 
   {{0xa27e9247,0x129012e5,0x405782e6,0x33807002}},	//   _muang_, _dehan_, _inostran, _korras_, 
   {{0x217d82e7,0xd3f4c114,0x5ae5312f,0x2c7d6104}},	//   _דיעות_, _хурсанд_, _sigurant, _pressan_, 
   {{0xd341e047,0x126c70b4,0x13c1302a,0x00000000}},	//   _allegro_, _panon_, _сведения_, --, 
   {{0x876131b5,0x6e47906d,0x922410b3,0xc30df074}},	//   _двери_, _serbixwe_, _regionál, _nekilnoj, 
   {{0x32d87160,0xf27e0124,0x244240c8,0x691ac0c8}},	//   _tvnet_, _brine_, _사회복지과_, _행정서비스헌장_, 
   {{0x0c186114,0xa9803171,0x675ce1ce,0x6290c1f9}},	//   _истеъмол_, _konkursa_, _kakitang, _salamo_, 
   {{0x961df087,0x4430327e,0x120011fd,0x1320317c}},	//   _avtomobi, _concurso_, _behin_, _concurs_, 
   {{0xec68d052,0x9c36127a,0xcad730f6,0x91c6b1c7}},	//   _augusti_, _grantiau_, _bistarat, _postopek_, 
   {{0xa27f72e8,0x3d882035,0x9e889049,0xeeed51a1}},	//   _teanga_, _質問者のみ_, _navendî_, _salvesta, 
   {{0x026d9027,0xb24a7134,0xa57cc035,0xad1372e9}},	//   _kusov_, _fermer_, _ジに対するお問い, _kunstner, 
   {{0x59b961a4,0x927f40ba,0x52d8702a,0xfa89b043}},	//   _растител, _kwenda_, _menee_, _europeis, 
   {{0x9c7d600e,0xad60720d,0x503c9191,0x9290c1e3}},	// [430] _viestin_, _इन्स्टाल_, _جغرافیا_, _halako_, 
   {{0xf201e039,0xf3648083,0x4cec10dd,0xa27ed1dd}},	//   _akció_, _tingnan_, _компаниј, _weens_, 
   {{0xfbf83085,0x1f71c02f,0xfc91e24d,0x1b8a1271}},	//   _নেটওয়ার্, _concours_, _अवरोध_, _fronteir, 
   {{0x8d3c3090,0xe9ee401f,0xd677c2ea,0x59abc023}},	//   _velikost_, _tetikasa_, _ахири_, _иккала_, 
   {{0x803dc0c8,0xbc1241b4,0x5c8dc127,0x626ff137}},	//   _mogelijk_, _kampani_, _азимов_, _tvrdošín_, 
   {{0x801db260,0x026c2078,0x1e4520e2,0xd3877282}},	//   _tradisyo, _lemond_, _melangga, _charge_, 
   {{0x054fc008,0xa3035015,0x0d127016,0xc3878286}},	//   _амалий_, _smanjenj, _אַביסל_, _norra_, 
   {{0xd27e7043,0x6d22b005,0xab085035,0x58a6c034}},	//   _kunne_, _zagranic, _アルバイト_, _шрифта_, 
   {{0x82adc138,0x4464f065,0x627872eb,0x22bb8230}},	//   _الذات_, _انٹرویو_, _barnet_, _radenie_, 
   {{0x7200c2ec,0x826d800c,0x93878002,0x6366f17e}},	//   _online_, _eurot_, _korra_, _реалност_, 
   {{0xe20022ed,0x68e2f079,0x4b68411d,0xac93c191}},	//   _nekin_, _депутаци, _enlefzin_, _داداش_, 
   {{0x85845106,0xf2cf706d,0xc0f07075,0xc9d8506a}},	//   _fotogalé, _mamoste_, _নিখোঁজ_, _kutekele, 
   {{0xf2ebc0f7,0xe30da0b0,0xf1736027,0x5523f0b8}},	//   _kvinner_, _pokézoo_, _pomníky_, _teknoloh, 
   {{0x32e5e2e0,0xc6d38030,0xe9d1d075,0xd6727173}},	//   _hronika_, _пенализа, _জনস্বাস্, _waldensi, 
   {{0x3c6a82ee,0xb2f45045,0x3200216d,0xa20202b9}},	//   _चिन्ता_, _chuntas_, _cekin_, _disitu_, 
   {{0xe343b138,0x02a0619b,0x426c9111,0x9f239288}},	//   _بتوقيت_, _ljubav_, _nikoli_, _conectan, 
   {{0xabfa5297,0x5e73c151,0x825fc043,0xe29240a9}},	// [440] _vietcomb, _构建社会主义和谐, _впровадж, _bawaan_, 
   {{0x9b5a726d,0x86c511fb,0xc3eae287,0x00000000}},	//   _मिर्जापु, _pemanggi, _kontol_, --, 
   {{0xd3484033,0x237b9083,0xa976311b,0x00000000}},	//   _seleksi_, _malalim_, _виртуал_, --, 
   {{0xd2fc7186,0x2fb07069,0xf0c87110,0x02a0a0c8}},	//   _gange_, _پرائویسی_, _smallhol, _궁금합니다_, 
   {{0xe27e90ef,0x812d30f7,0xfe70b103,0xa7ba7120}},	//   _quang_, _сайту_, _कुम्भ_, _फेंगशुई_, 
   {{0x7e2630b5,0x2277d1ad,0x85f63199,0xcefdc05f}},	//   _сайтам_, _maksymal, _veteriná, _الرغم_, 
   {{0x82fc709e,0xd2da60bc,0x89d9303b,0x43942188}},	//   _bange_, _kereke_, _seinasta_, _maksu_, 
   {{0xae56b134,0x127e90c2,0xc2ee60c9,0x52b4d03a}},	//   _dimanche_, _tuang_, _ikonomi_, _niech_, 
   {{0x5f4e004d,0x869790f7,0xa224e092,0x6f95b0b0}},	//   _personne_, _видань_, _funkci_, _luận_, 
   {{0xde1dd075,0xd2fc71fa,0x926d12ef,0x4f39b002}},	//   _দাপ্তরিক_, _wange_, _izbori_, _भूमिहार_, 
   {{0x2d7dc2b9,0xf3a3f071,0x5c605232,0x952480c8}},	//   _bermanfa, _grupy_, _sigurta_, _롯데캐슬비치_, 
   {{0xec5b80b3,0x5db7301a,0x33ce91bf,0xdd4bd1a8}},	//   _dostali_, _сегіз_, _agava_, _халқымыз, 
   {{0x6e169034,0x052c5234,0x905e6038,0x7d3e615c}},	//   _значение_, _प्राथमिक, _ekonomik_, _ekonomie_, 
   {{0x9b73e079,0x02fc709e,0x72eb2044,0x709260f8}},	//   _ротару_, _zange_, _digidol_, _ইউসুফ_, 
   {{0xb60de024,0xb35bd0bc,0x2588d08b,0xf2fc70f4}},	//   _बांदा_, _mengata_, _activité, _yange_, 
   {{0xdf01200c,0x22003193,0xa477a098,0xdf7f4140}},	//   _अंग्रेजी_, _bejin_, _проекты_, _aktivnoš, 
   {{0x8381b149,0xec55b017,0x00000000,0x00000000}},	// [450] _verziju_, _instead_, --, --, 
   {{0x13ead246,0x22902010,0xb2f52045,0x73eb40af}},	//   _protiv_, _tekan_, _laistigh_, _khetha_, 
   {{0xa2c940c4,0x4b4d41c6,0xa2ef50e6,0xa27f7110}},	//   _pellach_, _көзөмөлд, _podzimní_, _kwanga_, 
   {{0x4e4520fe,0x029020a9,0xfff430b1,0x220020ee}},	//   _pelangga, _rekan_, _dunyonin, _rekin_, 
   {{0x5601503c,0x40760171,0x32002098,0xc8d322f0}},	//   _kommerci, _aksesuār, _sekin_, _कुसुमाग्, 
   {{0x529090f4,0xeceb81c2,0x72d64196,0x0e96408b}},	//   _imaam_, _अधिकतर_, _gratuity_, _gratuite_, 
   {{0xe26ca0b7,0x62861203,0x5f463193,0xd2d76140}},	//   _sabon_, _לשונות_, _aristide_, _odvojio_, 
   {{0x13946155,0x0367c075,0xc2fa01a6,0x3d881016}},	//   _those_, _দুঃখিত_, _swahaba_, _העכסטע_, 
   {{0x794f702b,0xef77a191,0x2d57c015,0x735431e2}},	//   _samostat, _کیبورد_, _назван_, _galegas_, 
   {{0x4db54048,0xb17f217e,0x28c2d0b0,0xeb2dc128}},	//   _meningga, _ученицит, _lovestru, _simbahan_, 
   {{0x53eb710e,0x9c27a079,0xa2b44230,0x11455056}},	//   _anatin_, _примиря_, _ramci_, _espesyal, 
   {{0x8a69f14c,0xeb4210b3,0x63797095,0x7bd1611a}},	//   _финансов, _doporuču, _boravka_, _conducer, 
   {{0xa3eb903f,0x02d5507b,0xd7c06151,0x00000000}},	//   _byste_, _levoča_, _抗震救灾特别专题_, --, 
   {{0x52da62f1,0x7400108f,0x1ec3f0e6,0x02d88110}},	//   _sereke_, _песни_, _राजकुमार, _makere_, 
   {{0xd431e005,0xc224502d,0xa301e142,0x9e51e1ad}},	//   _ostatnio_, _balki_, _ostatni_, _ostatnie_, 
   {{0x8212b2cf,0xbc27a1a4,0xf5d2e038,0x5af8d0f8}},	//   _eadhon_, _примери_, _studentë, _বিনোদন_, 
   {{0x7290413c,0x9303012e,0x2b9e2033,0xac7650fd}},	// [460] _heman_, _salamat_, _चातुर्य_, _forumas_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x529260cc,0xa2b471c4,0x00000000,0x00000000}},	//   _karaan_, _sincs_, --, --, 
   {{0x41ecd071,0xf2d9012b,0x00000000,0x00000000}},	//   _हाथरस_, _arbeid_, --, --, 
   {{0x1290209f,0xa3cf017a,0x18afe08a,0x434c22cc}},	//   _rekao_, _suaves_, _түймешіг, _cestovné_, 
   {{0x99fa30ab,0x2e389173,0xbc481016,0xe200513d}},	//   _starptau, _irenaeus_, _גענצליך_, _melin_, 
   {{0x85aa5010,0xa13f30ef,0xdd2f0151,0xba1052f2}},	//   _pengaruh, _kemulato, _arrière_, _estabele, 
   {{0x0436328b,0x56ae8075,0x6ac80016,0xd6f32033}},	//   _praktick, _বেসামরিক_, _בערלין_, _वाढदिवसा, 
   {{0xf87cc043,0x329101ae,0xa5ce1094,0x3c49317c}},	//   _поставле, _ambara_, _ҳатмӣ_, _circulac, 
   {{0xb349c116,0xe24970a9,0xc2ac41e9,0x868cc002}},	//   _livelli_, _nyaman_, _контроль, _नादान_, 
   {{0x239590a2,0xad73a015,0x3b8091e5,0x51b3d1de}},	//   _sisse_, _познато_, _دورتموند_, _ڈائری_, 
   {{0xbb343112,0x5394b07a,0xe3d5b1d7,0xa2905128}},	//   _интересн, _meeste_, _platinti_, _kelan_, 
   {{0xfb1c2096,0x5db79074,0xa3b0c008,0x72d550cc}},	//   _respuest, _заводы_, _lmoqda_, _istorya_, 
   {{0x1d032010,0x52b1d2f3,0x73648287,0x82d8913d}},	//   _خدمات_, _टेबुल_, _sungmin_, _adael_, 
   {{0x4401a074,0xb55dc119,0x43470094,0x3c762213}},	//   _аспекты_, _вполне_, _феҳрасти_, _मुल्ये_, 
   {{0x427e9128,0x39e4a03c,0xe2b182f4,0x02fc7110}},	//   _ngang_, _ありがとうござい, _pridala_, _nanga_, 
   {{0xb386c236,0x484ed239,0xfc12406a,0x324bd142}},	// [470] _andre_, _publicid, _kampuni_, _ट्रेलर_, 
   {{0xa2fc712e,0x71a41016,0x54e21075,0xa2fe70da}},	//   _hanga_, _שניאור_, _নওগাঁ_, _margar_, 
   {{0xed73221b,0x00000000,0x00000000,0x00000000}},	//   _posmatra, --, --, --, 
   {{0x9387e139,0x7c143151,0xc26cc0b9,0xb2fc2192}},	//   _votre_, _没有相关文章_, _padon_, _dominos_, 
   {{0x71f3c030,0xc2d912f5,0xf30712f6,0x18c40024}},	//   _войник_, _emberi_, _расмии_, _ओलंपिक_, 
   {{0x329040a9,0xe9c2f180,0xe2fc704c,0x3713b035}},	//   _teman_, _vrednost, _langa_, _アビシニアン_, 
   {{0x0305a162,0xb72ce0a1,0xe157900c,0x935b8041}},	//   _dimasak_, _органдар_, _मल्लाह_, _zeemzeeg_, 
   {{0x92fc70da,0xe9c9b140,0x7200506f,0x130752b3}},	//   _ganga_, _odgovara_, _felin_, _limburg_, 
   {{0x629051e3,0x4b8931b9,0x820051e6,0xd225709f}},	//   _gelan_, _diciembr, _gelin_, _ovakve_, 
   {{0x727e62f7,0xaf0a520f,0xe387c0b3,0x903c0017}},	//   _grond_, _mhàin_, _stará_, _selectio, 
   {{0x38fc4093,0xd6213277,0xcf5bd1ae,0x9cea4050}},	//   _қыркүйек_, _befolkni, _mahalian, _तिलमिला_, 
   {{0xcb44405c,0x9d7c3094,0xbefd50c8,0xdb3131de}},	//   _интересо, _муфассал_, _확인하시기_, _جنگجو_, 
   {{0x4290c2f8,0x98a7a17e,0xff21e0f1,0x19139008}},	//   _omdat_, _правец_, _rotterda, _сўроққа_, 
   {{0x52bb1088,0x89eba151,0x4f61907d,0xd96f725c}},	//   _seneste_, _由县级以上人民政, _століття_, _acontece, 
   {{0xa292709f,0x137f3068,0x6200509d,0xa288708b}},	//   _moraju_, _almanya_, _delio_, _fichier_, 
   {{0xde435155,0x2f4350db,0xb3485170,0x0248d09f}},	//   _password_, _passwort_, _koneksi_, _svemu_, 
   {{0x89d0c072,0x42a752f9,0x00000000,0x00000000}},	// [480] _темир_, _nyebut_, --, --, 
   {{0x779d9186,0x9c5e304d,0x00000000,0x00000000}},	//   _トラックバック_, _portail_, --, --, 
   {{0x97b59069,0x322580bf,0x00000000,0x00000000}},	//   _amelynek_, _jirka_, --, --, 
   {{0x727e607c,0x9277a0b1,0xe36ab02f,0x14d77006}},	//   _trong_, _радиоси_, _文化东路街道办事, _אנציקלופ, 
   {{0x62fc9154,0x13947026,0xbbdde130,0xdbe3d29c}},	//   _kaaga_, _dansi_, _मटिया_, _makelaar, 
   {{0x0c5372fa,0x35a95106,0x125ad0d2,0x92d8007a}},	//   _pertama_, _formulár_, _sjell_, _kliek_, 
   {{0xbc71e002,0x286860e5,0xa2a75146,0x16d3318e}},	//   _पिज्जा_, _ekspress_, _liebes_, _rahalahi, 
   {{0x3785d2fb,0xaa4cc138,0x0f60d0b3,0x12e78164}},	//   _प्राकृति, _تجهيز_, _displeje_, _ukinuto_, 
   {{0x77e72015,0x86d7205c,0x32f7305f,0x367f62fc}},	//   _архива_, _архиве_, _indiach_, _venenati, 
   {{0x6290d196,0x2301e162,0xcefd2024,0x26e2f175}},	//   _dinale_, _piranti_, _पेशकश_, _životnéh, 
   {{0xa740c02f,0x91e730a9,0x9f03a094,0x00000000}},	//   _科学技术部_, _चेहर्_, _шомгоҳӣ_, --, 
   {{0x129052fd,0x69ec8121,0x69f7b0b3,0x82da7030}},	//   _delal_, _فدراسیون_, _dodavate, _curent_, 
   {{0x6947e17e,0xe1bec01b,0xae18904f,0x00000000}},	//   _предлог_, _berevajî_, _oppervla, --, 
   {{0x15ae40a9,0xb3f89087,0xa983801a,0x66e2f0bf}},	//   _पाहता_, _nakupu_, _теледида, _životníh, 
   {{0x427e619e,0x920070b2,0xb38a22fe,0x568651d9}},	//   _huono_, _tenia_, _körde_, _acadamai, 
   {{0x8d9841ad,0xaaf25245,0xd2363179,0x730c227e}},	//   _momencie_, _dikredit, _reljef_, _romanos_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [490] --, --, --, --, 
   {{0x1f2e320a,0xf9b6c075,0xfee500a9,0xe224727b}},	//   _comunida, _শতাধিক_, _राष्ट्रा, _sanki_, 
   {{0xd3947029,0xc3a91006,0xbde91155,0xff991155}},	//   _pansi_, _provide_, _provided_, _provides_, 
   {{0x72fcd050,0xdae7f052,0x32fae1ad,0xcf27f052}},	//   _isegi_, _intresse, _informuj, _intressa, 
   {{0x729030e8,0xd98e12ff,0x8e7d0138,0x48eec05f}},	//   _semasa_, _наших_, _ويتحمل_, _تصنيف_, 
   {{0x233d1300,0xa25ad301,0x8e563126,0x72ad9149}},	//   _دیدار_, _heller_, _хастанд_, _nekadašn, 
   {{0xb7bbf09f,0x4f051025,0xbc757109,0x3dc1b262}},	//   _međutim_, _प्रेमचंद_, _adhradh_, _aimhreit_, 
   {{0xc5802243,0x9c769277,0x41c30089,0x81e6c069}},	//   _informaç, _torsdag_, _sastanak_, _تباہی_, 
   {{0x03f470a6,0xe27ee0b9,0x89aac302,0xf84fd09d}},	//   _ersten_, _mennen_, _помир_, _ymholiad, 
   {{0xe2cab163,0xd201814e,0x0e5f6138,0x51cfd079}},	//   _fredag_, _emrin_, _المؤمنين_, _адаптат_, 
   {{0x12d84216,0xb27ee03e,0x3f31907d,0x0290500a}},	//   _immer_, _meinen_, _konferan, _celal_, 
   {{0xb29d607a,0x93959267,0xcd4140c7,0x3386820b}},	//   _verkoop_, _fissi_, _edərkən_, _sakrij_, 
   {{0x283240c8,0x23eae13d,0x9313c075,0x3307e04b}},	//   _잊으셨나요_, _menter_, _হলিউড_, _beradik_, 
   {{0x3e735303,0xa7c0d075,0x20ec12dc,0xd27ef173}},	//   _दोस्त_, _আবারো_, _speisial, _bannor_, 
   {{0x9f4c303c,0x83948128,0x770b9045,0x03c58121}},	//   _ガイドライン_, _hanggang_, _custaimé, _جادویی_, 
   {{0x48c5317a,0x4f3a109c,0x826a10ff,0x59ea1008}},	//   _reservad, _amerikaa, _amerikal, _amerikad, 
   {{0xca7c31b6,0x12a70053,0xfe372304,0xf21ee0f8}},	// [4a0] _wezareta_, _khabar_, _kungakha, _ক্রমানুস, 
   {{0xfae5f006,0x62b66109,0x261c7112,0xad0fa006}},	//   _characte, _dorcha_, _mielenki, _עמותת_, 
   {{0xb3fd602f,0x67296148,0x6e573137,0x0394c2aa}},	//   _国家发展和改革委, _nasledov, _nenašiel_, _falsch_, 
   {{0x7d1360d2,0x198050f1,0x739420cc,0x4fdca187}},	//   _konsider, _artikele, _laksi_, _velikono, 
   {{0x9ecb9086,0xbeb1408c,0x517e6023,0x00000000}},	//   _kulingan, _evropian, _kiritish_, --, 
   {{0x73401113,0x2303108c,0x02cae0a4,0x42d8c1bf}},	//   _licenza_, _allahut_, _fundet_, _muleke_, 
   {{0xc27ee29c,0xa4d7901a,0x75eb30c8,0xb3eae13d}},	//   _kennen_, _базасы_, _공정거래위원회_, _fenter_, 
   {{0x027e9297,0x2249411e,0x93eac063,0x7a0e71b1}},	//   _trang_, _premye_, _lwmtus_, _prestaku, 
   {{0x927ee1e7,0x59f57059,0x127e9009,0xa27e9006}},	//   _keinen_, _डेस्कटॉप_, _urang_, _brand_, 
   {{0xdc1c30fa,0x5e557262,0x9395903b,0xb045c062}},	//   _nitrians, _aoibhnea, _vissi_, _overigen, 
   {{0xc2cae0a4,0x32489086,0xf39401b5,0xb308f01e}},	//   _kender_, _alama_, _upisa_, _symbool_, 
   {{0x620070f2,0xf37962b0,0x1403b12a,0xeb421299}},	//   _tenin_, _furasta_, _бюджета_, _doporuče, 
   {{0x53b81205,0xb224006a,0xb26c70c4,0xcc5c6305}},	//   _provozu_, _spika_, _hynod_, _निषेध_, 
   {{0x22fce1a7,0x07d8b015,0x3c6ff1b7,0x90c050b8}},	//   _mangsa_, _синдикат, _storico_, _summersl, 
   {{0x79765243,0x9f6ea0a9,0x22d12133,0x00000000}},	//   _atendime, _अहमदनगर_, _cestách_, --, 
   {{0xb65840fd,0xa2caf0db,0x06ba119a,0xb4679016}},	//   _натураль, _leider_, _barangsi, _נאַטירלע, 
   {{0xea1ec023,0xa399325f,0x2e1591e3,0x13404199}},	// [4b0] _диний_, _läser_, _hemengoa, _modelka_, 
   {{0x19add065,0xf3ebf170,0xe2da6196,0x99233024}},	//   _تجربہ_, _ikuti_, _tirelo_, _रेंजर_, 
   {{0xe88061b1,0xa3f4629f,0xc0f06038,0x69c7d306}},	//   _artikulu, _vertel_, _artikull, _рамазан_, 
   {{0x86e6002d,0xcb61c0ed,0x326ce1ac,0xca02a240}},	//   _kompaniy, _भेजनी_, _sinodi_, _rosalega_, 
   {{0x92300138,0xae992138,0x9a485226,0xe3963065}},	//   _shampla_, _وبعدين_, _mendrika_, _kissé_, 
   {{0xdbcc0006,0xa3f450c9,0x8ef0d0a9,0x9c66b240}},	//   _והעמקים_, _fluted_, _संकल्पना_, _birtist_, 
   {{0x32fe6043,0x53d0a171,0x00000000,0x00000000}},	//   _bergen_, _olimpisk, --, --, 
   {{0x52a740ef,0x338701cf,0xeac8a307,0x00000000}},	//   _byebye_, _ngarah_, _rosalía_, --, 
   {{0x7c6d8036,0xd9f6c069,0x738601a6,0xe20070ff}},	//   _shirika_, _توہین_, _siiro_, _menim_, 
   {{0xe2e6f188,0xc95b903f,0x027ff0c2,0x927ed09b}},	//   _biznesa_, _जीवनमा_, _itung_, _ageng_, 
   {{0x4b3e3075,0xe202618e,0x91c3c1e9,0x00000000}},	//   _কিলোমিটা, _corine_, _догори_, --, 
   {{0x7aa940cf,0x02027053,0xeec5c1f1,0xfa931015}},	//   _शिवलिंग_, _periuk_, _словник_, _корени_, 
   {{0x25042164,0xa7ece121,0x0c15c00f,0x7395f1c0}},	//   _početna_, _pekalong, _sveriges, _giuse_, 
   {{0x1721d140,0xb26d80c4,0xc0009121,0x6307d095}},	//   _početkom_, _barod_, _علیزاده_, _boravak_, 
   {{0xf30dc04b,0xd36360fe,0x6dad8003,0xc9c390f6}},	//   _membina_, _langkah_, _bandarís, _konektat, 
   {{0x9b6e320e,0xdd2021c6,0xc2da71de,0x00000000}},	//   _емоции_, _кээде_, _keress_, --, 
   {{0x83e0402a,0xe28c51fa,0x00000000,0x00000000}},	// [4c0] _hallituk, _abekika_, --, --, 
   {{0xe310b041,0xbc3cb072,0x65ee1113,0x8e33b004}},	//   _chuckle_, _комитетт, _produció, _reklamos_, 
   {{0xc2c940c4,0x2bb4c251,0x00000000,0x00000000}},	//   _bellach_, _सुन्नुहो, --, --, 
   {{0x627e700c,0x4c3ea100,0xb3f4709c,0xc17da017}},	//   _tunne_, _genişlən, _gestel_, _חימום_, 
   {{0xb395903b,0xf3949062,0xfc2ed0f7,0x4f2360d1}},	//   _misst_, _naast_, _бюджетно, _comentan, 
   {{0x7486403a,0x4b28b004,0x5111a069,0x12d8c143}},	//   _घटनाओं_, _транспар, _ایڈیٹر_, _groene_, 
   {{0xa2d51039,0x13914138,0x8ef71005,0x4c7d722c}},	//   _mellett_, _الطاقة_, _कलाको_, _persuna_, 
   {{0x16b2f08f,0xfd8c2216,0xa9d15191,0xe954f12a}},	//   _редактир, _geregelt_, _بفرمایید_, _известен_, 
   {{0x03416260,0x88700308,0xf073c1d7,0x00000000}},	//   _direkta_, _músicas_, _бухты_, --, 
   {{0x029250f4,0x627e90cc,0x00000000,0x00000000}},	//   _matayo_, _ngani_, --, --, 
   {{0xe4b3808e,0x282e9019,0x7e0060fd,0x22da511a}},	//   _הארבע_, _условиях_, _bendrada, _putere_, 
   {{0x93659017,0x9f3980b8,0x00000000,0x00000000}},	//   _לוקחת_, _muenster_, --, --, 
   {{0xb394b27a,0x8dc42102,0x6f783021,0xd373714c}},	//   _tacsi_, _agricole_, _blackpan, _domande_, 
   {{0x2dffe048,0xd2d83026,0x12fc3084,0xc2ea00b9}},	//   _perempua, _comesa_, _milions_, _afriken_, 
   {{0xaaba217e,0xff32102f,0xcdb42008,0xfa171151}},	//   _предизви, _国土资源部_, _нуқтаи_, _徐州监察分局_, 
   {{0xd0464071,0x35105095,0xd460d151,0xfd784016}},	//   _डेवलपर_, _pokušao_, _香艳的寻宝之旅_, _פאסאזשיר, 
   {{0x8ae1f006,0x964e2072,0xb581f1fd,0x22a6a21c}},	// [4d0] _institut, _зомбулук, _instituz, _hobby_, 
   {{0x427f5096,0x42d7c180,0x00000000,0x00000000}},	//   _buenas_, _kuponko_, --, --, 
   {{0xf85cb08d,0x02583149,0xffc23069,0x82eff092}},	//   _verander_, _engleski_, _کاموں_, _užijte_, 
   {{0x327e609b,0x73b02309,0xf13fd029,0x8683420d}},	//   _ngono_, _webstrán, _greenbel, _एतबार_, 
   {{0x34610132,0x72d90068,0x50dd21de,0x3f310132}},	//   _disebutk, _habere_, _ریسرچ_, _disebutn, 
   {{0x6f1e3121,0x1d85c043,0xb4fb40cf,0x00000000}},	//   _شاکردوست_, _словом_, _गिलानी_, --, 
   {{0xe2da70fa,0x8cf2f12f,0x6cd9908e,0x620051a7}},	//   _stredu_, _partener, _החסיד_, _belia_, 
   {{0xd3da2015,0xa3c890f8,0x25d4e1a4,0x15ec1017}},	//   _правилни, _এলোমেলো_, _стартува, _ללקוחות_, 
   {{0xee29d03b,0xc38bc30a,0x00000000,0x00000000}},	//   _bygginga, _færre_, --, --, 
   {{0xb27e9134,0xce4d9006,0xcefe7182,0x8510a0c7}},	//   _quand_, _הייטק_, _prekybos_, _səlahiyy, 
   {{0x6386c19c,0x611ac004,0x0c7b421f,0x82d521aa}},	//   _gjorde_, _бомбы_, _برخاست_, _robocon_, 
   {{0x2386a099,0x0947217e,0x835ab161,0x33ebe0bd}},	//   _dobry_, _писател_, _aerfort_, _nytta_, 
   {{0x5290c09f,0x2c79e065,0x00000000,0x00000000}},	//   _jedan_, _kérlek_, --, --, 
   {{0x829020a9,0x22b73043,0x768e61b8,0x29e52183}},	//   _dekat_, _другому_, _profissi, _bestuurd, 
   {{0x95bd90eb,0x1302c00e,0x13875042,0xa1b9a017}},	//   _министра_, _lokakuu_, _cifras_, _החלקה_, 
   {{0x1b495033,0x6d8c720b,0x427e91fe,0x4a8cf151}},	//   _संस्कृती, _točno_, _itanu_, _胶南市民政局_, 
   {{0x7e4290cc,0xe27e00f4,0x9290c0de,0x4055c188}},	// [4e0] _breakout_, _erina_, _nedan_, _izgatavo, 
   {{0x861d1062,0x02e020ce,0xb66482c4,0x4c03d171}},	//   _개인정보보호정책_, _deireadh_, _घमासान_, _forumā_, 
   {{0xfef3513b,0xfa7e91c5,0x736c7162,0xc1084026}},	//   _panjangn, _connaiss, _bingkai_, _anakubal, 
   {{0x854e210a,0x320e111b,0x62d46022,0x2aa91030}},	//   _лични_, _зарар_, _burdan_, _перете_, 
   {{0x6299b03c,0x224a711b,0x00000000,0x00000000}},	//   _アウトドア_, _hurmat_, --, --, 
   {{0xe70ba08e,0x32d5d1c1,0x03fa60fc,0xc26c8055}},	//   _ההגדה_, _razliku_, _struje_, _dekore_, 
   {{0x4b7cc133,0x1387e04d,0xf320c150,0x3200913d}},	//   _jednoduc, _notre_, _medyo_, _owain_, 
   {{0xc2365272,0xdfe15138,0x12bd5033,0x22002068}},	//   _vilja_, _ollmhór_, _माणुस_, _tekil_, 
   {{0x5497530b,0x834c2251,0xff23804b,0xe1415039}},	//   _अयोग्यता_, _cestovní_, _cemerlan, _مشاروتی_, 
   {{0x984340dd,0xd27fe0a3,0x6d99c1ad,0xaa8cb165}},	//   _централн, _letni_, _bezpośre, _perioden_, 
   {{0x96577158,0xf2fe6023,0x2394d30c,0x725ad0a4}},	//   _poljopri, _bergan_, _mbese_, _skolen_, 
   {{0x927e7043,0x52b470f3,0x323fd07a,0xbc16509f}},	//   _kunna_, _manch_, _vermaak_, _mogucnos, 
   {{0x094341b5,0xd85811dc,0x00000000,0x00000000}},	//   _међунаро, _habarlar_, --, --, 
   {{0xc2ba530d,0x89d5d002,0x48675035,0x652c101d}},	//   _sendiri_, _उत्पात_, _mulighed, _términos_, 
   {{0x829020a3,0xc291c20c,0xdb6a416b,0x0379630e}},	//   _nekaj_, _vrijeme_, _политици_, _matanda_, 
   {{0x3248d050,0x33eae30f,0x2773915f,0x10589052}},	//   _olema_, _centar_, _доллари_, _johansso, 
   {{0xab1820ce,0x5c5c9310,0xcfda00cd,0x527e726c}},	// [4f0] _هههههههه, _बिशेष_, _бюджетке_, _gunna_, 
   {{0x0200c00c,0x19699171,0xf75fa1e9,0x6c7ca0bd}},	//   _valige_, _autortie, _дозволяє_, _teksten_, 
   {{0x826cc16d,0xcc1720e6,0xa25a9036,0x925ad1e2}},	//   _zalogi_, _पूर्वाञ्, _ajali_, _mellor_, 
   {{0x1b0b003c,0x12cbf075,0x322540a7,0x7d88c127}},	//   _アドバイス_, _ayuda_, _şekli_, _қазоқист, 
   {{0x98fce311,0xbdae00d5,0xb2f4c092,0x63207057}},	//   _levantad, _kasnasda, _emailem_, _menya_, 
   {{0x6c777129,0xd25a913e,0x00000000,0x00000000}},	//   _पेक्षा_, _djali_, --, --, 
   {{0x80d4205f,0x89f1e003,0x13417149,0x644570a9}},	//   _يوفقك_, _endilega_, _spremna_, _प्रयोगशा, 
   {{0x1a897082,0xc27e90cc,0x4cb7202f,0x12fe7042}},	//   _üniversi, _ngano_, _您当前的位置_, _cargas_, 
   {{0x0996801a,0x32cae16d,0x139402d7,0xf26c418c}},	//   _картасы_, _vendar_, _spise_, _symon_, 
   {{0xd290c00f,0x727ed089,0xb317329c,0x1b1c4194}},	//   _redan_, _krene_, _functie_, _debatten_, 
   {{0xb9d2e2b2,0xa999500e,0x62ef41c9,0xe290c006}},	//   _tallinna_, _професси, _gwefan_, _sedan_, 
   {{0x9290506d,0xb3209131,0x5288227b,0x92a01220}},	//   _belav_, _bwayo_, _hastalığ, _غنیمت_, 
   {{0xb350804f,0x0c801072,0x4bad80bf,0xf2e76124}},	//   _profiel_, _десек_, _क्यूबेक_, _putnika_, 
   {{0x4bfcf29f,0x7727c231,0x820091da,0x00000000}},	//   _vergader, _naolejov, _dakizu_, --, 
   {{0x325bf03b,0x0962b01a,0x49eab01e,0x19fd002b}},	//   _skulu_, _деректер, _알려드립니다_, _interiér, 
   {{0xc1b1e075,0x62da61e5,0xb2002069,0x163f3106}},	//   _জানেন_, _bareng_, _nekik_, _kalendár_, 
   {{0x0840c1ab,0x92d8a1a1,0x91452155,0xab658106}},	// [500] _مخصوص_, _umbes_, _material, _januára_, 
   {{0x66f19114,0xc6902019,0x10e4b0cf,0x8c03f0ab}},	//   _ибодат_, _справочн, _सुनीता_, _kopumā_, 
   {{0x012a2075,0x42e110ed,0x9d5cc191,0xc2d8b16d}},	//   _নামস্থান_, _भेजीं_, _مجسمه_, _vedeti_, 
   {{0xcbd21258,0x927ed153,0xcc7c01a5,0x62fdf095}},	//   _कृपया_, _bueno_, _biasana_, _drugu_, 
   {{0xcc61006a,0x91fed0b2,0x1a03a023,0xa6ced084}},	//   _masuala_, _орозо_, _darajada_, _ошого_, 
   {{0x82d8a065,0x739a60a3,0x9351912f,0x13e8901e}},	//   _ember_, _podatkov_, _conform_, _태터데스크_, 
   {{0x47fcb08b,0xdc1ce03c,0x52d66087,0x83f4019c}},	//   _只看该作者_, _サイトマップ_, _podobno_, _kostet_, 
   {{0x542d60c5,0x3fd071e6,0xd6c76012,0x00000000}},	//   _दबदबा_, _sahiptir_, _financei, --, 
   {{0x03f471ca,0xddff51e0,0x48534084,0x63cf30b0}},	//   _nostre_, _mendenga, _empreses_, _ttxvn_, 
   {{0x5386d175,0x62921312,0x00000000,0x00000000}},	//   _miere_, _ispalo_, --, --, 
   {{0x92cbf1c1,0x93f20083,0x014561e3,0xd2008068}},	//   _ljude_, _parehong_, _espezial, _makine_, 
   {{0x3c9c20a8,0x9681a1f7,0xc200c0af,0x5c634034}},	//   _мурда_, _क्रास_, _felisa_, _imprese_, 
   {{0xb4a95177,0x1394909e,0xfc054313,0xaf7fb124}},	//   _فبراير_, _kaasi_, _chorvats, _potrošač, 
   {{0x2e50202b,0xc24db050,0x868071f9,0x8b95a0f4}},	//   _informač, _फिरला_, _delegasi, _katikkir, 
   {{0x6a7c80f4,0xbfd21162,0xf32a0231,0x62f640f3}},	//   _makanisa_, _miniatur_, _zábery_, _prensip_, 
   {{0xb27e90e2,0x758a01f5,0x0290f11b,0x3c769277}},	//   _orang_, _registrá, _degan_, _forslag_, 
   {{0xc2858035,0x9107f039,0x00000000,0x00000000}},	// [510] _回答は役に立ちま, _ellenáll, --, --, 
   {{0x52902054,0xc386d2e3,0x00000000,0x00000000}},	//   _mekah_, _diere_, --, --, 
   {{0xc3869036,0xdea4c314,0x4f310101,0x00000000}},	//   _ziara_, _ҳузури_, _paguyuba, --, 
   {{0x2f2db0de,0x7dc4501e,0x00000000,0x00000000}},	//   _utrednin, _maximale_, --, --, 
   {{0xa26dc140,0xa25b7225,0x5e685035,0xf2025188}},	//   _prvoj_, _ilalim_, _総合ランキング_, _netiek_, 
   {{0xd582f150,0x1394b301,0xe20ec0a1,0xf98ec15f}},	//   _kategory, _fleste_, _қадам_, _қадим_, 
   {{0x37cc7034,0x92e79034,0x584cb0c8,0xcb6d3092}},	//   _пострада, _gennaio_, _보았습니다_, _भएपनि_, 
   {{0x47e3400c,0xa38f505d,0xe26d8168,0x1c90a1ce}},	//   _त्रिपाठी_, _rapporti_, _karon_, _sekurang_, 
   {{0xa26da208,0x9cf7b02e,0xd273b240,0xc62ed151}},	//   _ispod_, _पुलकित_, _mínum_, _必须保留本网注明, 
   {{0x128d2242,0xe2f1e12a,0xa2ff90ce,0x688e1151}},	//   _thaksin_, _diritti_, _radharc_, _面皮做好刺洞_, 
   {{0x235870fa,0x997e405b,0x0bc7c094,0x33f8e1eb}},	//   _potrebné_, _afrikane, _қаблан_, _minuts_, 
   {{0x62d87187,0x7d0840c3,0x038672c6,0x71c3d280}},	//   _konec_, _באזונדער, _blizini_, _говорим_, 
   {{0xe153c151,0x2290401b,0x05b760b0,0x00000000}},	//   _企业国有产权转让, _temam_, _finalsty, --, 
   {{0xe225009f,0xf2fe7042,0x3e9e1147,0x5b1ae1af}},	//   _svakom_, _cargos_, _насли_, _semporna_, 
   {{0x0682f006,0x2637602a,0x927e9037,0xe9c2f0c4}},	//   _categori, _пластико, _erano_, _categore, 
   {{0x9290c2ef,0x44091127,0x52fce143,0x9373c09f}},	//   _nalaze_, _теъдоди_, _dingen_, _nikakve_, 
   {{0x729052f1,0xa3207110,0xa5a71248,0x7031f315}},	// [520] _zelal_, _menyu_, _घाइते_, _बतकही_, 
   {{0xa280c224,0x02b2803e,0x6394e194,0x8c90900c}},	//   _novinky_, _sondern_, _prisen_, _त्यों_, 
   {{0x7967a016,0xd200d03b,0x9ccb9035,0x33cea134}},	//   _מגילה_, _tveir_, _円以上国内配送料_, _privé_, 
   {{0x2eead010,0x99a9f147,0xd386206a,0x00000000}},	//   _پستون_, _қаламрав, _fikra_, --, 
   {{0x7386c052,0xf156c0fd,0xdda971ae,0xedf7c195}},	//   _andra_, _малышам_, _tanindra, _филмови_, 
   {{0x83f470a8,0x26d61220,0x653c9035,0x4f38d0cc}},	//   _vostre_, _یاسمین_, _希望小売価格_, _sovracca, 
   {{0x5c50c0e6,0x1e398129,0x2ee3e0a7,0x20e7e0cb}},	//   _ट्रेड_, _penawara, _programı, _offiziel, 
   {{0xd27e7240,0xe1275220,0x185da08e,0x426df1d7}},	//   _kunnu_, _تدابیر_, _משכיל_, _sezono_, 
   {{0xd2fd80a7,0x3db8e0cc,0xde237073,0x56d3d108}},	//   _kargo_, _filament_, _संग्रहाल, _мобилни_, 
   {{0xa057b0a1,0xe4d5e2ab,0x2200f050,0x24609255}},	//   _назарға_, _गोपिका_, _tegin_, _menegask, 
   {{0x4202603d,0x00000000,0x00000000,0x00000000}},	//   _kuriem_, --, --, --, 
   {{0x73eae006,0x7248d1a1,0x92c5307a,0x2e94b04d}},	//   _center_, _oleme_, _heilige_, _pratique_, 
   {{0xb2926316,0x76e46015,0x42d9f00a,0x1f444240}},	//   _vitatu_, _многобро, _gazete_, _búskapar, 
   {{0xc9d4d317,0x95727016,0x0292614a,0xd7f27016}},	//   _umiestne, _אַרמיי_, _sarado_, _אַרכיװ_, 
   {{0x447dc0cd,0x123691b0,0x2d007075,0x6c69e038}},	//   _армян_, _znaju_, _মিউজিক_, _titulli_, 
   {{0x827e9178,0x520071d6,0x0b2720a9,0xbbfb91b9}},	//   _trano_, _menit_, _विश्वकरं, _septiemb, 
   {{0xe3f47047,0x42e2d169,0xe9e870c5,0x0526819b}},	// [530] _jestem_, _स्वीट_, _कोतवाली_, _završio_, 
   {{0x0485100c,0x23f47052,0x00000000,0x00000000}},	//   _शिवाला_, _bostad_, --, --, 
   {{0x327f9318,0x002d70f7,0x845e30a7,0xe236b0a9}},	//   _qaynar_, _фотоальб, _kendiniz, _prediksi_, 
   {{0xe2903255,0x93eaf1c8,0xf2da5060,0x00000000}},	//   _sejak_, _pritet_, _asteng_, --, 
   {{0x826c1319,0x82908225,0xfd136155,0x914dc17e}},	//   _रक्षा_, _dekada_, _consider, _извори_, 
   {{0xf072b010,0xc047f10a,0xb450914c,0xc2a6831a}},	//   _امارات_, _мислите_, _здравейт, _provozní_, 
   {{0xb200304e,0x0a6fa138,0xda7b909f,0x326cc31b}},	//   _komiti_, _prionsab, _greške_, _balozi_, 
   {{0x42e32027,0x526cc01f,0x520270c9,0xc7aa7157}},	//   _peniaze_, _filoha_, _masimo_, _avstrali, 
   {{0x62bd518f,0xb287f27b,0xfa0fe0a9,0x728c307b}},	//   _मानुस_, _hastalık, _manajeme, _balkón_, 
   {{0xc2bb814c,0xec5740c1,0x123ba152,0x526df098}},	//   _offerte_, _nastaje_, _этапах_, _autot_, 
   {{0x6580e1ea,0x2f3dd0e5,0x097ad03e,0x2c31e0e5}},	//   _federasy, _कृतित्व_, _enthalte, _artiklid_, 
   {{0x43f98206,0x9387409b,0xbc673163,0x53eae07a}},	//   _terug_, _ngerti_, _omkring_, _duitse_, 
   {{0x7163a282,0x12d8527a,0x747d809b,0x93949095}},	//   _דניאל_, _coleg_, _interwik, _spasa_, 
   {{0x12a64304,0x1c53f243,0xe2d8309f,0xd38b3293}},	//   _mimba_, _contato_, _kojem_, _først_, 
   {{0xbce27195,0x02a64030,0x9248d131,0x7435e02a}},	//   _информир, _limba_, _aleme_, _функции_, 
   {{0x74ef4167,0xf3f8522c,0x127ee2aa,0x0290c0c4}},	//   _спортивн, _illum_, _seinen_, _addas_, 
   {{0xd200c155,0x252021e4,0x7b0e700e,0x027ed145}},	// [540] _media_, _beannach, _viestike, _stenu_, 
   {{0x4e54e1f1,0xeb100106,0xf20231ad,0x1b84e1e9}},	//   _економіч, _prostrie, _kupić_, _екологіч, 
   {{0xc9f8f229,0x47dfb01c,0x8f628171,0xbb2100f1}},	//   _milijuna_, _ponašaju_, _katalogs_, _proberen_, 
   {{0xcab520af,0xd26c21de,0x503c90f1,0x1a15231c}},	//   _drakensb, _ekkor_, _namelijk_, _कामोत्ते, 
   {{0xde0ea17e,0xd29271f2,0x9b260155,0xc6ae20aa}},	//   _verdinha, _pasado_, _companie, _abituriy, 
   {{0xb3869052,0x53eb2042,0xf29041a7,0x924990d2}},	//   _snart_, _lector_, _semak_, _mesme_, 
   {{0x7c50c075,0xe3099006,0x419991ad,0xedad8003}},	//   _ছোট্ট_, _problem_, _problemy_, _bandarík, 
   {{0x92484043,0x06ab31a8,0xa1acc187,0xc39ca0a5}},	//   _komme_, _өзара_, _pondělí_, _zakašnje, 
   {{0xe5c0b0a9,0x32d850a6,0xe2fd20a3,0xc85f8287}},	//   _ब्राह्मण, _allem_, _kolikor_, _makassar_, 
   {{0x1887d023,0x9567309f,0x7394001f,0x3c52d0e5}},	//   _назарда_, _obavezno_, _tsisy_, _स्लेट_, 
   {{0xf24800d6,0x5290e20f,0x8a886199,0x3c0eb089}},	//   _elimu_, _chiall_, _moderáto, _skuplje_, 
   {{0xe2d850a3,0x49e17069,0xb3f40084,0x0b261118}},	//   _poleg_, _میگزین_, _costat_, _ядром_, 
   {{0x8dcfa31d,0xc2d980b3,0x0290c038,0x0039e095}},	//   _ज़्यादा_, _tablety_, _islame_, _atletsko, 
   {{0x02d8b0eb,0xa59630e0,0x82a78277,0x0f5ac02f}},	//   _организу, _isteriny, _forbi_, _campagne_, 
   {{0x320070a7,0x0bf2d069,0xaceee073,0xc2bc9316}},	//   _benim_, _kattints, _क्रमवार_, _goodall_, 
   {{0x53eae160,0xb8e6301a,0x04fb600c,0x1082108e}},	//   _centrs_, _сайтқа_, _किसानी_, _לחבירו_, 
   {{0xe43f301e,0x2914d02d,0xe394d09d,0x4e46327e}},	// [550] _대전광역시_, _gurbangu, _asesu_, _humanida, 
   {{0x323a4273,0x5631c019,0xf348505d,0x00000000}},	//   _विशालकाय_, _erinomai, _lineari_, --, 
   {{0x93f40123,0x26823030,0x0200b238,0x520071ca}},	//   _postat_, _accesori, _medida_, _tenim_, 
   {{0x9d271138,0x42823233,0x4b4d9131,0x25b7b032}},	//   _مهرجان_, _alobacsi_, _eggwanga_, _disposiz, 
   {{0xcbee1167,0x725a2277,0x48438113,0xabcd61a1}},	//   _часом_, _fortælle, _contidos_, _privaats, 
   {{0x9fe9731e,0x92a1301e,0xb27ed1f2,0xef47d050}},	//   _संभावना_, _불가합니다_, _buena_, _maksimaa, 
   {{0x27c0e006,0x6290013d,0x00000000,0x00000000}},	//   _classifi, _seiat_, --, --, 
   {{0xd47f9116,0x7201f029,0xf27ff00d,0xdefd212a}},	//   _batterij, _maziko_, _efuna_, _графични_, 
   {{0x763f10c4,0xe9e130cf,0xe2005254,0x00000000}},	//   _personol_, _कस्टम_, _pelik_, --, 
   {{0xf2e641b0,0x6c03618b,0x0354a288,0x8575a1a7}},	//   _radnika_, _gampang_, _poderes_, _mendedah, 
   {{0xd3ea0055,0xd0472094,0x59c2c0b2,0x7ae851c5}},	//   _edite_, _тақозои_, _divendre, _certaine, 
   {{0x220260c7,0xfe725258,0xd2a71156,0x034f8048}},	//   _turizm_, _आरम्भ_, _парола_, _sebelah_, 
   {{0x415ac0c1,0xd57dc01e,0x329030bc,0x37bac276}},	//   _prirodno, _엔터테인먼트_, _temana_, _prirodni, 
   {{0xc3ced197,0x93fa500b,0x5cd21075,0x9200c0a7}},	//   _drevo_, _hatuwe_, _বৈঠকে_, _haline_, 
   {{0x5f24029c,0x0386912f,0x75c541bc,0xa2d2305f}},	//   _nederlan, _ziare_, _memboleh, _صديقك_, 
   {{0x90373278,0x8ae0d23b,0x9f2e117e,0xdf30d1e6}},	//   _cestovan, _netefats, _модифици, _muhteşem_, 
   {{0xc66400e5,0x5c7f6006,0xf2cae1dd,0xefe7b17e}},	// [560] _ग्रसित_, _january_, _rondom_, _правата_, 
   {{0xf2d8503f,0x926dc03e,0xa1b89106,0x44302243}},	//   _kolem_, _davon_, _recenzií_, _processo_, 
   {{0xb3f8520f,0x948641be,0x2667e0bc,0x0387f17e}},	//   _colum_, _सुपारी_, _amahangw, _couro_, 
   {{0x5ab48072,0x4386d178,0x73eae0e0,0xaaf8508b}},	//   _мушташ_, _piera_, _gentar_, _actuelle, 
   {{0xd290d0c9,0x33ce209f,0xdd2d1030,0x00000000}},	//   _manane_, _kakve_, _similare_, --, 
   {{0x43ead221,0x72a7f0ab,0xedc0d03d,0x0e4630b1}},	//   _tiotal_, _klubs_, _komisija, _tumanida, 
   {{0x4378d082,0xbe9ba04e,0x72e750d2,0x02012318}},	//   _olmayan_, _huguette_, _gjenden_, _seyid_, 
   {{0xc1773167,0xc147531f,0x129020ab,0x8a2680c5}},	//   _центр_, _desenvol, _nekas_, _बराबरी_, 
   {{0xd27ed316,0xf9efb08b,0x0290c030,0x00000000}},	//   _greno_, _injurieu, _dolari_, --, 
   {{0x6f5dd1aa,0x30763069,0x32d8306d,0x3d6f920f}},	//   _vinaphon, _مذاہب_, _rojek_, _seòladh_, 
   {{0xf38060f5,0x2394e0ce,0x155770b0,0x7290b0a2}},	//   _sutras_, _coiste_, _ninjasch, _vedada_, 
   {{0xcbd6f151,0x6a7210b3,0xfa8901a7,0x951cc0d2}},	//   _市场参考价_, _značka_, _perisian_, _zakonish, 
   {{0xb2cad15c,0x8394f0e5,0x029020f5,0x1200c11a}},	//   _vandag_, _siiski_, _mekas_, _mediu_, 
   {{0xd2d84060,0x0331005f,0x5757e084,0x00000000}},	//   _komek_, _اجنبيه_, _барлар_, --, 
   {{0x478412fb,0x53f14116,0x926c6247,0x29514116}},	//   _प्रस्तुत, _esportaz, _nkoos_, _esportat, 
   {{0x5f3fa170,0x00000000,0x00000000,0x00000000}},	//   _tangeran, --, --, --, 
   {{0x62ec2027,0x1b65a320,0x6878b043,0x6cd560c8}},	// [570] _rastliny_, _coolinar, _продовжу, _페이지까지_, 
   {{0xd1314030,0x52661006,0xcf114287,0x9951b19e}},	//   _produsel, _בביטוח_, _produsen, _kiellett, 
   {{0x99b14206,0xc011425d,0xf97a1034,0x3a809320}},	//   _producte, _producto, _architet, _domovins, 
   {{0xa3eaf03b,0x00000000,0x00000000,0x00000000}},	//   _leitar_, --, --, --, 
   {{0x9fae1223,0x9e8cb008,0xf2d822b3,0x00000000}},	//   _шарки_, _маслаҳат_, _koken_, --, 
   {{0xf290c116,0x729100cc,0x2290c2f1,0x12318015}},	//   _solari_, _babaye_, _salane_, _септембр, 
   {{0x2200206d,0x76830321,0x129031fa,0xb94e7151}},	//   _nekir_, _पोशाक_, _tamale_, _广州市白云山农产, 
   {{0x329011b1,0xbd676126,0x2c776155,0xb27f4104}},	//   _behar_, _базудӣ_, _popular_, _prenta_, 
   {{0xf912e074,0x00000000,0x00000000,0x00000000}},	//   _этапу_, --, --, --, 
   {{0x215f2138,0xcc7cd01a,0x07b79075,0x6200c055}},	//   _coinnigh_, _күтімі_, _ডোমেইন_, _galile_, 
   {{0x07d7c322,0x529020fe,0xe963d035,0xc2299075}},	//   _nadaljev, _bekas_, _あなたにおすすめ, _মুহম্মদ_, 
   {{0xf26de010,0x26b8507d,0xedd04247,0xd4b90207}},	//   _katon_, _глобальн, _fatherna, _दिनेशदा_, 
   {{0x22f21126,0x6c6d3141,0x62d8219c,0x40fca151}},	//   _аксар_, _porukom_, _boken_, _胶南市交通局_, 
   {{0x7877a1d7,0x3e41c0b1,0xc195c075,0xf2d8c1da}},	//   _правах_, _фарғона_, _নীড়পাতা_, _kodea_, 
   {{0x6393c09b,0x22003173,0x9e9ec243,0x226df276}},	//   _رابطه_, _mejis_, _табла_, _istoj_, 
   {{0x2377c069,0xac53d0e6,0x7594a0eb,0x03ead032}},	//   _فرائض_, _विदेह_, _студенат, _avete_, 
   {{0x178ac0dd,0x94ac714c,0xe3bfd095,0xc0d5d035}},	// [580] _приватно, _консулта, _zatvori_, _このサイトを評価, 
   {{0x70b2200c,0x91259112,0x6082f0f4,0x8cda7157}},	//   _प्रजातंत, _mielestä_, _abacondo, _видеобло, 
   {{0xa9d18173,0x117d2179,0x438061b0,0x825ad2a0}},	//   _muitimed, _odrastal, _jutros_, _fellur_, 
   {{0x2cf6108f,0xd2a7f148,0xa3794098,0xe291f06d}},	//   _адрес_, _kluby_, _tavalla_, _dizane_, 
   {{0x1200c196,0x0386b072,0x00000000,0x00000000}},	//   _balile_, _podria_, --, --, 
   {{0x7849e07d,0xd35ae151,0x1f2400e2,0xbad61151}},	//   _призначе, _从这里开始_, _bertamba, _中国国际广播电台_, 
   {{0xb387f1c5,0x7db9b317,0x1b499103,0x8291f28d}},	//   _jours_, _trenčian, _रास्ट्री, _nizane_, 
   {{0xc387e1cb,0xe98081ad,0x426e7017,0xc320018a}},	//   _intre_, _नियमों_, _across_, _agiye_, 
   {{0x027f4201,0x2adf3038,0xc1412075,0x52254323}},	//   _cuenta_, _komunite, _বেড়েছে_, _drekka_, 
   {{0xde72e324,0xac325270,0x08621002,0xc8c58075}},	//   _एकत्र_, _szeptemb, _राजगद्दी_, _সভ্যতা_, 
   {{0x65142162,0xa3c8709f,0x8cf7a0a2,0xfae5c002}},	//   _gaalkacy, _sasvim_, _हमशक्ल_, _संगठनो_, 
   {{0xb15cd030,0x5679d02b,0xdaaa80c8,0xf2d9e069}},	//   _тулар_, _neustále_, _구체적으로_, _beteg_, 
   {{0x330cb03f,0x6ae43155,0x5f24321b,0x0200c0a7}},	//   _upravit_, _septembe, _septemba, _dedim_, 
   {{0x412d217c,0x6fc67182,0x8a867325,0x5e8d20a1}},	//   _шарты_, _istorijo, _istorijs, _шаршы_, 
   {{0x4387f1c5,0x135f32c5,0x00000000,0x00000000}},	//   _cours_, _pengene_, --, --, 
   {{0x52da712a,0x23f45052,0x636cf0a5,0xa27e90b9}},	//   _essere_, _natten_, _tragovi_, _grann_, 
   {{0xb2dac03e,0x4387e11e,0x12da509a,0x52902010}},	// [590] _können_, _antre_, _gatete_, _sekar_, 
   {{0x0b63b035,0xd24902b0,0x825ad07d,0x1ef630eb}},	//   _アクセス解析_, _ciamar_, _felles_, _настала_, 
   {{0xd2484116,0x8ea2a035,0x001a1006,0x00000000}},	//   _somma_, _最新記事一覧_, _providin, --, 
   {{0x9290403a,0xe281c037,0x6a0fa137,0x934c70cf}},	//   _temat_, _possibil, _manažmen, _पाउंड_, 
   {{0xd0567187,0x122b3030,0x5f57214f,0x5e1b31b9}},	//   _अर्घाखाँ, _animale_, _टाँगे_, _animales_, 
   {{0xe38691c6,0x6290320a,0x4f698054,0xf379213e}},	//   _diari_, _dejar_, _sambilan, _elbasan_, 
   {{0x92fd629c,0xd2bc029f,0xfc1b8132,0xf29041a7}},	//   _liggen_, _verdien_, _kulantar, _kemas_, 
   {{0x58e3c1c6,0x9c187326,0x7caf5119,0x3e0da0f6}},	//   _редакция, _despois_, _jyväskyl, _ordenaga, 
   {{0x4c5042b2,0xcd9f009f,0x4c6f1109,0x42963027}},	//   _कैसेट_, _većina_, _fearann_, _funkciu_, 
   {{0xebd450eb,0xdc6161bf,0x8201800a,0x00000000}},	//   _генералн, _mutumba_, _derin_, --, 
   {{0x63954034,0x43640084,0xcb774042,0x00000000}},	//   _questo_, _чернобыл, _explotac, --, 
   {{0xd290e0fe,0x2b67420d,0xa20e10a1,0xf9f92032}},	//   _tenaga_, _कारने_, _нашар_, _alessand, 
   {{0x92730002,0xec0ba293,0x00000000,0x00000000}},	//   _politsei_, _egypten_, --, --, 
   {{0x32d841ae,0x5f4e0034,0xa2c4907a,0x0045e268}},	//   _nomen_, _versione_, _skuldig_, _चाइल्ड_, 
   {{0x7d23e02f,0xc20182f1,0xab05a1c3,0x8c59e1b1}},	//   _plusieur, _herin_, _grignion_, _testuak_, 
   {{0x80ae2006,0x8ad8d251,0x34800024,0x429181fd}},	//   _מוגובי_, _vánoční_, _फिनांस_, _beran_, 
   {{0x32902121,0x43187063,0xb2d46098,0x00000000}},	// [5a0] _cekap_, _hwjchim_, _kauden_, --, 
   {{0xd24950bc,0x0be0e0fd,0x4fc2c220,0x00000000}},	//   _depositi_, _interjer, _تابوت_, --, 
   {{0xe27f7022,0xe27e614a,0xfafa504b,0x6c39417d}},	//   _fransa_, _taong_, _pengurus, _descripc, 
   {{0xe2d870e0,0xefb1e0c8,0xdae4209a,0xd31770f6}},	//   _konek_, _주절거리기_, _ingengab, _plazan_, 
   {{0xc290506d,0xef6fc153,0x93954323,0x0fea4327}},	//   _welat_, _palabras_, _flestu_, _dubrovač, 
   {{0x528c70c3,0xb27f2046,0xe7560069,0xf20190a7}},	//   _בליץבריו, _quynh_, _ماہنامہ_, _kesin_, 
   {{0x5343006a,0xfecef087,0x0ec7e017,0x00000000}},	//   _vitendo_, _varnostn, _efficien, --, 
   {{0x9200410f,0x9f21f0d1,0x23fa70a7,0x00000000}},	//   _demir_, _utilizar_, _kurulu_, --, 
   {{0x925a0104,0x92cae186,0x12005004,0x72b5b1dd}},	//   _deild_, _hendes_, _kelis_, _misdaad_, 
   {{0xaa14406a,0xd290c2c6,0xa201827b,0xa37e50b4}},	//   _mahakama_, _sedam_, _verin_, _kusabab_, 
   {{0x128c3138,0xf25a90f2,0x9cf75047,0xf2879245}},	//   _الصمت_, _adala_, _लेखकों_, _alekane_, 
   {{0x918a607c,0xd3195092,0x00000000,0x00000000}},	//   _матеріал, _abychom_, --, --, 
   {{0x92d85044,0xa1c3d223,0x00000000,0x00000000}},	//   _dolen_, _рогозин_, --, --, 
   {{0x5394b328,0xf27e9083,0x225a91bf,0xe25a0003}},	//   _često_, _laang_, _ddala_, _heild_, 
   {{0x237a0010,0xeded8329,0xa290c0a3,0xeb09432a}},	//   _perawan_, _विद्यालय, _sedaj_, _composte, 
   {{0x324a72c1,0xf3f4700e,0x4201810e,0xe3ec20c1}},	//   _termos_, _lasten_, _perin_, _sastavni_, 
   {{0xcc50402e,0x527e707a,0x671da20a,0x080a9043}},	// [5b0] _कैरेट_, _manne_, _situació, _стоять_, 
   {{0xd27e929c,0x425a00e5,0x9200402d,0x7200519e}},	//   _maand_, _meile_, _temir_, _pelit_, 
   {{0xc09a403a,0xe8152188,0x827e203b,0x4f8c90e5}},	//   _प्रयोगपृ, _sacensīb, _vakna_, _हक्का_, 
   {{0x77c95047,0x2ee3d0e6,0x0e70f016,0x00000000}},	//   _dostosow, _पूर्वाधा, _לאָנדאָן_, --, 
   {{0xeaa910a1,0x0ffb00c5,0xf2ddf095,0x4609d079}},	//   _терезе_, _सोसाइटी_, _otrovni_, _анексей_, 
   {{0xe2916018,0x0a15e163,0x5291a048,0xe1ac405a}},	//   _negara_, _forbinde, _depan_, _adlandır, 
   {{0x7f7390a3,0xff4711c6,0xcb92a006,0x52918084}},	//   _posamezn, _comprova, _אינדקסים_, _seran_, 
   {{0x44919213,0x522582f8,0xa27e90b4,0x50f390c3}},	//   _धर्मे_, _markt_, _gaang_, _קאשוי_, 
   {{0x4edc6014,0x5737a243,0x1c34f022,0x1a93c10a}},	//   _sociales_, _таблети_, _bannerlə, _монети_, 
   {{0xab613142,0x72905043,0x0783300e,0xb05a3027}},	//   _तुमने_, _delar_, _harvinai, _zaciatok_, 
   {{0x1c0ae21a,0x7291817e,0x1394d072,0xf27e0098}},	//   _kroppen_, _geral_, _aposta_, _paino_, 
   {{0xd8962147,0x8290c25f,0x79c71072,0x0b3432a0}},	//   _тартиб_, _ibland_, _карама_, _sambands, 
   {{0x33788035,0xa2e120f3,0x262b103f,0x525a00e5}},	//   _ひとりごと_, _pozitif_, _खेलहरु_, _neile_, 
   {{0x924a70a8,0x22919170,0xb2a6a100,0x00000000}},	//   _termes_, _pesan_, _tibbi_, --, 
   {{0x73eab28f,0x8d7c901e,0x3736d043,0x2e8d1094}},	//   _þetta_, _블로그에서_, _stilling, _нақши_, 
   {{0x6507d206,0x514632db,0xe290f174,0xfb1320a4}},	//   _allemaal_, _गारंटी_, _tegal_, _hinanden_, 
   {{0xf20142a0,0xcc6f028b,0xf23e4122,0xa7737275}},	// [5c0] _fleiri_, _doprava_, _кормандо, _प्रसिद्ध, 
   {{0x5777c314,0x23fa71dc,0x00000000,0x00000000}},	//   _биологи_, _durust_, --, --, 
   {{0xd2d851f1,0xc3eae046,0x825b706f,0x54eac02f}},	//   _elles_, _toitim_, _chalon_, _第三十二条_, 
   {{0x429190b9,0x9987900c,0x090eb035,0xa27a80a7}},	//   _resan_, _स्तम्भ_, _はじめまして_, _kaliteli_, 
   {{0x9a23b0ab,0x86d10092,0x02fcf32b,0x2aeb3191}},	//   _darbinie, _symbolem_, _bygge_, _lamongan_, 
   {{0xf8c8606b,0xdd230106,0x0ea2f085,0x00000000}},	//   _финансиј, _položiek_, _contiene_, --, 
   {{0x3eaa703c,0x937fc049,0xf422a01e,0xe2318014}},	//   _この回答内容が不, _armanca_, _개인정보를_, _primero_, 
   {{0xe200711a,0xfb18b122,0x963920cd,0xa27801ce}},	//   _venit_, _компютер_, _палатасы, _bisnes_, 
   {{0x52d99277,0x420160ee,0x42d8e1c6,0x00000000}},	//   _olsen_, _begira_, _diners_, --, 
   {{0xdc6bb18a,0xb0a922ff,0x2bf7500d,0xa58a00f8}},	//   _burundu_, _подарить_, _mustahab, _সামগ্রী_, 
   {{0xe132a03f,0x626df0b1,0x1486732c,0xb2901173}},	//   _reklamní_, _iston_, _तरकारी_, _nthaw_, 
   {{0x0394911a,0x214020a9,0x7387f055,0xa200d089}},	//   _acasa_, _तेंडुलकर_, _pouri_, _splitu_, 
   {{0xd2d470a4,0x5f6c2084,0x63c870fb,0x727e90b4}},	//   _onsdag_, _кыска_, _servei_, _asana_, 
   {{0x5237e304,0x9e954017,0x52ff410f,0xedb51280}},	//   _chimera_, _התלמידים_, _veriyor_, _stagione_, 
   {{0xc2267116,0x2682c171,0x22e85082,0xa2c9820f}},	//   _avukat_, _novembri, _mutfak_, _poblach_, 
   {{0x0f24019b,0xe2f2832d,0xa2611049,0xe2d8b0a7}},	//   _zašto_, _karimov_, _helbestê_, _nedeni_, 
   {{0x498ec0f7,0x63dc00d0,0xe21a102b,0x7a5da07b}},	// [5d0] _самим_, _njiwa_, _centráln, _takúto_, 
   {{0xde9640a9,0xd386009a,0x23be00ac,0x9bed717e}},	//   _राष्ट्रव, _nzira_, _živali_, _fevereir, 
   {{0x0201a110,0xe3ebf079,0x44a7c1c6,0x6743307d}},	//   _davide_, _ajuta_, _балким_, _курси_, 
   {{0xd10c809f,0xeefc701a,0x7692a1dc,0x07bb21c8}},	//   _slučajev, _нормалар, _унутдинг, _gjermani, 
   {{0x22cad06c,0xcc009042,0x08709042,0x22d84017}},	//   _mandag_, _básica_, _básicas_, _homes_, 
   {{0x82907171,0xa38b51e7,0xe2d871fd,0x12907052}},	//   _cenas_, _würde_, _honen_, _menar_, 
   {{0x9d44503c,0xc69c214c,0xb249f0dc,0x727e0191}},	//   _最近の記事_, _достатъч, _udumo_, _raine_, 
   {{0x1c751305,0xe2d84171,0xb0e8e05b,0xc27ed0b9}},	//   _रात्री_, _domes_, _christel, _grenn_, 
   {{0xe531a158,0xac5b3098,0x2405d232,0x5f1e41e9}},	//   _najčitan, _minulle_, _armonizz, _проектів_, 
   {{0xc2d8532e,0x72d84174,0x026e5084,0x13eb706f}},	//   _eller_, _nomer_, _antoni_, _statud_, 
   {{0x4546c11a,0x2ae21069,0xa3f85247,0x9429c244}},	//   _брашов_, _تھریڈ_, _lolus_, _tampilan_, 
   {{0x2290c0a9,0x29c52050,0x00000000,0x00000000}},	//   _celana_, _matemaat, --, --, 
   {{0xd7cc20b8,0x941e409a,0xc1e0a071,0x92fce2f1}},	//   _dysplasi, _kiganiro_, _हंगरी_, _lingan_, 
   {{0x63438106,0xbcdea247,0x829071c7,0xcf2dc0e2}},	//   _členom_, _hiavtxwv_, _denar_, _kepentin, 
   {{0x3dcef01e,0xd27f7003,0xc2fda240,0xd2d84155}},	//   _베스트셀러_, _standa_, _tveimur_, _comes_, 
   {{0xda3500a1,0x8c5e303e,0xf8e68079,0x9ba6000c}},	//   _субъекті, _erstmal_, _арэтат_, _अमित्र_, 
   {{0x726f509e,0x426de0f2,0x2fa30017,0xd35bd04a}},	// [5e0] _piripiri_, _matoa_, _director_, _pulgada_, 
   {{0x76eb5186,0xedc41030,0x794d403a,0x8291c11e}},	//   _ランキング_, _articole_, _चित्रकूट_, _devan_, 
   {{0x67a9f065,0xbd13a12b,0x9ba4c14f,0x5c5ba063}},	//   _harmadik_, _регулято, _संयुक्ता, _lubtsev_, 
   {{0x629072fa,0x2a57d04c,0xf0b3f09f,0x00000000}},	//   _benar_, _каменка_, _američke_, --, 
   {{0x9f2d6042,0xd49c0075,0x8cd39119,0xf76011e9}},	//   _advertin, _চিহ্নিত_, _голову_, _чергу_, 
   {{0x19e481f9,0xe20181a0,0x223760cb,0x9c5fd0f3}},	//   _manokana_, _verib_, _völlig_, _septanm_, 
   {{0xc70790b5,0x94c8901a,0xbc1da006,0xefd720fd}},	//   _газеты_, _мамандар, _לשאול_, _svetainė, 
   {{0x40075186,0xf8c5c035,0x00000000,0x00000000}},	//   _甲信越地区_, _の検索結果_, --, --, 
   {{0x625a9316,0x7762b1a4,0x5c7571a1,0xb27c6197}},	//   _ovala_, _легендат, _रहस्यन_, _cudzích_, 
   {{0x2e59208b,0xb27e9084,0x02d8c031,0xb7a1004e}},	//   _推荐给朋友_, _quant_, _podem_, _resumpti, 
   {{0x5d9ad119,0x0c68614c,0x91b830c3,0x3518614c}},	//   _статьи_, _annunci_, _פארזיכער, _annuncio_, 
   {{0x0cb25075,0x92fce1e0,0x22925174,0xeaf2632f}},	//   _মুরগী_, _dingin_, _betawi_, _consecue, 
   {{0x8fba90f1,0x03f461ce,0x2170201c,0x5bf77016}},	//   _augustus_, _pautan_, _različit_, _מסתּמא_, 
   {{0xb255e071,0xd4f4b031,0x92ca91d4,0xc2d841d8}},	//   _सिलेबस_, _acompanh, _idade_, _comer_, 
   {{0xe6d60138,0x4200b0b1,0xa89551c7,0x32cd90af}},	//   _لايمكنك_, _oldini_, _posvetov, _angoang_, 
   {{0x11518072,0xe2d8506f,0xfd2de0b9,0x36db20fc}},	//   _энергияс, _solet_, _rekipere_, _srebreni, 
   {{0x8290c09f,0xe2ec101a,0xc3ce20a5,0xbc64d159}},	// [5f0] _dolazi_, _бостанды, _takve_, _pivtxwv_, 
   {{0x527e9176,0xd3eb7210,0x9c230133,0x799e2039}},	//   _isang_, _quatre_, _poprvé_, _البرادعی_, 
   {{0xb7661006,0x1dd2d119,0x33f850d2,0x56b980db}},	//   _ושומרת_, _стиль_, _folur_, _benachri, 
   {{0x72b58006,0x7b5df1e5,0x927e006a,0x9b0150cb}},	//   _march_, _norwegia_, _haina_, _sonstige, 
   {{0xc27e002c,0xd3cf707b,0xc291d033,0xbaea8116}},	//   _kaina_, _stavba_, _hewan_, _adattame, 
   {{0xe181d1c2,0xb84a1243,0x2d91e014,0x00000000}},	//   _सर्वे_, _фотки_, _cantidad_, --, 
   {{0xe27e0110,0xde4960c7,0x29adc121,0x12ef712f}},	//   _maina_, _olmayaca, _مجتبی_, _trafic_, 
   {{0x227ed02a,0x025b6180,0xf3874240,0x32cae17e}},	//   _vuonna_, _poglej_, _hversu_, _vendas_, 
   {{0x52da60f7,0xc2fcf00f,0x1e618027,0x3c1bd287}},	//   _barend_, _bygga_, _prebieha, _pekanbar, 
   {{0xfc5370b4,0x52fce09b,0x3316f0ee,0x5386d2cc}},	//   _hartina_, _pingin_, _baizik_, _mieru_, 
   {{0x635aa155,0x69ebe0c5,0xa228c175,0x53fa20cd}},	//   _perfect_, _मारवाडी_, _portfóli, _paquet_, 
   {{0xd305a051,0x82ca60d2,0x0201e060,0x926d3138}},	//   _članak_, _ndodh_, _ketin_, _macosx_, 
   {{0x62d8f2b4,0x92d84027,0x40373191,0x7a904081}},	//   _vogel_, _pomer_, _قرمزی_, _indirimb, 
   {{0xb2d9a15c,0x92fce225,0xeb6870ff,0xdac11191}},	//   _amper_, _tingin_, _əleyhinə_, _سنندج_, 
   {{0x13f851d9,0x5f21207e,0x5b03a004,0x2193409d}},	//   _solus_, _diperken, _antradie, _dosbarth_, 
   {{0xe95dd236,0x996d40b2,0x02857029,0x1b88f06c}},	//   _tjeneste, _visionat, _bulking_, _eksister, 
   {{0x62905102,0x427f7330,0x00000000,0x00000000}},	// [600] _aflat_, _tuanya_, --, --, 
   {{0xf26dc241,0x1c88215d,0x216c9155,0x00000000}},	//   _izvor_, _деярли_, _activity_, --, 
   {{0xd321811e,0x736481a5,0xaae84089,0xcc01a003}},	//   _berya_, _sangkan_, _izloženi_, _flestir_, 
   {{0x02fce14a,0xf679c015,0xcc5d907d,0x00000000}},	//   _linggo_, _региону_, _sentrum_, --, 
   {{0x7ed4005b,0xfbaa602a,0x43cee0cc,0x00000000}},	//   _inligtin, _прикольн, _ativan_, --, 
   {{0xa27ff107,0x924a708b,0x8a004008,0x00000000}},	//   _grund_, _permis_, _чемпиони_, --, 
   {{0x9386632f,0x9eb301d4,0xd1c93331,0x534301d4}},	//   _ahora_, _direitos_, _поате_, _direito_, 
   {{0x42918118,0x2a4f32a8,0xe70990a1,0x9fee6151}},	//   _gerai_, _nijeriya_, _аналар_, _国家体育总局_, 
   {{0xc3492146,0xc863a006,0x2316005a,0xf2d8517c}},	//   _diversi_, _ברלין_, _faizi_, _voler_, 
   {{0x3136d138,0xdc5740b3,0x00000000,0x00000000}},	//   _مراقب_, _dostane_, --, --, 
   {{0xfaf4c1ca,0xdfeaf1ad,0x4c73f1f9,0x00000000}},	//   _estrange, _विभागों_, _raisina_, --, 
   {{0x37ed4092,0x42ca5190,0xda91a0de,0xef2a2204}},	//   _fotbalov, _melde_, _händelse, _банковск, 
   {{0x2d43d043,0xe2d9809f,0x41ed403f,0x55c831d7}},	//   _автомобі, _pored_, _formulář, _значна_, 
   {{0xce173195,0x31772019,0xa292608c,0xf2d870b2}},	//   _значи_, _месте_, _tirane_, _dones_, 
   {{0x43893119,0x6140e332,0xa291e1ab,0x27e7c0f9}},	//   _рождения_, _तिरंगा_, _wetan_, _филиалы_, 
   {{0xa27ff0ef,0xa264710f,0xbae1c18b,0xa291810e}},	//   _trung_, _teslim_, _पथ्यकर_, _ndray_, 
   {{0xb38660b1,0x22eba104,0x8d862094,0x1a7480ce}},	// [610] _chora_, _stendur_, _дастҳо_, _ranganna_, 
   {{0x45fdb333,0x4dc4111a,0xa248d1b8,0x2dc40016}},	//   _direcció, _ultimele_, _filmes_, _מאַשין_, 
   {{0x7f3fa0a5,0xd29031e0,0x2ffa3019,0x873b1151}},	//   _osiguran, _remaja_, _работник, _第三十九条_, 
   {{0xbfb2c138,0xb24c50c5,0x4200b201,0x07be00c8}},	//   _ندعوك_, _हिटलर_, _decir_, _토지문학공원_, 
   {{0xe2d8c1ce,0x52df1240,0xbd1fc068,0x23eae042}},	//   _moden_, _menning_, _beslenme_, _centos_, 
   {{0x7349d18d,0x3d5a40fd,0xe61e3084,0x00000000}},	//   _ditemui_, _раздавал, _laboraci, --, 
   {{0x52fe6121,0x6af7c24a,0x22d8a162,0x00000000}},	//   _dirilis_, _газети_, _dobel_, --, 
   {{0xa3438322,0xd87ae251,0x826c81ec,0xa19c605f}},	//   _namenom_, _बर्दिया_, _mikono_, _فتافيت_, 
   {{0xb22ac1ef,0x1728802b,0x2949e084,0xf3ce209f}},	//   _годам_, _publikov, _гражданд, _kakva_, 
   {{0x88060282,0x425a50e5,0x9201801b,0xf378d082}},	//   _אינטרנט_, _kelle_, _meriv_, _olmadan_, 
   {{0x4396604f,0xf386a034,0xa394e0fd,0x00000000}},	//   _eerste_, _messaggi_, _maisto_, --, 
   {{0xc2cae32e,0x6225f067,0x7201e174,0x5ad741da}},	//   _landet_, _lauku_, _detil_, _partekat, 
   {{0xa8535334,0x829160b2,0x1f81f195,0x6e7c600c}},	//   _dossiers_, _vegada_, _германиј, _परस्त_, 
   {{0x36086098,0x12cae0d2,0x949ac0c8,0xf3335196}},	//   _normaali, _vendos_, _전자상거래등에서, _alexor_, 
   {{0x1290612e,0x63d88075,0xd225009f,0x00000000}},	//   _tulad_, _বাঁড়ার_, _svakoj_, --, 
   {{0xeab15027,0xf87e008e,0xb2908098,0x00000000}},	//   _telefónu_, _קונטרס_, _mukava_, --, 
   {{0x6529011e,0x71abd151,0xfcbda02a,0xd2f42030}},	// [620] _definisy, _位读者读过此文_, _наверное_, _ultimul_, 
   {{0x6759c099,0xa8ec8182,0x8487d06b,0xdeb6c01a}},	//   _निर्मित_, _законных_, _лидера_, _элементт, 
   {{0x52574075,0x9290403d,0x32d8c2aa,0x2da8d116}},	//   _আশঙ্কা_, _nemaz_, _boden_, _attivita, 
   {{0x227f4026,0x1f696039,0xabd16194,0x2abac0de}},	//   _mwendo_, _hatalmas_, _kundeser, _gravidit, 
   {{0x7386a034,0x52d1b09b,0x3c5421c3,0x00000000}},	//   _libri_, _kelopak_, _lintawd_, --, 
   {{0xf36960ea,0xd200f29c,0xef892031,0xe3869221}},	//   _imagens_, _manier_, _терапии_, _mhara_, 
   {{0x9b7781ad,0x5f5bb335,0x9245b28e,0x7386a01e}},	//   _podobnyc, _innanlan, _mendalam, _bedrag_, 
   {{0x0e10f336,0x4292004d,0x3a084152,0xcff400c5}},	//   _रामरक्षा_, _espace_, _буржуазн, _निराकरण_, 
   {{0xa1fe50f2,0x626e5081,0xe641c079,0x00000000}},	//   _taratasy_, _matora_, _атурэ_, --, 
   {{0x691731b5,0xd2ca90ba,0x82d9e03e,0xb5a6d002}},	//   _далеко_, _idadi_, _alten_, _कसरती_, 
   {{0xc2024010,0xa25ae045,0xd2490232,0x7d9bd0b3}},	//   _akting_, _buille_, _stampi_, _autoseda, 
   {{0x42da619a,0x5fe7e119,0x449790b1,0x8ae01138}},	//   _kereta_, _пароль_, _оқланмаг, _للبلاك_, 
   {{0x525ad00c,0x805330bf,0x304720cd,0x82f0e2e4}},	//   _selles_, _sportovn, _нерсе_, _berilah_, 
   {{0xfc42b015,0x3b725035,0x36cf515b,0x02a60086}},	//   _непознат, _地域共同研究セン, _difasili, _naibu_, 
   {{0x32870065,0xc15bf02f,0xd2eee0a4,0xcc75a173}},	//   _مہمان_, _月参加工作_, _kaffe_, _puasyog_, 
   {{0x22a63174,0x37f3c008,0xd3ddf09e,0x747ec0f7}},	//   _nambah_, _ажойиб_, _okuwa_, _ринок_, 
   {{0xe292631b,0xb200707a,0x2199d06b,0xc3eac166}},	// [630] _kitabu_, _junie_, _манипула, _adotta_, 
   {{0x32da5087,0x3ac02087,0x37eab035,0xad71e0fd}},	//   _katere_, _različne_, _クラシック_, _premjera, 
   {{0x4bda517e,0x12d8c0fb,0xc2d8c155,0x72bf11fb}},	//   _родители_, _poden_, _model_, _حملات_, 
   {{0xa3f4603e,0xb3eae134,0xa25ad1ae,0x00000000}},	//   _garten_, _ventes_, _avela_, --, 
   {{0x827d024c,0x43869110,0xdde4d0f9,0x235f306a}},	//   _materiál, _chara_, _экспедиц, _mengine_, 
   {{0xa2007030,0x9758d195,0xee1070b0,0x00000000}},	//   _iunie_, _финансис, _thằng_, --, 
   {{0xb37fc102,0x4200c0b7,0x8290313c,0x2290c1ce}},	//   _romania_, _sedir_, _armanc_, _sedar_, 
   {{0xc2ca7337,0xba6740ff,0xfccaf160,0x4652d1a0}},	//   _dende_, _mütləq_, _spēļu_, _braziliy, 
   {{0xf1cbf0ee,0x73f4016f,0x00000000,0x00000000}},	//   _besterik_, _mistet_, --, --, 
   {{0x127e431b,0xc3f0413b,0xcc5fc01c,0xd313a323}},	//   _namna_, _prasasti_, _sestrom_, _umleið_, 
   {{0x3ea5b0ee,0x7f3c50e8,0x42fce008,0x7c68218a}},	//   _bestalde_, _dikurnia, _rangli_, _cyprien_, 
   {{0x24b6320d,0xd2025282,0x7c6ba02e,0xa88a10c8}},	//   _कुंडी_, _action_, _काल्हु_, _민주노동당_, 
   {{0x02ca7338,0x0200d09f,0xe27e4187,0x43ea70a4}},	//   _hende_, _ranije_, _kamna_, _hente_, 
   {{0x127e60bc,0x883681c6,0xf27e0081,0xadf0c191}},	//   _tsona_, _таасир_, _nyine_, _انبوه_, 
   {{0x5f320339,0xbfeda016,0x53bbd069,0x424981d9}},	//   _preferan, _כסליו_, _اسٹاف_, _gorma_, 
   {{0x82d960f5,0xaf4b0012,0xbb0b017c,0x00000000}},	//   _ligers_, _resposta, _resposte, --, 
   {{0xb25a9110,0x42cae194,0x7d2d92f1,0x8bb270ec}},	// [640] _udali_, _sendes_, _vedigere_, _conexão_, 
   {{0xb2979023,0x7344b081,0xa3f47062,0x00000000}},	//   _кампир_, _mirenge_, _gasten_, --, 
   {{0x2d80a1c2,0xadd100fb,0x8ba48051,0x9292631b}},	//   _मुख्यमंत, _projecte_, _radionic, _vitabu_, 
   {{0x52d830af,0xc9fbb09b,0x370ac1d7,0x1d9e10af}},	//   _romela_, _kapungku, _эсперант, _millenia, 
   {{0x0200f13d,0xbb19e2c2,0x3c6140b7,0x225a90c9}},	//   _megis_, _relasyon_, _gautier_, _kwala_, 
   {{0x42d8c16f,0x414ec0ce,0x31dec26c,0x00000000}},	//   _alder_, _agallamh_, _agallaim, --, 
   {{0xb3998069,0xa27e71bf,0x4150e0a7,0xe53e6071}},	//   _másik_, _banne_, _hareketl, _zapisany, 
   {{0x6291807a,0xa344a095,0x539460bd,0xd9bd1071}},	//   _veral_, _istekne_, _epost_, _chociaż_, 
   {{0x7394e123,0x0308b02f,0x3d6600c3,0x23f1629c}},	//   _ganska_, _股权登记日_, _הייזער_, _zaterdag_, 
   {{0xe61210c3,0xdbe01186,0x79aa3147,0xf6b0b270}},	//   _אַזעלכע_, _accepter, _солим_, _kizáróla, 
   {{0x627e0029,0x9acbf06d,0xb27e9176,0x6c189079}},	//   _chino_, _perwerde, _paano_, _милилитр, 
   {{0x126c809f,0xa26c6063,0x00000000,0x00000000}},	//   _nekome_, _xyoos_, --, --, 
   {{0xb387a23b,0x7ee2d17c,0x29ed91ed,0xcc1e9035}},	//   _cipro_, _атаке_, _redigera_, _リストマニア_, 
   {{0xb201818e,0xea0e2084,0x538601e4,0xabe261e9}},	//   _herim_, _орхон_, _gairm_, _створити_, 
   {{0x7c649075,0x1345514e,0x00000000,0x00000000}},	//   _অপেশাদার_, _sigurisë_, --, --, 
   {{0xa1f1c02f,0x71f741a2,0x440080b0,0xf787a024}},	//   _订阅该问题_, _zemljišt, _nguời_, _तत्वों_, 
   {{0xf34ef25e,0x0aec3116,0x52f16006,0x894631e9}},	// [650] _emberek_, _attraent, _saturday_, _сайтів_, 
   {{0x329492b2,0x54315075,0x82d8c1c6,0x7290d1a5}},	//   _विनोबा_, _আংশিক_, _podeu_, _salaku_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xb315d04a,0x2651b17d,0xb2d8b27e,0xe51a00c8}},	//   _burbank_, _educació, _voces_, _모르겠지만_, 
   {{0x7394e0ba,0x72a13148,0x1394b236,0x536fb182}},	//   _maisha_, _pravidlá_, _eneste_, _vertinim, 
   {{0x3200111b,0xaf4dd1d7,0x92902254,0xeaea70a7}},	//   _muhim_, _конкурса, _sukan_, _sistemle, 
   {{0x36dcb02e,0xfc53626d,0x927f1095,0x0867a08a}},	//   _बंदिश_, _स्पेन_, _kazne_, _кремль_, 
   {{0xd27f40d2,0x5a376042,0xa4d76042,0x5b03a177}},	//   _brenda_, _técnica_, _técnico_, _lárionad_, 
   {{0x69ef8019,0x72fd00b2,0x127f7316,0x835b1098}},	//   _известны, _socials_, _mganda_, _изменить_, 
   {{0xd290b1b5,0x11b03069,0x52cad062,0x00000000}},	//   _dodaci_, _منسلک_, _handig_, --, 
   {{0xf2e900d2,0x6977d27e,0x430e6067,0x90d4d320}},	//   _berisha_, _entidade, _vasaras_, _poručuju_, 
   {{0xddf1e255,0xe3329063,0xbb19d01a,0x8f4bf08b}},	//   _mendapat_, _kojxwb_, _ендеше_, _consomma, 
   {{0x81f3a006,0x8031a287,0x4861b2cf,0xece7a094}},	//   _אריאל_, _मलाही_, _donnchad, _таблиғ_, 
   {{0xefdf9327,0xd294e33a,0xaa48800d,0x1e9b1035}},	//   _najvažni, _ज्यादातर_, _yeremiya_, _プレスリリ_, 
   {{0xa84f8175,0xaeb92134,0x829030c1,0x94657204}},	//   _mimoriad, _chiffres_, _rujan_, _страхова, 
   {{0x311da102,0xc9e2c191,0xe1939016,0xc27e60c9}},	//   _проблеме_, _باشيد_, _פאַקט_, _haona_, 
   {{0xd27e0225,0x1354a0a6,0x7c93c1ee,0x4985001c}},	// [660] _aking_, _anderes_, _باغات_, _navikama_, 
   {{0x3290933b,0x9ad511f1,0x5a4a8087,0xc50300f3}},	//   _staan_, _postadre, _katerega_, _refleksy, 
   {{0x08ab602f,0x2bfb602f,0x19db602f,0x2c5b8038}},	//   _第三十一条_, _第三十三条_, _第三十七条_, _postimi_, 
   {{0x3577f118,0x284cd01e,0xa29040a9,0x445e50fe}},	//   _кафедры_, _않았습니다_, _cuman_, _menentuk, 
   {{0x03f462f1,0xf82140b0,0x8200b0db,0xc2248062}},	//   _hertim_, _kiếm_, _medien_, _pakken_, 
   {{0x704720e6,0x26224027,0xb70e0006,0xb224e08f}},	//   _पर्याप्त_, _narodeni, _יונדאי_, _paikka_, 
   {{0xf6590182,0x92061138,0x124400e6,0xf5a39031}},	//   _настольк, _ناروتو_, _उत्तीर्ण_, _помеѓу_, 
   {{0x382832ca,0xe290401b,0xc39602c6,0x3e1a219a}},	//   _центра_, _guman_, _srpska_, _dikemuka, 
   {{0x5200f104,0xd27e70ef,0x3af33010,0xa24a6071}},	//   _segir_, _gunny_, _عبدالمال, _firmie_, 
   {{0x4def7039,0x929190d2,0x5f1921b7,0xbcc41007}},	//   _اجتماعات_, _kesaj_, _детайли_, _artikolu_, 
   {{0x84273086,0xa5ecc043,0x2296b23a,0x82d92334}},	//   _matatizo_, _повернут, _mematuhi_, _moyen_, 
   {{0x03f8e015,0x1eb1633c,0xa39590cb,0xc4e3733d}},	//   _ponuda_, _externas_, _passt_, _विषयसूची_, 
   {{0xa2918023,0x57bbe14c,0x9369200f,0x753cc157}},	//   _kerak_, _останали, _bloggar_, _постсове, 
   {{0x141cf02d,0x82786102,0xc6dc326d,0x53d52032}},	//   _электрон_, _atunci_, _दाखिल_, _contatti_, 
   {{0x71e2c071,0x427f70e8,0x86d81199,0x92d8700e}},	//   _करारा_, _duanya_, _univerzá, _monet_, 
   {{0x7da6f095,0x9290b158,0x62d8c113,0x2895d2fc}},	//   _ispitiva, _podaci_, _podes_, _pulvinar_, 
   {{0xb781626e,0xc2cad176,0xea47504e,0x00000000}},	// [670] _व्यापारि, _pwede_, _anselara_, --, 
   {{0x59d17075,0xf27e6146,0xc225f071,0x0290f33e}},	//   _গার্মেন্, _skond_, _nauki_, _pegar_, 
   {{0x52019215,0x5b8ac072,0xd396317e,0xf2b52299}},	//   _resim_, _кокон_, _ивановск, _abych_, 
   {{0xd2d4604d,0x93eb0155,0x82497129,0x41ede185}},	//   _jardin_, _status_, _nyampe_, _मकबरा_, 
   {{0x127e7104,0x237d400b,0xd1d200b0,0xd173f118}},	//   _manna_, _rusange_, _đôrêmon_, _бочках_, 
   {{0x82d8e173,0x2290810d,0xa3fa7006,0x0b041006}},	//   _linens_, _alhaji_, _forums_, _ברגשות_, 
   {{0xb290402d,0x7038e232,0xb635b25e,0x472d22b5}},	//   _tuman_, _dimensjo, _garanciá, _uostalom_, 
   {{0xaef1b118,0x32786100,0x1069d106,0x1eb7b151}},	//   _paskutin, _olunan_, _prepojen, _中华人民共和国行, 
   {{0x8947309f,0x2dbd42b0,0xc2f19087,0xc8e4a12a}},	//   _uključuj, _legalese_, _samostoj, _италианс, 
   {{0xe2d9607a,0xbfe34138,0xe3eb71de,0xec80c0f9}},	//   _engels_, _مماثلة_, _fiatal_, _кеден_, 
   {{0xd386933f,0xbbefb199,0x92ff4072,0x42d8b2fd}},	//   _whare_, _pardubic, _arribar_, _vedeli_, 
   {{0x3bd20136,0x1b97320a,0x403a8068,0x204b7033}},	//   _अनुपम_, _relación_, _ergeneko, _रांगोळी_, 
   {{0xba82802f,0x67f7c0b1,0x6380602a,0x3ad00170}},	//   _市政府主要部门_, _табиий_, _verran_, _keamanan_, 
   {{0x7b271121,0x5dc9b1d1,0x00000000,0x00000000}},	//   _المپیک_, _तथ्यांक_, --, --, 
   {{0x68868071,0x327ff0e5,0x58701006,0x00000000}},	//   _मूवीरिव्, _juuni_, _standard, --, 
   {{0x26c52083,0x831cb340,0x2413d0fd,0xe394f089}},	//   _pamamagi, _sábado_, _пожелаю_, _blisku_, 
   {{0x91ccd072,0x990a0280,0x0d85328e,0xfa3b4191}},	// [680] _кылат_, _наказани, _permulaa, _شرکتها_, 
   {{0xb543f023,0x2db7a121,0xf201a14c,0xe290606d}},	//   _komissiy, _دیپلمات_, _страници_, _gulan_, 
   {{0xfcf8c072,0x425b00f5,0x06153126,0x92903068}},	//   _принципт, _kablig_, _мусиқии_, _numara_, 
   {{0x523670e8,0x62902069,0x8beda10f,0x00000000}},	//   _janji_, _kukac_, _gerektir, --, 
   {{0x4394e04d,0xa1c92147,0xe93fe08d,0x7a47320b}},	//   _maison_, _рости_, _verminde, _uključen, 
   {{0x4645f01e,0x227f70ff,0xa9f09179,0x227ba092}},	//   _소프트웨어_, _iranda_, _pronasla_, _kalendář, 
   {{0xa27e906a,0xe589b13a,0x4200625d,0x6a2bd075}},	//   _maana_, _pasaulē_, _julio_, _চাহিদা_, 
   {{0x40d33108,0xb745316b,0xdfd8317e,0xf3ea01c5}},	//   _гласа_, _удара_, _детство_, _boite_, 
   {{0xd34451b2,0x02ca807e,0x220060ce,0x52003057}},	//   _recenze_, _dialami_, _troid_, _komini_, 
   {{0xb61c213d,0x269b2079,0x79d211b6,0x00000000}},	//   _statudol_, _акциун_, _sererast, --, 
   {{0x3c2970e2,0xf27ec095,0xb320024e,0xe2d83032}},	//   _pembayar, _radno_, _ariyo_, _numeri_, 
   {{0xd4e300f8,0x00000000,0x00000000,0x00000000}},	//   _বৈশাখ_, --, --, --, 
   {{0xf27e6176,0xff61f341,0xb2ff50c7,0x91472122}},	//   _iyong_, _çünki_, _biridir_, _натиҷаи_, 
   {{0xf5d2c1eb,0xa1e2d00c,0x6290309a,0xecab6088}},	//   _шектелге, _पसारे_, _kumara_, _クチコミ数_, 
   {{0x525ad183,0x2cfb8033,0x93f470d2,0x82d88188}},	//   _beeld_, _प्रमाणे_, _rastin_, _hokeja_, 
   {{0x9c251071,0x029070c4,0x22e761c0,0x0401f26b}},	//   _राजौरी_, _hunan_, _diendan_, _solution_, 
   {{0x7291c215,0x8454f092,0x57e61118,0x7421f342}},	// [690] _devam_, _नभुल्नु_, _смуга_, _politikk, 
   {{0x1101e0b1,0xd30041a2,0xc3a8d083,0x31b3305f}},	//   _ijtimoiy_, _članci_, _dumating_, _نادرة_, 
   {{0x20061006,0x347d40ed,0xf37ec069,0x6d0ab099}},	//   _מסיבות_, _निरभर_, _ایمرجنسی_, _nadużyci, 
   {{0xbcc8c0ce,0x4f1fb14c,0x82dab0de,0x3201c26e}},	//   _يتعلق_, _partecip, _datorer_, _nevim_, 
   {{0x42a690bc,0xe58b4116,0xdb9000ba,0x24074050}},	//   _baabi_, _approvaz, _muungano_, _हरिदास_, 
   {{0x7b19c034,0xd6970053,0x62000221,0xeb9e4287}},	//   _знаете_, _dikenali, _agiis_, _एकमेकांन, 
   {{0xb30e41ce,0x62fd0171,0x3341d0a3,0xc34231d4}},	//   _peratus_, _akcijas_, _namesto_, _sucesso_, 
   {{0x7386023e,0x3808b122,0x929012cb,0x825ac07a}},	//   _mpira_, _блогисто, _athar_, _willem_, 
   {{0xb8dc403b,0x67e9a03c,0x837b92cc,0x63878022}},	//   _spurning, _ダイエット_, _skladom_, _sirri_, 
   {{0x8e1b705b,0x6cbec034,0x3b6c122c,0x00000000}},	//   _wetenska, _памет_, _castagna_, --, 
   {{0x8c6a2264,0x520071f2,0x7016314c,0x3202018c}},	//   _sonuncu_, _junio_, _екскурзи, _positi_, 
   {{0xa7a9008b,0x3320702d,0x7f63e170,0x62fe4334}},	//   _entrepri, _dunyo_, _kumpulka, _petites_, 
   {{0xf2a7c147,0x325a115b,0x19083286,0xa6c862ce}},	//   _саломат_, _wohle_, _populära_, _глобално, 
   {{0x72fcb0a9,0x1cbcd201,0x2291f110,0xd2fce1f1}},	//   _berikut_, _নবাগত_, _nazale_, _lenger_, 
   {{0xe5ea1023,0x00000000,0x00000000,0x00000000}},	//   _босма_, --, --, --, 
   {{0x2290010e,0x3dc0e171,0xcce470cc,0x00000000}},	//   _arial_, _policija, _traveloc, --, 
   {{0x59f6810e,0xcdebb1ad,0xc3f99132,0x3ed83079}},	// [6a0] _haingana_, _najbliżs, _rosul_, _аннсее_, 
   {{0x6e434057,0x36b0c098,0xa394e134,0xeeb13088}},	//   _ambasade_, _страницу_, _saison_, _danskere_, 
   {{0x33ead155,0xd9bec05f,0x00000000,0x00000000}},	//   _wanted_, _تحذير_, --, --, 
   {{0x222b21cb,0xde72400c,0xba885204,0x2e563008}},	//   _trimite_, _तुर्क_, _kokonais, _шайтон_, 
   {{0xdc74a1f1,0xd3fa5057,0x52909132,0x96d57035}},	//   _forumet_, _bitume_, _duaan_, _月末日まで_, 
   {{0xac76417a,0xc10db075,0x83174032,0x3045e26d}},	//   _futuros_, _সহায়তায, _prezzi_, _जंगलों_, 
   {{0x4fc230a5,0x321c6041,0x989a50f9,0x97a5e343}},	//   _previše_, _asthiv_, _мамандан, _parroqui, 
   {{0x138781db,0x0fcbc043,0x00000000,0x00000000}},	//   _mazrui_, _свободу_, --, --, 
   {{0x42925149,0x03405301,0x07f6d05f,0x9394e134}},	//   _metara_, _verdens_, _تعبّر_, _raison_, 
   {{0x730d305e,0xfd8631ef,0x6c00b2fc,0x727e9174}},	//   _pelacur_, _настрой_, _egestas_, _hyang_, 
   {{0x5c449100,0xfd5cd191,0x2e32c1de,0xee293043}},	//   _istirahə, _تجسمی_, _سمندری_, _католиць, 
   {{0x537d411a,0x837ff019,0x89fd40fd,0x00000000}},	//   _departe_, _tahansa_, _pagamint, --, 
   {{0xe8f13045,0xf664a069,0x03eae06d,0x52d87068}},	//   _انتظر_, _مہنگائی_, _hefte_, _annem_, 
   {{0x0cf9318b,0x841f100c,0xe2d8301b,0x6a009330}},	//   _घडामोडी_, _versioon_, _komela_, _depannya_, 
   {{0x13993002,0xb8d5c167,0x223f607b,0x1da36038}},	//   _hästi_, _страхува, _prokurát, _jugoslla, 
   {{0x767cf1e9,0xd27e914a,0x7505612a,0x711af1d1}},	//   _проблему_, _nyang_, _acquisto_, _जन्मदिवस_, 
   {{0x83100344,0x83ea0019,0x42ca0040,0xfc074027}},	// [6b0] _político, _noita_, _noida_, _vlastnu_, 
   {{0x178ba028,0xfe6ac147,0xe9288243,0x66d3e07d}},	//   _termasuk_, _монда_, _центар_, _студенті, 
   {{0xa2d99039,0x3d557124,0xa27ed045,0x429b2045}},	//   _sosem_, _pokazuju_, _daonra_, _وكمان_, 
   {{0xedaa7094,0x5ecdd15f,0x12779072,0x65765195}},	//   _истодаас, _бирюлёво_, _калктын_, _publicaç, 
   {{0x33f400de,0x3855b022,0x17607023,0x43425060}},	//   _kostar_, _birlikdə_, _kiritilg, _deveran_, 
   {{0x42926207,0x2b11b138,0xb565a142,0xd3d2007d}},	//   _merasa_, _أمريكا_, _उद्धृत_, _педагогі, 
   {{0x831642fa,0xebabd175,0xee14001e,0x53f40229}},	//   _kembali_, _fungovať_, _inderdaa, _mostar_, 
   {{0x79b88043,0xd648819c,0xf512716d,0x343ec072}},	//   _центру_, _центрі_, _aktualno_, _даана_, 
   {{0xa09ca075,0x0c607045,0xdc66c24e,0x22caf1b5}},	//   _বিপুল_, _costais_, _protais_, _negde_, 
   {{0xd2eba07d,0x6ae42087,0x8526a0f8,0x2aca20c5}},	//   _trenger_, _lastnost, _রায়হান_, _डायरिया_, 
   {{0xcf746170,0x767c0006,0x2d03b098,0xc9c512d5}},	//   _प्रकाशचि, _ההשקעות_, _выберите_, _potestat, 
   {{0xbf7d3085,0xa6a82138,0x43ead12f,0xd306216d}},	//   _সাংগঠনিক_, _وبحمده_, _aveti_, _podatek_, 
   {{0xa6c8e03e,0x0ecc3019,0xb27e9110,0x2d22208c}},	//   _mitarbei, _avainsan, _chani_, _pozitive_, 
   {{0xbcbf20a9,0x326e112b,0x7f238007,0x22edc345}},	//   _क्षेत्रा, _napoli_, _dilettan, _dienanh_, 
   {{0x0c5b5060,0x738701d7,0xa7bd6062,0xdd8101db}},	//   _partiyên_, _svarbu_, _bevestig, _josephat_, 
   {{0x6c7bf033,0xc201e08c,0xb3f7f035,0x1eb061c0}},	//   _शुद्धलेख, _ketij_, _質問した人_, _sacomban, 
   {{0x87920006,0xbe62f015,0xc39e11c7,0x00000000}},	// [6c0] _statisti, _регистру, _izvajanj, --, 
   {{0xe386929c,0xf959e0a3,0x0168c030,0x72ba92ba}},	//   _maart_, _zaposlit, _imaginil, _gradski_, 
   {{0x5f542016,0x23cf830a,0xb2e0d136,0x7d606092}},	//   _דאזיגע_, _farve_, _कोचीन_, _खानेपानी_, 
   {{0xc291e1a7,0x75a91079,0x62d5f01c,0xb3ead078}},	//   _letak_, _терито_, _sklopio_, _rantre_, 
   {{0x12903070,0x8ac65271,0x32a64086,0x1eea7052}},	//   _pemain_, _previame, _kambi_, _reaktion, 
   {{0x7074313a,0xf2e622ef,0x32925180,0xdbcaa24b}},	//   _komentār, _pogledaj, _boljše_, _स्वीकृत_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x4b21e06d,0x3301e171,0x92d92346,0x8f9a30c8}},	//   _parastin_, _parasti_, _colocar_, _지식포인트_, 
   {{0x838601d9,0x9db301da,0x9ad51155,0x3d051072}},	//   _cairt_, _hilabete_, _instruct, _instrucc, 
   {{0x0396715a,0xa2d82068,0x9850e0d2,0xbb7f1101}},	//   _tussen_, _anket_, _rekomand, _ngaranna_, 
   {{0x8c293022,0x12ee9110,0x0225f057,0x44b9f0bf}},	//   _versiyas, _akafa_, _ibuka_, _inspiruj, 
   {{0xd8c710c8,0x00000000,0x00000000,0x00000000}},	//   _안녕하십니까_, --, --, --, 
   {{0x027e61d0,0xc2d820ee,0xe3220035,0x62cb5236}},	//   _akong_, _mikel_, _ブログジャンル_, _steder_, 
   {{0x5d959006,0xec3f5046,0xd9d990ab,0x2e3990ab}},	//   _פורטל_, _lappybas, _dienesta_, _dienests_, 
   {{0x127ee00e,0x8340b06d,0xe9d63127,0x93eae09a}},	//   _kuinka_, _dikevin_, _зарурат_, _uwitwa_, 
   {{0x8bd58043,0xc386929c,0xc343e004,0x4b93f1a9}},	//   _soldatar, _kaart_, _privalom, _aimiseir, 
   {{0x096221e9,0x7616527a,0x8261a138,0x00000000}},	// [6d0] _коштів_, _poblogai, _píosa_, --, 
   {{0xf251f0dd,0x4c80c347,0xe29180fd,0x204c9320}},	//   _странице_, _семей_, _geras_, _izbornik_, 
   {{0x22c6d02f,0x1166d02f,0xb2020151,0x3adec0f1}},	//   _第三十六条_, _第三十八条_, _rapide_, _forumove, 
   {{0xa395f110,0xe2d841ea,0x7200c0b9,0x5320009a}},	//   _abusa_, _limen_, _aplike_, _iriya_, 
   {{0x42c282a0,0xa378d2fa,0x53411069,0x32e9f131}},	//   _heilsan_, _semakin_, _منہاج_, _bulijjo_, 
   {{0x4af7c1ca,0x01e61045,0x6248d0ab,0xcfce5008}},	//   _сайдын_, _قانونية_, _filmas_, _конкурси, 
   {{0x787390aa,0xb2918052,0x7523001e,0x73f981b2}},	//   _istifadə_, _deras_, _선택하세요_, _korun_, 
   {{0x720ec093,0xb6652033,0x72006086,0xb738801a}},	//   _санат_, _वर्णिलेल, _kulia_, _дүйсенбі_, 
   {{0xb201e1c7,0x8513613c,0xb2c56022,0xd3513045}},	//   _letih_, _danûstan, _nədir_, _meiriceá_, 
   {{0x120e1008,0x788e801a,0xe8dcc030,0x00000000}},	//   _ҳасан_, _мүдделер, _букий_, --, 
   {{0xa387e309,0x43ce9168,0x134b0069,0xaeb43043}},	//   _nitra_, _chavo_, _baleset_, _oversikt_, 
   {{0x9b27809c,0x3366a1d6,0x67a58348,0x8962002b}},	//   _johannes, _tanggal_, _komentov, _podnikat, 
   {{0x92918010,0x163f31b2,0x7fe81024,0x69aac302}},	//   _beras_, _komentář_, _स्थानों_, _собит_, 
   {{0x920e115f,0xf291e1fb,0x6363d008,0x9e51f23a}},	//   _гарав_, _betah_, _термизли, _kelayaka, 
   {{0xa9d3d1dc,0xefae123d,0xf2674050,0xb3f8c065}},	//   _телевиде, _ласка_, _alkoholi_, _indul_, 
   {{0x72925140,0x7298c075,0xa24a70fd,0x576131e9}},	//   _ostaje_, _অলাভজনক_, _formos_, _твори_, 
   {{0x86fa2174,0xb430b012,0x96405329,0xf20182a0}},	// [6e0] _فرانسه_, _desconto_, _पारिश्रम, _gerir_, 
   {{0x1f6fa0c3,0xc248925a,0x9db7308a,0x0d1ee01e}},	//   _המדרש_, _inama_, _тегін_, _애니메이션_, 
   {{0xe2d980db,0x83f40041,0x6201e0b4,0xac39b035}},	//   _foren_, _lostus_, _getih_, _ショップへ_, 
   {{0x898e1079,0x2291a018,0x425a529f,0x63ea5156}},	//   _парис_, _lepas_, _volle_, _volte_, 
   {{0xe07d3032,0x6a14109a,0xaae73106,0x00000000}},	//   _такса_, _bigatuma_, _videoalb, --, 
   {{0x50e7304f,0xa2eff09a,0x680d002a,0xb0a3c12b}},	//   _gemiddel, _ngufu_, _ситуации_, _колонки_, 
   {{0x20d3307d,0x58dcd008,0x7290d0f6,0xf085f11a}},	//   _класу_, _руҳий_, _dudan_, _spectaco, 
   {{0x9eca5046,0x79828147,0x00000000,0x00000000}},	//   _muốn_, _хостори_, --, --, 
   {{0xc290604b,0x5341508f,0x00c29087,0xd3fa50f6}},	//   _julai_, _оформлен, _priljubl, _lotura_, 
   {{0x165d4030,0xe8fd417e,0x14a70043,0x78733349}},	//   _постамен, _поставен, _благоуст, _प्रकारको_, 
   {{0x27c70032,0x1881634a,0xdb15e116,0xb291934b}},	//   _машини_, _महाविद्य, _kompetit, _sesat_, 
   {{0x7394b145,0x920250a9,0xe28e007f,0x3860534c}},	//   _mieste_, _ketiga_, _syukran_, _बालेश्वर_, 
   {{0xad4960ee,0xa2d990c2,0x62f0d0fd,0xd9a001d1}},	//   _vvрvv_, _bosen_, _greitai_, _लक्ष्मीप, 
   {{0xd2025049,0x8fd23034,0xc3200121,0xafd2f1d1}},	//   _hatine_, _покупка_, _priya_, _dostateč, 
   {{0xaaabb01e,0xfc67d21f,0x361f1092,0x00000000}},	//   _비밀번호를_, _شرعاً_, _अर्थतन्त, --, 
   {{0x991f2023,0x73e5334d,0x6265411a,0x7379b124}},	//   _адресни_, _इण्डस्ट्, _anunturi_, _pokazao_, 
   {{0x127f534e,0x927e91a5,0x21f7e01a,0x03cee1ae}},	// [6f0] _apenas_, _akang_, _биылғы_, _anivon_, 
   {{0xa2d8700e,0xc6513151,0xa682d34f,0xb27e0057}},	//   _ennen_, _无标题文档_, _आजकाल_, _nyina_, 
   {{0x224802ca,0x22d9a062,0x82ebc044,0x8538914c}},	//   _snimi_, _kopen_, _prinder_, _настаняв, 
   {{0x9ba4115b,0x52d8508c,0xf14e4045,0xe2d9409d}},	//   _ditirelo_, _cilen_, _gaillimh_, _fideos_, 
   {{0x67a260fa,0xe2d871f1,0x1f5500a7,0x70326027}},	//   _spotrebi, _innen_, _kampanya, _spotrebn, 
   {{0xe2018022,0x532071a5,0xee58c17e,0xe2909225}},	//   _verir_, _dunya_, _обиди_, _itaas_, 
   {{0xd2fce052,0x232141d2,0x6485c142,0xa2cae1e0}},	//   _pengar_, _inscrit_, _सेनानी_, _rendah_, 
   {{0x06bec138,0x52d84228,0x427ff167,0x0368d042}},	//   _مصرّح_, _simen_, _grunn_, _linguas_, 
   {{0x4950b301,0x0c70b032,0x4860b0fb,0x2abca14c}},	//   _personer_, _persone_, _persones_, _министър_, 
   {{0x829190e2,0xe2d94209,0x03a29086,0x6c1cd118}},	//   _besar_, _videos_, _iwapo_, _участку_, 
   {{0x4340e244,0x92f3a22c,0x7470e0cc,0xe2caf002}},	//   _telepon_, _artiklu_, _telepono_, _leidis_, 
   {{0xb32071e0,0x00000000,0x00000000,0x00000000}},	//   _bunyi_, --, --, --, 
   {{0xc3ea031f,0xa291a0c2,0xa2d9c149,0x4602f00c}},	//   _noite_, _tepas_, _covek_, _स्वागताध, 
   {{0x12909116,0x62d8712b,0x2e8790b3,0x225740b0}},	//   _lokali_, _annen_, _kalkulač, _chuẩn_, 
   {{0xa8d8d024,0x427eb110,0x43763019,0x42d99030}},	//   _माध्यमिक_, _ndende_, _авторски, _atentie_, 
   {{0x2342a155,0x3eb63098,0x2d92a14c,0xa29001d9}},	//   _general_, _систему_, _generale_, _grian_, 
   {{0x71d61098,0x73f40194,0xcdfa2094,0x00000000}},	// [700] _сентября_, _koster_, _бозгашти_, --, 
   {{0x7c5b8095,0x4290009d,0x0c65b0e2,0x23ebf1b7}},	//   _postoji_, _arian_, _bertemu_, _avuto_, 
   {{0xb7a3e14b,0x5290d1a9,0x9879e035,0x9b45e0c8}},	//   _području_, _rudan_, _ジャンル別_, _행정정보공개_, 
   {{0xf25a6002,0x5342a11e,0x9ca1b0f8,0x72d2a06a}},	//   _poole_, _jeneral_, _প্র্রোফা, _jenerali_, 
   {{0x2df481cb,0x91398232,0xeccd6068,0x00000000}},	//   _економис, _identità_, _şeklinde_, --, 
   {{0x31508151,0xa615a08e,0x629250c9,0xe6762008}},	//   _东营市蓝天塑胶有, _סודאן_, _satane_, _машъал_, 
   {{0x62902087,0xe2d8e102,0x166532c4,0x64319074}},	//   _tukaj_, _cineva_, _कांस्य_, _абажур_, 
   {{0x92909062,0xda0831de,0x343ce075,0x9f28614b}},	//   _staat_, _تصحیح_, _সিভিল_, _također_, 
   {{0x2320023e,0x43f87204,0x3c67b150,0xb2ba80ba}},	//   _asiye_, _minun_, _sobrang_, _maadili_, 
   {{0x82d9e0a3,0x32cad090,0xbb0cc03c,0xc394d07a}},	//   _potem_, _prodej_, _でお届けします_, _minste_, 
   {{0x837af1d9,0x527f1095,0x0b60f344,0x237ca0ce}},	//   _tamaill_, _kazna_, _permanec, _gruaige_, 
   {{0xf2ad0010,0xc2d9e0bf,0x6212b0b9,0x6f2bf240}},	//   _شلوار_, _fotek_, _seche_, _sameigin, 
   {{0x3212b2c2,0xf2ca5023,0x4de7a1e8,0xa27ff0c2}},	//   _peche_, _holda_, _нивните_, _maung_, 
   {{0x3291210f,0xe2efe046,0x525a52fe,0x1200d1c0}},	//   _beyaz_, _ketnooi_, _kolla_, _mudim_, 
   {{0x62c50200,0x7dd22108,0xfaf2c045,0x6b239023}},	//   _billige_, _достъп_, _beartait, _худонинг_, 
   {{0x62e210d9,0x93ea51c6,0xac7aa191,0x1d0b8313}},	//   _gjennom_, _molta_, _دريافت_, _zaplatit_, 
   {{0x6827a148,0xe913f0f5,0xc303f143,0x0de7a02b}},	// [710] _rodinný_, _anacletu, _bedankt_, _rodinné_, 
   {{0x9201c13a,0x0387931b,0x038c50e1,0x00000000}},	//   _nevis_, _misri_, _формирањ, --, 
   {{0x4386010e,0x52d981c6,0xf683c120,0xb8ccd012}},	//   _ocirc_, _hores_, _श्वास_, _necessid, 
   {{0x42f2b062,0x08f00069,0x12d8300d,0x725ad0e5}},	//   _archief_, _کلومیٹر_, _kimera_, _koolis_, 
   {{0x4c5f0133,0x86cef06c,0x5a8ca0fd,0x7ee3c0f2}},	//   _systém_, _behandli, _galeriją_, _toekaren, 
   {{0x82fda30a,0x938f10bf,0x7ac7409f,0xc291c0f1}},	//   _forhold_, _cestován, _zaštite_, _bevat_, 
   {{0x5536412a,0x02fcd1d0,0x00000000,0x00000000}},	//   _страхотн, _tungod_, --, --, 
   {{0xcfdbf05f,0xd200b158,0xafe8b1cd,0x426db07a}},	//   _múinteoi, _godini_, _हीरालाल_, _geword_, 
   {{0xee56c261,0xda16c261,0x9113a100,0x524900b4}},	//   _zdravlje_, _zdravlja_, _çıxdı_, _ciamis_, 
   {{0xcfc42136,0xb2002023,0x9c73f0cc,0x4b0c506c}},	//   _ब्रिटेन_, _erkin_, _opisina_, _presseme, 
   {{0x2224e069,0x126c815b,0xd17b614a,0x502bc243}},	//   _minket_, _nakong_, _samantal, _учете_, 
   {{0xa2d870f6,0x37423305,0x1224e0a4,0x00000000}},	//   _ginen_, _साहित्या, _linket_, --, 
   {{0x39e60350,0x248060e6,0x02cae0f1,0x92ecb08b}},	//   _dianggap_, _विभाजन_, _minder_, _musique_, 
   {{0x12a66142,0x1306216d,0x82c932aa,0x3503f075}},	//   _osoby_, _dodatek_, _endlich_, _সৈয়দ_, 
   {{0x52d8f039,0x6617903a,0x030e70ef,0x5c0b02c9}},	//   _engem_, _प्रत्याश, _secafer_, _obiteljs, 
   {{0xaf28e080,0x330832a9,0xb9c53156,0x994110c7}},	//   _devolver_, _trabaho_, _riservat, _populyar_, 
   {{0x7fbbf351,0xdad70201,0x6291c13a,0xe4cea2d3}},	// [720] _cingular_, _opinión_, _nevar_, _concello_, 
   {{0x32d872cb,0x57314098,0xddb4205f,0xdaa0a1de}},	//   _innes_, _страницы_, _شوفوا_, _ریٹائرڈ_, 
   {{0x73f8e027,0x62365050,0xd149a352,0x3db3a08e}},	//   _ponuka_, _palju_, _מחיצה_, _מנוחת_, 
   {{0xe2001087,0xc2d871e9,0x4b4ae306,0xa16480fa}},	//   _arhiv_, _annet_, _долларын_, _tvnoviny_, 
   {{0xa2926028,0x1c767040,0xab611138,0xd7ea31f7}},	//   _berada_, _macular_, _teoranta_, _सुरुचिपू, 
   {{0x32d98293,0x825af03f,0xa1c55151,0x8c76b12f}},	//   _vores_, _mailem_, _中华人民共和国国, _tuturor_, 
   {{0x1200e1b1,0x3829e24a,0x90dfa28f,0x2ec1521f}},	//   _benito_, _четвер_, _væntanle, _الرضوان_, 
   {{0xa2ca60f4,0x143da03a,0x00000000,0x00000000}},	//   _booda_, _अत्याधुन, --, --, 
   {{0x22d8c29c,0x52240178,0x736e305a,0xff73e151}},	//   _alleen_, _amiko_, _redaktə_, _编译或摘编的目的, 
   {{0x43ead0ef,0x75a2e353,0x538691d9,0xf3eae0db}},	//   _chotot_, _यावत्_, _opara_, _hinter_, 
   {{0x17034170,0xe2cae0db,0xf7a2811e,0xe2d98026}},	//   _ज्ञानकोश, _kinder_, _kontribi, _borer_, 
   {{0xa212b0c9,0xc290b29c,0xe26471e6,0x5201c28d}},	//   _lecha_, _gedaan_, _meslek_, _kevir_, 
   {{0x5f495354,0x00000000,0x00000000,0x00000000}},	//   _existuje_, --, --, --, 
   {{0x9f6b4355,0x7290f0b4,0xf2002277,0xa3f87204}},	//   _प्रदूषण_, _sugan_, _arkiv_, _sinun_, 
   {{0xb975a09f,0xbbd161ac,0xe476907d,0x0f02c030}},	//   _koristit, _wanderer, _процесі_, _аколо_, 
   {{0x0e693138,0x024830db,0x96fd7098,0x326e6356}},	//   _سيدتي_, _kommen_, _проблемы_, _strong_, 
   {{0xd96990e3,0x07f311b2,0xe68e3151,0x3ea37188}},	// [730] _ориджина, _स्थानहरू_, _国家税务总局_, _studijas_, 
   {{0x1e2c402e,0xd29161e0,0x7f7dc211,0x19f802d6}},	//   _बहुआयामी_, _segala_, _измаил_, _विद्यमान_, 
   {{0x93050177,0x0eb680b5,0x3388717e,0x323000b4}},	//   _béarla_, _валюты_, _промоциј, _utamana_, 
   {{0x73f47357,0x760381a9,0xd6bb2358,0xe22bb14c}},	//   _destek_, _chomatai, _putrajay, _tramite_, 
   {{0x4212b359,0xd71fb2ee,0x6060d161,0x061e4008}},	//   _fecha_, _उद्देश्य, _substain, _йўналишл, 
   {{0x30e8e0f7,0x2eb1401e,0xb3eae173,0x6200c22e}},	//   _artikkel, _단독다가구_, _mentsi_, _kulipa_, 
   {{0x7bd13033,0x8f1b22ff,0x82d8a0b9,0xe2009173}},	//   _इसापनीती_, _украины_, _kiben_, _nraim_, 
   {{0x5387007b,0x52d82173,0x0a7d81a4,0xf1943171}},	//   _modrý_, _likev_, _полуврем, _komentēt, 
   {{0x627ff004,0x13f9a140,0x9b1fc150,0x519e8043}},	//   _kaune_, _poput_, _talaksan_, _поведінк, 
   {{0xf486c019,0x726d8089,0xc2ca405a,0xf20061c7}},	//   _имени_, _skroz_, _hillari_, _julij_, 
   {{0x2d32a06c,0x348a5087,0x5c6b71c2,0x00000000}},	//   _positivt_, _apartmaj, _जिन्दा_, --, 
   {{0xd5a3735a,0xbbdf218d,0xa1b2f0b5,0x9bedf140}},	//   _kliknutí, _kementer, _поршня_, _ograniče, 
   {{0xd2cad0a3,0xe3200110,0x93869123,0x5d3201d0}},	//   _glede_, _asiya_, _spara_, _coenzyme_, 
   {{0x1200b1a6,0x925aa084,0xd2fd916d,0x00000000}},	//   _rediyo_, _poble_, _najnovej, --, 
   {{0xa6b7d1f1,0x92b391b1,0xd5f7c075,0xe2d99072}},	//   _категорі, _munduko_, _ছাড়াই_, _roser_, 
   {{0x33954242,0xe2cb82e3,0x3e6c0069,0x00000000}},	//   _fresno_, _derde_, _شیڈول_, --, 
   {{0x92d8c190,0x9f642035,0x400c621b,0xa6e26191}},	// [740] _inden_, _最新コメント_, _privredn, _خودارضای, 
   {{0xeabf828d,0xb87571e9,0x96412061,0x00000000}},	//   _hemwelat, _студента, _ऑर्डर_, --, 
   {{0xb2d9e1e5,0xfc72b080,0x4f3e6024,0x12fce1e9}},	//   _boten_, _ofertas_, _खूबियां_, _penger_, 
   {{0x93ac616f,0xd7c4835b,0x9010c045,0x4d880016}},	//   _gruppe_, _चव्हाण_, _انتقل_, _פעלקער_, 
   {{0x227ef086,0x77bfc231,0xef9e305f,0x00000000}},	//   _msingi_, _cokolvek_, _لحقوق_, --, 
   {{0x126cd19b,0xb3eb9106,0xd12bb35c,0xcf0e301a}},	//   _pomoć_, _meste_, _servicio, _әдетте_, 
   {{0xb6cf2086,0x32abc277,0x3255b023,0x4edc326f}},	//   _majadili, _håber_, _tantanal, _спорта_, 
   {{0xc9da0086,0x42d990fb,0x53a0d093,0x00000000}},	//   _asilimia_, _josep_, _ахмет_, --, 
   {{0x2248912a,0xb2b2501a,0xc2d9908b,0x02004102}},	//   _siamo_, _өкінішке_, _poser_, _lumii_, 
   {{0x12d8c186,0x426e70b3,0x42d8c17e,0x14b64151}},	//   _anden_, _oproti_, _boleto_, _谁有刘松仁版陆小, 
   {{0x08c10039,0x4200d145,0x00000000,0x00000000}},	//   _viselked, _ludia_, --, --, 
   {{0x61661016,0x92001100,0x1152514c,0x8320b20a}},	//   _ליקוטי_, _vahid_, _станишев_, _efectos_, 
   {{0xd200335d,0xaf6f327e,0x83f40195,0xec9200a9}},	//   _asmira_, _demandas_, _postar_, _berulang_, 
   {{0xe2cb9042,0x23eb9012,0x3c071043,0xb4024204}},	//   _desde_, _deste_, _prosent_, _сексуаль, 
   {{0x2ef57121,0xdef12227,0xb8712156,0xe3cf80ac}},	//   _panjenen, _остави_, _остава_, _barve_, 
   {{0xc291803f,0x8c601017,0xba8f809b,0x8f50113d}},	//   _stran_, _המקצוע_, _tlhingan_, _ymosodia, 
   {{0xc3eb9167,0x12907010,0x719812c6,0x92caf01f}},	// [750] _neste_, _lunak_, _specijal, _hendry_, 
   {{0x5f247092,0x7215313c,0x6c6712f9,0xeb6c417c}},	//   _pište_, _pêşvebir, _ngiring_, _terrassa_, 
   {{0x69fb9065,0x8ae90116,0x3beec0eb,0x82c28065}},	//   _lehetség, _intrapre, _након_, _mailben_, 
   {{0x39cd903c,0x220180b9,0x22ddc015,0x6aff2034}},	//   _コメントを書く_, _afrik_, _košarkaš, _истината_, 
   {{0x0e396070,0x73eae042,0x00000000,0x00000000}},	//   _kelahira, _contos_, --, --, 
   {{0x867a1258,0x1fe940c7,0x92d8416d,0xe071935e}},	//   _डेनमार्क_, _müsbət_, _izmed_, _аменинца, 
   {{0x7bee126f,0x038bb247,0xf9f6735f,0x549960e2}},	//   _часов_, _menyuam_, _atrás_, _melahirk, 
   {{0xa3eae039,0x89399035,0xe3eaf360,0x7376c12a}},	//   _fontos_, _タイからの投稿_, _moitos_, _христо_, 
   {{0xb98b4034,0xec278178,0x42ca50d9,0x92009221}},	//   _richiest, _maharitr, _holde_, _craic_, 
   {{0x58517030,0x63eb9361,0xcb69f02a,0x7650b188}},	//   _recomand, _odsto_, _paremmin_, _jauniešu_, 
   {{0x7a70d255,0x3730d033,0x06d48075,0x5da9d124}},	//   _berlangs, _berlangg, _আক্রমণ_, _postupku_, 
   {{0x1b040254,0x92da00dd,0x8e27205c,0x65a06228}},	//   _persekut, _meseci_, _интереса_, _jerizalè, 
   {{0xe2cad2f8,0x2887a0c3,0xb2d821b6,0x06c4c151}},	//   _goede_, _נעכטן_, _diket_, _查看用户评论_, 
   {{0xfe3da006,0x86a88119,0x8ebb8095,0x0edec2cd}},	//   _נשלחה_, _значит_, _rukometn, _milyonla, 
   {{0xf98bf23d,0x8386023e,0x024940a7,0xc3cf806d}},	//   _штрафу_, _mbiri_, _eleman_, _parve_, 
   {{0x0298c07d,0x6484b0d4,0xb2118035,0x00000000}},	//   _охорони_, _रोजाना_, _おすすめ商品を見, --, 
   {{0x9c7510a9,0xb28cf07b,0xe36c70b4,0xc0f02006}},	// [760] _शिक्षण_, _archív_, _ningali_, _הצדדים_, 
   {{0x120262ed,0x3f460362,0x6fba1023,0x00000000}},	//   _beriya_, _persemba, _фаровонл, --, 
   {{0x7386909a,0x3277a1a8,0x020250fd,0xfa70d0a4}},	//   _ibara_, _радиосы_, _ketina_, _berlings, 
   {{0xb3860212,0x9e4f517e,0x598050f6,0xb2541319}},	//   _abiri_, _впечатли, _ostirale, _अलबेला_, 
   {{0xb25e1260,0x32c421b6,0xf37ff035,0x62d8c03e}},	//   _huntsvil, _bêjim_, _この質問に対する, _allein_, 
   {{0xcc85a006,0x0bef901f,0xf27f71a6,0x4f5b80e2}},	//   _רואים_, _ankehitr, _amanye_, _melaksan, 
   {{0x1c4b813d,0x626c6063,0x926d120b,0x62020304}},	//   _cartref_, _txoos_, _subotu_, _masiku_, 
   {{0x3e94401f,0xc3f8b1b1,0x6f8a2035,0x52d8c1e6}},	//   _mpaminan, _moduan_, _アメブロランキン, _giden_, 
   {{0x924a6008,0xf2903103,0x39776232,0x6d55901a}},	//   _umuman_, _jumala_, _manifatt, _италияны, 
   {{0x65bd2052,0xcae5b075,0x7ae86148,0x5c7530de}},	//   _erfarenh, _আর্থিক_, _založený_, _minuter_, 
   {{0xb2a0801e,0xde520171,0xe1e121ad,0xd096f191}},	//   _생각합니다_, _bibliotē, _oprogram, _داداشی_, 
   {{0xeb7d60cb,0x00000000,0x00000000,0x00000000}},	//   _abonnier, --, --, --, 
   {{0xfef34008,0x8f5c00cf,0x6d30c1b9,0x42d8c03c}},	//   _германия, _सिंगल_, _clasific, _viden_, 
   {{0x69d21005,0xe585902c,0xf2d8a0b7,0x00000000}},	//   _zarejest, _плазмы_, _tobey_, --, 
   {{0xa63a90a9,0x638f1039,0x1387809d,0x9effc0c8}},	//   _प्रश्नां, _rengeteg_, _gwyrdd_, _칭찬합시다_, 
   {{0xa2ca71c5,0x72d8c03c,0x98c0203c,0x4ebac289}},	//   _monde_, _andet_, _続きを読む_, _топла_, 
   {{0xc2d83032,0x61ed202c,0xbec72195,0x93866363}},	// [770] _almeno_, _марафона_, _impostos_, _oboru_, 
   {{0x0290d044,0x1594a064,0x569a0195,0x13940196}},	//   _ardal_, _студентт, _нормално_, _imisa_, 
   {{0xa2d8f06c,0xb25ad1ca,0x8411a1b1,0x33f820fd}},	//   _ingen_, _millor_, _gainerak, _pikul_, 
   {{0x3c51e1ae,0x73f87098,0xf7aec008,0x5471e01f}},	//   _tantara_, _minua_, _тилга_, _tantaran_, 
   {{0xf2b5412f,0x6f9940e6,0xe02a308f,0xb2646011}},	//   _precum_, _उत्तेजक_, _физическ, _haulwm_, 
   {{0x8290c03e,0x42f761fb,0x0daee011,0x8292c0f9}},	//   _damals_, _hanifah_, _tiffanie_, _педагогт, 
   {{0x22d8c07d,0x731b9364,0xe3eb50ab,0x331f0034}},	//   _tiden_, _názor_, _lietus_, _mercato_, 
   {{0x52d8c13d,0x22918278,0x12ca720a,0x63cf8050}},	//   _fideo_, _teraz_, _donde_, _narva_, 
   {{0x4290c00d,0x72f5409f,0xec1f50d2,0x6104c345}},	//   _tulaga_, _obzirom_, _perandor, _mobiarmy_, 
   {{0xb2d0602b,0xa2d9805e,0x73ea71d4,0x4c6a800c}},	//   _včera_, _rezeki_, _fonte_, _चित्ते_, 
   {{0xfd762065,0x127f8129,0xd477e0b5,0xe30e4042}},	//   _پرِنٹ_, _karna_, _зарэгіст, _citados_, 
   {{0x22d8f13d,0xa04dc17e,0xf2902128,0xd2902128}},	//   _angen_, _врати_, _sukat_, _bukas_, 
   {{0xde7352d6,0xc69dc0fd,0xd2d83010,0x4248d109}},	//   _सशक्त_, _красе_, _solopos_, _chomas_, 
   {{0x52d8c155,0xc3ea7193,0x0fb51015,0x8673b0c8}},	//   _video_, _konte_, _играчи_, _북구문화예술회관_, 
   {{0xa2cb8095,0xd39400bc,0x39dd101a,0xa2ab921f}},	//   _tvrdi_, _emisa_, _аптада_, _gábor_, 
   {{0xa25a901f,0x12cac008,0x5f33a034,0x3a1100bf}},	//   _omaly_, _modda_, _следните_, _nezapome, 
   {{0xdfc20158,0xb3f8c300,0xd3f0b098,0x00000000}},	// [780] _najviše_, _kidul_, _viestisi_, --, 
   {{0xf9b050d2,0x985cb1b6,0xf27e622c,0x7104405f}},	//   _menjëher, _beramber_, _skont_, _مناقشة_, 
   {{0xfd70e19a,0x57e5407d,0xd2b40156,0xa3f47054}},	//   _perminta, _актуальн, _amici_, _rustam_, 
   {{0x1a08609c,0x4f28e1da,0x7f5b80fe,0x22d91299}},	//   _belangst, _kontrola, _pelaksan, _docela_, 
   {{0xa27f8262,0x639570df,0xf290400c,0x92d8c299}},	//   _darna_, _yaasin_, _urmas_, _lidem_, 
   {{0x52d8c29f,0xb31f12c0,0x374ed019,0xd28f10b8}},	//   _ander_, _mercado_, _крови_, _merkado_, 
   {{0x020092fc,0x627e911e,0x57c7d0a1,0x62d8c03a}},	//   _orain_, _chans_, _табиғи_, _wideo_, 
   {{0x3c012024,0x22a78222,0x00000000,0x00000000}},	//   _हरमोहिंद, _garbi_, --, --, 
   {{0xb163403c,0xeb82b075,0xfb27c20b,0x9bdde365}},	//   _ペタを残す_, _পড়তে_, _nesreća_, _मचिया_, 
   {{0x1386d09d,0x73b1b063,0x00000000,0x00000000}},	//   _storio_, _tswqab_, --, --, 
   {{0xe381115b,0x7ab14035,0x729180b8,0xffb5b002}},	//   _kenyang_, _お気に入りブログ_, _muran_, _postitus_, 
   {{0xfa0ba13d,0xa27e90b4,0x720ec182,0x003c1014}},	//   _asiantae, _ayana_, _палац_, _seleccio, 
   {{0x4e725009,0x3200515b,0x3132f06f,0x03811010}},	//   _जोक्स_, _malie_, _porttito, _menyang_, 
   {{0x7e33616d,0xb2b1e049,0xd2912076,0x72ab925e}},	//   _pridržan, _bandora_, _locali_, _tábor_, 
   {{0x51141210,0xc2e3e181,0xe290207e,0x79978151}},	//   _техникал, _तृतीय_, _tukar_, _突发公共卫生事件, 
   {{0x42d8f043,0x0a15301f,0x721470b0,0x429260b3}},	//   _eigen_, _abrahama_, _hướng_, _dotazy_, 
   {{0x11d0e1b2,0xad90e031,0x7b0c3121,0x6efc9171}},	// [790] _telefony_, _telefone_, _ناحیه_, _samazinā, 
   {{0x0c76c099,0xd29021ce,0x1265c094,0xf9696288}},	//   _यात्री_, _sukar_, _ягонаи_, _militare, 
   {{0xa2e960ce,0xd36f11d7,0x00000000,0x00000000}},	//   _freisin_, _adresą_, --, --, 
   {{0x99f4a092,0x02041019,0x11e59015,0x00000000}},	//   _povlečen, _valikoim, _будућнос, --, 
   {{0x6254900d,0x222ac07c,0x20e6c2d0,0x00000000}},	//   _obulungi_, _показ_, _paradajz_, --, 
   {{0x63ea900f,0x527f00fa,0xb0bda035,0x00000000}},	//   _plats_, _vranov_, _コメント投稿_, --, 
   {{0x858740ee,0xd0f5b106,0x8d0e9088,0x94abf145}},	//   _bestelak, _najstarš, _最近の注文状況を, _nastaviť_, 
   {{0x329082ff,0x1b40d121,0x1c025337,0xa42b01cf}},	//   _mukana_, _تعویض_, _persoas_, _serpihan_, 
   {{0x02d8f123,0x82d600c2,0x87d42191,0xf0ad205f}},	//   _inget_, _obrolan_, _بخشنامه_, _اشكرك_, 
   {{0xf37ac008,0x3ee9d1e7,0xc2907062,0x1f79d256}},	//   _поезд_, _funktion, _vanaf_, _function, 
   {{0x027ff152,0x62025116,0x820260f4,0x1aac70f8}},	//   _kauno_, _attiva_, _terina_, _কুরআনের_, 
   {{0xf27ff160,0x92904102,0xc40e5034,0x00000000}},	//   _jauno_, _numar_, _residenz, --, 
   {{0x02901098,0xb3ebe291,0x00000000,0x00000000}},	//   _rahaa_, _lette_, --, --, 
   {{0x42d9a1aa,0xa11a117e,0x72d851ce,0xd290727d}},	//   _gopet_, _борба_, _filem_, _arnat_, 
   {{0x2819207d,0xa3ae225f,0x678620b0,0x33eaf211}},	//   _компанія_, _köpte_, _đểđăng_, _spital_, 
   {{0x030d41f3,0xfb62024a,0x3fbbe00f,0xa9e3d015}},	//   _lugares_, _publiser, _fungerar_, _пожара_, 
   {{0xf2904045,0xd297c24e,0xf24a11ad,0x48145171}},	// [7a0] _cumas_, _matariki_, _firmę_, _kolektīv, 
   {{0x83ea9242,0x7251e05f,0xb0d18075,0xfd89a006}},	//   _fajtim_, _leibhéil_, _কাউন্সিল, _תקופת_, 
   {{0xc3a24084,0xe0642305,0x36837201,0x9f531302}},	//   _temps_, _अक्षरे_, _producci, _ноябри_, 
   {{0x33ebe0d9,0x52e6512b,0x59e4702e,0x094db062}},	//   _dette_, _svenska_, _शीर्षस्थ_, _formulie, 
   {{0xf2ed4030,0x21862366,0xdaa3d35e,0x27bf7023}},	//   _aprilie_, _економик, _индепенд, _litsenzi, 
   {{0x9295f215,0x849d1086,0x4a7f40f2,0x78e372e0}},	//   _merkezi_, _matangaz, _serasera_, _prisustv, 
   {{0xc9481006,0xaf2b80fd,0xa2786128,0x047fc1e3}},	//   _הגילאים_, _ekstrema, _kaunti_, _baterako_, 
   {{0x03ea61bf,0x1200608b,0xb686a069,0xe25a60e5}},	//   _kooti_, _trois_, _جدوجہد_, _kooli_, 
   {{0x93030053,0x39d9901a,0x348c60dd,0x43210225}},	//   _gelagat_, _бейбіт_, _naprednj, _maayos_, 
   {{0x1d7ba0c3,0xdab0b01e,0x59aa3019,0xf2904034}},	//   _תלמיד_, _알려주세요_, _ролик_, _ormai_, 
   {{0x05f93118,0x9a7fb0f0,0xbadda0ee,0xa3c860b9}},	//   _ролях_, _odnoklas, _sustatze, _souvan_, 
   {{0xe359d20e,0x10e3c072,0x73869065,0xb9d9a016}},	//   _разновид, _мыкты_, _ipari_, _אינדרויס, 
   {{0x12d8f28d,0xce49f1a7,0x4faec182,0x00000000}},	//   _digel_, _antaraba, _майку_, --, 
   {{0xc62a1195,0x8da13121,0x8387a0a3,0x5265d289}},	//   _организи, _پیگیری_, _zapri_, _агенции_, 
   {{0xc29190ee,0xd2bd700d,0x4153a01a,0x631d61c6}},	//   _busan_, _liddell_, _терминде, _tercera_, 
   {{0xe29041d9,0xcd3690ba,0x94ba919c,0xc200c245}},	//   _cumar_, _nyingine_, _статті_, _pilisi_, 
   {{0x7b621123,0x5d0210b2,0xa2002022,0xaefdb02f}},	// [7b0] _publicer, _publicat_, _lakin_, _上的问答吗_, 
   {{0x2873f1f3,0x3c6370ec,0x8dc5305f,0xf7d0c0fd}},	//   _cancelar_, _outubro_, _طبخات_, _многа_, 
   {{0x406d7232,0x4212b06a,0xb68cc0d4,0xf3ac626e}},	//   _temporan, _mechi_, _बौछार_, _skupin_, 
   {{0x41cba07d,0xcb1f90e8,0x86a8220f,0xf200d170}},	//   _консульт, _bahagian_, _bharrach, _mudik_, 
   {{0x52002019,0xf27c3012,0x92cae190,0xd3eae194}},	//   _takia_, _necessár, _vinder_, _vinter_, 
   {{0xee9ec1d7,0x451010b1,0x525a515b,0x7e1b7170}},	//   _файла_, _терма_, _mollo_, _ditemuka, 
   {{0x42b5420a,0xdc7c800e,0x00000000,0x00000000}},	//   _precio_, _naisten_, --, --, 
   {{0xb85392f6,0x75bd5047,0x02014354,0xe80a314c}},	//   _телефонҳ, _archiwum_, _rodiny_, _струва_, 
   {{0x3484401e,0x49c5105d,0xbf5c2083,0x8d8c014b}},	//   _주변정보는_, _intestat, _magandan, _jučer_, 
   {{0x4382d121,0xac073057,0xe37b00ea,0x2d9a40d1}},	//   _تابلو_, _tharciss, _espaço_, _velocida, 
   {{0x32d89110,0x7c57d119,0x52d7d02a,0xdba6c069}},	//   _anjela_, _машины_, _машину_, _سازشیں_, 
   {{0xc200902f,0xd2fe2041,0xa2d8f21c,0x7697e367}},	//   _frais_, _nplhaib_, _enger_, _शिवरायां, 
   {{0x43010135,0x4301a29f,0x00000000,0x00000000}},	//   _sayansi_, _verband_, --, --, 
   {{0x275aa234,0x2ee9e035,0x6ae79075,0x5841205f}},	//   _संस्करण_, _ありがとう_, _উদরাজী_, _موريتاني, 
   {{0x73a97194,0xe4e4a248,0xf83e1157,0x43874201}},	//   _erfaring_, _प्रभावशा, _киска_, _cuerpo_, 
   {{0x03a8e028,0xa2bc60b8,0x12e3107a,0x5e86c01a}},	//   _dilarang_, _kredito_, _polisie_, _заңсыз_, 
   {{0xd0fed09f,0x62fd6272,0x4db4e26c,0x57e5919e}},	// [7c0] _društven, _byggja_, _saineola, _kaupunki, 
   {{0x093fb01a,0xd8f5f1e8,0x615c2072,0x00000000}},	//   _комитеті_, _студенти, _курал_, --, 
   {{0xf3ea7012,0x826c209f,0x73eae010,0xf2925193}},	//   _conta_, _nekog_, _pinter_, _pataje_, 
   {{0x5ff021eb,0xbe6ad008,0xe9870368,0x00000000}},	//   _кечки_, _модда_, _देशमुख_, --, 
   {{0xc2fc609f,0xe3f8703b,0x98626369,0xd2deb255}},	//   _ovoga_, _hinum_, _zapomenu, _memenuhi_, 
   {{0x9c67f1e0,0x3fe82129,0xbdfce02a,0x027ee09a}},	//   _manusia_, _स्थानिक_, _ситуация_, _uhinga_, 
   {{0xd274c045,0xc79562cc,0x00000000,0x00000000}},	//   _سوالف_, _história, --, --, 
   {{0xc05130fd,0x27c72147,0x5a03009f,0x7dadb100}},	//   _хвост_, _тариқи_, _pronađen, _mütəxəss, 
   {{0x13f80167,0x52909183,0x0290d100,0xf0edd367}},	//   _агентств, _praat_, _ordan_, _महापालिक, 
   {{0xce819062,0x3d0cb098,0xd3ea7030,0xb290c134}},	//   _서울특별시_, _комплект, _ponta_, _jamais_, 
   {{0xe25ad065,0x1edc9072,0x0386c0e5,0xa2a7f057}},	//   _amely_, _artistes_, _noored_, _izuba_, 
   {{0xc2cb11b0,0xa200927a,0x42907023,0x435bd0c9}},	//   _mozda_, _trais_, _hunar_, _hangata_, 
   {{0xa29031a5,0xdecbd121,0x5c5b81ad,0x38c28035}},	//   _najan_, _ترکیبی_, _postaci_, _ドラマティック_, 
   {{0xe200b164,0xc2902010,0x13ea71f9,0xf290e2a0}},	//   _jedino_, _pakan_, _tonta_, _einari_, 
   {{0xf2255173,0x77a3e14b,0xded4010e,0x035951c8}},	//   _amekas_, _područja_, _filistin, _trafiku_, 
   {{0x2ec20002,0x505a117e,0x00000000,0x00000000}},	//   _valitsus_, _променли, --, --, 
   {{0xe79562b7,0x89cb110f,0xea8c40f4,0x737922b0}},	// [7d0] _históric, _belediye, _chairmen_, _albainn_, 
   {{0xb24801ec,0xa2d6a0c4,0x00000000,0x00000000}},	//   _nzima_, _priodol_, --, --, 
   {{0x62b43267,0x4387717e,0xd3f8f36a,0x5200d07a}},	//   _entità_, _quarto_, _sigue_, _brein_, 
   {{0x32904098,0x520040f2,0x3688c11b,0x97b35260}},	//   _samaa_, _samia_, _такрорла, _geospati, 
   {{0x16e200e1,0x852ef0ba,0x12002128,0x837f31e0}},	//   _резултат, _mwendesh, _sakin_, _namanya_, 
   {{0xa4d6502e,0x5b1fc1bc,0xb003603d,0x00000000}},	//   _हाजिरी_, _kelantan_, _konsultā, --, 
   {{0x269532cf,0x627f00f4,0x9471e053,0x31c55191}},	//   _fhreagai, _mwangu_, _hantaran_, _اضطراب_, 
   {{0xa200d240,0x1ce0503c,0x02fc636b,0x4ebac079}},	//   _grein_, _削除用パスワ_, _svoga_, _боала_, 
   {{0x7291c26f,0x0061c36c,0x42018008,0xed3b0151}},	//   _kuvan_, _стате_, _turib_, _国家知识产权局_, 
   {{0x42ca7034,0x23122187,0x6a164174,0xacf710b8}},	//   _mondo_, _प्रमाणपत, _minangka_, _southwar, 
   {{0x72904010,0xc4fec12a,0x82b6620a,0x329031fb}},	//   _jaman_, _временно_, _marcha_, _wajan_, 
   {{0xfff3e16d,0x5290f12f,0xd286220f,0xd26e624c}},	//   _nepremič, _rugam_, _dunkeld_, _batohy_, 
   {{0xe4b470f6,0x2cb7b0eb,0x5c80110a,0xd3cba017}},	//   _didaktik, _границе_, _лесен_, _לפגוע_, 
   {{0x87091015,0x32fe52b5,0xd2916062,0x1291c022}},	//   _четири_, _drugog_, _gegaan_, _arvad_, 
   {{0xb290412e,0xd2004150,0xb213802a,0xa290c168}},	//   _naman_, _namin_, _perhe_, _delano_, 
   {{0x4a442016,0xded75091,0x4ef5a075,0x412d304c}},	//   _טראפיק_, _bonitetn, _আরাফাত_, _танти_, 
   {{0x2291e193,0x3db912e8,0x8723c05f,0xe1c3c00c}},	// [7e0] _detay_, _zhongsha, _جهازك_, _उन्हा_, 
   {{0xc2caf137,0xd291836d,0x64a7e0b2,0xf2ea50ec}},	//   _pridaj_, _otras_, _organitz, _região_, 
   {{0xa38660b2,0x0a8fd2e4,0x93bfe0c8,0x4201a16d}},	//   _acord_, _penipuan_, _맨마지막글_, _kupil_, 
   {{0x42bfc2f5,0xf2f232ef,0xb2d87069,0xc44792bf}},	//   _شمشاد_, _putovanj, _kinek_, _पकौड़ी_, 
   {{0xb4fbb248,0x3b1fb115,0x06678024,0x00000000}},	//   _चुनावी_, _kajadian_, _बेकसूर_, --, 
   {{0x20d7a0c3,0x1dffd0a9,0xf41282b5,0x1cb281c1}},	//   _הגאון_, _ketentua, _sarajevo_, _sarajevu_, 
   {{0x4d417255,0x42904240,0x2be2312a,0x929050f2}},	//   _membantu_, _gaman_, _inserisc, _lalan_, 
   {{0xcbddc1ff,0xa5c1d02d,0xa0464187,0x96cdd0a1}},	//   _बप्पा_, _batafsil_, _zeměděls, _топольда, 
   {{0x74b8218b,0x6237305c,0x22cae318,0x00000000}},	//   _विशेषतः_, _filmova_, _dindar_, --, 
   {{0xb9d7a273,0xaa77a0cf,0xc03391e9,0x473a3072}},	//   _प्रयाग_, _प्रभाग_, _демотива, _колго_, 
   {{0x1cd7d0a5,0x085c2127,0x4236d09f,0x2ceed1e8}},	//   _pretraži, _истеъмол, _svojoj_, _среде_, 
   {{0x10d620c3,0x82905068,0x0d05e006,0x00372119}},	//   _מיטגליד_, _kalan_, _introduc, _группа_, 
   {{0xd3f9b173,0xf2fcd1fd,0xada021ae,0xf757d0f8}},	//   _nique_, _blogak_, _anankira, _মরুভূমির_, 
   {{0x32005038,0x12905010,0x1df62006,0xb3341016}},	//   _dalin_, _dalan_, _מיליארד_, _סאציאלע_, 
   {{0x8581a0b2,0xd8b2315d,0xb2c43033,0x7c625092}},	//   _депутатт, _форумда_, _televisi_, _rubrice_, 
   {{0x5886d36e,0x82a770b0,0xe9eb71b1,0x92d6713b}},	//   _प्रस्ताव, _muaban_, _langilee, _patokan_, 
   {{0x70253174,0x42da60f2,0x8cd4836f,0xc3a232a4}},	// [7f0] _عوارض_, _horeba_, _uskutočn, _kempen_, 
   {{0xfd173069,0x28b6d191,0x00000000,0x00000000}},	//   _علاقوں_, _شرايط_, --, --, 
   {{0xf20011c8,0x738071b1,0x0290c304,0xc387a0b9}},	//   _ishin_, _mauris_, _malata_, _espri_, 
   {{0xf2905121,0x0d945160,0xa6dea0c7,0x738690e9}},	//   _balan_, _finanšu_, _məsuliyy, _abari_, 
   {{0x0ff1d258,0x16e60100,0x1ed41171,0x3c02b042}},	//   _नियुक्ति_, _kampaniy, _palielin, _básico_, 
   {{0x59f3602f,0x127ff370,0x491e200c,0xc200b0ff}},	//   _constitu, _jauna_, _पत्रिकाक, _indiki_, 
   {{0xe998e182,0x32903089,0x4f054246,0x12f390ba}},	//   _каментар, _nemamo_, _mišković_, _magazeti_, 
   {{0x329050a7,0x5ea6422c,0x02ec621a,0x52005240}},	//   _falan_, _interess_, _teknisk_, _falin_, 
   {{0x925af277,0x56bd60eb,0xdc1d20aa,0x1e1a5200}},	//   _nogle_, _операциј, _kitablar, _videnska, 
   {{0x8a04c116,0x6a25a0f4,0x00000000,0x00000000}},	//   _dibattit, _abachaga_, --, --, 
   {{0x820110f4,0x83e07065,0xfa577075,0x4f3700b1}},	//   _bibiri_, _héten_, _করুনঃ_, _uskunala, 
   {{0x62905022,0x58e22119,0xc33da069,0x12d821f1}},	//   _yalan_, _форуме_, _ہتھیار_, _liker_, 
   {{0x826c5297,0xd5f3a1a4,0x7cd7c045,0xd40f2079}},	//   _tabindex_, _моменти_, _إعداد_, _адулций_, 
   {{0xe3f82010,0x143f1138,0x1770b371,0x52005178}},	//   _tikus_, _استضافة_, _क्लासीफा, _valin_, 
   {{0xe03cd037,0xdfa4f155,0xb351d02f,0x5231728d}},	//   _recensio, _november_, _其版权属于商务部, _fermana_, 
   {{0x0c66b0a4,0x53a0c198,0x5c65026f,0x07f24092}},	//   _bestemt_, _удостове, _отечеств, _नजिस्क्य, 
  
   {{0x4ffad033,0x52908002,0xa25521f2,0x62da7292}},	// [800] _परवानगी_, _tahaks_, _directam, _joseba_, 
   {{0x7291825b,0x2069802a,0x9a48d345,0x52f5b069}},	//   _surah_, _напомина, _freeship_, _akciók_, 
   {{0xe25a6002,0xa200b35f,0xdd717255,0xd9bab0c8}},	//   _poolt_, _pedido_, _berminat_, _뮤직비디오_, 
   {{0xbc446186,0x02002267,0x3fd630f9,0x72f42017}},	//   _プライバシ_, _żmien_, _шартпен_, _באחריות_, 
   {{0x437970e6,0x4b40b01e,0x220050ee,0xe29050ff}},	//   _poradna_, _남겨주세요_, _balio_, _qalan_, 
   {{0x62a6e115,0x63f83036,0x53e54146,0xb6953330}},	//   _tribun_, _kamusi_, _imputati_, _disesuai, 
   {{0xd2480022,0xa2e9f0d2,0x2ead8195,0x00000000}},	//   _daimi_, _gjendet_, _комисија, --, 
   {{0x81f7d069,0x3486800c,0x7f540006,0x32005192}},	//   _معذرت_, _बाजारी_, _תאילנד_, _talin_, 
   {{0xd20010f2,0xa3bbb09a,0xdc00d0fd,0xa36c7004}},	//   _mahia_, _indwara_, _maistas_, _lengvai_, 
   {{0xb29071f9,0x4290706a,0xf27e9026,0x83869277}},	//   _manan_, _sanaa_, _nyani_, _vcard_, 
   {{0x029052f1,0x7847c127,0x22d8c087,0x4f239016}},	//   _salan_, _ҳайати_, _videl_, _דעפארטמע, 
   {{0x6290f07f,0xc2019027,0x227f401d,0x3291f2fa}},	//   _bahawa_, _musia_, _tienen_, _hutan_, 
   {{0x64225032,0x82912257,0x23ead0c4,0x00000000}},	//   _indirizz, _ticari_, _doeth_, --, 
   {{0xe68a70dd,0x1f0e3098,0xb17720dd,0x28c751a0}},	//   _организо, _социальн, _месту_, _stadionu, 
   {{0x62005226,0xdff2c230,0x21cc908b,0x13f8f1c6}},	//   _valio_, _presvedč, _activité_, _sigui_, 
   {{0xc3f8208c,0xde913138,0xa200d05f,0x7616a0ca}},	//   _sikur_, _ينبغي_, _breis_, _ballkani, 
   {{0x42b4003d,0x82d8d08d,0x88701150,0x115a807d}},	// [810] _teica_, _dieet_, _pakiramd, _situasjo, 
   {{0xc0741016,0x127ff207,0x09bad1c7,0x1dfad0ac}},	//   _גניבות_, _hyung_, _povezava_, _povezave_, 
   {{0x2405f1e6,0x49fe4280,0x00000000,0x00000000}},	//   _başbakan_, _verament, --, --, 
   {{0x92d8c155,0x229272b0,0xa290d109,0x42001041}},	//   _under_, _turais_, _treas_, _nkhib_, 
   {{0x7a97400c,0x446951e8,0x0e26802c,0x4f3cd1c9}},	//   _सम्मान_, _пристигн, _халяву_, _arfordir_, 
   {{0x4290320f,0x627f00e9,0x183b603c,0xa27e6214}},	//   _camara_, _abandi_, _こんにちは_, _ikony_, 
   {{0x62c94024,0x83f0d0c2,0x77ca50fd,0x3d09103a}},	//   _stronie_, _sumedang_, _verslini, _उपलब्धि_, 
   {{0x027f4212,0x65af31b5,0x7366a132,0x4305201c}},	//   _mwenge_, _споразум, _tangkal_, _ostalom_, 
   {{0x92d981b1,0x12907262,0xb2ec6155,0xf84e9026}},	//   _diren_, _canan_, _february_, _chloroqu, 
   {{0xaa083069,0xa3c1f043,0xe9e0e149,0x960ad040}},	//   _تصدیق_, _географі, _izborima_, _algonqui, 
   {{0xb6d91094,0x7387e171,0xe148319e,0x02b210d4}},	//   _тавассут, _katru_, _kaverill, _सचमुच_, 
   {{0xb387d133,0x53eb92fd,0x8b8a1030,0xff041148}},	//   _dobrý_, _boste_, _норок_, _chladnič, 
   {{0xe2bb30dc,0x1c983030,0x4cbd4017,0x1aefb13d}},	//   _akhente_, _бундесре, _disabled_, _hystyrie, 
   {{0x33eb804d,0xb29040c9,0xd290f039,0x23f4003e}},	//   _porte_, _esman_, _magad_, _erster_, 
   {{0x4deb312a,0x4c0250fd,0x8f53d10a,0xa34fd1de}},	//   _странно_, _verslas_, _домашна_, _keresek_, 
   {{0x52cb503e,0xa1c73121,0xcb8bd0b1,0x024830de}},	//   _wieder_, _هاستینگ_, _vakillar, _kommun_, 
   {{0x6ab1908f,0x2ba4f00f,0xf291f0ff,0xe00820c3}},	// [820] _область_, _diskuter, _tutan_, _געגנטן_, 
   {{0x5759d024,0x5ccd42f1,0xb2d8508c,0x00000000}},	//   _निर्यात_, _salveger, _cilet_, --, 
   {{0x13ebf0de,0xd47bf1f9,0x52cae27c,0x00000000}},	//   _sluta_, _misterin_, _bindur_, --, 
   {{0xd0e96142,0x9637c032,0xc2d98068,0x00000000}},	//   _अनुक्रम_, _файлове_, _giren_, --, 
   {{0x4a39217f,0xa31b61e6,0x82e5617a,0x5b5cb299}},	//   _веселие_, _müzik_, _mínimo_, _jedinečn, 
   {{0x92cae06c,0xb2009199,0xd3178015,0x00000000}},	//   _findes_, _mikiny_, _ubrzo_, --, 
   {{0x525a513d,0xa00521e8,0x8b196330,0xad49f230}},	//   _colli_, _огромна_, _batalkan_, _filtráci, 
   {{0x63870099,0x4292604c,0xfacaf1ee,0x62041187}},	//   _dobrze_, _durata_, _látogató, _probíhá_, 
   {{0x095630e3,0x18e6314c,0x2ee9d038,0x42b281da}},	//   _минуте_, _минути_, _funksion, _munduan_, 
   {{0x3479f053,0x7ac310cd,0xccbe3126,0x7f2170c8}},	//   _diletakk, _театрынд, _далел_, _홈페이지를_, 
   {{0x1e55e1b1,0xc4d791eb,0xdc5781c6,0x82e87060}},	//   _espainia, _намазы_, _чагылдыр, _derfet_, 
   {{0x125b9246,0x229070cc,0xfa963169,0x420070f2}},	//   _posle_, _tanan_, _नर्मदा_, _tanin_, 
   {{0x025a904f,0x23eb507a,0xa290f010,0x241801b1}},	//   _zoals_, _pieter_, _jagad_, _nabigatz, 
   {{0xb9ef40ce,0x5f5d41a9,0x00000000,0x00000000}},	//   _استعادة_, _disarman, --, --, 
   {{0x3a008060,0x339b103c,0xbb745102,0x00000000}},	//   _piraniya_, _こんばんは_, _реглемен, --, 
   {{0x927f723b,0x92eff0f4,0x1cccc008,0x52fc70db}},	//   _khanna_, _okufa_, _иложи_, _menge_, 
   {{0xa2d8406c,0x0ee3b2a1,0x42fc71f1,0xf201804c}},	// [830] _timer_, _महत्वाका, _lenge_, _murit_, 
   {{0x6eca30bc,0x55040102,0xfcdf602c,0x85be71b5}},	//   _imininin, _produsul_, _аспектах_, _формиран, 
   {{0x4290a12e,0xc2d850de,0x7eacc322,0x226c82ba}},	//   _laban_, _filer_, _dovoljen, _sinoć_, 
   {{0xf6a90262,0x02009199,0x00000000,0x00000000}},	//   _litreach, _bikiny_, --, --, 
   {{0x3248906a,0xb2d8721c,0x12fcd0ba,0xb65750f9}},	//   _chama_, _ihnen_, _ndege_, _ұлыбрита, 
   {{0xf630b138,0xed86b180,0x00000000,0x00000000}},	//   _الأبيض_, _vrednost_, --, --, 
   {{0x6386d0f4,0x3afbc1ce,0x1200a036,0xf2fd2033}},	//   _mberi_, _peperiks, _tabia_, _kuliner_, 
   {{0xa35571b8,0xe43aa035,0xc2fc7068,0x3290a12e}},	//   _cabelos_, _相棒探しから_, _denge_, _kaban_, 
   {{0x29243016,0xbd86c034,0x73eb8072,0xf94e9164}},	//   _אָנװײַז_, _награди_, _horta_, _maglovit, 
   {{0xa2cb4148,0xb4c7b372,0x4dd9c05f,0xaf7ec151}},	//   _predaj_, _buscando_, _اتخاذ_, _中国经济网_, 
   {{0xb4852125,0x839fc045,0x9dc72121,0x923b4151}},	//   _अर्थात_, _اصدار_, _یازدهم_, _控制面板首页_, 
   {{0xe354307f,0x65d9c11b,0xc201c112,0x0d560006}},	//   _selepas_, _инглиз_, _kuvia_, _ליצירת_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe290714a,0xa2499051,0x2f5d323a,0xe5f66072}},	//   _banal_, _bismo_, _merancan, _esperanç, 
   {{0x6ad071e8,0x82d85285,0x48e2f12a,0x00000000}},	//   _инфекции_, _biler_, _депутати, --, 
   {{0x4b612201,0x5d87409f,0xf24111de,0x600e808f}},	//   _también_, _međunaro, _منقطع_, _примерно_, 
   {{0x91f5e114,0xcc9ec02f,0xd69a5022,0xd2499152}},	// [840] _муборак_, _新农村建设_, _sakinlər, _eismo_, 
   {{0x720261e0,0xa27f7110,0x78151075,0x03eb800f}},	//   _terima_, _changa_, _প্রখ্যাত_, _borta_, 
   {{0xb2f3011a,0x525ae109,0xc23b229f,0x84b3f0f4}},	//   _proiect_, _chille_, _klimaat_, _abachwez, 
   {{0xb2fcd09f,0x30473227,0x72906257,0x4c7361b9}},	//   _svega_, _секси_, _aslan_, _podrás_, 
   {{0xfee2d182,0x63164037,0xe30c3053,0x02b2805f}},	//   _атаку_, _bambini_, _pelapis_, _londain_, 
   {{0x33f47084,0x31ed1106,0x1c1d8203,0xc26ce21b}},	//   _sortir_, _formulár, _רשעות_, _osnovu_, 
   {{0xd56400c3,0x46cc2193,0x2c2c2050,0x00000000}},	//   _לאנדאן_, _ekspresy, _ekspress, --, 
   {{0xaef9b0f2,0x0e393254,0x3e4300aa,0xb7f131a4}},	//   _panjakan, _kebangsa, _almaniya, _скара_, 
   {{0x6b280006,0xc291820f,0xebadb18b,0x92d8b006}},	//   _התייעץ_, _curam_, _ऑलिंपिक_, _modern_, 
   {{0xa20e31eb,0x0fa981ee,0x2becd11d,0xa2d8e095}},	//   _балам_, _تبلیغی_, _superthr, _kineza_, 
   {{0xfb8d11e9,0x12d870b3,0x03947035,0x3f1fd1c6}},	//   _artistar, _ihned_, _件を表示していま, _segureta, 
   {{0x1f612289,0x08712195,0xb6293045,0x3a03b157}},	//   _остане_, _остана_, _traidisi, _borasida_, 
   {{0x3105d201,0x83e25065,0xe1d2d147,0x00000000}},	//   _পাশাপাশি_, _természe, _аъзам_, --, 
   {{0x4264e187,0x37a300f5,0xe29201b0,0x00000000}},	//   _नेविगेशन_, _cerulari, _otpada_, --, 
   {{0x63ac609f,0x2200728e,0x024c81f6,0xe82111c6}},	//   _ukupno_, _isnin_, _होखला_, _адабиятт, 
   {{0x03eb9116,0xdf7cf03a,0x2019e211,0xc2d99052}},	//   _bosta_, _पुस्तकें_, _хиротони, _anser_, 
   {{0x93eb902a,0x8291609a,0x00000000,0x00000000}},	// [850] _josta_, _bigari_, --, --, 
   {{0xb373f106,0x32bd720f,0xfc801023,0xefe71108}},	//   _zadajte_, _riddell_, _чечен_, _заявка_, 
   {{0x7c361006,0x54d7d1cd,0xbe917017,0x840130b3}},	//   _לשיקול_, _वेटिकन_, _district_, _infolink, 
   {{0xa248c0df,0x27263015,0x939da004,0x21757129}},	//   _salmah_, _текстова_, _palangoj, _अभियांत्, 
   {{0x23967084,0xbeab71eb,0x00000000,0x00000000}},	//   _passen_, _dimecres_, --, --, 
   {{0x5201123e,0x274251f9,0xf2e3209c,0x6290c0f3}},	//   _yazid_, _fianakav, _maniere_, _madan_, 
   {{0xb290a350,0x5290c193,0xa51091b1,0x805e607a}},	//   _saban_, _ladan_, _hurrengo_, _moontlik_, 
   {{0x4303a09f,0x9067a373,0x3d3c2121,0x65fa70f8}},	//   _pitanju_, _आकासे_, _میدهد_, _হবিগঞ্জ_, 
   {{0xf290b010,0x92a65179,0x3c77306c,0x00000000}},	//   _wacan_, _daljini_, _kristne_, --, 
   {{0xf99970a5,0xa3978215,0xb2552280,0xec68405f}},	//   _traže_, _kızlar_, _direttam, _patrún_, 
   {{0xab399015,0x429270fe,0x00000000,0x00000000}},	//   _договоре_, _sesama_, --, --, 
   {{0xe6661006,0x7784f277,0x5f5d304b,0x2290f075}},	//   _גיימינג_, _frivilli, _perancan, _jugar_, 
   {{0xe292522c,0xd2e11189,0x327ed168,0x1ed11374}},	//   _totali_, _anuncio_, _bennie_, _anuncios_, 
   {{0xd290c2f9,0xd2d9e194,0xf200c1da,0x6394202c}},	//   _dadan_, _enten_, _dadin_, _sekso_, 
   {{0x7cce132b,0x00000000,0x00000000,0x00000000}},	//   _tyskland_, --, --, --, 
   {{0x6366d06b,0x0965b075,0xe34520a6,0xf7c7104c}},	//   _ponedelj, _অদ্ভুত_, _handelt_, _машиний_, 
   {{0x9200c06d,0x0087b034,0x4da01052,0x5d6ac0b5}},	// [860] _nadin_, _природат, _avancera, _звесткі_, 
   {{0x2b1ff19e,0xd3209304,0x2085e0b3,0x058fa006}},	//   _ainakaan_, _tsaya_, _komplexn, _אמצעי_, 
   {{0x52ba2375,0xf2d910c7,0x42026289,0x3e71c05f}},	//   _ponekad_, _gizem_, _equipe_, _وخاصة_, 
   {{0x6ee4107a,0x3a941052,0xdeda9079,0x8bee0008}},	//   _artikels_, _artikeln_, _абундент, _рашод_, 
   {{0xa12d2034,0x3b0c3069,0xbaf5008c,0x42caf042}},	//   _части_, _مابین_, _evropian_, _unidas_, 
   {{0x885b3069,0x5200c058,0x324760ff,0x00000000}},	//   _ellenére_, _milioi_, _dəmir_, --, 
   {{0x037fc053,0x4e86d12a,0x9200c178,0x77b1f29c}},	//   _galanya_, _ефект_, _madio_, _vertrouw, 
   {{0x926cb0c1,0xcfeef0cf,0xd343205f,0xea73a31b}},	//   _redova_, _ख्वाहिश_, _نافذة_, _kutambua_, 
   {{0x854d6182,0x1291c061,0xe15401fc,0x00000000}},	//   _візуальн, _नियोजन_, _vlastito, --, 
   {{0x6386f1a0,0x6d9bd1a3,0x5615a08e,0xa212b262}},	//   _şirin_, _fotorada, _טומאה_, _ouche_, 
   {{0xadc47004,0x62d830ab,0xdbf5a006,0x6fada108}},	//   _konkursa, _valodas_, _אובמה_, _formazio, 
   {{0xa344911a,0x60ddd076,0x0999509f,0xe2d9c209}},	//   _citeste_, _положите, _svakodne, _given_, 
   {{0xa7b3611e,0xec5d9151,0x439501b9,0x00000000}},	//   _konstiti, _功成名就闯大都_, _clases_, --, 
   {{0x138770e3,0xc3ea71fd,0x7ea70151,0xe9b5b1e1}},	//   _foarte_, _kontu_, _掘进工作面_, _mendekat, 
   {{0xc7541034,0x1290a176,0x4290b048,0x59132008}},	//   _независи, _babae_, _macam_, _депутатл, 
   {{0x532071cf,0x129271ae,0xe7e4b00c,0x5201f05b}},	//   _nanya_, _resaka_, _negatiiv, _stuit_, 
   {{0x0320705e,0x07a82007,0xbd7e8069,0x8ddcd065}},	// [870] _ianya_, _approssi, _kézműves_, _بلاول_, 
   {{0xf32072fa,0x22b082e2,0x527ed212,0xe3ead05b}},	//   _hanya_, _कानुन_, _gyonna_, _toets_, 
   {{0x23207083,0xcba42168,0x4e4ff14a,0xecc420f6}},	//   _kanya_, _artikulo_, _pinakama, _artikulu_, 
   {{0xf2fce30d,0x533d0010,0xf6b9529c,0x53a2d04d}},	//   _sangat_, _ایلام_, _belangri, _propos_, 
   {{0x32d9e2ff,0xf3eba159,0x432071a6,0xb271d188}},	//   _miten_, _sixtus_, _manya_, _jānis_, 
   {{0x22d9e1f1,0x73a2023e,0xa1471122,0x96f9c1c3}},	//   _liten_, _kuipa_, _расида_, _saibnkaw, 
   {{0xaf64c1ad,0x461ee07a,0x42026034,0x00000000}},	//   _negatywn, _vernieti, _arriva_, --, 
   {{0xe224003b,0xc387f050,0x8cbec004,0xe2596146}},	//   _leika_, _lauri_, _капец_, _partikol, 
   {{0x1290b1fd,0xdf2a828d,0x7a018019,0x929ec031}},	//   _bidali_, _desthila, _marrasku, _видам_, 
   {{0x3786600e,0x4f3fe027,0x8320710d,0x9df7b191}},	//   _turvalli, _nakoniec_, _aanya_, _دلنوشته_, 
   {{0xac5280ef,0x03407145,0x14499035,0xc3f9811b}},	//   _denthan_, _nedeľa_, _ドを忘れた_, _бразилия, 
   {{0x820041e6,0x4fe32121,0xe347c00f,0xc4fbe033}},	//   _izmir_, _رایتل_, _handlar_, _कंटाळा_, 
   {{0x8d38e102,0x6a2d301a,0x534d9151,0xa2d9e08c}},	//   _milioane_, _қимыл_, _中央电视台_, _diten_, 
   {{0x0495e376,0xea2de280,0xd2d8a12f,0x32730138}},	//   _potrebuj, _победите, _liber_, _dúnta_, 
   {{0x09a96121,0x7bdf0138,0x16dc2258,0x525b5017}},	//   _دوچرخه_, _ومستلزما, _पारित_, _fields_, 
   {{0x425bf2c2,0xb20180d2,0xb2ac711e,0x1868c05f}},	//   _boule_, _arrin_, _popilè_, _ريجيم_, 
   {{0x128cc069,0xdb9b5062,0x4301e021,0xae240119}},	// [880] _علامہ_, _technisc, _garansi_, _hallitus_, 
   {{0xc9f341f5,0x93a2c062,0x0200e10e,0x02d68111}},	//   _prostred, _helpen_, _dafin_, _lyžování_, 
   {{0x51510121,0x07f29095,0x51a101de,0x21008084}},	//   _اشتغال_, _prebaciv, _اشتعال_, _октябрда_, 
   {{0x748e9089,0x63eb702b,0x58e8d0a6,0x00000000}},	//   _napravlj, _platba_, _leistung, --, 
   {{0xf300d053,0xd097b0cd,0xc3966204,0xc2d82121}},	//   _ustazah_, _армиясы_, _varsin_, _pakem_, 
   {{0x52900030,0xa3f471c6,0x2e70e20d,0x00000000}},	//   _chiar_, _partit_, _झुण्ड_, --, 
   {{0x72d9e284,0x00000000,0x00000000,0x00000000}},	//   _intet_, --, --, --, 
   {{0x6248d21c,0x22b652c2,0x8606b2d7,0x28bbe035}},	//   _thema_, _mouche_, _sammenli, _キャラクタ_, 
   {{0x7200c0b8,0xc625d1ad,0x62900045,0xbfb4902a}},	//   _balita_, _pomorski, _thiar_, _мудрец_, 
   {{0x92919033,0xd2f742a4,0x724991b9,0xcc714377}},	//   _rusak_, _kalimah_, _misma_, _मोर्चे_, 
   {{0x3200c1ac,0x72d761a2,0xb200c204,0x9b69c019}},	//   _kulima_, _navodno_, _valita_, _договора_, 
   {{0x825a520d,0x23431079,0xf2b310e2,0x82d8316d}},	//   _mille_, _сорока_, _keadaan_, _člena_, 
   {{0x725a5378,0x0c36f035,0x397ec068,0xe25ad102}},	//   _lille_, _この質問の閲覧数_, _kelimele, _unele_, 
   {{0xddbd30b2,0xa2ef32b8,0x22d9c0d2,0x6075d11b}},	//   _superfíc, _pamilya_, _enver_, _кубоги_, 
   {{0x225ac0fa,0x94860268,0x4058401a,0x32cbf11e}},	//   _okolie_, _प्रातः_, _министрі, _soude_, 
   {{0x0200f272,0xc2499101,0x6220000c,0x8bdf20de}},	//   _dagin_, _bisma_, _viljandi_, _semester, 
   {{0x946ee119,0x0723e01c,0x75cde28c,0x1290a0fb}},	// [890] _время_, _kulturom_, _sayangny, _tabac_, 
   {{0x13ebf092,0x0c5bf038,0x3df1b03f,0x930db006}},	//   _historii_, _histori_, _sledovat_, _ויופי_, 
   {{0x326cf0af,0x8366a150,0xc57e40c4,0xa200f0cc}},	//   _jehova_, _tungkol_, _benderfy, _nagin_, 
   {{0x5b1f40c8,0xaf7a501a,0x00000000,0x00000000}},	//   _효과적으로_, _филиалын, --, --, 
   {{0x425ba0ef,0x9681315d,0x047a70f5,0x36dad379}},	//   _amply_, _шарқий_, _pontmain_, _ачестора_, 
   {{0x1f5db270,0x607c2138,0x017d90c3,0x23f40032}},	//   _tulajdon, _الفقه_, _עיבור_, _nostri_, 
   {{0x3a12e1c5,0x1ccc1010,0x537f8081,0xe27f7029}},	//   _inscrive, _ایرنا_, _muhanga_, _nyanga_, 
   {{0x8200c150,0x78052075,0x55bbf270,0xe5a1f038}},	//   _salita_, _জালবাজ_, _önkormán, _politikë, 
   {{0x97b74092,0xb2f3723a,0x143881eb,0xe29250b0}},	//   _poplatek_, _peminat_, _тажрыйба, _vitalk_, 
   {{0x0ef150ee,0xba11f25e,0x92d9e019,0xf96720e6}},	//   _kaмep_, _garancia_, _siten_, _prosinec_, 
   {{0x337b9251,0x629e7177,0x48ef60c8,0x00000000}},	//   _skladem_, _céard_, _각종계약서_, --, 
   {{0x28b6e177,0x82122083,0x3af51078,0xc3f2209e}},	//   _عرايس_, _mukha_, _entegras, _eddobooz, 
   {{0x12d851fb,0xd6a8f094,0x3c60408b,0x33486156}},	//   _dalem_, _дастгири, _lettres_, _clienti_, 
   {{0x93eaf02a,0x42cad03d,0x820e1008,0x1200f102}},	//   _kiitos_, _bildes_, _насаф_, _schimb_, 
   {{0xe2d9e239,0x8ff8201e,0xa388f0fc,0xf695c145}},	//   _antes_, _클린중개업소_, _unutrašn, _prezentá, 
   {{0x1f0d1170,0x8200d1e7,0x635f902b,0x8290d1f2}},	//   _संस्कृती_, _preis_, _recepty_, _crear_, 
   {{0xc346d0fd,0xa290e146,0x615a9034,0xdc035288}},	// [8a0] _vandens_, _finali_, _difficil, _físico_, 
   {{0x368fe0c4,0xf2d7118a,0x561c5005,0x29e07087}},	//   _gwreiddi, _mirongo_, _podlaski, _navodila_, 
   {{0xa57e413d,0x03410033,0x3c74427a,0xe4472004}},	//   _penderfy, _जाणून_, _mesurau_, _pristatė_, 
   {{0x43f85262,0x37f6812a,0x7bedf179,0xf320f1a6}},	//   _calum_, _текстове_, _varaliča, _nagyo_, 
   {{0xe291f039,0xa1e1e1de,0xae1202aa,0x00000000}},	//   _mutat_, _کمزوری_, _vereinba, --, 
   {{0x87293127,0x23ea60f6,0x32d8c04d,0x9fd30095}},	//   _шоири_, _diote_, _aider_, _postojeć, 
   {{0x42980137,0x53af3105,0x9386a30a,0x855150e6}},	//   _vďaka_, _løpet_, _bidrag_, _कल्याणका, 
   {{0x32918039,0xa394024e,0x5200b2c7,0x822400d0}},	//   _marad_, _afise_, _hacia_, _afike_, 
   {{0x1591d062,0x9c62637a,0x03806300,0xae03f08a}},	//   _안녕하세요_, _escribe_, _aktris_, _форматы_, 
   {{0xebf5a006,0x12bb907a,0x8aad61a7,0xac6122de}},	//   _עולמי_, _engelse_, _berkesan_, _består_, 
   {{0x72925316,0x79d22139,0xe818e043,0x41e3320a}},	//   _kotani_, _enregist, _договору_, _autoprom, 
   {{0x722cc072,0x22d84297,0xa77d305f,0xbe96d191}},	//   _сателлит_, _gamek_, _الحزب_, _آرزوی_, 
   {{0x6229108f,0x526e409b,0xa0d7c079,0xefac112a}},	//   _показать_, _atribusi_, _биколор_, _promozio, 
   {{0xc3a0103c,0xd0f9e37b,0xdf2d60ec,0x623931d7}},	//   _ログインして投票, _forhandl, _através_, _розум_, 
   {{0xd27ef0bd,0x522550b1,0x2b824062,0x22d8b053}},	//   _meiner_, _elektr_, _standaar, _paderi_, 
   {{0x4a3c217f,0x327f414c,0xccc9c015,0x7af040c8}},	//   _хутор_, _utente_, _многим_, _구매평가를_, 
   {{0x22fce244,0xc44ac152,0x7d1e2151,0x6424102a}},	// [8b0] _banget_, _джона_, _明星大哉问_, _politiik, 
   {{0xe2d85099,0x2e99711e,0x439400a6,0x626e51b7}},	//   _dalej_, _kontinye_, _meist_, _autore_, 
   {{0xa3f8c18b,0xc711b00c,0xec8011a8,0x77a37153}},	//   _tidur_, _जबरदस्ती_, _терең_, _protecci, 
   {{0x1ef1e00c,0x5b91e024,0x527f72f1,0x6e1d91ca}},	//   _विश्वामि, _zamieszc, _ajansa_, _компрома, 
   {{0xf2efd042,0x539400e5,0x48899347,0xcd40305f}},	//   _galicia_, _neist_, _тамашала, _انتهت_, 
   {{0xde9ec347,0x017d90c3,0xe30d211a,0x6381a075}},	//   _файлы_, _חילוק_, _sambata_, _দাঁড়িয়, 
   {{0xac76437c,0x99495306,0x6290f1c4,0x9348d087}},	//   _estudos_, _наразылы, _magam_, _katerih_, 
   {{0xed8df2c6,0xd2911257,0x385f20f5,0x27c961ad}},	//   _odgovara, _yazan_, _missnoob_, _postanow, 
   {{0xf2ca7183,0xae96b1d8,0x029112b5,0x9287c045}},	//   _einde_, _bastante_, _kazao_, _أفراد_, 
   {{0x529122bd,0x02ca7107,0x0d5ac14c,0x42e5c01e}},	//   _bayan_, _finde_, _модел_, _통신판매업_, 
   {{0xbd96a2b2,0x03107065,0x1bdf809a,0xd3930069}},	//   _tallinna, _hiszen_, _ruhenger, _سینکڑوں_, 
   {{0xac048027,0x62eef110,0xfaee1134,0xc7c4b05c}},	//   _uhasili_, _heifer_, _quotidie, _околност, 
   {{0xa964601f,0xe0528133,0x64b84092,0xdc2821b9}},	//   _jerosale, _poznámka_, _एभरेष्ट_, _sociedad_, 
   {{0x841dd121,0x4bee10fd,0x4682b0fb,0x3d182248}},	//   _سالگی_, _каток_, _сексуалд, _कारबाही_, 
   {{0x421340a7,0x152b7280,0x33a2a035,0x8651405f}},	//   _şehir_, _достовер, _ご利用案内_, _العثور_, 
   {{0x01682006,0xf51350cd,0x21c68094,0x12b53316}},	//   _כתוצאה_, _энергиян, _ҳайъати_, _wandale_, 
   {{0xb2026032,0xac630029,0xd9f2a0bc,0xf320c010}},	// [8c0] _aprile_, _matumbo_, _amahngwa_, _madya_, 
   {{0x2e6ac118,0x62d98086,0x37287023,0xfaed00b8}},	//   _фонды_, _gazeti_, _мардикор, _carleton_, 
   {{0x983721cb,0xc9d9a1da,0xf2131251,0xe290c086}},	//   _паралел_, _esperime, _bychom_, _silaha_, 
   {{0x1e18e03d,0xf206e088,0x3290c026,0x00000000}},	//   _galerija, _クリックで拡大_, _gadaa_, --, 
   {{0x929b4175,0x1c23a08e,0x5289c220,0x527e90f3}},	//   _izbový_, _קראון_, _سقراط_, _ajans_, 
   {{0x75c3a122,0x1291837d,0x80492156,0xd21240b0}},	//   _кодекси_, _aurat_, _периода_, _bumha_, 
   {{0x92b47068,0x126c2098,0x26f7602e,0x429181a7}},	//   _bence_, _alkoi_, _दयावान_, _surau_, 
   {{0x827ed0bc,0x9201b026,0xb291c1cd,0x94e4d1c6}},	//   _tjena_, _kuvina_, _arvan_, _окумушту, 
   {{0x821c003e,0x8a14203e,0x7e542034,0xe200d007}},	//   _bisher_, _finanzie, _finanzia, _eroina_, 
   {{0xa2d981b2,0xa20110ff,0x8d3cd02f,0xb29030ba}},	//   _firem_, _fazil_, _发表评论于_, _jamani_, 
   {{0x068c11cd,0xb00f2069,0x6e52b010,0xc99190c4}},	//   _बेताब_, _ہسپتال_, _perbanya, _technole, 
   {{0xe712f19c,0x28f2912a,0x00000000,0x00000000}},	//   _форумі_, _интервют, --, --, 
   {{0x3d9ca1ad,0xbd55c023,0xd26af079,0x00000000}},	//   _kolekcje_, _assalomu_, _апариция_, --, 
   {{0xa291803d,0xc12d208f,0xd2d87006,0xaad740cb}},	//   _kuras_, _карты_, _panel_, _festplat, 
   {{0x82250010,0x74607296,0xb201813a,0x8ed5c07d}},	//   _anakku_, _menerusk, _juris_, _kopierin, 
   {{0x22a40093,0x62e30019,0x12e3103f,0x308cc1ef}},	//   _инноваци, _valitse_, _policie_, _слове_, 
   {{0xe2d991f9,0x0361a0e1,0xc290f1b4,0x48cf1069}},	// [8d0] _gazety_, _основу_, _mahara_, _ہلاکت_, 
   {{0xfc71400c,0x37a6b071,0x127f700b,0x7c5980b2}},	//   _मार्गी_, _spotkani, _nyanza_, _дирекция, 
   {{0x3b090138,0xeb0b3035,0xb2d830b3,0xe3d161c5}},	//   _تذكرني_, _一部例外あり_, _objem_, _marché_, 
   {{0x47a6b289,0xf2d8f0cc,0xf7eef084,0xba1ec072}},	//   _текстови_, _liger_, _аппендиц, _бийик_, 
   {{0xb291f071,0x7628b155,0x5201a03a,0xc46bc19e}},	//   _tutaj_, _navigati, _mapie_, _скидки_, 
   {{0xc35881eb,0x736ce161,0xa29100cc,0xc26681fe}},	//   _pàgina_, _margadh_, _mabasa_, _koloneli_, 
   {{0x170e10c3,0xcaee106d,0xd51b9006,0x9291227b}},	//   _אוודאי_, _tenduris, _ההצעה_, _hayal_, 
   {{0x426c21ae,0x68464080,0x2785f03d,0xe224618a}},	//   _kokoa_, _realizad, _normatīv, _bwoko_, 
   {{0x9f165024,0x0299e0be,0x417d3038,0x92914045}},	//   _शादीशुदा_, _svojím_, _parandal, _theach_, 
   {{0x3291820f,0xd26cd0c9,0xc103c0f9,0x00000000}},	//   _turas_, _arnone_, _білмей_, --, 
   {{0xb2020131,0x6925a034,0xbe232044,0xa2d8325d}},	//   _misiri_, _главата_, _gwefanna, _colores_, 
   {{0xa2010036,0xbae8118b,0x794c0016,0x4e38f138}},	//   _kabisa_, _सर्वत्र_, _באזונדער_, _carachta, 
   {{0x54b5e1e9,0xb0f62006,0xfc78e0ff,0x7445903f}},	//   _будинок_, _הבחירות_, _fərqli_, _गण्डकी_, 
   {{0x731920a9,0xcd2470d0,0xaec7a191,0x00000000}},	//   _dibilang_, _blantyre_, _میدهند_, --, 
   {{0xe2245253,0x51c6b006,0x02c6b13d,0xa202111a}},	//   _belki_, _category_, _categori_, _copiii_, 
   {{0xb2903086,0x73fe5065,0x19d94006,0x35ce40a9}},	//   _zamani_, _amerikai_, _governme, _barangny, 
   {{0x3ec21173,0xf3eae033,0xc755e042,0x3fe8c210}},	// [8e0] _vientian, _lintas_, _católica_, _театрда_, 
   {{0x43eb5067,0xe59f120d,0x1401705f,0xe77b30cd}},	//   _vietas_, _करुणानिध, _المؤلف_, _психикал, 
   {{0x827ec145,0x361f1265,0xc20270b1,0xde46e25e}},	//   _fronte_, _resoluci, _musiqa_, _karbanta, 
   {{0x12910029,0x5d07b0c3,0xc7b9d18b,0xbb601035}},	//   _sabata_, _ארטאדאקס, _memungki, _ショッピングカ_, 
   {{0x7200e162,0x6dc8202e,0x1f3f620d,0x6200c11b}},	//   _punika_, _सत्यदेव_, _ट्विस्ट_, _jaligi_, 
   {{0x111b001e,0x485640c7,0x30b12033,0x2db7d150}},	//   _개인정보취급방침_, _əslində_, _बिरुटे_, _aktibida, 
   {{0x92f3a016,0x10d3326f,0x4ed6507e,0x24e53072}},	//   _הרבני_, _класс_, _dilindun, _мурдагы_, 
   {{0xa3f8f211,0x29ab500e,0x791b70b0,0x1d179084}},	//   _sigur_, _остальны, _toán_, _декабрда_, 
   {{0xbd9dc164,0xe2d8c238,0x827e9110,0x973890b8}},	//   _jednosta, _galega_, _njani_, _unforgiv, 
   {{0xa917602f,0xb25a50d2,0xa7b9d0fe,0x9f6ad20d}},	//   _地方商务之窗_, _tilla_, _kemungki, _बिंदिया_, 
   {{0x93ba7270,0x5290c267,0xd43262ad,0xd3ee507d}},	//   _privát_, _onlajn_, _descanso_, _органами_, 
   {{0xf3c43122,0x62d871ba,0x898d4031,0x366ef151}},	//   _кӯмак_, _maneh_, _популарн, _中国经典经济现代, 
   {{0xb90a21e9,0xf2b66024,0x88ccd1d7,0x00000000}},	//   _лютий_, _marcin_, _контурна, --, 
   {{0xb2e85249,0x4394f083,0x34ab2199,0x99585145}},	//   _poslednj, _moises_, _keramick, _posledne, 
   {{0xe201b046,0x3200b106,0x51df80b1,0xc200306a}},	//   _davita_, _akcia_, _tomonlam, _kamili_, 
   {{0xc358937e,0xb3f82255,0x3290007f,0x02fc937f}},	//   _página_, _takut_, _skian_, _klage_, 
   {{0x63ea0146,0xd3687043,0xfed7807f,0x22b360fe}},	// [8f0] _uniti_, _наприкла, _hakikatn, _saudara_, 
   {{0x4d3921aa,0x5290c0c4,0x39512098,0x8e99d04c}},	//   _mobifone_, _gydag_, _automaat, _кампание, 
   {{0xa25b70e8,0xd201f07a,0xb873c17e,0xf65880e3}},	//   _amalan_, _bruin_, _procurar_, _регуль_, 
   {{0x82f3c15d,0xf2cae069,0x5f0ef0b0,0xa3ebf183}},	//   _юлдуз_, _mondja_, _nhếch_, _foute_, 
   {{0xa2910057,0x8db43121,0x12d91380,0xf65a8069}},	//   _kubaka_, _کوروش_, _dizer_, _اہلسنت_, 
   {{0xa6b8e1ae,0x12e771e0,0x8dfcc043,0x121a91ad}},	//   _madagasi, _bernama_, _учитель_, _एकदिवसीय_, 
   {{0x33a9212e,0x626cb2e5,0xe2da5316,0x00000000}},	//   _maaaring_, _didome_, _zotero_, --, 
   {{0xab0172d9,0x620091c3,0xe201c006,0xc5831015}},	//   _posición_, _khaim_, _david_, _москви_, 
   {{0xaa8fe132,0x9201e1ea,0xe2d8b030,0xed00e0cb}},	//   _kuningan_, _natif_, _facem_, _herunter, 
   {{0xf3f9124e,0xe5a3a17f,0xc34b6065,0xcee7c157}},	//   _zaburi_, _елементе_, _médiaajá, _оркали_, 
   {{0xd7b6105d,0x726ca189,0x4ceec16b,0x00000000}},	//   _apprendi, _ambos_, _америку_, --, 
   {{0x0526e012,0x8681a0cf,0x12f0506a,0x0f7541f2}},	//   _carrinho_, _जयराम_, _bilioni_, _interés_, 
   {{0x7cc511ab,0xa2c9c0b8,0x21638035,0xd49af255}},	//   _اریکسون_, _hotlink_, _円以上ご注文頂き, _ditawark, 
   {{0xb27ef0a6,0x92f0422c,0x98f420dd,0x00000000}},	//   _bringt_, _delitti_, _академиј, --, 
   {{0x8c7cb2ff,0x527f42c7,0x63add1eb,0x62d82017}},	//   _tekstin_, _fuente_, _ырбадыбы_, _takes_, 
   {{0x92d9c236,0x75f3a16b,0x2e30c162,0x6758e329}},	//   _livet_, _довести_, _panggina, _सदस्यीय_, 
   {{0x9b32e035,0xc0c1d204,0x420271b9,0x65972072}},	// [900] _ジの先頭へ_, _основе_, _varias_, _бардыгы_, 
   {{0xcc73c0dc,0xee0ba006,0x9637f005,0x3847f1ad}},	//   _prosesa_, _שליטה_, _reklamow, _reklamod, 
   {{0x82927033,0xf22470ba,0xf200c05d,0x43eb91e8}},	//   _desain_, _benki_, _validi_, _gosto_, 
   {{0x148502fb,0x552a00b9,0xb8524151,0xfc08e006}},	//   _स्नातक_, _sitiyasy, _中文科技期刊数据, _involved_, 
   {{0xee91604d,0xb2902060,0xce6a2195,0x82b312b0}},	//   _histoire_, _nemaze_, _дојде_, _meadhan_, 
   {{0xe3add171,0x584d2182,0x9b8020af,0x8319c045}},	//   _tāpat_, _sistemos_, _diforomo_, _إيران_, 
   {{0x12f0c06a,0xd39490ce,0xffeda0e6,0x127f436a}},	//   _hadithi_, _measa_, _ग्राफिक_, _siendo_, 
   {{0x23eb5004,0x82ca7008,0xc3949045,0x6300928e}},	//   _vietos_, _rinda_, _leasa_, _separuh_, 
   {{0xf460f065,0xf201c1b4,0x627f730c,0x940f91ca}},	//   _berendez, _davie_, _afande_, _идеалы_, 
   {{0x56aee035,0x03eb0255,0x63f47243,0x8dc380c3}},	//   _ジのトップへ_, _diatas_, _curtir_, _מארטש_, 
   {{0x6307b03b,0x6ad7320d,0xfaf570b7,0x9ebfc305}},	//   _komandi_, _postitat, _moroccan_, _अनुक्रमण, 
   {{0x225ad25f,0x53f84004,0x12d84017,0xc8de826d}},	//   _fyller_, _namus_, _names_, _विस्फोटक_, 
   {{0xe212b0cb,0xd2ca701b,0x10f3b016,0xe8563108}},	//   _suche_, _winda_, _באזוך_, _загуби_, 
   {{0xe3eb80b2,0xe847a05f,0xdf392094,0xcbdd62a1}},	//   _morts_, _اللواء_, _меёбад_, _धनिया_, 
   {{0x122b82c7,0x487d804c,0x5458d01a,0x10581168}},	//   _siempre_, _комемора, _кеңінен_, _escalato, 
   {{0x3faa4075,0x02c660f5,0x73eb81c6,0xf875e03c}},	//   _পড়াশোনা_, _kasmoos_, _forts_, _pluspris_, 
   {{0x427ef273,0xe2e09119,0x42d82167,0xade740c8}},	// [910] _opinii_, _profiili_, _saker_, _부동산써브의_, 
   {{0x022471ee,0x820181b1,0xbf0b909f,0x30da5043}},	//   _senki_, _saria_, _premijer_, _запитанн, 
   {{0x22d90270,0xc273a28e,0x0fbc7261,0x4c6d201c}},	//   _videó_, _peribadi_, _englesko, _putujem_, 
   {{0x06368351,0x06c7301e,0x22f2c1ef,0xb2504207}},	//   _vikipedi, _고객님께서_, _уклад_, _पायेंग_, 
   {{0x16368351,0x87e620e6,0xb83f6096,0x653680b9}},	//   _wikipedi, _अवार्ड_, _después_, _wikipedy, 
   {{0x12009011,0xbeb6302a,0xa47530e0,0xd4960072}},	//   _phais_, _системе_, _disertak, _сүйүү_, 
   {{0xa4651232,0x0b09c084,0x47a7304d,0x1e5361c5}},	//   _integraz, _миллионд, _partenai, _inscrire_, 
   {{0x2201a0c2,0xd2d84006,0xb3dc1159,0x3399a008}},	//   _supir_, _james_, _plhws_, _bojxona_, 
   {{0xe2fca052,0xd9aac043,0x724a7045,0xa2918121}},	//   _skrivet_, _годин_, _chumas_, _jaran_, 
   {{0xb783423c,0x7e76f187,0x429180a6,0x325a22a0}},	//   _धारावाहि, _klikněte_, _daran_, _mikla_, 
   {{0xae19e1d6,0xd25a52cf,0xc84c11c5,0x897541e7}},	//   _selengka, _cille_, _certains_, _dienstle, 
   {{0xe293a006,0xf380620d,0x4bded28d,0x33ea9030}},	//   _מאוחר_, _korral_, _amadekir, _piata_, 
   {{0x1b669121,0x02018225,0x13f820a3,0xf2caa002}},	//   _دبیرستان_, _narin_, _nakup_, _विचारणीय_, 
   {{0x93ea912f,0x320e1079,0x00000000,0x00000000}},	//   _viata_, _натал_, --, --, 
   {{0xb290711b,0xd2909110,0xbc1d21e6,0x6383b1db}},	//   _aynan_, _makani_, _kitaplar, _abayite_, 
   {{0x22d8b304,0x6c34f030,0x8a53507d,0x55a71191}},	//   _madeya_, _descoper, _сертифік, _شکنجه_, 
   {{0x329182f1,0x73870052,0xc29190f2,0x02b5f102}},	// [920] _caran_, _klarar_, _lasan_, _discutii_, 
   {{0x92b650b9,0x038aa075,0xb2925023,0x6ece9151}},	//   _touche_, _আক্রান্ত_, _mitasi_, _上海联放贸易有限, 
   {{0xf615a016,0xee29b035,0x43f9e1e3,0xac5bf27b}},	//   _מוצאי_, _ジャンルランキン, _ditut_, _listesi_, 
   {{0xb290c2ba,0x82018003,0x92dab022,0x70daf024}},	//   _nalazi_, _farin_, _fotolar_, _कटरीना_, 
   {{0xb201917e,0x729181fd,0x59d0a07a,0x02ca529c}},	//   _assim_, _garan_, _advertee, _wilde_, 
   {{0x18963127,0xb9d22184,0x22926257,0xf25a50d2}},	//   _мактаб_, _inregist, _burada_, _tille_, 
   {{0xc807a155,0xdd7a8075,0x2202720a,0x8291f199}},	//   _מתאים_, _ব্রিটিশ_, _varios_, _zuzana_, 
   {{0x8a80d317,0x8d86b1c6,0xf290d262,0x39f4d0b0}},	//   _tehotens, _entendre_, _shean_, _ngoãn_, 
   {{0x72a7b065,0x2c4a2024,0xa26c4300,0x2f6690b4}},	//   _évben_, _योजनाओं_, _momod_, _dikandun, 
   {{0x1212b110,0x32924029,0x1c09c01a,0xc5d3d06b}},	//   _kucha_, _kuwaza_, _минералд, _елемента_, 
   {{0xa29080ba,0x0f540151,0x72918254,0x82d88138}},	//   _mahali_, _建设项目环境影响, _waran_, _vbhelp_, 
   {{0xf6dd715e,0xc291f02a,0x965dd008,0x12ba71c4}},	//   _नीतिश_, _ostaa_, _мобайнид, _mondani_, 
   {{0x5200b0af,0x978d22f6,0x191320e2,0xa201910e}},	//   _modimo_, _бисёр_, _pembangu, _hasin_, 
   {{0x63833062,0xf15c2127,0xa200e05b,0x22e95115}},	//   _자유게시판_, _сурат_, _geniet_, _hadirin_, 
   {{0xf8af4220,0xd201a2ff,0x00000000,0x00000000}},	//   _استطاعت_, _lapin_, --, --, 
   {{0x2201812e,0x02918193,0x93957089,0x5340e0db}},	//   _parin_, _paran_, _opasno_, _gelesen_, 
   {{0xc2025039,0xe25a526f,0x6cb37086,0x92b53029}},	// [930] _attila_, _sille_, _jumatatu_, _mundime_, 
   {{0xb2b501cb,0x4b2570f6,0xb50c7113,0xa2ca717e}},	//   _produse_, _uniberts, _febreiro_, _vindo_, 
   {{0xa52bb1fe,0xc455025d,0x02a74381,0x02a2a138}},	//   _munyakaz, _producto_, _trebao_, _بمنطقة_, 
   {{0xa291a033,0x29a3b0c9,0xc201a0b7,0x498b513a}},	//   _kapan_, _setjhaba_, _kapin_, _preču_, 
   {{0x99e21244,0x13f400f6,0x7bdfc0f7,0x927ee21a}},	//   _कट्टा_, _laster_, _modeller, _venner_, 
   {{0xfb14c108,0xc29161a5,0x426c5065,0x1201f095}},	//   _избор_, _nagara_, _dolog_, _saziva_, 
   {{0x8291902d,0x5d07b075,0x0378a0fe,0x8394f301}},	//   _xasan_, _সমাজের_, _makanan_, _priser_, 
   {{0x926c22e0,0x8320924e,0x227fb1b5,0xd2d850c2}},	//   _tokom_, _nyayo_, _оставили_, _kaler_, 
   {{0xeea210cc,0x42d9c1cb,0x327ed0d2,0xa3040070}},	//   _assurant_, _анений_, _gjeni_, _kedalam_, 
   {{0x93f8c140,0xb7ea4122,0x0a6f0092,0x4ecda0e5}},	//   _usluga_, _бойгонии_, _véčka_, _komisjon, 
   {{0x32483105,0x637f6019,0xaae7c052,0x00000000}},	//   _kommet_, _избранно, _styrelse, --, 
   {{0x1d5d900e,0xac620132,0x324800ec,0xc2d8f0a9}},	//   _популярн, _turunan_, _acima_, _kaget_, 
   {{0x9c0c80c8,0x26a5d22c,0x09ca3151,0x9cb5c04c}},	//   _무이자할부_, _konformi, _国家环境保护总局_, _афаче_, 
   {{0xedc3a0c3,0x8a4a41b4,0x144120a1,0x40f3a016}},	//   _דריקט_, _rhodesia_, _бұндай_, _דאטום_, 
   {{0xf2b4d26e,0x0d26f01a,0x87410151,0x82fcd12f}},	//   _trochu_, _деректер_, _政治交接学习教育, _alege_, 
   {{0xf386e0ce,0xf13e3210,0x522c00c3,0xcb8b827c}},	//   _foirne_, _колониал, _פלעצער_, _familjar, 
   {{0xd3a2c048,0x6bcba071,0x2af761c7,0x5d8df1d7}},	// [940] _hampir_, _पंजीकृत_, _zasebnos, _autobusa, 
   {{0xa4d79004,0x3c5b8095,0x00000000,0x00000000}},	//   _канады_, _sastoji_, --, --, 
   {{0xf3949006,0x02d96017,0x5b1db0c8,0x0dcad1eb}},	//   _least_, _safety_, _세계적으로_, _июлда_, 
   {{0x8291a0a7,0x2d74824a,0x52009022,0xa201809d}},	//   _yapan_, _авторизу, _sakini_, _wario_, 
   {{0x152e0006,0x9290d0de,0xc200b086,0x1a07d28d}},	//   _לונדון_, _senare_, _madini_, _alfabeya_, 
   {{0x13a240f4,0x35739152,0x42fa303a,0x13423034}},	//   _kumpi_, _педагога, _kuchnia_, _accesso_, 
   {{0x7d2c3034,0xd38601de,0xdcdf9069,0x147720e6}},	//   _списък_, _amire_, _negatív_, _अग्नी_, 
   {{0x02ca704c,0x5ddc2069,0x43ea708c,0x7daa2033}},	//   _vinde_, _حلقوں_, _vinte_, _pariwisa, 
   {{0xa3940221,0x7340028d,0x98d4e0e2,0x3b60f08b}},	//   _ceist_, _mebesta_, _kekurang, _permettr, 
   {{0x5fed202f,0x92c8a0e3,0x52cb8023,0x63b4b1ad}},	//   _百度知道投诉吧_, _aproape_, _bordi_, _atrakcyj, 
   {{0xd26c309f,0x04c071f3,0xba207344,0xa3eb50ab}},	//   _kojoj_, _públicos_, _públicas_, _lietas_, 
   {{0xc2d8706f,0xb596001e,0x4c1d200b,0x537f31ac}},	//   _hanes_, _클릭하세요_, _intambar, _kumanda_, 
   {{0x1fc3804d,0x026e111e,0xb2e74095,0x7f653382}},	//   _modifier_, _repons_, _davnina_, _रामचन्द्, 
   {{0x67134227,0x62924128,0xa378e0b4,0x6e3cd010}},	//   _сексуалн, _kawawa_, _kalayan_, _اشتون_, 
   {{0xed1c80cc,0xf2df1056,0x53f98297,0xc29190df}},	//   _follicle_, _whining_, _virut_, _masam_, 
   {{0xe25a9109,0x2291f2d3,0x15a72383,0x4708a006}},	//   _ciall_, _rutas_, _झपकते_, _ומולטימד, 
   {{0x325a5052,0x8212c063,0xa344b032,0xf201814c}},	// [950] _lilla_, _nplhab_, _firenze_, _varie_, 
   {{0x4200b384,0x33a2d121,0xbb88e0a6,0x02f3f072}},	//   _ledige_, _tropis_, _aktivier, _dedicat_, 
   {{0xa71cc136,0xb395705d,0x73ebf323,0x404400b8}},	//   _पारदर्शी_, _chased_, _flutt_, _rattlesn, 
   {{0xf9fb10ee,0x327ef21c,0xa2d430ef,0x82b5112f}},	//   _digitala_, _seiner_, _tailieu_, _vandute_, 
   {{0xaa761142,0xda0950b4,0x12919195,0x0f20f13b}},	//   _नवीनतम_, _sadayana_, _casal_, _beruruta, 
   {{0x82918065,0xa224f09c,0xe13bc2dc,0x927f50f1}},	//   _darab_, _suiker_, _modhnóir_, _brengt_, 
   {{0xe486f15e,0xc1488373,0x6b98d03f,0xd0e3b0eb}},	//   _भिखारी_, _टाइपराइट, _प्युठान_, _протесту_, 
   {{0x4439917e,0x347ec1dc,0xd2fc1155,0x8292407f}},	//   _програма, _никоҳ_, _actually_, _iswara_, 
   {{0xf611c1ee,0xc683c20d,0x07b01006,0x11dd3092}},	//   _probléma_, _रूमाल_, _המלחמה_, _aplikací_, 
   {{0x92e95070,0xe169209d,0x77c8c2a2,0x0c6060fd}},	//   _artinya_, _presenno, _poisteni, _kartais_, 
   {{0x43614174,0x98d7e126,0x75a2d009,0xf6b9a087}},	//   _lingvoj_, _сармоя_, _bersangk, _nekateri, 
   {{0xca16826e,0x1224f11e,0x6394006a,0x629180c9}},	//   _osobnost, _efikas_, _afisa_, _barab_, 
   {{0x8d42d19c,0x48471034,0xd3a69042,0x61d7c023}},	//   _інформац, _заради_, _máxima_, _навоий_, 
   {{0x18d2c17a,0x125a5116,0xcdee50b8,0x5b9f614f}},	//   _sobreviv, _billi_, _bridgewa, _शंभुनाथ_, 
   {{0x7c0ba0f4,0x327f417a,0x31d420c3,0xc27f71b7}},	//   _amalungu_, _frente_, _אראבישע_, _bianco_, 
   {{0xf0ddf235,0x92905176,0x727eb02f,0xdc75a01c}},	//   _branitel, _aklat_, _agence_, _opasnog_, 
   {{0xac0730cc,0x0477a195,0x72d9b022,0x51b3c1de}},	// [960] _northeas, _проекти_, _avtobus_, _وائرس_, 
   {{0xcaaa400e,0x326c20e0,0xa2908135,0xe8fb80f6}},	//   _компании_, _pokok_, _wahabi_, _hamarkad, 
   {{0xb20061e4,0xe9d17044,0xf290e12e,0x8290b168}},	//   _chois_, _ieithoed, _pinaka_, _madali_, 
   {{0xf26c100e,0xa29260b2,0x7a6b61dc,0xd21290c2}},	//   _johon_, _agrada_, _innovats, _iraha_, 
   {{0xbd9d916a,0x79754086,0x13e831d7,0x43874153}},	//   _महत्त्वप, _maendele, _голубева_, _acerca_, 
   {{0xb3ead067,0x227ed1d9,0x8be740e5,0x43ead23e}},	//   _vieta_, _tional_, _kategoor, _inetu_, 
   {{0xe378002d,0x884150f5,0xa201f09b,0x98c55033}},	//   _albatta_, _callixtu, _kutip_, _जवळपास_, 
   {{0x9b65b11a,0x4b5ed280,0xf977b232,0x4845b0d1}},	//   _utilizar, _храни_, _indirett, _utilizad, 
   {{0xe6818071,0x139501c1,0xe35850ef,0x084e505f}},	//   _करनाल_, _vlasti_, _webgame_, _لأجهزة_, 
   {{0x63ea91ac,0x1c6061ea,0x95dbc01e,0x00000000}},	//   _inati_, _distans_, _마지막으로_, --, 
   {{0xfee6e168,0x582f5385,0x6290c318,0x327ea09f}},	//   _machinin, _skomentu, _aydan_, _radnog_, 
   {{0xc527e0c1,0x32926276,0xde55c0dc,0x585dd0e5}},	//   _potrudio_, _zgrada_, _absalome_, _teenistu, 
   {{0x6900b050,0xb623e008,0x00000000,0x00000000}},	//   _अतिरिक्त, _бордир_, --, --, 
   {{0xc2da51a7,0xd291d2e4,0x5395022c,0xd2ca5050}},	//   _isteri_, _kawan_, _klassi_, _pildi_, 
   {{0x1ecda0a7,0x02f71092,0xdf6e108e,0x252d0034}},	//   _gerektiğ, _novinek_, _יוליוס_, _composto_, 
   {{0xd201913b,0x42d800cb,0x1d7a7194,0xbaee114e}},	//   _arsip_, _spiel_, _kommende_, _rendesis, 
   {{0x23ea72ff,0xe2ca7050,0x0b11a05f,0x14858386}},	// [970] _hinta_, _hinda_, _cásanna_, _विनाशक_, 
   {{0xbdc39387,0xdaba5098,0x8d1181e9,0xbaa6e1db}},	//   _terimaka, _компаний_, _юстиції_, _abayonka_, 
   {{0x95e0d106,0xc25a9026,0x24d01006,0x2b7081f9}},	//   _literatú, _anali_, _במקביל_, _nitranga_, 
   {{0x43f9903d,0x32ca71a7,0xe2e171b0,0x02d9932b}},	//   _visus_, _minda_, _velikog_, _vises_, 
   {{0xb39661d7,0xc224f2fe,0x2e398063,0xcebac076}},	//   _sausio_, _funkar_, _vivncaus_, _топло_, 
   {{0x23f461c5,0x68968072,0xe238703b,0x0201e1d2}},	//   _partie_, _максат_, _heimili_, _matin_, 
   {{0x52ff50d2,0xc2786023,0xc5adc355,0x722e00b3}},	//   _arritur_, _chunki_, _बनाता_, _pravidel, 
   {{0x224b6267,0x0a17e132,0x4290c0f2,0x326c8164}},	//   _popolari_, _disangka_, _mamaly_, _tokova_, 
   {{0x62ca71b8,0x13fc603c,0xc9f661de,0xd68e7388}},	//   _ainda_, _リクエスチョン_, _során_, _proffesi, 
   {{0xa2da6010,0xe3f15037,0x7b815084,0x3249009b}},	//   _dereng_, _associaz, _associac, _slamet_, 
   {{0x52d8a215,0x53eb00f3,0xce27e079,0x9b1ff0b4}},	//   _haber_, _pratik_, _презент_, _priangan_, 
   {{0xd14a703e,0xe201e0cc,0xa29b0100,0x13f9a1c6}},	//   _kostenlo, _katin_, _ekspertl, _tipus_, 
   {{0xfabdf05e,0xf3ead171,0x12cad087,0x356010c8}},	//   _pinjaman_, _lieto_, _spodaj_, _사람입니다_, 
   {{0x42129251,0x0c06e0fa,0xdefdd034,0xc2009247}},	//   _praha_, _potreby_, _политиче, _khais_, 
   {{0x32cbf313,0x2e52522f,0x53738124,0xd290e1a6}},	//   _soudu_, _dijadika, _izdanje_, _kanani_, 
   {{0xda326136,0x7fa4c069,0x7cf2c065,0x03eb82a0}},	//   _फर्जी_, _ٹوئٹر_, _فاطمہ_, _flytja_, 
   {{0xce14a137,0x1201e12e,0x842c524c,0xd41c51ad}},	// [980] _zamestna, _natin_, _technick, _technicz, 
   {{0x53a381f9,0x02ca7081,0x92ebd161,0x0c0440ff}},	//   _egypta_, _bindi_, _muintir_, _prosesi_, 
   {{0xb201e049,0xf2d99236,0xb26d816d,0x8dfbe0ef}},	//   _hatin_, _viser_, _evrov_, _nukeviet_, 
   {{0x9766a0c8,0xe2008086,0x79e820b3,0xf89aa1de}},	//   _마찬가지로_, _sahihi_, _dobrodru, _سرفراز_, 
   {{0x90479314,0x7569108f,0xf26c7123,0xf290c1ae}},	//   _миллат_, _настройк, _honom_, _hamaly_, 
   {{0xe95980b1,0x7e03c17c,0x64b5c023,0xf8dc22f6}},	//   _сўмининг_, _чемпионд, _kasallik, _шурик_, 
   {{0xd2d9a08b,0x2b7a3008,0x98dbf12f,0x1201e0f2}},	//   _favoris_, _миллионл, _dimensiu, _matio_, 
   {{0x03a240c9,0xa58830fa,0xa2016062,0xb25a811d}},	//   _hampe_, _popradsk, _begint_, _daklak_, 
   {{0x82d67162,0x2758d0e6,0x82ca7081,0xec051069}},	//   _mitogen_, _मुस्ताङ_, _zindi_, _گناہوں_, 
   {{0xd26e1084,0x02b3706d,0x2394d2f8,0x0c751389}},	//   _suport_, _serdana_, _meest_, _रात्रि_, 
   {{0xa962d02f,0x42e8e052,0x5650b02f,0x12ca7316}},	//   _商务部网站版权与, _polisen_, _胶南市教育体育局_, _cindi_, 
   {{0xa2d830d2,0xcc6a307b,0x9340e01e,0x3147d126}},	//   _koment_, _odvtedy_, _gelegen_, _заминаи_, 
   {{0x920250f4,0x83eae032,0xd290e06f,0x725af1a9}},	//   _mutima_, _contro_, _gyfan_, _idhlig_, 
   {{0x7291e15d,0x32d8b337,0x830311a9,0xc9e2f2e3}},	//   _vatan_, _facer_, _malairt_, _portefeu, 
   {{0x0d8680b2,0x527332da,0xa2d6320d,0x2b30c030}},	//   _novembre_, _många_, _selleks_, _зенон_, 
   {{0x020061c5,0xa290c110,0x33f4602a,0x0d2e90f8}},	//   _choix_, _saladi_, _kertoa_, _সারাদিন_, 
   {{0x7611c0b3,0xd40531ff,0x9394e285,0x2031628e}},	// [990] _problémy_, _आनंदित_, _avisen_, _serentak_, 
   {{0xb2ca50f6,0x616e3075,0xfee0400c,0xcee4d034}},	//   _bildu_, _গাইবান্ধ, _चित्रकला, _чувства_, 
   {{0xc3eb70b4,0xa25b701f,0xfa45c0fb,0x937570f8}},	//   _alatan_, _alalan_, _finestra_, _ফায়ারফক্, 
   {{0x737301c5,0xfe6841e8,0x213da05c,0xbf63004d}},	//   _semaine_, _дискусиј, _спортист, _semaines_, 
   {{0xecdf302f,0x62fc906c,0x22786304,0xdbf0e1ad}},	//   _欢迎批评指正_, _slags_, _mpunga_, _internec, 
   {{0x73ead197,0xc342b18f,0x99cd10a4,0x5c5510b9}},	//   _tieto_, _भुजंग_, _myndighe, _kantite_, 
   {{0xe49cc0fd,0xe202038a,0xe91320e2,0xb292706a}},	//   _плане_, _disini_, _membangu, _miradi_, 
   {{0xc8b8938b,0xbc7f4151,0x437f809a,0x00000000}},	//   _кэутаре_, _返回黑龙江主站_, _muhanda_, --, 
   {{0x91c33106,0x925ad2d1,0x00000000,0x00000000}},	//   _autorské_, _ciele_, --, --, 
   {{0xf3eae193,0xc47ec094,0x2eb4d087,0x72ebd188}},	//   _kontan_, _ҷиноӣ_, _samodejn, _bizness_, 
   {{0x3da3c004,0x32d8c1c6,0xdd37a019,0x6637217f}},	//   _nemokama, _dades_, _бизнеса_, _татиана_, 
   {{0x1ed10031,0x0378e12e,0xbf24019b,0x7265309e}},	//   _reunidos_, _malaman_, _višak_, _yerusaal, 
   {{0xd249f110,0xac7581ff,0xb25a9247,0xa1c17097}},	//   _chuma_, _सदस्या_, _ciali_, _terendah_, 
   {{0xd3a8211a,0x0f9bd0a1,0xd60390c7,0x159531ed}},	//   _privind_, _авиация_, _bələdiyy, _klassisk, 
   {{0xc9aa1126,0x42d9917e,0x5e36c133,0x3d04c191}},	//   _хориҷ_, _esses_, _upravova, _توجهی_, 
   {{0xf6b36118,0x825ad027,0x698180ce,0xc619615d}},	//   _pristaty, _biele_, _sibhialt, _ҳамжамия, 
   {{0xab9280a7,0x98c5327b,0x27b49255,0x28bfe1b9}},	// [9a0] _ingilizc, _referand, _kemenang, _enfermed, 
   {{0xb27e0155,0x91cae0b5,0xf3ead148,0xef4a2017}},	//   _being_, _parašė_, _viete_, _זכוכית_, 
   {{0x83f45168,0x6683138c,0xbf2fc053,0x024df38d}},	//   _rattle_, _ब्याज_, _kewujuda, _मनाला_, 
   {{0x6f594104,0x00000000,0x00000000,0x00000000}},	//   _hlýtur_, --, --, --, 
   {{0x3f6b206b,0x93ea00b9,0x4efb214c,0xd291e0b7}},	//   _стране_, _chita_, _страни_, _matam_, 
   {{0x027f70b9,0xcbb271cb,0xebdc70c8,0x3ddee035}},	//   _franse_, _респекту, _한국과학기술연구, _昭和つっても幅広, 
   {{0x024991bc,0x48692210,0x426de1c7,0xfad5912f}},	//   _rasmi_, _бээжин_, _avtor_, _cantitat, 
   {{0x91f53289,0x12e16071,0x1b6a912a,0xe26c10b0}},	//   _имате_, _दसवीं_, _статия_, _sohot_, 
   {{0xeda811da,0xaef7f12a,0xef142017,0x67f82045}},	//   _donostia, _фирмата_, _לרישיון_, _لبرنامج_, 
   {{0x425cc060,0x02ca70ee,0x927860fe,0x1e3831e1}},	//   _siyasetê_, _findu_, _ibunya_, _rangkaia, 
   {{0x430f6222,0xcad200c8,0x19f6b199,0x1eac2145}},	//   _berbera_, _도와주세요_, _ustanove, _postupne_, 
   {{0x0202613b,0xc4851142,0xb295c116,0xe2a6d38e}},	//   _harita_, _विधायक_, _dipartim, _osobno_, 
   {{0x826e6334,0x927860ff,0xec914244,0x9c68e19a}},	//   _retour_, _olundu_, _श्लोक_, _barulah_, 
   {{0x93ea7263,0x12d45106,0xeff11123,0xfe75728d}},	//   _kintu_, _ľudia_, _miljoner_, _kêmasî_, 
   {{0x7292517e,0x5a00e05e,0x0f17236d,0xd20271c1}},	//   _estava_, _kitabnya_, _ciudadan, _desilo_, 
   {{0x9fc0d004,0xffdd305f,0x82b49138,0x725ad030}},	//   _literatū, _العبد_, _dtaca_, _piele_, 
   {{0xddcb3010,0x00000000,0x00000000,0x00000000}},	// [9b0] _اثبات_, --, --, --, 
   {{0x427e02aa,0xbcf530a2,0x90b5202e,0xdd87a38f}},	//   _meine_, _लोककला_, _दुगुना_, _objednat_, 
   {{0xa4a90079,0x12fcf286,0x22d9e13e,0x0386614c}},	//   _протекци, _logga_, _vitet_, _amore_, 
   {{0xaaf7c302,0x0bf0d092,0xae72f0e5,0x1dfc01c9}},	//   _майдон_, _mistrovs, _शुद्र_, _cludiant_, 
   {{0x02016255,0x026ca13d,0xd0612033,0x0affe07b}},	//   _begitu_, _pobol_, _धाडसी_, _nepríjem, 
   {{0x6f24019b,0x9255c1f7,0x03ea71bf,0x29d5a29d}},	//   _nešto_, _विशेषः_, _bintu_, _cantidad, 
   {{0x12f2f0ff,0x82e18268,0x994ce038,0x3651318b}},	//   _radiosu_, _जागीर_, _automjet, _गोंधळ_, 
   {{0x42d980a9,0x92369087,0x76091008,0x1d4e81aa}},	//   _maret_, _imajo_, _zamonavi, _gunbound_, 
   {{0x8ed9f004,0x3b11414f,0x00000000,0x00000000}},	//   _aplinkos_, _पाखण्ड_, --, --, 
   {{0xe4dac0bd,0x42d8c183,0xa3ebf006,0x0c574095}},	//   _можна_, _vader_, _south_, _nestaje_, 
   {{0x726e0290,0x72014038,0xf0ed7093,0xa98b409f}},	//   _lepota_, _mediat_, _логиныңы, _treće_, 
   {{0x61633114,0xd7928076,0xb3eb826e,0xb3188225}},	//   _бутун_, _интересу, _dorty_, _ganitong_, 
   {{0xcaeeb0de,0x4345108b,0x821ba0b3,0x39af4206}},	//   _fastighe, _américai, _virtuáln, _eindhove, 
   {{0xce0cc03c,0x12f3a216,0x00000000,0x00000000}},	//   _ドを入力してくだ, _beginnt_, --, --, 
   {{0x7b9e40f3,0x29f9b023,0x25d7009d,0x27b84187}},	//   _prezidan_, _видеолав, _dosbarth, _položek_, 
   {{0x227e00cb,0x82c74010,0x32578039,0xe2d8c128}},	//   _keine_, _ادارات_, _nálam_, _pader_, 
   {{0xd3c72148,0x438661da,0x134bc082,0x5344a12d}},	// [9c0] _hospodár, _umore_, _birkaç_, _ourense_, 
   {{0xf201c0fb,0x127f7026,0x2758e024,0xa22491fa}},	//   _havia_, _nyanja_, _मुद्दों_, _ttaka_, 
   {{0x137a80c4,0x23f980b4,0x42930322,0x215f20b1}},	//   _allanol_, _garut_, _sporočil_, _ядровий_, 
   {{0x7469507d,0xfb823007,0xf047202a,0xf1b42146}},	//   _християн, _umanitar, _часовой_, _promossi_, 
   {{0x12db409f,0x42352166,0x426ca089,0x63f901b4}},	//   _kasnije_, _evidenti_, _sobom_, _kabula_, 
   {{0x326c5115,0x0200c0c4,0xb25b9390,0xf80da16b}},	//   _nolol_, _miliwn_, _misle_, _командов, 
   {{0x8291f026,0xc0a2e191,0x00000000,0x00000000}},	//   _kuzama_, _تماشای_, --, --, 
   {{0xf291f084,0xe26d9026,0xadf6907d,0x9aa590e6}},	//   _estan_, _elson_, _ресурсів_, _विक्रेता_, 
   {{0x23f9e0d2,0x42d9815c,0x0fb61137,0x9291f050}},	//   _ditur_, _darem_, _zosilňov, _ostan_, 
   {{0xa26c51f9,0x337c9150,0xe291119c,0xa99d21eb}},	//   _solon_, _detalye_, _debatt_, _качып_, 
   {{0xf96d60a1,0x6d20c126,0x56965068,0x1c5a6166}},	//   _кішкента, _устувор_, _adresini, _evitati_, 
   {{0x4316d381,0x874c026f,0x00000000,0x00000000}},	//   _trebali_, _растения_, --, --, 
   {{0xa386d004,0x3997e122,0x12375116,0x3a96600c}},	//   _sporto_, _марбут_, _plejer_, _उम्मेद_, 
   {{0x28dcd11b,0x015c20fb,0xef4e20dd,0xba83b29c}},	//   _мужик_, _турат_, _политичк, _beginnen_, 
   {{0x23f9e1d6,0xe2d9e391,0xbf8752c6,0x03f1205f}},	//   _situs_, _sites_, _mašine_, _فضفضة_, 
   {{0x5bc2701e,0x020dc015,0xb1dee199,0xb9fd0069}},	//   _크게보기를_, _спомен_, _schránky_, _javaslat, 
   {{0x647ec126,0x0c2a602b,0xfe5631f1,0x12fc61b5}},	// [9d0] _симои_, _vlastnos, _частини_, _ulogu_, 
   {{0x5290d26c,0x28392034,0x2225805b,0x333f9017}},	//   _theas_, _последна_, _werke_, _המסחר_, 
   {{0x63f8f1e0,0x77185019,0x5205a116,0x42bca0f3}},	//   _bagus_, _контакты_, _marittim, _mondyal_, 
   {{0xe3f02007,0x425ad145,0x8a93c1c6,0x63f991a7}},	//   _informaz, _biela_, _бойдон_, _kasut_, 
   {{0x0a989090,0x943ed0c8,0x5d82a1b5,0x5290c225}},	//   _luxusní_, _광주광역시_, _najčešće_, _kulang_, 
   {{0x72a700dc,0xc3ea5078,0x7c01c1a6,0x3603d02a}},	//   _ribbed_, _kilti_, _vengador, _картинку_, 
   {{0xb316918a,0x9e922195,0xf0aab392,0x72369049}},	//   _amaze_, _форумот_, _lasmuigh_, _amaje_, 
   {{0x227e6003,0x12d9f148,0xad9ac037,0x2f2fb0f5}},	//   _svona_, _kvality_, _статии_, _nestoria, 
   {{0xc48072db,0x62d9800c,0x02cae07a,0xc41cc004}},	//   _बहराइच_, _varem_, _londen_, _meninink, 
   {{0xa291f095,0x926c4170,0xa2acf0b2,0xb3f9821c}},	//   _ostao_, _nomor_, _барактар_, _warum_, 
   {{0x7e713393,0xb2efb28f,0x3c6b81da,0x37540329}},	//   _चित्र_, _þeirra_, _elementu_, _पारिवारि, 
   {{0x826cc089,0xf2554394,0x73f8f2a0,0xa2d9a18b}},	//   _vodom_, _विधेयक_, _dagur_, _dapet_, 
   {{0xbe72f136,0x96374002,0x3e3d20f8,0xecc6e148}},	//   _शीघ्र_, _politsei, _দুইটা_, _dobierku_, 
   {{0x737892e4,0x1317001c,0x123c2062,0x5b0301c7}},	//   _fahaman_, _stazom_, _normaal_, _priprava_, 
   {{0xbecf4110,0x7f2521d2,0xf3435201,0xe906e277}},	//   _strikers_, _utiliser_, _diseño_, _forbered, 
   {{0xd11fa155,0xc394904a,0x6dd2d072,0xf3f46030}},	//   _למצוא_, _yeast_, _стили_, _martie_, 
   {{0x12fd017a,0xc39401ec,0xb2cae119,0x00000000}},	// [9e0] _nocivas_, _ofisi_, _joiden_, --, 
   {{0xa39481e5,0xc2fc6256,0x726e6027,0x326cc01f}},	//   _langkung_, _blogs_, _istotu_, _demony_, 
   {{0xf5442044,0x29ec9116,0xa291f0ee,0x3cd48092}},	//   _gwahanol_, _attivita_, _bazara_, _uskutečn, 
   {{0xa3ebf055,0xe3940026,0x4aeb9204,0xb1d331c6}},	//   _foutu_, _afisi_, _kokonaan_, _тыюуу_, 
   {{0xa3192150,0xc2cae01e,0x00000000,0x00000000}},	//   _kabilang_, _honden_, --, --, 
   {{0x1303c0db,0x62efd0ba,0x00000000,0x00000000}},	//   _bekannt_, _kulinda_, --, --, 
   {{0xe212b0b9,0x02d980e5,0xb91e1106,0x31f240f5}},	//   _mache_, _parem_, _trenčín_, _luangnam, 
   {{0xc84d20b3,0x71c48151,0xf308716f,0x00000000}},	//   _naposled, _人在草木中_, _klubben_, --, 
   {{0x7e186166,0xa22f8006,0xa9dfa075,0x6e96135e}},	//   _irregola, _וליטוגרפ, _উপযুক্ত_, _акциунил, 
   {{0xedd2d23d,0xeb72d14c,0x43788350,0x520c82dc}},	//   _стала_, _стана_, _sanajan_, _dóigh_, 
   {{0x93044087,0x4305326e,0x587ba017,0x229150ef}},	//   _pozabil_, _obrazem_, _הלבשה_, _gofarm_, 
   {{0x52e920f6,0xc10281be,0x25982039,0x7aa41047}},	//   _hainbat_, _प्रश्_, _impressz, _जुर्माना_, 
   {{0xf26c4395,0x92d980b4,0x3cee208f,0x00000000}},	//   _somos_, _karek_, _груди_, --, 
   {{0xa4ba001e,0x1ff10136,0x4979f00f,0xaf6d50c6}},	//   _중국국제전화카드_, _तेलंगाना_, _gymnasie, _insbeson, 
   {{0xc20080a2,0x84fa9279,0x43866078,0x8365b024}},	//   _arhiiv_, _गंगाधर_, _amori_, _मुरैना_, 
   {{0x5997736e,0x702e2037,0xec932039,0xf84001e9}},	//   _प्रशिक्ष, _condizio, _تاوان_, _справедл, 
   {{0x31ab7034,0x4bcb7034,0xf200d008,0x6212b055}},	// [9f0] _commenti_, _commento_, _buning_, _fache_, 
   {{0x0a07419e,0xf2d8f13b,0x6f32501f,0x7a989034}},	//   _tilantee, _pager_, _ahafahan, _натиснет, 
   {{0x22918068,0x4f9e112a,0x9af050af,0x00000000}},	//   _biraz_, _родители, _ahisanwe, --, 
   {{0x475a308b,0xab87d1d5,0xe9673011,0x025ac168}},	//   _非煤矿生产许可证_, _ingilter, _immitate, _bellow_, 
   {{0x93012156,0x0992c1a8,0x4c7d80a3,0x3c4b10cb}},	//   _страната_, _ресурста, _prosimo_, _eintrag_, 
   {{0xc486d1b2,0x39e320f4,0x12d9806d,0x9e743008}},	//   _भाषामा_, _minisita_, _carek_, _чемпионл, 
   {{0x626c50cc,0x498611d7,0x56d1d136,0x0e4b2140}},	//   _kolor_, _paskelbt, _अंकित_, _stranica, 
   {{0xff6bc12a,0xe17d9006,0x89ded34a,0x7090b098}},	//   _историче, _בישול_, _न्यूजलेट, _netistä_, 
   {{0x50588109,0x63eae255,0xb2249260,0x463a3019}},	//   _donaldso, _cantik_, _atake_, _промышле, 
   {{0x92ca724e,0xa3404076,0x8b9e7027,0x8ae611d3}},	//   _kindi_, _offerta_, _zaciatoc, _acetonae, 
   {{0x6387f00a,0x53ead0ab,0x6a04b054,0x43958174}},	//   _barzani_, _lietu_, _megabait, _kersa_, 
   {{0x634c72cc,0xd212b142,0x15d0405f,0xf2d8c168}},	//   _povedal_, _ruchu_, _تجهيزات_, _illene_, 
   {{0xa5a3e03e,0x6a10304c,0x52d9f1d4,0x1b10304c}},	//   _versandk, _consiliu, _estes_, _consilie, 
   {{0xf291f0e8,0x784d80c8,0x937110f8,0xdeb631e9}},	//   _skuad_, _들었습니다_, _চুয়াডাঙ্, _системі_, 
   {{0x01f7c010,0x226c713d,0xe2b40081,0xeb9ac016}},	//   _معارف_, _annog_, _igice_, _אַקאַדעמ, 
   {{0xc26c5113,0x8212305f,0x22fc602b,0x00000000}},	//   _polos_, _damhsa_, _blogy_, --, 
   {{0x6743211b,0x8d37c010,0x78fd3151,0x00000000}},	// [a00] _ботинка_, _معاصر_, _您所在的位置_, --, 
   {{0xd394d09d,0x49a9607d,0x8528407d,0x82d9907f}},	//   _broses_, _професій, _футбольн, _maseh_, 
   {{0xb157919c,0xc389b062,0x569762aa,0xe6d2b00c}},	//   _рамках_, _vergelij, _eigentli, _नाहिए_, 
   {{0xa9c530a9,0x00000000,0x00000000,0x00000000}},	//   _kesempat, --, --, --, 
   {{0xb529e193,0xc23d50c8,0x3dc431e1,0x6629e09c}},	//   _navigasy, _필요합니다_, _penilaia, _navigasi, 
   {{0x9f03d1cb,0x52259222,0x00000000,0x00000000}},	//   _респекти, _neska_, --, --, 
   {{0x9f4eb1c6,0x2354a0a7,0x82d9f0a7,0x3ad61089}},	//   _respecte_, _hareket_, _ister_, _pretplat, 
   {{0x927d6210,0xe98b5045,0x9387114e,0xb7937151}},	//   _палатасы_, _modhanna_, _librat_, _国家旅游局_, 
   {{0xb290b316,0x0d7860b0,0xf4789033,0x90b592bf}},	//   _padali_, _giăng_, _सानिकास्, _सतगुरु_, 
   {{0xc9e0a01e,0x83d862d6,0x450141c4,0xde0c82ca}},	//   _청소년보호정책_, _सेलिब्रे, _billenty, _хомосекс, 
   {{0x998e0015,0x8ca84075,0x00000000,0x00000000}},	//   _нашим_, _ফরিদপুর_, --, --, 
   {{0xf3a72019,0x23891115,0xec672119,0x00000000}},	//   _другой_, _kaayaan_, _другое_, --, 
   {{0xde3d9006,0x02fcc0da,0x7ef51027,0x92127019}},	//   _משפחת_, _blogga_, _telefónn, _vanha_, 
   {{0xdd11601e,0xb37f818a,0x425ad179,0x8f965233}},	//   _아파트분양권_, _mahanga_, _uzele_, _quần_, 
   {{0x47572195,0xf387f12f,0x937541b7,0x00000000}},	//   _метри_, _scurt_, _appuntam, --, 
   {{0x6e735142,0x036da1c1,0x0ed6c11b,0x80744171}},	//   _रुद्र_, _potencij, _karimovn, _kalendār, 
   {{0x9342011d,0x9710d0c8,0x62fd00d5,0x06f780d4}},	// [a10] _doremon_, _고객센터의_, _seinphy_, _नौजवान_, 
   {{0xf3ead067,0x43030045,0xaeb641a2,0x8ef51027}},	//   _vietu_, _raidió_, _gradonač, _telefóno, 
   {{0xfbc4e119,0xf316900b,0xb2259092,0x5200a267}},	//   _очень_, _amazi_, _deska_, _ġdida_, 
   {{0xcc71f059,0xdc46d121,0xa2ca0002,0x861a3045}},	//   _निफ्टी_, _مردمی_, _saidi_, _ترانيم_, 
   {{0x08b4c0c8,0xbcf2c05f,0x99d6901a,0x00000000}},	//   _사진갤러리_, _ناعمه_, _кадрлық_, --, 
   {{0x6f1e1068,0xa20220a3,0x33f410b4,0x2c1d2008}},	//   _kendisin, _izboljša, _daptar_, _tatarlar, 
   {{0x4f6d413a,0x4a4ec12a,0xe3f89131,0x1f618063}},	//   _pasaules_, _директно_, _ekkumi_, _xeebxeeb_, 
   {{0x74fa52ff,0x627e000d,0x2aa2a0b0,0x6192a307}},	//   _программ, _olina_, _techcomb, _autonómi, 
   {{0x130de1a2,0xfe15a08b,0x00000000,0x00000000}},	//   _osobama_, _premiers_, --, --, 
   {{0x998e1031,0x224a6277,0xe2c5c14b,0x30c39065}},	//   _начин_, _dermed_, _primjer_, _بالمقابل_, 
   {{0xa4e20201,0x727e00f4,0x923e9270,0x9925008b}},	//   _মোছাঃ_, _alina_, _termék_, _caractèr, 
   {{0xe3ebe020,0x6290c069,0xd9b5a255,0x8557a016}},	//   _mitte_, _valami_, _mendapat, _מתפלל_, 
   {{0xc0e42006,0x1ee60017,0x6eb51052,0xb037b1a1}},	//   _מאיימות_, _חיפשתם_, _konstigt_, _seltskon, 
   {{0x72da61da,0x72fdf396,0x306262f3,0x2f72c043}},	//   _direla_, _miandry_, _बतासे_, _доброго_, 
   {{0xf3eb900f,0x5c913024,0x792120f8,0xb2da6024}},	//   _sista_, _मैचों_, _চট্রগ্রা, _paweł_, 
   {{0xb3a240a9,0x187a7195,0x229fe1d4,0xe3aaa0fc}},	//   _sampe_, _затворен, _projeto_, _odobrenj, 
   {{0xa273a37c,0x281fa0c8,0xf79100c8,0x00000000}},	// [a20] _aínda_, _광화문연가_, _테마감상평_, --, 
   {{0x92d911ad,0x13f8a350,0x227e608b,0x99877035}},	//   _reklamy_, _indung_, _avons_, _厚生労働省_, 
   {{0x239402d5,0x49ebd2eb,0x54818287,0x00000000}},	//   _crise_, _undersøg, _प्राजु_, --, 
   {{0x8fe00075,0x0a8b50ce,0xe1ffe0e2,0x4c75e31a}},	//   _প্রমাণ_, _torthaí_, _menambah_, _formátu_, 
   {{0x34d07127,0x226ca044,0x7b06e1de,0x00000000}},	//   _кабирӣ_, _bobol_, _fórumban_, --, 
   {{0x449b21a7,0x7f0280f8,0x00000000,0x00000000}},	//   _dipapark, _চিংড়ি_, --, --, 
   {{0xd3eba1ba,0x908cd01a,0x9a1f1151,0x52bb1024}},	//   _cipta_, _мамандар_, _热门关键字_, _kolejne_, 
   {{0x3aa27004,0x750a6043,0xa27e9287,0x3f30d199}},	//   _priklaus, _програмн, _teknis_, _satelitn, 
   {{0x92919083,0x2ad17276,0x6c4dd081,0x33874156}},	//   _bayani_, _normalan_, _intwari_, _aperto_, 
   {{0xb290c083,0xf2434008,0x73f9e132,0x46dcd024}},	//   _malaki_, _бутунлай_, _katut_, _मुहिम_, 
   {{0xc204229a,0x2efd71f0,0x119720b3,0xd3f4607a}},	//   _serikali_, _धडाका_, _koncerty_, _watter_, 
   {{0x6ed5d067,0x626e6232,0x09f59057,0x4e02f0f0}},	//   _papildin, _ewropa_, _kaminuza_, _режиссёр, 
   {{0x2534630f,0x23ea2038,0x2386f010,0x32cf10b9}},	//   _različit, _fakti_, _ngirim_, _denonse_, 
   {{0xf2b402b0,0x00000000,0x00000000,0x00000000}},	//   _trice_, --, --, --, 
   {{0x03ea0018,0xafc7a072,0xb7b5f1e3,0x00000000}},	//   _iaitu_, _патриотт, _ibarretx, --, 
   {{0xc75de057,0xa7b420c3,0xe79ef20d,0xeaeeb123}},	//   _bizimung, _נאכנישט_, _नेतागिरी_, _hastighe, 
   {{0x627e7220,0x92558033,0x9dfa8035,0x00000000}},	// [a30] _lenne_, _kultural, _このレビュ_, --, 
   {{0x83ced35a,0x92f49095,0xaf3460b8,0x9342f092}},	//   _clovek_, _nepovolj, _adironda, _kulturní_, 
   {{0x927ed196,0x727e9110,0x00000000,0x00000000}},	//   _edene_, _adani_, --, --, 
   {{0x59d1b075,0x0b5a8138,0xd25a5052,0x2c77d116}},	//   _কমপ্লেক্, _مُساهمات, _tills_, _entrati_, 
   {{0xf2249040,0xe200c03f,0x4224d09c,0x325a91dc}},	//   _ataki_, _velice_, _reeks_, _chala_, 
   {{0xfc624042,0x52fd725d,0x9c6270aa,0x3db34178}},	//   _aparece_, _imagen_, _tutulan_, _malgache_, 
   {{0xc27e908b,0x62255104,0x52da516d,0x327860de}},	//   _avant_, _frekar_, _kateri_, _barnen_, 
   {{0xe27e732e,0x9611f206,0x9fd5d099,0xcde58035}},	//   _denne_, _kwalitei, _prezyden, _指定しない_, 
   {{0x7c67c039,0xf9d38075,0x1a25c027,0x32fe6004}},	//   _دربار_, _ক্ষুদ্র_, _prebieha_, _visiems_, 
   {{0xaf01b0c1,0x795fe1bf,0x65b15035,0x72d99151}},	//   _novorođe, _atendere, _に関する質問_, _assez_, 
   {{0x7daf60f3,0x727ef1fe,0x23ea2003,0xc29200bc}},	//   _ansiklop, _iminsi_, _vakti_, _basadi_, 
   {{0x29d9b0cf,0x029260b4,0x025a9304,0x6394d033}},	//   _सातवाहन_, _karasa_, _phala_, _grosir_, 
   {{0x200a808b,0x62fe7021,0x13fa715b,0x227e7043}},	//   _回复此发言_, _target_, _baruti_, _henne_, 
   {{0xf23691b0,0xaa73d199,0x2852035f,0x3237e146}},	//   _imaju_, _lokalita_, _segundos_, _animata_, 
   {{0x62d8f0c4,0xce38323a,0xae430150,0xe586c129}},	//   _rhieni_, _pengajia, _kamataya, _hendakny, 
   {{0xd394d123,0x63ea90af,0x6af090b3,0xdc684191}},	//   _kanske_, _thata_, _minulost, _سودمند_, 
   {{0x03ea00e2,0x9c11e1dd,0x951cf1f1,0xf032f0b3}},	// [a40] _yaitu_, _gesprek_, _доступни, _postaven, 
   {{0x6394d397,0x4290c065,0xd2fd8003,0xe26d1224}},	//   _danske_, _valaki_, _borga_, _neboli_, 
   {{0x3f6b1096,0x63210288,0x9f9fd072,0x7f01d035}},	//   _usuarios_, _década_, _qualsevo, _スピリチュアル_, 
   {{0x8e1c9081,0xf7b5d164,0xaeba6042,0x7af7602c}},	//   _interaha, _šestoric, _petróleo_, _сегменты_, 
   {{0x012d300e,0x327e90c9,0x8291f1c0,0x225a0086}},	//   _сайте_, _kwana_, _thuan_, _asili_, 
   {{0xeba8f024,0xe3ea71e0,0x16359398,0x33a23207}},	//   _स्कूलों_, _pintu_, _económic, _sempat_, 
   {{0xf2ca7062,0x92fc909f,0x3f966006,0x4e43a065}},	//   _vindt_, _snage_, _חובבניות_, _megadott_, 
   {{0x22d8d07a,0x1532200c,0x3ffc6047,0xf485d0cf}},	//   _speel_, _नब्बे_, _अधिकारों_, _रिटायर_, 
   {{0xf1013015,0x570ae21f,0x13ac50a5,0x12909245}},	//   _свете_, _وزيراعظم_, _ukupne_, _lijalo_, 
   {{0xdc8030b2,0x93427173,0x626e523e,0x163e307b}},	//   _белем_, _lateran_, _matope_, _štiavnic, 
   {{0x43a232fa,0xa2cae006,0xcf991024,0x759c806d}},	//   _tempat_, _london_, _वस्तुओं_, _enfeksiy, 
   {{0x696c2117,0x7147d043,0x1ef120eb,0x32d89027}},	//   _affiliat, _написав_, _остали_, _pokecu_, 
   {{0xdc1e7034,0x1ae381e8,0x03eae009,0x86493220}},	//   _развитие_, _интензив, _nonton_, _جبرئیل_, 
   {{0x2d8be0a1,0x5290c1b7,0xd2b28018,0x81a472db}},	//   _авторы_, _milano_, _panduan_, _नागालैंड_, 
   {{0x59d2224c,0x904990c3,0xed3ab075,0x336f60c1}},	//   _zaregist, _אַלײן_, _হেফাজতে_, _tehnički, 
   {{0xd27e900b,0xf355b182,0xf2498052,0xad2f0035}},	//   _ewana_, _moterys_, _varmt_, _回答順に表示_, 
   {{0xbe1a7399,0x7205b18a,0x7065b07d,0xc105b0b3}},	// [a50] _materija, _politiki_, _politikk_, _politiky_, 
   {{0xae18102f,0x48b9a034,0xf2e90071,0x427fa09f}},	//   _凡本站及其子站注, _последни_, _posiada_, _javnog_, 
   {{0x1188e023,0xd9f660fa,0x3dd0314c,0x68090092}},	//   _harakatl, _korún_, _остров_, _आम्दानी_, 
   {{0x23f982fa,0xdd1b41ad,0x326471c5,0x72364272}},	//   _harus_, _katowice_, _parler_, _semja_, 
   {{0xca8b3251,0xf6d0f0e6,0x8c6f0116,0x00000000}},	//   _sociální_, _आंशिक_, _approva_, --, 
   {{0x825ad273,0x317e11c6,0xf2efc029,0xfb5970cc}},	//   _mieli_, _чарба_, _malinga_, _britanya_, 
   {{0x995f1006,0xa3f9e0e2,0x00000000,0x00000000}},	//   _resource, _jatuh_, --, --, 
   {{0x73eb9047,0x627b7138,0x8a0400ce,0x457a7064}},	//   _posty_, _ginearál, _cumasait, _сәлеметс, 
   {{0x12d9e0f6,0x826c51a5,0x42da528d,0x77e5b0cf}},	//   _batek_, _kolot_, _wateya_, _अतिरेक_, 
   {{0xb3720006,0xfb7a239a,0x22497003,0x388410c8}},	//   _related_, _presenza_, _framan_, _회원님들께서는_, 
   {{0x03eb9109,0xf3f9e01e,0x19f4e181,0x63a79076}},	//   _aiste_, _플래닛으로_, _राजेन्द्, _противор, 
   {{0x23eb9246,0xd12d2098,0x33525151,0x62d9e13b}},	//   _biste_, _часто_, _知识堂首页_, _watek_, 
   {{0x620270ee,0xcb83d0f6,0x5fe7b17e,0xcd9f7050}},	//   _musika_, _europako_, _правите_, _demokraa, 
   {{0x0e36c137,0x120260f4,0x9f0d214f,0x227290ba}},	//   _spracova, _yeriko_, _संस्कारी_, _mafisadi_, 
   {{0x6945a04d,0xcc500024,0x029210b3,0x8e563072}},	//   _utilisat, _लाशें_, _odpadu_, _орусча_, 
   {{0x63574053,0x4efcc024,0x8535a016,0x15742017}},	//   _ditegur_, _बैठकर_, _נוצען_, _האגודה_, 
   {{0x1d03f035,0x2660f0fc,0x570220c8,0x5970f1de}},	// [a60] _リスト作成者_, _službeni, _허브차입니다_, _دیوبند_, 
   {{0x6a070057,0xfc67c07a,0xbf07a015,0x5c46c05f}},	//   _ambasade, _kantoor_, _провери_, _وربما_, 
   {{0xe3ea910e,0x53f990a9,0xb2ca7062,0x52e76179}},	//   _anaty_, _kasus_, _sinds_, _kornera_, 
   {{0xc26cc217,0x67db7138,0xa1f8c045,0xd0ec200c}},	//   _todos_, _كروشيه_, _وقالت_, _digitaal, 
   {{0xd1936075,0x8e5360e2,0xab810087,0x00000000}},	//   _কর্পোরেশ, _mencinta, _zanimivo_, --, 
   {{0x72365003,0xd719e106,0xa292606a,0x0629f2f1}},	//   _selja_, _komuniká, _furaha_, _difikiri, 
   {{0x7c67f075,0x325ab388,0x22ec234c,0x09c7102d}},	//   _বেসরকারি_, _ledled_, _परवीन_, _харакат_, 
   {{0xa5bd2010,0xb213f300,0xa69b2079,0xa9eb91c0}},	//   _ditambah, _kutha_, _акциунь_, _skygarde, 
   {{0xbca42108,0xd2011017,0xa23651c7,0x72f4c12f}},	//   _английск, _social_, _velja_, _posibil_, 
   {{0x204fd20e,0x02e000db,0x1769a08e,0x6ae9c2ca}},	//   _односно_, _stunden_, _רחמנא_, _полиција_, 
   {{0xd755d00c,0x33eb907c,0xa29270b5,0x5c29608c}},	//   _positiiv, _siste_, _vasara_, _kombetar, 
   {{0x4a0a10ee,0x92d99155,0x326ce0b5,0x82da715c}},	//   _arrakast, _cases_, _šioje_, _spreek_, 
   {{0x22925095,0x9c612161,0x5c25f03e,0x63e77149}},	//   _ostaci_, _feirste_, _verbrauc, _sportovi_, 
   {{0x73ea02dc,0x627c707a,0x0af61052,0xb8c6106c}},	//   _maith_, _verskill, _leverans, _leverand, 
   {{0xc2b1d034,0x17e7e095,0xaa812005,0x43fa711b}},	//   _vendita_, _bogatstv, _natomias, _guruhi_, 
   {{0x7c23b006,0xe3cef065,0xa23b7065,0xf25a9196}},	//   _ארגון_, _privit_, _komment_, _khale_, 
   {{0x82d8b2b3,0xb40d103c,0x725a9029,0x126e50ee}},	// [a70] _andere_, _最近のトラックバ, _chale_, _aktore_, 
   {{0xd31211c5,0x42921033,0xa20270a9,0xcfdd1004}},	//   _membres_, _sepatu_, _resiko_, _medicino, 
   {{0x518a01f9,0xda0a01f9,0xf25a5116,0x325ad04e}},	//   _karazany_, _karazana_, _talli_, _ahela_, 
   {{0x92b5813d,0x9ecb80ef,0x13e781ee,0xd2925342}},	//   _merch_, _thoitran, _látom_, _avtale_, 
   {{0xec61600d,0x798bf0e1,0x9b0bf08f,0xde849079}},	//   _kutunga_, _страну_, _страны_, _алиятул_, 
   {{0xdd84a107,0x7c71810e,0x71b5b197,0x126c51ce}},	//   _oprettet_, _pierrot_, _najčítan, _dilog_, 
   {{0x7c00b0a5,0x03f9a038,0xf8d281ef,0x4eded1ef}},	//   _razgovar, _hapur_, _добрых_, _dienomis_, 
   {{0xcb465073,0x92647022,0x929200f3,0xf156303a}},	//   _विद्यापी, _birlik_, _repare_, _aktualno, 
   {{0xb43f201e,0x62b520f1,0xa2920193,0x9eb6c032}},	//   _부산광역시_, _succes_, _separe_, _профила_, 
   {{0x3be74146,0x620ec072,0x13ebe2fe,0xdaf721df}},	//   _direttor, _талас_, _titta_, _материи_, 
   {{0x3147c11b,0xe49b206e,0x70ca4075,0xc2926089}},	//   _камида_, _ogranicz, _মৌলভীবাজ, _izrada_, 
   {{0x1c931069,0xf0fc9033,0xa25a6069,0x9a8d1094}},	//   _نایاب_, _सुचवा_, _zsolt_, _апрели_, 
   {{0xc932a195,0x7feb519d,0x5497e09a,0x026c2162}},	//   _реализир, _नामांकन_, _bitanduk, _nominasi_, 
   {{0xf2881084,0x43a20081,0xb19c2039,0xdb1b70cc}},	//   _айтам_, _ikipe_, _الملک_, _istasyon_, 
   {{0x0d62c1ee,0x18dcd17e,0x83eb513e,0x36b73277}},	//   _ردعمل_, _купив_, _vjeter_, _behøver_, 
   {{0x95162006,0xab0f4012,0x452870b8,0x8e70a14c}},	//   _ביאליק_, _resposta_, _aplikasy, _статията_, 
   {{0xa3860012,0xcd8a0301,0x827f0053,0x32f450d2}},	// [a80] _feira_, _allerede_, _amanah_, _pranuar_, 
   {{0xe36c8030,0xc2307045,0xa9142016,0x1c57400c}},	//   _imagini_, _ceamara_, _באגריף_, _lastele_, 
   {{0x427f0045,0x93eae19e,0x6983400c,0x4f8c61b2}},	//   _leanas_, _eniten_, _tarkvara_, _तस्कर_, 
   {{0xc7a271a7,0xb2b472a4,0x0200c087,0xf7a9326b}},	//   _pentadbi, _punca_, _obliki_, _appropri, 
   {{0xa2b5808b,0xa248f350,0xe3f82156,0x8b324008}},	//   _merci_, _rahman_, _comune_, _амалдорл, 
   {{0x70e48169,0xa2b4e224,0xc27e007a,0xc6043045}},	//   _स्वीडन_, _plochy_, _klink_, _tsamhrai, 
   {{0xb46ed198,0x5683f0c5,0x26aeb02f,0xa88e2249}},	//   _време_, _प्याज_, _民族自治地方的自, _холандск, 
   {{0x4f65a049,0x5bb75069,0xf777024f,0x81e37133}},	//   _parastin, _مداخلت_, _सत्संग_, _parfémy_, 
   {{0x8feff26d,0x43bb2220,0x72e6e2f9,0x00000000}},	//   _व्यापार_, _اسقاط_, _omongan_, --, 
   {{0xc3167032,0x93f9908c,0x5386909a,0xdfa4503c}},	//   _senza_, _pasur_, _imari_, _accepter_, 
   {{0xbab1907d,0x2b9e525f,0xfe1f8035,0xa2c16106}},	//   _області_, _fortsätt, _してください_, _kombinác, 
   {{0x20b820f9,0xb2fd6104,0x59b74362,0x4212b39b}},	//   _астам_, _liggur_, _berdekat, _sache_, 
   {{0x85b9e12a,0xecc9b0d5,0x8698f035,0xc2d8b124}},	//   _заболява, _hauvcaug_, _メルちゃん_, _budemo_, 
   {{0x22b5503d,0x98c7503e,0x22fdf04d,0x42255182}},	//   _preces_, _angemeld, _rouge_, _prekes_, 
   {{0xa29271ba,0x32020030,0xc22400f4,0x00000000}},	//   _aksara_, _masini_, _eriko_, --, 
   {{0x1097d17f,0xebca9118,0xa3b7a1d7,0x00000000}},	//   _транси_, _светлым_, _privalo_, --, 
   {{0xd2ce3098,0x92b64075,0x63eb9007,0x224a10df}},	// [a90] _нормальн, _আলমগীর_, _jista_, _luqman_, 
   {{0xb94b3230,0x720271a9,0x62c75151,0x73a230a9}},	//   _celosvet, _heriot_, _任何单位和个人不, _sempet_, 
   {{0x03160188,0x075a1006,0xc2259287,0x00000000}},	//   _reizi_, _מכיוון_, _meski_, --, 
   {{0x7e14a1dc,0xb0df920f,0x8314223b,0x12b3c2f6}},	//   _telekana, _teicneòl, _nedbank_, _поймол_, 
   {{0x828e115c,0x00000000,0x00000000,0x00000000}},	//   _miskien_, --, --, --, 
   {{0x1eb6c10a,0xdc75439c,0xc3ac02bb,0xfc52e31c}},	//   _профил_, _तृप्ति_, _toppen_, _लादेन_, 
   {{0xfcc77270,0x596b903c,0xb236905e,0x2248b019}},	//   _hosszú_, _関連法人等_, _dajjal_, _olemme_, 
   {{0x83f9a1c9,0x2f96c0fd,0x73ea00f4,0x149bb18b}},	//   _papur_, _рабства_, _mpita_, _diharapk, 
   {{0xf394e0f1,0x33a261c9,0x044300a9,0x392cf34c}},	//   _mensen_, _chopi_, _प्रयत्ना, _परिजन_, 
   {{0xadbb42cc,0x00000000,0x00000000,0x00000000}},	//   _poznania, --, --, --, 
   {{0x53ead01e,0x0200c004,0xb3781350,0x325ad186}},	//   _niets_, _dydis_, _mibanda_, _niels_, 
   {{0x6201a1ea,0x33869030,0x72a63032,0x5eac2236}},	//   _revize_, _seara_, _sembra_, _eksterne_, 
   {{0x0e33a39d,0x93869209,0x7af00317,0xf5a830f6}},	//   _גרופע_, _learn_, _prirodze, _klaserak, 
   {{0x86aa801e,0x3af7d04c,0x839490e2,0xa9c510b7}},	//   _최근검색매물_, _ражения_, _puasa_, _vallarta_, 
   {{0xa5ce1072,0x0feac138,0x62cad062,0x1f239109}},	//   _басма_, _تكبير_, _biedt_, _achterca, 
   {{0x5647c0cd,0x00000000,0x00000000,0x00000000}},	//   _алкаголд, --, --, --, 
   {{0x5bd9c043,0xf7e2b17c,0xac696065,0x62a64068}},	// [aa0] _реклами_, _сентябрд, _mintegy_, _pembe_, 
   {{0x03f4504f,0x04071033,0x5e6fd0a0,0x9ce3b151}},	//   _zetten_, _तांदूळ_, _turklāt_, _国家海洋局_, 
   {{0xf2d9c084,0x525ad0ab,0x654e61c6,0x62918179}},	//   _haver_, _skolas_, _өзүнчө_, _vezanu_, 
   {{0xe94840a9,0x9b34802f,0x72feb052,0xa3ea927b}},	//   _वेबसमूह_, _评价已经被关闭_, _butiker_, _saati_, 
   {{0x0586a079,0x96ec7119,0xc2d9c015,0x29333151}},	//   _супериор, _абсолютн, _savet_, _如其他媒体_, 
   {{0x02f1a075,0xb6b3a0f7,0xdcee2108,0x99e67260}},	//   _অবরোধ_, _бензинов, _сряда_, _craftsme, 
   {{0x829271a9,0x37ebe36e,0xe1fe239e,0xf5a6302b}},	//   _obrach_, _महाकाली_, _realizác, _plastick, 
   {{0x3c6100f3,0x71add157,0xc25a910d,0x7ac720e1}},	//   _otorite_, _разведка_, _waali_, _zahvalje, 
   {{0x19f871b2,0x61675220,0x82139157,0x4224e074}},	//   _recenzí_, _ناپسند_, _mashg_, _veikla_, 
   {{0x220261ea,0xb047d15d,0x00000000,0x00000000}},	//   _verite_, _сазовор_, --, --, 
   {{0xe2027050,0xd26cc0fa,0x7374d02a,0x8c3fc103}},	//   _otsing_, _bodov_, _рубрики_, _चम्पारण_, 
   {{0x79c7c0fd,0xf7a5f145,0xc7182094,0x73f9e188}},	//   _макара_, _objektov, _даҳҳо_, _latus_, 
   {{0x326dc158,0xfc66c1a3,0xb25a003b,0x394c217c}},	//   _novog_, _protams_, _spila_, _бытие_, 
   {{0xcdd7d17e,0xb2b120c5,0x5c34116d,0xa2d851a9}},	//   _превоз_, _काबुल_, _delavnic, _abley_, 
   {{0xbd05a045,0x3e3a1128,0xedf9c019,0x00000000}},	//   _suntasac, _karanasa, _многое_, --, 
   {{0xc2d46058,0x3b9e3179,0x4e39530e,0x00000000}},	//   _zeuden_, _podnosio_, _pamamara, --, 
   {{0xe212b0bc,0xe2f1f022,0xb5ae610a,0x26243004}},	// [ab0] _bacha_, _verildi_, _дозволен, _вербальн, 
   {{0x33ebe03e,0x691a0034,0xd908d191,0xb983804e}},	//   _bitte_, _последно_, _تغذيه_, _sitifike, 
   {{0xf94cf16b,0xa1b3c075,0x726cb22e,0x03f47171}},	//   _принципу_, _একসেস_, _dodoma_, _kartes_, 
   {{0x42927322,0x97baf0a5,0xc4fb2103,0x6a7ed191}},	//   _zaradi_, _nekretni, _गिरामी_, _تشییع_, 
   {{0x693d3138,0x3b662027,0x83ebe143,0x086d30e2}},	//   _الآخر_, _spotreba_, _witte_, _membayar_, 
   {{0x43f8c204,0x00000000,0x00000000,0x00000000}},	//   _haluan_, --, --, --, 
   {{0x4295c173,0x12f450a0,0x5264611e,0x5075027e}},	//   _majkauv_, _stundas_, _berlen_, _inscrito, 
   {{0xe2fc708d,0x9c7f0062,0x280cc289,0x4cbec02c}},	//   _dinge_, _meestal_, _млеко_, _манер_, 
   {{0xb3ead110,0x72d462c5,0x134921b0,0x1a17a037}},	//   _chete_, _verden_, _dovesti_, _кризата_, 
   {{0x3920702e,0xfc74b1c8,0x018b302f,0x5163e0a7}},	//   _शिवजी_, _forumit_, _日时政要闻_, _programl, 
   {{0x23a232b9,0xbc8100a3,0xb529d289,0x34c970f8}},	//   _simpan_, _storitev_, _реакции_, _ফিডব্যাক_, 
   {{0x8c52b033,0xb9fda1b0,0xcd3da1b0,0x00000000}},	//   _एकमेव_, _jedinica_, _jedinice_, --, 
   {{0x72e5e010,0xfba961c7,0x00000000,0x00000000}},	//   _تبصره_, _psihiatr, --, --, 
   {{0x327f409e,0xc9ff4121,0x00000000,0x00000000}},	//   _esente_, _دستبند_, --, --, 
   {{0xf2a640f4,0x62f45170,0x5c345155,0x23f9e0b4}},	//   _memba_, _standar_, _standard_, _hatur_, 
   {{0xd2d88245,0x2d327133,0xfe9231e9,0x9a77c0a9}},	//   _dikete_, _pronájem_, _порталу_, _भन्नाट_, 
   {{0x9f21a016,0xcc3ec170,0x5c111121,0xb7c3303f}},	// [ac0] _קדושת_, _daihatsu_, _کالکشن_, _नजोडिएको_, 
   {{0x7394009d,0x92d9d049,0x675ca132,0x000d3179}},	//   _prism_, _bawer_, _siliwang, _nerazjaš, 
   {{0xb3a230e2,0xe25b725b,0x22d9e006,0x2400f046}},	//   _sampai_, _soalan_, _later_, _nguội_, 
   {{0x026cc0b9,0x42926053,0x82fc639f,0xc2d9e27d}},	//   _vodou_, _diraja_, _onoga_, _fater_, 
   {{0x73f470db,0x7c6de23b,0x237a1023,0xc60322bf}},	//   _besten_, _aforika_, _masalan_, _आबिदा_, 
   {{0x263fe03f,0xdd6e9004,0x00000000,0x00000000}},	//   _kalendář_, _асфальту_, --, --, 
   {{0xa787700c,0xbaea701e,0xd7aa701e,0x5842104e}},	//   _तस्वीर_, _bestelle, _bestelli, _cycloped, 
   {{0xe2f0b017,0xc75cf182,0xe76c005f,0x725a4157}},	//   _טריילרים_, _разведку_, _الاكسسوا, _lamli_, 
   {{0xda589106,0xf348903f,0xed989106,0x3c989106}},	//   _recenzia_, _recenzi_, _recenzie_, _recenziu_, 
   {{0xd2d891fc,0x02d8b030,0x2d2301cb,0x23091288}},	//   _dijete_, _acces_, _calitate_, _carbono_, 
   {{0x226d102b,0x2ed4829f,0x239d10a3,0xb37f306a}},	//   _pozor_, _bedienin, _nadaljnj, _kamanda_, 
   {{0x80fe1282,0xe200d140,0xb3003004,0x0da4d015}},	//   _אוגוסט_, _veliku_, _kadangi_, _супруга_, 
   {{0x9c1e23a0,0xf3eae11d,0xb3534268,0x6087f29c}},	//   _compras_, _dantri_, _बहुचर्चि, _misbruik_, 
   {{0xeb9dd2e4,0x0e821151,0x61c92280,0x133cc015}},	//   _dikhabar, _图等稿件均为转载, _кости_, _близу_, 
   {{0x7262d010,0x4eab8005,0xb4c36121,0xe8668045}},	//   _سابقه_, _zostanie_, _همواره_, _beartais_, 
   {{0xc3f9e0b4,0x5792927a,0xbbd87326,0x00000000}},	//   _batur_, _manteisi, _símbolos_, --, 
   {{0x927e9168,0x537970ce,0x617ed177,0xc82060c8}},	// [ad0] _alang_, _cosanta_, _أماكن_, _고맙습니다_, 
   {{0x3b7250ba,0x6290d033,0xa3966166,0x5f70613c}},	//   _biashara_, _pelaku_, _flussi_, _neçar_, 
   {{0xd778d1de,0xd2c51039,0x9b1971a5,0x337a6151}},	//   _یونانی_, _kellene_, _karajaan_, _高宇参加台湾_, 
   {{0x93cf70de,0x22246010,0xeb311191,0xbe73320d}},	//   _gravid_, _ngoko_, _منیجر_, _मुण्ड_, 
   {{0x726de00c,0xd27e91fb,0x5ee5e079,0x12e68062}},	//   _fotod_, _elang_, _бунэстар, _drinken_, 
   {{0x63961069,0x7e8460a3,0xbc01b00d,0x620020cc}},	//   _مہینے_, _različni, _tafsiir_, _taming_, 
   {{0x52da5118,0xb807b075,0xba9d2041,0x0d6e817e}},	//   _europos_, _সমাবেশ_, _polycarp_, _моментал, 
   {{0xbc5b81c7,0x097160a2,0x626dc089,0x053b5195}},	//   _postani_, _सांझी_, _novoj_, _dimensõe, 
   {{0x439481d0,0x92003128,0xaf837332,0x825a502a}},	//   _teksto_, _galing_, _हकीकत_, _malli_, 
   {{0xe365f0cc,0xc3dcb388,0xa68cd2a6,0xc2d9e2aa}},	//   _abogado_, _incwm_, _फरमान_, _vater_, 
   {{0xd2d9e006,0x52b371c1,0x128be0d4,0x23a291ea}},	//   _water_, _ljudima_, _अनहोनी_, _chapo_, 
   {{0x227e0017,0xf2fce297,0xe2d8d247,0xfb301034}},	//   _doing_, _bongda_, _ncees_, _герои_, 
   {{0x53ebe052,0x26f0e103,0x3ba8b090,0x80291074}},	//   _hitta_, _परिवेश_, _न्यूनतम_, _героем_, 
   {{0x72d98022,0x937a5062,0x0c6990c8,0xa991d0cb}},	//   _aprel_, _volledig_, _게시판으로_, _verkaufe, 
   {{0x02466041,0xcc3ac032,0x56440121,0x72d81041}},	//   _nîmes_, _съвсем_, _diakriti, _nqhes_, 
   {{0x03946114,0xa3f9e0d2,0x5fbf2194,0x1250b024}},	//   _bulsa_, _patur_, _fungerer_, _मनरेगा_, 
   {{0x73564182,0x1a3b4121,0x725be03b,0x0047331c}},	// [ae0] _moteris_, _شرکتهای_, _litla_, _रिजल्ट_, 
   {{0x9a09202d,0xa37f30a7,0x3fa0221b,0x106572de}},	//   _москвада_, _zamanda_, _decembar_, _danskern, 
   {{0xe291f0ef,0xc7c951fb,0xbe295128,0xfa7f40de}},	//   _thuat_, _pangangg, _panganga, _varandra_, 
   {{0xf355d04d,0x126d809d,0x5386d00d,0x3386e138}},	//   _acheter_, _goron_, _seera_, _gairid_, 
   {{0x20ea2191,0x1193d11b,0xc3786057,0xb0473023}},	//   _فراوان_, _туманида_, _inganda_, _келса_, 
   {{0x327ee07a,0x88dad182,0xe3ebe02d,0xd27e9196}},	//   _kennis_, _skirting, _bitta_, _tlang_, 
   {{0x9cf3c1a8,0xe2760106,0xfc5a7232,0x82d83050}},	//   _осыған_, _starostl, _mentali_, _nimelt_, 
   {{0x03ebe1d5,0x22908140,0x4cb7b1e8,0xac2bd17e}},	//   _ditta_, _nikako_, _граници_, _ставил_, 
   {{0x47d8724d,0x92b4735f,0xd6c9f09f,0x1225f07d}},	//   _अधिकांश_, _nunca_, _uglavnom_, _становле, 
   {{0x62cad03a,0x826d913d,0x028bd0c5,0xc781b04c}},	//   _chodzi_, _noson_, _कुपोषण_, _аседият_, 
   {{0x025ad0ba,0xe2d46060,0x32fc91dc,0x53c5c17a}},	//   _mbele_, _berdan_, _anaga_, _estará_, 
   {{0x1c77f089,0x5d4bb036,0x726c80b4,0xa48593a1}},	//   _unesite_, _binadamu_, _pokona_, _विभाषा_, 
   {{0x2e46e002,0xda9a51a1,0x00000000,0x00000000}},	//   _पोस्टकार, _tehnilis, --, --, 
   {{0x82b4712f,0xa22471ee,0x4c75f2db,0xb2cd00ff}},	//   _munca_, _munka_, _रिक्शा_, _bilməz_, 
   {{0x9c537095,0xc7774094,0x72c3713f,0xe1c9214c}},	//   _postova_, _пуштибон, _poslova_, _госта_, 
   {{0x680d424b,0x322b00d9,0x4acb02bb,0x6f0b0105}},	//   _मोटरसाइक, _kommune_, _kommunen_, _kommuner_, 
   {{0xbbdf5038,0x0db7301a,0xa267311b,0xe2dc1116}},	// [af0] _falender, _темір_, _темур_, _notevoli_, 
   {{0xd291f3a2,0xa36eb212,0x52345006,0xf201f206}},	//   _thuas_, _waggulu_, _example_, _thuis_, 
   {{0xc39460fb,0x72d46060,0x8d829194,0x650291e9}},	//   _agost_, _berdin_, _generelt_, _generell_, 
   {{0xbc5d50ce,0x13578108,0x431691fa,0x93f40011}},	//   _بتاريخ_, _profilo_, _kwazo_, _hastas_, 
   {{0xa5ea102a,0x8c72d004,0x00000000,0x00000000}},	//   _форме_, _skirtas_, --, --, 
   {{0x420e11ef,0x35acc147,0xbb1cc084,0x09f6000d}},	//   _фасад_, _олими_, _cinquant, _locative, 
   {{0xef6d3046,0x41b38075,0xed1e402a,0xd2647133}},	//   _đềmới_, _বাজেট_, _поздравл, _myslim_, 
   {{0x1213f045,0xae363070,0xf639720a,0xc7d9907d}},	//   _orthu_, _kemampua, _aplicaci, _надзвича, 
   {{0xbc80c1a8,0xe2da6196,0x164df035,0x1059d079}},	//   _жедел_, _marena_, _この商品について, _капитале, 
   {{0x120fc010,0xe6dcc1c6,0x22ca70f6,0xd2fd50ec}},	//   _محترم_, _жылга_, _handi_, _chegar_, 
   {{0x52ca718a,0x93ea7010,0x43f4728d,0x52fc909f}},	//   _kandi_, _kanti_, _destan_, _snaga_, 
   {{0x1c801072,0xd1e7335a,0x1db3212f,0x187f914f}},	//   _десем_, _kliknutí_, _sanatate_, _उमीदवार_, 
   {{0x72ca70fe,0x1da660c1,0xf200b091,0x3291e267}},	//   _mandi_, _pozitiva, _budite_, _iktar_, 
   {{0x62ca7003,0xc386d0f4,0xb7e70050,0x3eeac0bc}},	//   _landi_, _leero_, _तवारीख_, _provense_, 
   {{0x673d4023,0x2224d1c8,0x5578503f,0x62560033}},	//   _проверку_, _greke_, _poslední, _थोडेसे_, 
   {{0xefa04357,0xe2e3d08c,0x88063075,0xc81c60a7}},	//   _videolar_, _prandaj_, _শাহবাগ_, _yanlış_, 
   {{0x32d471d7,0x1c0ca089,0x49c6f00c,0x871cf1df}},	// [b00] _vardas_, _austrijs, _खींचे_, _констати, 
   {{0x20513079,0x2de523a3,0x7b21105f,0x9355c29a}},	//   _историк_, _hoặc_, _البطولة_, _profesa_, 
   {{0x3bef7009,0x17aa70a4,0xcb87405d,0x99f2c177}},	//   _छत्रपती_, _bestilli, _camiller, _mhargaid, 
   {{0x9af6c194,0xa2d50166,0x05101118,0x8f423126}},	//   _oplevels, _apposta_, _ферму_, _зоиров_, 
   {{0x63f47370,0x3ec7120a,0xb386d1e4,0xd3a2e104}},	//   _tautas_, _nosotros_, _storas_, _skipta_, 
   {{0x6c37901e,0x127e7134,0x3394907f,0xb291e267}},	//   _연구회참여_, _bonne_, _kuasa_, _aktar_, 
   {{0x777f7329,0xa2a120fd,0x329e1179,0x4249f1fb}},	//   _क्रान्ति, _склалася_, _krajnja_, _ibumu_, 
   {{0xa394c1ad,0x72fce113,0x52d3d053,0x82fc7123}},	//   _polski_, _lingua_, _seronok_, _ringa_, 
   {{0x92fc700d,0x3f6950d1,0x99f741da,0xed6f9079}},	//   _singa_, _intactas_, _hilabete, _адмисэ_, 
   {{0x626e6187,0xb744e121,0x82925057,0x78a8e0b5}},	//   _metody_, _جنجالی_, _satani_, _жніўня_, 
   {{0xa9f881f9,0x4200c086,0x417da017,0xb3dc603a}},	//   _maninona_, _kilimo_, _סיבוב_, _znowu_, 
   {{0x2c31a17f,0x27d8413c,0x00000000,0x00000000}},	//   _аспирь_, _şopandin, --, --, 
   {{0x8873102f,0x129260db,0x025a900d,0xe2ca910d}},	//   _您想在自己的网站, _gerade_, _kaali_, _kaadi_, 
   {{0x0f1da0c8,0x00000000,0x00000000,0x00000000}},	//   _무엇보다도_, --, --, --, 
   {{0x5194c016,0x91db3004,0x9dcad0ff,0x6292706a}},	//   _גרעגאריא, _строгая_, _proseslə, _barani_, 
   {{0xfbe85059,0x4b5b21e9,0x3707f01a,0x62c5c09e}},	//   _खजुराहो_, _окремих_, _қаулысы_, _abiezeri_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [b10] --, --, --, --, 
   {{0x827f71e0,0x1c6271b7,0x5b2011ea,0x02e30078}},	//   _adanya_, _seguito_, _arjantin_, _kalifye_, 
   {{0x8386c3a4,0x92f6c038,0xa512f079,0x43f9807f}},	//   _bedre_, _artikuj_, _универсу, _rayuan_, 
   {{0xa2615118,0x8b6c51d6,0x00000000,0x00000000}},	//   _зверобой_, _वेदना_, --, --, 
   {{0x749562c4,0x1006c016,0x227e72aa,0x2bc991de}},	//   _स्वचालित_, _עסטרײַך_, _sonne_, _ٹیوٹوریل, 
   {{0x753e2033,0xa2129081,0x93eb7095,0x00000000}},	//   _हेमांगीक, _cyaha_, _slatko_, --, 
   {{0x7c37d0aa,0x2dffe0d2,0xd26d92d5,0xda0d30f8}},	//   _istifadə, _arrestua, _nosos_, _ভয়াবহ_, 
   {{0x2316d0d0,0xfac42112,0x23e00270,0xf373020a}},	//   _mwezi_, _беременн, _péter_, _delante_, 
   {{0x43f8e0f6,0x526c6063,0x925b4034,0xd7157045}},	//   _minutu_, _hnoos_, _quelli_, _meiriceá, 
   {{0x326cf039,0x2171310e,0x24339075,0x326c2036}},	//   _angol_, _jeankely_, _ডিলিট_, _mikoa_, 
   {{0xad292005,0xaddde21b,0x8ad1e093,0xff66c0b5}},	//   _komputer, _projekat_, _инфрақұр, _умела_, 
   {{0x52d9e3a5,0x12fd41b4,0x239d6182,0x27e692d6}},	//   _obter_, _ridges_, _заменены_, _हेमराज_, 
   {{0x7e01c03a,0xf27ed0af,0xa6d12094,0x6f5e212a}},	//   _rejestra, _eleng_, _мавқеи_, _redazion, 
   {{0x6213e0cc,0x5394009d,0xeaca105f,0x00000000}},	//   _lathe_, _grist_, _ومنتديات_, --, 
   {{0x46a29023,0x00000000,0x00000000,0x00000000}},	//   _чеченист, --, --, --, 
   {{0x020270b9,0x87e7c126,0x1d86c0eb,0xfc18e16f}},	//   _deside_, _филиали_, _награду_, _detaljer, 
   {{0x568cd169,0x426d1297,0x0db751a9,0x4c618183}},	// [b20] _फरहान_, _socola_, _ministea, _sterkte_, 
   {{0xa290c01f,0x84868024,0x8b53a3a6,0xc3944221}},	//   _silamo_, _नीलामी_, _कान्तिपु, _ormsa_, 
   {{0x637b3004,0xe2eb425f,0x906da017,0x125aa16d}},	//   _vasario_, _avsnitt_, _מסיבה_, _kabli_, 
   {{0xa386e161,0x9b9950cf,0x3f9b5045,0xf200e017}},	//   _cairde_, _ध्रुवीय_, _minicíoc, _senior_, 
   {{0xe51513a7,0x55038030,0xa0f3e0c1,0x4e53301f}},	//   _अनुदान_, _претекст_, _županija_, _raharaha, 
   {{0x526e1180,0x0733d00b,0xb22a2003,0x325be12f}},	//   _šport_, _brazzavi, _heimild_, _titlu_, 
   {{0x2049d100,0xb27ee167,0x93f4709d,0x72903081}},	//   _qehreman, _finner_, _destun_, _rumaze_, 
   {{0xf386909c,0x5249418c,0x00000000,0x00000000}},	//   _swart_, _mpemba_, --, --, 
   {{0xa9113089,0x76d130c1,0xf2d8904e,0xe0f3e381}},	//   _pojavlju, _pojavlji, _kajeno_, _županije_, 
   {{0xb23f7039,0x83ea623e,0x33ff5164,0xea0b7069}},	//   _munkatár, _mpoto_, _zauzeta_, _kilométe, 
   {{0x13574389,0x469a21b7,0xdf69d0fd,0x4909d03a}},	//   _ज्ञानकोष_, _компютри_, _komandos_, _makijaż_, 
   {{0x33940039,0x00000000,0x00000000,0x00000000}},	//   _friss_, --, --, --, 
   {{0xb4d100a9,0x00000000,0x00000000,0x00000000}},	//   _मालिका_, --, --, --, 
   {{0x826c7134,0x8d2d4233,0x00000000,0x00000000}},	//   _sinon_, _agriviet_, --, --, 
   {{0x8395c072,0x22b570df,0xcb98e27e,0x00000000}},	//   _илимий_, _yaacob_, _enriquec, --, 
   {{0xd542c034,0x0292730e,0x627a1204,0x09c0f235}},	//   _невероят, _marami_, _трениров, _prometna_, 
   {{0x06d5d02f,0xe22600a9,0xf641c0fd,0x0e95b1d4}},	// [b30] _与本站立场无关_, _kaskus_, _шторм_, _destaque_, 
   {{0x8a0a717c,0x93eae2f8,0x74a811b5,0xdf6a70fb}},	//   _catalana_, _buiten_, _izuzetno_, _catalans_, 
   {{0x02d56176,0x0380704d,0x53452134,0xec186079}},	//   _tatoeba_, _heures_, _pendant_, _raspuns_, 
   {{0x827e70af,0x71ac5114,0x139600a4,0x83f47134}},	//   _monna_, _бартараф_, _masser_, _cartes_, 
   {{0xe2f21008,0xd91b2050,0x420080a9,0xf681e34a}},	//   _юксак_, _आदर्शवाद_, _saking_, _देसाई_, 
   {{0x53796029,0xb200a15b,0x8b03f19e,0xb2ca7280}},	//   _watatoa_, _mading_, _haastatt, _разочаро, 
   {{0x7200012e,0x7f66c147,0x6506c147,0x803cc075}},	//   _idiin_, _амали_, _адами_, _বেসরকারী_, 
   {{0xb3eae0b4,0xc9c64031,0xa7bef02f,0x421290b4}},	//   _punten_, _apresent, _安徽企业网络服务, _nyaho_, 
   {{0x8a57b2f6,0x93f4709d,0x938dc162,0x12415121}},	//   _назарҳо_, _testun_, _اشخاص_, _سیمبین_, 
   {{0xd27e71a6,0x0a967171,0x00000000,0x00000000}},	//   _bonna_, _decembrī_, --, --, 
   {{0x69812069,0x302e114c,0xb25a5084,0x6799726f}},	//   _شراکت_, _produzio, _valls_, _противоп, 
   {{0x5c66d182,0xf27e7034,0xa5c900b1,0xf3090004}},	//   _centras_, _donna_, _futbolch, _futbolo_, 
   {{0xe2fce1a5,0x6affd138,0xf26e7110,0x6e39d1a5}},	//   _kungsi_, _cróitis_, _kosowa_, _kadahara, 
   {{0xd9d90075,0x1c72a1c6,0x725680c5,0x439401a1}},	//   _সংযুক্ত_, _ofertes_, _सुहागरात_, _naise_, 
   {{0x3fe8d336,0x79cd9033,0x927ed2bb,0x1394e216}},	//   _सोयाबीन_, _नदिचा_, _alene_, _reisen_, 
   {{0x23cf806d,0x039581c8,0xc43d4119,0x327eb09f}},	//   _derve_, _kurse_, _современ, _njenog_, 
   {{0x11b4b098,0xe290c28e,0xe224000d,0xc3a30040}},	// [b40] _varmasti_, _jumaat_, _esika_, _teapot_, 
   {{0xc6cca0ce,0xacf7400a,0x45e60102,0x00000000}},	//   _ollainni, _hastalar, _procesul_, --, 
   {{0x64e2212c,0x00000000,0x00000000,0x00000000}},	//   _अय्यर_, --, --, --, 
   {{0x3a18d126,0xf603d2ea,0xc2eca0b3,0x0200a128}},	//   _исбот_, _холиқов_, _kontroly_, _bading_, 
   {{0x3ac88079,0x2431d075,0x13869045,0x72d501b6}},	//   _ресурсе_, _এনজিও_, _neart_, _digotin_, 
   {{0xe12d3032,0x1ffc302a,0x25d6512f,0x129261fa}},	//   _сайта_, _способ_, _probabil_, _pirato_, 
   {{0xdff8f004,0x2446302f,0x73afc105,0xa3ea70ab}},	//   _французс, _信息产业部_, _håper_, _pantu_, 
   {{0x702eb0b2,0x9e295150,0x93860161,0x00000000}},	//   _moderado, _nanganga, _beirt_, --, 
   {{0xb3ac6146,0x88b6c0c7,0x6c14f039,0x00000000}},	//   _gruppi_, _sentyabr_, _verseny_, --, 
   {{0x2a5e3052,0x4df71204,0x00000000,0x00000000}},	//   _engelska_, _интервью_, --, --, 
   {{0xf27e6176,0xa3947323,0x53f471d8,0xcc80112a}},	//   _noong_, _hérna_, _partes_, _черен_, 
   {{0x93869262,0xee68c08b,0x72647370,0xfc09c18e}},	//   _feart_, _concerna, _saules_, _sampana_, 
   {{0xdeaca031,0x1602c072,0x1c1d13a8,0x92b401ea}},	//   _controle_, _confianç, _štandard, _krich_, 
   {{0xfb97f270,0x43dc50f4,0x279ed079,0x8bcc7094}},	//   _regisztr, _kilwa_, _араба_, _истеҳсол, 
   {{0x6d76c1ab,0x524a20a2,0x10633178,0x02f731b7}},	//   _برهنه_, _कामेडी_, _globalvo, _климатич, 
   {{0x883860c8,0xcad2e0db,0x00000000,0x00000000}},	//   _쇼핑몰에서_, _vertrete, --, --, 
   {{0x6e7cf092,0xf26dc1d4,0x14999249,0x99d63050}},	// [b50] _बिश्व_, _novos_, _половине_, _ettepane, 
   {{0x126d2232,0x5ce2108e,0x2d55a1e8,0x616d2006}},	//   _militari_, _הקיצור_, _планира_, _military_, 
   {{0x2bb4a006,0xbf7d105f,0xf2baf0cc,0x827e63a9}},	//   _וטכנולוג, _الفعاليا, _sleeved_, _goong_, 
   {{0x07b36160,0x62fce0c2,0xfbe7412a,0xa37871ed}},	//   _situācij, _sungsi_, _ulterior, _dagarna_, 
   {{0xa22b4121,0x2e51e0c2,0xe7c93019,0x5701013e}},	//   _درگذشت_, _pamajika, _varsinai, _deputetë, 
   {{0x0c859006,0xb1ca708c,0x3386909a,0x00000000}},	//   _רוסיה_, _britanik_, _bwari_, --, 
   {{0x825ad0f0,0xd6edb1ad,0x138dd1ee,0x9a6c2008}},	//   _milliy_, _finansow, _اشراق_, _ёлғиз_, 
   {{0x4cd7a173,0x3c0f20c8,0x433dc13c,0x63ea902a}},	//   _catholiq, _오피스텔분양권_, _dizanî_, _saatu_, 
   {{0x00e560fd,0x0dad017e,0x224940a9,0xd212914a}},	//   _скандаль, _quantida, _taemin_, _byahe_, 
   {{0x3aad9294,0x1b3d9006,0xb667111b,0x53f94069}},	//   _funktion_, _function_, _рашидов_, _indult_, 
   {{0x52ebc035,0x28543121,0x63a29167,0x5444d23a}},	//   _kvinder_, _موزيک_, _skapa_, _berjangk, 
   {{0x42cae022,0x8394213c,0x62f05157,0xac7160c5}},	//   _bundan_, _mêran_, _filiali_, _भुट्टो_, 
   {{0x5eab23a0,0xa34040fb,0x00000000,0x00000000}},	//   _clientes_, _defensa_, --, --, 
   {{0x2394618e,0xe2b4617e,0xa22b2015,0xb33fe313}},	//   _trosa_, _troca_, _promene_, _sedací_, 
   {{0xb2d9b0b7,0x9248e0c1,0x23ef42c9,0x1c5f42c9}},	//   _covert_, _primio_, _obitelji_, _obitelj_, 
   {{0x28184152,0x4dc8c1e9,0x00000000,0x00000000}},	//   _губернск, _центром_, --, --, 
   {{0xdff42006,0xc29101b6,0xf280a1e6,0x725b0010}},	// [b60] _הנחיות_, _dubare_, _herkese_, _ndalem_, 
   {{0x2f38f0ed,0x00000000,0x00000000,0x00000000}},	//   _होशियार_, --, --, --, 
   {{0xba0ab178,0x44b3f016,0x4a8d50c8,0x42ca90ba}},	//   _mahalala_, _באָבע_, _전문가들은_, _ibada_, 
   {{0x47e9039c,0x37074195,0x69f9610f,0x00000000}},	//   _अदाकारी_, _instalaç, _forumumu, --, 
   {{0x2177314c,0xd3ebe03b,0x00000000,0x00000000}},	//   _целта_, _hitti_, --, --, 
   {{0xf300c3aa,0xc2d4703d,0x22025060,0xfdffd1fb}},	//   _podatki_, _naudas_, _ketine_, _katentua, 
   {{0x22772094,0x1c9cb17e,0x72918074,0x2629e0c3}},	//   _фармони_, _помогнет, _vyras_, _ליבהאָבע, 
   {{0x527f40f4,0x12f05010,0x026de083,0x30e0e002}},	//   _mwenzi_, _kelinci_, _totoo_, _स्वीटी_, 
   {{0x94f3114c,0x594ed2fc,0x2224309f,0xc2881006}},	//   _местопол, _publizit, _majke_, _עתידיים_, 
   {{0x02902261,0x00000000,0x00000000,0x00000000}},	//   _kamate_, --, --, --, 
   {{0x7aa7b04c,0x32d8e0d7,0x7198a030,0x427e904e}},	//   _требуя_, _maneno_, _провизор, _joang_, 
   {{0x73087261,0xd1414010,0x629251a7,0xd9bfe0a6}},	//   _trebalo_, _مشارکت_, _hutang_, _begeiste, 
   {{0x9d0060b8,0x3bca9118,0x7c32c0a7,0x8c7c9316}},	//   _groundbr, _светлых_, _alabilir, _crispin_, 
   {{0x06492300,0xb27e2166,0x72249095,0x8fd1f094}},	//   _نتيجه_, _rokna_, _braka_, _шавҳар_, 
   {{0x639401c6,0x0d5bd05f,0xe60bc19c,0x4df49191}},	//   _crisi_, _وأضاف_, _вчора_, _منچستر_, 
   {{0xd3ead0b9,0x8585a1ae,0x72bf0010,0x12e960aa}},	//   _montre_, _tanterak, _امواج_, _istisna_, 
   {{0x1d056004,0xc25a61ae,0x1213f242,0xfc553196}},	// [b70] _populiar, _paoly_, _nsthe_, _lentsoe_, 
   {{0x2a0c1016,0x113bb016,0xb37fc0f4,0x0b073090}},	//   _בפירוש_, _אלזוז_, _talanta_, _kuchyňsk, 
   {{0x32026006,0x47154031,0x22ac1006,0x4d153008}},	//   _during_, _seguranç, _והקריות_, _футболи_, 
   {{0xb4a822a3,0xc5d690d8,0xe2b470fe,0x03374006}},	//   _opcional_, _परिपुर्ण_, _kunci_, _סטטיסטיק, 
   {{0xf82650b0,0x82c620f0,0xdb0980da,0xb6ba1023}},	//   _kiến_, _экспорти, _lýsingar_, _darajasi, 
   {{0x1b093004,0x4394730c,0xb2f300e2,0xd2d210e5}},	//   _kompiute, _munsi_, _dilihat_, _paremini_, 
   {{0xdc5ce136,0x4c75f2a2,0x53039023,0xfc69701f}},	//   _नोबेल_, _napriek_, _nafaqat_, _fantany_, 
   {{0xccd1d17e,0x92fcd098,0xdcbec05c,0x637fd010}},	//   _особено_, _blogin_, _кажем_, _walanda_, 
   {{0xdb752149,0x03f52261,0x4342d34c,0xc60e4207}},	//   _tekstova_, _tekstovi_, _बंदूक_, _kepolisi, 
   {{0xd4f9607b,0xd2026104,0x7ae6c13c,0x5cef3216}},	//   _peňazí_, _netinu_, _înternet, _hintergr, 
   {{0xf3ced029,0x33dd21a6,0xaf16c138,0xea552280}},	//   _alevi_, _anywa_, _leideann, _domenica_, 
   {{0x620271ae,0x14044092,0x7cbec211,0x00000000}},	//   _fisian_, _semináře_, _вавел_, --, 
   {{0xcaf721cb,0xc7a6e008,0x9b82b138,0xa3cee205}},	//   _наречия_, _operatsi, _mionsonr, _provoz_, 
   {{0x32b49005,0x122491a5,0x73949171,0x7c01c183}},	//   _praca_, _ngaku_, _prasa_, _luister_, 
   {{0x33ead1c5,0x227ed13d,0x729040c7,0x48c110b1}},	//   _contre_, _eleni_, _idman_, _айтади_, 
   {{0xc25ac03c,0x4401b046,0x730971ad,0x7e2ec019}},	//   _mellem_, _kilobook, _aplikacj, _поверхно, 
   {{0xd2fc905e,0xb9c581ef,0x1c63013d,0xaac3d321}},	// [b80] _niaga_, _сказочны, _astudio_, _समापन_, 
   {{0xc2d12092,0x738072ad,0x02fc71fa,0x87e841e8}},	//   _autorem_, _terras_, _bingi_, _главобол, 
   {{0xfa08a131,0x6e53a132,0xc984f02a,0x76d1a087}},	//   _bakabona_, _masaraka, _tarkaste, _dobavlji, 
   {{0x2e6de1c2,0x72ea0081,0x1290013d,0x239671dd}},	//   _अधिकारिय, _ingingo_, _leiaf_, _passie_, 
   {{0x925ad043,0x439581c6,0x7b21c17f,0x00000000}},	//   _spela_, _cursa_, _атенуаря_, --, 
   {{0xc3cff11a,0xd56ff35c,0x2883d0c8,0x91661017}},	//   _servicii_, _servicio_, _인근지하철_, _כיסויים_, 
   {{0x65aa010a,0xbceed17e,0x7eb30042,0xc62d6043}},	//   _promoçõe, _вреди_, _dereitos_, _trondhei, 
   {{0xa386009a,0x40ad5075,0xdceed079,0xa6d320cf}},	//   _agire_, _ধ্বংস_, _креде_, _दूषित_, 
   {{0x5d1e2057,0xd3ea9102,0x0b7871e4,0x00000000}},	//   _genocide_, _spate_, _catriona_, --, 
   {{0x626de17d,0x0d8451c7,0x08c0c148,0x00000000}},	//   _votos_, _izberite_, _predsedu, --, 
   {{0x5292510a,0xd2009063,0xe380009f,0xc3df2035}},	//   _citado_, _txais_, _ispred_, _この質問内容が不, 
   {{0x9b4010eb,0x9739c102,0xc2d8c07d,0x00000000}},	//   _енглески_, _impotriv, _bilete_, --, 
   {{0x837371c5,0x66534152,0xbc51e024,0x4bf41188}},	//   _demande_, _ментальн, _यादें_, _amatpers, 
   {{0xbf26301e,0x327ed0bc,0x9cd99352,0xb992c008}},	//   _홈페이지에_, _moena_, _תחיית_, _ресурсла, 
   {{0x526cf0c4,0xe68c3207,0xb48f91ae,0x622400f2}},	//   _digon_, _सुहास_, _mangatak, _vaika_, 
   {{0x02fc70e5,0xe29260f2,0xee7c000c,0x00000000}},	//   _ringi_, _mirado_, _तुम्ह_, --, 
   {{0x5c6491eb,0x4ead90a9,0xcef56079,0xb10e1017}},	// [b90] _octubre_, _lintasme_, _активита, _מופצות_, 
   {{0x226ce295,0x62c4513c,0x226cd245,0x9f370033}},	//   _infos_, _kîjan_, _ndlovu_, _persyara, 
   {{0x927ff1cf,0xa7c91121,0x96981006,0xa7691191}},	//   _jeung_, _گذاشته_, _מעצבים_, _گذاشتم_, 
   {{0x529252bb,0x08645195,0x57c7c076,0xb3a39138}},	//   _betale_, _универзи, _зависи_, _easpa_, 
   {{0x1d5a1127,0x929dd1c7,0xd237803b,0xf3957297}},	//   _бошед_, _svojega_, _verja_, _trasua_, 
   {{0x72da40ef,0xb30fe009,0x4394d017,0x47360017}},	//   _fullbox_, _menatap_, _guest_, _פיננסים_, 
   {{0x327e00f0,0xb27e026b,0xe9b1f089,0x1c5c2026}},	//   _uning_, _point_, _dvadeset, _ubatizo_, 
   {{0xe200d039,0x1c779062,0x00000000,0x00000000}},	//   _ideig_, _kwestie_, --, --, 
   {{0xf3954280,0x2386600f,0x33a3a156,0x77647125}},	//   _questa_, _stora_, _mappa_, _अस्तित्व, 
   {{0xb09f2035,0x00000000,0x00000000,0x00000000}},	//   _イベント会場_, --, --, --, 
   {{0x05e1902f,0x1be36048,0x74074065,0x1e47e3ab}},	//   _网站或个人转载使, _sementar, _feliratk, _требуе_, 
   {{0x2250c211,0x52cae2da,0xe290f054,0x334fe089}},	//   _чебан_, _handla_, _pahang_, _desetak_, 
   {{0x52b57173,0xfc7d10ef,0x4fc2c25e,0x6e31e1e5}},	//   _deacon_, _toasoan_, _قارون_, _utilitas_, 
   {{0x331ad064,0x568ee27a,0xd5f4a3ac,0x037ec079}},	//   _аралығын, _ceredigi, _zamestná, _абордязэ_, 
   {{0x73f46098,0xf87d21d7,0x127f7161,0xb5d9d0eb}},	//   _kautta_, _кампанія_, _amanna_, _анализе_, 
   {{0x949cd072,0x189d3187,0x9bab4121,0xa3ea3041}},	//   _планы_, _soutěž_, _فرکانس_, _namtha_, 
   {{0x89f29034,0x3c67d098,0xa3942067,0xe2db101a}},	// [ba0] _великобр, _minusta_, _jūras_, _нүкте_, 
   {{0xa39580b8,0x622400f2,0x58bc2017,0x13959110}},	//   _kurso_, _haiko_, _מפגשים_, _pussa_, 
   {{0x5c4b11ba,0xb2d211db,0x22bb81e6,0xa5b60297}},	//   _sunting_, _museveni_, _nedenle_, _keangnam_, 
   {{0xb2ab1062,0xa2d8b285,0x9f23928e,0x226d023b}},	//   _vandaag_, _videre_, _menentan, _roboto_, 
   {{0x5679d108,0x18cb6151,0xf1ec3059,0xd27e008b}},	//   _региона_, _北京新发地_, _बेशरम_, _soins_, 
   {{0x103fc100,0x92c5120d,0xbc6161e3,0xe25b6104}},	//   _sistemin, _selline_, _dituela_, _reglum_, 
   {{0x34c1f255,0x027ec1ac,0x43f4d00c,0x06149151}},	//   _memberik, _chonde_, _lõuna_, _经络锻炼法_, 
   {{0x027e525e,0x915b910a,0x83966250,0x00000000}},	//   _volna_, _консумир, _persoa_, --, 
   {{0x1017f0f9,0xd0270069,0x6afa60c8,0x32925132}},	//   _маркасы_, _باغیوں_, _이르기까지_, _patali_, 
   {{0xffedd227,0x0e50029c,0x89f65002,0x4e59502a}},	//   _издание_, _vakantie_, _नागेन्द्, _минималь, 
   {{0x239583a5,0x52df10a6,0xb73a1084,0x2c4ec139}},	//   _curso_, _sonntag_, _торго_, _cheveux_, 
   {{0x27cad12a,0x5292504f,0x62f520ff,0xe33112f1}},	//   _consigli, _totaal_, _ittiham_, _tebaxê_, 
   {{0xac605148,0xb7e0d3ad,0x12a6d3ae,0x225b91c3}},	//   _augusta_, _बिमर्श_, _osobnu_, _tasli_, 
   {{0xc29c4041,0x323fe0c8,0x83946159,0x00000000}},	//   _txujlub_, _모집합니다_, _yajyuam_, --, 
   {{0x9784e12a,0x42909276,0x55785145,0x875c1151}},	//   _актуализ, _najave_, _posledný, _政府信息公开_, 
   {{0x5317d0a5,0x639420e5,0xe35f31b1,0x0d29e182}},	//   _ljubavi_, _saksa_, _langile_, _песнях_, 
   {{0x727ff134,0x422471ea,0x12242240,0x00000000}},	// [bb0] _jeune_, _manke_, _pakka_, --, 
   {{0xe3bb3010,0xc2da509a,0x3300e087,0x52de40eb}},	//   _اسباب_, _mateka_, _straneh_, _нормално, 
   {{0xffe80033,0xba5392b4,0x00000000,0x00000000}},	//   _अर्थातच_, _mijëra_, --, --, 
   {{0x8838f12a,0x8d7860b0,0x3efc6050,0x00000000}},	//   _проектир, _phăng_, _युवकन_, --, 
   {{0x7386011a,0x3e2f71c6,0x2ed040ce,0x0bb59111}},	//   _stiri_, _көптөгөн_, _cúiseann, _नियुक्ति, 
   {{0x2c062006,0x2d603121,0x950a612f,0x00000000}},	//   _השגויים_, _ماهیانه_, _momentul_, --, 
   {{0x944ee02b,0x724941b9,0xb2e710c2,0x00000000}},	//   _souvisej, _premio_, _neangan_, --, 
   {{0xbae13008,0x00000000,0x00000000,0x00000000}},	//   _jumladan_, --, --, --, 
   {{0xd2ff41f1,0xb224703e,0x6fcbc043,0x5166e02f}},	//   _skriver_, _danke_, _свобода_, _第二十八条_, 
   {{0x537fd1a5,0x52da506a,0x06a2a003,0xdc75e225}},	//   _balarea_, _wateja_, _tilfinni, _sekular_, 
   {{0xffa5b0f5,0x33eba1d7,0x417ec1d7,0x00000000}},	//   _koomtxoo, _tapti_, _дамбы_, --, 
   {{0x8292703b,0x6386018a,0xfc30807a,0xf9d8a068}},	//   _gerast_, _agira_, _spesifis, _inceleme, 
   {{0x152b7069,0xaa4da116,0xec936002,0xd5fda0b3}},	//   _لڑکیوں_, _alleanza_, _निरोग_, _potenciá, 
   {{0x44e29075,0xb38071eb,0x22a6d148,0xd248e17f}},	//   _ত্যাগ_, _terres_, _osobou_, _асигурэм_, 
   {{0x2212e098,0x63877045,0xe373119e,0x6c5a905d}},	//   _siihen_, _bearta_, _tilanne_, _statali_, 
   {{0x317e026f,0x40c7c35e,0x1f6dd063,0x00000000}},	//   _положени, _физиче_, _toobfaab_, --, 
   {{0x5be7820f,0x0e92305c,0x0b04f098,0x00000000}},	// [bc0] _alpenhor, _потребу_, _viestist, --, 
   {{0x2a05c030,0xb2420086,0xa26c725e,0x83410086}},	//   _ближний_, _nyumbani_, _finom_, _desemba_, 
   {{0x03eb8050,0x6960d059,0x1ddc2069,0x7b9161ad}},	//   _tartu_, _फिटनेस_, _فلموں_, _materiał_, 
   {{0x07b462f1,0x82da7105,0x87a110b5,0x00000000}},	//   _afirandi, _årene_, _suaugusi, --, 
   {{0x2248c07c,0x23dd007d,0x00000000,0x00000000}},	//   _kommer_, _протягом_, --, --, 
   {{0x5e54e12a,0x039472a2,0x00000000,0x00000000}},	//   _икономич, _séria_, --, --, 
   {{0x85f3223c,0x63121117,0x13200086,0x3cbdd003}},	//   _अतिथि_, _members_, _ndiyo_, _formaður_, 
   {{0xac650186,0x43949026,0xb9f601de,0xfb1af2fd}},	//   _最近のコメント_, _msasa_, _japán_, _preprost, 
   {{0xbeffc0c7,0x628cd05f,0x82cab060,0x00000000}},	//   _forumçu_, _كلامك_, _seddam_, --, 
   {{0x62b5500f,0x62ff6121,0x53a3f176,0xc27ed1e9}},	//   _precis_, _pesisir_, _tsupa_, _poeng_, 
   {{0x566c2008,0x1291413d,0x00000000,0x00000000}},	//   _кучга_, _bedair_, --, --, 
   {{0xac5300b3,0x00000000,0x00000000,0x00000000}},	//   _dostala_, --, --, --, 
   {{0x7d85d19c,0x81cc2084,0xb39600cb,0x0691c122}},	//   _словами_, _кытай_, _wasser_, _қӯрғонте, 
   {{0x65324182,0xb2da60bc,0xd3304104,0xc1c400c3}},	//   _нейтраль, _mareka_, _gengið_, _מאנהעטן_, 
   {{0xf4d6a066,0x02861006,0xa2b6629e,0x838391c0}},	//   _नगरिया_, _רשלנות_, _marche_, _petrotim, 
   {{0x3711215d,0x00000000,0x00000000,0x00000000}},	//   _танқид_, --, --, --, 
   {{0xcf116103,0x00000000,0x00000000,0x00000000}},	// [bd0] _suitseta, --, --, --, 
   {{0xaf9383af,0x237a70b4,0xd36bd003,0x2c138024}},	//   _vendedor_, _matakan_, _byrjað_, _औरब्लॉग्, 
   {{0x138781d2,0x6b31505f,0x59f120b4,0x00000000}},	//   _terre_, _الشديد_, _sahingga_, --, 
   {{0x23940138,0xf906101e,0xf9c7c0fd,0x42368094}},	//   _naisc_, _부탁드립니다_, _багата_, _меафзояд_, 
   {{0x52b46148,0x339500fa,0x2202603b,0x71a72065}},	//   _troch_, _vlasov_, _skrifa_, _ہڑتال_, 
   {{0x9b974057,0xa837e01e,0x3cf6c0cd,0x312513b0}},	//   _komisiyo_, _하겠습니다_, _британ_, _ултима_, 
   {{0x7290419b,0x49aac32d,0x1b97f072,0x03fad043}},	//   _odmah_, _солиҳ_, _баракча_, _старший_, 
   {{0x895cc140,0x826ce3b1,0xdecdd171,0x5ee041d7}},	//   _iskorist, _ponovo_, _oktobris_, _dalintis_, 
   {{0x29937035,0xd76e317e,0xfdf2710e,0x00000000}},	//   _ソフトウェア_, _подготве, _archivé_, --, 
   {{0x43960285,0x63a3f116,0x22eb6084,0x40f53187}},	//   _passer_, _grupp_, _plantes_, _अप्रील_, 
   {{0xdeb820c3,0xa71dc1ff,0x920251c7,0xf291413d}},	//   _פעברואר_, _भद्दा_, _prvič_, _pedair_, 
   {{0xac75e111,0xc7b71277,0x77cb7140,0x8d331040}},	//   _कास्की_, _forsikri, _vlasteli, _townhome_, 
   {{0x0380621d,0xbe96513a,0x3cde10c3,0x3c2220e3}},	//   _letras_, _čempionā, _צופרידן_, _înregist, 
   {{0x138700c2,0x8e404066,0x1b87c1cb,0xc2a781c8}},	//   _ibarat_, _प्रशस्ति_, _библио_, _serbe_, 
   {{0x92adb075,0x8ecf2046,0xfda2c14c,0xf2242098}},	//   _ইনফরমেশন_, _quốc_, _контрол_, _pakko_, 
   {{0x0f5c70a9,0x89dfb039,0x829802d0,0x00000000}},	//   _प्रगत_, _hangulat, _ljubavni_, --, 
   {{0xe165404a,0x43eb7201,0x7922c072,0x7333e0ef}},	// [be0] _motorway_, _cuatro_, _теорияла, _matxa_, 
   {{0xcc49635f,0x2213e2b0,0x06e8b034,0xffb96042}},	//   _título_, _latha_, _гарантир, _títulos_, 
   {{0x1198305c,0xd5924179,0xacc7d17f,0x238c2147}},	//   _потребна_, _dvostruk, _бэець_, _гурез_, 
   {{0xa3d5b05d,0x034200a7,0x69435075,0x4f6b334d}},	//   _trattati_, _gereken_, _পুরনো_, _मुकद्दर_, 
   {{0x03ce9140,0x726de038,0xac12b06a,0xc3d9214e}},	//   _glavu_, _fotot_, _utaratib, _dollarë_, 
   {{0x88895198,0x85a0c075,0x47a39075,0xcb036191}},	//   _застрахо, _পাবলিক_, _সংকলন_, _بریتانیا_, 
   {{0x07b33042,0xf224e370,0xd5933042,0xba9923b2}},	//   _próximos_, _bankas_, _próximas_, _babylona_, 
   {{0xd35f328b,0x1d0dd08b,0xd223d008,0xd55c33b3}},	//   _funguje_, _populair, _кўпгина_, _prašume_, 
   {{0x820271d7,0x68f24138,0x02bb7146,0x52c86233}},	//   _geriau_, _بمدينة_, _komunità_, _phimsex_, 
   {{0x8200d2fc,0x7386926c,0x625ac236,0xc320d0b8}},	//   _ideia_, _fearr_, _mellom_, _ideya_, 
   {{0xd69b235e,0x5bee3019,0xe72963b4,0x4ec7c0f9}},	//   _акциуне_, _таком_, _maslinov, _таңбалы_, 
   {{0x9da79054,0x0b74c0a7,0x13869102,0x3c7c405c}},	//   _kerosaka, _devamını_, _afara_, _потенциј, 
   {{0x33a3f0da,0x127e612e,0x80574069,0x12eee0db}},	//   _kaupa_, _anong_, _feladato, _hoffe_, 
   {{0x5e9ec1a8,0x649cd383,0xfc26702f,0xf12d20b5}},	//   _жайлы_, _रश्मि_, _加入收藏夹_, _парты_, 
   {{0x225a9135,0x127e929c,0xa87d200b,0xa265b068}},	//   _mbali_, _klant_, _artichau, _maalesef_, 
   {{0xeee65071,0xdb597009,0xd886a01a,0x9dab8009}},	//   _मास्टरमा, _nantinya_, _функцияс, _balikpap, 
   {{0x0b76520a,0x4417509c,0xcb6c026b,0x32c6512f}},	// [bf0] _publicac, _politiek, _communic, _publice_, 
   {{0x956db3b5,0xe3870323,0xce2db006,0x23873133}},	//   _formació, _þarna_, _השופט_, _staré_, 
   {{0xc2ca710e,0x52da01e9,0xceace015,0xec3101ad}},	//   _bandy_, _årets_, _користит, _osobowyc, 
   {{0x3732402b,0x6f2ec1ca,0x1358e02b,0x00000000}},	//   _informov, _цикли_, _letenky_, --, 
   {{0x237961bf,0xa386d1da,0xe3eb007f,0xbc6e70c2}},	//   _kitanda_, _atera_, _umatku_, _nyarita_, 
   {{0x96bcd151,0x9f22e297,0xa394f236,0x65bfc126}},	//   _见习魔法师_, _vietinba, _spiser_, _осори_, 
   {{0xd224018e,0x827e91f1,0x725b723a,0x534141e9}},	//   _maika_, _blant_, _jualan_, _studier_, 
   {{0x423f9006,0x12fc9091,0x424832bb,0xfdbc9091}},	//   _במשקל_, _ostaviti_, _gammel_, _ostavite_, 
   {{0x52d592b5,0x53cf516d,0xe2b4911d,0x0bb2912a}},	//   _odnosno_, _prevoz_, _trach_, _archivio_, 
   {{0xf2fe1022,0x83ebf004,0xe2da60ee,0xd2a782a4}},	//   _birgə_, _gauti_, _sarean_, _herba_, 
   {{0xd097e06b,0x22378255,0xdd081297,0xb7aa3148}},	//   _времена_, _kerja_, _vietstoc, _anatómia, 
   {{0xb2fc720d,0x489dd02f,0x530901c6,0xa680e388}},	//   _mingi_, _中国人民银行_, _treball_, _ieuencti, 
   {{0xf37970f2,0x45d0a03d,0xc3558072,0x67752033}},	//   _maraina_, _augustā_, _курорту_, _आपापल्या_, 
   {{0x9ab150fa,0x8f89117e,0x52fce2fa,0xac28e17d}},	//   _telefón_, _детали_, _hingga_, _establec, 
   {{0x72243140,0x34f64151,0x220e1084,0x215231a7}},	//   _bajke_, _一年赚一生工资_, _матай_, _kecemerl, 
   {{0x92d9e084,0x038781e3,0x4394c1c9,0x739580ba}},	//   _actes_, _gerra_, _ymosod_, _fursa_, 
  
   {{0xe200c1d7,0x4987d1dc,0xf6e8e0b1,0x154a4249}},	// [c00] _galite_, _юридик_, _камайтир, _половини_, 
   {{0x83eb8132,0x2637803a,0xe531e0e5,0xdf6cd072}},	//   _harti_, _प्रतीक्ष, _कम्बल_, _жылкы_, 
   {{0x21cc9032,0xb4736287,0xe4602048,0x6d6d017e}},	//   _attività_, _साधनपेटी_, _diperluk, _бактерии_, 
   {{0x2200c193,0x31442006,0x1c37912b,0xdf483006}},	//   _kalite_, _בטוויטר_, _району_, _possible_, 
   {{0x672ba02f,0x92cb804d,0xd3eb804c,0x43574097}},	//   _经销假冒伪劣商品, _mardi_, _marti_, _beredar_, 
   {{0xda0aa0e0,0x3186212a,0x3bca9149,0x00000000}},	//   _manakala_, _икономик, _preminuo_, --, 
   {{0x03406212,0x4e3a5101,0xfaf461de,0x7276931b}},	//   _bagenda_, _biologis_, _ترقیاتی_, _mbinguni_, 
   {{0x2ae7a16b,0xbbeb410e,0x8b95112a,0x32d76276}},	//   _медицине_, _maromaro_, _столицат, _govorio_, 
   {{0x425d20c8,0x9d7820cd,0xb2fc0109,0xf8bee07a}},	//   _자연스럽게_, _метрге_, _uaigh_, _verenigd, 
   {{0x603b90f5,0xb2914034,0x031b2160,0x025ac050}},	//   _hautxawj_, _creare_, _novadā_, _koolid_, 
   {{0x326d902d,0x6200c039,0x9d8c70e1,0x480d5019}},	//   _inson_, _addig_, _počeo_, _понедель, 
   {{0xf349e22c,0x43ebf0ba,0x940ef26c,0x00000000}},	//   _esterni_, _sauti_, _teorainn_, --, 
   {{0xf12d2122,0xe3db70e1,0xa7caa125,0x4e920148}},	//   _дасти_, _početak_, _असामान्य_, _poškoden, 
   {{0xe2bf8035,0x00000000,0x00000000,0x00000000}},	//   _ザ操作端末_, --, --, --, 
   {{0x04b5b0a3,0xc4c3a07a,0x92008235,0x52b470cd}},	//   _zdravnik, _verbruik, _linić_, _tanca_, 
   {{0xc23b8168,0x41ce5043,0x2a864002,0xbdffc006}},	//   _fremont_, _положенн, _valitsus, _understa, 
   {{0x23954204,0x3fc2d1de,0x8809501e,0xc394d0f6}},	// [c10] _viesti_, _ماحول_, _삼성패밀리세이브_, _prest_, 
   {{0x5651503b,0xa22a1126,0x12918083,0x5da782a4}},	//   _skrifaði_, _хохад_, _kayang_, _motosika, 
   {{0x0315134b,0x7ac491de,0x8e3e0015,0x43a0413c}},	//   _kencing_, _ارتکاب_, _корисник, _televîzy, 
   {{0x5bc94065,0xcfef6103,0x39b960dd,0xf2e812a4}},	//   _خوبصورت_, _एकमात्र_, _материја, _dicipta_, 
   {{0x5e438023,0xac3390c3,0xec18c02a,0x740b7166}},	//   _madaniya, _זאליס_, _февраля_, _immigraz, 
   {{0x0504902f,0x6bc130c8,0x5899b1a4,0x754f11dc}},	//   _除权除息日_, _세금계산서_, _моментов_, _barkamol_, 
   {{0xa902201e,0x0290f0ef,0xd2ee50aa,0x0e37328d}},	//   _저작권침해_, _fshare_, _verilib_, _zanistî_, 
   {{0x00aa6098,0xc1880171,0x9f65e13c,0x63869196}},	//   _применен, _restorān, _serpêhat, _agare_, 
   {{0xa39591c5,0xb2fc0118,0x8c34e0c8,0x4006c195}},	//   _aussi_, _taigi_, _민주주의법학연구, _енергија_, 
   {{0x1fea718b,0x9b11b162,0x9adb0075,0x92cae29c}},	//   _अर्थजगत_, _امريکا_, _কলকাতা_, _landen_, 
   {{0xe224710e,0xcc5381d8,0x720e102a,0x00000000}},	//   _manko_, _sentido_, _начал_, --, 
   {{0x3248f102,0x327f9276,0x536be225,0xd5c3a1e9}},	//   _primul_, _bosne_, _tanggap_, _кодексу_, 
   {{0x0f950234,0xaad02121,0xa2f00103,0x73878003}},	//   _अज्ञात_, _ترکیب_, _वक्री_, _verri_, 
   {{0x22a661fa,0xc344b230,0xeea382c0,0x638660c2}},	//   _ngoba_, _stredne_, _vendidos_, _ngora_, 
   {{0x262282a5,0xf27c60db,0x0676b1c4,0xeaa2d02c}},	//   _organizá, _herstell, _دانشور_, _альманах_, 
   {{0xa4019055,0x4d9781ad,0x8682d207,0xcc6641ad}},	//   _ameriken_, _motoryza, _अहवाल_, _systemu_, 
   {{0xa2c69071,0xa38660c4,0xd4d1c136,0x6e0cb187}},	// [c20] _फरीदाबाद_, _stori_, _डिजिटल_, _vlastně_, 
   {{0xc66f61ad,0xd5734121,0x2386d09c,0xd34c20b3}},	//   _pozdrawi, _آماتور_, _sterf_, _dostupné_, 
   {{0x42cb5173,0x15a9f151,0x0277d02a,0x7dbf9034}},	//   _dogdig_, _大兴少年宫_, _seksuaal, _областта_, 
   {{0x42d8007d,0x5ad9c088,0x00000000,0x00000000}},	//   _veien_, _トラックバックの_, --, --, 
   {{0xe394507a,0x00000000,0x00000000,0x00000000}},	//   _valse_, --, --, --, 
   {{0x67566170,0xa747c031,0x32ca511a,0x72cbf03d}},	//   _प्रमाणात_, _милиони_, _conditii_, _naudu_, 
   {{0xd2b400ef,0x9c51d1ce,0xbde6f1ba,0x00000000}},	//   _thich_, _tentera_, _prajurit_, --, 
   {{0x9386631f,0xb0239106,0x038d2069,0x126c10b0}},	//   _agora_, _pondelok_, _اشیاء_, _xahoi_, 
   {{0x3c3ad19c,0xf2006134,0x3ed6a024,0x32247004}},	//   _людей_, _avoir_, _लैपटॉप_, _banko_, 
   {{0xf2871069,0xcfea4024,0xbba48216,0x00000000}},	//   _شہباز_, _पुरालेख_, _lediglic, --, 
   {{0x1170301e,0xce7343b6,0xf379703e,0x6bf1e054}},	//   _책임한계와_, _विप्र_, _angaben_, _berterus, 
   {{0x6fefd30e,0x07aad119,0x323600f1,0x024831e9}},	//   _reaksiyo, _любви_, _vrije_, _gammal_, 
   {{0xd2f462cb,0xa75183b7,0x00000000,0x00000000}},	//   _airneis_, _विकिपिडि, --, --, 
   {{0x123601c7,0x1341305f,0x5cf0b05f,0x7fa51151}},	//   _trije_, _أنحاء_, _البصرة_, _网络文化经营许可, 
   {{0x02b4d27a,0x930cd042,0x36e8c040,0x00000000}},	//   _drech_, _aliados_, _emicrani, --, 
   {{0x91e9c114,0x22f53089,0x8987d09d,0x787380f3}},	//   _аноним_, _turizam_, _ymwybydd, _disponib_, 
   {{0x22b4d13d,0xc9675024,0x5476907d,0x2386d12f}},	// [c30] _frech_, _वाहनों_, _процесу_, _ofera_, 
   {{0x852951ef,0x461da11b,0x5da9d071,0x2166108e}},	//   _брутальн, _жисмоний_, _zapomnia, _חידושי_, 
   {{0x220070cb,0x92da511a,0xb98590fa,0x02b53215}},	//   _wenig_, _altele_, _polievka_, _kendine_, 
   {{0xb2a7c034,0x4ff98169,0xec7c80a6,0x694631b7}},	//   _района_, _सोसायटी_, _meisten_, _сайтове_, 
   {{0x038690e9,0xb26cf1b6,0xad795008,0x00000000}},	//   _atari_, _digot_, _сарлавҳа, --, 
   {{0x2601e074,0x73f4601f,0x00000000,0x00000000}},	//   _эксперта_, _martsa_, --, --, 
   {{0x95914180,0x1cb76121,0xa20091d2,0x82a6d09e}},	//   _prispevk, _گارانتی_, _avait_, _ntebe_, 
   {{0xf486b382,0x52d8804e,0xa5c9211b,0x3aca326f}},	//   _प्रायः_, _dikele_, _тантанал, _китайски, 
   {{0xb528622c,0x97c7c2f6,0x7f66c1b5,0x82da516d}},	//   _libertà_, _радиои_, _имала_, _katero_, 
   {{0xd23601fc,0x6158a07d,0x424801d7,0xc91af0b0}},	//   _prije_, _оголошен, _seimo_, _chịu_, 
   {{0x8549b103,0x7c78e083,0x0413f1e4,0x72c4e1b8}},	//   _स्पेशली_, _patuloy_, _ceistean_, _animais_, 
   {{0x7ef8e031,0x72f0a3aa,0x3383c075,0x722582ff}},	//   _министер, _delovanj, _নিয়োগ_, _turku_, 
   {{0x026d81da,0x10a47016,0x00000000,0x00000000}},	//   _kirol_, _לאַגער_, --, --, 
   {{0x2e2530b1,0x59b73007,0x0f24f079,0x11792145}},	//   _туфайли_, _bandiera_, _админист_, _španiels, 
   {{0x6541705f,0x402ec12a,0x3d0310b2,0x72b4010f}},	//   _المؤتمر_, _tradizio, _explicat_, _iyice_, 
   {{0x2687d268,0xf45393b8,0x629261c0,0xd2fc01e3}},	//   _खुराक_, _अनौपचारि, _igrave_, _zaigu_, 
   {{0xcb7fe095,0xad341017,0x00000000,0x00000000}},	// [c40] _dopunska_, _באיטליה_, --, --, 
   {{0x71fc9030,0x65a9b035,0x2fc7b05f,0x00000000}},	//   _порядков, _よろしくお願いし, _ولكنها_, --, 
   {{0x4387f1eb,0xd2927109,0xafbd1151,0x00000000}},	//   _veure_, _òrain_, _年中国经济现代化, --, 
   {{0x93869046,0x5cac90a6,0x24f532a8,0x4c9810fb}},	//   _muare_, _leistung_, _itumanah, _objectiu_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xba0530a7,0x9200904d,0x7ff70027,0x3b5ed072}},	//   _saklıdır_, _avais_, _smokovec_, _араны_, 
   {{0x43172184,0xb89e301a,0xf5c1e1e4,0xe97a2191}},	//   _теоретик_, _командал, _artaigil_, _شقایق_, 
   {{0x6477a07d,0x00000000,0x00000000,0x00000000}},	//   _проекту_, --, --, --, 
   {{0x62d8204f,0x11f1a1ab,0x1c5b9150,0x3290d04f}},	//   _weken_, _ریمیکس_, _katulad_, _helaas_, 
   {{0xc2fe7297,0x8200d004,0x8fe8a0e6,0x7290c012}},	//   _exciter_, _kelias_, _सीताराम_, _demais_, 
   {{0x12f46104,0x73877182,0x03eae103,0x59e060ba}},	//   _hvenær_, _tvarka_, _kontot_, _kulikuwa_, 
   {{0x35cac297,0x934851e6,0xdceff052,0xc0b402f0}},	//   _canbannh, _izlendi_, _ansvarig_, _कुटुंब_, 
   {{0x8a11f070,0xd2d83133,0x2cf28192,0xb75803b9}},	//   _pemberit, _nejen_, _myndband_, _विस्वास_, 
   {{0x3340b049,0xa224510f,0x17a75106,0x00000000}},	//   _navenda_, _halka_, _opatreni, --, 
   {{0xa551e1a8,0x927e1240,0x73eb80a4,0x441c001a}},	//   _айтады_, _einstakl, _marts_, _министрі_, 
   {{0xe8d63121,0xe507f15c,0xb9aac023,0x0aa830c8}},	//   _لاستیک_, _generaal_, _хоним_, _전체적으로_, 
   {{0x993bd169,0x736f1071,0x4cc5235e,0x1cf7a038}},	// [c50] _सिद्धांत_, _akceptuj, _активитэ, _kulturor, 
   {{0x32d8208d,0x1b34706d,0x92cb7008,0x203fb038}},	//   _teken_, _lidarxis, _oradan_, _historin, 
   {{0x0867a270,0x92add039,0xe11a1006,0xf75a1006}},	//   _április_, _الشان_, _לדיוור_, _לכיוון_, 
   {{0x2c18306b,0x02b2f065,0x57a43151,0xd200c0b1}},	//   _текстом_, _rendben_, _胶南市乡镇及街道, _adliya_, 
   {{0x225a6309,0x9d8d41c3,0xb2cb7264,0x0e722151}},	//   _spolu_, _lemongra, _aradan_, _遵守中华人民共和, 
   {{0x425a611a,0x60e97169,0x83790027,0x4c5c7297}},	//   _acolo_, _अधीक्षक_, _zdravia_, _vietbao_, 
   {{0x42bde111,0x939470b9,0x4c13e1ba,0x8ca22016}},	//   _prodám_, _panse_, _merpati_, _יקותיאל_, 
   {{0x3c67d121,0x9ae69114,0xd2570270,0xe1e5b038}},	//   _ارزان_, _алайҳисс, _múlva_, _politikë_, 
   {{0x62245115,0x2c6fc222,0x425b71a5,0x29648204}},	//   _dalka_, _loturak_, _asalna_, _известно_, 
   {{0x2125701e,0x4816f118,0x52d83293,0x4f64807d}},	//   _사업자등록번호_, _pareigūn, _vejen_, _utdannin, 
   {{0xa248c08b,0x667c41e9,0xc2002022,0x9ac48035}},	//   _sommes_, _комуналь, _ilkin_, _質問をみる_, 
   {{0x13401232,0x8863a006,0x030301de,0x42d84055}},	//   _tabella_, _טרייד_, _valamit_, _demen_, 
   {{0xc3eb9171,0x19b390a8,0xa2d9a108,0x8367b259}},	//   _pastu_, _интеллиг, _invece_, _genggam_, 
   {{0x498b0164,0xdd47b03f,0x3b17b12f,0xc21e0006}},	//   _znači_, _dispozic, _dispozit, _שופינג_, 
   {{0x5e08e0e8,0xe2d84206,0xec76907a,0x9943608b}},	//   _hendakla, _nemen_, _verslag_, _imprimer_, 
   {{0x62fcd081,0xdeb9d0f1,0x00000000,0x00000000}},	//   _nzego_, _situatie_, --, --, 
   {{0x82d842fc,0x22cae0f6,0xcf25b29c,0x73807101}},	// [c60] _hemen_, _handia_, _telefoon, _ngurus_, 
   {{0xb1e1a0fa,0x96ce10b1,0x1295406d,0x42014333}},	//   _niektoré_, _милоддан_, _karkerên_, _medios_, 
   {{0xc3f4626c,0x670fb26c,0x7f859069,0xa3fa6010}},	//   _curtha_, _institiú, _تخلیقی_, _karuan_, 
   {{0x69e240c5,0xeaf8503e,0x643fe1cb,0x94984075}},	//   _पट्टी_, _aktuelle, _ефектив_, _পদত্যাগ_, 
   {{0x5b1fb0e2,0xf2d83027,0x247c30a7,0xe5bae092}},	//   _kejadian_, _odmena_, _genellik, _přičemž_, 
   {{0x4303a2a9,0x00000000,0x00000000,0x00000000}},	//   _magamit_, --, --, --, 
   {{0x49cc125e,0x5be75084,0xc387e03b,0xa81dd075}},	//   _rendelke, _assessor, _betra_, _বগুড়া_, 
   {{0xf0d31008,0x0386d260,0x170d2079,0x2e8d201a}},	//   _takomill, _peoria_, _патра_, _патша_, 
   {{0xab56d07e,0x02c5923b,0x12fd9221,0x34e60016}},	//   _sentiasa_, _evelyne_, _uisge_, _ביימער_, 
   {{0xfc6bd034,0xdff543ba,0xa2252260,0xd2b1d13b}},	//   _означава_, _proteína, _hickey_, _pandawa_, 
   {{0xaaf232fd,0xf2078161,0x6069b133,0x7a4ff2f1}},	//   _priredit, _priontái, _podprsen, _vegeriya_, 
   {{0x2dc41006,0xd2495002,0x5386d1ad,0x9c69704a}},	//   _באפריל_, _olemas_, _ofert_, _litrato_, 
   {{0xa2d85069,0xa3eb8006,0xb84c60c8,0x00000000}},	//   _jelen_, _parts_, _없었습니다_, --, 
   {{0x42d8529c,0x525c6032,0x95a391b5,0xe2d4632f}},	//   _delen_, _località_, _победу_, _verdad_, 
   {{0x63877224,0xb145a0b5,0x5dc53121,0x4387e03b}},	//   _zdarma_, _пункты_, _suriname_, _betri_, 
   {{0x27db2383,0x54fbd090,0x5b5a708c,0xd349f027}},	//   _टीआरपी_, _कैलाली_, _mendimin_, _stretli_, 
   {{0xb290807f,0x434370c8,0xa3fa71b1,0x626e51a6}},	// [c70] _baharu_, _머니투데이_, _kasuan_, _motoka_, 
   {{0x240ef02f,0x1387f132,0xc27f10fa,0x4cd6c182}},	//   _比上年增长_, _geura_, _mozno_, _забрала_, 
   {{0x6000d13a,0x92cae054,0xd90e20c3,0x6c2d512e}},	//   _informāc, _pandan_, _וואלוטע_, _espiritu_, 
   {{0xb2480323,0xe291f1a0,0x630181fc,0xf26d9192}},	//   _heima_, _dizayn_, _trebate_, _vandamál, 
   {{0x93411039,0x026c2123,0xe26de0bc,0xa25bf086}},	//   _انوار_, _bakom_, _sitoa_, _kauli_, 
   {{0xe6cca2dc,0x5341e0ba,0x00000000,0x00000000}},	//   _polainni, _malengo_, --, --, 
   {{0x6eb9a39d,0xc20ec1c6,0xa2d1a148,0x1868321f}},	//   _מיטגלידע, _казак_, _človek_, _حيثيت_, 
   {{0x88480082,0x22d84010,0x7c6831d8,0xb948333c}},	//   _ağustos_, _remen_, _escrito_, _escritor_, 
   {{0x72d85068,0x92fcd1c9,0xc23fe133,0x00000000}},	//   _gelen_, _blogio_, _elektrár, --, 
   {{0x69aac17f,0x727ed027,0x1a72102a,0xe2e94101}},	//   _комис_, _ikonku_, _акции_, _dijieun_, 
   {{0xc24862e1,0xa3eb90ab,0x7394712e,0x1dc9f06a}},	//   _veoma_, _pasts_, _bansa_, _mashinda, 
   {{0x6200c1ee,0xbe6dc0fd,0x7290405a,0x00000000}},	//   _pedig_, _заменена_, _elman_, --, 
   {{0x647552e4,0xc3880007,0x23657118,0x3653c0f0}},	//   _disediak, _bulgarij, _mergina_, _тугри_, 
   {{0x17fc1079,0x0bea0034,0xe2e8e10f,0x00000000}},	//   _алягэ_, _incontro_, _bilinen_, --, 
   {{0x2c537060,0xad8040cf,0x62d8407a,0xd3e02184}},	//   _girtina_, _सुस्वागत, _hemel_, _медалион_, 
   {{0xb926c227,0xb387528f,0x11a4d149,0x12fc7003}},	//   _причини_, _áfram_, _nikolić_, _gangi_, 
   {{0xf5ce12f6,0xac6241de,0x8ec18045,0x438ff06a}},	// [c80] _расмӣ_, _ممانعت_, _bronntan, _wanyama_, 
   {{0x471540c3,0xcbd841ab,0x945e7148,0x16250033}},	//   _אָרגאַני, _توضيحات_, _prievidz, _प्राजक्त, 
   {{0xc2fc71fa,0x78d3102e,0x8dd6c0c4,0x3d8aa0f4}},	//   _bangi_, _विंटर_, _gwahania, _abamaaka, 
   {{0x7ad3b151,0x53f45052,0x2ebcb2e0,0x00000000}},	//   _正在载入用户签名, _mitten_, _prvobitn, --, 
   {{0x82927210,0x939492b2,0x0915e216,0x27ae405f}},	//   _durant_, _kaasa_, _verbindu, _مكافحة_, 
   {{0x0c6d001a,0xf26c216d,0x6292602f,0x72e84164}},	//   _конкурст, _takoj_, _autant_, _truljenj, 
   {{0x5c96317c,0x00000000,0x00000000,0x00000000}},	//   _музыкалы, --, --, --, 
   {{0x953601f8,0x3a0741a0,0x89786108,0x02c41134}},	//   _מברסלב_, _almaniya_, _amminist, _vendredi_, 
   {{0x92132187,0x82a63012,0xdc48d15e,0xafa2f0c8}},	//   _archiv_, _membro_, _वैमनस्य_, _상습누범에_, 
   {{0x2c6cb008,0x0b094084,0x4bffe239,0x5a47406a}},	//   _сайтлари_, _comparte, _ofensivo_, _karemera_, 
   {{0x32fc702d,0x03eb8006,0x3c5c00f6,0x4db3501f}},	//   _yangi_, _party_, _martxan_, _piangona, 
   {{0x42e0603f,0xe73cf008,0xc26dd170,0xd23dd015}},	//   _jednoho_, _портрети, _siwon_, _празника_, 
   {{0xa2f4c16d,0xa300e358,0x12d8009c,0x6398a072}},	//   _napisal_, _pegawai_, _twiet_, _базарлар, 
   {{0x622490bc,0xeece2072,0xe5706191,0x00000000}},	//   _jaaka_, _артка_, _میهمان_, --, 
   {{0xe2920115,0x37a3f03c,0x2d0211cb,0x72c4325b}},	//   _lapang_, _チェックリスト_, _declarat_, _menerusi_, 
   {{0x8aa6906a,0x927e000c,0x626cb042,0x2ea14043}},	//   _magharib, _tiina_, _ricos_, _fullsten, 
   {{0xc2fc7086,0xb2df41a7,0xf39d1124,0x33204168}},	// [c90] _rangi_, _melebihi_, _izdavanj, _emmys_, 
   {{0x52d870db,0x0dc4c14c,0x02f4c017,0xa290b013}},	//   _denen_, _capitale_, _capital_, _kadare_, 
   {{0x89aac094,0x527e6233,0x4aea70db,0x2f399017}},	//   _полис_, _giong_, _erstelle, _תקציר_, 
   {{0x4386d081,0xfb8ac1df,0x5349f007,0x4225901c}},	//   _agera_, _помош_, _insetti_, _muski_, 
   {{0x300950f0,0x535bd04e,0x4cf6c01a,0x235660de}},	//   _машинала, _bongata_, _протон_, _arbetar_, 
   {{0x0bb2718f,0x04692195,0x00000000,0x00000000}},	//   _म्युनिसि, _conforto_, --, --, 
   {{0x0facb080,0x627e6063,0xd94cb155,0x01ccb170}},	//   _favorito, _xiong_, _favorite, _favoritm, 
   {{0x9b99f098,0x58278030,0xc20b63a3,0x5eb0e291}},	//   _практиче, _културал, _vườn_, _relevans_, 
   {{0x0396613d,0x89a3e02b,0x725ad090,0x00000000}},	//   _berson_, _rodinnéh, _oceli_, --, 
   {{0x3290506f,0xf2a71145,0x42cf1043,0x00000000}},	//   _allan_, _stavebné_, _annonse_, --, 
   {{0x02b490ef,0x93ea819c,0x027f700b,0xbaf6d016}},	//   _khach_, _viktig_, _nyange_, _מיליאָן_, 
   {{0x368ce103,0x6aa91306,0x2248912f,0x00000000}},	//   _बैताल_, _береке_, _seama_, --, 
   {{0x52fd7138,0x00000000,0x00000000,0x00000000}},	//   _araibis_, --, --, --, 
   {{0x6abe8267,0xac47b2cb,0xe1e291a4,0x00000000}},	//   _provvist, _hunchbac, _властите_, --, 
   {{0xa256501a,0xea158395,0x0a17c0fc,0xeb1ff2a4}},	//   _депутаты_, _automáti, _inicijat, _penafian_, 
   {{0x440f21a9,0x92a60128,0xb394d155,0x722ad004}},	//   _fearainn_, _tribo_, _press_, _позах_, 
   {{0x6e73e1f4,0x32fc70f4,0xd0d0905f,0xf0db411b}},	// [ca0] _बौद्ध_, _mangu_, _للنساء_, _salomatl, 
   {{0x726e500e,0xb6d2b071,0xfbed31c7,0xc2da705f}},	//   _kotona_, _यूजिक_, _rezervir, _nasedo_, 
   {{0x27f4d01e,0x00000000,0x00000000,0x00000000}},	//   _사업계획서_, --, --, --, 
   {{0x02f4a1b0,0x00000000,0x00000000,0x00000000}},	//   _velikoj_, --, --, --, 
   {{0xb201808b,0xb4fac033,0x7585c09a,0x00000000}},	//   _avril_, _खादाडी_, _ipererez, --, 
   {{0xe30ed188,0x023660a7,0xb208907f,0x00000000}},	//   _paziņoju, _proje_, _sayyidah_, --, 
   {{0x1bd803bb,0xa94cc062,0x696b4062,0xb7014189}},	//   _अमेरिकन_, _favoriet, _groninge, _américa_, 
   {{0xf26c31e0,0x85ab2069,0x00000000,0x00000000}},	//   _tolong_, _ڈرائیور_, --, --, 
   {{0xe3966117,0x7a15e0db,0x0ef49008,0xdc6de109}},	//   _person_, _verbunde, _шуҳрат_, _llorona_, 
   {{0x2ff90329,0x9304f10d,0xf8d8f17e,0xffd54179}},	//   _अर्थात्_, _whooping_, _помогнат_, _upozoren, 
   {{0xd533605a,0x44d7f008,0x5200b034,0xc8e692db}},	//   _hakimiyy, _футболчи, _ordine_, _न्यूयार्, 
   {{0xf7ac0265,0x52d87084,0xe27ed13d,0x7e07d015}},	//   _colectiv, _tenen_, _poeni_, _правна_, 
   {{0x327e93a9,0xf1852289,0x82026004,0x7639005b}},	//   _liang_, _огромен_, _turite_, _besighei, 
   {{0x33fa73bc,0xb4acf1a7,0x42d8f04e,0xef27220f}},	//   _poruku_, _dijalank, _dihele_, _agartasa, 
   {{0x77566310,0x23eae033,0x13ea6045,0x82806002}},	//   _प्रमाणित_, _banten_, _scoth_, _tekstiil, 
   {{0x020021d7,0x32d870bc,0x143350f8,0x00000000}},	//   _tokie_, _denel_, _লিখিত_, --, 
   {{0x12fc7285,0x58d39173,0x72d85060,0x020c912a}},	// [cb0] _langt_, _attrativ, _celeb_, _комбинир, 
   {{0xd202f0c1,0xbaf862cb,0x9863c17e,0x0c7450c5}},	//   _siromašn, _ierusale, _долари_, _वैष्णव_, 
   {{0x62d87215,0xe869a17e,0x00000000,0x00000000}},	//   _genel_, _книгата_, --, --, 
   {{0x31818075,0x5439c265,0x22bbf006,0x86b73008}},	//   _মুরুব্বী_, _traballo_, _powered_, _almashti, 
   {{0x8bb9e01e,0x9a093069,0x93329015,0x0f963182}},	//   _스팸블로그로_, _درجنوں_, _културна_, _царстве_, 
   {{0x0394e09f,0x26d33008,0x726cc052,0x2eb441b2}},	//   _zaista_, _террорчи, _sidor_, _posunout_, 
   {{0xe27e91c0,0xe9de32d4,0xd2a690b8,0xff839033}},	//   _giang_, _contenid, _grabe_, _एक्का_, 
   {{0x116dc199,0xd36c7036,0x10578010,0x60470059}},	//   _monitory_, _bungeni_, _tiongkok_, _रॉयल्स_, 
   {{0x10604182,0xa386d11a,0x726c1173,0x7c58529f}},	//   _prisimin, _oferi_, _ibhom_, _kritiek_, 
   {{0xd2fc7036,0x227e707c,0x226c502d,0xb16111f9}},	//   _wangu_, _finne_, _salom_, _behivavy_, 
   {{0x32366119,0x1380a1de,0xa2fc7036,0x1a310069}},	//   _sulje_, _یادگار_, _tangu_, _قیصرانی_, 
   {{0xd2bb61c8,0x1dfb6038,0xa386903d,0x8647a071}},	//   _komente_, _komentet_, _starp_, _अड्डे_, 
   {{0x427e7050,0x49aa1147,0x52a6c13b,0x8f58432f}},	//   _hinne_, _кории_, _lambar_, _propieda, 
   {{0x0a303151,0xa37b30ba,0x4069415c,0x63ea00b9}},	//   _的所有文字_, _mipango_, _kampioen, _imite_, 
   {{0x82d4d018,0xf28ad0fd,0xaeb4a0b4,0xe202609a}},	//   _memohon_, _мінет_, _gerentes_, _birimo_, 
   {{0x524bf18b,0x0e5f4035,0x6ca0b0c5,0x72a64029}},	//   _कुठेही_, _この記事へのトラ, _बृहस्पति_, _mumba_, 
   {{0xdc60909e,0xf39582b6,0x5c50c191,0x00000000}},	// [cc0] _nnyumba_, _darse_, _زنگنه_, --, 
   {{0xc27100b1,0x569641c7,0xd3739060,0x0e19c17e}},	//   _deputatl, _spremeni, _temaşe_, _белград_, 
   {{0x0354a1d8,0x3395c063,0x52f91015,0x03a3f140}},	//   _podemos_, _huvsi_, _потребно_, _skupa_, 
   {{0x6c36e010,0xe38601e3,0x33eb01a7,0x884371ef}},	//   _تعامل_, _agiri_, _amatur_, _portalas_, 
   {{0x82246110,0x42d97109,0x00000000,0x00000000}},	//   _shoko_, _ghaelg_, --, --, 
   {{0xbf1b101a,0xbb18b198,0xa2041035,0x32a6d042}},	//   _күміс_, _компютър_, _住所又は居所_, _probas_, 
   {{0xc6d11206,0xa3ced158,0x235670dc,0xf316709a}},	//   _probleem_, _čovek_, _alafuwa_, _zunze_, 
   {{0x549991de,0x6944b194,0x968d82db,0x6341512a}},	//   _معاملہ_, _herunder_, _परवाह_, _potenza_, 
   {{0x2224c230,0x63f473bd,0xe14c9127,0x4264709f}},	//   _dadka_, _postao_, _убайдулл, _poslao_, 
   {{0x51b3d075,0xd316931a,0x4b95e075,0x0e4f00fe}},	//   _মেসেজ_, _praze_, _সমাজসেবা_, _kehamila, 
   {{0x6b2b7022,0x11120290,0x496ce0f2,0x52bb7062}},	//   _komandas, _družina_, _tahirint, _komende_, 
   {{0x33eb70c4,0x00000000,0x00000000,0x00000000}},	//   _ymateb_, --, --, --, 
   {{0x95d42033,0x0dfae108,0x06aa4017,0xa4864103}},	//   _membutuh, _осъществ, _פסיכומטר, _सुधारे_, 
   {{0x047c0045,0xa39540ee,0x2120d171,0xe24af17f}},	//   _cartlann_, _tresna_, _informēj, _асигурэр, 
   {{0x9c71700c,0x73ce616d,0x3647009c,0x23e7a0e6}},	//   _डाक्टर_, _znova_, _verklari, _zítra_, 
   {{0xfb30c094,0xb7a2e0c8,0xcaeb816f,0x6664400c}},	//   _беном_, _테마스토리_, _bestemme, _viljandi, 
   {{0x876c3099,0x67e1f095,0x3f61f1b0,0x2946b151}},	// [cd0] _wyjątkow, _pripremi, _priprema, _国家外国专家局_, 
   {{0x69817121,0x1f15f36f,0xde0430fb,0x7a6b423b}},	//   _ایپرام_, _sledovan, _курска_, _kolobets, 
   {{0xafaec023,0x6ef1a006,0xc2dfe0f6,0x076f50bc}},	//   _балки_, _marketin, _bereziki_, _amahanng, 
   {{0x32903060,0xbfeb40e6,0x826d809d,0xf187a016}},	//   _komara_, _विभाजित_, _sirol_, _אָנערקענ, 
   {{0xd202706a,0x31dcf174,0x32d8b0c9,0x4d4710c8}},	//   _aprili_, _اتحادیه_, _nadege_, _전문가서비스_, 
   {{0xee8f636b,0x92d46210,0x5e7cb00c,0xa38c404f}},	//   _promijen, _perdre_, _बाक्स_, _toestemm, 
   {{0x82d8c26e,0xeb6310ef,0x901a102f,0x7307f28f}},	//   _leden_, _doreamon_, _服务已开通_, _endaði_, 
   {{0x3865d316,0x2df02069,0xa95a61ef,0x0531509f}},	//   _barracks_, _ونڈوز_, _намаганн, _pročitat, 
   {{0x7ae5239c,0x322ac0a1,0xe5f7901a,0x00000000}},	//   _कृष्णदेव_, _содан_, _мамандығ, --, 
   {{0xe280b1b2,0x728c1121,0xb15b7062,0xa772c0eb}},	//   _diskuse_, _آلوما_, _originel, _свега_, 
   {{0x52bb6012,0xb4b2620d,0x49aa111b,0xa22ac0fd}},	//   _somente_, _पिंडी_, _ҳосил_, _богам_, 
   {{0x02484065,0x00000000,0x00000000,0x00000000}},	//   _semmi_, --, --, --, 
   {{0x51f62033,0xa27f41ce,0xf3a2e09c,0x2d9c3078}},	//   _टोमॅटो_, _agensi_, _egipte_, _pagename_, 
   {{0x829241e0,0x5ee8602f,0xd84a123d,0xcb61405f}},	//   _datang_, _城乡规划法_, _горка_, _جلابيات_, 
   {{0xd3687126,0xb84753be,0x525ae0f6,0x027f5171}},	//   _тафаккур, _duplicad, _mailan_, _sienas_, 
   {{0x8e325173,0x11517072,0xe2e89164,0xc2903060}},	//   _amelikas_, _нерселер, _lozinka_, _tomara_, 
   {{0x217da016,0xa2d8c215,0x563ce173,0x12d850b4}},	// [ce0] _פיגור_, _neden_, _arianism_, _weleh_, 
   {{0x327f502c,0x85ee3003,0xd2f4509f,0x1d85b20d}},	//   _vienas_, _landslið, _zapošlja, _बायोग्रा, 
   {{0x727ff155,0x12e561de,0x22f22003,0xe48d50c8}},	//   _found_, _اعتکاف_, _ákveðið_, _인테리어소품_, 
   {{0x7b7340d8,0x352f41e2,0x4248d15b,0x4fdb60c8}},	//   _अप्रकाशि, _disposto_, _seema_, _소비자보호에_, 
   {{0x5200920f,0xbaf26008,0xc202600a,0xa89d3187}},	//   _amais_, _экологик_, _suriye_, _soutěži_, 
   {{0xe290a27a,0x6032f02b,0xc35673b5,0x5f9430b5}},	//   _alban_, _nastaven, _acceder_, _плоская_, 
   {{0x9386e041,0x52ea7089,0x6200909d,0x9292703d}},	//   _leiria_, _poginuo_, _blaid_, _atrast_, 
   {{0x23f85134,0x9db141f2,0xbc7f50ea,0xd2b4e15d}},	//   _celui_, _lenguaje_, _versão_, _pincha_, 
   {{0x37158016,0x1e761016,0x6305506d,0x5a15d118}},	//   _שושנת_, _מספריהם_, _dizanim_, _куплена_, 
   {{0xc2d82065,0x9e1bc20a,0xa9dbc084,0x49486023}},	//   _nekem_, _pregunta, _pregunte, _amaliyot, 
   {{0x6c723006,0x12d77297,0x9201b0ab,0x00000000}},	//   _stories_, _autopro_, _diviem_, --, 
   {{0xf2f50171,0x7200a0cc,0x627ed297,0x82367029}},	//   _pavisam_, _ambit_, _mieng_, _kunja_, 
   {{0x97f27148,0xd3bab121,0xb291c008,0xdc00c053}},	//   _možnosť_, _هرمزگان_, _avval_, _spyshot_, 
   {{0xa96c5030,0xb9d8f095,0x31bd2249,0xf7414017}},	//   _societat, _izložba_, _листе_, _ואביזרים_, 
   {{0x8c88d1ca,0xe38771f1,0x3d94a1de,0xe5a6b016}},	//   _транслит, _starta_, _keresett_, _אינטרעסא, 
   {{0x68e52079,0x926c2083,0x2b4c2068,0x00000000}},	//   _адмитеря_, _takot_, _numarası_, --, 
   {{0xf27f711e,0x5759f0e5,0x0309e027,0x269b205c}},	// [cf0] _chanje_, _भिक्षुक_, _zemiakov_, _активне_, 
   {{0x96823145,0xd342a045,0x02926162,0xf7b5b124}},	//   _decembri, _inneall_, _marang_, _najstari, 
   {{0xb3eb8199,0x906cf02f,0x47e3d02a,0xe27e916d}},	//   _karty_, _第三十四条_, _универса, _znana_, 
   {{0xf6c3a0aa,0x7a03a040,0x627f009b,0xbc4332f8}},	//   _portalı_, _paralyze, _nganti_, _netwerk_, 
   {{0x422ab0bf,0x73eb71da,0x53f870ee,0x926e736b}},	//   _někdo_, _esaten_, _menua_, _europi_, 
   {{0x2cfd70f9,0x12dfd123,0xbd81525e,0x0c76c050}},	//   _конкурсы, _inkomst_, _hallotta, _नृत्यं_, 
   {{0x4200913d,0x4abca0dd,0x37cbf287,0x00000000}},	//   _plaid_, _министар_, _लोकमान्य_, --, 
   {{0xf27f50fd,0x02d8c1c7,0x00000000,0x00000000}},	//   _dienos_, _teden_, --, --, 
   {{0x80e64024,0xdf6900c5,0x7c751196,0xa71b61de}},	//   _आईबीएन_, _लाभदायक_, _ofising_, _برصغیر_, 
   {{0x22fc7068,0xe2d8c29c,0x185d9079,0x53967288}},	//   _hangi_, _reden_, _минерале_, _causas_, 
   {{0x5fc39155,0x6dd6e098,0xe26dc2e0,0x9aaa7298}},	//   _register_, _perjanta, _nivou_, _מדרבנן_, 
   {{0xadc0715d,0x1807c069,0x3248003b,0xd863116b}},	//   _vositala, _لکھتے_, _heimi_, _морали_, 
   {{0x43fec232,0x72fc7131,0x72d8213c,0x5c8012ca}},	//   _kwalifik, _mangi_, _yekem_, _десет_, 
   {{0xc37b606a,0x62fc7131,0x22fce084,0x9f071074}},	//   _kiwango_, _langi_, _origen_, _маразм_, 
   {{0xeb6cb079,0x186743b5,0xf200c0b1,0x1f128171}},	//   _министру_, _solicitu, _oldin_, _organizā, 
   {{0x220272fa,0x7c5370c1,0x87aeb092,0xbc11508c}},	//   _masing_, _sastava_, _नर्सहरुक, _sarandë_, 
   {{0xa3b75015,0x93f8f08c,0x63f7b074,0x00000000}},	// [d00] _zatvora_, _punuar_, _граніт_, --, 
   {{0x126c9254,0xfd2c911e,0xcaa9c2db,0xc3f470a9}},	//   _aktiviti_, _aktivite_, _रामलीला_, _partai_, 
   {{0xd2cf9148,0x42c4a017,0x127ed063,0x00000000}},	//   _kancelár, _england_, _xieng_, --, 
   {{0xf27ed173,0x130350f5,0x5fb3d079,0x6246d171}},	//   _vieng_, _nyablab_, _антилеӂи, _tēmas_, 
   {{0xb290703a,0x6d7ab075,0x420b004a,0x08fd7021}},	//   _ponad_, _বিনিয়োগ_, _emphysem, _urbanind, 
   {{0x127e00f4,0xae72224f,0x72dac015,0x00000000}},	//   _diini_, _तुच्छ_, _исламист, --, 
   {{0x087881a8,0x00000000,0x00000000,0x00000000}},	//   _тексеру_, --, --, --, 
   {{0xac74d372,0xe3869155,0xa19d9119,0x12dfc01a}},	//   _minutos_, _start_, _наиболее_, _мұхаммед_, 
   {{0xb200d05b,0xb27e70e5,0x92d8f043,0x46c8e0fe}},	//   _klein_, _sinna_, _legen_, _maksudny, 
   {{0x3373c188,0xbc3a30fb,0x526c20bc,0xf3f4709d}},	//   _nekustam, _elaborac, _bakor_, _ofsted_, 
   {{0xb3ce6133,0xbc738149,0x59f4b039,0x05b8c313}},	//   _znovu_, _emisija_, _vidám_, _bankovní, 
   {{0xe27e7192,0xc354a17a,0x22d8427b,0x5adb80db}},	//   _vinna_, _modelos_, _temel_, _bestimmt, 
   {{0x0386b0a8,0x28a6c01a,0xf8e62084,0x107d21d7}},	//   _sucre_, _ауызашар, _мартта_, _марсе_, 
   {{0xd27ed0ef,0x087fb06e,0x0224d110,0xeee82119}},	//   _tieng_, _शब्दयोग_, _mkeka_, _метров_, 
   {{0x678530e6,0xb122d1fb,0x00000000,0x00000000}},	//   _आह्वान_, _مدافع_, --, --, 
   {{0x32926128,0x87e603bf,0x925ca121,0xb27ed1c0}},	//   _parang_, _अनार्य_, _اتوبوس_, _rieng_, 
   {{0x03646024,0x10d77099,0xaf7ab03f,0xde858172}},	// [d10] _ग्रैंड_, _motocykl, _upozorně, _दिव्यदृष, 
   {{0x9386d1fa,0xe38691d9,0x943ec23d,0x9f9e0072}},	//   _ngeri_, _fuara_, _ганна_, _комитети, 
   {{0x52db91cb,0xc25b4280,0xcdf2c152,0x1eb080f3}},	//   _контакту, _quello_, _джорджа_, _konesans_, 
   {{0x12cfd2e1,0x00000000,0x00000000,0x00000000}},	//   _takodje_, --, --, --, 
   {{0xd39580a7,0x21332145,0x9386d1d4,0xbb872089}},	//   _varsa_, _kvalitné_, _quero_, _dogodilo_, 
   {{0x4c9e12e7,0xf2fe4042,0x93f4738f,0xe6613008}},	//   _תוויות_, _motivos_, _postel_, _маъқул_, 
   {{0x52ff527b,0x12d841b6,0x1d87612a,0x0200b033}},	//   _verilir_, _semel_, _inserire_, _kediri_, 
   {{0xc3a8a22f,0x6b5a60dd,0x4c55b143,0x3ecba255}},	//   _sekarang_, _прокомен, _afstand_, _menyampa, 
   {{0x753a9022,0x175a9023,0xfd027084,0xa290e216}},	//   _agentliy, _agentlig, _qualitat_, _hinaus_, 
   {{0x96364071,0xd349e22c,0x62d6621b,0x5da74010}},	//   _सुनहरे_, _diretti_, _redovno_, _sekolaha, 
   {{0x831691da,0x7e1880ad,0xbd687016,0xc76bf3c0}},	//   _arazo_, _posetila, _דערזען_, _naučnici_, 
   {{0x92d8c087,0xf83e505f,0x707bc2db,0x6b2181b6}},	//   _telesa_, _القحطاني_, _सट्टेबाज, _nasandin_, 
   {{0xdae85098,0x5dc6d191,0xc238202a,0x22fc3247}},	//   _источник_, _ناوبری_, _блондинк, _ualicas_, 
   {{0x23ead0ce,0xb2da7006,0x00000000,0x00000000}},	//   _contae_, _myself_, --, --, 
   {{0x29560065,0x4f11405f,0x304a11fe,0x00000000}},	//   _ٹورنامنٹ_, _الاصدار_, _kwerekan, --, 
   {{0xa39590bc,0x7a1ed2f6,0x527f501d,0xddbd50b9}},	//   _sassa_, _либия_, _tienes_, _kapasite_, 
   {{0x4b0cc03c,0x23f45062,0x5263c16d,0xe4561268}},	// [d20] _友達に紹介_, _zitten_, _evropski_, _असाध्य_, 
   {{0xceee01e8,0x369b6297,0xc94890c5,0x00000000}},	//   _компании, _saigonti, _जालस्थल_, --, 
   {{0x325620dd,0x0e46b288,0x23958083,0xa2d851ba}},	//   _становни, _modalida, _marso_, _kelem_, 
   {{0xe2e3d2cb,0x0313f2ba,0x8b50502a,0x22d85071}},	//   _lehrbuch_, _ulicama_, _postissa_, _celem_, 
   {{0xa2cae0db,0x279371a1,0x5e643014,0x72b591c6}},	//   _findet_, _kultuuri, _públicam, _tasca_, 
   {{0x1290407a,0xbe67f004,0x37e55240,0xdb02709d}},	//   _almal_, _шахматы_, _samstarf, _lawrlwyt, 
   {{0x375fa0e5,0x82d8c1a7,0xac51c179,0xe307228d}},	//   _विद्याक_, _selesa_, _spotova_, _armancê_, 
   {{0x90c7603c,0xf201807a,0xd26c512e,0xdb45801a}},	//   _一覧を見る_, _berig_, _halos_, _тырнақ_, 
   {{0xb3f4500e,0x637b70d1,0x926e50af,0xb26c437e}},	//   _sitten_, _intacto_, _litora_, _vamos_, 
   {{0x3b0410c3,0x2a8bb1f1,0xbbb79069,0xeed741ad}},	//   _נאכאמאל_, _trenings, _کیلنڈر_, _delikatn, 
   {{0x6fe9400c,0x8386b09d,0x9aec00f6,0xd0739078}},	//   _संचालित_, _oedran_, _kolektib, _sweatsho, 
   {{0x73169012,0xc2fe6080,0x3378e28d,0x3d41c184}},	//   _prazo_, _visitas_, _welatan_, _авець_, 
   {{0xfda741e1,0x6291b081,0x52d85069,0xe30511de}},	//   _kelihata, _ndwara_, _velem_, _دوچار_, 
   {{0x83946081,0x73f86055,0x5323413d,0xfb8fe1d3}},	//   _cyose_, _gwoup_, _mercher_, _glengarr, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0xe948b1a8,0x1ae63187,0xffdfb006,0x5a1b407b}},	//   _кафедрас, _यद्यपि_, _מצאתי_, _absolútn, 
   {{0xec09b16d,0x12d84060,0x32b5827e,0x726c5040}},	// [d30] _podpora_, _demek_, _barco_, _balos_, 
   {{0xa3a5d127,0x827e304f,0x93207215,0xe6831033}},	//   _муовини_, _bijna_, _konya_, _aksesori, 
   {{0x24b3e23a,0x5eb7b1ee,0x068a1160,0x00000000}},	//   _memastik, _البلاغ_, _akadēmij, --, 
   {{0x211b5121,0xcaea7068,0x5a28d191,0x86b120c5}},	//   _سرپرست_, _destekle, _نتايج_, _डकैती_, 
   {{0x7394625a,0xbb5930a5,0xd28781d7,0x057930a5}},	//   _byose_, _iskustva_, _мультфіл, _iskustvo_, 
   {{0xcc66d3b5,0x33805101,0x2a6c303b,0xfc7560db}},	//   _centros_, _patrem_, _heimilis, _samstag_, 
   {{0x0387b1d3,0x0906e0e2,0x59c62017,0x52dff15b}},	//   _lawrie_, _berbentu, _ריאליטי_, _ameneng_, 
   {{0x9150a071,0x3291f05e,0xd290e029,0x77b0a071}},	//   _podstawo, _aduan_, _binamu_, _podstawi, 
   {{0xf2d85027,0xef6ea0b0,0xc26c3084,0x7c741016}},	//   _celej_, _niềng_, _rajoy_, _באריכטן_, 
   {{0xc41b4278,0x0d1a0262,0xce741016,0x95861017}},	//   _kuchynsk, _cudromac, _חנוכּה_, _קבלנים_, 
   {{0x2e4c4041,0xa3860357,0x030c21d8,0xffc8b059}},	//   _haaaaaaa, _daire_, _humanos_, _समलैंगिक_, 
   {{0x426cd180,0x2bebe3b3,0x4b977065,0x83f47137}},	//   _pomoč_, _komentir, _ماہرین_, _dostal_, 
   {{0xc38601d2,0x0dd40006,0x7c74a151,0x7d2601e9}},	//   _faire_, _האשכול_, _查看评论信息_, _редакції_, 
   {{0xb3f8c3c1,0xf200309f,0xbc47c118,0x375430c5}},	//   _usluge_, _kojim_, _разгон_, _पारिस्थि, 
   {{0x527f6084,0x1ff47099,0x129101fa,0x00000000}},	//   _signes_, _ब्राजील_, _embala_, --, 
   {{0xa248d05f,0x05c7716d,0xbc1d7149,0x49c5628c}},	//   _seomra_, _oblačila_, _doprinos, _diperhat, 
   {{0x8c068224,0x7f6ea0b0,0xa6962075,0x48713210}},	// [d40] _dopravy_, _giềng_, _বরগুনা_, _усталар_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x18999122,0x62f20148,0x1394e1ae,0xf27e623b}},	//   _писандид, _nasleduj, _anisan_, _sione_, 
   {{0x137c6042,0x10d1b1f9,0x1b78e22f,0x77a61297}},	//   _alcalde_, _manontol, _berusaha_, _vietgiai, 
   {{0x6e07520f,0x32b69195,0x92ca9162,0x8291b0b9}},	//   _meadhana, _планирањ, _ngalami_, _lavant_, 
   {{0x9f275161,0x02f76097,0xf396302f,0x0f24c287}},	//   _leathana, _menikah_, _passé_, _जवळजवळ_, 
   {{0xdd66c2ce,0x7743d019,0x231c70f8,0x92e9f074}},	//   _критику_, _новинки_, _বলিউড_, _француза, 
   {{0xa9dff1de,0x2a376075,0xa40dc05f,0xa2497087}},	//   _augusztu, _চালিয়ে_, _الضحك_, _znamke_, 
   {{0x2f45d2c9,0x227e914c,0x12980017,0x00000000}},	//   _najljepš, _siano_, _הגירסה_, --, 
   {{0x154d807b,0x2c8b503f,0xd236609f,0xc54e0033}},	//   _prevádzk, _kuchyně_, _broja_, _कुठेतरी_, 
   {{0xe33c401e,0xd30ca128,0x4d11d010,0x35ab0075}},	//   _사람들에게_, _madalas_, _اخراج_, _উন্মুক্ত_, 
   {{0xb290e164,0x5d5cb2ea,0xdf162151,0x00000000}},	//   _sinaju_, _зарурати_, _买卖通档案_, --, 
   {{0xa7bc5200,0x62a6c225,0x42ee613d,0xb5059006}},	//   _forretni, _tomboy_, _economi_, _טורבו_, 
   {{0xa36bb069,0xffd952d1,0x00000000,0x00000000}},	//   _بھرپور_, _dostatoč, --, --, 
   {{0x22ab1244,0x5e62d1f2,0x322590cc,0xa847c16b}},	//   _bandung_, _descarga, _pasko_, _напали_, 
   {{0xd08e1352,0xdccda17e,0x35fa702f,0x92e71035}},	//   _פוסקים_, _читатели_, _劳动和社会保障部_, _spanien_, 
   {{0x212d319c,0x42f621a9,0xb0f9832d,0x3af3604d}},	// [d50] _сайті_, _briseadh_, _ministrl, _consulte, 
   {{0x027f50a0,0xacf9702e,0xbb4fd3c2,0x89e6d164}},	//   _dienas_, _अभिमानी_, _premijer, _pritisnu, 
   {{0x69a6902f,0x677e4179,0x83788008,0x41fd20a9}},	//   _尊重网上道德_, _ekološku_, _nazarda_, _स्वयंपाक, 
   {{0xe27e72e8,0xd3801180,0x4c9250cf,0xbf69b261}},	//   _rinne_, _naprej_, _संभोग_, _nezavisn, 
   {{0x72912270,0xf27ec3c3,0x92b4b1eb,0x0beec098}},	//   _olyan_, _endnu_, _efecte_, _набор_, 
   {{0x5a07418a,0xa2005100,0xbe47e04c,0xea5d2177}},	//   _somaliya_, _illik_, _кишинэу_, _tapúla_, 
   {{0xad8911c7,0x82bbd07a,0x19113124,0x949cc072}},	//   _primerja, _geheime_, _najavlju, _элине_, 
   {{0x5641019b,0xc2d4e1f9,0x727f91b0,0xc200c1da}},	//   _zanimlji, _filohan_, _bosni_, _polita_, 
   {{0x27fea02f,0xb2c4a194,0x067810f9,0x4c18e341}},	//   _的所有作品_, _normalt_, _мамандық, _xarakter, 
   {{0xcbb47148,0x62d811c8,0xe26c801f,0xe351531d}},	//   _reagovať_, _behet_, _jakoba_, _हथेली_, 
   {{0x71fa303c,0x5248f191,0x5f6400f1,0x43f961c8}},	//   _詳細はこちら_, _dekorasi_, _belastin, _sigurt_, 
   {{0x6207c092,0x2c61022f,0xc2cad0bc,0x87e02059}},	//   _mimořádn, _berusia_, _golder_, _फेवरेट_, 
   {{0xe2cad069,0xb3340017,0x72d8c049,0x2f0ef233}},	//   _mindig_, _באריאל_, _bedew_, _chạnh_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x2cec4152,0x529261b0,0x72b5804d,0x42d8f1da}},	//   _колыбель, _zgrade_, _parce_, _behera_, 
   {{0x9f3f4150,0x0eb45171,0xe0345065,0xb5172182}},	//   _kristiya, _receptes_, _receptek_, _pristato_, 
   {{0xc5a8c261,0xa200309f,0x2af4c2f8,0x0386b1cb}},	// [d60] _preporuk, _kojih_, _hieronde, _andrei_, 
   {{0xa354a006,0xe38691e3,0x52f74075,0x27c42352}},	//   _effects_, _ugari_, _কখনোই_, _הרועים_, 
   {{0xc3946392,0xbc6a20cc,0x81123197,0x02a831fb}},	//   _phost_, _darrell_, _pravdepo, _متوقف_, 
   {{0x327ed03d,0x25165287,0xbb8e5017,0x27a3510a}},	//   _piena_, _शब्दात_, _אסיאתיות_, _внатрешн, 
   {{0x1fb231c4,0xcac03015,0xd84a3079,0x429180e6}},	//   _مدفون_, _обично_, _актуалэ_, _bazaru_, 
   {{0x927ed0fd,0xdf6ea046,0x31c37091,0x334c1380}},	//   _viena_, _kiểng_, _nastavak_, _futebol_, 
   {{0x92fc9263,0xb2cae0ce,0xd3dc91bf,0x127f0104}},	//   _mbaga_, _maidin_, _mbawa_, _standi_, 
   {{0x3f0ef3a3,0x0aaf30c8,0xec782113,0x65ba3010}},	//   _thạnh_, _정상적으로_, _persoal_, _معامله_, 
   {{0xb074703c,0xf3dc910d,0xa2b6737e,0x26b8801a}},	//   _redaktio, _obawa_, _marcas_, _берудің_, 
   {{0x40871121,0x527e9057,0x59e091cb,0x3f277024}},	//   _نداشته_, _inani_, _аскулте_, _सरबजीत_, 
   {{0x42907177,0xe8d05181,0xb225900c,0x126cc037}},	//   _ionad_, _पश्चात_, _raske_, _colore_, 
   {{0x1840d045,0xc26d8065,0xcf162004,0x43958385}},	//   _بخصوص_, _piros_, _застой_, _kursy_, 
   {{0x92259193,0x42fdf109,0xf95f1069,0xd386e296}},	//   _paske_, _diugh_, _پیشکش_, _jufri_, 
   {{0x62bf0039,0x8fa32008,0x32805071,0x00000000}},	//   _اموات_, _дорбози_, _brakuje_, --, 
   {{0x23f4628d,0xa5ee2337,0x7f20e0b3,0x4e394031}},	//   _girtin_, _condició, _zateplen, _esportes_, 
   {{0x30081155,0xeb3690a5,0xf0472127,0x00000000}},	//   _בעקבות_, _isključi, _тақозо_, --, 
   {{0x6d8ac19c,0x13076300,0xf761c119,0x00000000}},	// [d70] _ввести_, _tembang_, _вверх_, --, 
   {{0xc3954106,0x6b1fa070,0x5d0ea052,0x254ec008}},	//   _miesto_, _sekalian_, _otroligt_, _кимни_, 
   {{0xe8d9601e,0xf3f470de,0x7fe801ad,0x958a30c8}},	//   _해외부동산_, _listan_, _विचारों_, _아르바이트_, 
   {{0x226d9182,0x727ee119,0x17556087,0xc2d8f211}},	//   _visos_, _toinen_, _učinkovi, _legea_, 
   {{0x427e7050,0xada6c17e,0x6d1ae0f8,0xf29050b4}},	//   _linna_, _планинат, _মালয়েশিয়, _nolak_, 
   {{0xdeab900f,0xe5187076,0x1e390166,0xafe7a06b}},	//   _rekommen, _картинка, _separata, _приват_, 
   {{0x0201c1c3,0x5349f095,0x5667b3b8,0x12bf105f}},	//   _devid_, _spremni_, _भीमसेन_, _دمياط_, 
   {{0x8e327170,0x4dbe111d,0x6394e287,0x5e7c1099}},	//   _kualitas_, _hdvietna, _ponsel_, _मौर्य_, 
   {{0x228b2106,0xf7cba2ca,0x12267023,0xb27e00b8}},	//   _poslať_, _skupštin, _keskin_, _niini_, 
   {{0x02cae04f,0x1d8970e8,0xab9cc25f,0x4df421e9}},	//   _zonder_, _seumpama, _lantmäte, _екскурсі, 
   {{0xb2c55100,0x2341001b,0x00000000,0x00000000}},	//   _qədim_, _vegerin_, --, --, 
   {{0xdeb5629d,0xf26da0d1,0x91456006,0xe62d8045}},	//   _especies_, _tipos_, _especial, _sainchei, 
   {{0x601f30a3,0x426ca0c2,0x4a5981d7,0x73111079}},	//   _najboljš, _sabot_, _nereikia_, _абсолв_, 
   {{0xf2475287,0x93169042,0xf3105099,0xe27e71f1}},	//   _जंगलं_, _praza_, _pracuje_, _finna_, 
   {{0xc26c80ee,0x79da8045,0x9e41e146,0xb80a2057}},	//   _eskola_, _upalenia_, _garantit_, _electrog, 
   {{0x92efc0c0,0xe200503f,0x32914074,0x3e1070b0}},	//   _familja_, _kolik_, _vidaus_, _trắng_, 
   {{0x7c7cd0fd,0xdbddd1f7,0x970d80c8,0x8fae117e}},	// [d80] _вылет_, _बतिया_, _이용자에게_, _новогоди, 
   {{0x026c8116,0x92cae2f7,0x2186207d,0xfd1ba04f}},	//   _iskola_, _sonder_, _економік, _openbare_, 
   {{0xa3b2608b,0xc2fcd019,0x00000000,0x00000000}},	//   _marque_, _blogit_, --, --, 
   {{0xc5a10138,0x904511d0,0xcc01c08b,0xb30dc05a}},	//   _الاضحى_, _estudyan, _laisser_, _binalar_, 
   {{0x83ac11ee,0xc8c842a0,0x63a82024,0x00000000}},	//   _éppen_, _flutning, _युटिलिटी, --, 
   {{0x5a57c122,0x36967134,0xf562801e,0x2236609f}},	//   _паланги_, _accessoi, _때문입니다_, _broju_, 
   {{0x235bf2f1,0xd2558148,0x63ea0131,0x5ea4c17f}},	//   _amerîkî_, _problémo, _emiti_, _атентату, 
   {{0xa386d032,0x8d99d1b5,0x00000000,0x00000000}},	//   _storia_, _победила_, --, --, 
   {{0xcc5c5075,0x93ee0034,0x31695098,0xceb0a0d1}},	//   _তীব্র_, _dettagli_, _itsensä_, _diversas_, 
   {{0xe68b8092,0x8eb0e078,0x52d8215c,0xf320c1ac}},	//   _kancelář_, _tolerans_, _beker_, _fodya_, 
   {{0x53785138,0x7c1411b1,0xe2026168,0x72cea37f}},	//   _مواليد_, _segurtas, _purine_, _utrolig_, 
   {{0x727ed23d,0xa7167035,0xdb6de0c8,0x720050bf}},	//   _vieno_, _固定リンク_, _우리나라의_, _tolik_, 
   {{0x32d8a0b4,0xf96242f8,0x2248d01e,0x23ead045}},	//   _kebek_, _retourne, _neemt_, _moltar_, 
   {{0x9a06302f,0xa5f39015,0xee472344,0x00000000}},	//   _下一篇文章_, _болести_, _localida, --, 
   {{0x9f52b0a5,0xc950314e,0x42d8d316,0x7b80336a}},	//   _držač_, _negociat, _malemu_, _negociac, 
   {{0xa10b01de,0x0f2c121c,0x298ec079,0x62e8e1a0}},	//   _مہربانی_, _allerdin, _паник_, _polisin_, 
   {{0x327e7104,0x62d8208d,0x39c6e047,0x4e4ec147}},	// [d90] _sinni_, _seker_, _कराची_, _чанде_, 
   {{0x127ed0fd,0xf9aa1053,0x030c3083,0x3a343035}},	//   _pieno_, _mendakwa_, _malakas_, _ミッション_, 
   {{0xd25ad0af,0x129040f3,0x024900c4,0x88068084}},	//   _emele_, _moman_, _dramor_, _клеткала, 
   {{0x34652116,0xab03f01e,0x62902065,0xff3a20a7}},	//   _referenz, _일반적으로_, _sokan_, _profilin, 
   {{0xe349805d,0xa2d8a253,0x9863c14c,0xd290a138}},	//   _aspetti_, _bebek_, _покажи_, _albam_, 
   {{0x52fd72aa,0x1290907a,0x826cc1a3,0x45f20155}},	//   _fragen_, _plaas_, _gados_, _permissi, 
   {{0xc24982c8,0xd38601a9,0x4c5fc2b3,0x52a35113}},	//   _terma_, _nairn_, _systeem_, _procedem, 
   {{0xe2d980a9,0x27931030,0xa5879069,0x22aa6044}},	//   _keren_, _софией_, _horoszkó, _dioddef_, 
   {{0x1200403b,0x9507d0c8,0xf29040b9,0x1284317d}},	//   _komin_, _helemaal_, _koman_, _archivo_, 
   {{0x1e70f0e6,0x1055c13a,0x72d980db,0x1099c0cd}},	//   _चित्त_, _sagatavo, _deren_, _радиация, 
   {{0x526cc1ab,0xb195c0fd,0x5b27d063,0xab846117}},	//   _dados_, _членам_, _nawbbbbb, _transfor, 
   {{0x2386d087,0x284b003c,0xc290011d,0xc386d1e3}},	//   _skoraj_, _sommerhu, _uniad_, _ageri_, 
   {{0x32497057,0xd587702b,0x13a2c151,0xce41f0f6}},	//   _ijambo_, _autorský, _propre_, _zalantza, 
   {{0x137b02c0,0x32fd813b,0x1655d043,0x0225f0fd}},	//   _citando_, _wargi_, _рейтингу_, _lauko_, 
   {{0x4589e193,0xadca30f7,0xd3f84010,0xff39e092}},	//   _televizy, _начальни, _semut_, _televizn, 
   {{0xe26ce026,0x82926081,0xf30c207a,0x52d980e6}},	//   _manoma_, _gatatu_, _onlangs_, _beren_, 
   {{0xf2d991ce,0xfcaf8008,0xaaf5213d,0x0200d134}},	// [da0] _lesen_, _қочқинла, _astudiae, _plein_, 
   {{0xd27ed034,0xc3a7a0b5,0x398b40e1,0x827b711f}},	//   _viene_, _фронту_, _uveče_, _podijeli_, 
   {{0x92d840b2,0xa049d0cd,0x13043150,0xc540b1ab}},	//   _temes_, _радикалд, _marahil_, _nirkabel_, 
   {{0xd96273c4,0xb27ed1b9,0xcc00b173,0xf2489225}},	//   _व्यवस्था, _tiene_, _ameskas_, _itama_, 
   {{0x727e0117,0xc04ec079,0x00000000,0x00000000}},	//   _china_, _афлэрий_, --, --, 
   {{0x927e6345,0xf2d84171,0xb2904193,0x626d10b3}},	//   _khong_, _zemes_, _goman_, _sobotu_, 
   {{0x6faeb08f,0x026e70c1,0xf32002f1,0xe0e8f0a4}},	//   _совершен, _parovi_, _aniye_, _oprindel, 
   {{0x2b9570aa,0xc8eed05f,0x00000000,0x00000000}},	//   _sevindir, _تصحيح_, --, --, 
   {{0x9200c0f1,0xa3782045,0xb290d262,0x6599426f}},	//   _nodig_, _بينما_, _solais_, _настроен, 
   {{0x8c18e032,0x92d98068,0xe2d8c2cc,0xcf393024}},	//   _caratter, _veren_, _sedem_, _बेटियों_, 
   {{0x7d89407d,0x12d990a0,0x00000000,0x00000000}},	//   _харчуван, _nesen_, --, --, 
   {{0xd6013138,0x298a80c7,0xa25b7196,0x4eb451c5}},	//   _هندسة_, _müraciət_, _dialed_, _recettes_, 
   {{0x6d44f26d,0x7c17d043,0xd68b21b1,0x4f071106}},	//   _अतिरिक्त_, _правил_, _lizentzi, _dispozíc, 
   {{0x72d981c5,0x0c53612c,0xee35125d,0x89a680cd}},	//   _prendre_, _मैसेज_, _millones_, _орусия_, 
   {{0x03498116,0xe2c4a138,0xbecf00b0,0x33946230}},	//   _esperti_, _aisling_, _cuộc_, _akosi_, 
   {{0x62cad285,0xd692006e,0x9a8fc0fe,0x626c3155}},	//   _mindre_, _statysty, _demikian_, _almost_, 
   {{0x0d6f31d2,0xee4e310e,0x85eed156,0x99e931c3}},	// [db0] _commenta, _antanana, _апартаме, _mainidea_, 
   {{0x291e5033,0x541bc19c,0xa872c249,0x63f941da}},	//   _ग्रहमान_, _скільки_, _могући_, _baduzu_, 
   {{0xb2a6d0ee,0x3b6a8096,0x00000000,0x00000000}},	//   _greba_, _corazón_, --, --, 
   {{0x53f462ec,0x7af3c140,0x5273c140,0x00000000}},	//   _portal_, _napravit, _napravil, --, 
   {{0x75bb4075,0xdddc305f,0x31cd81b6,0x00000000}},	//   _গবেষণা_, _الضوء_, _fransayê_, --, 
   {{0x77e270f0,0x04d1a03a,0x348190a2,0xf1667280}},	//   _respubli, _प्रतापगढ, _नानाजी_, _футболис, 
   {{0xce2cc195,0x8ecf91c1,0x53dcb005,0x42903195}},	//   _млади_, _socijaln, _kosmetyk, _lojas_, 
   {{0x13ead04c,0x826de182,0xfb2f835e,0x6527a08f}},	//   _dintre_, _kitos_, _историче_, _кажется_, 
   {{0xc22ac147,0x926c8246,0xb863c17e,0x00000000}},	//   _додан_, _uskoro_, _домати_, --, 
   {{0x72a69162,0x82d85285,0xe6905162,0x00000000}},	//   _prabu_, _deler_, _brawijay, --, 
   {{0xf2bb81b5,0xd344b09a,0x3d8672d6,0x89668035}},	//   _nedelje_, _murenge_, _तस्करी_, _注文した商品はど, 
   {{0x3127c11b,0x03f8c095,0x33bdc164,0x8d6001de}},	//   _давоми_, _odluka_, _drevnih_, _قادیانی_, 
   {{0x0378804b,0x8c77a0a6,0x5bdd9075,0x5c28c138}},	//   _kenalan_, _versand_, _ব্যথা_, _سيدنا_, 
   {{0x32d99174,0x3316725a,0x22d8d21d,0x724a71e6}},	//   _pesen_, _hanze_, _idiomas_, _vermek_, 
   {{0x329e1034,0xbe2bd34c,0xdb990076,0xae41607d}},	//   _китай_, _बर्बादी_, _заплатит, _relativt_, 
   {{0xe68c70e6,0x92905166,0x16e8b015,0x94d630c5}},	//   _बिहान_, _allat_, _карактер, _दाखिला_, 
   {{0x84d770c3,0x011090b3,0x026de03d,0x03877104}},	// [dc0] _ענציקלאפ, _techniky_, _citos_, _starfa_, 
   {{0x031d72e4,0xcb82214c,0xa8695160,0x715c2072}},	//   _percuma_, _късно_, _procedūr, _куран_, 
   {{0x0da2b04a,0xa386b11d,0xc290532f,0xd34fa245}},	//   _terraced_, _androi_, _ellas_, _alafang_, 
   {{0x34191030,0xf1633191,0xecd3b074,0xfe75216e}},	//   _престижи, _بامزه_, _сценах_, _počelo_, 
   {{0x7d22e17e,0x32f23015,0xc9fb6039,0x00000000}},	//   _pagsegur, _letovanj, _ellentét, --, 
   {{0x275fa0c5,0x0a6b4199,0xbc242069,0x00000000}},	//   _विख्यात_, _domény_, _کروڑوں_, --, 
   {{0x0ea740d2,0xab89201a,0xf366a128,0x5615e1fd}},	//   _mysliman, _процесте, _hinggil_, _balorazi, 
   {{0xb236029c,0xf640b069,0x946e202f,0xf122d0a5}},	//   _prijs_, _جاسکتا_, _国家税务总局关于, _privatno, 
   {{0x47e760a9,0x6f397296,0x023f7065,0x8200513e}},	//   _स्वरूप_, _terutama, _kalkulát, _rolin_, 
   {{0x227e911d,0x32647106,0x17f33002,0xddb7301a}},	//   _khang_, _poslal_, _त्रिशंकु_, _неміс_, 
   {{0x7c481355,0x4507b0eb,0x62d9f09c,0x8af9f0f1}},	//   _अधिनियम_, _кредита_, _dienste_, _diensten_, 
   {{0xb200b09f,0xd2979006,0x87292122,0xc2d990b4}},	//   _jedini_, _התקנת_, _корро_, _kesel_, 
   {{0x72fcc0c8,0xc200d033,0x31e9b0f1,0x00000000}},	//   _hoogte_, _miliar_, _assortim, --, 
   {{0xd27ea09f,0xa118f02f,0x6c89b0a4,0x5e72116a}},	//   _jednog_, _您的汇款已收到_, _samtidig_, _वृद्ध_, 
   {{0x1642f03c,0x02907003,0xacb7b16b,0xe094402f}},	//   _最近の記事一覧_, _konan_, _границу_, _互联网上网服务营, 
   {{0x42d961e0,0x7291b00d,0xc386d006,0x25c1201a}},	//   _segera_, _omwana_, _sports_, _тапқан_, 
   {{0xdc6270a5,0x10e0c26f,0xd387717e,0x42dd8232}},	// [dd0] _preuzeo_, _снова_, _quarta_, _imposti_, 
   {{0xa905a1da,0x631d9016,0xa394e1c6,0x9d984079}},	//   _eztabaid, _פינחס_, _consum_, _dragoste_, 
   {{0x6c499043,0x99d070f6,0x72d96060,0xd2f04212}},	//   _ремонту_, _telebist, _vegera_, _malinzi_, 
   {{0x22005164,0x2e96302d,0xa2d8c261,0xa7bbe195}},	//   _molim_, _chempion, _jelena_, _останати, 
   {{0x34652146,0x09c52155,0x1ff76121,0xf127c15d}},	//   _internaz, _internat, _بازسازی_, _бакиев_, 
   {{0x127b42d1,0x727ed0fd,0x7290503b,0x9200503b}},	//   _komentár, _diena_, _allar_, _allir_, 
   {{0x52ca92f1,0x41fe1155,0x3ece108b,0x4b0731eb}},	//   _amade_, _environm, _environn, _кечээ_, 
   {{0xeb369095,0xd27860ba,0x038710c3,0x930761cf}},	//   _zaključa, _mbunge_, _נייַעס_, _lembang_, 
   {{0xc2d870b2,0x6fe3d069,0x7a6bc19e,0x9587736f}},	//   _gener_, _لاپتہ_, _свежие_, _autorské, 
   {{0x33ac608c,0x4d0b20a7,0xd200513d,0x620c81e8}},	//   _trupin_, _metrekar, _ellir_, _adicioná_, 
   {{0x4d0ad158,0x72eaa262,0xf2fcd0ba,0x61ef70b3}},	//   _učlanjen_, _daniell_, _mbegu_, _brigády_, 
   {{0xbb50b13c,0xa330b13c,0x00000000,0x00000000}},	//   _endamên_, _endamê_, --, --, 
   {{0xf4b2226d,0xfbf381c6,0x44131289,0x72e2120d}},	//   _कनाडा_, _celebrac, _посета_, _valitud_, 
   {{0xf20040a6,0x7329e068,0x00000000,0x00000000}},	//   _somit_, _psikoloj, --, --, 
   {{0x927b41a4,0xc29041a9,0x72018063,0xf29260ee}},	//   _comentár, _comas_, _hnyiab_, _estatu_, 
   {{0xd2caf137,0x3695136f,0x1c3e31e8,0xfd5570ff}},	//   _pridal_, _oddeleni, _затворен_, _şəhid_, 
   {{0xf320630c,0x630d21a0,0xd2011095,0xbd15307d}},	// [de0] _aloys_, _balalar_, _odbili_, _футболу_, 
   {{0x28a92139,0x2d09302a,0x00000000,0x00000000}},	//   _stratégi, _конце_, --, --, 
   {{0xfae30002,0xd8971138,0x63693285,0xb4882047}},	//   _postimee, _قريبا_, _mangler_, _gwarancj, 
   {{0x72d871a5,0x0055c2b3,0xb84712ea,0x329710e8}},	//   _bener_, _verantwo, _зарари_, _dikasihi_, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --, 
   {{0x5eac20cc,0x6472905f,0x4a7991ca,0x79e6f019}},	//   _cysteine_, _áiteanna_, _долларга_, _harrastu, 
   {{0xa863c01a,0xe3dd809d,0x323f902b,0x00000000}},	//   _телефонд, _glywed_, _čokoládo, --, 
   {{0xf37b4044,0x92d871f2,0xedb6e20f,0x6fc350e5}},	//   _wahanol_, _tener_, _barrachd_, _horoskoo, 
   {{0xe9ec51e3,0x52889008,0x3a8871e1,0x82ba8200}},	//   _donostia_, _манбалар, _inginkan_, _kodeord_, 
   {{0x192850cd,0x23f8a004,0x525b000c,0x9aaee378}},	//   _партиясы, _nebus_, _avalik_, _forvente, 
   {{0x998e0204,0x5378a1a7,0xb9ae0160,0x2248f12f}},	//   _машин_, _bekalan_, _privātum, _primar_, 
   {{0xb27ed00e,0xaa0ff02f,0xde3980a9,0x4a46b0f0}},	//   _pieni_, _没收违法所得_, _penasara, _режиссёр_, 
   {{0x9f21023b,0xc2499390,0x724970f4,0x3395f171}},	//   _dipersen, _pesme_, _abamwe_, _kausa_, 
   {{0xe2483116,0x127ed0fd,0xf9294121,0x3c891015}},	//   _nemmen_, _vieni_, _آلومینیو, _различит, 
   {{0x7739c0a8,0x89a79075,0xe200c023,0x737f8009}},	//   _esportiv, _বগুড়া_, _moliya_, _seharga_, 
   {{0xd29052c8,0xda1620c1,0x615e02a0,0x93eb40ab}},	//   _solat_, _zadataka_, _morgunbl, _lietot_, 
   {{0x3c694092,0x45c81043,0xd3eb71b0,0x0355906c}},	// [df0] _kultury_, _благодій, _vratio_, _leveres_, 
   {{0xe2d85046,0xc2a600cc,0xa2ba7053,0xe3869108}},	//   _telex_, _naiba_, _mendaki_, _orari_, 
   {{0x534100f6,0xa73350b3,0x703100f6,0xa2020037}},	//   _berezia_, _absolvov, _bereziak_, _capire_, 
   {{0x7c6bc33a,0x7e428008,0x6200b008,0x00000000}},	//   _चित्रण_, _нотўғри_, _oldida_, --, 
   {{0x17b3b00c,0x92a600cc,0xd409e275,0xe979b052}},	//   _प्रधानम्_, _kaiba_, _बाबासाहे, _bransche, 
   {{0x7a7f001e,0xd3875191,0x3d0603c5,0xb2905191}},	//   _입주가능일_, _باردار_, _aparecer, _rolas_, 
   {{0xa7f9512a,0xc290c1ad,0x42d8a153,0x00000000}},	//   _протести, _podaj_, _debes_, --, 
   {{0xc5a79075,0x52da7183,0xabdd31f7,0x5373a09f}},	//   _ভৌগলিক_, _bereik_, _बढ़िया_, _domaće_, 
   {{0xf2d9c006,0xcfc23069,0x8c07b171,0xea1620ba}},	//   _level_, _ناموں_, _personu_, _madaraka_, 
   {{0x9481c3c6,0xb27e70e5,0x4a3de1be,0xd27b40b3}},	//   _बाबाजी_, _kinni_, _मज्जा_, _momentál, 
   {{0x739fc045,0xa1c531ad,0x627ef03b,0x00000000}},	//   _إصدار_, _sklepach_, _erindi_, --, 
   {{0x7c1ad00c,0xd27e72a0,0xa26d806d,0xf2ba7083}},	//   _चुनौती_, _minni_, _zarok_, _sandali_, 
   {{0x2fc42016,0x1386c17d,0x726df36a,0xb2009063}},	//   _מנהיגים_, _madre_, _estos_, _hlais_, 
   {{0xa4013065,0xd2d8c039,0x98fe40c8,0xc201a0b4}},	//   _آئندہ_, _elleni_, _프로그램을_, _ampir_, 
   {{0x9be9024d,0xc29050ce,0xac86802f,0xa248c07a}},	//   _अमेरिकी_, _solas_, _中签号公布_, _jammer_, 
   {{0x327e60bc,0x4dc4d147,0xd5f87336,0x6c1bf053}},	//   _khona_, _оянда_, _रातोरात_, _didaftar, 
   {{0x5fe510aa,0x13f86247,0x00000000,0x00000000}},	// [e00] _dostları, _lulug_, --, --, 
   {{0xb25a9179,0xb27ed13a,0x32907392,0xa108c12f}},	//   _imala_, _dienu_, _ionas_, _asistenţ, 
   {{0x226c10cb,0x46d742fd,0x75b1a006,0xaa9ca38e}},	//   _schon_, _sporočil, _בדואר_, _talijans, 
   {{0x19e53080,0xd318d053,0x6248c1ee,0xce0ed1ce}},	//   _resultad, _gemilang_, _filmek_, _terengga, 
   {{0x994e819e,0x92fd8115,0x4318f148,0xec05e01a}},	//   _mielipit, _margi_, _zavrieť_, _оқулық_, 
   {{0x4f164177,0x12858247,0x527f000d,0x4ad8602a}},	//   _راسلنا_, _limhiam_, _erangi_, _основной_, 
   {{0x6e2fa182,0x7be33191,0xd02e0044,0xf6ae0044}},	//   _autorius_, _دامپزشکی_, _arbenigo, _arbenigw, 
   {{0xf2bf6082,0xb200f148,0x9386a191,0x5f7e50fb}},	//   _yardım_, _meniny_, _پایدار_, _полициян, 
   {{0x2e7263b6,0x0312b068,0xb59bd033,0x1b89702d}},	//   _इंद्र_, _serbest_, _dibutuhk, _бағдодда, 
   {{0x6200a140,0xe3436198,0xc27ed188,0xc2836069}},	//   _dobio_, _livello_, _ikonas_, _miskolc_, 
   {{0x325a90f4,0x9f1161f3,0x1b1e5156,0xe1316288}},	//   _amala_, _contrata, _понеделн, _contrato, 
   {{0xf329c0c8,0x972e40de,0x92eb1004,0xeacb7285}},	//   _개인정보관리책임, _exklusiv, _turizmo_, _sommeren_, 
   {{0x312d2147,0x8f2da017,0xb2909062,0x427f014c}},	//   _марти_, _determin, _klaar_, _grandi_, 
   {{0xa2d9e013,0xc8de5034,0x15d2f220,0x00000000}},	//   _veten_, _приказки_, _újdonság, --, 
   {{0x826d11eb,0xb2d9e0c8,0x72ca0160,0xcf1590fe}},	//   _escola_, _weten_, _veida_, _mendatan, 
   {{0x9394d08c,0xe03e80b2,0x15c1a022,0xd4ca30fb}},	//   _pjese_, _эмоция_, _sevirəm_, _бизнесте, 
   {{0x826dc0b1,0xa27ed2b3,0xf6b8d0fd,0x73f401ed}},	// [e10] _davom_, _dient_, _разраста, _testar_, 
   {{0xd27ed370,0x2c7d617e,0x8d0210c8,0x00000000}},	//   _vienu_, _последна, _알고싶어요_, --, 
   {{0x12fca023,0xd3ea9110,0xf30ca023,0xffc7902c}},	//   _harakati_, _amati_, _harakat_, _ранняя_, 
   {{0x84a4407b,0xb2907109,0xa1b99006,0xe355a045}},	//   _neobmedz, _annad_, _מחלקת_, _referer_, 
   {{0xd2d9b01b,0x62d8b20a,0x03559199,0x6b9cf00b}},	//   _devera_, _veces_, _plastové_, _nyandiko_, 
   {{0xe518323d,0x45a08033,0x00000000,0x00000000}},	//   _славянск, _वाढते_, --, --, 
   {{0x1d3f612f,0x3200a087,0x120112fd,0xf3f88110}},	//   _juridice_, _dobil_, _vozil_, _kukuwa_, 
   {{0xa379609f,0x1afe41aa,0x127ef0e5,0x00000000}},	//   _pitanja_, _nghịch_, _prindi_, --, 
   {{0xae96a155,0x03f8713d,0x42732119,0xc136a092}},	//   _students_, _munud_, _tänne_, _studenty_, 
   {{0x3734003c,0x43636255,0xea8ff124,0xa292720f}},	//   _お役立ち度_, _sungguh_, _odličan_, _parant_, 
   {{0xd200c204,0xe236701f,0x42907240,0x00bfc11b}},	//   _kodin_, _manjo_, _konar_, _elementl, 
   {{0xb386d1dd,0xf86d2045,0x90663008,0x00000000}},	//   _ouers_, _scriosad, _samarado, --, 
   {{0xd29070fb,0x427eb186,0xdf571118,0xe2d80017}},	//   _donar_, _odense_, _merginos_, _tried_, 
   {{0x9290b017,0x87c743aa,0x29459039,0xba074137}},	//   _local_, _pripravi, _pillanat, _pripravu, 
   {{0x489fa07d,0x7c369075,0x925ad196,0xe387425d}},	//   _компанії_, _সমালোচনা_, _amele_, _padres_, 
   {{0x6cfa60eb,0x441d2292,0x96cec27b,0xcfaf7151}},	//   _придружи, _horietak, _bulabili, _请及时与我们联系_, 
   {{0xbe466288,0x5e36c197,0xc7bde0ab,0xf6d93044}},	// [e20] _finalida, _stravova, _patiesīb, _humphrey, 
   {{0xa200c02b,0xf26e1042,0xbd84a06c,0x12ce6017}},	//   _hodin_, _época_, _hotellet_, _removed_, 
   {{0x975be066,0xf20250dc,0xd3648171,0x00000000}},	//   _मुस्कान_, _rutile_, _atkritum, --, 
   {{0x126e61da,0xf54a9034,0xb27e91ea,0xd3ea0380}},	//   _kirola_, _обстанов, _khana_, _jeito_, 
   {{0x33f9a010,0xb3ead012,0x7c75f36e,0xea380151}},	//   _sepuh_, _voltar_, _मुक्तक_, _国家邮政局_, 
   {{0x20d5301a,0x425b0036,0xa2014004,0xf23671f9}},	//   _журналы_, _maalum_, _sveiki_, _nanjo_, 
   {{0x02cf8106,0xc3c08069,0x52cbb02f,0xc252101a}},	//   _podobne_, _رینجرز_, _对最佳答案的评论_, _неғұрлым_, 
   {{0x8a06d02f,0x9378d068,0x0202605d,0x00000000}},	//   _上一篇文章_, _tamamen_, _ferita_, --, 
   {{0xd2903087,0x239661d7,0xd3b26042,0xa2d8c0a6}},	//   _pomaga_, _verslo_, _parque_, _jeder_, 
   {{0x0eae1054,0x8983d079,0x92907050,0x69dc4297}},	//   _syarikat_, _модерне_, _annab_, _bikervie, 
   {{0x43877124,0x9c193145,0x3292609a,0x6cdaa072}},	//   _udario_, _polovicu_, _batatu_, _өркүндөт, 
   {{0x72d801f2,0x66e97035,0x00000000,0x00000000}},	//   _quien_, _プレゼント_, --, --, 
   {{0x1eead121,0xff53d289,0x13860304,0x0eee7035}},	//   _خسروی_, _домашно_, _chiri_, _すべて表示_, 
   {{0x51772147,0x603850da,0xf08ae004,0x8292631b}},	//   _нести_, _vestmann, _psicholo, _watatu_, 
   {{0xbc56b1fc,0x93ea022d,0x1b9621df,0x92c6b1b0}},	//   _postove_, _feito_, _научни_, _poslove_, 
   {{0xe93f300e,0xb5ef300e,0xcf8f300e,0xb2df3065}},	//   _kommentt, _kommenti, _kommento, _kommentj, 
   {{0x4503d1ee,0x93974088,0xc9f74052,0x96c741e9}},	// [e30] _خارجہ_, _samarbej, _samarbet, _samarbei, 
   {{0x127e027a,0x146f4010,0x93f9e173,0x02d8e1e6}},	//   _maint_, _استعداد_, _metub_, _nefes_, 
   {{0xb9f2b00f,0xd0da60eb,0x00000000,0x00000000}},	//   _startsid, _радикалн, --, --, 
   {{0xe3860316,0xb3ea012d,0x847da019,0x1c6c311a}},	//   _phiri_, _xeito_, _животные_, _forumul_, 
   {{0x52ca002c,0xd18e60b1,0x007170f5,0x2adf50cb}},	//   _veido_, _yaratish_, _norapamo, _eintrage, 
   {{0x66276081,0x496760e9,0x8b9763c7,0x12026004}},	//   _minisiti, _minisite, _minisitr, _turime_, 
   {{0x0a0f61fc,0x1e4f6164,0x200610c3,0x328f616e}},	//   _stranica_, _stranice_, _כינעזער_, _stranici_, 
   {{0x6f68e251,0x420121d0,0x8035a1e4,0x731001c4}},	//   _zdravotn, _orbitz_, _santayan, _észak_, 
   {{0x427ef14c,0x3ed4e182,0xd2ef803a,0x425b433b}},	//   _quindi_, _socialin, _पदार्थों_, _spelen_, 
   {{0xa9dcc1ad,0x12eb012a,0x023640a9,0xd3eae030}},	//   _zabezpie, _diritto_, _namja_, _suntem_, 
   {{0xdf210009,0xb18e50d2,0x22d7c105,0x2290c2fd}},	//   _kesulita, _parasysh_, _spiller_, _dodal_, 
   {{0x82a6407f,0x7616a204,0x5d7d510f,0x00000000}},	//   _hamba_, _путешест, _boşver_, --, 
   {{0x125a8224,0x52d8c196,0xf3864166,0xb6987297}},	//   _okolí_, _xaleke_, _kamra_, _careerli, 
   {{0xe27e6297,0x8afd8038,0xd2fca06f,0xa3311060}},	//   _phong_, _intervis, _wariant_, _encamê_, 
   {{0xda4d405f,0xa41a0175,0xfe15420f,0x3ed65087}},	//   _متّصلاً_, _prezeraj, _aigeanna, _jezikovn, 
   {{0x02d8f13d,0xf201e284,0x125ac0f6,0xac67b05b}},	//   _neges_, _altid_, _nullam_, _gebring_, 
   {{0xa7b8706e,0x8af87030,0x12d8c100,0x2c73a15c}},	// [e40] _regulami, _regulame, _qeder_, _sterker_, 
   {{0x80390049,0xb7dab05f,0x76bc205f,0xb9f8e006}},	//   _profesyo, _وعندما_, _لتحميل_, _paramete, 
   {{0xcc22f07b,0x50b8d12a,0x5aba0015,0x00000000}},	//   _skupiny_, _искат_, _proverit, --, 
   {{0x330761c6,0xc0672121,0xc2f3a08e,0x526c302a}},	//   _системас, _رفسنجانی_, _דרבנן_, _samoin_, 
   {{0x7290a30f,0x52247024,0x740d03c8,0x8483819e}},	//   _dobar_, _rynku_, _francouz, _kuluttaj, 
   {{0x0f264002,0xa2a640f2,0xd2909110,0x5fe0c0f8}},	//   _perekonn, _jamba_, _mukati_, _নাজমুল_, 
   {{0xa3ea900d,0x5340e324,0x72a670ef,0x7b6780e5}},	//   _amatu_, _ग्रूप_, _banbe_, _अइसने_, 
   {{0x42902164,0x78d7d030,0x0ac8816b,0xaf57d079}},	//   _nikad_, _низация_, _ресурса_, _армате_, 
   {{0x139cc03c,0x62ca029c,0x62da6151,0x55b6819c}},	//   _回答した人_, _beide_, _moteur_, _партії_, 
   {{0x98bb1236,0x29da51e3,0xd25ad1c7,0xbf2140ce}},	//   _minutter_, _ekologia_, _imela_, _ailtirea, 
   {{0x51111145,0x80f6802d,0x4ca43126,0x7200b02b}},	//   _projekty_, _қаттиқ_, _султон_, _pocit_, 
   {{0x49f94092,0xb79da032,0x5d0cd084,0x00000000}},	//   _externí_, _costruzi, _рында_, --, 
   {{0xb25a000c,0x611700ab,0x3b764045,0x00000000}},	//   _teile_, _publicēt, _sealadac, --, 
   {{0x7290d1e4,0x031ab151,0xa2d9810f,0x8ff3a0b3}},	//   _sleat_, _按作者搜索_, _yerel_, _netradič, 
   {{0x7290a1d9,0x7a89917e,0xa26d8092,0x00000000}},	//   _tobar_, _продажба, _parou_, --, 
   {{0x32fe6192,0x530da0f3,0x116af08c,0x00000000}},	//   _morgun_, _lavalas_, _respekto, --, 
   {{0xd522703a,0x53eb7300,0xc26c6041,0x726d83c9}},	// [e50] _प्रतिबंध, _obatan_, _npoos_, _sprog_, 
   {{0x02c362f8,0x437a63ca,0xbe29c17e,0x8291b1b6}},	//   _stellen_, _zadarmo_, _немало_, _kovara_, 
   {{0x442b2121,0x4eb32271,0x9c9201ab,0xdefdd05f}},	//   _مسنجر_, _aspectos_, _pitulung_, _الشغل_, 
   {{0x0b88002b,0xaa8831e4,0x7c5af12f,0x291730f7}},	//   _nemocnic, _schottis, _alaturi_, _грудень_, 
   {{0x72079282,0x5143405f,0x33ce209f,0x00000000}},	//   _רעננה_, _لمعرفة_, _kakvu_, --, 
   {{0xa321a0cc,0x4a34d016,0x467e7072,0xe477a02a}},	//   _kopya_, _לעיקוואד_, _батпаган_, _проекте_, 
   {{0x543181d7,0xe236219c,0xc8d43008,0x62a69039}},	//   _pasaulio_, _mykje_, _телефонл, _csaba_, 
   {{0xc3ea00a6,0xf290f09f,0x0da0118b,0x203c5015}},	//   _seite_, _mogao_, _diantara, _користећ, 
   {{0x725a0138,0x0a57712f,0xabf3b1d9,0xc693b1d9}},	//   _peile_, _biserica_, _aineolac, _aineolai, 
   {{0xc3fc5039,0xa4f8f1f1,0x2d43a1e8,0xa9ff02cc}},	//   _aktuális_, _наступни, _можност_, _poznania_, 
   {{0xc2025278,0xbd19f092,0x335fa199,0x53f46194}},	//   _fotiek_, _dekorace_, _kabelky_, _hurtig_, 
   {{0x420251a3,0xc15d6023,0x4200c13d,0x77491191}},	//   _notiek_, _manfaatl, _nodir_, _صبحانه_, 
   {{0x3f12e03c,0x00000000,0x00000000,0x00000000}},	//   _studeren, --, --, --, 
   {{0x8c39c045,0x13ea51a3,0x98acd035,0x6e9a6076}},	//   _بغداد_, _zelta_, _最新の日記_, _силиконо, 
   {{0x12cae29b,0x926df380,0x12903166,0xa489212a}},	//   _hendak_, _estou_, _armati_, _интервю_, 
   {{0x931321dd,0xa139502d,0x7290c350,0x7ef6315d}},	//   _probeer_, _таъминла, _bodas_, _жинсий_, 
   {{0xc291c0a5,0xceb8607a,0xbe2d902c,0x039663c0}},	// [e60] _novac_, _januarie_, _японец_, _turska_, 
   {{0x435e2040,0x3ccdb098,0x7b5f3195,0xa5c071a9}},	//   _lungsod_, _последне, _историја_, _ionadail_, 
   {{0x1f7d20a1,0x9342c113,0x42d8f09b,0x22d9a2b4}},	//   _израиль_, _facendo_, _ceger_, _jepet_, 
   {{0x9290c17e,0x237a0121,0xc2d8e2aa,0x00000000}},	//   _todas_, _seratan_, _offen_, --, 
   {{0x0ee29009,0xb4e8b05c,0x73f400a9,0xf027a0c3}},	//   _महत्त्वा, _планиран, _justru_, _נעבעך_, 
   {{0xb27e91c0,0xbea15116,0x286d0122,0xafe89024}},	//   _thang_, _fallimen, _шӯъбаи_, _हज़ारों_, 
   {{0x123a2087,0x99cf7093,0x81048075,0xf35f5024}},	//   _primeru_, _спортшыл, _কাছাকাছি_, _kolejny_, 
   {{0xd290f07a,0xe3f8d162,0x22025100,0xcb9c2161}},	//   _nogal_, _mudug_, _imtina_, _digiteac, 
   {{0xf3ac50b9,0xd2d8111d,0xf394b07a,0xd3ea5335}},	//   _souple_, _nghen_, _oudste_, _velta_, 
   {{0xc25a50c4,0x72d980a7,0x7ae67075,0xf9a37175}},	//   _wella_, _gerek_, _ঈদগাঁও_, _kuchyňa_, 
   {{0x937a2053,0xa1deb0f7,0x706d6043,0xe2d8f2aa}},	//   _lepasan_, _понеділо, _kompetan, _spielt_, 
   {{0x8eb6c098,0x517ab0e1,0xa27e9057,0x5d33b285}},	//   _профиль_, _прописан, _azana_, _menneske_, 
   {{0x52bf11ab,0x8687903f,0x90edb019,0xa36c7316}},	//   _املاک_, _खोटाङ_, _monipuol, _mangani_, 
   {{0x329111b6,0x024a70a8,0xe98d908e,0xc943a02c}},	//   _hozan_, _formes_, _וישלח_, _ансамбле, 
   {{0x824a71ca,0xf2d94171,0xd200b0a3,0x8290703e}},	//   _normes_, _rudens_, _nuditi_, _monat_, 
   {{0xd38b8270,0xa2787045,0x29d0809d,0xb79510cb}},	//   _három_, _karnar_, _ieithydd, _testberi, 
   {{0x93ce90ea,0x62015078,0x9741e0dd,0xc5ad80f8}},	// [e70] _chave_, _defini_, _основне_, _কারখানা_, 
   {{0xcc3960a9,0xcbc7d043,0x7ea49233,0x9c5d2195}},	//   _प्रयत्न_, _продажу_, _giftcode_, _postado_, 
   {{0xcdbc1006,0x23eb020d,0x13166131,0xe2912191}},	//   _בלייזר_, _alates_, _akoze_, _doyan_, 
   {{0x8e8a500c,0x33eb4079,0xe31740cc,0x00984016}},	//   _विपत्ति_, _pretul_, _namatay_, _אטמאספער, 
   {{0x29edc040,0xec82a0d5,0xe20cb3cb,0x4c0811c5}},	//   _disulfid, _havtsuag_, _uživo_, _fourniss, 
   {{0xc42cf20d,0x9200c023,0x32d98320,0xd26d800f}},	//   _मेंबर_, _sodir_, _cerek_, _varor_, 
   {{0x12d8613d,0x9e35e128,0x945d217e,0x00000000}},	//   _droed_, _karaniwa, _alteraçã, --, 
   {{0x3e2cc0e1,0x13ea003b,0x8f3503cc,0x66b500ff}},	//   _влада_, _leita_, _reportar_, _reportaj_, 
   {{0x215cc1ca,0x83a22282,0x183ce035,0x6e7d518b}},	//   _кулак_, _simple_, _産学官連携リンク, _मिक्स_, 
   {{0x6637a146,0xd2741282,0x3367a155,0x2b07c015}},	//   _programm_, _כניקראו_, _program_, _видели_, 
   {{0x52367029,0x234a106f,0xd3bbc045,0xb2d99060}},	//   _banja_, _telerau_, _فستان_, _kesek_, 
   {{0xaae51151,0x4c1831eb,0x366ff179,0x69184016}},	//   _由工商行政管理部, _дээрлик_, _voljenom_, _ראזענבער, 
   {{0xc3a2305e,0x7c50c138,0xe25a5019,0xb26da2b8}},	//   _tempoh_, _عندنا_, _kello_, _tapos_, 
   {{0x727c1015,0x8303713d,0x037c81fa,0x4bfbe14c}},	//   _играч_, _cymaint_, _kitaawe_, _dimentic, 
   {{0x86bc60e5,0x625a0104,0xe27f736a,0x42c941a9}},	//   _सत्तर_, _deila_, _blanco_, _tulloch_, 
   {{0x93874022,0x60d1f04c,0x00000000,0x00000000}},	//   _enerji_, _instituţ, --, --, 
   {{0xd15c7039,0xa96740f6,0xa3ea03cd,0x00000000}},	// [e80] _speciáli, _kalitate, _feita_, --, 
   {{0x32a621c5,0x215c7090,0x92d8c036,0x3903a017}},	//   _membre_, _speciáln, _kuleta_, _ואילו_, 
   {{0xab602142,0xd653d329,0x83ff6171,0x6d0cd004}},	//   _रोशनी_, _उपाधि_, _diezgan_, _выйду_, 
   {{0x49d0d166,0x5886e008,0xbf980016,0x5e9e30db}},	//   _interatt, _ташриф_, _צענזור_, _gestellt_, 
   {{0x847260bf,0xf303025b,0xbf2a713d,0xb8c5d230}},	//   _बस्ने_, _melawat_, _dystiola, _triumfov, 
   {{0xa2905068,0x22c9f0b3,0x4354a341,0xdc49307d}},	//   _kolay_, _nakonec_, _hereket_, _харківсь, 
   {{0x826c9095,0x0290102a,0x69b5d072,0x00000000}},	//   _školi_, _onhan_, _кыздын_, --, 
   {{0x6c7c802f,0xb236d087,0x0e18019f,0x4248615a}},	//   _贴子相关图片_, _svojem_, _бөтен_, _drome_, 
   {{0x34d663ce,0xe15cd1ca,0x82d8e02f,0x2fb4003f}},	//   _देखिये_, _кудай_, _effet_, _říjen_, 
   {{0x7afa70e5,0x21c79211,0xc291817e,0x6c05f1fb}},	//   _tingimus, _фидель_, _foram_, _pirsani_, 
   {{0x824801fe,0x62ec3023,0x00000000,0x00000000}},	//   _arimo_, _улкан_, --, --, 
   {{0xb290002a,0x7386c334,0x0dda9087,0x13ce71eb}},	//   _liian_, _cadre_, _soglašat, _canvi_, 
   {{0xb7b8629c,0xe3ea7014,0xc2cd6122,0xb8fdd108}},	//   _natuurli, _venta_, _тақрибан_, _доказате, 
   {{0x92d83105,0x6e38211a,0x2290e1a9,0xb2ca7049}},	//   _igjen_, _localita, _winans_, _wenda_, 
   {{0x468333cf,0xea090026,0x82d80046,0x6a6e0100}},	//   _विशाल_, _kugawana_, _trien_, _fotosess, 
   {{0x015b1180,0xcafb1148,0x52c51002,0x60778016}},	//   _podrobno, _podrobne, _milline_, _מערבֿ_, 
   {{0xf3f87253,0x82011008,0x42f76230,0xa201b29f}},	// [e90] _bunun_, _lozim_, _pezinok_, _rivier_, 
   {{0x942cc122,0x4cfde00e,0x171ec147,0x30a62195}},	//   _ягона_, _последни, _чанга_, _ексклузи, 
   {{0xf4e02121,0x23443026,0xe9b84116,0x7317915d}},	//   _بلامانع_, _kondomu_, _tendenza_, _jizzax_, 
   {{0xb27fe09f,0xf3840006,0x148db087,0x9c1720b0}},	//   _bitno_, _הנתונים_, _kirurgij, _catphcm_, 
   {{0xcecf7251,0x00000000,0x00000000,0x00000000}},	//   _sociální, --, --, --, 
   {{0x026ca224,0x524840c9,0x00000000,0x00000000}},	//   _školy_, _tumme_, --, --, 
   {{0xf2ca000c,0x9b8ac07d,0xfdc0e276,0xfba0e124}},	//   _veidi_, _зобов_, _policaja, _policajc, 
   {{0xc29160fd,0x54d743d0,0x00000000,0x00000000}},	//   _negali_, _मामिला_, --, --, 
   {{0x127ed08b,0x9f03b0a9,0x927ed115,0x22d93159}},	//   _liens_, _निर्मिती_, _aheng_, _ntxee_, 
   {{0x13004087,0xee994145,0x59d2609b,0x03f4506f}},	//   _članki_, _uvítací_, _lisènsi_, _gutted_, 
   {{0xdd1830b7,0x56f682c4,0x13992286,0x53f8600c}},	//   _glasswar, _राजवंश_, _lästa_, _kulul_, 
   {{0x72480032,0xd22571bf,0xc2126196,0x227ea0df}},	//   _primo_, _shakka_, _tloha_, _lajnah_, 
   {{0xeeee70e3,0x5a73d34c,0x526dc074,0x00000000}},	//   _dezvolta, _तत्वावधा, _kavos_, --, 
   {{0x5407d15d,0x12996174,0x1b58422c,0x973e1062}},	//   _прокси_, _paragraf_, _sentenza_, _volledig, 
   {{0x23ea009a,0x1809b151,0x5f9f8187,0xb5568306}},	//   _ifite_, _查看该公司所有供, _रक्तदान_, _классика, 
   {{0x495be320,0x13957086,0xbc28501a,0x1200e05d}},	//   _znanstve, _ghasia_, _функциял, _muniti_, 
   {{0x80b09065,0x7f0ba006,0x6ab90035,0x32912065}},	// [ea0] _digitáli, _תפקיד_, _陽気なギャングが, _anyag_, 
   {{0x3236212b,0x7a9d6173,0x62d8c2f8,0x02927174}},	//   _ikkje_, _albigens, _kamers_, _lysate_, 
   {{0xcae5d03a,0x23030254,0xa25a51d2,0xdc1e11c6}},	//   _उद्यान_, _pelawat_, _belle_, _comptes_, 
   {{0xecd73010,0x910ff035,0x03874062,0x00000000}},	//   _اعمال_, _個人情報保護方針_, _overal_, --, 
   {{0xf200909f,0x0887c093,0xba5fd1ae,0xc26e62cb}},	//   _kojima_, _ауғанста, _miresaka_, _baroda_, 
   {{0x1ee320d8,0xbc7f2280,0xc3f90004,0x0b0d7086}},	//   _निष्प्रा, _possono_, _nebuvo_, _kompyuta_, 
   {{0x62fcf177,0x4d9d6019,0xb386630c,0xed8c73aa}},	//   _éigin_, _sunnunta, _akora_, _točke_, 
   {{0x927ed29f,0x3a153079,0xc2e3f15c,0x00000000}},	//   _diens_, _афлэм_, _mediese_, --, 
   {{0x2265d14c,0xe7888074,0x220260f4,0x249df035}},	//   _агенция_, _калейдос, _kirime_, _ルディングス_, 
   {{0x920031ce,0xd0b0902b,0xa3f8d07a,0x422bd033}},	//   _enjin_, _digitáln, _steun_, _मागच्या_, 
   {{0x87ffb103,0x568a5222,0xeb8a1210,0xf4b5c0d2}},	//   _ब्रह्मान, _federazi, _тороп_, _parashik, 
   {{0xb2e310a7,0xd2e96322,0xd11d2024,0x0ecd228d}},	//   _halinde_, _kariera_, _zaawanso, _goristan, 
   {{0x429071d9,0x57b6525b,0x9f486155,0x7d89302a}},	//   _annam_, _seseteng, _response_, _valokuva, 
   {{0x543ec084,0x26b52375,0x1c7a72b0,0x851e20c8}},	//   _дайны_, _milanovi, _làrach_, _수령일로부터_, 
   {{0xa16ab02d,0x34297095,0xf43b2035,0x5308c079}},	//   _самарқан, _opravdao_, _ルマガジン_, _бэтрыне_, 
   {{0xdc910071,0x82c3e337,0x9413c249,0xaad03188}},	//   _हरदोई_, _gallego_, _домена_, _konkursā_, 
   {{0xb2e971b1,0xca8970f6,0xda55e1b0,0x81823287}},	// [eb0] _hasiera_, _hasieran_, _učenika_, _आचेवर_, 
   {{0xc25a5103,0xd98ba03c,0x06a59084,0xf3f460db}},	//   _selle_, _ルアドレス_, _украинад, _wetter_, 
   {{0x0c05f05d,0x81fa90c1,0x8f98e244,0x01fa8179}},	//   _tessuti_, _trenucim, _उत्तुंग_, _trenerim, 
   {{0x329be0a7,0x00000000,0x00000000,0x00000000}},	//   _davranış, --, --, --, 
   {{0xf2ce2221,0x6a08e1de,0x1e9ec004,0x63ea003b}},	//   _spiorad_, _تصنیف_, _файле_, _neitt_, 
   {{0x03f2506c,0x3e7043d1,0xe3ea018a,0x7c0e30f2}},	//   _levering_, _गोल्ड_, _ufite_, _jentilis, 
   {{0x93f830b4,0x429020f2,0x225e20f6,0xab6db1d1}},	//   _tujuh_, _dikan_, _kontseil, _kosmetic, 
   {{0xb27ed171,0x8291818e,0x82026193,0x926e63a9}},	//   _viens_, _torak_, _dirije_, _korong_, 
   {{0x838781c8,0xdd812038,0xd378600d,0x876960e6}},	//   _marre_, _publikua, _bagamba_, _राज्यको_, 
   {{0xde9a001e,0xb3f40271,0xc55951f1,0x4c6170ba}},	//   _브라우저로_, _destes_, _наступно, _kirumba_, 
   {{0x113c1106,0xb2ca0160,0xe1987016,0x725953ad}},	//   _posledné_, _veidu_, _טײַערע_, _त्रिभुवन_, 
   {{0xc27b60e8,0xd3f400cd,0xc93c2291,0x00000000}},	//   _persekol, _festes_, _sommerfe, --, 
   {{0xa3ea7317,0x92d9e013,0x92d4733b,0x917cf017}},	//   _tento_, _vetem_, _verder_, _although_, 
   {{0x7640702a,0x427e01ae,0x02b6b1b8,0x9d3c631c}},	//   _sosiaali, _mpino_, _verdade_, _ब्वॉय_, 
   {{0x513c11b2,0xc9da8037,0xe25a00f7,0x1b99309f}},	//   _poslední_, _preferit, _heilt_, _ozbiljno_, 
   {{0xebe40257,0x09edb082,0xaacb7167,0x723b3063}},	//   _videolar, _peygambe, _sommaren_, _tijlaug_, 
   {{0xf3161188,0xb2a78068,0xd386c045,0x34a5b09a}},	// [ec0] _nedaudz_, _darbe_, _madra_, _kurangiz, 
   {{0xc3958003,0x6394e11a,0x569bb0ff,0xe25a913d}},	//   _fyrst_, _exista_, _verilməs, _deall_, 
   {{0xd2b4e1b9,0x5001e0ab,0xd2a78294,0x8cee2019}},	//   _inicio_, _fotogrāf, _farbe_, _труда_, 
   {{0x93f8d13e,0x2ebdd030,0x0d0b2030,0x53ca6069}},	//   _kaluar_, _evenimen, _intrebar, _پوزیشن_, 
   {{0xb9d2206b,0x3356403e,0x20612180,0xcd3ea03f}},	//   _neregist, _bereits_, _enostavn, _navigace_, 
   {{0xdc6f11a9,0x0db74075,0x4813a006,0xc29020ba}},	//   _clarion_, _মেহেরপুর_, _קראתי_, _kikao_, 
   {{0x92ca7215,0x034101f9,0xb29030f3,0x5f81601a}},	//   _bende_, _jeremia_, _kijan_, _экологты_, 
   {{0xe3a201ac,0x42d980c2,0x629192a4,0x43ea712d}},	//   _ilipo_, _leres_, _rosak_, _xente_, 
   {{0x23ea704d,0x63a200d0,0x727e00ce,0x93051039}},	//   _vente_, _alipo_, _caint_, _رومان_, 
   {{0xc26de052,0xc75ec26e,0x3903f016,0x53fa5057}},	//   _dator_, _चार्ल्स_, _פאָלק_, _batuye_, 
   {{0x172721ab,0x52cb3111,0xb98c4110,0x32d472c0}},	//   _عروسی_, _mladé_, _machinga_, _perder_, 
   {{0xf20270a9,0x42a6d196,0x120270af,0x9fd85092}},	//   _berisi_, _haeba_, _seriti_, _odstraně, 
   {{0xdb0c10c3,0x49d22206,0x7e963152,0x9341305f}},	//   _אלימלך_, _geregist, _čempiona, _بنجاح_, 
   {{0xb25a90f4,0x00000000,0x00000000,0x00000000}},	//   _kwali_, --, --, --, 
   {{0x32fdf09a,0x527f91fb,0x31772098,0x025a50a2}},	//   _mbuga_, _wisnu_, _тесты_, _kella_, 
   {{0x2432b075,0x53a8e0fe,0xd3f470b2,0xd25a90f4}},	//   _জিনিস_, _belakang_, _instal_, _mwali_, 
   {{0xafe5b024,0x00000000,0x00000000,0x00000000}},	// [ed0] _एक्टिव_, --, --, --, 
   {{0x0e7ab03c,0xa7e1a0c8,0x625ad1c7,0x33f9815c}},	//   _チェックリストに, _판매자에게_, _imeli_, _gerus_, 
   {{0x829110fb,0x529032b0,0x39ddd1c6,0x4ceb9017}},	//   _encara_, _almain_, _ооганста, _להסיר_, 
   {{0x33f861ea,0x6e13919e,0xdecc4010,0x00000000}},	//   _atout_, _ollenkaa, _dibintan, --, 
   {{0x7ae1913c,0x32d98069,0xf27e900d,0x00000000}},	//   _girtîgeh, _keres_, _asani_, --, 
   {{0x9fab303f,0x22d98186,0x00000000,0x00000000}},	//   _nemovito, _jeres_, --, --, 
   {{0xc2d980d9,0x2290b060,0xf29021a0,0xa303400b}},	//   _deres_, _encam_, _inkar_, _nabantu_, 
   {{0x4290c023,0x00000000,0x00000000,0x00000000}},	//   _undan_, --, --, --, 
   {{0xe2004022,0x62ca60b1,0x466dc05f,0x52290243}},	//   _kimin_, _kunlari_, _للاسف_, _размислу, 
   {{0x5c5b0196,0xb290c02a,0x1b30c15f,0x00000000}},	//   _samuele_, _ollaan_, _седой_, --, 
   {{0x135bd09a,0x4378a060,0x33869110,0xb6e7f1dc}},	//   _kongera_, _dihatin_, _charo_, _tasarruf, 
   {{0x23dce28e,0x73eae2b7,0xc6042050,0xaf72302a}},	//   _haiwan_, _montes_, _dubleeri, _вокруг_, 
   {{0x52d99189,0xb25a9131,0xa2d980c2,0x62fce174}},	//   _meses_, _swala_, _beres_, _mangan_, 
   {{0x427a129a,0x22c21086,0x730c20ec,0x6876c118}},	//   _karibuni_, _usalama_, _poderá_, _смаку_, 
   {{0xf25a527b,0xa386d23b,0x6d7261a8,0x00000000}},	//   _belli_, _akere_, _техникас, --, 
   {{0xa291801f,0x799d2064,0x0f58701a,0xf85ca285}},	//   _coran_, _қарым_, _дәйексөз_, _detaljer_, 
   {{0xe2498155,0x358b91e8,0xe60fd079,0x3b03d0c8}},	// [ee0] _terms_, _достигну, _конститу_, _기본적으로_, 
   {{0x0c5bf015,0x93b390e5,0xd887d1c6,0x0dff7038}},	//   _ekstovi_, _प्रबुद्ध, _казанда_, _rezervua, 
   {{0xd291821a,0xabe0a043,0x00000000,0x00000000}},	//   _foran_, _nyhetsbr, --, --, 
   {{0x32fce2fa,0x1743300e,0x00000000,0x00000000}},	//   _jangan_, _курсы_, --, --, 
   {{0x936120b4,0x32fcd15b,0xf27e9039,0x2252f190}},	//   _nyambung_, _dingwe_, _arany_, _bestyrel, 
   {{0x684ed064,0xd5b20035,0x00000000,0x00000000}},	//   _вьетнам_, _詳しくはこちら_, --, --, 
   {{0xec527167,0x2290e0b5,0xbd9c60f5,0xc2b670b2}},	//   _ефективн, _šiame_, _ameliska, _mercat_, 
   {{0xfc00b0fd,0x43f10148,0x00000000,0x00000000}},	//   _miestas_, _poštovné, --, --, 
   {{0x630341fa,0x738fd300,0x12d9e087,0xcc5d505f}},	//   _zabantu_, _senyawa_, _petek_, _وتاريخ_, 
   {{0x42b7a072,0x938aa2a0,0x2d3c817e,0x00000000}},	//   _министр_, _aðrir_, _новинарс, --, 
   {{0xb2d9a121,0xa2d990cc,0x93eb709f,0x0c56a08c}},	//   _cepet_, _beses_, _smatra_, _vertete_, 
   {{0xf26e512a,0xb2d98288,0x83f9913d,0xbc41f151}},	//   _motore_, _seres_, _mesur_, _县级以上人民政府, 
   {{0xb320506f,0xa291e155,0x32d9907d,0x47d96132}},	//   _dilyn_, _total_, _leser_, _kulawarg, 
   {{0x0d1b23d2,0x0c693250,0x3290f11a,0xd3cf013c}},	//   _गुणवत्ता_, _emprego_, _logat_, _çavan_, 
   {{0x64d52130,0x83ea0045,0xf22aa0bf,0x327ed0a6}},	//   _साहित्_, _leith_, _někde_, _abend_, 
   {{0x7290810e,0xd47513d3,0x1c63117e,0x5853117e}},	//   _tokana_, _अपरिहार्, _assunto_, _assuntos_, 
   {{0x10f3b006,0xaa07d0b1,0x00000000,0x00000000}},	// [ef0] _לאהוב_, _капелло_, --, --, 
   {{0xc2ca7104,0xbb735329,0x07bbb006,0xc290e2c1}},	//   _henda_, _असुरक्षि, _לפועל_, _finais_, 
   {{0x32905023,0x0b57f197,0x72e25033,0x02908098}},	//   _bilan_, _kultúra_, _जाणीव_, _alkaen_, 
   {{0xdf495344,0x8d46c195,0xc9f61069,0x16a91072}},	//   _proposta, _интервју_, _توسیع_, _системал, 
   {{0xd29070bd,0x965e105c,0x42d9a0d2,0x00000000}},	//   _innan_, _фирме_, _neper_, --, 
   {{0x5ac7b01a,0xcb79d0fd,0x853170c8,0xf74e70c8}},	//   _авторлық_, _легенды_, _불가능합니다_, _국가보안법_, 
   {{0x9ae07032,0xfc394084,0xd316018a,0x4a14c01e}},	//   _contenut, _inscripc, _myiza_, _verborge, 
   {{0x42904078,0xa2ca71a6,0xa743e0a9,0x000c1088}},	//   _siman_, _genda_, _नवनिर्मा, _お問い合せ_, 
   {{0xf290c0cc,0xaabf226e,0x0d5ab0fb,0x928c2233}},	//   _andam_, _slavnost, _абонентт, _rơixuống_, 
   {{0x9a3c123d,0x21f7c1de,0x347d9266,0xb665e2d6}},	//   _душой_, _معترف_, _प्रभा_, _आवासीय_, 
   {{0xda5fc0f2,0x9c64506a,0x6264709f,0xe2908173}},	//   _matetika_, _wabunge_, _mislio_, _nkhaus_, 
   {{0xe2d9b0ac,0x48dc3008,0x6837e0c8,0xe2ca7110}},	//   _seveda_, _истайсиз, _되겠습니다_, _jenda_, 
   {{0x72ca70f6,0x5ed9636a,0x379140ce,0xd3072049}},	//   _denda_, _noticias_, _صلاحيات_, _armancên_, 
   {{0xf4271015,0xdd80d0a9,0x12182060,0x00000000}},	//   _мислим_, _माध्यमात, _bêhna_, --, 
   {{0x1307d1a7,0x4426f094,0xc7ef10a1,0x79e6f02a}},	//   _sarawak_, _ташхиси_, _мәрте_, _verrattu, 
   {{0x23ead183,0x73a2c2da,0x93ea000c,0x00000000}},	//   _groter_, _kompis_, _leiti_, --, 
   {{0xdbd83169,0x2853307d,0x2ea5911a,0x463bf206}},	// [f00] _श्रीमद्_, _площа_, _reducere_, _enthousi, 
   {{0x82cad1cb,0xbfe970e6,0x7b193019,0xbdbe4168}},	//   _produs_, _संभावित_, _tamperee, _catalase_, 
   {{0xd583a10f,0x327e00ba,0x129dc1de,0x9667f1d7}},	//   _fenerbah, _mbinu_, _مشائخ_, _pastebėj, 
   {{0x90b87121,0x27e7e0cf,0x850c8151,0x00000000}},	//   _ماجراجوی, _देखरेख_, _胶南市农业机械管, --, 
   {{0xf075d0ab,0x068dc136,0x468c91f0,0x1a6fc3d4}},	//   _materiāl, _निवास_, _बोलाव_, _आर्काइवक_, 
   {{0x42e9d0c4,0x87de905d,0xe63b5151,0x8da40016}},	//   _mwynhau_, _kumpanni, _小仓优子性感泳装, _גרעניץ_, 
   {{0xbe3b2026,0xc969b02a,0xc665a0fe,0x63ea71de}},	//   _pioneers_, _ajankoht, _peristiw, _fenti_, 
   {{0x7eb6300e,0x2eb990b5,0xd3c7526e,0x564b8124}},	//   _системы_, _анонсы_, _hospodář, _njihovom_, 
   {{0x4f39e358,0x00000000,0x00000000,0x00000000}},	//   _memulaka, --, --, --, 
   {{0xc394027e,0xf27ed06f,0x1b60b02e,0x88ebf07b}},	//   _aviso_, _maent_, _सोहनी_, _topánky_, 
   {{0xa28900f1,0x23cef098,0x03f8210f,0xb27f7101}},	//   _appartem, _olivat_, _hukuk_, _lianna_, 
   {{0xc4c07238,0x62007045,0xb93d9075,0xa2d9a08c}},	//   _público_, _inniu_, _বিজয়_, _teper_, 
   {{0x324971e4,0xe2de8027,0xe448607d,0xd1a2d0b1}},	//   _agamsa_, _strojov_, _плануван, _ҳузурида_, 
   {{0x8291909f,0xbc93e121,0x0636819b,0x2c52a024}},	//   _posao_, _ماساژ_, _završila_, _ड्रइङ_, 
   {{0x9200b179,0xd36950a9,0x12da5116,0x9237e03a}},	//   _godina_, _inggris_, _poteri_, _chomika_, 
   {{0x02b3e0ec,0xc2907060,0x22918161,0x87e7a3d5}},	//   _produto_, _jinan_, _foras_, _बाथरूम_, 
   {{0x5ee9b0c3,0xf68ca2d2,0x2dbe4117,0x41dc3017}},	// [f10] _בחדרי_, _प्राय_, _database_, _directly_, 
   {{0x700ad0c3,0xe71f124a,0x62d94065,0x8237826f}},	//   _אַבאָנעמ, _спортсме, _fidesz_, _sarja_, 
   {{0x72d37178,0x42918189,0x53a2d0e5,0xfe4e5150}},	//   _jehovah_, _horas_, _hoopis_, _kasalana, 
   {{0xf4e89171,0x670cd195,0x00000000,0x00000000}},	//   _pagaidām_, _divergên, --, --, 
   {{0x538690ce,0xbc68912f,0x1249f131,0xa2019173}},	//   _bharr_, _acordul_, _atuma_, _losis_, 
   {{0xfc93e18b,0x02918109,0xf6ae3100,0x70843023}},	//   _स्कोर_, _doras_, _britaniy, _семинарл, 
   {{0xb3f8f0b1,0x00000000,0x00000000,0x00000000}},	//   _bugun_, --, --, --, 
   {{0xa2bdc175,0xc38f1145,0x5b4200cb,0x62d9a15c}},	//   _pokiaľ_, _obstaráv, _mädchen_, _peper_, 
   {{0xce9ec122,0x92910255,0xd756a1de,0x00000000}},	//   _қавли_, _dibawa_, _طاقتور_, --, 
   {{0xa2d8207a,0x6290c0f2,0x00000000,0x00000000}},	//   _erken_, _bolana_, --, --, 
   {{0xd301e11a,0xb501e01c,0x12b40030,0x934a00fc}},	//   _detalii_, _protekao_, _adica_, _izmedju_, 
   {{0x0de1307d,0xe2378008,0xd200c155,0x125bf02d}},	//   _останні_, _shimcha_, _india_, _mazlum_, 
   {{0x0307e07f,0xa20181c6,0x00000000,0x00000000}},	//   _jugalah_, _morir_, --, --, 
   {{0x62d9e171,0xf2030171,0x48b9906b,0xf2d800a8}},	//   _sezonas_, _automašī, _последњи_, _trieu_, 
   {{0x32d9624e,0xb48432d6,0x00000000,0x00000000}},	//   _ingeri_, _इजरायल_, --, --, 
   {{0x0feda0c3,0x630b70a3,0x729b72c6,0x70efd3a2}},	//   _מסביר_, _najbolj_, _najbolji_, _sóisialt, 
   {{0x8f7b51c6,0x3ef31016,0x4cc48104,0xabfda11a}},	// [f20] _barcelon, _אַבֿרהם_, _hamingju_, _puternic, 
   {{0xc2f230a3,0x5fa46155,0x9e4d60b1,0x42007109}},	//   _potovanj, _december_, _москвада, _innis_, 
   {{0x69df50fb,0x00000000,0x00000000,0x00000000}},	//   _contingu, --, --, --, 
   {{0xbc765209,0xb2907144,0x1c761264,0x938071d9}},	//   _results_, _annat_, _fikrini_, _thuras_, 
   {{0x2248923a,0x528b6133,0x6200c098,0xf2d8c10e}},	//   _suami_, _pomocí_, _tulisi_, _nomeny_, 
   {{0xbae9608d,0x417720fd,0x89ed91ee,0xe61a1020}},	//   _gasteboe, _нешта_, _rendelés, _reklaami, 
   {{0xfdbc43ac,0xfb93b088,0x00000000,0x00000000}},	//   _označte_, _その他のタグ_, --, --, 
   {{0x425a405e,0x02d9f204,0x00000000,0x00000000}},	//   _semlm_, _etten_, --, --, 
   {{0x42fc0217,0x82ad32ff,0x92da62f2,0x527820e3}},	//   _amigo_, _минут_, _parede_, _anunţ_, 
   {{0x638772f9,0x0115a07d,0x9eb0b05f,0x786cf07a}},	//   _ngaran_, _власност, _الأثاث_, _minstens_, 
   {{0xf8a1703c,0xf291920a,0xfc26e0f1,0x24fd917e}},	//   _お気に入り_, _cosas_, _verbeter, _законите_, 
   {{0xf8748074,0xa3f8e1e3,0xd27ee00c,0xc2cb200a}},	//   _курсах_, _genuen_, _tunnen_, _seyda_, 
   {{0xdc6f60ba,0xe2927023,0x61806093,0x520272e3}},	//   _ukurasa_, _beradi_, _апелляци, _musiek_, 
   {{0xa2d92297,0x98c7c035,0x1b479024,0xd2d9c060}},	//   _luyen_, _知恵袋に投稿され, _लिक्खाड़_, _dever_, 
   {{0x32ca70ee,0x094e32b7,0x52cad002,0x835d114a}},	//   _kendu_, _escolare, _reede_, _tanging_, 
   {{0xd288c023,0xc8e8a035,0x62d8319e,0x4e8f432b}},	//   _айнан_, _選択してください_, _arjen_, _kommunen, 
   {{0xf3e54201,0xd86a904d,0xaea3800e,0x62907155}},	// [f30] _চমৎকার_, _politiqu, _значител, _final_, 
   {{0xc27ff1aa,0x8387817a,0x3404701e,0x6f40f01e}},	//   _khung_, _carro_, _전체매물정보_, _인도네시아_, 
   {{0xfc29823a,0x86cb8019,0xf197c098,0x3c9d802a}},	//   _membenar, _samanlai, _наконец_, _последов, 
   {{0xd2d9c0fb,0x72cb0194,0x3b9e1006,0x9394f052}},	//   _seves_, _grader_, _קומדיה_, _priset_, 
   {{0xd25ae003,0xa212b32f,0x22d9211d,0x92d901ed}},	//   _heilsa_, _coche_, _duyen_, _arbeta_, 
   {{0xd9daa244,0x2623a041,0x0200b09e,0x830cd0c4}},	//   _ternyata_, _daimntaw, _endiga_, _anhapus_, 
   {{0x0860c195,0x426e6072,0x00000000,0x00000000}},	//   _инаку_, _aprova_, --, --, 
   {{0x95e2f1f2,0x0a7e000b,0xf29272cb,0x0200712f}},	//   _categorí, _byandits, _dorais_, _minim_, 
   {{0xf9ffa03f,0xc2cb4148,0xa31cf18b,0x00000000}},	//   _moderní_, _predam_, _yoochun_, --, 
   {{0x62d9211d,0x92907192,0x8bf460c3,0x7e17f023}},	//   _huyen_, _annar_, _פאָלקס_, _gazetala, 
   {{0x03ea71e0,0x328c4182,0xb79292d5,0x439481e0}},	//   _tentu_, _niekada_, _contrasi, _punggung_, 
   {{0xd2a5b05f,0x532040ba,0x31efc126,0x00000000}},	//   _بالقرب_, _kimya_, _амволи_, --, 
   {{0x6eb9615c,0x62d8d173,0xe3eaf115,0x693d6035}},	//   _navorsin, _ntees_, _bunter_, _オンラインゲ_, 
   {{0x32480140,0x4233c19e,0x9af3b0a4,0x00000000}},	//   _naime_, _hyppää_, _hverdage, --, 
   {{0x8053c033,0xe290c100,0x02d9e19c,0x331a8075}},	//   _presiden, _ondan_, _heter_, _সিকিউরিট, 
   {{0x5d3d303f,0xb301c071,0xab980238,0x4305c191}},	//   _aplikace_, _ज़िम्मेद, _ficheiro_, _اوضاع_, 
   {{0x7387f04f,0xa1b9e0fd,0xd2d28116,0x43b99015}},	// [f40] _buurt_, _молодёжь_, _illegali_, _zatvoru_, 
   {{0x23e8d072,0x273620a1,0x92020099,0xff3a0004}},	//   _аскер_, _украинан, _lipiec_, _profesin, 
   {{0xe2fcc2ec,0x227e6057,0x0386030c,0x1c536100}},	//   _google_, _mbona_, _akiri_, _tətbiq_, 
   {{0x355c9043,0xf5a9707d,0x62d92297,0xf2d98045}},	//   _постанов, _радянськ, _xuyen_, _dtreo_, 
   {{0x36e8d09f,0xc3265151,0x51c9315f,0xa27e71c9}},	//   _istraživ, _图片和音视频稿件_, _сойти_, _rannu_, 
   {{0x5cce40c8,0x00000000,0x00000000,0x00000000}},	//   _이메일주소_, --, --, --, 
   {{0xf46530c0,0xb7e60016,0xfb266094,0x927f12c6}},	//   _osservaz, _ליצנות_, _мусиқӣ_, _kaznu_, 
   {{0x527e6057,0x92cae3a9,0x9730d121,0x2e39d3b0}},	//   _abona_, _mondok_, _ویتامین_, _рэзбой_, 
   {{0x16d1a169,0x90ea111b,0xb29190b2,0xbef2e052}},	//   _रितिक_, _лавозими, _posar_, _beskrivn, 
   {{0x975973b6,0x16034079,0xbc619071,0x288af022}},	//   _साक्ष्य_, _тестамен, _ofercie_, _tamamilə_, 
   {{0x827ed23b,0x2290725e,0x92901060,0x1a5720b5}},	//   _tsonga_, _annak_, _dihat_, _іншых_, 
   {{0xf2d9211d,0x3aed4116,0x0248620f,0x8d561017}},	//   _quyen_, _introdot, _droma_, _בינתיים_, 
   {{0x32eab0d1,0x841c1006,0x8ab6b2bf,0x1481c151}},	//   _eventos_, _להפעיל_, _दुखड़ा_, _劳动的财政贡献率, 
   {{0x62fe4250,0xffa411c8,0x7386b11a,0x02f1812a}},	//   _artigos_, _vendosur_, _oferte_, _инсталир, 
   {{0x4d35a05c,0x00000000,0x00000000,0x00000000}},	//   _планете_, --, --, --, 
   {{0xa2d9e29c,0x62da6057,0x73d51116,0x026e713e}},	//   _beter_, _gereza_, _protetti_, _kosove_, 
   {{0xf23780de,0x4ff8201e,0xc291c1d4,0x6c1db006}},	// [f50] _varje_, _담당중개업소_, _novas_, _כשהוא_, 
   {{0x82cae1f9,0x3fd6806a,0x622670de,0x00000000}},	//   _sendra_, _changamo, _risken_, --, 
   {{0xb2020099,0x13454082,0x825af193,0xe27f409f}},	//   _musisz_, _anadolu_, _regle_, _krenuo_, 
   {{0xf53fe2ca,0x925af0a8,0x2d9fc0bc,0x00000000}},	//   _адресу_, _segle_, _neteweke_, --, 
   {{0x2c755073,0x025a91ec,0x2c0691ad,0x3a40505f}},	//   _दोस्ती_, _awali_, _imprezy_, _وشروحات_, 
   {{0x620070ce,0x4c2c020f,0x1234011a,0x12fd2033}},	//   _minic_, _theangac, _меломани, _militer_, 
   {{0xc08a407d,0xf3f9e003,0x825a51d5,0x1248d2a8}},	//   _кримінал, _setur_, _kelli_, _igomba_, 
   {{0x82da63d6,0x0a1460f6,0x00000000,0x00000000}},	//   _parece_, _pribatut, --, --, 
   {{0x72b52042,0x625ad15b,0xa229a011,0x427e6197}},	//   _índice_, _feela_, _kuamuag_, _uplne_, 
   {{0xb290f057,0x127f030a,0x330c30ab,0x7b29d0ec}},	//   _yohana_, _blandt_, _izlases_, _justiça_, 
   {{0xae0591a7,0x72d8e0cb,0x52d8c29f,0xd9b3a187}},	//   _kenderaa, _spiele_, _namens_, _nesprávn, 
   {{0x02005132,0x771341f0,0x526c823b,0xca0d60d1}},	//   _silih_, _जर्दा_, _jakobo_, _computad, 
   {{0x3200c049,0x9711403a,0x34a30100,0xc20020a9}},	//   _didin_, _गर्दन_, _futbolçu, _dikit_, 
   {{0x53966065,0xb2a66010,0x22d960f1,0x44531072}},	//   _persze_, _nyoba_, _ergens_, _гордый_, 
   {{0x2ece5099,0xd9ec517d,0xad44419c,0x76f420c5}},	//   _कार्यवाह, _colombia_, _унікальн, _गढ़वाल_, 
   {{0x0d8af0c9,0x9248d09a,0x96e94129,0x32d9e209}},	//   _sewerage_, _agomba_, _इतिहासाच, _often_, 
   {{0xce53009b,0x3b8b92b5,0x3b6ac07a,0x9b6f1138}},	// [f60] _pelatiha, _ministar, _pretoria_, _réasúnta_, 
   {{0x935d40a9,0x3f29615d,0x0b02c0ff,0x92fce0b7}},	//   _सल्ला_, _daftarla, _konfrans, _hangin_, 
   {{0xedb790b5,0xc3866221,0x9395404e,0x00000000}},	//   _законы_, _phort_, _kreste_, --, 
   {{0x9845b042,0x8e44d12e,0xc25a3039,0x00000000}},	//   _utilidad, _kapangya, _állam_, --, 
   {{0x325a9086,0xc33d2121,0x4a1771ae,0xd9f7a057}},	//   _swali_, _میراث_, _raharaha_, _bibiliya_, 
   {{0x2f1d6087,0xc5327015,0x02489121,0x25abf016}},	//   _nakupova, _септемба, _krama_, _עקאָנאָמ, 
   {{0x1315b25b,0x72d821e6,0x0200c0b4,0x627ed138}},	//   _memberi_, _erkek_, _indit_, _daonna_, 
   {{0xe212b06a,0x0c6430df,0xd2903116,0x77b8714e}},	//   _kocha_, _bintulu_, _rumani_, _sigurimi, 
   {{0x027e912e,0xa4315075,0xc2787004,0x1c586378}},	//   _upang_, _আপনিও_, _kaunas_, _faktisk_, 
   {{0x2f993046,0x307cb075,0xedb2d38a,0x01df803a}},	//   _nhất_, _ফটোশপ_, _keingina, _poinform, 
   {{0x52d9e200,0x8291c06d,0xd63ab126,0xb6faf039}},	//   _aften_, _kovar_, _забоншин, _افزائی_, 
   {{0xe27e900b,0xc38c2015,0x238e91b7,0x82fd520a}},	//   _abana_, _путем_, _consigli_, _llegar_, 
   {{0x6e68c22d,0x1f20c234,0xbc6321ad,0xd1dc108e}},	//   _adiciona, _स्वीकृति_, _dostęp_, _סלוצקי_, 
   {{0x1201f1dd,0x34e34075,0xd248d09a,0x00000000}},	//   _sluit_, _ইকবাল_, _ugomba_, --, 
   {{0xa9093169,0x1387e010,0x513c1106,0x9ae891da}},	//   _विवेकानं, _yatra_, _posledný_, _datorren_, 
   {{0xbd0d7095,0x7200f240,0x5212b0bc,0x5d7d2122}},	//   _najmanje_, _engin_, _bocha_, _лоиҳаи_, 
   {{0x9db43010,0xf3eb3042,0xcc1d3068,0x83a34323}},	// [f70] _موضوع_, _texto_, _kurallar, _sleppa_, 
   {{0x7290c023,0x2291d2e3,0xa89ec127,0x20f44035}},	//   _zidan_, _sowat_, _зарафшон_, _そういえば_, 
   {{0xb200f048,0xba7301b1,0x67bca03e,0x4291e0d2}},	//   _ingin_, _bilaketa_, _angezeig, _votat_, 
   {{0x035fa221,0x77a1f2f7,0x131c1191,0x72fd017e}},	//   _airgead_, _omstandi, _ضیغمی_, _направен_, 
   {{0x3c5280f6,0x2b98e30e,0x0481b2db,0x11216089}},	//   _kontuan_, _pilipino_, _पिताजी_, _raspolož, 
   {{0x72a7c034,0x07d7c182,0x3273b104,0xc201011a}},	//   _такова_, _тэкст_, _mínir_, _mobila_, 
   {{0x1291c145,0x2290306a,0x325a014c,0xc0947008}},	//   _tovar_, _kamati_, _utile_, _tinchlik_, 
   {{0x89438143,0x53ead00c,0x53d400c7,0xd27e00c2}},	//   _mailadre, _rootsi_, _yuxarı_, _ucing_, 
   {{0xae37b1b1,0x04993085,0x55993038,0x125a0034}},	//   _bidalita, _personaj, _personaz, _stile_, 
   {{0x90c7a10a,0x0290c0f7,0xcf300138,0x42ca7104}},	//   _рамките_, _sidan_, _الزفاف_, _hendi_, 
   {{0x72ca700a,0x938693a2,0xd37381b2,0x527ef146}},	//   _kendi_, _thart_, _redakce_, _magni_, 
   {{0xf32070c2,0x801e2182,0xee4ec10e,0x7a0c1075}},	//   _dinya_, _komentuo, _malamala, _সুখবর_, 
   {{0xe200c00a,0xc75831ff,0xab7bf128,0xa810f121}},	//   _indir_, _मिष्ठान_, _pangalan_, _جایگزین_, 
   {{0x604dc015,0x82ca70f3,0x73f402b7,0x2017c182}},	//   _врата_, _lendi_, _destas_, _законна_, 
   {{0xa1ad1138,0xafa4c065,0x6b1d1138,0x43ea9045}},	//   _الفطر_, _کوئٹہ_, _الفجر_, _leath_, 
   {{0x427bc199,0x00000000,0x00000000,0x00000000}},	//   _objednáv, --, --, --, 
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [f80] --, --, --, --, 
   {{0xf3ead1d9,0xa89ea065,0x372ba1e9,0x00000000}},	//   _cultur_, _katalógu, _столиці_, --, 
   {{0x7fd52005,0x82139148,0x1273b003,0xa078d12a}},	//   _materiał, _najnovši, _sínar_, _правилат, 
   {{0x9d976019,0x4bdde03a,0xd16c4126,0x07a6c07d}},	//   _applikaa, _बलिया_, _истодаан, _handling, 
   {{0x72a7813a,0x987602e7,0xbeb3236a,0x49427019}},	//   _darba_, _משניות_, _derechos_, _sellaise, 
   {{0x8386902d,0xee2e0053,0x867e008e,0x00000000}},	//   _shart_, _bergamba, _צונאמי_, --, 
   {{0x3dd931a7,0x92a78175,0x97739151,0xc7e3d280}},	//   _berkenaa, _farba_, _并不意味着赞同其, _позиция_, 
   {{0xeb0a412f,0x1317f0d0,0x49912164,0xa290f042}},	//   _persoane, _wauza_, _klijenta_, _ligan_, 
   {{0x0290e0a2,0xdf13801f,0xd369c03b,0x00000000}},	//   _kunagi_, _fantatra, _tenglar_, --, 
   {{0xe29032b0,0xd5d2f015,0x00000000,0x00000000}},	//   _comann_, _железниц, --, --, 
   {{0xf2cb811b,0x52927199,0xf2d8209e,0x027f803b}},	//   _yerda_, _strach_, _emmere_, _barni_, 
   {{0x63209170,0x1d561006,0x9290709f,0x69d01098}},	//   _biaya_, _זיכרון_, _iznad_, _серии_, 
   {{0x3aefd07b,0x68d2d287,0x0605a1d7,0xe2904376}},	//   _opíšte_, _पहाटे_, _буклеты_, _nimam_, 
   {{0x92d9707b,0x3a033035,0xf62323d3,0x00000000}},	//   _videá_, _このブログの読者_, _अरुणा_, --, 
   {{0x92c7c293,0xca051287,0x8a376042,0xd4d76042}},	//   _sådan_, _चिन्हावर_, _técnicas_, _técnicos_, 
   {{0x645b71ef,0xb3ead15b,0x235d1010,0x7290111a}},	//   _установа, _hantle_, _nanging_, _mihai_, 
   {{0x32c89134,0x6b5d1034,0x0055017e,0xb2903299}},	// [f90] _octobre_, _кирилица_, _passagen, _nijak_, 
   {{0xd3eb805e,0x222ac043,0xfe00f26c,0x6898a26d}},	//   _serta_, _понад_, _fhreasta, _न्यूजीलै, 
   {{0x8197c118,0x72d8527a,0xa8c3f035,0x9b308088}},	//   _законе_, _caled_, _サプリメント_, _クチコミを投稿す, 
   {{0x1f599173,0x329070f5,0x00000000,0x00000000}},	//   _bliajyob_, _vinai_, --, --, 
   {{0x8730d1de,0x00000000,0x00000000,0x00000000}},	//   _عیسائی_, --, --, --, 
   {{0x084a1023,0xe2bd1118,0x9387e0e7,0x00000000}},	//   _бошка_, _спроба_, _catro_, --, 
   {{0x4224919b,0xc3cef144,0xaf5d60fe,0x137a3201}},	//   _ovako_, _blivit_, _sepanjan, _embargo_, 
   {{0x33eb00e8,0xf2cb0053,0x95b92138,0x00000000}},	//   _khatam_, _khadam_, _ballstát_, --, 
   {{0xd291b13a,0xf290f1e0,0x62fc930e,0x8ce831c6}},	//   _novada_, _ingat_, _umaga_, _нерсени_, 
   {{0x5378706a,0x00000000,0x00000000,0x00000000}},	//   _angalia_, --, --, --, 
   {{0xb2d9f019,0x6321a027,0xc23b20df,0x8841c17a}},	//   _ettei_, _dopyt_, _menepati_, _últimas_, 
   {{0xa2d8406e,0x13954037,0x43f0c007,0xbac331de}},	//   _numer_, _queste_, _minoranz, _اننگز_, 
   {{0x2d04c138,0x3a1161a9,0xe11a10dd,0x084a111b}},	//   _زوجها_, _thuairme, _борби_, _борки_, 
   {{0x97e31126,0xa5ba302f,0xecaa01a3,0xfc65222c}},	//   _хотири_, _月加入中国共产党_, _asociāci, _kuntatt_, 
   {{0x2c21a39d,0xf30b9121,0x02d930f5,0x1292700d}},	//   _גדליה_, _یکدیگر_, _ntxes_, _merali_, 
   {{0x5254e220,0x7f39a006,0xb200c1a3,0x7300a1e0}},	//   _főleg_, _תקציב_, _paliek_, _dicapai_, 
   {{0x4fef80a9,0x22cb5385,0x00000000,0x00000000}},	// [fa0] _विमानतळ_, _kredyt_, --, --, 
   {{0x5ad681e8,0x42903168,0x42bb50ff,0x5ba79094}},	//   _листата_, _himaya_, _həcmi_, _бигзор_, 
   {{0xa24801d7,0xa6174019,0x5e59123a,0xf74e0111}},	//   _kaimo_, _englanni, _berbinca, _rodičovs, 
   {{0xe8b1d1fc,0x8a76f1c6,0xdb3b9015,0x2225409c}},	//   _predsjed, _тартуу_, _складу_, _hoekom_, 
   {{0xd9945023,0x517780f1,0xe2da7068,0xbb6440cb}},	//   _менежмен, _behandel, _mesela_, _arbeiten_, 
   {{0x33f880f4,0x1f3360b9,0xb332d0b7,0x22d7c1f2}},	//   _yakuwa_, _konsista, _flexo_, _laboral_, 
   {{0x92d9e155,0x6374d05c,0x429081c1,0x0395715b}},	//   _after_, _рубрике_, _nikada_, _traste_, 
   {{0xaa7cc060,0x806172d7,0x628c2140,0x61422289}},	//   _siyaseta_, _praktisk_, _njihovu_, _страв_, 
   {{0x5b1ed02f,0x3b8de116,0x2290f09b,0xc13a3204}},	//   _点击此处查看原文_, _fornitur, _tigan_, _mennessä_, 
   {{0xa3ea60d7,0x8224909f,0x420050a7,0xd686b21b}},	//   _mtoto_, _svako_, _bilim_, _prodavni, 
   {{0xd2d9e293,0x73538005,0x5be9a138,0x492b70c3}},	//   _efter_, _produkcj, _جرينتش_, _טווערסקי_, 
   {{0xf387e11a,0x42d8d1da,0x1e57c122,0x598ec1b5}},	//   _catre_, _ordea_, _сердюков_, _малих_, 
   {{0xf2d9806c,0x6437a1e1,0x00000000,0x00000000}},	//   _turen_, _perhatik, --, --, 
   {{0xffcd3138,0x2e3870a7,0x7e91e03f,0x02a2624d}},	//   _البعض_, _galatasa, _editovat_, _उच्चस्तर, 
   {{0x720071ce,0xe00521e8,0xa01601c2,0x84cb912a}},	//   _minit_, _огромни_, _गणेशजी_, _контрапр, 
   {{0xa2d822b3,0xf507b098,0x81b3205f,0x37d0c015}},	//   _maken_, _средств_, _ظاهرة_, _многи_, 
   {{0x53eb91f5,0x7c7040fa,0x7e6ac15d,0x80d04027}},	// [fb0] _mesto_, _vlastne_, _фонди_, _vlastnej_, 
   {{0xd23510c0,0xf4551032,0xb3eb8034,0x44a1b068}},	//   _prodotti_, _prodotto_, _certo_, _firması_, 
   {{0x217cc062,0x2bdf81bb,0x3e59104b,0xb2912150}},	//   _해피캠퍼스_, _coreógra, _perbinca, _diyan_, 
   {{0xf2d6f027,0x62918024,0x9f25015b,0xe290c0bc}},	//   _pomohol_, _coraz_, _latelwan, _molato_, 
   {{0x30b01133,0x01b91184,0x42b40081,0xce4f0168}},	//   _minimáln, _термен_, _kwica_, _makalala, 
   {{0xe4b5a1a6,0xfa198151,0xe4b28007,0x00000000}},	//   _kutandik, _点击查看更多_, _legalizz, --, 
   {{0xf5c71085,0x9779802f,0xaa73920b,0x33eb9112}},	//   _তেহরান_, _青岛市公安局_, _slično_, _kesto_, 
   {{0x41dc1114,0x0b43a094,0x334211b0,0x0395a008}},	//   _клуби_, _вобаста_, _poseban_, _ruxsat_, 
   {{0xf3eb7109,0x7c7ea04a,0xf25a0017,0xed9d8071}},	//   _leatsa_, _opisyal_, _build_, _recenzje_, 
   {{0xdc60310f,0xe37b225d,0x00000000,0x00000000}},	//   _amatör_, _horario_, --, --, 
   {{0xa9e64140,0x96d601da,0x78bae0c8,0xb2d64140}},	//   _otvorena_, _desberdi, _동영상갤러리_, _otvoren_, 
   {{0x63eb91b0,0x9290f003,0x00000000,0x00000000}},	//   _nesto_, _engar_, --, --, 
   {{0x226e611a,0xb3ea91b7,0xd26fb0e2,0xc57140c8}},	//   _parola_, _stata_, _pengalam, _공간입니다_, 
   {{0x373e0098,0x6e39504d,0x9a0ab297,0xc27ed09d}},	//   _подготов, _localisa, _banbient, _ffonio_, 
   {{0x4a5e710e,0x62d99199,0x4c56b1b6,0xdb0c019a}},	//   _takelaka_, _musel_, _girtine_, _keistime, 
   {{0x4045f0b0,0xf3553341,0x4617e0e1,0x485c21de}},	//   _kilobook_, _zemfira_, _арапски_, _ویجٹس_, 
   {{0x83eb82f2,0x725a002f,0xf041a276,0x00000000}},	// [fc0] _perto_, _huile_, _okruženj, --, 
   {{0x93a24304,0x8f03e024,0x00000000,0x00000000}},	//   _pompo_, _मुफ़्त_, --, --, 
   {{0x73ef618b,0xf726d024,0xba3ab127,0xb8f8b0ee}},	//   _जन्मकुंड, _काफ़ी_, _гурҷисто, _askatasu, 
   {{0xa290e21b,0x7c615022,0xf2ed7017,0x42d750e6}},	//   _dinara_, _dostlar_, _approach_, _třech_, 
   {{0x6227201e,0x223dd063,0xd201328d,0xe07a40eb}},	//   _전원주택펜션_, _huamhoj_, _dixin_, _временск, 
   {{0x7248d13f,0x646ed118,0x50b4e079,0x127e9084}},	//   _prema_, _драмы_, _импресия_, _abans_, 
   {{0xa2005174,0xc03fb07a,0x229ee095,0x343ee095}},	//   _milih_, _vertalin, _slobodni_, _slobodno_, 
   {{0x22005254,0x84be10b1,0xab2e40e6,0xe202600c}},	//   _bilik_, _зўравонл, _poradens, _aprill_, 
   {{0xa2fde182,0x3200509b,0x7f5d4142,0x825af0ee}},	//   _muzikos_, _cilik_, _दूंगा_, _soilik_, 
   {{0x52903170,0x430f3246,0x52d810cc,0x7ace0187}},	//   _dimana_, _roditelj, _kahel_, _संखुवासभ, 
   {{0xed035035,0x0d31405f,0x675ba069,0xbe3b1287}},	//   _最終更新日_, _رووووووو, _ہتھیاروں_, _kesadara, 
   {{0xcda913d7,0xc8a0c093,0x72942110,0x00f1c024}},	//   _факульте, _рұқсат_, _israyeli_, _हाईवे_, 
   {{0x3ef4d019,0xf2005010,0x42d8a074,0x58a41017}},	//   _становит, _bilih_, _vadovas_, _טריילר_, 
   {{0x217720a1,0xe38730d2,0x527ff046,0x67ed4106}},	//   _кесте_, _milionë_, _thung_, _futbalov, 
   {{0xf1e1a0a9,0x031b205f,0x508d9117,0x03009016}},	//   _ठाकरे_, _آعجبنيً_, _השיער_, _ראטעווען_, 
   {{0xe38ce074,0x43ac705b,0xd7fcc26f,0x52f5b069}},	//   _музея_, _respek_, _блоги_, _opciók_, 
   {{0x5e9230dd,0xa741d07d,0x86a8d13b,0xdb61f287}},	// [fd0] _портала_, _основні_, _multiply, _sinetron_, 
   {{0x4ea2f287,0x7c68317f,0x12d82006,0xbef7713c}},	//   _parlemen, _петрика_, _taken_, _pêdivî_, 
   {{0x327f7108,0xc387710e,0x50da5043,0x93005086}},	//   _quanto_, _anaran_, _написанн, _halaiki_, 
   {{0xa4ee119c,0x52da70dd,0x70f3a275,0xcdf150fe}},	//   _підготов, _meseca_, _भागवत_, _mendafta, 
   {{0x7e9f000c,0xc54a703c,0x02d820bd,0xa2ca7105}},	//   _विशेषज्ञ_, _アクセサリ_, _saken_, _sendt_, 
   {{0xd5fa6258,0x4201c032,0x00000000,0x00000000}},	//   _पुरोहित_, _invio_, --, --, 
   {{0x238a906b,0x32cb8068,0x625ad196,0x3837c079}},	//   _француск, _yerde_, _meeli_, _базате_, 
   {{0x729001d9,0x0425c110,0x00000000,0x00000000}},	//   _chiad_, _kusindik, --, --, 
   {{0x830cd0b4,0xf5ac1079,0x42b441c4,0x33a45017}},	//   _dihapus_, _глума_, _vendég_, _ההצטרפות_, 
   {{0x830e00cc,0x03b621e9,0xd27f724e,0x9a09c053}},	//   _sapatos_, _значення_, _asanga_, _takbirat, 
   {{0x1290a028,0x12d8c110,0x0201c340,0x0c5c60c5}},	//   _sedang_, _zalewa_, _envio_, _प्लेन_, 
   {{0x3e6c21ee,0xe2912191,0x6a12b1bd,0xdf2d5006}},	//   _فیروز_, _anyar_, _izaberit, _conferen, 
   {{0x575fe3d8,0xd9f7b187,0x83f400d2,0x8239528d}},	//   _विस्फोट_, _vydavate, _rastet_, _dermanê_, 
   {{0xc2ea007f,0x5290f132,0xff3890ef,0xaf202045}},	//   _beriman_, _bihara_, _kienthuc_, _موبايلات_, 
   {{0xc2d840db,0x4bc43197,0x42ea8260,0xa9359244}},	//   _namen_, _dekoráci, _helical_, _एक्स्प्ल, 
   {{0x01b3c138,0xc2d92297,0x33eae146,0x71d96210}},	//   _شاغرة_, _huyet_, _editja_, _кармалга, 
   {{0x8c3aa14c,0x439403d9,0x00000000,0x00000000}},	// [fe0] _историят, _ovisi_, --, --, 
   {{0xedff5358,0x2c7581f7,0x856d636f,0xa2d422ce}},	//   _rundinga, _सदस्यो_, _samosprá, _večernje_, 
   {{0x7611804a,0x1a5b7046,0x24d5b1f7,0xde72c1b2}},	//   _kritikal_, _nghành_, _काशिका_, _रिक्त_, 
   {{0xe290a10d,0x6e7c10bf,0x7c639145,0xad43d019}},	//   _hajati_, _मूख्य_, _milujem_, _великоле, 
   {{0x929071b2,0x615ba02f,0x7df16060,0xc0116023}},	//   _jinak_, _添加到收藏夹_, _hindista, _hindisto, 
   {{0x402e1155,0x3ac3b071,0x7bed0084,0xcc574299}},	//   _conditio, _बागपत_, _социалды, _postele_, 
   {{0x99207251,0xa9d8801a,0x8de073da,0x72d8d2d7}},	//   _mobilní_, _кестесі_, _mobilné_, _ordet_, 
   {{0xf300205e,0x1200a2f1,0xd784f21a,0xc84c7016}},	//   _najasyi_, _dibim_, _privatli, _ספֿרים_, 
   {{0x0297e0d6,0xaae8a11e,0xee4f8089,0xb390809e}},	//   _marafiki_, _retounen_, _malograđ, _abayizi_, 
   {{0x419580ab,0xc4982006,0x0a14429c,0xf25b00ee}},	//   _rezultāt, _מתמטיקה_, _vakantie, _aralar_, 
   {{0x5c1d612f,0x03eb904d,0xc71a3023,0xe387e0b9}},	//   _complet_, _reste_, _закачкал, _fatra_, 
   {{0x0f7831b5,0x1795a040,0x8378e0b4,0xbf3b91d6}},	//   _текста_, _centerpi, _kalawan_, _kerusaka, 
   {{0xe3eb91cb,0x5c1fc052,0xe9fb9069,0x00000000}},	//   _peste_, _slipper_, _tehetség, --, 
   {{0x13a8e128,0x428750bf,0x6c756286,0xe314b0b8}},	//   _dalawang_, _miliony_, _därmed_, _lambeth_, 
   {{0xd23cd01e,0x47c320bd,0x9d9df019,0x53eb3224}},	//   _환영합니다_, _лютого_, _maananta, _textu_, 
   {{0x4dc0505d,0x227f724e,0x5200730e,0xdebf4182}},	//   _intitola, _usanga_, _tinik_, _bendrovė, 
   {{0x4265e00e,0x42787019,0x50e3b017,0xdc67b128}},	// [ff0] _sukupuol, _kaunis_, _הרחבה_, _libreng_, 
   {{0x97db5321,0x1ae97087,0x5a8ca0db,0x08511151}},	//   _प्रकृति_, _sprememb, _optionen_, _衣锦荣归回乡路_, 
   {{0x817db006,0x7489f12a,0x54d041d6,0x00000000}},	//   _ליווי_, _опасност_, _मिलिंद_, --, 
   {{0x95f3a198,0xce9c108e,0x8b114168,0xd2926197}},	//   _момента_, _והארות_, _kompanya_, _porada_, 
   {{0x3e7380a9,0xc9f61121,0xc1dea149,0x1abf72b9}},	//   _दृश्य_, _توزیع_, _povratak_, _berjalan_, 
   {{0x22d8439a,0xec5be007,0x2245a074,0x825af12a}},	//   _tamen_, _partiti_, _эксперта, _negli_, 
   {{0x529011e3,0xf47e3127,0x3606800c,0xec7aa08c}},	//   _bihar_, _тилоӣ_, _चाँदी_, _sërish_, 
   {{0xc1691167,0x5828e0b0,0x52d76124,0xc27ed026}},	//   _методи_, _liệu_, _osvojio_, _mpeni_, 
   {{0x12d84206,0x53f841a7,0x32a62134,0x00000000}},	//   _samen_, _samun_, _semble_, --, 
   {{0x63ea9022,0xf5d15005,0x9290e081,0x13077039}},	//   _teatr_, _produktó, _munani_, _anyagok_, 
   {{0x4290c101,0x320021a5,0x5fcca301,0xc75a1006}},	//   _malati_, _mikir_, _artikler_, _וכמובן_, 
   {{0x82d96052,0x6814c006,0xad0bc296,0x651b32f1}},	//   _dagens_, _specific_, _melompat_, _mamostey, 
   {{0xc200205a,0x52d8d0f5,0xb2007099,0x73eb83db}},	//   _fikir_, _nrees_, _linii_, _merta_, 
   {{0x76371094,0xf2663079,0x51ad0084,0x8302d3db}},	//   _марказ_, _ансамблу_, _сайтынын_, _tuhanku_, 
   {{0x191f3138,0xe8cda122,0x524800ba,0x020e1280}},	//   _aistriúc, _додситон, _daima_, _масаж_, 
   {{0xf37961b4,0x00000000,0x00000000,0x00000000}},	//   _faransa_, --, --, --, 
  
  };
  // table_hash = 3eb2-6696, unused_entries = 1062 (6.48%)

static const uint32 kDeltaOctaChrome1015SizeOne = 988;    // Bucket count one-lang
extern const uint32 kDeltaOctaIndSize = kDeltaOctaChrome1015SizeOne; // Source-agnostic named constant
static const uint32 kDeltaOctaChrome1015Ind[988] = {
  // [0000]
  0x00000000, 0x00000000, 0x00001324, 0x00000e1c,   // -- --  bh.un.un_900 is.un.un_800 
  0x0000101c, 0x00000924, 0x00000115, 0x00002a2d,   // lt.un.un_800 pl.un.un_900  iw.un.un_700 mt.un.un_A00 
  0x00003015, 0x00001c03, 0x00001b2d, 0x0000552d,   // uz.un.un_700 id.un.un_300  tr.un.un_A00 rw.un.un_A00 
  0x00001342, 0x0000642d, 0x00000424, 0x00000c24,   // et.un.un_C00 lg.un.un_A00  fi.un.un_900 sv.un.un_900 
  // [0010]
  0x00002142, 0x00006e24, 0x19000a36, 0x0000202d,   // jw.un.un_C00 hmn.un.un_900  pt.gl.un_AA0 sq.un.un_A00 
  0x00000b24, 0x00001742, 0x0000240f, 0x0000010f,   // es.un.un_900 sr.un.un_C00  yi.un.un_600 iw.un.un_600 
  0x1c001e2c, 0x00000442, 0x00004415, 0x00003d2d,   // ms.id.un_990 fi.un.un_C00  kk.un.un_700 ku.un.un_A00 
  0x1700160e, 0x19000b1b, 0x00000315, 0x00005615,   // hr.sr.un_550 es.gl.un_770  ko.un.un_700 mg.un.un_700 
  // [0020]
  0x0000130a, 0x00001c2d, 0x00003142, 0x00003042,   // et.un.un_500 id.un.un_A00  az.un.un_C00 uz.un.un_C00 
  0x0000090f, 0x13000902, 0x00007337, 0x0d002d14,   // hi.un.un_600 hi.bh.un_220  ny.un.un_B00 sk.cs.un_660 
  0x1c001e09, 0x0000732d, 0x00000415, 0x2d000d23,   // ms.id.un_440 ny.un.un_A00  ru.un.un_700 cs.sk.un_880 
  0x00001006, 0x00003024, 0x09001309, 0x00000515,   // lt.un.un_400 uz.un.un_900  bh.hi.un_440 zh.un.un_700 
  // [0030]
  0x00001142, 0x00000a24, 0x00000724, 0x00001c15,   // ro.un.un_C00 pt.un.un_900  bg.un.un_900 id.un.un_700 
  0x00000742, 0x00000215, 0x00002824, 0x0000072d,   // it.un.un_C00 ja.un.un_700  sw.un.un_900 it.un.un_A00 
  0x0000201c, 0x00001242, 0x00000942, 0x00000e42,   // sq.un.un_800 ur.un.un_C00  pl.un.un_C00 is.un.un_C00 
  0x0000021c, 0x00000f42, 0x00000624, 0x00000d1c,   // ja.un.un_800 lv.un.un_C00  de.un.un_900 cs.un.un_800 
  // [0040]
  0x00006b0a, 0x00006e0f, 0x00001942, 0x00000842,   // ceb.un.un_500 hmn.un.un_600  gl.un.un_C00 uk.un.un_C00 
  0x00001f0f, 0x00001842, 0x00002b0f, 0x0000092d,   // cy.un.un_600 ga.un.un_C00  vi.un.un_600 hi.un.un_A00 
  0x1e001c2c, 0x00003d1c, 0x00006b15, 0x00001e03,   // id.ms.un_990 ku.un.un_800  ceb.un.un_700 ms.un.un_300 
  0x00001137, 0x00000524, 0x0000371c, 0x00000301,   // ro.un.un_B00 fr.un.un_900  st.un.un_800 nl.un.un_200 
  // [0050]
  0x00001315, 0x17001635, 0x00000c42, 0x1c001e14,   // et.un.un_700 hr.sr.un_A90  sv.un.un_C00 ms.id.un_660 
  0x00001e0f, 0x0000532d, 0x00006b03, 0x00005542,   // ms.un.un_600 ht.un.un_A00  ceb.un.un_300 rw.un.un_C00 
  0x00002501, 0x1c000912, 0x00003124, 0x00003f24,   // eu.un.un_200 hi.mr.un_640  az.un.un_900 af.un.un_900 
  0x00001737, 0x00002a37, 0x1c001e02, 0x0000180f,   // sr.un.un_B00 mt.un.un_B00  ms.id.un_220 ar.un.un_600 
  // [0060]
  0x00003d42, 0x09001c13, 0x0000031c, 0x00006e01,   // ku.un.un_C00 mr.hi.un_650  ko.un.un_800 hmn.un.un_200 
  0x00004424, 0x0000121c, 0x09001314, 0x00000f06,   // kk.un.un_900 ur.un.un_800  bh.hi.un_660 lv.un.un_400 
  0x00001b42, 0x00001215, 0x00002842, 0x00001724,   // tr.un.un_C00 ur.un.un_700  sw.un.un_C00 sr.un.un_900 
  0x08000236, 0x00003d15, 0x00000937, 0x00001f24,   // da.no.un_AA0 ku.un.un_700  pl.un.un_B00 cy.un.un_900 
  // [0070]
  0x1e001c04, 0x00000915, 0x00002315, 0x09001c1b,   // id.ms.un_320 pl.un.un_700  ky.un.un_700 mr.hi.un_770 
  0x0000100f, 0x00000b15, 0x00000703, 0x1c000d22,   // be.un.un_600 bn.un.un_700  bg.un.un_300 ne.mr.un_870 
  0x0000530f, 0x0000110f, 0x00003f42, 0x0d002d02,   // ht.un.un_600 ro.un.un_600  af.un.un_C00 sk.cs.un_220 
  0x0000082d, 0x0000081c, 0x1c001e22, 0x1c001e1b,   // uk.un.un_A00 uk.un.un_800  ms.id.un_870 ms.id.un_770 
  // [0080]
  0x0b000a2c, 0x0000551c, 0x00001b01, 0x00001a1c,   // pt.es.un_990 rw.un.un_800  tr.un.un_200 tl.un.un_800 
  0x00002342, 0x00000b1c, 0x0000281c, 0x0000291c,   // ca.un.un_C00 es.un.un_800  sw.un.un_800 sl.un.un_800 
  0x0000020f, 0x1700161b, 0x0000440a, 0x0000051c,   // ja.un.un_600 hr.sr.un_770  kk.un.un_500 fr.un.un_800 
  0x00002015, 0x00003f2d, 0x0000240a, 0x00000406,   // sq.un.un_700 af.un.un_A00  yi.un.un_500 ru.un.un_400 
  // [0090]
  0x00000d06, 0x16001722, 0x00000d15, 0x00004401,   // cs.un.un_400 sr.hr.un_870  cs.un.un_700 kk.un.un_200 
  0x00003515, 0x17001636, 0x19000b02, 0x1e001c21,   // tg.un.un_700 hr.sr.un_AA0  es.gl.un_220 id.ms.un_860 
  0x0000041c, 0x00000901, 0x00005515, 0x00002124,   // ru.un.un_800 hi.un.un_200  rw.un.un_700 jw.un.un_900 
  0x00003f1c, 0x00001f15, 0x0000641c, 0x00003242,   // af.un.un_800 cy.un.un_700  lg.un.un_800 bs.un.un_C00 
  // [00a0]
  0x00000f37, 0x00004442, 0x00001301, 0x00002924,   // lv.un.un_B00 kk.un.un_C00  et.un.un_200 sl.un.un_900 
  0x00000242, 0x17001602, 0x0000061c, 0x00001b1c,   // da.un.un_C00 hr.sr.un_220  de.un.un_800 tr.un.un_800 
  0x00002303, 0x00001c42, 0x00003137, 0x00000f24,   // ca.un.un_300 id.un.un_C00  az.un.un_B00 lv.un.un_900 
  0x0000290f, 0x3200171a, 0x1600172b, 0x00003715,   // sl.un.un_600 sr.bs.un_760  sr.hr.un_980 st.un.un_700 
  // [00b0]
  0x00002b0a, 0x0000301c, 0x00002324, 0x2d000d1b,   // vi.un.un_500 uz.un.un_800  ca.un.un_900 cs.sk.un_770 
  0x00002f42, 0x00001001, 0x19000a07, 0x00006b37,   // su.un.un_C00 be.un.un_200  pt.gl.un_420 ceb.un.un_B00 
  0x00006b24, 0x00005342, 0x00002815, 0x13001c0e,   // ceb.un.un_900 ht.un.un_C00  sw.un.un_700 mr.bh.un_550 
  0x00003742, 0x0000080a, 0x00002d0a, 0x00000d0f,   // st.un.un_C00 no.un.un_500  sk.un.un_500 ne.un.un_600 
  // [00c0]
  0x00002a06, 0x17001614, 0x00002f15, 0x00002415,   // mt.un.un_400 hr.sr.un_660  su.un.un_700 yi.un.un_700 
  0x00001f1c, 0x0d00090e, 0x00000601, 0x00003101,   // cy.un.un_800 hi.ne.un_550  de.un.un_200 az.un.un_200 
  0x0000030f, 0x00003737, 0x0000200a, 0x00000615,   // ko.un.un_600 st.un.un_B00  sq.un.un_500 de.un.un_700 
  0x00006b42, 0x0000230f, 0x0000181c, 0x1c00090e,   // ceb.un.un_C00 ky.un.un_600  ga.un.un_800 hi.mr.un_550 
  // [00d0]
  0x00007301, 0x0b000a23, 0x00002042, 0x0900132b,   // ny.un.un_200 pt.es.un_880  sq.un.un_C00 bh.hi.un_980 
  0x13000912, 0x00006e0a, 0x00002837, 0x00002801,   // hi.bh.un_640 hmn.un.un_500  sw.un.un_B00 sw.un.un_200 
  0x1c001323, 0x0200080e, 0x00000e37, 0x00000642,   // bh.mr.un_880 no.da.un_550  is.un.un_B00 de.un.un_C00 
  0x00003706, 0x0000171c, 0x00000c1c, 0x1c001e0e,   // st.un.un_400 sr.un.un_800  sv.un.un_800 ms.id.un_550 
  // [00e0]
  0x1c001e34, 0x00001703, 0x1e001c02, 0x00001101,   // ms.id.un_A80 sr.un.un_300  id.ms.un_220 ro.un.un_200 
  0x00002006, 0x0000131c, 0x00000d42, 0x0b00192a,   // sq.un.un_400 bh.un.un_800  ne.un.un_C00 gl.es.un_970 
  0x1c001e23, 0x00005506, 0x19000a1b, 0x00001715,   // ms.id.un_880 rw.un.un_400  pt.gl.un_770 sr.un.un_700 
  0x19000a02, 0x0900130e, 0x00002542, 0x00002b42,   // pt.gl.un_220 bh.hi.un_550  eu.un.un_C00 vi.un.un_C00 
  // [00f0]
  0x0000300a, 0x00000342, 0x00005642, 0x00005315,   // uz.un.un_500 nl.un.un_C00  mg.un.un_C00 ht.un.un_700 
  0x00006442, 0x00006e37, 0x0000251c, 0x0000080f,   // lg.un.un_C00 hmn.un.un_B00  eu.un.un_800 uk.un.un_600 
  0x00000b0f, 0x0000440f, 0x0d002d1b, 0x0000232d,   // bn.un.un_600 kk.un.un_600  sk.cs.un_770 ca.un.un_A00 
  0x16003222, 0x00001042, 0x1e001c23, 0x00003115,   // bs.hr.un_870 be.un.un_C00  id.ms.un_880 az.un.un_700 
  // [0100]
  0x0000311c, 0x00002f0f, 0x00001115, 0x00001337,   // az.un.un_800 su.un.un_600  ro.un.un_700 et.un.un_B00 
  0x00000e15, 0x02000802, 0x00002d1c, 0x0000022d,   // is.un.un_700 no.da.un_220  sk.un.un_800 da.un.un_A00 
  0x00000701, 0x00002742, 0x00000a01, 0x1c000936,   // it.un.un_200 gd.un.un_C00  mk.un.un_200 hi.mr.un_AA0 
  0x1600172a, 0x0000640a, 0x00005624, 0x00001b15,   // sr.hr.un_970 lg.un.un_500  mg.un.un_900 tr.un.un_700 
  // [0110]
  0x00007342, 0x00000d03, 0x0000040a, 0x00001924,   // ny.un.un_C00 cs.un.un_300  fi.un.un_500 gl.un.un_900 
  0x00003003, 0x00002f2d, 0x00002a42, 0x00000142,   // uz.un.un_300 su.un.un_A00  mt.un.un_C00 en.un.un_C00 
  0x0000102d, 0x00000401, 0x00001124, 0x0000300f,   // be.un.un_A00 fi.un.un_200  ro.un.un_900 uz.un.un_600 
  0x1100111b, 0x00002b37, 0x00005324, 0x32001605,   // ro.ro.un_770 vi.un.un_B00  ht.un.un_900 hr.bs.un_330 
  // [0120]
  0x09001c1a, 0x00002115, 0x0000351c, 0x00000c2d,   // mr.hi.un_760 jw.un.un_700  tg.un.un_800 sv.un.un_A00 
  0x1600171b, 0x0d001c1b, 0x0000350f, 0x00003501,   // sr.hr.un_770 mr.ne.un_770  tg.un.un_600 tg.un.un_200 
  0x00001a42, 0x00001c37, 0x00000715, 0x00000803,   // tl.un.un_C00 mr.un.un_B00  bg.un.un_700 no.un.un_300 
  0x13000909, 0x0b001902, 0x00001a2d, 0x0000111c,   // hi.bh.un_440 gl.es.un_220  tl.un.un_A00 ro.un.un_800 
  // [0130]
  0x09001323, 0x00006415, 0x00002f1c, 0x2d000d02,   // bh.hi.un_880 lg.un.un_700  su.un.un_800 cs.sk.un_220 
  0x00000542, 0x00007306, 0x0d000914, 0x0d002d23,   // fr.un.un_C00 ny.un.un_400  hi.ne.un_660 sk.cs.un_880 
  0x00001815, 0x00000501, 0x00000f2d, 0x00002f37,   // ga.un.un_700 fr.un.un_200  lv.un.un_A00 su.un.un_B00 
  0x00003d01, 0x00001f42, 0x0000200f, 0x16003235,   // ku.un.un_200 cy.un.un_C00  sq.un.un_600 bs.hr.un_A90 
  // [0140]
  0x17001623, 0x0000162d, 0x00000903, 0x00000306,   // hr.sr.un_880 hr.un.un_A00  hi.un.un_300 nl.un.un_400 
  0x00000c37, 0x00002d15, 0x00002a24, 0x00003542,   // sv.un.un_B00 sk.un.un_700  mt.un.un_900 tg.un.un_C00 
  0x00002d42, 0x16001736, 0x00001a37, 0x32001602,   // sk.un.un_C00 sr.hr.un_AA0  tl.un.un_B00 hr.bs.un_220 
  0x0000071c, 0x00002803, 0x00002037, 0x09001308,   // bg.un.un_800 sw.un.un_300  sq.un.un_B00 bh.hi.un_430 
  // [0150]
  0x00001a24, 0x0000050f, 0x0000100a, 0x19000b05,   // tl.un.un_900 zh.un.un_600  be.un.un_500 es.gl.un_330 
  0x00006b0f, 0x0000011c, 0x00000706, 0x0000302d,   // ceb.un.un_600 en.un.un_800  bg.un.un_400 uz.un.un_A00 
  0x16001702, 0x00006e03, 0x00003f0a, 0x0000372d,   // sr.hr.un_220 hmn.un.un_300  af.un.un_500 st.un.un_A00 
  0x00003f15, 0x00003001, 0x09001302, 0x0000352d,   // af.un.un_700 uz.un.un_200  bh.hi.un_220 tg.un.un_A00 
  // [0160]
  0x00000f01, 0x00001837, 0x0000212d, 0x08000205,   // lv.un.un_200 ga.un.un_B00  jw.un.un_A00 da.no.un_330 
  0x1700162c, 0x02000822, 0x00002a0f, 0x00000806,   // hr.sr.un_990 no.da.un_870  mt.un.un_600 no.un.un_400 
  0x00006b2d, 0x1c000914, 0x09000d2c, 0x0000170f,   // ceb.un.un_A00 hi.mr.un_660  ne.hi.un_990 sr.un.un_600 
  0x16001734, 0x00002942, 0x00003237, 0x0200081b,   // sr.hr.un_A80 sl.un.un_C00  bs.un.un_B00 no.da.un_770 
  // [0170]
  0x00001c1c, 0x00000f1c, 0x1c000902, 0x00006e42,   // id.un.un_800 lv.un.un_800  hi.mr.un_220 hmn.un.un_C00 
  0x0000211c, 0x00002d0f, 0x00001a01, 0x00001801,   // jw.un.un_800 sk.un.un_600  tl.un.un_200 ar.un.un_200 
  0x0000562d, 0x17001609, 0x0b000a36, 0x2d000d12,   // mg.un.un_A00 hr.sr.un_440  pt.es.un_AA0 cs.sk.un_640 
  0x00002337, 0x00000b42, 0x00000a42, 0x0000110a,   // ca.un.un_B00 es.un.un_C00  pt.un.un_C00 ro.un.un_500 
  // [0180]
  0x00002901, 0x09000d14, 0x00001024, 0x00003f03,   // sl.un.un_200 ne.hi.un_660  be.un.un_900 af.un.un_300 
  0x00001103, 0x1c000909, 0x00000224, 0x00000d01,   // ro.un.un_300 hi.mr.un_440  ja.un.un_900 cs.un.un_200 
  0x00000f15, 0x0a000b36, 0x00005524, 0x00001c01,   // lv.un.un_700 es.pt.un_AA0  rw.un.un_900 mr.un.un_200 
  0x0000730a, 0x1c001e08, 0x00005637, 0x1c001309,   // ny.un.un_500 ms.id.un_430  mg.un.un_B00 bh.mr.un_440 
  // [0190]
  0x00000237, 0x0000210f, 0x00000e2d, 0x0000531c,   // da.un.un_B00 jw.un.un_600  is.un.un_A00 ht.un.un_800 
  0x08000223, 0x00000a1c, 0x00003724, 0x00002d01,   // da.no.un_880 mk.un.un_800  st.un.un_900 sk.un.un_200 
  0x0000070a, 0x2d000d36, 0x1c001e35, 0x17001605,   // it.un.un_500 cs.sk.un_AA0  ms.id.un_A90 hr.sr.un_330 
  0x00000801, 0x1c000923, 0x0000040f, 0x0000442d,   // uk.un.un_200 hi.mr.un_880  fi.un.un_600 kk.un.un_A00 
  // [01a0]
  0x0000312d, 0x0000130f, 0x17001622, 0x00000f0f,   // az.un.un_A00 bh.un.un_600  hr.sr.un_870 lv.un.un_600 
  0x00000a37, 0x00002f24, 0x00006437, 0x00001e42,   // mk.un.un_B00 su.un.un_900  lg.un.un_B00 ms.un.un_C00 
  0x0000441c, 0x0000271c, 0x00002b15, 0x00002101,   // kk.un.un_800 gd.un.un_800  vi.un.un_700 fa.un.un_200 
  0x0000731c, 0x0000091c, 0x0000561c, 0x1c001e13,   // ny.un.un_800 pl.un.un_800  mg.un.un_800 ms.id.un_650 
  // [01b0]
  0x16003236, 0x00002524, 0x00000d24, 0x3200172c,   // bs.hr.un_AA0 eu.un.un_900  ne.un.un_900 sr.bs.un_990 
  0x00007324, 0x00001701, 0x00003d37, 0x0000070f,   // ny.un.un_900 sr.un.un_200  ku.un.un_B00 it.un.un_600 
  0x19000a23, 0x19000b23, 0x00002106, 0x0b000a1b,   // pt.gl.un_880 es.gl.un_880  jw.un.un_400 pt.es.un_770 
  0x00001e06, 0x16001721, 0x1c000d14, 0x0000640f,   // ms.un.un_400 sr.hr.un_860  ne.mr.un_660 lg.un.un_600 
  // [01c0]
  0x00002b24, 0x16003223, 0x13000936, 0x00006e2d,   // vi.un.un_900 bs.hr.un_880  hi.bh.un_AA0 hmn.un.un_A00 
  0x00001237, 0x0000052d, 0x0000231c, 0x00002915,   // ur.un.un_B00 fr.un.un_A00  ky.un.un_800 sl.un.un_700 
  0x00002024, 0x00001f2d, 0x00002306, 0x0000112d,   // sq.un.un_900 cy.un.un_A00  ca.un.un_400 ro.un.un_A00 
  0x1c000d35, 0x00001303, 0x00001e1c, 0x00002f01,   // ne.mr.un_A90 et.un.un_300  ms.un.un_800 su.un.un_200 
  // [01d0]
  0x00006b01, 0x00000d2d, 0x00000537, 0x00002706,   // ceb.un.un_200 cs.un.un_A00  fr.un.un_B00 gd.un.un_400 
  0x19000a2c, 0x00002a03, 0x00001c24, 0x00001015,   // pt.gl.un_990 mt.un.un_300  id.un.un_900 lt.un.un_700 
  0x0a000b23, 0x0000272d, 0x00002515, 0x00006406,   // es.pt.un_880 gd.un.un_A00  eu.un.un_700 lg.un.un_400 
  0x00003037, 0x00003f01, 0x0000120f, 0x00000a0f,   // uz.un.un_B00 af.un.un_200  ur.un.un_600 mk.un.un_600 
  // [01e0]
  0x1e001c36, 0x1e001c1b, 0x0000192d, 0x0000250f,   // id.ms.un_AA0 id.ms.un_770  gl.un.un_A00 eu.un.un_600 
  0x00002737, 0x0000210a, 0x00001b0f, 0x0000060a,   // gd.un.un_B00 jw.un.un_500  tr.un.un_600 de.un.un_500 
  0x00000a15, 0x00000815, 0x00005337, 0x00002301,   // mk.un.un_700 uk.un.un_700  ht.un.un_B00 ca.un.un_200 
  0x00002806, 0x00000c15, 0x00001224, 0x00001037,   // sw.un.un_400 sv.un.un_700  hu.un.un_900 lt.un.un_B00 
  // [01f0]
  0x1c001336, 0x00000824, 0x19000b36, 0x0a001923,   // bh.mr.un_AA0 uk.un.un_900  es.gl.un_AA0 gl.pt.un_880 
  0x09000d36, 0x00002d24, 0x09001313, 0x09001335,   // ne.hi.un_AA0 sk.un.un_900  bh.hi.un_650 bh.hi.un_A90 
  0x00002401, 0x0000560f, 0x00006424, 0x00002137,   // yi.un.un_200 mg.un.un_600  lg.un.un_900 jw.un.un_B00 
  0x32001636, 0x0000252d, 0x0000550f, 0x09001336,   // hr.bs.un_AA0 eu.un.un_A00  rw.un.un_600 bh.hi.un_AA0 
  // [0200]
  0x0800022c, 0x00000b01, 0x0b000a22, 0x00002437,   // da.no.un_990 es.un.un_200  pt.es.un_870 yi.un.un_B00 
  0x00000437, 0x2d000d13, 0x0000032d, 0x00001c0a,   // fi.un.un_B00 cs.sk.un_650  nl.un.un_A00 id.un.un_500 
  0x17001604, 0x00000124, 0x19000b2c, 0x00001601,   // hr.sr.un_320 en.un.un_900  es.gl.un_990 hr.un.un_200 
  0x32001609, 0x0000132d, 0x00000a0a, 0x00002724,   // hr.bs.un_440 et.un.un_A00  mk.un.un_500 gd.un.un_900 
  // [0210]
  0x0000230a, 0x00001106, 0x00006401, 0x1c001321,   // ky.un.un_500 ro.un.un_400  lg.un.un_200 bh.mr.un_860 
  0x0d002d35, 0x00001b24, 0x00000637, 0x0b000a09,   // sk.cs.un_A90 tr.un.un_900  de.un.un_B00 pt.es.un_440 
  0x11001136, 0x00003701, 0x08000209, 0x32001723,   // ro.ro.un_AA0 st.un.un_200  da.no.un_440 sr.bs.un_880 
  0x0000062d, 0x0a001905, 0x17001608, 0x00001206,   // de.un.un_A00 gl.pt.un_330  hr.sr.un_430 ur.un.un_400 
  // [0220]
  0x0000120a, 0x00002701, 0x00002537, 0x0000350a,   // ur.un.un_500 gd.un.un_200  eu.un.un_B00 tg.un.un_500 
  0x2d000d05, 0x00001a15, 0x00005603, 0x00000a06,   // cs.sk.un_330 tl.un.un_700  mg.un.un_300 mk.un.un_400 
  0x0000530a, 0x32001623, 0x00001615, 0x00005601,   // ht.un.un_500 hr.bs.un_880  hr.un.un_700 mg.un.un_200 
  0x00002a1c, 0x19000a0e, 0x0000280a, 0x1e001c08,   // mt.un.un_800 pt.gl.un_550  sw.un.un_500 id.ms.un_430 
  // [0230]
  0x0d002d0e, 0x0d002d09, 0x00002a15, 0x00002b06,   // sk.cs.un_550 sk.cs.un_440  mt.un.un_700 vi.un.un_400 
  0x09000d08, 0x0000161c, 0x02000805, 0x1000063f,   // ne.hi.un_430 hr.un.un_800  no.da.un_330 de.lt.un_B90 
  0x0a00192c, 0x0a000b2c, 0x00001e01, 0x0000370f,   // gl.pt.un_990 es.pt.un_990  ms.un.un_200 st.un.un_600 
  0x09001304, 0x00001003, 0x00007303, 0x32001635,   // bh.hi.un_320 be.un.un_300  ny.un.un_300 hr.bs.un_A90 
  // [0240]
  0x00000e24, 0x16001707, 0x00006e1c, 0x00000a2d,   // is.un.un_900 sr.hr.un_420  hmn.un.un_800 mk.un.un_A00 
  0x00001c06, 0x0000370a, 0x1600172c, 0x00006e15,   // id.un.un_400 st.un.un_500  sr.hr.un_990 hmn.un.un_700 
  0x09000d02, 0x0000172d, 0x00000837, 0x09000d04,   // ne.hi.un_220 sr.un.un_A00  uk.un.un_B00 ne.hi.un_320 
  0x2d000d2c, 0x09000d23, 0x00005537, 0x1c000913,   // cs.sk.un_990 ne.hi.un_880  rw.un.un_B00 hi.mr.un_650 
  // [0250]
  0x00001901, 0x00000d0a, 0x1e001c0d, 0x00001b0a,   // gl.un.un_200 cs.un.un_500  id.ms.un_540 tr.un.un_500 
  0x00001e24, 0x1e001c05, 0x00000106, 0x00001b03,   // ms.un.un_900 id.ms.un_330  en.un.un_400 tr.un.un_300 
  0x0d000902, 0x1e001c34, 0x00005501, 0x00001e0a,   // hi.ne.un_220 id.ms.un_A80  rw.un.un_200 ms.un.un_500 
  0x19000a09, 0x19000b34, 0x0000122d, 0x00000c01,   // pt.gl.un_440 es.gl.un_A80  ur.un.un_A00 sv.un.un_200 
  // [0260]
  0x00006b1c, 0x16001735, 0x0000270f, 0x00006403,   // ceb.un.un_800 sr.hr.un_A90  gd.un.un_600 lg.un.un_300 
  0x00003103, 0x0b001935, 0x1c000d02, 0x00002a01,   // az.un.un_300 gl.es.un_A90  ne.mr.un_220 mt.un.un_200 
  0x0d000909, 0x00002503, 0x0a001904, 0x00000103,   // hi.ne.un_440 eu.un.un_300  gl.pt.un_320 en.un.un_300 
  0x0000182d, 0x0d00091b, 0x00000d37, 0x00000403,   // ga.un.un_A00 hi.ne.un_770  cs.un.un_B00 ru.un.un_300 
  // [0270]
  0x00001201, 0x0a001935, 0x00000e06, 0x00000906,   // hu.un.un_200 gl.pt.un_A90  is.un.un_400 hi.un.un_400 
  0x1c000934, 0x09001c14, 0x1600321b, 0x08000202,   // hi.mr.un_A80 mr.hi.un_660  bs.hr.un_770 da.no.un_220 
  0x00002d06, 0x09001c02, 0x00001f37, 0x00001b37,   // sk.un.un_400 mr.hi.un_220  cy.un.un_B00 tr.un.un_B00 
  0x00002003, 0x00001f0a, 0x0a001936, 0x13000919,   // sq.un.un_300 cy.un.un_500  gl.pt.un_AA0 hi.bh.un_750 
  // [0280]
  0x00000737, 0x0a000b22, 0x00000101, 0x1c000d04,   // it.un.un_B00 es.pt.un_870  en.un.un_200 ne.mr.un_320 
  0x08000235, 0x02000823, 0x00000c0f, 0x00001c0f,   // da.no.un_A90 no.da.un_880  sv.un.un_600 id.un.un_600 
  0x0a00191b, 0x00000a03, 0x00005306, 0x2d000d09,   // gl.pt.un_770 mk.un.un_300  ht.un.un_400 cs.sk.un_440 
  0x1e001c1a, 0x00003d0f, 0x1c001e1a, 0x00000e01,   // id.ms.un_760 ku.un.un_600  ms.id.un_760 is.un.un_200 
  // [0290]
  0x00002906, 0x0800021b, 0x0000250a, 0x00000201,   // sl.un.un_400 da.no.un_770  eu.un.un_500 da.un.un_200 
  0x00000606, 0x00000506, 0x1c001e05, 0x00002b2d,   // de.un.un_400 fr.un.un_400  ms.id.un_330 vi.un.un_A00 
  0x00002406, 0x2d000d14, 0x0000282d, 0x1c001e2a,   // yi.un.un_400 cs.sk.un_660  sw.un.un_A00 ms.id.un_970 
  0x00000324, 0x0b001922, 0x0000050a, 0x00003f37,   // nl.un.un_900 gl.es.un_870  fr.un.un_500 af.un.un_B00 
  // [02a0]
  0x00000e0f, 0x0d000936, 0x00002d37, 0x0b000a2a,   // is.un.un_600 hi.ne.un_AA0  sk.un.un_B00 pt.es.un_970 
  0x00001e15, 0x0d002d21, 0x1300091b, 0x0a000b08,   // ms.un.un_700 sk.cs.un_860  hi.bh.un_770 es.pt.un_430 
  0x0000550a, 0x00006b06, 0x0000060f, 0x1c001335,   // rw.un.un_500 ceb.un.un_400  de.un.un_600 bh.mr.un_A90 
  0x0a000b34, 0x00001937, 0x1c001e07, 0x1c001314,   // es.pt.un_A80 gl.un.un_B00  ms.id.un_420 bh.mr.un_660 
  // [02b0]
  0x00002715, 0x0900183f, 0x00001306, 0x00000337,   // gd.un.un_700 ga.pl.un_B90  bh.un.un_400 nl.un.un_B00 
  0x00002001, 0x1600322c, 0x0b001923, 0x0a001934,   // sq.un.un_200 bs.hr.un_990  gl.es.un_880 gl.pt.un_A80 
  0x00001a06, 0x1e001c07, 0x16001705, 0x02000809,   // tl.un.un_400 id.ms.un_420  sr.hr.un_330 no.da.un_440 
  0x00001637, 0x00001a0a, 0x02000834, 0x0900130c,   // hr.un.un_B00 tl.un.un_500  no.da.un_A80 bh.hi.un_530 
  // [02c0]
  0x0b000a35, 0x0a001908, 0x00005303, 0x00001906,   // pt.es.un_A90 gl.pt.un_430  ht.un.un_300 gl.un.un_400 
  0x0d000912, 0x02000836, 0x16001723, 0x19000b08,   // hi.ne.un_640 no.da.un_AA0  sr.hr.un_880 es.gl.un_430 
  0x00001e2d, 0x3200162c, 0x00001706, 0x0000270a,   // ms.un.un_A00 hr.bs.un_990  sr.un.un_400 gd.un.un_500 
  0x00002d03, 0x0000310a, 0x0000170a, 0x00002703,   // sk.un.un_300 az.un.un_500  sr.un.un_500 gd.un.un_300 
  // [02d0]
  0x1600171a, 0x00002d2d, 0x09000d1a, 0x0b00192c,   // sr.hr.un_760 sk.un.un_A00  ne.hi.un_760 gl.es.un_990 
  0x00000b2d, 0x0000191c, 0x09000d13, 0x08000208,   // es.un.un_A00 gl.un.un_800  ne.hi.un_650 da.no.un_430 
  0x00001a03, 0x19000b04, 0x00000c06, 0x13000914,   // tl.un.un_300 es.gl.un_320  sv.un.un_400 hi.bh.un_660 
  0x00001824, 0x09000d2a, 0x0000020a, 0x2d000d21,   // ga.un.un_900 ne.hi.un_970  da.un.un_500 cs.sk.un_860 
  // [02e0]
  0x32001736, 0x32001705, 0x13000d21, 0x00003f0f,   // sr.bs.un_AA0 sr.bs.un_330  ne.bh.un_860 af.un.un_600 
  0x1c001e36, 0x00003d0a, 0x3200170e, 0x0000242d,   // ms.id.un_AA0 ku.un.un_500  sr.bs.un_550 yi.un.un_A00 
  0x00001803, 0x0800020e, 0x00003503, 0x08000234,   // ga.un.un_300 da.no.un_550  tg.un.un_300 da.no.un_A80 
  0x00001515, 0x00003d03, 0x13000d05, 0x16001709,   // un.un.un_700 ku.un.un_300  ne.bh.un_330 sr.hr.un_440 
  // [02f0]
  0x09001c0e, 0x00003d24, 0x19000a34, 0x0d00130e,   // mr.hi.un_550 ku.un.un_900  pt.gl.un_A80 bh.ne.un_550 
  0x0d002d2b, 0x00001203, 0x00003524, 0x00003f06,   // sk.cs.un_980 hu.un.un_300  tg.un.un_900 af.un.un_400 
  0x00000303, 0x00002f03, 0x1e001c09, 0x09000d05,   // nl.un.un_300 su.un.un_300  id.ms.un_440 ne.hi.un_330 
  0x00002506, 0x00002937, 0x00000c0a, 0x0000042d,   // eu.un.un_400 sl.un.un_B00  sv.un.un_500 ru.un.un_A00 
  // [0300]
  0x00002103, 0x0200082c, 0x00003537, 0x1300092c,   // fa.un.un_300 no.da.un_990  tg.un.un_B00 hi.bh.un_990 
  0x00007315, 0x0d001c14, 0x00004437, 0x0b001905,   // ny.un.un_700 mr.ne.un_660  kk.un.un_B00 gl.es.un_330 
  0x19000a21, 0x0d002d36, 0x00000203, 0x0d001309,   // pt.gl.un_860 sk.cs.un_AA0  da.un.un_300 bh.ne.un_440 
  0x00005503, 0x1e001c0e, 0x00001a0f, 0x1600322b,   // rw.un.un_300 id.ms.un_550  tl.un.un_600 bs.hr.un_980 
  // [0310]
  0x13000d2c, 0x0b000a14, 0x17001619, 0x2d000d19,   // ne.bh.un_990 pt.es.un_660  hr.sr.un_750 cs.sk.un_750 
  0x00003506, 0x09001312, 0x0000730f, 0x0d002d2c,   // tg.un.un_400 bh.hi.un_640  ny.un.un_600 sk.cs.un_990 
  0x0000310f, 0x09001307, 0x2d000d1a, 0x0000280f,   // az.un.un_600 bh.hi.un_420  cs.sk.un_760 sw.un.un_600 
  0x0d000913, 0x13000923, 0x13000905, 0x19000a05,   // hi.ne.un_650 hi.bh.un_880  hi.bh.un_330 pt.gl.un_330 
  // [0320]
  0x00001642, 0x0d000905, 0x0000292d, 0x00000e0a,   // hr.un.un_C00 hi.ne.un_330  sl.un.un_A00 is.un.un_500 
  0x13001c1b, 0x32001735, 0x0a001914, 0x00001603,   // mr.bh.un_770 sr.bs.un_A90  gl.pt.un_660 hr.un.un_300 
  0x291617a0, 0x09000d1b, 0x0b001936, 0x08000204,   // sr.hr.sl_322 ne.hi.un_770  gl.es.un_AA0 da.no.un_320 
  0x13000d04, 0x00003006, 0x02000814, 0x19000b09,   // ne.bh.un_320 uz.un.un_400  no.da.un_660 es.gl.un_440 
  // [0330]
  0x1e001c19, 0x11001109, 0x13000913, 0x19000b0e,   // id.ms.un_750 ro.ro.un_440  hi.bh.un_650 es.gl.un_550 
  0x00000503, 0x00000e03, 0x1c001302, 0x0b001934,   // fr.un.un_300 is.un.un_300  bh.mr.un_220 gl.es.un_A80 
  0x0800022a, 0x00005301, 0x0d00092c, 0x0000030a,   // da.no.un_970 ht.un.un_200  hi.ne.un_990 nl.un.un_500 
  0x0a001921, 0x1c000d2c, 0x0b000a21, 0x00001f06,   // gl.pt.un_860 ne.mr.un_990  pt.es.un_860 cy.un.un_400 
  // [0340]
  0x0b000a04, 0x00003106, 0x0200081a, 0x0b001904,   // pt.es.un_320 az.un.un_400  no.da.un_760 gl.es.un_320 
  0x0a001922, 0x00002b1c, 0x0b000a34, 0x00004403,   // gl.pt.un_870 vi.un.un_800  pt.es.un_A80 kk.un.un_300 
  0x0d002d22, 0x09000d2b, 0x09001c04, 0x1c001e21,   // sk.cs.un_870 ne.hi.un_980  mr.hi.un_320 ms.id.un_860 
  0x1300090e, 0x1c00130d, 0x0b000a0c, 0x0d001c35,   // hi.bh.un_550 bh.mr.un_540  pt.es.un_530 mr.ne.un_A90 
  // [0350]
  0x00002f06, 0x00001542, 0x00002424, 0x09000d07,   // su.un.un_400 un.un.un_C00  yi.un.un_900 ne.hi.un_420 
  0x2d000d04, 0x1c00091b, 0x00000137, 0x00001b06,   // cs.sk.un_320 hi.mr.un_770  en.un.un_B00 tr.un.un_400 
  0x00001e37, 0x0a000b07, 0x0d002d05, 0x09001c19,   // ms.un.un_B00 es.pt.un_420  sk.cs.un_330 mr.hi.un_750 
  0x19000b2b, 0x0d002d34, 0x11001114, 0x0b000a05,   // es.gl.un_980 sk.cs.un_A80  ro.ro.un_660 pt.es.un_330 
  // [0360]
  0x0b00191a, 0x3200172a, 0x1c001e04, 0x2d000d0e,   // gl.es.un_760 sr.bs.un_970  ms.id.un_320 cs.sk.un_550 
  0x2d000d08, 0x0d001323, 0x11001135, 0x09001c21,   // cs.sk.un_430 bh.ne.un_880  ro.ro.un_A90 mr.hi.un_860 
  0x09001c23, 0x2d000d07, 0x19000b35, 0x3200161b,   // mr.hi.un_880 cs.sk.un_420  es.gl.un_A90 hr.bs.un_770 
  0x11001102, 0x19000b14, 0x1c000d1b, 0x0d002d1a,   // ro.ro.un_220 es.gl.un_660  ne.mr.un_770 sk.cs.un_760 
  // [0370]
  0x00000f03, 0x09001c07, 0x0a000b04, 0x0d001314,   // lv.un.un_300 mr.hi.un_420  es.pt.un_320 bh.ne.un_660 
  0x19000b2a, 0x17001634, 0x0000290a, 0x1c00092c,   // es.gl.un_970 hr.sr.un_A80  sl.un.un_500 hi.mr.un_990 
  0x0800020d, 0x1100111a, 0x19000b07, 0x08000213,   // da.no.un_540 ro.ro.un_760  es.gl.un_420 da.no.un_650 
  0x0a001902, 0x1e1c1bd9, 0x0b000a02, 0x02000808,   // gl.pt.un_220 tr.id.ms_B87  pt.es.un_220 no.da.un_430 
  // [0380]
  0x19000a14, 0x32001614, 0x09000d19, 0x0900130d,   // pt.gl.un_660 hr.bs.un_660  ne.hi.un_750 bh.hi.un_540 
  0x00000206, 0x0000090a, 0x09001322, 0x1e001c2b,   // da.un.un_400 pl.un.un_500  bh.hi.un_870 id.ms.un_980 
  0x00001f01, 0x0d000923, 0x1e001c35, 0x11001121,   // cy.un.un_200 hi.ne.un_880  id.ms.un_A90 ro.ro.un_860 
  0x0d000904, 0x13001c14, 0x32001621, 0x2d000d34,   // hi.ne.un_320 mr.bh.un_660  hr.bs.un_860 cs.sk.un_A80 
  // [0390]
  0x16001714, 0x0000012d, 0x0000180a, 0x09001c05,   // sr.hr.un_660 en.un.un_A00  ga.un.un_500 mr.hi.un_330 
  0x0d000919, 0x0a000b02, 0x0000560a, 0x0800020c,   // hi.ne.un_750 es.pt.un_220  mg.un.un_500 da.no.un_530 
  0x00000b03, 0x1700162b, 0x0000190a, 0x00000603,   // es.un.un_300 hr.sr.un_980  gl.un.un_500 de.un.un_300 
  0x0900131b, 0x0000241c, 0x0d002d13, 0x16003205,   // bh.hi.un_770 yi.un.un_800  sk.cs.un_650 bs.hr.un_330 
  // [03a0]
  0x0b000a08, 0x09000d34, 0x00001806, 0x00002b01,   // pt.es.un_430 ne.hi.un_A80  ga.un.un_400 vi.un.un_200 
  0x08000207, 0x0a00192b, 0x09000d21, 0x1c000d1a,   // da.no.un_420 gl.pt.un_980  ne.hi.un_860 ne.mr.un_760 
  0x0d002d12, 0x00002f0a, 0x00002903, 0x11001134,   // sk.cs.un_640 su.un.un_500  sl.un.un_300 ro.ro.un_A80 
  0x0d002d19, 0x13000d14, 0x3200162a, 0x0a000b09,   // sk.cs.un_750 ne.bh.un_660  hr.bs.un_970 es.pt.un_440 
  // [03b0]
  0x11001123, 0x1600170d, 0x00003703, 0x00001624,   // ro.ro.un_880 sr.hr.un_540  st.un.un_300 hr.un.un_900 
  0x1700161a, 0x0b00192b, 0x09001319, 0x1c000d23,   // hr.sr.un_760 gl.es.un_980  bh.hi.un_750 ne.mr.un_880 
  0x1c000d13, 0x0d00130d, 0x0a001909, 0x0d001c1a,   // ne.mr.un_650 bh.ne.un_540  gl.pt.un_440 mr.ne.un_760 
  0x00001606, 0x1600320d, 0x0a000b1b, 0x1c00131b,   // hr.un.un_400 bs.hr.un_540  es.pt.un_770 bh.mr.un_770 
  // [03c0]
  0x3200171b, 0x16001704, 0x16001708, 0x08000214,   // sr.bs.un_770 sr.hr.un_320  sr.hr.un_430 da.no.un_660 
  0x1c000d08, 0x0a00191a, 0x09001334, 0x00005606,   // ne.mr.un_430 gl.pt.un_760  bh.hi.un_A80 mg.un.un_400 
  0x2d000d35, 0x0800022b, 0x0d002d0d, 0x16003234,   // cs.sk.un_A90 da.no.un_980  sk.cs.un_540 bs.hr.un_A80 
  0x0a000b2a, 0x19000a08, 0x13000934, 0x09001c09,   // es.pt.un_970 pt.gl.un_430  hi.bh.un_A80 mr.hi.un_440 
  // [03d0] --- double_langprob_start=03dc ---
  0x13000d23, 0x0d001c05, 0x1c000904, 0x1c000d0e,   // ne.bh.un_880 mr.ne.un_330  hi.mr.un_320 ne.mr.un_550 
  0x0d00131b, 0x1c000905, 0x0a000b0d, 0x00004406,   // bh.ne.un_770 hi.mr.un_330  es.pt.un_540 kk.un.un_400 
  0x09001305, 0x32001604, 0x0d002d07, 0x1c001e19,   // bh.hi.un_330 hr.bs.un_320  sk.cs.un_420 ms.id.un_750 
                                                    // 
  };

//  COMPILE_ASSERT(988 <= 4096, k_indirectbits_too_small);

extern const CLD2TableSummary kDeltaOcta_obj = {
  kDeltaOctaChrome1015,
  kDeltaOctaChrome1015Ind,
  kDeltaOctaChrome1015SizeOne,
  kDeltaOctaChrome1015Size,
  kDeltaOctaChrome1015KeyMask,
  kDeltaOctaChrome1015BuildDate,
  kDeltaOctaChrome1015RecognizedLangScripts,
};

static const uint32 kDeltaOctaChrome1015_2Size = 0;    // Bucket count
static const uint32 kDeltaOctaChrome1015_2KeyMask = 0xffffffff;    // Mask hash key

// NOTE: Some compilers will not allow an array of structs to have a constant
//       size of zero. Thus, we tell the code that the size is zero, but
//       actually allocate a single element array that will never be read.
//       More info: https://code.google.com/p/cld2/issues/detail?id=9
static const IndirectProbBucket4 kDeltaOctaChrome1015_2[1] = {
  // hash_indirect[4], tokens[4] in UTF-8
  {0x00000000,0x00000000,0x00000000,0x00000000} // UNUSED, see above!
  };
  // table_hash = ffff-ffff, unused_entries = 0 (0.00%)

static const uint32 kDeltaOctaChrome1015_2SizeOne = 2;    // Bucket count one-lang
extern const uint32 kDeltaOcta2IndSize = kDeltaOctaChrome1015_2SizeOne; // Source-agnostic named constant
static const uint32 kDeltaOctaChrome1015_2Ind[2] = {
  // [0000] --- double_langprob_start=0002 ---
  0x00000000, 0x00000000,                           // -- --  
                                                    // 
  };

extern const CLD2TableSummary kDeltaOcta_obj2 = {
  kDeltaOctaChrome1015_2,
  kDeltaOctaChrome1015_2Ind,
  kDeltaOctaChrome1015_2SizeOne,
  kDeltaOctaChrome1015_2Size,
  kDeltaOctaChrome1015_2KeyMask,
  kDeltaOctaChrome1015BuildDate,
  kDeltaOctaChrome1015RecognizedLangScripts,
};

}       // End namespace CLD2

// End of generated tables
