function (assess_target_property target)
  get_target_property(target_val "${target}" IMPORTED_GLOBAL)
  message(STATUS "IMPORTED TARGET ${target} has GLOBAL scope: ${target_val}")
endfunction ()

list(INSERT CMAKE_MODULE_PATH 0 ${CMAKE_CURRENT_SOURCE_DIR}/PackageRoot)

find_package(GlobalTarget GLOBAL REQUIRED)
assess_target_property(imported_local_target)
assess_target_property(imported_global_target)
assess_target_property(imported_local_ex)
assess_target_property(imported_global_ex)
assess_target_property(Foo1)
assess_target_property(Foo2)

set(CMAKE_FIND_PACKAGE_TARGETS_GLOBAL TRUE)
find_package(GlobalVarTarget)
assess_target_property(imported_var_local_target)
assess_target_property(imported_var_global_target)
assess_target_property(imported_var_local_ex)
assess_target_property(imported_var_global_ex)
set(CMAKE_FIND_PACKAGE_TARGETS_GLOBAL OFF)

find_package(LocalTarget)
assess_target_property(imported_global_lib)
assess_target_property(imported_explicit_global_ex)
assess_target_property(imported_local_lib)
assess_target_property(imported_implied_local_ex)

find_package(GlobalTargetNoVar GLOBAL)
assess_target_property(imported_no_var_local_target)
assess_target_property(imported_no_var_global_target)
assess_target_property(imported_no_var_local_ex)
assess_target_property(imported_no_var_global_ex)
assess_target_property(not_imported_not_global)

set(Baz_DIR "${CMAKE_CURRENT_SOURCE_DIR}/PackageRoot")
find_package(Baz GLOBAL REQUIRED)
assess_target_property(PackName)
assess_target_property(PackNameExe)
assess_target_property(PackName1)
assess_target_property(PackNameExe1)

set(Biz_DIR "${CMAKE_CURRENT_SOURCE_DIR}/PackageRoot")
find_package(Biz REQUIRED)
assess_target_property(local_lib_glob)
assess_target_property(local_exe_glob)
assess_target_property(local_lib)
assess_target_property(local_exe)

set(CMAKE_FIND_PACKAGE_TARGETS_GLOBAL TRUE)
set(Simple_DIR "${CMAKE_CURRENT_SOURCE_DIR}/PackageRoot")
find_package(Simple REQUIRED)
assess_target_property(LT1)
assess_target_property(LT2)
assess_target_property(LT3)
assess_target_property(LT4)
