// Code generated by cuelang.org/go/pkg/gen. DO NOT EDIT.

package math

import (
	"cuelang.org/go/internal/core/adt"
	"cuelang.org/go/internal/pkg"
)

func init() {
	pkg.Register("math", p)
}

var _ = adt.TopKind // in case the adt package isn't used

var p = &pkg.Package{
	Native: []*pkg.Builtin{{
		Name:  "MaxExp",
		Const: "2147483647",
	}, {
		Name:  "MinExp",
		Const: "-2147483648",
	}, {
		Name:  "MaxPrec",
		Const: "4294967295",
	}, {
		Name:  "ToNearestEven",
		Const: "0",
	}, {
		Name:  "ToNearestAway",
		Const: "1",
	}, {
		Name:  "ToZero",
		Const: "2",
	}, {
		Name:  "AwayFromZero",
		Const: "3",
	}, {
		Name:  "ToNegativeInf",
		Const: "4",
	}, {
		Name:  "ToPositiveInf",
		Const: "5",
	}, {
		Name:  "Below",
		Const: "-1",
	}, {
		Name:  "Exact",
		Const: "0",
	}, {
		Name:  "Above",
		Const: "1",
	}, {
		Name: "Jacobi",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
			{Kind: adt.IntKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			x, y := c.BigInt(0), c.BigInt(1)
			if c.Do() {
				c.Ret = Jacobi(x, y)
			}
		},
	}, {
		Name:  "MaxBase",
		Const: "62",
	}, {
		Name: "Floor",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Decimal(0)
			if c.Do() {
				c.Ret, c.Err = Floor(x)
			}
		},
	}, {
		Name: "Ceil",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Decimal(0)
			if c.Do() {
				c.Ret, c.Err = Ceil(x)
			}
		},
	}, {
		Name: "Trunc",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Decimal(0)
			if c.Do() {
				c.Ret, c.Err = Trunc(x)
			}
		},
	}, {
		Name: "Round",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Decimal(0)
			if c.Do() {
				c.Ret, c.Err = Round(x)
			}
		},
	}, {
		Name: "RoundToEven",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Decimal(0)
			if c.Do() {
				c.Ret, c.Err = RoundToEven(x)
			}
		},
	}, {
		Name: "MultipleOf",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
			{Kind: adt.NumberKind},
		},
		Result: adt.BoolKind,
		Func: func(c *pkg.CallCtxt) {
			x, y := c.Decimal(0), c.Decimal(1)
			if c.Do() {
				c.Ret, c.Err = MultipleOf(x, y)
			}
		},
	}, {
		Name: "Abs",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Decimal(0)
			if c.Do() {
				c.Ret, c.Err = Abs(x)
			}
		},
	}, {
		Name: "Acosh",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Acosh(x)
			}
		},
	}, {
		Name: "Asin",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Asin(x)
			}
		},
	}, {
		Name: "Acos",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Acos(x)
			}
		},
	}, {
		Name: "Asinh",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Asinh(x)
			}
		},
	}, {
		Name: "Atan",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Atan(x)
			}
		},
	}, {
		Name: "Atan2",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			y, x := c.Float64(0), c.Float64(1)
			if c.Do() {
				c.Ret = Atan2(y, x)
			}
		},
	}, {
		Name: "Atanh",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Atanh(x)
			}
		},
	}, {
		Name: "Cbrt",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Decimal(0)
			if c.Do() {
				c.Ret, c.Err = Cbrt(x)
			}
		},
	}, {
		Name:  "E",
		Const: "2.71828182845904523536028747135266249775724709369995957496696763",
	}, {
		Name:  "Pi",
		Const: "3.14159265358979323846264338327950288419716939937510582097494459",
	}, {
		Name:  "Phi",
		Const: "1.61803398874989484820458683436563811772030917980576286213544861",
	}, {
		Name:  "Sqrt2",
		Const: "1.41421356237309504880168872420969807856967187537694807317667974",
	}, {
		Name:  "SqrtE",
		Const: "1.64872127070012814684865078781416357165377610071014801157507931",
	}, {
		Name:  "SqrtPi",
		Const: "1.77245385090551602729816748334114518279754945612238712821380779",
	}, {
		Name:  "SqrtPhi",
		Const: "1.27201964951406896425242246173749149171560804184009624861664038",
	}, {
		Name:  "Ln2",
		Const: "0.693147180559945309417232121458176568075500134360255254120680009",
	}, {
		Name:  "Log2E",
		Const: "1.442695040888963407359924681001892137426645954152985934135449408",
	}, {
		Name:  "Ln10",
		Const: "2.3025850929940456840179914546843642076011014886287729760333278",
	}, {
		Name:  "Log10E",
		Const: "0.43429448190325182765112891891660508229439700580366656611445378",
	}, {
		Name: "Copysign",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x, y := c.Decimal(0), c.Decimal(1)
			if c.Do() {
				c.Ret = Copysign(x, y)
			}
		},
	}, {
		Name: "Dim",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x, y := c.Decimal(0), c.Decimal(1)
			if c.Do() {
				c.Ret, c.Err = Dim(x, y)
			}
		},
	}, {
		Name: "Erf",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Erf(x)
			}
		},
	}, {
		Name: "Erfc",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Erfc(x)
			}
		},
	}, {
		Name: "Erfinv",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Erfinv(x)
			}
		},
	}, {
		Name: "Erfcinv",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Erfcinv(x)
			}
		},
	}, {
		Name: "Exp",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Decimal(0)
			if c.Do() {
				c.Ret, c.Err = Exp(x)
			}
		},
	}, {
		Name: "Exp2",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Decimal(0)
			if c.Do() {
				c.Ret, c.Err = Exp2(x)
			}
		},
	}, {
		Name: "Expm1",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Expm1(x)
			}
		},
	}, {
		Name: "Gamma",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Gamma(x)
			}
		},
	}, {
		Name: "Hypot",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			p, q := c.Float64(0), c.Float64(1)
			if c.Do() {
				c.Ret = Hypot(p, q)
			}
		},
	}, {
		Name: "J0",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = J0(x)
			}
		},
	}, {
		Name: "Y0",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Y0(x)
			}
		},
	}, {
		Name: "J1",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = J1(x)
			}
		},
	}, {
		Name: "Y1",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Y1(x)
			}
		},
	}, {
		Name: "Jn",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			n, x := c.Int(0), c.Float64(1)
			if c.Do() {
				c.Ret = Jn(n, x)
			}
		},
	}, {
		Name: "Yn",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			n, x := c.Int(0), c.Float64(1)
			if c.Do() {
				c.Ret = Yn(n, x)
			}
		},
	}, {
		Name: "Ldexp",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
			{Kind: adt.IntKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			frac, exp := c.Float64(0), c.Int(1)
			if c.Do() {
				c.Ret = Ldexp(frac, exp)
			}
		},
	}, {
		Name: "Log",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Decimal(0)
			if c.Do() {
				c.Ret, c.Err = Log(x)
			}
		},
	}, {
		Name: "Log10",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Decimal(0)
			if c.Do() {
				c.Ret, c.Err = Log10(x)
			}
		},
	}, {
		Name: "Log2",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Decimal(0)
			if c.Do() {
				c.Ret, c.Err = Log2(x)
			}
		},
	}, {
		Name: "Log1p",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Log1p(x)
			}
		},
	}, {
		Name: "Logb",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Logb(x)
			}
		},
	}, {
		Name: "Ilogb",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.IntKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Ilogb(x)
			}
		},
	}, {
		Name: "Mod",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x, y := c.Float64(0), c.Float64(1)
			if c.Do() {
				c.Ret = Mod(x, y)
			}
		},
	}, {
		Name: "Pow",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x, y := c.Decimal(0), c.Decimal(1)
			if c.Do() {
				c.Ret, c.Err = Pow(x, y)
			}
		},
	}, {
		Name: "Pow10",
		Params: []pkg.Param{
			{Kind: adt.IntKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			n := c.Int32(0)
			if c.Do() {
				c.Ret = Pow10(n)
			}
		},
	}, {
		Name: "Remainder",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x, y := c.Float64(0), c.Float64(1)
			if c.Do() {
				c.Ret = Remainder(x, y)
			}
		},
	}, {
		Name: "Signbit",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.BoolKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Decimal(0)
			if c.Do() {
				c.Ret = Signbit(x)
			}
		},
	}, {
		Name: "Cos",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Cos(x)
			}
		},
	}, {
		Name: "Sin",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Sin(x)
			}
		},
	}, {
		Name: "Sinh",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Sinh(x)
			}
		},
	}, {
		Name: "Cosh",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Cosh(x)
			}
		},
	}, {
		Name: "Sqrt",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Sqrt(x)
			}
		},
	}, {
		Name: "Tan",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Tan(x)
			}
		},
	}, {
		Name: "Tanh",
		Params: []pkg.Param{
			{Kind: adt.NumberKind},
		},
		Result: adt.NumberKind,
		Func: func(c *pkg.CallCtxt) {
			x := c.Float64(0)
			if c.Do() {
				c.Ret = Tanh(x)
			}
		},
	}},
}
