; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

[Setup]
AppName=Graphite Compiler
AppVerName=Graphite Compiler 5.2.1
AppPublisher=SIL International
AppPublisherURL=http://graphite.sil.org/
AppSupportURL=http://graphite.sil.org/
AppUpdatesURL=http://graphite.sil.org/
DefaultDirName=C:\Program Files\Graphite Compiler
; Start Menu item name:
DefaultGroupName=Graphite Compiler
; allows them to say they don't want a start menu item:
AllowNoIcons=yes
; installer file name:
OutputBaseFilename=grcompiler_setup_5_2_1
Compression=lzma
SolidCompression=yes
LicenseFile= "..\..\license\LICENSING.txt"
InfoAfterFile= "..\..\installer\readme.txt"

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Files]
Source: "..\..\build\compiler\Release\grcompiler.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "..\..\build\compiler\Release\icuuc66.dll"; DestDir: "{app}"; Flags: ignoreversion
Source: "..\..\build\compiler\Release\icudt66.dll"; DestDir: "{app}"; Flags: ignoreversion
; Don't need this because the ICU stuff is built with /MT:
;Source: "C:\Windows\system32\msvcr71.dll"; DestDir: "{app}"; Flags: ignoreversion
Source: "..\..\build\preprocessor\Release\gdlpp.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "..\..\installer\readme.txt"; DestDir: "{app}"; Flags: ignoreversion
Source: "..\..\compiler\stddef.gdh"; DestDir: "{app}"; Flags: ignoreversion
;Source: "..\..\installer\gr_buildbat.bat"; DestDir: "{app}"; Flags: ignoreversion
Source: "..\..\doc\CompilerDebugFiles.pdf"; DestDir: "{app}\doc"; Flags: ignoreversion
Source: "..\..\doc\CppDoc.pdf"; DestDir: "{app}\doc"; Flags: ignoreversion
Source: "..\..\doc\GDL.pdf"; DestDir: "{app}\doc"; Flags: ignoreversion
Source: "..\..\doc\GDL_BNF.pdf"; DestDir: "{app}\doc"; Flags: ignoreversion
Source: "..\..\doc\GraphiteOverview.pdf"; DestDir: "{app}\doc"; Flags: ignoreversion
Source: "..\..\doc\GTF_6_0.pdf"; DestDir: "{app}\doc"; Flags: ignoreversion
Source: "..\..\doc\StackMachineCommands.pdf"; DestDir: "{app}\doc"; Flags: ignoreversion
Source: "..\..\installer\example\stddr.ttf"; DestDir: "{app}\example"; Flags: ignoreversion
Source: "..\..\installer\example\allcaps.gdl"; DestDir: "{app}\example"; Flags: ignoreversion
Source: "..\..\installer\example\allcaps_test.html"; DestDir: "{app}\example"; Flags: ignoreversion
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Icons]
;Name: "{group}\Run GrCompiler"; Filename: "{app}\GrCompiler.exe"
Name: "{group}\Read-Me"; Filename: "{app}\readme.txt"
Name: "{group}\GDL documentation"; Filename: "{app}\doc\GDL.pdf"
Name: "{group}\Compiler Debug Files Doc"; Filename: "{app}\doc\CompilerDebugFiles.pdf"
Name: "{commondesktop}\Graphite Compiler"; Filename: "{app}\GrCompiler.exe"; Tasks: desktopicon

[Registry]
Root: HKLM; Subkey: "SYSTEM\CurrentControlSet\Control\Session Manager\Environment"; ValueType: string; ValueName: "GDLPP_PREFS"; ValueData: "-I{code:GetShortName|{app}}"; Flags: uninsdeletevalue
Root: HKLM; Subkey: "SYSTEM\CurrentControlSet\Control\Session Manager\Environment"; ValueType: expandsz; ValueName: "Path"; ValueData: "{olddata};{app}"; Check: NeedsAddPath(ExpandConstant('{app}'))


[Messages]
ClickFinish=Click Finish to exit Setup.

[Code]
function SendMessage(const Wnd: HWND; const Msg, WParam: LongInt; LParam: AnsiString): Longint; external 'SendMessageA@user32.dll stdcall'; 

procedure CurStepChanged(CurStep: TSetupStep);
begin
  Log('CurStepChanged(' + IntToStr(Ord(CurStep)) + ') called');
  if CurStep = ssPostInstall then
  begin
    // Inform all windows that the environment has changed (ie, via the registry). Note that 26 = x1A.
    // Above we redefine the SendMessage function because a call with "Environment" needs to have that argument
    // interpreted as a string.
    SendMessage(-1, 26, 0, 'Environment');
  end;
end;

// Check if install directory should be added to the PATH
// see https://stackoverflow.com/questions/3304463/how-do-i-modify-the-path-environment-variable-when-running-an-inno-setup-install
function NeedsAddPath(NewDir: string): boolean;
var
  OrigPath: string;
begin
  if not RegQueryStringValue(HKEY_LOCAL_MACHINE,
    'SYSTEM\CurrentControlSet\Control\Session Manager\Environment',
    'Path', OrigPath)
  then
    Result := True  // Didn't find any path.
  else
    // Look for the directory to add, with leading and trailing semicolon.
    // Pos() returns 0 if not found.
    Result := (Pos(';' + NewDir + ';', ';' + OrigPath + ';') = 0);
end;

