/*
 *  $Id: version.c 27855 2025-04-18 09:57:38Z yeti-dn $
 *  Copyright (C) 2006 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "config.h"
#include <libgwyddion/macros.h>
#include <libgwyddion/version.h>

/**
 * gwy_version_major:
 *
 * Gets the major version of Gwyddion.
 *
 * If the version is 3.20.20261013., this function returns 3.
 *
 * The function provides run-time version information. See %GWY_VERSON_MAJOR for compile-time version information.
 *
 * Returns: The major version.
 **/
gint
gwy_version_major(void)
{
    return GWY_VERSION_MAJOR;
}

/**
 * gwy_version_minor:
 *
 * Gets the minor version of Gwyddion.
 *
 * If the version is 3.20.20261013., this function returns 20.
 *
 * The function provides run-time version information. See %GWY_VERSON_MINOR for compile-time version information.
 *
 * Returns: The minor version.
 **/
gint
gwy_version_minor(void)
{
    return GWY_VERSION_MINOR;
}

/**
 * gwy_version_string:
 *
 * Gets the full Gwyddion version as a string.
 *
 * If the version is 3.20.20261013., this function returns<literal>"3.20.20261013"</literal> .
 *
 * The function provides run-time version information. See %GWY_VERSON_STRING for compile-time version information.
 *
 * This is the only method to get finer version information than major.minor. However, only development versions use
 * finer versioning than major.minor. Therefore, a module or program requiring such information is probably broken
 * anyway. A meaningful use is to advertise the version of Gwyddion libraries your program runs with.
 *
 * Returns: The full version as a constant string.
 **/
const gchar*
gwy_version_string(void)
{
    return GWY_VERSION_STRING;
}

/**
 * SECTION: version
 * @title: Version
 * @short_description: Version information
 *
 * Macros like %GWY_VERSION_MAJOR can be used for compile-time version checks, that is they tell what version a module
 * or app is being compiled or was compiled with.
 *
 * On the other hand functions like gwy_version_major() can be used to run-time version checks and they tell what
 * version a module or app was linked or is running with.
 **/

/**
 * GWY_VERSION_MAJOR:
 *
 * Expands to the major version of Gwyddion as a number.
 *
 * If the version is 3.20.20261013., this macro is defined as 3.
 *
 * The macro provides compile-time version information. See gwy_version_major() for run-time version information.
 **/

/**
 * GWY_VERSION_MINOR:
 *
 * Expands to the minor version of Gwyddion as a number.
 *
 * If the version is 3.20.20261013., this macro is defined as 20.
 *
 * The macro provides compile-time version information. See gwy_version_minor() for run-time version information.
 **/

/**
 * GWY_VERSION_STRING:
 *
 * Expands to the full Gwyddion version as a string.
 *
 * If the version is 3.20.20261013., this macro is defined as <literal>"3.20.20261013"</literal>.
 *
 * The macro provides compile-time version information. See gwy_version_major() for run-time version information.
 * Also see gwy_version_string() for caveats. A meaningful use of this macro might perhaps be to advertise the version
 * of Gwyddion libraries your program was compiled with.
 **/

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
