"""
This Python type stubs file is only here to support checking of lldb_bson.py.
The type/member/constant listings in here are incomplete, as only those that
are used in lldb_bson have been transcribed from the LLDB Python API
documentation. Refer: https://lldb.llvm.org/python_api.html
"""

from typing import IO, Any, NoReturn, Sequence, TypeAlias

_Pointer: TypeAlias = int
_Size: TypeAlias = int
_Offset: TypeAlias = int
_InternalDict: TypeAlias = dict[str, Any]

class SBError:
    def __init__(self) -> None: ...
    @property
    def success(self) -> bool: ...
    @property
    def fail(self) -> bool: ...
    @property
    def description(self) -> str: ...

class SBDebugger:
    def __init__(self, _: NoReturn) -> None: ...
    def HandleCommand(self, command: str) -> None: ...
    def GetErrorFileHandle(self) -> IO[str]: ...
    def GetSelectedTarget(self) -> SBTarget | None: ...

class SBAddress:
    def __init__(self) -> None: ...
    @property
    def offset(self) -> type: ...
    @property
    def load_addr(self) -> _Pointer: ...
    def SetLoadAddress(self, addr: _Pointer, tgt: SBTarget) -> None: ...

class SBData:
    def GetSignedInt32(self, err: SBError, off: _Offset) -> int: ...
    @staticmethod
    def CreateDataFromUInt64Array(endian: ByteOrderType, size: _Size, dat: Sequence[int]) -> SBData: ...
    @staticmethod
    def CreateDataFromCString(endian: ByteOrderType, size: _Size, s: str) -> SBData: ...

    byte_order: ByteOrderType

    @property
    def uint8(self) -> Sequence[int]: ...
    @property
    def uint32(self) -> Sequence[int]: ...
    @property
    def uint64(self) -> Sequence[int]: ...
    @property
    def size(self) -> int: ...
    def ReadRawData(self, err: SBError, off: _Offset, size: _Size) -> bytes: ...
    def GetAddress(self, err: SBError, off: _Offset) -> _Pointer: ...
    def GetUnsignedInt32(self, err: SBError, off: _Offset) -> int: ...
    def GetUnsignedInt64(self, err: SBError, off: _Offset) -> int: ...

class SBValue:
    def Dereference(self) -> SBValue: ...
    def TypeIsPointerType(self) -> bool: ...
    def GetChildMemberWithName(self, name: str) -> SBValue: ...
    def GetValueAsUnsigned(self) -> int: ...
    def Cast(self, type: SBType) -> SBValue: ...
    def GetAddress(self) -> SBAddress: ...
    def GetData(self) -> SBData: ...
    def GetNonSyntheticValue(self) -> SBValue: ...
    def CreateChildAtOffset(self, name: str, offset: _Offset, type: SBType) -> SBValue: ...
    def CreateValueFromData(self, name: str, data: SBData, type: SBType) -> SBValue: ...
    def CreateValueFromAddress(self, name: str, addr: _Pointer, type: SBType) -> SBValue: ...
    def CreateValueFromExpression(self, name: str, expr: str) -> SBValue: ...
    def synthetic_child_from_address(self, name: str, addr: _Pointer, type: SBType) -> SBValue: ...
    def synthetic_child_from_expression(self, name: str, expr: str) -> SBValue: ...
    @property
    def addr(self) -> SBAddress: ...
    @property
    def frame(self) -> SBFrame: ...
    @property
    def type(self) -> SBType: ...
    @property
    def name(self) -> str: ...
    @property
    def target(self) -> SBTarget: ...
    @property
    def load_addr(self) -> _Pointer: ...
    @property
    def size(self) -> int: ...
    @property
    def unsigned(self) -> int: ...
    @property
    def data(self) -> SBData: ...
    @property
    def deref(self) -> SBValue: ...
    @property
    def process(self) -> SBProcess: ...
    @property
    def error(self) -> SBError: ...
    @property
    def changed(self) -> bool: ...
    @property
    def children(self) -> Sequence[SBValue]: ...

    value: str
    format: ValueFormatType

class SBFrame:
    def FindVariable(self, var_name: str) -> SBValue: ...
    def EvaluateExpression(self, expr: str) -> SBValue: ...
    @property
    def locals(self) -> Sequence[SBValue]: ...
    @property
    def thread(self) -> SBThread: ...

class SBThread:
    @property
    def frames(self) -> Sequence[SBFrame]: ...
    @property
    def process(self) -> SBProcess: ...

class SBProcess:
    def ReadMemory(self, addr: _Pointer, size: int, err: SBError) -> bytes: ...
    def ReadCStringFromMemory(self, addr: _Pointer, max: int, err: SBError) -> bytes: ...
    @property
    def selected_thread(self) -> SBThread: ...
    @property
    def id(self) -> int: ...

class SBCommandReturnObject:
    def AppendMessage(self, s: str) -> None: ...

class SBTarget:
    def FindFirstType(self, type: str) -> SBType: ...
    def CreateValueFromData(self, name: str, data: SBData, type: SBType) -> SBValue: ...
    def CreateValueFromExpression(self, name: str, expr: str) -> SBValue: ...
    def CreateValueFromAddress(self, name: str, addr: SBAddress, type: SBType) -> SBValue: ...
    def GetBasicType(self, type: BasicType) -> SBType: ...
    @property
    def process(self) -> SBProcess: ...

class SBType:
    def GetDisplayTypeName(self) -> str: ...
    def GetPointerType(self) -> SBType: ...
    def GetArrayType(self, size: int) -> SBType: ...
    @property
    def name(self) -> str: ...
    def IsValid(self) -> bool: ...
    @property
    def fields(self) -> Sequence[SBTypeMember]: ...
    @property
    def size(self) -> int: ...

class SBTypeMember:
    @property
    def name(self) -> str: ...
    @property
    def byte_offset(self) -> int: ...

class SBSyntheticValueProvider:
    def __init__(self, valobj: SBValue, internal_dict: _InternalDict) -> None: ...
    def num_children(self) -> int: ...
    def get_child_at_index(self, pos: int) -> SBValue: ...
    def has_children(self) -> bool: ...
    def get_value(self) -> SBValue: ...
    def update(self) -> bool | None: ...

# Types not present in lldb, but represent the types of top-level constants:
# (These may only be used in unevaluated contexts)
class ByteOrderType: ...
class ValueFormatType: ...
class BasicType: ...

eBasicTypeNullPtr: BasicType
eBasicTypeUnsignedChar: BasicType
eBasicTypeDouble: BasicType
eBasicTypeBool: BasicType
eBasicTypeChar: BasicType
eBasicTypeUnsignedChar: BasicType
eBasicTypeVoid: BasicType

eFormatDefault: ValueFormatType
eFormatHex: ValueFormatType
eFormatBinary: ValueFormatType
eFormatPointer: ValueFormatType
eFormatInvalid: ValueFormatType

debugger: SBDebugger
