## opkssh add

Appends new rule to the policy file

### Synopsis

Add appends a new policy entry in the auth_id policy file granting SSH access to the specified email or subscriber ID (sub) or group.

It first attempts to write to the system-wide file (/etc/opk/auth_id). If it lacks permissions to update this file it falls back to writing to the user-specific file (~/.opk/auth_id).

Arguments:
  principal            The target user account (requested principal).
  email|sub|group      Email address, subscriber ID or group authorized to assume this principal. If using an OIDC group, the argument needs to be in the format of oidc:groups:<groupId>.
  issuer               OpenID Connect provider (issuer) URL associated with the email/sub/group.


```
opkssh add <principal> <email|sub|group> <issuer> [flags]
```

### Examples

```
  opkssh add root alice@example.com https://accounts.google.com
  opkssh add alice 103030642802723203118 https://accounts.google.com
  opkssh add developer oidc:groups:developer https://accounts.google.com
```

### Options

```
  -h, --help   help for add
```

### SEE ALSO

* [opkssh](opkssh.md)	 - SSH with OpenPubkey

###### Auto generated by spf13/cobra on 21-Jan-2026
