// Round cap line
module pcb_line_rc(x1, y1, length, angle, width, thick) {
	translate([x1,y1,0]) {
		rotate([0,0,angle]) {
			translate([length/2, 0, 0])
				cube([length, width, thick], center=true);
			cylinder(r=width/2, h=thick, center=true, $fn=30);
			translate([length, 0, 0])
				cylinder(r=width/2, h=thick, center=true, $fn=30);
		}
	}
}
// Square cap line
module pcb_line_sc(x1, y1, length, angle, width, thick) {
	translate([x1,y1,0]) {
		rotate([0,0,angle]) {
			translate([length/2, 0, 0])
				cube([length + width, width, thick], center=true);
		}
	}
}
// filled rectangle
module pcb_fill_rect(x1, y1, x2, y2, angle, thick) {
	translate([(x1+x2)/2,(y1+y2)/2,0])
		rotate([0,0,angle])
			cube([x2-x1, y2-y1, thick], center=true);
}
// filled polygon
module pcb_fill_poly(coords, thick) {
	linear_extrude(height=thick)
		polygon(coords);
}
// filled circle
module pcb_fcirc(x1, y1, radius, thick) {
	translate([x1,y1,0])
		cylinder(r=radius, h=thick, center=true, $fn=30);
}
module pcb_outline() {
	polygon([
		[0.0000,15.8750],[16.5100,15.8750],[16.5100,0.0000],[0.0000,0.0000]
	]);
}
module layer_bottom_silk_pos_1() {
	color([0,0,0])
		translate([0,0,-0.833000]) {
		}
}

module layer_group_bottom_silk() {
	layer_bottom_silk_pos_1();
}

module layer_bottom_copper_pos_2() {
	color([1,0.4,0.2])
		translate([0,0,-0.811000]) {
			pcb_fcirc(2.5400, 13.3350, 1.0000, 0.010000);
			pcb_fcirc(6.3500, 13.3350, 1.0000, 0.010000);
			pcb_fcirc(2.5400, 10.1600, 1.0000, 0.010000);
			pcb_fcirc(6.3500, 10.1600, 1.0000, 0.010000);
			pcb_fcirc(2.5400, 13.3350, 0.4001, 0.010000);
			pcb_fcirc(6.3500, 13.3350, 0.4001, 0.010000);
			pcb_fcirc(2.5400, 10.1600, 0.4001, 0.010000);
			pcb_fcirc(6.3500, 10.1600, 0.4001, 0.010000);
		}
}

module layer_group_bottom_copper() {
	layer_bottom_copper_pos_2();
}

module layer_top_copper_pos_3() {
	color([1,0.4,0.2])
		translate([0,0,0.811000]) {
			pcb_fill_poly([[4.3454,10.7891],[4.2482,10.7658],[4.1558,10.7275],[4.0706,10.6753],[3.9946,10.6104],[3.9853,10.5995],[3.9786,10.6274],[3.8878,10.8467],[3.7638,11.0491],[3.6096,11.2296],[3.4291,11.3838],[3.2267,11.5078],[3.0074,11.5986],[2.7766,11.6540],[2.5400,11.6727],[2.5377,11.6725],[2.5377,11.8225],[2.5400,11.8223],[2.7766,11.8410],[3.0074,11.8964],[3.2267,11.9872],[3.4291,12.1112],[3.6096,12.2654],[3.7638,12.4459],[3.8878,12.6483],[3.9786,12.8676],[4.0340,13.0984],[4.0480,13.3350],[4.0340,13.5716],[3.9786,13.8024],[3.8878,14.0217],[3.7638,14.2241],[3.6096,14.4046],[3.4291,14.5588],[3.2267,14.6828],[3.0074,14.7736],[2.7766,14.8290],[2.5400,14.8477],[2.5377,14.8475],[2.5377,15.2400],[8.2530,15.2400],[8.2550,15.2151],[8.2550,13.9949],[8.2530,13.9700],[8.2550,13.9451],[8.2550,12.7249],[8.2530,12.7000],[8.2550,12.6751],[8.2550,11.4549],[8.2530,11.4300],[8.2550,11.4051],[8.2550,8.9454],[8.2526,8.8900],[7.1637,8.8900],[7.2391,8.9362],[7.4196,9.0904],[7.5738,9.2709],[7.6978,9.4733],[7.7886,9.6926],[7.8440,9.9234],[7.8580,10.1600],[7.8440,10.3966],[7.7886,10.6274],[7.6978,10.8467],[7.6200,10.9737],[7.6200,11.4300],[7.6141,11.5296],[7.5908,11.6268],[7.5525,11.7192],[7.5003,11.8044],[7.4354,11.8804],[7.3594,11.9453],[7.2742,11.9975],[7.1818,12.0358],[7.1345,12.0471],[7.2391,12.1112],[7.4196,12.2654],[7.5738,12.4459],[7.6978,12.6483],[7.7886,12.8676],[7.8440,13.0984],[7.8580,13.3350],[7.8440,13.5716],[7.7886,13.8024],[7.6978,14.0217],[7.5738,14.2241],[7.4196,14.4046],[7.2391,14.5588],[7.0367,14.6828],[6.8174,14.7736],[6.5866,14.8290],[6.3500,14.8477],[6.1134,14.8290],[5.8826,14.7736],[5.6633,14.6828],[5.4609,14.5588],[5.2804,14.4046],[5.1262,14.2241],[5.0022,14.0217],[4.9114,13.8024],[4.8560,13.5716],[4.8373,13.3350],[4.8560,13.0984],[4.9114,12.8676],[5.0022,12.6483],[5.1262,12.4459],[5.2804,12.2654],[5.4609,12.1112],[5.6633,11.9872],[5.8826,11.8964],[6.1134,11.8410],[6.3500,11.8223],[6.4948,11.8337],[6.4697,11.8044],[6.4175,11.7192],[6.3967,11.6690],[6.3500,11.6727],[6.1134,11.6540],[5.8826,11.5986],[5.6633,11.5078],[5.4609,11.3838],[5.2804,11.2296],[5.1262,11.0491],[5.0022,10.8467],[4.9808,10.7950],[4.4450,10.7950]], 0.010000);
			pcb_fill_poly([[2.3034,11.6540],[2.0726,11.5986],[1.8533,11.5078],[1.6509,11.3838],[1.4704,11.2296],[1.3162,11.0491],[1.1922,10.8467],[1.1014,10.6274],[1.0460,10.3966],[1.0273,10.1600],[1.0460,9.9234],[1.1014,9.6926],[1.1922,9.4733],[1.3162,9.2709],[1.4704,9.0904],[1.6509,8.9362],[1.7263,8.8900],[0.6350,8.8900],[0.6350,15.2400],[2.5377,15.2400],[2.5377,14.8475],[2.3034,14.8290],[2.0726,14.7736],[1.8533,14.6828],[1.6509,14.5588],[1.4704,14.4046],[1.3162,14.2241],[1.1922,14.0217],[1.1014,13.8024],[1.0460,13.5716],[1.0273,13.3350],[1.0460,13.0984],[1.1014,12.8676],[1.1922,12.6483],[1.3162,12.4459],[1.4704,12.2654],[1.6509,12.1112],[1.8533,11.9872],[2.0726,11.8964],[2.3034,11.8410],[2.5377,11.8225],[2.5377,11.6725]], 0.010000);
			pcb_fill_poly([[7.6200,7.6200],[7.6200,2.5400],[6.3500,2.5400],[6.3500,7.6200]], 0.010000);
			pcb_fill_poly([[9.5250,7.6200],[9.5250,2.5400],[8.2550,2.5400],[8.2550,7.6200]], 0.010000);
			pcb_fill_poly([[11.4300,7.6200],[11.4300,2.5400],[10.1600,2.5400],[10.1600,7.6200]], 0.010000);
			pcb_fill_poly([[13.3350,7.6200],[13.3350,2.5400],[12.0650,2.5400],[12.0650,7.6200]], 0.010000);
			pcb_line_rc(4.4450, 10.1600, 1.9050, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(6.3500, 10.1600, 0.8980, 45.000000, 0.2540, 0.010000);
			pcb_line_rc(6.9850, 10.7950, 0.6350, 90.000000, 0.2540, 0.010000);
			pcb_line_rc(8.8900, 15.2400, 5.0800, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(8.8900, 13.9700, 5.0800, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(8.8900, 12.7000, 5.0800, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(8.8900, 11.4300, 5.0800, 0.000000, 0.2540, 0.010000);
			// line-approx arc 0.000000 .. -90.000000 by -10.000000
				pcb_line_rc(8.8900, 8.8900, 0.3321, 85.000043, 0.2540, 0.010000);
				pcb_line_rc(8.9189, 9.2208, 0.3321, 75.000073, 0.2540, 0.010000);
				pcb_line_rc(9.0049, 9.5415, 0.3321, 64.999962, 0.2540, 0.010000);
				pcb_line_rc(9.1452, 9.8425, 0.3321, 55.000022, 0.2540, 0.010000);
				pcb_line_rc(9.3357, 10.1145, 0.3321, 45.000000, 0.2540, 0.010000);
				pcb_line_rc(9.5705, 10.3493, 0.3321, 34.999978, 0.2540, 0.010000);
				pcb_line_rc(9.8425, 10.5398, 0.3321, 25.000038, 0.2540, 0.010000);
				pcb_line_rc(10.1435, 10.6801, 0.3321, 14.999927, 0.2540, 0.010000);
				pcb_line_rc(10.4642, 10.7661, 0.3321, 4.999957, 0.2540, 0.010000);
			// line-approx arc 0.000000 .. -90.000000 by -10.000000
				pcb_line_rc(10.1600, 8.8900, 0.3321, 85.000043, 0.2540, 0.010000);
				pcb_line_rc(10.1889, 9.2208, 0.3321, 75.000073, 0.2540, 0.010000);
				pcb_line_rc(10.2749, 9.5415, 0.3321, 64.999962, 0.2540, 0.010000);
				pcb_line_rc(10.4152, 9.8425, 0.3321, 55.000022, 0.2540, 0.010000);
				pcb_line_rc(10.6057, 10.1145, 0.3321, 45.000000, 0.2540, 0.010000);
				pcb_line_rc(10.8405, 10.3493, 0.3321, 34.999978, 0.2540, 0.010000);
				pcb_line_rc(11.1125, 10.5398, 0.3321, 25.000038, 0.2540, 0.010000);
				pcb_line_rc(11.4135, 10.6801, 0.3321, 14.999927, 0.2540, 0.010000);
				pcb_line_rc(11.7342, 10.7661, 0.3321, 4.999957, 0.2540, 0.010000);
			// line-approx arc 0.000000 .. -90.000000 by -10.000000
				pcb_line_rc(11.4300, 8.8900, 0.3321, 85.000043, 0.2540, 0.010000);
				pcb_line_rc(11.4589, 9.2208, 0.3321, 75.000073, 0.2540, 0.010000);
				pcb_line_rc(11.5449, 9.5415, 0.3321, 64.999962, 0.2540, 0.010000);
				pcb_line_rc(11.6852, 9.8425, 0.3321, 55.000022, 0.2540, 0.010000);
				pcb_line_rc(11.8757, 10.1145, 0.3321, 45.000000, 0.2540, 0.010000);
				pcb_line_rc(12.1105, 10.3493, 0.3321, 34.999978, 0.2540, 0.010000);
				pcb_line_rc(12.3825, 10.5398, 0.3321, 25.000038, 0.2540, 0.010000);
				pcb_line_rc(12.6835, 10.6801, 0.3321, 14.999927, 0.2540, 0.010000);
				pcb_line_rc(13.0042, 10.7661, 0.3321, 4.999957, 0.2540, 0.010000);
			// line-approx arc 0.000000 .. -90.000000 by -10.000000
				pcb_line_rc(12.7000, 8.8900, 0.3321, 85.000043, 0.2540, 0.010000);
				pcb_line_rc(12.7289, 9.2208, 0.3321, 75.000073, 0.2540, 0.010000);
				pcb_line_rc(12.8149, 9.5415, 0.3321, 64.999962, 0.2540, 0.010000);
				pcb_line_rc(12.9552, 9.8425, 0.3321, 55.000022, 0.2540, 0.010000);
				pcb_line_rc(13.1457, 10.1145, 0.3321, 45.000000, 0.2540, 0.010000);
				pcb_line_rc(13.3805, 10.3493, 0.3321, 34.999978, 0.2540, 0.010000);
				pcb_line_rc(13.6525, 10.5398, 0.3321, 25.000038, 0.2540, 0.010000);
				pcb_line_rc(13.9535, 10.6801, 0.3321, 14.999927, 0.2540, 0.010000);
				pcb_line_rc(14.2742, 10.7661, 0.3321, 4.999957, 0.2540, 0.010000);
			pcb_line_rc(1.2700, 8.2550, 0.5080, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(1.5240, 8.2550, 1.0160, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(2.0828, 7.7978, 0.3810, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(2.0828, 7.2390, 0.5080, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(2.0828, 8.2550, 1.0160, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(2.0828, 8.2550, 0.5080, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(3.4036, 8.2550, 0.1796, -45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.0226, 8.2550, 0.3810, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(2.8956, 8.1280, 0.1796, 45.000000, 0.2540, 0.010000);
			pcb_line_rc(2.8956, 8.1280, 0.2540, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(2.8956, 7.8740, 0.1796, -45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.0226, 7.7470, 0.3810, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(3.4036, 7.7470, 0.1796, -45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.5306, 7.6200, 0.2540, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(3.4036, 7.2390, 0.1796, 45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.0226, 7.2390, 0.3810, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(2.8956, 7.3660, 0.1796, -45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.8354, 8.2550, 0.5080, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(4.0894, 8.2550, 1.0160, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(1.2700, 6.3500, 0.5080, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(1.5240, 6.3500, 1.0160, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(2.0828, 5.8928, 0.3810, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(2.0828, 5.3340, 0.5080, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(2.0828, 6.3500, 1.0160, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(2.0828, 6.3500, 0.5080, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(3.4036, 6.3500, 0.1796, -45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.0226, 6.3500, 0.3810, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(2.8956, 6.2230, 0.1796, 45.000000, 0.2540, 0.010000);
			pcb_line_rc(2.8956, 6.2230, 0.2540, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(2.8956, 5.9690, 0.1796, -45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.0226, 5.8420, 0.3810, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(3.4036, 5.8420, 0.1796, -45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.5306, 5.7150, 0.2540, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(3.4036, 5.3340, 0.1796, 45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.0226, 5.3340, 0.3810, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(2.8956, 5.4610, 0.1796, -45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.8354, 6.3500, 0.5080, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(4.0894, 6.3500, 1.0160, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(1.2700, 4.4450, 0.5080, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(1.5240, 4.4450, 1.0160, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(2.0828, 3.9878, 0.3810, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(2.0828, 3.4290, 0.5080, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(2.0828, 4.4450, 1.0160, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(2.0828, 4.4450, 0.5080, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(3.4036, 4.4450, 0.1796, -45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.0226, 4.4450, 0.3810, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(2.8956, 4.3180, 0.1796, 45.000000, 0.2540, 0.010000);
			pcb_line_rc(2.8956, 4.3180, 0.2540, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(2.8956, 4.0640, 0.1796, -45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.0226, 3.9370, 0.3810, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(3.4036, 3.9370, 0.1796, -45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.5306, 3.8100, 0.2540, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(3.4036, 3.4290, 0.1796, 45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.0226, 3.4290, 0.3810, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(2.8956, 3.5560, 0.1796, -45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.8354, 4.4450, 0.5080, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(4.0894, 4.4450, 1.0160, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(1.2700, 2.5400, 0.5080, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(1.5240, 2.5400, 1.0160, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(2.0828, 2.0828, 0.3810, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(2.0828, 1.5240, 0.5080, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(2.0828, 2.5400, 1.0160, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(2.0828, 2.5400, 0.5080, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(3.4036, 2.5400, 0.1796, -45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.0226, 2.5400, 0.3810, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(2.8956, 2.4130, 0.1796, 45.000000, 0.2540, 0.010000);
			pcb_line_rc(2.8956, 2.4130, 0.2540, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(2.8956, 2.1590, 0.1796, -45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.0226, 2.0320, 0.3810, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(3.4036, 2.0320, 0.1796, -45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.5306, 1.9050, 0.2540, -90.000000, 0.2540, 0.010000);
			pcb_line_rc(3.4036, 1.5240, 0.1796, 45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.0226, 1.5240, 0.3810, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(2.8956, 1.6510, 0.1796, -45.000000, 0.2540, 0.010000);
			pcb_line_rc(3.8354, 2.5400, 0.5080, 0.000000, 0.2540, 0.010000);
			pcb_line_rc(4.0894, 2.5400, 1.0160, -90.000000, 0.2540, 0.010000);
			pcb_fcirc(2.5400, 13.3350, 1.0000, 0.010000);
			pcb_fcirc(6.3500, 13.3350, 1.0000, 0.010000);
			pcb_fcirc(2.5400, 10.1600, 1.0000, 0.010000);
			pcb_fcirc(6.3500, 10.1600, 1.0000, 0.010000);
			pcb_fill_poly([[5.5651,1.6198],[5.0653,1.6198],[5.0653,0.9202],[5.5651,0.9202]], 0.010000);
			pcb_fill_poly([[6.3647,1.6198],[5.8649,1.6198],[5.8649,0.9202],[6.3647,0.9202]], 0.010000);
			pcb_fill_poly([[8.1051,1.6198],[7.6053,1.6198],[7.6053,0.9202],[8.1051,0.9202]], 0.010000);
			pcb_fill_poly([[8.9047,1.6198],[8.4049,1.6198],[8.4049,0.9202],[8.9047,0.9202]], 0.010000);
			pcb_fill_poly([[10.6451,1.6198],[10.1453,1.6198],[10.1453,0.9202],[10.6451,0.9202]], 0.010000);
			pcb_fill_poly([[11.4447,1.6198],[10.9449,1.6198],[10.9449,0.9202],[11.4447,0.9202]], 0.010000);
			pcb_fill_poly([[13.1851,1.6198],[12.6853,1.6198],[12.6853,0.9202],[13.1851,0.9202]], 0.010000);
			pcb_fill_poly([[13.9847,1.6198],[13.4849,1.6198],[13.4849,0.9202],[13.9847,0.9202]], 0.010000);
			pcb_fcirc(2.5400, 13.3350, 0.4001, 0.010000);
			pcb_fcirc(6.3500, 13.3350, 0.4001, 0.010000);
			pcb_fcirc(2.5400, 10.1600, 0.4001, 0.010000);
			pcb_fcirc(6.3500, 10.1600, 0.4001, 0.010000);
		}
}

module layer_top_copper_pos_4() {
	color([1,0.4,0.2])
		translate([0,0,0.811000]) {
		}
}

module layer_group_top_copper() {
	layer_top_copper_pos_3();
	layer_top_copper_pos_4();
}

module layer_top_mask_pos_5() {
	color([0,0.7,0,0.5])
		translate([0,0,0.822000]) {
			pcb_fill_rect(0.0000, 0.0000, 16.5100, 15.8750, 0.000000, 0.010000);
		}
}

module layer_top_mask_neg_6() {
	color([0,0.7,0,0.5])
		translate([0,0,0.812000]) {
			pcb_fill_poly([[5.6413,1.6960],[4.9891,1.6960],[4.9891,0.8440],[5.6413,0.8440]], 1.020000);
			pcb_fill_poly([[6.4409,1.6960],[5.7887,1.6960],[5.7887,0.8440],[6.4409,0.8440]], 1.020000);
			pcb_fill_poly([[8.1813,1.6960],[7.5291,1.6960],[7.5291,0.8440],[8.1813,0.8440]], 1.020000);
			pcb_fill_poly([[8.9809,1.6960],[8.3287,1.6960],[8.3287,0.8440],[8.9809,0.8440]], 1.020000);
			pcb_fill_poly([[10.7213,1.6960],[10.0691,1.6960],[10.0691,0.8440],[10.7213,0.8440]], 1.020000);
			pcb_fill_poly([[11.5209,1.6960],[10.8687,1.6960],[10.8687,0.8440],[11.5209,0.8440]], 1.020000);
			pcb_fill_poly([[13.2613,1.6960],[12.6091,1.6960],[12.6091,0.8440],[13.2613,0.8440]], 1.020000);
			pcb_fill_poly([[14.0609,1.6960],[13.4087,1.6960],[13.4087,0.8440],[14.0609,0.8440]], 1.020000);
		}
}

module layer_top_mask_pos_7() {
	color([0,0.7,0,0.5])
		translate([0,0,0.822000]) {
		}
}

module layer_group_top_mask() {
	union() {
	difference() {
	layer_top_mask_pos_5();
	layer_top_mask_neg_6();
}
	layer_top_mask_pos_7();
}
}

module layer_bottom_mask_pos_8() {
	color([0,0.7,0,0.5])
		translate([0,0,-0.822000]) {
			pcb_fill_rect(0.0000, 0.0000, 16.5100, 15.8750, 0.000000, 0.010000);
		}
}

module layer_bottom_mask_neg_9() {
	color([0,0.7,0,0.5])
		translate([0,0,-0.832000]) {
		}
}

module layer_bottom_mask_pos_10() {
	color([0,0.7,0,0.5])
		translate([0,0,-0.822000]) {
		}
}

module layer_group_bottom_mask() {
	union() {
	difference() {
	layer_bottom_mask_pos_8();
	layer_bottom_mask_neg_9();
}
	layer_bottom_mask_pos_10();
}
}

module layer_top_silk_pos_11() {
	color([0,0,0])
		translate([0,0,0.833000]) {
			pcb_fill_poly([[4.9149,2.0701],[5.6769,2.0701],[5.6769,1.0541],[4.9149,1.0541]], 0.010000);
			pcb_fill_poly([[5.8293,2.0701],[6.5913,2.0701],[6.5913,1.0541],[5.8293,1.0541]], 0.010000);
			pcb_fill_poly([[6.7437,2.0701],[7.5057,2.0701],[7.5057,1.0541],[6.7437,1.0541]], 0.010000);
			pcb_fill_poly([[7.4549,2.0701],[8.2169,2.0701],[8.2169,1.0541],[7.4549,1.0541]], 0.010000);
			pcb_fill_poly([[8.3693,2.0701],[9.1313,2.0701],[9.1313,1.0541],[8.3693,1.0541]], 0.010000);
			pcb_fill_poly([[9.2837,2.0701],[10.0457,2.0701],[10.0457,1.0541],[9.2837,1.0541]], 0.010000);
			pcb_fill_poly([[9.9949,2.0701],[10.7569,2.0701],[10.7569,1.0541],[9.9949,1.0541]], 0.010000);
			pcb_fill_poly([[10.9093,2.0701],[11.6713,2.0701],[11.6713,1.0541],[10.9093,1.0541]], 0.010000);
			pcb_fill_poly([[11.8237,2.0701],[12.5857,2.0701],[12.5857,1.0541],[11.8237,1.0541]], 0.010000);
			pcb_fill_poly([[12.5349,2.0701],[13.2969,2.0701],[13.2969,1.0541],[12.5349,1.0541]], 0.010000);
			pcb_fill_poly([[13.4493,2.0701],[14.2113,2.0701],[14.2113,1.0541],[13.4493,1.0541]], 0.010000);
			pcb_fill_poly([[14.3637,2.0701],[15.1257,2.0701],[15.1257,1.0541],[14.3637,1.0541]], 0.010000);
		}
}

module layer_top_silk_pos_12() {
	color([0,0,0])
		translate([0,0,0.833000]) {
		}
}

module layer_group_top_silk() {
	layer_top_silk_pos_11();
	layer_top_silk_pos_12();
}

module pcb_drill() {
	translate([2.5400,13.3350,0])
		cylinder(r=0.4001, h=4, center=true, $fn=30);
	translate([6.3500,13.3350,0])
		cylinder(r=0.4001, h=4, center=true, $fn=30);
	translate([2.5400,10.1600,0])
		cylinder(r=0.4001, h=4, center=true, $fn=30);
	translate([6.3500,10.1600,0])
		cylinder(r=0.4001, h=4, center=true, $fn=30);
}
module pcb_board_main() {
	translate ([0, 0, -0.8])
		linear_extrude(height=1.6)
			pcb_outline();
	layer_group_bottom_silk();
	layer_group_bottom_copper();
	layer_group_top_copper();
	layer_group_top_mask();
	layer_group_bottom_mask();
	layer_group_top_silk();
}

module pcb_board() {
	intersection() {
		translate ([0, 0, -4])
			linear_extrude(height=8)
				pcb_outline();
		union() {
			difference() {
				pcb_board_main();
				pcb_drill();
			}
		}
	}
}

pcb_board();
