dnl Process this m4 file to produce 'C' language file.
dnl
dnl If you see this line, you can ignore the next one.
/* Do not edit this file. It is produced from the corresponding .m4 source */
dnl
/*
 *  Copyright (C) 2003, Northwestern University and Argonne National Laboratory
 *  See COPYRIGHT notice in top-level directory.
 */
/* $Id$ */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <unistd.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include <assert.h>

#include <mpi.h>

#include <pnc_debug.h>
#include <common.h>
#include "nc.h"
#include "ncx.h"
#include "ncmpidtype.h"


/* buffer layers:

        User Level              buf     (user defined buffer of MPI_Datatype)
        MPI Datatype Level      cbuf    (contiguous buffer of ptype)
        NetCDF XDR Level        xbuf    (XDR I/O buffer)
*/

static int
ncmpio_getput_varnm(int                ncid,
                    int                varid,
                    int                num,
                    MPI_Offset* const  starts[],   /* [num] */
                    MPI_Offset* const  counts[],   /* [num] */
                    MPI_Offset* const  strides[],  /* [num] */
                    MPI_Offset* const  imaps[],    /* [num] */
                    void              *buf,
                    MPI_Offset         bufcount,
                    MPI_Datatype       buftype,
                    int                rw_flag,    /* WRITE_REQ or READ_REQ */
                    int                io_method); /* COLL_IO or INDEP_IO */

/*----< ncmpi_put_varn() >---------------------------------------------------*/
int
ncmpi_put_varn(int           ncid,
               int           varid,
               int           num,
               const void   *buf,
               MPI_Offset    bufcount,
               MPI_Datatype  buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, NULL, NULL, NULL,
                               NULL, (void*)buf, bufcount, buftype,
                               WRITE_REQ, INDEP_IO);
}

/*----< ncmpi_put_varn_all() >-----------------------------------------------*/
int
ncmpi_put_varn_all(int           ncid,
                   int           varid,
                   int           num,
                   const void   *buf,
                   MPI_Offset    bufcount,
                   MPI_Datatype  buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, NULL, NULL, NULL,
                               NULL, (void*)buf, bufcount, buftype,
                               WRITE_REQ, COLL_IO);
}

dnl
dnl PUT_VARN(btype_name, btype, mpi_type, mode, mode_name)
dnl
define(`PUT_VARN',dnl
`dnl
/*----< ncmpi_put_varn_$1$5() >-----------------------------------------------*/
int
ncmpi_put_varn_$1$5(int       ncid,
                    int       varid,
                    int       num,
                    const $2 *buf)
{
    return ncmpio_getput_varnm(ncid, varid, num, NULL, NULL, NULL,
                               NULL, (void*)buf, -1, $3, WRITE_REQ, $4);
}
')dnl

PUT_VARN(text,      char,               MPI_CHAR,               INDEP_IO)
PUT_VARN(schar,     signed char,        MPI_SIGNED_CHAR,        INDEP_IO)
PUT_VARN(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      INDEP_IO)
PUT_VARN(short,     short,              MPI_SHORT,              INDEP_IO)
PUT_VARN(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     INDEP_IO)
PUT_VARN(int,       int,                MPI_INT,                INDEP_IO)
PUT_VARN(uint,      unsigned int,       MPI_UNSIGNED,           INDEP_IO)
PUT_VARN(long,      long,               MPI_LONG,               INDEP_IO)
PUT_VARN(float,     float,              MPI_FLOAT,              INDEP_IO)
PUT_VARN(double,    double,             MPI_DOUBLE,             INDEP_IO)
PUT_VARN(longlong,  long long,          MPI_LONG_LONG_INT,      INDEP_IO)
PUT_VARN(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, INDEP_IO)

PUT_VARN(text,      char,               MPI_CHAR,               COLL_IO, _all)
PUT_VARN(schar,     signed char,        MPI_SIGNED_CHAR,        COLL_IO, _all)
PUT_VARN(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      COLL_IO, _all)
PUT_VARN(short,     short,              MPI_SHORT,              COLL_IO, _all)
PUT_VARN(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     COLL_IO, _all)
PUT_VARN(int,       int,                MPI_INT,                COLL_IO, _all)
PUT_VARN(uint,      unsigned int,       MPI_UNSIGNED,           COLL_IO, _all)
PUT_VARN(long,      long,               MPI_LONG,               COLL_IO, _all)
PUT_VARN(float,     float,              MPI_FLOAT,              COLL_IO, _all)
PUT_VARN(double,    double,             MPI_DOUBLE,             COLL_IO, _all)
PUT_VARN(longlong,  long long,          MPI_LONG_LONG_INT,      COLL_IO, _all)
PUT_VARN(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, COLL_IO, _all)

/*----< ncmpi_put_varn1() >--------------------------------------------------*/
int
ncmpi_put_varn1(int                ncid,
                int                varid,
                int                num,
                MPI_Offset* const  starts[],    /* [num] */
                const void        *buf,
                MPI_Offset         bufcount,
                MPI_Datatype       buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, NULL, NULL,
                               NULL, (void*)buf, bufcount, buftype,
                               WRITE_REQ, INDEP_IO);
}

/*----< ncmpi_put_varn1_all() >----------------------------------------------*/
int
ncmpi_put_varn1_all(int                ncid,
                    int                varid,
                    int                num,
                    MPI_Offset* const  starts[],    /* [num] */
                    const void        *buf,
                    MPI_Offset         bufcount,
                    MPI_Datatype       buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, NULL, NULL,
                               NULL, (void*)buf, bufcount, buftype,
                               WRITE_REQ, COLL_IO);
}

dnl
dnl PUT_VARN1(btype_name, btype, mpi_type, mode, mode_name)
dnl
define(`PUT_VARN1',dnl
`dnl
/*----< ncmpi_put_varn1_$1$5() >----------------------------------------------*/
int
ncmpi_put_varn1_$1$5(int                ncid,
                     int                varid,
                     int                num,
                     MPI_Offset* const  starts[],    /* [num] */
                     const $2          *buf)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, NULL, NULL,
                               NULL, (void*)buf, -1, $3, WRITE_REQ, $4);
}
')dnl

PUT_VARN1(text,      char,               MPI_CHAR,               INDEP_IO)
PUT_VARN1(schar,     signed char,        MPI_SIGNED_CHAR,        INDEP_IO)
PUT_VARN1(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      INDEP_IO)
PUT_VARN1(short,     short,              MPI_SHORT,              INDEP_IO)
PUT_VARN1(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     INDEP_IO)
PUT_VARN1(int,       int,                MPI_INT,                INDEP_IO)
PUT_VARN1(uint,      unsigned int,       MPI_UNSIGNED,           INDEP_IO)
PUT_VARN1(long,      long,               MPI_LONG,               INDEP_IO)
PUT_VARN1(float,     float,              MPI_FLOAT,              INDEP_IO)
PUT_VARN1(double,    double,             MPI_DOUBLE,             INDEP_IO)
PUT_VARN1(longlong,  long long,          MPI_LONG_LONG_INT,      INDEP_IO)
PUT_VARN1(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, INDEP_IO)

PUT_VARN1(text,      char,               MPI_CHAR,               COLL_IO, _all)
PUT_VARN1(schar,     signed char,        MPI_SIGNED_CHAR,        COLL_IO, _all)
PUT_VARN1(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      COLL_IO, _all)
PUT_VARN1(short,     short,              MPI_SHORT,              COLL_IO, _all)
PUT_VARN1(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     COLL_IO, _all)
PUT_VARN1(int,       int,                MPI_INT,                COLL_IO, _all)
PUT_VARN1(uint,      unsigned int,       MPI_UNSIGNED,           COLL_IO, _all)
PUT_VARN1(long,      long,               MPI_LONG,               COLL_IO, _all)
PUT_VARN1(float,     float,              MPI_FLOAT,              COLL_IO, _all)
PUT_VARN1(double,    double,             MPI_DOUBLE,             COLL_IO, _all)
PUT_VARN1(longlong,  long long,          MPI_LONG_LONG_INT,      COLL_IO, _all)
PUT_VARN1(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, COLL_IO, _all)

/*----< ncmpi_put_varna() >--------------------------------------------------*/
int
ncmpi_put_varna(int                ncid,
                int                varid,
                int                num,
                MPI_Offset* const  starts[],    /* [num] */
                MPI_Offset* const  counts[],    /* [num] */
                const void        *buf,
                MPI_Offset         bufcount,
                MPI_Datatype       buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, counts, NULL,
                               NULL, (void*)buf, bufcount, buftype,
                               WRITE_REQ, INDEP_IO);
}

/*----< ncmpi_put_varna_all() >----------------------------------------------*/
int
ncmpi_put_varna_all(int                ncid,
                    int                varid,
                    int                num,
                    MPI_Offset* const  starts[],    /* [num] */
                    MPI_Offset* const  counts[],    /* [num] */
                    const void        *buf,
                    MPI_Offset         bufcount,
                    MPI_Datatype       buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, counts, NULL,
                               NULL, (void*)buf, bufcount, buftype,
                               WRITE_REQ, COLL_IO);
}

dnl
dnl PUT_VARNA(btype_name, btype, mpi_type, mode, mode_name)
dnl
define(`PUT_VARNA',dnl
`dnl
/*----< ncmpi_put_varna_$1$5() >----------------------------------------------*/
int
ncmpi_put_varna_$1$5(int                ncid,
                     int                varid,
                     int                num,
                     MPI_Offset* const  starts[],    /* [num] */
                     MPI_Offset* const  counts[],    /* [num] */
                     const $2          *buf)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, counts, NULL,
                               NULL, (void*)buf, -1, $3, WRITE_REQ, $4);
}
')dnl

PUT_VARNA(text,      char,               MPI_CHAR,               INDEP_IO)
PUT_VARNA(schar,     signed char,        MPI_SIGNED_CHAR,        INDEP_IO)
PUT_VARNA(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      INDEP_IO)
PUT_VARNA(short,     short,              MPI_SHORT,              INDEP_IO)
PUT_VARNA(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     INDEP_IO)
PUT_VARNA(int,       int,                MPI_INT,                INDEP_IO)
PUT_VARNA(uint,      unsigned int,       MPI_UNSIGNED,           INDEP_IO)
PUT_VARNA(long,      long,               MPI_LONG,               INDEP_IO)
PUT_VARNA(float,     float,              MPI_FLOAT,              INDEP_IO)
PUT_VARNA(double,    double,             MPI_DOUBLE,             INDEP_IO)
PUT_VARNA(longlong,  long long,          MPI_LONG_LONG_INT,      INDEP_IO)
PUT_VARNA(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, INDEP_IO)

PUT_VARNA(text,      char,               MPI_CHAR,               COLL_IO, _all)
PUT_VARNA(schar,     signed char,        MPI_SIGNED_CHAR,        COLL_IO, _all)
PUT_VARNA(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      COLL_IO, _all)
PUT_VARNA(short,     short,              MPI_SHORT,              COLL_IO, _all)
PUT_VARNA(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     COLL_IO, _all)
PUT_VARNA(int,       int,                MPI_INT,                COLL_IO, _all)
PUT_VARNA(uint,      unsigned int,       MPI_UNSIGNED,           COLL_IO, _all)
PUT_VARNA(long,      long,               MPI_LONG,               COLL_IO, _all)
PUT_VARNA(float,     float,              MPI_FLOAT,              COLL_IO, _all)
PUT_VARNA(double,    double,             MPI_DOUBLE,             COLL_IO, _all)
PUT_VARNA(longlong,  long long,          MPI_LONG_LONG_INT,      COLL_IO, _all)
PUT_VARNA(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, COLL_IO, _all)

/*----< ncmpi_put_varns() >--------------------------------------------------*/
int
ncmpi_put_varns(int                ncid,
                int                varid,
                int                num,
                MPI_Offset* const  starts[],    /* [num] */
                MPI_Offset* const  counts[],    /* [num] */
                MPI_Offset* const  strides[],   /* [num] */
                const void        *buf,
                MPI_Offset         bufcount,
                MPI_Datatype       buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, counts, strides,
                               NULL, (void*)buf, bufcount, buftype,
                               WRITE_REQ, INDEP_IO);
}

/*----< ncmpi_put_varns_all() >----------------------------------------------*/
int
ncmpi_put_varns_all(int                ncid,
                    int                varid,
                    int                num,
                    MPI_Offset* const  starts[],    /* [num] */
                    MPI_Offset* const  counts[],    /* [num] */
                    MPI_Offset* const  strides[],   /* [num] */
                    const void        *buf,
                    MPI_Offset         bufcount,
                    MPI_Datatype       buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, counts, strides,
                               NULL, (void*)buf, bufcount, buftype,
                               WRITE_REQ, COLL_IO);
}

dnl
dnl PUT_VARNS(btype_name, btype, mpi_type, mode, mode_name)
dnl
define(`PUT_VARNS',dnl
`dnl
/*----< ncmpi_put_varns_$1$5() >----------------------------------------------*/
int
ncmpi_put_varns_$1$5(int                ncid,
                     int                varid,
                     int                num,
                     MPI_Offset* const  starts[],    /* [num] */
                     MPI_Offset* const  counts[],    /* [num] */
                     MPI_Offset* const  strides[],   /* [num] */
                     const $2          *buf)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, counts, strides,
                               NULL, (void*)buf, -1, $3, WRITE_REQ, $4);
}
')dnl

PUT_VARNS(text,      char,               MPI_CHAR,               INDEP_IO)
PUT_VARNS(schar,     signed char,        MPI_SIGNED_CHAR,        INDEP_IO)
PUT_VARNS(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      INDEP_IO)
PUT_VARNS(short,     short,              MPI_SHORT,              INDEP_IO)
PUT_VARNS(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     INDEP_IO)
PUT_VARNS(int,       int,                MPI_INT,                INDEP_IO)
PUT_VARNS(uint,      unsigned int,       MPI_UNSIGNED,           INDEP_IO)
PUT_VARNS(long,      long,               MPI_LONG,               INDEP_IO)
PUT_VARNS(float,     float,              MPI_FLOAT,              INDEP_IO)
PUT_VARNS(double,    double,             MPI_DOUBLE,             INDEP_IO)
PUT_VARNS(longlong,  long long,          MPI_LONG_LONG_INT,      INDEP_IO)
PUT_VARNS(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, INDEP_IO)

PUT_VARNS(text,      char,               MPI_CHAR,               COLL_IO, _all)
PUT_VARNS(schar,     signed char,        MPI_SIGNED_CHAR,        COLL_IO, _all)
PUT_VARNS(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      COLL_IO, _all)
PUT_VARNS(short,     short,              MPI_SHORT,              COLL_IO, _all)
PUT_VARNS(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     COLL_IO, _all)
PUT_VARNS(int,       int,                MPI_INT,                COLL_IO, _all)
PUT_VARNS(uint,      unsigned int,       MPI_UNSIGNED,           COLL_IO, _all)
PUT_VARNS(long,      long,               MPI_LONG,               COLL_IO, _all)
PUT_VARNS(float,     float,              MPI_FLOAT,              COLL_IO, _all)
PUT_VARNS(double,    double,             MPI_DOUBLE,             COLL_IO, _all)
PUT_VARNS(longlong,  long long,          MPI_LONG_LONG_INT,      COLL_IO, _all)
PUT_VARNS(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, COLL_IO, _all)

/*----< ncmpi_put_varnm() >--------------------------------------------------*/
int
ncmpi_put_varnm(int                ncid,
                int                varid,
                int                num,
                MPI_Offset* const  starts[],    /* [num] */
                MPI_Offset* const  counts[],    /* [num] */
                MPI_Offset* const  strides[],   /* [num] */
                MPI_Offset* const  imaps[],     /* [num] */
                const void        *buf,
                MPI_Offset         bufcount,
                MPI_Datatype       buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, counts, strides,
                               imaps, (void*)buf, bufcount, buftype,
                               WRITE_REQ, INDEP_IO);
}

/*----< ncmpi_put_varnm_all() >----------------------------------------------*/
int
ncmpi_put_varnm_all(int                ncid,
                    int                varid,
                    int                num,
                    MPI_Offset* const  starts[],    /* [num] */
                    MPI_Offset* const  counts[],    /* [num] */
                    MPI_Offset* const  strides[],   /* [num] */
                    MPI_Offset* const  imaps[],     /* [num] */
                    const void        *buf,
                    MPI_Offset         bufcount,
                    MPI_Datatype       buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, counts, strides,
                               imaps, (void*)buf, bufcount, buftype,
                               WRITE_REQ, COLL_IO);
}

dnl
dnl PUT_VARNM(btype_name, btype, mpi_type, mode, mode_name)
dnl
define(`PUT_VARNM',dnl
`dnl
/*----< ncmpi_put_varnm_$1$5() >----------------------------------------------*/
int
ncmpi_put_varnm_$1$5(int                ncid,
                     int                varid,
                     int                num,
                     MPI_Offset* const  starts[],    /* [num] */
                     MPI_Offset* const  counts[],    /* [num] */
                     MPI_Offset* const  strides[],   /* [num] */
                     MPI_Offset* const  imaps[],     /* [num] */
                     const $2          *buf)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, counts, strides,
                               imaps, (void*)buf, -1, $3, WRITE_REQ, $4);
}
')dnl

PUT_VARNM(text,      char,               MPI_CHAR,               INDEP_IO)
PUT_VARNM(schar,     signed char,        MPI_SIGNED_CHAR,        INDEP_IO)
PUT_VARNM(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      INDEP_IO)
PUT_VARNM(short,     short,              MPI_SHORT,              INDEP_IO)
PUT_VARNM(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     INDEP_IO)
PUT_VARNM(int,       int,                MPI_INT,                INDEP_IO)
PUT_VARNM(uint,      unsigned int,       MPI_UNSIGNED,           INDEP_IO)
PUT_VARNM(long,      long,               MPI_LONG,               INDEP_IO)
PUT_VARNM(float,     float,              MPI_FLOAT,              INDEP_IO)
PUT_VARNM(double,    double,             MPI_DOUBLE,             INDEP_IO)
PUT_VARNM(longlong,  long long,          MPI_LONG_LONG_INT,      INDEP_IO)
PUT_VARNM(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, INDEP_IO)

PUT_VARNM(text,      char,               MPI_CHAR,               COLL_IO, _all)
PUT_VARNM(schar,     signed char,        MPI_SIGNED_CHAR,        COLL_IO, _all)
PUT_VARNM(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      COLL_IO, _all)
PUT_VARNM(short,     short,              MPI_SHORT,              COLL_IO, _all)
PUT_VARNM(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     COLL_IO, _all)
PUT_VARNM(int,       int,                MPI_INT,                COLL_IO, _all)
PUT_VARNM(uint,      unsigned int,       MPI_UNSIGNED,           COLL_IO, _all)
PUT_VARNM(long,      long,               MPI_LONG,               COLL_IO, _all)
PUT_VARNM(float,     float,              MPI_FLOAT,              COLL_IO, _all)
PUT_VARNM(double,    double,             MPI_DOUBLE,             COLL_IO, _all)
PUT_VARNM(longlong,  long long,          MPI_LONG_LONG_INT,      COLL_IO, _all)
PUT_VARNM(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, COLL_IO, _all)

/*----< ncmpi_get_varn() >---------------------------------------------------*/
int
ncmpi_get_varn(int           ncid,
               int           varid,
               int           num,
               void         *buf,
               MPI_Offset    bufcount,
               MPI_Datatype  buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, NULL, NULL, NULL,
                               NULL, buf, bufcount, buftype,
                               READ_REQ, INDEP_IO);
}

/*----< ncmpi_get_varn_all() >-----------------------------------------------*/
int
ncmpi_get_varn_all(int           ncid,
                   int           varid,
                   int           num,
                   void         *buf,
                   MPI_Offset    bufcount,
                   MPI_Datatype  buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, NULL, NULL, NULL,
                               NULL, buf, bufcount, buftype,
                               READ_REQ, COLL_IO);
}

dnl
dnl GET_VARN(btype_name, btype, mpi_type, mode, mode_name)
dnl
define(`GET_VARN',dnl
`dnl
/*----< ncmpi_get_varn_$1$5() >-----------------------------------------------*/
int
ncmpi_get_varn_$1$5(int       ncid,
                    int       varid,
                    int       num,
                    $2       *buf)
{
    return ncmpio_getput_varnm(ncid, varid, num, NULL, NULL, NULL,
                               NULL, buf, -1, $3, READ_REQ, $4);
}
')dnl

GET_VARN(text,      char,               MPI_CHAR,               INDEP_IO)
GET_VARN(schar,     signed char,        MPI_SIGNED_CHAR,        INDEP_IO)
GET_VARN(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      INDEP_IO)
GET_VARN(short,     short,              MPI_SHORT,              INDEP_IO)
GET_VARN(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     INDEP_IO)
GET_VARN(int,       int,                MPI_INT,                INDEP_IO)
GET_VARN(uint,      unsigned int,       MPI_UNSIGNED,           INDEP_IO)
GET_VARN(long,      long,               MPI_LONG,               INDEP_IO)
GET_VARN(float,     float,              MPI_FLOAT,              INDEP_IO)
GET_VARN(double,    double,             MPI_DOUBLE,             INDEP_IO)
GET_VARN(longlong,  long long,          MPI_LONG_LONG_INT,      INDEP_IO)
GET_VARN(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, INDEP_IO)

GET_VARN(text,      char,               MPI_CHAR,               COLL_IO, _all)
GET_VARN(schar,     signed char,        MPI_SIGNED_CHAR,        COLL_IO, _all)
GET_VARN(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      COLL_IO, _all)
GET_VARN(short,     short,              MPI_SHORT,              COLL_IO, _all)
GET_VARN(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     COLL_IO, _all)
GET_VARN(int,       int,                MPI_INT,                COLL_IO, _all)
GET_VARN(uint,      unsigned int,       MPI_UNSIGNED,           COLL_IO, _all)
GET_VARN(long,      long,               MPI_LONG,               COLL_IO, _all)
GET_VARN(float,     float,              MPI_FLOAT,              COLL_IO, _all)
GET_VARN(double,    double,             MPI_DOUBLE,             COLL_IO, _all)
GET_VARN(longlong,  long long,          MPI_LONG_LONG_INT,      COLL_IO, _all)
GET_VARN(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, COLL_IO, _all)

/*----< ncmpi_get_varn1() >--------------------------------------------------*/
int
ncmpi_get_varn1(int                ncid,
                int                varid,
                int                num,
                MPI_Offset* const  starts[],     /* [num] */
                void              *buf,
                MPI_Offset         bufcount,
                MPI_Datatype       buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, NULL, NULL,
                               NULL, buf, bufcount, buftype,
                               READ_REQ, INDEP_IO);
}

/*----< ncmpi_get_varn1_all() >----------------------------------------------*/
int
ncmpi_get_varn1_all(int                ncid,
                    int                varid,
                    int                num,
                    MPI_Offset* const  starts[],     /* [num] */
                    void              *buf,
                    MPI_Offset         bufcount,
                    MPI_Datatype       buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, NULL, NULL,
                               NULL, buf, bufcount, buftype,
                               READ_REQ, COLL_IO);
}

dnl
dnl GET_VARN1(btype_name, btype, mpi_type, mode, mode_name)
dnl
define(`GET_VARN1',dnl
`dnl
/*----< ncmpi_get_varn1_$1$5() >----------------------------------------------*/
int
ncmpi_get_varn1_$1$5(int                ncid,
                     int                varid,
                     int                num,
                     MPI_Offset* const  starts[],    /* [num] */
                     $2                *buf)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, NULL, NULL,
                               NULL, buf, -1, $3, READ_REQ, $4);
}
')dnl

GET_VARN1(text,      char,               MPI_CHAR,               INDEP_IO)
GET_VARN1(schar,     signed char,        MPI_SIGNED_CHAR,        INDEP_IO)
GET_VARN1(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      INDEP_IO)
GET_VARN1(short,     short,              MPI_SHORT,              INDEP_IO)
GET_VARN1(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     INDEP_IO)
GET_VARN1(int,       int,                MPI_INT,                INDEP_IO)
GET_VARN1(uint,      unsigned int,       MPI_UNSIGNED,           INDEP_IO)
GET_VARN1(long,      long,               MPI_LONG,               INDEP_IO)
GET_VARN1(float,     float,              MPI_FLOAT,              INDEP_IO)
GET_VARN1(double,    double,             MPI_DOUBLE,             INDEP_IO)
GET_VARN1(longlong,  long long,          MPI_LONG_LONG_INT,      INDEP_IO)
GET_VARN1(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, INDEP_IO)

GET_VARN1(text,      char,               MPI_CHAR,               COLL_IO, _all)
GET_VARN1(schar,     signed char,        MPI_SIGNED_CHAR,        COLL_IO, _all)
GET_VARN1(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      COLL_IO, _all)
GET_VARN1(short,     short,              MPI_SHORT,              COLL_IO, _all)
GET_VARN1(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     COLL_IO, _all)
GET_VARN1(int,       int,                MPI_INT,                COLL_IO, _all)
GET_VARN1(uint,      unsigned int,       MPI_UNSIGNED,           COLL_IO, _all)
GET_VARN1(long,      long,               MPI_LONG,               COLL_IO, _all)
GET_VARN1(float,     float,              MPI_FLOAT,              COLL_IO, _all)
GET_VARN1(double,    double,             MPI_DOUBLE,             COLL_IO, _all)
GET_VARN1(longlong,  long long,          MPI_LONG_LONG_INT,      COLL_IO, _all)
GET_VARN1(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, COLL_IO, _all)

/*----< ncmpi_get_varna() >--------------------------------------------------*/
int
ncmpi_get_varna(int                ncid,
                int                varid,
                int                num,
                MPI_Offset* const  starts[],     /* [num] */
                MPI_Offset* const  counts[],     /* [num] */
                void              *buf,
                MPI_Offset         bufcount,
                MPI_Datatype       buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, counts, NULL,
                               NULL, buf, bufcount, buftype,
                               READ_REQ, INDEP_IO);
}

/*----< ncmpi_get_varna_all() >----------------------------------------------*/
int
ncmpi_get_varna_all(int                ncid,
                    int                varid,
                    int                num,
                    MPI_Offset* const  starts[],     /* [num] */
                    MPI_Offset* const  counts[],     /* [num] */
                    void              *buf,
                    MPI_Offset         bufcount,
                    MPI_Datatype       buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, counts, NULL,
                               NULL, buf, bufcount, buftype,
                               READ_REQ, COLL_IO);
}

dnl
dnl GET_VARNA(btype_name, btype, mpi_type, mode, mode_name)
dnl
define(`GET_VARNA',dnl
`dnl
/*----< ncmpi_get_varna_$1$5() >----------------------------------------------*/
int
ncmpi_get_varna_$1$5(int                ncid,
                     int                varid,
                     int                num,
                     MPI_Offset* const  starts[],    /* [num] */
                     MPI_Offset* const  counts[],    /* [num] */
                     $2                *buf)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, counts, NULL,
                               NULL, buf, -1, $3, READ_REQ, $4);
}
')dnl

GET_VARNA(text,      char,               MPI_CHAR,               INDEP_IO)
GET_VARNA(schar,     signed char,        MPI_SIGNED_CHAR,        INDEP_IO)
GET_VARNA(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      INDEP_IO)
GET_VARNA(short,     short,              MPI_SHORT,              INDEP_IO)
GET_VARNA(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     INDEP_IO)
GET_VARNA(int,       int,                MPI_INT,                INDEP_IO)
GET_VARNA(uint,      unsigned int,       MPI_UNSIGNED,           INDEP_IO)
GET_VARNA(long,      long,               MPI_LONG,               INDEP_IO)
GET_VARNA(float,     float,              MPI_FLOAT,              INDEP_IO)
GET_VARNA(double,    double,             MPI_DOUBLE,             INDEP_IO)
GET_VARNA(longlong,  long long,          MPI_LONG_LONG_INT,      INDEP_IO)
GET_VARNA(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, INDEP_IO)

GET_VARNA(text,      char,               MPI_CHAR,               COLL_IO, _all)
GET_VARNA(schar,     signed char,        MPI_SIGNED_CHAR,        COLL_IO, _all)
GET_VARNA(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      COLL_IO, _all)
GET_VARNA(short,     short,              MPI_SHORT,              COLL_IO, _all)
GET_VARNA(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     COLL_IO, _all)
GET_VARNA(int,       int,                MPI_INT,                COLL_IO, _all)
GET_VARNA(uint,      unsigned int,       MPI_UNSIGNED,           COLL_IO, _all)
GET_VARNA(long,      long,               MPI_LONG,               COLL_IO, _all)
GET_VARNA(float,     float,              MPI_FLOAT,              COLL_IO, _all)
GET_VARNA(double,    double,             MPI_DOUBLE,             COLL_IO, _all)
GET_VARNA(longlong,  long long,          MPI_LONG_LONG_INT,      COLL_IO, _all)
GET_VARNA(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, COLL_IO, _all)

/*----< ncmpi_get_varns() >--------------------------------------------------*/
int
ncmpi_get_varns(int                ncid,
                int                varid,
                int                num,
                MPI_Offset* const  starts[],     /* [num] */
                MPI_Offset* const  counts[],     /* [num] */
                MPI_Offset* const  strides[],    /* [num] */
                void              *buf,
                MPI_Offset         bufcount,
                MPI_Datatype       buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, counts, strides,
                               NULL, buf, bufcount, buftype,
                               READ_REQ, INDEP_IO);
}

/*----< ncmpi_get_varns_all() >----------------------------------------------*/
int
ncmpi_get_varns_all(int                ncid,
                    int                varid,
                    int                num,
                    MPI_Offset* const  starts[],     /* [num] */
                    MPI_Offset* const  counts[],     /* [num] */
                    MPI_Offset* const  strides[],    /* [num] */
                    void              *buf,
                    MPI_Offset         bufcount,
                    MPI_Datatype       buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, counts, strides,
                               NULL, buf, bufcount, buftype,
                               READ_REQ, COLL_IO);
}

dnl
dnl GET_VARNS(btype_name, btype, mpi_type, mode, mode_name)
dnl
define(`GET_VARNS',dnl
`dnl
/*----< ncmpi_get_varns_$1$5() >----------------------------------------------*/
int
ncmpi_get_varns_$1$5(int                ncid,
                     int                varid,
                     int                num,
                     MPI_Offset* const  starts[],    /* [num] */
                     MPI_Offset* const  counts[],    /* [num] */
                     MPI_Offset* const  strides[],   /* [num] */
                     $2                *buf)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, counts, strides,
                               NULL, buf, -1, $3, READ_REQ, $4);
}
')dnl

GET_VARNS(text,      char,               MPI_CHAR,               INDEP_IO)
GET_VARNS(schar,     signed char,        MPI_SIGNED_CHAR,        INDEP_IO)
GET_VARNS(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      INDEP_IO)
GET_VARNS(short,     short,              MPI_SHORT,              INDEP_IO)
GET_VARNS(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     INDEP_IO)
GET_VARNS(int,       int,                MPI_INT,                INDEP_IO)
GET_VARNS(uint,      unsigned int,       MPI_UNSIGNED,           INDEP_IO)
GET_VARNS(long,      long,               MPI_LONG,               INDEP_IO)
GET_VARNS(float,     float,              MPI_FLOAT,              INDEP_IO)
GET_VARNS(double,    double,             MPI_DOUBLE,             INDEP_IO)
GET_VARNS(longlong,  long long,          MPI_LONG_LONG_INT,      INDEP_IO)
GET_VARNS(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, INDEP_IO)

GET_VARNS(text,      char,               MPI_CHAR,               COLL_IO, _all)
GET_VARNS(schar,     signed char,        MPI_SIGNED_CHAR,        COLL_IO, _all)
GET_VARNS(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      COLL_IO, _all)
GET_VARNS(short,     short,              MPI_SHORT,              COLL_IO, _all)
GET_VARNS(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     COLL_IO, _all)
GET_VARNS(int,       int,                MPI_INT,                COLL_IO, _all)
GET_VARNS(uint,      unsigned int,       MPI_UNSIGNED,           COLL_IO, _all)
GET_VARNS(long,      long,               MPI_LONG,               COLL_IO, _all)
GET_VARNS(float,     float,              MPI_FLOAT,              COLL_IO, _all)
GET_VARNS(double,    double,             MPI_DOUBLE,             COLL_IO, _all)
GET_VARNS(longlong,  long long,          MPI_LONG_LONG_INT,      COLL_IO, _all)
GET_VARNS(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, COLL_IO, _all)

/*----< ncmpi_get_varnm() >--------------------------------------------------*/
int
ncmpi_get_varnm(int                ncid,
                int                varid,
                int                num,
                MPI_Offset* const  starts[],     /* [num] */
                MPI_Offset* const  counts[],     /* [num] */
                MPI_Offset* const  strides[],    /* [num] */
                MPI_Offset* const  imaps[],      /* [num] */
                void              *buf,
                MPI_Offset         bufcount,
                MPI_Datatype       buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, counts, strides,
                               imaps, buf, bufcount, buftype,
                               READ_REQ, INDEP_IO);
}

/*----< ncmpi_get_varnm_all() >----------------------------------------------*/
int
ncmpi_get_varnm_all(int                ncid,
                    int                varid,
                    int                num,
                    MPI_Offset* const  starts[],     /* [num] */
                    MPI_Offset* const  counts[],     /* [num] */
                    MPI_Offset* const  strides[],    /* [num] */
                    MPI_Offset* const  imaps[],      /* [num] */
                    void              *buf,
                    MPI_Offset         bufcount,
                    MPI_Datatype       buftype)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, counts, strides,
                               imaps, buf, bufcount, buftype,
                               READ_REQ, COLL_IO);
}

dnl
dnl GET_VARNM(btype_name, btype, mpi_type, mode, mode_name)
dnl
define(`GET_VARNM',dnl
`dnl
/*----< ncmpi_get_varnm_$1$5() >----------------------------------------------*/
int
ncmpi_get_varnm_$1$5(int                ncid,
                     int                varid,
                     int                num,
                     MPI_Offset* const  starts[],    /* [num] */
                     MPI_Offset* const  counts[],    /* [num] */
                     MPI_Offset* const  strides[],   /* [num] */
                     MPI_Offset* const  imaps[],     /* [num] */
                     $2                *buf)
{
    return ncmpio_getput_varnm(ncid, varid, num, starts, counts, strides,
                               imaps, buf, -1, $3, READ_REQ, $4);
}
')dnl

GET_VARNM(text,      char,               MPI_CHAR,               INDEP_IO)
GET_VARNM(schar,     signed char,        MPI_SIGNED_CHAR,        INDEP_IO)
GET_VARNM(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      INDEP_IO)
GET_VARNM(short,     short,              MPI_SHORT,              INDEP_IO)
GET_VARNM(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     INDEP_IO)
GET_VARNM(int,       int,                MPI_INT,                INDEP_IO)
GET_VARNM(uint,      unsigned int,       MPI_UNSIGNED,           INDEP_IO)
GET_VARNM(long,      long,               MPI_LONG,               INDEP_IO)
GET_VARNM(float,     float,              MPI_FLOAT,              INDEP_IO)
GET_VARNM(double,    double,             MPI_DOUBLE,             INDEP_IO)
GET_VARNM(longlong,  long long,          MPI_LONG_LONG_INT,      INDEP_IO)
GET_VARNM(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, INDEP_IO)

GET_VARNM(text,      char,               MPI_CHAR,               COLL_IO, _all)
GET_VARNM(schar,     signed char,        MPI_SIGNED_CHAR,        COLL_IO, _all)
GET_VARNM(uchar,     unsigned char,      MPI_UNSIGNED_CHAR,      COLL_IO, _all)
GET_VARNM(short,     short,              MPI_SHORT,              COLL_IO, _all)
GET_VARNM(ushort,    unsigned short,     MPI_UNSIGNED_SHORT,     COLL_IO, _all)
GET_VARNM(int,       int,                MPI_INT,                COLL_IO, _all)
GET_VARNM(uint,      unsigned int,       MPI_UNSIGNED,           COLL_IO, _all)
GET_VARNM(long,      long,               MPI_LONG,               COLL_IO, _all)
GET_VARNM(float,     float,              MPI_FLOAT,              COLL_IO, _all)
GET_VARNM(double,    double,             MPI_DOUBLE,             COLL_IO, _all)
GET_VARNM(longlong,  long long,          MPI_LONG_LONG_INT,      COLL_IO, _all)
GET_VARNM(ulonglong, unsigned long long, MPI_UNSIGNED_LONG_LONG, COLL_IO, _all)

/*----< ncmpio_getput_varnm() >-----------------------------------------------*/
static int
ncmpio_getput_varnm(int                ncid,
                    int                varid,
                    int                num,
                    MPI_Offset* const  starts[],  /* [num] */
                    MPI_Offset* const  counts[],  /* [num] */
                    MPI_Offset* const  strides[], /* [num] */
                    MPI_Offset* const  imaps[],   /* [num] */
                    void              *buf,
                    MPI_Offset         bufcount,
                    MPI_Datatype       buftype,
                    int                rw_flag,   /* WRITE_REQ or READ_REQ */
                    int                io_method) /* COLL_IO or INDEP_IO */
{
    int i, j, status=NC_NOERR, *req_ids=NULL, *statuses=NULL, min_st;
    int el_size, iscontig_of_ptypes, isderived;
    void *lbuf;
    MPI_Offset bnelems;
    MPI_Datatype ptype;
    NC *ncp=NULL;
    NC_var *varp;
    PNC *pncp;

    /* check if ncid is valid */
    status = PNC_check_id(ncid, &pncp);
    if (status != NC_NOERR)
        /* must return the error now, parallel program might hang */
        return status;

    ncp = (NC*)pncp->ncp;

    /* check if it is in define mode */
    if (NC_indef(ncp)) status = NC_EINDEFINE;

    /* check file write permission if this is write request */
    if (status == NC_NOERR) {
        if (rw_flag == WRITE_REQ && NC_readonly(ncp)) status = NC_EPERM;
    }
    /* check whether collective or independent mode */
    if (status == NC_NOERR) {
        if (io_method == INDEP_IO)
            status = ncmpio_check_mpifh(ncp, 0);
        else if (io_method == COLL_IO)
            status = ncmpio_check_mpifh(ncp, 1);
        /* else if (io_method == INDEP_COLL_IO) */
    }

    /* check if varid is valid */
    if (status == NC_NOERR)
        status = ncmpio_NC_lookupvar(ncp, varid, &varp);

    /* decode buftype */
    if (status == NC_NOERR) {
        if (bufcount >= 0)  /* flexible API is used */
            /* ptype (primitive MPI data type) from buftype
             * el_size is the element size of ptype
             * bnelems is the total number of ptype elements in buftype
             */
            status = ncmpii_dtype_decode(buftype, &ptype, &el_size, &bnelems,
                                         &isderived, &iscontig_of_ptypes);
        else if (bufcount == 0)
            num = 0;
        else {
            ptype = buftype;
            el_size = ncmpio_xlen_nc_type(varp->type);
        }
    }

    if (ncp->safe_mode == 1 && io_method == COLL_IO)
        MPI_Allreduce(&status, &min_st, 1, MPI_INT, MPI_MIN, ncp->nciop->comm);
    else
        min_st = status;

    if (min_st != NC_NOERR)
        return status;

    if (num > 0) {
        req_ids  = (int*) NCI_Malloc(2 * num * SIZEOF_INT);
        statuses = req_ids + num;

        lbuf = buf;
        if (bufcount > 0) { /* flexible API is used */
            /* check if buftype is contiguous, if not, pack to one, lbuf */
            if (! iscontig_of_ptypes && bnelems > 0) {
                /* pack buf into lbuf, a contiguous buffer, based on buftype */
                int position=0, outsize=bnelems*el_size;
                lbuf = NCI_Malloc(outsize);
                MPI_Pack(buf, bufcount, buftype, lbuf, outsize, &position,
                         MPI_COMM_SELF);
            }
        }
    }

    /* break buf into num pieces */
    char *bufp = (char*)lbuf;
    MPI_Offset *start, *count, buflen;

    if (starts == NULL) {         /* var */
        if (num > 0) {
            /* if num > 1, skip the 2nd and rest of requests */
            GET_FULL_DIMENSIONS(start, count)
            for (buflen=1, j=0; j<varp->ndims; j++) buflen *= count[j];
            status = ncmpio_igetput_varm(ncp, varp, start, count, NULL,
                                         NULL, bufp, buflen,
                                         ptype, &req_ids[0], rw_flag, 0);
            if (varp->ndims > 0) NCI_Free(start);
        }
    } else if (counts == NULL) {  /* var1 */
        count = (MPI_Offset*) NCI_Malloc(varp->ndims * SIZEOF_MPI_OFFSET);
        for (j=0; j<varp->ndims; j++) count[j] = 1;
        for (i=0; i<num; i++) {
            status = ncmpio_igetput_varm(ncp, varp, starts[i], count, NULL,
                                         NULL, bufp, 1,
                                         ptype, &req_ids[i], rw_flag, 0);
            bufp += el_size;
        }
        if (varp->ndims > 0) NCI_Free(count);
    } else if (strides == NULL) { /* vara */
        for (i=0; i<num; i++) {
            for (buflen=1, j=0; j<varp->ndims; j++) buflen *= counts[i][j];
            status = ncmpio_igetput_varm(ncp, varp, starts[i], counts[i], NULL,
                                         NULL, bufp, buflen,
                                         ptype, &req_ids[i], rw_flag, 0);
            bufp += buflen * el_size;
        }
    } else if (imaps == NULL) {   /* vars */
        for (i=0; i<num; i++) {
            for (buflen=1, j=0; j<varp->ndims; j++) buflen *= counts[i][j];
            status = ncmpio_igetput_varm(ncp, varp, starts[i], counts[i],
                                         strides[i], NULL, bufp, buflen,
                                         ptype, &req_ids[i], rw_flag, 0);
            bufp += buflen * el_size;
        }
    } else {                      /* varm */
        for (i=0; i<num; i++) {
            for (buflen=1, j=0; j<varp->ndims; j++) buflen *= counts[i][j];
            status = ncmpio_igetput_varm(ncp, varp, starts[i], counts[i],
                                         strides[i], imaps[i], bufp, buflen,
                                         ptype, &req_ids[i], rw_flag, 0);
            bufp += buflen * el_size;
        }
    }

    if (status != NC_NOERR)
        return status;

    if (starts == NULL && num > 0) num = 1; /* var */

    if (io_method == COLL_IO)
        status = ncmpi_wait_all(ncid, num, req_ids, statuses);
    else
        status = ncmpi_wait(ncid, num, req_ids, statuses);

    if (status != NC_NOERR)
        return status;

    for (i=0; i<num; i++)
        if (statuses[i] != NC_NOERR)
            return statuses[i];

    if (num > 0)
        NCI_Free(req_ids);

    return NC_NOERR;
}
