# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Action(_serialization.Model):
    """Action to be applied.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AddActionGroups, RemoveAllActionGroups

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: Action that should be applied. Required. Known values are: "AddActionGroups"
     and "RemoveAllActionGroups".
    :vartype action_type: str or ~azure.mgmt.alertsmanagement.models.ActionType
    """

    _validation = {
        "action_type": {"required": True},
    }

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
    }

    _subtype_map = {
        "action_type": {"AddActionGroups": "AddActionGroups", "RemoveAllActionGroups": "RemoveAllActionGroups"}
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.action_type: Optional[str] = None


class ActionStatus(_serialization.Model):
    """Action status.

    :ivar is_suppressed: Value indicating whether alert is suppressed.
    :vartype is_suppressed: bool
    """

    _attribute_map = {
        "is_suppressed": {"key": "isSuppressed", "type": "bool"},
    }

    def __init__(self, *, is_suppressed: Optional[bool] = None, **kwargs):
        """
        :keyword is_suppressed: Value indicating whether alert is suppressed.
        :paramtype is_suppressed: bool
        """
        super().__init__(**kwargs)
        self.is_suppressed = is_suppressed


class AddActionGroups(Action):
    """Add action groups to alert processing rule.

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: Action that should be applied. Required. Known values are: "AddActionGroups"
     and "RemoveAllActionGroups".
    :vartype action_type: str or ~azure.mgmt.alertsmanagement.models.ActionType
    :ivar action_group_ids: List of action group Ids to add to alert processing rule. Required.
    :vartype action_group_ids: list[str]
    """

    _validation = {
        "action_type": {"required": True},
        "action_group_ids": {"required": True},
    }

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
        "action_group_ids": {"key": "actionGroupIds", "type": "[str]"},
    }

    def __init__(self, *, action_group_ids: List[str], **kwargs):
        """
        :keyword action_group_ids: List of action group Ids to add to alert processing rule. Required.
        :paramtype action_group_ids: list[str]
        """
        super().__init__(**kwargs)
        self.action_type: str = "AddActionGroups"
        self.action_group_ids = action_group_ids


class Resource(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar name: Azure resource name.
    :vartype name: str
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None


class Alert(Resource):
    """An alert created in alert management service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar properties: Alert property bag.
    :vartype properties: ~azure.mgmt.alertsmanagement.models.AlertProperties
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "AlertProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AlertProperties"] = None, **kwargs):
        """
        :keyword properties: Alert property bag.
        :paramtype properties: ~azure.mgmt.alertsmanagement.models.AlertProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AlertModification(Resource):
    """Alert Modification details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar properties: Properties of the alert modification item.
    :vartype properties: ~azure.mgmt.alertsmanagement.models.AlertModificationProperties
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "AlertModificationProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AlertModificationProperties"] = None, **kwargs):
        """
        :keyword properties: Properties of the alert modification item.
        :paramtype properties: ~azure.mgmt.alertsmanagement.models.AlertModificationProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AlertModificationItem(_serialization.Model):
    """Alert modification item.

    :ivar modification_event: Reason for the modification. Known values are: "AlertCreated",
     "StateChange", "MonitorConditionChange", "SeverityChange", "ActionRuleTriggered",
     "ActionRuleSuppressed", "ActionsTriggered", "ActionsSuppressed", and "ActionsFailed".
    :vartype modification_event: str or ~azure.mgmt.alertsmanagement.models.AlertModificationEvent
    :ivar old_value: Old value.
    :vartype old_value: str
    :ivar new_value: New value.
    :vartype new_value: str
    :ivar modified_at: Modified date and time.
    :vartype modified_at: str
    :ivar modified_by: Modified user details (Principal client name).
    :vartype modified_by: str
    :ivar comments: Modification comments.
    :vartype comments: str
    :ivar description: Description of the modification.
    :vartype description: str
    """

    _attribute_map = {
        "modification_event": {"key": "modificationEvent", "type": "str"},
        "old_value": {"key": "oldValue", "type": "str"},
        "new_value": {"key": "newValue", "type": "str"},
        "modified_at": {"key": "modifiedAt", "type": "str"},
        "modified_by": {"key": "modifiedBy", "type": "str"},
        "comments": {"key": "comments", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        modification_event: Optional[Union[str, "_models.AlertModificationEvent"]] = None,
        old_value: Optional[str] = None,
        new_value: Optional[str] = None,
        modified_at: Optional[str] = None,
        modified_by: Optional[str] = None,
        comments: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword modification_event: Reason for the modification. Known values are: "AlertCreated",
         "StateChange", "MonitorConditionChange", "SeverityChange", "ActionRuleTriggered",
         "ActionRuleSuppressed", "ActionsTriggered", "ActionsSuppressed", and "ActionsFailed".
        :paramtype modification_event: str or
         ~azure.mgmt.alertsmanagement.models.AlertModificationEvent
        :keyword old_value: Old value.
        :paramtype old_value: str
        :keyword new_value: New value.
        :paramtype new_value: str
        :keyword modified_at: Modified date and time.
        :paramtype modified_at: str
        :keyword modified_by: Modified user details (Principal client name).
        :paramtype modified_by: str
        :keyword comments: Modification comments.
        :paramtype comments: str
        :keyword description: Description of the modification.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.modification_event = modification_event
        self.old_value = old_value
        self.new_value = new_value
        self.modified_at = modified_at
        self.modified_by = modified_by
        self.comments = comments
        self.description = description


class AlertModificationProperties(_serialization.Model):
    """Properties of the alert modification item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar alert_id: Unique Id of the alert for which the history is being retrieved.
    :vartype alert_id: str
    :ivar modifications: Modification details.
    :vartype modifications: list[~azure.mgmt.alertsmanagement.models.AlertModificationItem]
    """

    _validation = {
        "alert_id": {"readonly": True},
    }

    _attribute_map = {
        "alert_id": {"key": "alertId", "type": "str"},
        "modifications": {"key": "modifications", "type": "[AlertModificationItem]"},
    }

    def __init__(self, *, modifications: Optional[List["_models.AlertModificationItem"]] = None, **kwargs):
        """
        :keyword modifications: Modification details.
        :paramtype modifications: list[~azure.mgmt.alertsmanagement.models.AlertModificationItem]
        """
        super().__init__(**kwargs)
        self.alert_id = None
        self.modifications = modifications


class ManagedResource(Resource):
    """An azure managed resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags


class AlertProcessingRule(ManagedResource):
    """Alert processing rule object containing target scopes, conditions and scheduling logic.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Alert processing rule properties.
    :vartype properties: ~azure.mgmt.alertsmanagement.models.AlertProcessingRuleProperties
    :ivar system_data: Alert processing rule system data.
    :vartype system_data: ~azure.mgmt.alertsmanagement.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "AlertProcessingRuleProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AlertProcessingRuleProperties"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Alert processing rule properties.
        :paramtype properties: ~azure.mgmt.alertsmanagement.models.AlertProcessingRuleProperties
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.properties = properties
        self.system_data = None


class AlertProcessingRuleProperties(_serialization.Model):
    """Alert processing rule properties defining scopes, conditions and scheduling logic for alert processing rule.

    All required parameters must be populated in order to send to Azure.

    :ivar scopes: Scopes on which alert processing rule will apply. Required.
    :vartype scopes: list[str]
    :ivar conditions: Conditions on which alerts will be filtered.
    :vartype conditions: list[~azure.mgmt.alertsmanagement.models.Condition]
    :ivar schedule: Scheduling for alert processing rule.
    :vartype schedule: ~azure.mgmt.alertsmanagement.models.Schedule
    :ivar actions: Actions to be applied. Required.
    :vartype actions: list[~azure.mgmt.alertsmanagement.models.Action]
    :ivar description: Description of alert processing rule.
    :vartype description: str
    :ivar enabled: Indicates if the given alert processing rule is enabled or disabled.
    :vartype enabled: bool
    """

    _validation = {
        "scopes": {"required": True},
        "actions": {"required": True},
    }

    _attribute_map = {
        "scopes": {"key": "scopes", "type": "[str]"},
        "conditions": {"key": "conditions", "type": "[Condition]"},
        "schedule": {"key": "schedule", "type": "Schedule"},
        "actions": {"key": "actions", "type": "[Action]"},
        "description": {"key": "description", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        scopes: List[str],
        actions: List["_models.Action"],
        conditions: Optional[List["_models.Condition"]] = None,
        schedule: Optional["_models.Schedule"] = None,
        description: Optional[str] = None,
        enabled: bool = True,
        **kwargs
    ):
        """
        :keyword scopes: Scopes on which alert processing rule will apply. Required.
        :paramtype scopes: list[str]
        :keyword conditions: Conditions on which alerts will be filtered.
        :paramtype conditions: list[~azure.mgmt.alertsmanagement.models.Condition]
        :keyword schedule: Scheduling for alert processing rule.
        :paramtype schedule: ~azure.mgmt.alertsmanagement.models.Schedule
        :keyword actions: Actions to be applied. Required.
        :paramtype actions: list[~azure.mgmt.alertsmanagement.models.Action]
        :keyword description: Description of alert processing rule.
        :paramtype description: str
        :keyword enabled: Indicates if the given alert processing rule is enabled or disabled.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.scopes = scopes
        self.conditions = conditions
        self.schedule = schedule
        self.actions = actions
        self.description = description
        self.enabled = enabled


class AlertProcessingRulesList(_serialization.Model):
    """List of alert processing rules.

    :ivar next_link: URL to fetch the next set of alert processing rules.
    :vartype next_link: str
    :ivar value: List of alert processing rules.
    :vartype value: list[~azure.mgmt.alertsmanagement.models.AlertProcessingRule]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[AlertProcessingRule]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.AlertProcessingRule"]] = None, **kwargs
    ):
        """
        :keyword next_link: URL to fetch the next set of alert processing rules.
        :paramtype next_link: str
        :keyword value: List of alert processing rules.
        :paramtype value: list[~azure.mgmt.alertsmanagement.models.AlertProcessingRule]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class AlertProperties(_serialization.Model):
    """Alert property bag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar essentials: This object contains consistent fields across different monitor services.
    :vartype essentials: ~azure.mgmt.alertsmanagement.models.Essentials
    :ivar context: Information specific to the monitor service that gives more contextual details
     about the alert.
    :vartype context: JSON
    :ivar egress_config: Config which would be used for displaying the data in portal.
    :vartype egress_config: JSON
    """

    _validation = {
        "context": {"readonly": True},
        "egress_config": {"readonly": True},
    }

    _attribute_map = {
        "essentials": {"key": "essentials", "type": "Essentials"},
        "context": {"key": "context", "type": "object"},
        "egress_config": {"key": "egressConfig", "type": "object"},
    }

    def __init__(self, *, essentials: Optional["_models.Essentials"] = None, **kwargs):
        """
        :keyword essentials: This object contains consistent fields across different monitor services.
        :paramtype essentials: ~azure.mgmt.alertsmanagement.models.Essentials
        """
        super().__init__(**kwargs)
        self.essentials = essentials
        self.context = None
        self.egress_config = None


class AlertsList(_serialization.Model):
    """List the alerts.

    :ivar next_link: URL to fetch the next set of alerts.
    :vartype next_link: str
    :ivar value: List of alerts.
    :vartype value: list[~azure.mgmt.alertsmanagement.models.Alert]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Alert]"},
    }

    def __init__(self, *, next_link: Optional[str] = None, value: Optional[List["_models.Alert"]] = None, **kwargs):
        """
        :keyword next_link: URL to fetch the next set of alerts.
        :paramtype next_link: str
        :keyword value: List of alerts.
        :paramtype value: list[~azure.mgmt.alertsmanagement.models.Alert]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class AlertsMetaData(_serialization.Model):
    """alert meta data information.

    :ivar properties: alert meta data property bag.
    :vartype properties: ~azure.mgmt.alertsmanagement.models.AlertsMetaDataProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "AlertsMetaDataProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AlertsMetaDataProperties"] = None, **kwargs):
        """
        :keyword properties: alert meta data property bag.
        :paramtype properties: ~azure.mgmt.alertsmanagement.models.AlertsMetaDataProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AlertsMetaDataProperties(_serialization.Model):
    """alert meta data property bag.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MonitorServiceList

    All required parameters must be populated in order to send to Azure.

    :ivar metadata_identifier: Identification of the information to be retrieved by API call.
     Required. "MonitorServiceList"
    :vartype metadata_identifier: str or ~azure.mgmt.alertsmanagement.models.MetadataIdentifier
    """

    _validation = {
        "metadata_identifier": {"required": True},
    }

    _attribute_map = {
        "metadata_identifier": {"key": "metadataIdentifier", "type": "str"},
    }

    _subtype_map = {"metadata_identifier": {"MonitorServiceList": "MonitorServiceList"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.metadata_identifier: Optional[str] = None


class AlertsSummary(Resource):
    """Summary of alerts based on the input filters and 'groupby' parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar properties: Group the result set.
    :vartype properties: ~azure.mgmt.alertsmanagement.models.AlertsSummaryGroup
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "AlertsSummaryGroup"},
    }

    def __init__(self, *, properties: Optional["_models.AlertsSummaryGroup"] = None, **kwargs):
        """
        :keyword properties: Group the result set.
        :paramtype properties: ~azure.mgmt.alertsmanagement.models.AlertsSummaryGroup
        """
        super().__init__(**kwargs)
        self.properties = properties


class AlertsSummaryGroup(_serialization.Model):
    """Group the result set.

    :ivar total: Total count of the result set.
    :vartype total: int
    :ivar smart_groups_count: Total count of the smart groups.
    :vartype smart_groups_count: int
    :ivar groupedby: Name of the field aggregated.
    :vartype groupedby: str
    :ivar values: List of the items.
    :vartype values: list[~azure.mgmt.alertsmanagement.models.AlertsSummaryGroupItem]
    """

    _attribute_map = {
        "total": {"key": "total", "type": "int"},
        "smart_groups_count": {"key": "smartGroupsCount", "type": "int"},
        "groupedby": {"key": "groupedby", "type": "str"},
        "values": {"key": "values", "type": "[AlertsSummaryGroupItem]"},
    }

    def __init__(
        self,
        *,
        total: Optional[int] = None,
        smart_groups_count: Optional[int] = None,
        groupedby: Optional[str] = None,
        values: Optional[List["_models.AlertsSummaryGroupItem"]] = None,
        **kwargs
    ):
        """
        :keyword total: Total count of the result set.
        :paramtype total: int
        :keyword smart_groups_count: Total count of the smart groups.
        :paramtype smart_groups_count: int
        :keyword groupedby: Name of the field aggregated.
        :paramtype groupedby: str
        :keyword values: List of the items.
        :paramtype values: list[~azure.mgmt.alertsmanagement.models.AlertsSummaryGroupItem]
        """
        super().__init__(**kwargs)
        self.total = total
        self.smart_groups_count = smart_groups_count
        self.groupedby = groupedby
        self.values = values


class AlertsSummaryGroupItem(_serialization.Model):
    """Alerts summary group item.

    :ivar name: Value of the aggregated field.
    :vartype name: str
    :ivar count: Count of the aggregated field.
    :vartype count: int
    :ivar groupedby: Name of the field aggregated.
    :vartype groupedby: str
    :ivar values: List of the items.
    :vartype values: list[~azure.mgmt.alertsmanagement.models.AlertsSummaryGroupItem]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "count": {"key": "count", "type": "int"},
        "groupedby": {"key": "groupedby", "type": "str"},
        "values": {"key": "values", "type": "[AlertsSummaryGroupItem]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        count: Optional[int] = None,
        groupedby: Optional[str] = None,
        values: Optional[List["_models.AlertsSummaryGroupItem"]] = None,
        **kwargs
    ):
        """
        :keyword name: Value of the aggregated field.
        :paramtype name: str
        :keyword count: Count of the aggregated field.
        :paramtype count: int
        :keyword groupedby: Name of the field aggregated.
        :paramtype groupedby: str
        :keyword values: List of the items.
        :paramtype values: list[~azure.mgmt.alertsmanagement.models.AlertsSummaryGroupItem]
        """
        super().__init__(**kwargs)
        self.name = name
        self.count = count
        self.groupedby = groupedby
        self.values = values


class Comments(_serialization.Model):
    """Change alert state reason.

    :ivar comments:
    :vartype comments: str
    """

    _attribute_map = {
        "comments": {"key": "comments", "type": "str"},
    }

    def __init__(self, *, comments: Optional[str] = None, **kwargs):
        """
        :keyword comments:
        :paramtype comments: str
        """
        super().__init__(**kwargs)
        self.comments = comments


class Condition(_serialization.Model):
    """Condition to trigger an alert processing rule.

    :ivar field: Field for a given condition. Known values are: "Severity", "MonitorService",
     "MonitorCondition", "SignalType", "TargetResourceType", "TargetResource",
     "TargetResourceGroup", "AlertRuleId", "AlertRuleName", "Description", and "AlertContext".
    :vartype field: str or ~azure.mgmt.alertsmanagement.models.Field
    :ivar operator: Operator for a given condition. Known values are: "Equals", "NotEquals",
     "Contains", and "DoesNotContain".
    :vartype operator: str or ~azure.mgmt.alertsmanagement.models.Operator
    :ivar values: List of values to match for a given condition.
    :vartype values: list[str]
    """

    _attribute_map = {
        "field": {"key": "field", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        field: Optional[Union[str, "_models.Field"]] = None,
        operator: Optional[Union[str, "_models.Operator"]] = None,
        values: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword field: Field for a given condition. Known values are: "Severity", "MonitorService",
         "MonitorCondition", "SignalType", "TargetResourceType", "TargetResource",
         "TargetResourceGroup", "AlertRuleId", "AlertRuleName", "Description", and "AlertContext".
        :paramtype field: str or ~azure.mgmt.alertsmanagement.models.Field
        :keyword operator: Operator for a given condition. Known values are: "Equals", "NotEquals",
         "Contains", and "DoesNotContain".
        :paramtype operator: str or ~azure.mgmt.alertsmanagement.models.Operator
        :keyword values: List of values to match for a given condition.
        :paramtype values: list[str]
        """
        super().__init__(**kwargs)
        self.field = field
        self.operator = operator
        self.values = values


class Recurrence(_serialization.Model):
    """Recurrence object.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DailyRecurrence, MonthlyRecurrence, WeeklyRecurrence

    All required parameters must be populated in order to send to Azure.

    :ivar recurrence_type: Specifies when the recurrence should be applied. Required. Known values
     are: "Daily", "Weekly", and "Monthly".
    :vartype recurrence_type: str or ~azure.mgmt.alertsmanagement.models.RecurrenceType
    :ivar start_time: Start time for recurrence.
    :vartype start_time: str
    :ivar end_time: End time for recurrence.
    :vartype end_time: str
    """

    _validation = {
        "recurrence_type": {"required": True},
    }

    _attribute_map = {
        "recurrence_type": {"key": "recurrenceType", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "end_time": {"key": "endTime", "type": "str"},
    }

    _subtype_map = {
        "recurrence_type": {"Daily": "DailyRecurrence", "Monthly": "MonthlyRecurrence", "Weekly": "WeeklyRecurrence"}
    }

    def __init__(self, *, start_time: Optional[str] = None, end_time: Optional[str] = None, **kwargs):
        """
        :keyword start_time: Start time for recurrence.
        :paramtype start_time: str
        :keyword end_time: End time for recurrence.
        :paramtype end_time: str
        """
        super().__init__(**kwargs)
        self.recurrence_type: Optional[str] = None
        self.start_time = start_time
        self.end_time = end_time


class DailyRecurrence(Recurrence):
    """Daily recurrence object.

    All required parameters must be populated in order to send to Azure.

    :ivar recurrence_type: Specifies when the recurrence should be applied. Required. Known values
     are: "Daily", "Weekly", and "Monthly".
    :vartype recurrence_type: str or ~azure.mgmt.alertsmanagement.models.RecurrenceType
    :ivar start_time: Start time for recurrence.
    :vartype start_time: str
    :ivar end_time: End time for recurrence.
    :vartype end_time: str
    """

    _validation = {
        "recurrence_type": {"required": True},
    }

    _attribute_map = {
        "recurrence_type": {"key": "recurrenceType", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "end_time": {"key": "endTime", "type": "str"},
    }

    def __init__(self, *, start_time: Optional[str] = None, end_time: Optional[str] = None, **kwargs):
        """
        :keyword start_time: Start time for recurrence.
        :paramtype start_time: str
        :keyword end_time: End time for recurrence.
        :paramtype end_time: str
        """
        super().__init__(start_time=start_time, end_time=end_time, **kwargs)
        self.recurrence_type: str = "Daily"


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.alertsmanagement.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.alertsmanagement.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """An error response from the service.

    :ivar error: Details of error response.
    :vartype error: ~azure.mgmt.alertsmanagement.models.ErrorResponseBody
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponseBody"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponseBody"] = None, **kwargs):
        """
        :keyword error: Details of error response.
        :paramtype error: ~azure.mgmt.alertsmanagement.models.ErrorResponseBody
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseAutoGenerated(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.alertsmanagement.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.alertsmanagement.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseAutoGenerated2(_serialization.Model):
    """An error response from the service.

    :ivar error: Details of error response.
    :vartype error: ~azure.mgmt.alertsmanagement.models.ErrorResponseBodyAutoGenerated
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponseBodyAutoGenerated"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponseBodyAutoGenerated"] = None, **kwargs):
        """
        :keyword error: Details of error response.
        :paramtype error: ~azure.mgmt.alertsmanagement.models.ErrorResponseBodyAutoGenerated
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseAutoGenerated3(_serialization.Model):
    """An error response from the service.

    :ivar error: Details of error response.
    :vartype error: ~azure.mgmt.alertsmanagement.models.ErrorResponseBodyAutoGenerated2
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponseBodyAutoGenerated2"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponseBodyAutoGenerated2"] = None, **kwargs):
        """
        :keyword error: Details of error response.
        :paramtype error: ~azure.mgmt.alertsmanagement.models.ErrorResponseBodyAutoGenerated2
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseBody(_serialization.Model):
    """Details of error response.

    :ivar code: Error code, intended to be consumed programmatically.
    :vartype code: str
    :ivar message: Description of the error, intended for display in user interface.
    :vartype message: str
    :ivar target: Target of the particular error, for example name of the property.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.alertsmanagement.models.ErrorResponseBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponseBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.ErrorResponseBody"]] = None,
        **kwargs
    ):
        """
        :keyword code: Error code, intended to be consumed programmatically.
        :paramtype code: str
        :keyword message: Description of the error, intended for display in user interface.
        :paramtype message: str
        :keyword target: Target of the particular error, for example name of the property.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.alertsmanagement.models.ErrorResponseBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ErrorResponseBodyAutoGenerated(_serialization.Model):
    """Details of error response.

    :ivar code: Error code, intended to be consumed programmatically.
    :vartype code: str
    :ivar message: Description of the error, intended for display in user interface.
    :vartype message: str
    :ivar target: Target of the particular error, for example name of the property.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.alertsmanagement.models.ErrorResponseBodyAutoGenerated]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponseBodyAutoGenerated]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.ErrorResponseBodyAutoGenerated"]] = None,
        **kwargs
    ):
        """
        :keyword code: Error code, intended to be consumed programmatically.
        :paramtype code: str
        :keyword message: Description of the error, intended for display in user interface.
        :paramtype message: str
        :keyword target: Target of the particular error, for example name of the property.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.alertsmanagement.models.ErrorResponseBodyAutoGenerated]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ErrorResponseBodyAutoGenerated2(_serialization.Model):
    """Details of error response.

    :ivar code: Error code, intended to be consumed programmatically.
    :vartype code: str
    :ivar message: Description of the error, intended for display in user interface.
    :vartype message: str
    :ivar target: Target of the particular error, for example name of the property.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.alertsmanagement.models.ErrorResponseBodyAutoGenerated2]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponseBodyAutoGenerated2]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.ErrorResponseBodyAutoGenerated2"]] = None,
        **kwargs
    ):
        """
        :keyword code: Error code, intended to be consumed programmatically.
        :paramtype code: str
        :keyword message: Description of the error, intended for display in user interface.
        :paramtype message: str
        :keyword target: Target of the particular error, for example name of the property.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.alertsmanagement.models.ErrorResponseBodyAutoGenerated2]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class Essentials(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """This object contains consistent fields across different monitor services.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar severity: Severity of alert Sev0 being highest and Sev4 being lowest. Known values are:
     "Sev0", "Sev1", "Sev2", "Sev3", and "Sev4".
    :vartype severity: str or ~azure.mgmt.alertsmanagement.models.Severity
    :ivar signal_type: The type of signal the alert is based on, which could be metrics, logs or
     activity logs. Known values are: "Metric", "Log", and "Unknown".
    :vartype signal_type: str or ~azure.mgmt.alertsmanagement.models.SignalType
    :ivar alert_state: Alert object state, which can be modified by the user. Known values are:
     "New", "Acknowledged", and "Closed".
    :vartype alert_state: str or ~azure.mgmt.alertsmanagement.models.AlertState
    :ivar monitor_condition: Condition of the rule at the monitor service. It represents whether
     the underlying conditions have crossed the defined alert rule thresholds. Known values are:
     "Fired" and "Resolved".
    :vartype monitor_condition: str or ~azure.mgmt.alertsmanagement.models.MonitorCondition
    :ivar target_resource: Target ARM resource, on which alert got created.
    :vartype target_resource: str
    :ivar target_resource_name: Name of the target ARM resource name, on which alert got created.
    :vartype target_resource_name: str
    :ivar target_resource_group: Resource group of target ARM resource, on which alert got created.
    :vartype target_resource_group: str
    :ivar target_resource_type: Resource type of target ARM resource, on which alert got created.
    :vartype target_resource_type: str
    :ivar monitor_service: Monitor service on which the rule(monitor) is set. Known values are:
     "Application Insights", "ActivityLog Administrative", "ActivityLog Security", "ActivityLog
     Recommendation", "ActivityLog Policy", "ActivityLog Autoscale", "Log Analytics", "Nagios",
     "Platform", "SCOM", "ServiceHealth", "SmartDetector", "VM Insights", and "Zabbix".
    :vartype monitor_service: str or ~azure.mgmt.alertsmanagement.models.MonitorService
    :ivar alert_rule: Rule(monitor) which fired alert instance. Depending on the monitor service,
     this would be ARM id or name of the rule.
    :vartype alert_rule: str
    :ivar source_created_id: Unique Id created by monitor service for each alert instance. This
     could be used to track the issue at the monitor service, in case of Nagios, Zabbix, SCOM etc.
    :vartype source_created_id: str
    :ivar smart_group_id: Unique Id of the smart group.
    :vartype smart_group_id: str
    :ivar smart_grouping_reason: Verbose reason describing the reason why this alert instance is
     added to a smart group.
    :vartype smart_grouping_reason: str
    :ivar start_date_time: Creation time(ISO-8601 format) of alert instance.
    :vartype start_date_time: ~datetime.datetime
    :ivar last_modified_date_time: Last modification time(ISO-8601 format) of alert instance.
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar monitor_condition_resolved_date_time: Resolved time(ISO-8601 format) of alert instance.
     This will be updated when monitor service resolves the alert instance because the rule
     condition is no longer met.
    :vartype monitor_condition_resolved_date_time: ~datetime.datetime
    :ivar last_modified_user_name: User who last modified the alert, in case of monitor service
     updates user would be 'system', otherwise name of the user.
    :vartype last_modified_user_name: str
    :ivar action_status: Action status.
    :vartype action_status: ~azure.mgmt.alertsmanagement.models.ActionStatus
    :ivar description: Alert description.
    :vartype description: str
    """

    _validation = {
        "severity": {"readonly": True},
        "signal_type": {"readonly": True},
        "alert_state": {"readonly": True},
        "monitor_condition": {"readonly": True},
        "monitor_service": {"readonly": True},
        "alert_rule": {"readonly": True},
        "source_created_id": {"readonly": True},
        "smart_group_id": {"readonly": True},
        "smart_grouping_reason": {"readonly": True},
        "start_date_time": {"readonly": True},
        "last_modified_date_time": {"readonly": True},
        "monitor_condition_resolved_date_time": {"readonly": True},
        "last_modified_user_name": {"readonly": True},
    }

    _attribute_map = {
        "severity": {"key": "severity", "type": "str"},
        "signal_type": {"key": "signalType", "type": "str"},
        "alert_state": {"key": "alertState", "type": "str"},
        "monitor_condition": {"key": "monitorCondition", "type": "str"},
        "target_resource": {"key": "targetResource", "type": "str"},
        "target_resource_name": {"key": "targetResourceName", "type": "str"},
        "target_resource_group": {"key": "targetResourceGroup", "type": "str"},
        "target_resource_type": {"key": "targetResourceType", "type": "str"},
        "monitor_service": {"key": "monitorService", "type": "str"},
        "alert_rule": {"key": "alertRule", "type": "str"},
        "source_created_id": {"key": "sourceCreatedId", "type": "str"},
        "smart_group_id": {"key": "smartGroupId", "type": "str"},
        "smart_grouping_reason": {"key": "smartGroupingReason", "type": "str"},
        "start_date_time": {"key": "startDateTime", "type": "iso-8601"},
        "last_modified_date_time": {"key": "lastModifiedDateTime", "type": "iso-8601"},
        "monitor_condition_resolved_date_time": {"key": "monitorConditionResolvedDateTime", "type": "iso-8601"},
        "last_modified_user_name": {"key": "lastModifiedUserName", "type": "str"},
        "action_status": {"key": "actionStatus", "type": "ActionStatus"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_resource: Optional[str] = None,
        target_resource_name: Optional[str] = None,
        target_resource_group: Optional[str] = None,
        target_resource_type: Optional[str] = None,
        action_status: Optional["_models.ActionStatus"] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword target_resource: Target ARM resource, on which alert got created.
        :paramtype target_resource: str
        :keyword target_resource_name: Name of the target ARM resource name, on which alert got
         created.
        :paramtype target_resource_name: str
        :keyword target_resource_group: Resource group of target ARM resource, on which alert got
         created.
        :paramtype target_resource_group: str
        :keyword target_resource_type: Resource type of target ARM resource, on which alert got
         created.
        :paramtype target_resource_type: str
        :keyword action_status: Action status.
        :paramtype action_status: ~azure.mgmt.alertsmanagement.models.ActionStatus
        :keyword description: Alert description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.severity = None
        self.signal_type = None
        self.alert_state = None
        self.monitor_condition = None
        self.target_resource = target_resource
        self.target_resource_name = target_resource_name
        self.target_resource_group = target_resource_group
        self.target_resource_type = target_resource_type
        self.monitor_service = None
        self.alert_rule = None
        self.source_created_id = None
        self.smart_group_id = None
        self.smart_grouping_reason = None
        self.start_date_time = None
        self.last_modified_date_time = None
        self.monitor_condition_resolved_date_time = None
        self.last_modified_user_name = None
        self.action_status = action_status
        self.description = description


class MonitorServiceDetails(_serialization.Model):
    """Details of a monitor service.

    :ivar name: Monitor service name.
    :vartype name: str
    :ivar display_name: Monitor service display name.
    :vartype display_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, display_name: Optional[str] = None, **kwargs):
        """
        :keyword name: Monitor service name.
        :paramtype name: str
        :keyword display_name: Monitor service display name.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name


class MonitorServiceList(AlertsMetaDataProperties):
    """Monitor service details.

    All required parameters must be populated in order to send to Azure.

    :ivar metadata_identifier: Identification of the information to be retrieved by API call.
     Required. "MonitorServiceList"
    :vartype metadata_identifier: str or ~azure.mgmt.alertsmanagement.models.MetadataIdentifier
    :ivar data: Array of operations. Required.
    :vartype data: list[~azure.mgmt.alertsmanagement.models.MonitorServiceDetails]
    """

    _validation = {
        "metadata_identifier": {"required": True},
        "data": {"required": True},
    }

    _attribute_map = {
        "metadata_identifier": {"key": "metadataIdentifier", "type": "str"},
        "data": {"key": "data", "type": "[MonitorServiceDetails]"},
    }

    def __init__(self, *, data: List["_models.MonitorServiceDetails"], **kwargs):
        """
        :keyword data: Array of operations. Required.
        :paramtype data: list[~azure.mgmt.alertsmanagement.models.MonitorServiceDetails]
        """
        super().__init__(**kwargs)
        self.metadata_identifier: str = "MonitorServiceList"
        self.data = data


class MonthlyRecurrence(Recurrence):
    """Monthly recurrence object.

    All required parameters must be populated in order to send to Azure.

    :ivar recurrence_type: Specifies when the recurrence should be applied. Required. Known values
     are: "Daily", "Weekly", and "Monthly".
    :vartype recurrence_type: str or ~azure.mgmt.alertsmanagement.models.RecurrenceType
    :ivar start_time: Start time for recurrence.
    :vartype start_time: str
    :ivar end_time: End time for recurrence.
    :vartype end_time: str
    :ivar days_of_month: Specifies the values for monthly recurrence pattern. Required.
    :vartype days_of_month: list[int]
    """

    _validation = {
        "recurrence_type": {"required": True},
        "days_of_month": {"required": True},
    }

    _attribute_map = {
        "recurrence_type": {"key": "recurrenceType", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "end_time": {"key": "endTime", "type": "str"},
        "days_of_month": {"key": "daysOfMonth", "type": "[int]"},
    }

    def __init__(
        self, *, days_of_month: List[int], start_time: Optional[str] = None, end_time: Optional[str] = None, **kwargs
    ):
        """
        :keyword start_time: Start time for recurrence.
        :paramtype start_time: str
        :keyword end_time: End time for recurrence.
        :paramtype end_time: str
        :keyword days_of_month: Specifies the values for monthly recurrence pattern. Required.
        :paramtype days_of_month: list[int]
        """
        super().__init__(start_time=start_time, end_time=end_time, **kwargs)
        self.recurrence_type: str = "Monthly"
        self.days_of_month = days_of_month


class Operation(_serialization.Model):
    """Operation provided by provider.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar display: Properties of the operation.
    :vartype display: ~azure.mgmt.alertsmanagement.models.OperationDisplay
    :ivar origin: Origin of the operation.
    :vartype origin: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword display: Properties of the operation.
        :paramtype display: ~azure.mgmt.alertsmanagement.models.OperationDisplay
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin


class OperationDisplay(_serialization.Model):
    """Properties of the operation.

    :ivar provider: Provider name.
    :vartype provider: str
    :ivar resource: Resource name.
    :vartype resource: str
    :ivar operation: Operation name.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Provider name.
        :paramtype provider: str
        :keyword resource: Resource name.
        :paramtype resource: str
        :keyword operation: Operation name.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationsList(_serialization.Model):
    """Lists the operations available in the AlertsManagement RP.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: URL to fetch the next set of alerts.
    :vartype next_link: str
    :ivar value: Array of operations. Required.
    :vartype value: list[~azure.mgmt.alertsmanagement.models.Operation]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, value: List["_models.Operation"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: URL to fetch the next set of alerts.
        :paramtype next_link: str
        :keyword value: Array of operations. Required.
        :paramtype value: list[~azure.mgmt.alertsmanagement.models.Operation]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class PatchObject(_serialization.Model):
    """Data contract for patch.

    :ivar tags: Tags to be updated.
    :vartype tags: dict[str, str]
    :ivar enabled: Indicates if the given alert processing rule is enabled or disabled.
    :vartype enabled: bool
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, enabled: Optional[bool] = None, **kwargs):
        """
        :keyword tags: Tags to be updated.
        :paramtype tags: dict[str, str]
        :keyword enabled: Indicates if the given alert processing rule is enabled or disabled.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.enabled = enabled


class PrometheusRule(_serialization.Model):
    """PrometheusRule.

    All required parameters must be populated in order to send to Azure.

    :ivar record: the name of the recording rule.
    :vartype record: str
    :ivar alert: the name of the alert rule.
    :vartype alert: str
    :ivar enabled: the flag that indicates whether the Prometheus rule is enabled.
    :vartype enabled: bool
    :ivar expression: the expression to run for the rule. Required.
    :vartype expression: str
    :ivar severity: the severity of the alerts fired by the rule. Only relevant for alerts.
    :vartype severity: int
    :ivar for_property: the amount of time alert must be active before firing. Only relevant for
     alerts.
    :vartype for_property: str
    :ivar labels: labels for rule group. Only relevant for alerts.
    :vartype labels: dict[str, str]
    :ivar annotations: annotations for rule group. Only relevant for alerts.
    :vartype annotations: dict[str, str]
    :ivar actions: The array of actions that are performed when the alert rule becomes active, and
     when an alert condition is resolved. Only relevant for alerts.
    :vartype actions: list[~azure.mgmt.alertsmanagement.models.PrometheusRuleGroupAction]
    :ivar resolve_configuration: defines the configuration for resolving fired alerts. Only
     relevant for alerts.
    :vartype resolve_configuration:
     ~azure.mgmt.alertsmanagement.models.PrometheusRuleResolveConfiguration
    """

    _validation = {
        "expression": {"required": True},
    }

    _attribute_map = {
        "record": {"key": "record", "type": "str"},
        "alert": {"key": "alert", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
        "expression": {"key": "expression", "type": "str"},
        "severity": {"key": "severity", "type": "int"},
        "for_property": {"key": "for", "type": "str"},
        "labels": {"key": "labels", "type": "{str}"},
        "annotations": {"key": "annotations", "type": "{str}"},
        "actions": {"key": "actions", "type": "[PrometheusRuleGroupAction]"},
        "resolve_configuration": {"key": "resolveConfiguration", "type": "PrometheusRuleResolveConfiguration"},
    }

    def __init__(
        self,
        *,
        expression: str,
        record: Optional[str] = None,
        alert: Optional[str] = None,
        enabled: Optional[bool] = None,
        severity: Optional[int] = None,
        for_property: Optional[str] = None,
        labels: Optional[Dict[str, str]] = None,
        annotations: Optional[Dict[str, str]] = None,
        actions: Optional[List["_models.PrometheusRuleGroupAction"]] = None,
        resolve_configuration: Optional["_models.PrometheusRuleResolveConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword record: the name of the recording rule.
        :paramtype record: str
        :keyword alert: the name of the alert rule.
        :paramtype alert: str
        :keyword enabled: the flag that indicates whether the Prometheus rule is enabled.
        :paramtype enabled: bool
        :keyword expression: the expression to run for the rule. Required.
        :paramtype expression: str
        :keyword severity: the severity of the alerts fired by the rule. Only relevant for alerts.
        :paramtype severity: int
        :keyword for_property: the amount of time alert must be active before firing. Only relevant for
         alerts.
        :paramtype for_property: str
        :keyword labels: labels for rule group. Only relevant for alerts.
        :paramtype labels: dict[str, str]
        :keyword annotations: annotations for rule group. Only relevant for alerts.
        :paramtype annotations: dict[str, str]
        :keyword actions: The array of actions that are performed when the alert rule becomes active,
         and when an alert condition is resolved. Only relevant for alerts.
        :paramtype actions: list[~azure.mgmt.alertsmanagement.models.PrometheusRuleGroupAction]
        :keyword resolve_configuration: defines the configuration for resolving fired alerts. Only
         relevant for alerts.
        :paramtype resolve_configuration:
         ~azure.mgmt.alertsmanagement.models.PrometheusRuleResolveConfiguration
        """
        super().__init__(**kwargs)
        self.record = record
        self.alert = alert
        self.enabled = enabled
        self.expression = expression
        self.severity = severity
        self.for_property = for_property
        self.labels = labels
        self.annotations = annotations
        self.actions = actions
        self.resolve_configuration = resolve_configuration


class PrometheusRuleGroupAction(_serialization.Model):
    """An alert action. Only relevant for alerts.

    :ivar action_group_id: The resource id of the action group to use.
    :vartype action_group_id: str
    :ivar action_properties: The properties of an action group object.
    :vartype action_properties: dict[str, str]
    """

    _attribute_map = {
        "action_group_id": {"key": "actionGroupId", "type": "str"},
        "action_properties": {"key": "actionProperties", "type": "{str}"},
    }

    def __init__(
        self, *, action_group_id: Optional[str] = None, action_properties: Optional[Dict[str, str]] = None, **kwargs
    ):
        """
        :keyword action_group_id: The resource id of the action group to use.
        :paramtype action_group_id: str
        :keyword action_properties: The properties of an action group object.
        :paramtype action_properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.action_group_id = action_group_id
        self.action_properties = action_properties


class ResourceAutoGenerated(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.alertsmanagement.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(ResourceAutoGenerated):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.alertsmanagement.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class PrometheusRuleGroupResource(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The Prometheus rule group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.alertsmanagement.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar description: the description of the Prometheus rule group that will be included in the
     alert email.
    :vartype description: str
    :ivar enabled: the flag that indicates whether the Prometheus rule group is enabled.
    :vartype enabled: bool
    :ivar cluster_name: the cluster name of the rule group evaluation.
    :vartype cluster_name: str
    :ivar scopes: the list of resource id's that this rule group is scoped to. Required.
    :vartype scopes: list[str]
    :ivar interval: the interval in which to run the Prometheus rule group represented in ISO 8601
     duration format. Should be between 1 and 15 minutes.
    :vartype interval: str
    :ivar rules: defines the rules in the Prometheus rule group. Required.
    :vartype rules: list[~azure.mgmt.alertsmanagement.models.PrometheusRule]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "scopes": {"required": True},
        "rules": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "cluster_name": {"key": "properties.clusterName", "type": "str"},
        "scopes": {"key": "properties.scopes", "type": "[str]"},
        "interval": {"key": "properties.interval", "type": "str"},
        "rules": {"key": "properties.rules", "type": "[PrometheusRule]"},
    }

    def __init__(
        self,
        *,
        location: str,
        scopes: List[str],
        rules: List["_models.PrometheusRule"],
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        enabled: Optional[bool] = None,
        cluster_name: Optional[str] = None,
        interval: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword description: the description of the Prometheus rule group that will be included in the
         alert email.
        :paramtype description: str
        :keyword enabled: the flag that indicates whether the Prometheus rule group is enabled.
        :paramtype enabled: bool
        :keyword cluster_name: the cluster name of the rule group evaluation.
        :paramtype cluster_name: str
        :keyword scopes: the list of resource id's that this rule group is scoped to. Required.
        :paramtype scopes: list[str]
        :keyword interval: the interval in which to run the Prometheus rule group represented in ISO
         8601 duration format. Should be between 1 and 15 minutes.
        :paramtype interval: str
        :keyword rules: defines the rules in the Prometheus rule group. Required.
        :paramtype rules: list[~azure.mgmt.alertsmanagement.models.PrometheusRule]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.description = description
        self.enabled = enabled
        self.cluster_name = cluster_name
        self.scopes = scopes
        self.interval = interval
        self.rules = rules


class PrometheusRuleGroupResourceCollection(_serialization.Model):
    """Represents a collection of alert rule resources.

    :ivar value: the values for the alert rule resources.
    :vartype value: list[~azure.mgmt.alertsmanagement.models.PrometheusRuleGroupResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrometheusRuleGroupResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrometheusRuleGroupResource"]] = None, **kwargs):
        """
        :keyword value: the values for the alert rule resources.
        :paramtype value: list[~azure.mgmt.alertsmanagement.models.PrometheusRuleGroupResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PrometheusRuleGroupResourcePatch(_serialization.Model):
    """The Prometheus rule group resource for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties:
    :vartype properties:
     ~azure.mgmt.alertsmanagement.models.PrometheusRuleGroupResourcePatchProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "PrometheusRuleGroupResourcePatchProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.PrometheusRuleGroupResourcePatchProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties:
        :paramtype properties:
         ~azure.mgmt.alertsmanagement.models.PrometheusRuleGroupResourcePatchProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class PrometheusRuleGroupResourcePatchProperties(_serialization.Model):
    """PrometheusRuleGroupResourcePatchProperties.

    :ivar enabled: the flag that indicates whether the Prometheus rule group is enabled.
    :vartype enabled: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs):
        """
        :keyword enabled: the flag that indicates whether the Prometheus rule group is enabled.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class PrometheusRuleResolveConfiguration(_serialization.Model):
    """Specifies the Prometheus alert rule configuration.

    :ivar auto_resolved: the flag that indicates whether or not to auto resolve a fired alert.
    :vartype auto_resolved: bool
    :ivar time_to_resolve: the duration a rule must evaluate as healthy before the fired alert is
     automatically resolved represented in ISO 8601 duration format. Should be between 1 and 15
     minutes.
    :vartype time_to_resolve: str
    """

    _attribute_map = {
        "auto_resolved": {"key": "autoResolved", "type": "bool"},
        "time_to_resolve": {"key": "timeToResolve", "type": "str"},
    }

    def __init__(self, *, auto_resolved: Optional[bool] = None, time_to_resolve: Optional[str] = None, **kwargs):
        """
        :keyword auto_resolved: the flag that indicates whether or not to auto resolve a fired alert.
        :paramtype auto_resolved: bool
        :keyword time_to_resolve: the duration a rule must evaluate as healthy before the fired alert
         is automatically resolved represented in ISO 8601 duration format. Should be between 1 and 15
         minutes.
        :paramtype time_to_resolve: str
        """
        super().__init__(**kwargs)
        self.auto_resolved = auto_resolved
        self.time_to_resolve = time_to_resolve


class RemoveAllActionGroups(Action):
    """Indicates if all action groups should be removed.

    All required parameters must be populated in order to send to Azure.

    :ivar action_type: Action that should be applied. Required. Known values are: "AddActionGroups"
     and "RemoveAllActionGroups".
    :vartype action_type: str or ~azure.mgmt.alertsmanagement.models.ActionType
    """

    _validation = {
        "action_type": {"required": True},
    }

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.action_type: str = "RemoveAllActionGroups"


class Schedule(_serialization.Model):
    """Scheduling configuration for a given alert processing rule.

    :ivar effective_from: Scheduling effective from time. Date-Time in ISO-8601 format without
     timezone suffix.
    :vartype effective_from: str
    :ivar effective_until: Scheduling effective until time. Date-Time in ISO-8601 format without
     timezone suffix.
    :vartype effective_until: str
    :ivar time_zone: Scheduling time zone.
    :vartype time_zone: str
    :ivar recurrences: List of recurrences.
    :vartype recurrences: list[~azure.mgmt.alertsmanagement.models.Recurrence]
    """

    _validation = {
        "effective_from": {"pattern": r"^(?:(\d{4}-\d{2}-\d{2})T(\d{2}:\d{2}:\d{2}(?:\.\d+)?))$"},
        "effective_until": {"pattern": r"^(?:(\d{4}-\d{2}-\d{2})T(\d{2}:\d{2}:\d{2}(?:\.\d+)?))$"},
    }

    _attribute_map = {
        "effective_from": {"key": "effectiveFrom", "type": "str"},
        "effective_until": {"key": "effectiveUntil", "type": "str"},
        "time_zone": {"key": "timeZone", "type": "str"},
        "recurrences": {"key": "recurrences", "type": "[Recurrence]"},
    }

    def __init__(
        self,
        *,
        effective_from: Optional[str] = None,
        effective_until: Optional[str] = None,
        time_zone: Optional[str] = None,
        recurrences: Optional[List["_models.Recurrence"]] = None,
        **kwargs
    ):
        """
        :keyword effective_from: Scheduling effective from time. Date-Time in ISO-8601 format without
         timezone suffix.
        :paramtype effective_from: str
        :keyword effective_until: Scheduling effective until time. Date-Time in ISO-8601 format without
         timezone suffix.
        :paramtype effective_until: str
        :keyword time_zone: Scheduling time zone.
        :paramtype time_zone: str
        :keyword recurrences: List of recurrences.
        :paramtype recurrences: list[~azure.mgmt.alertsmanagement.models.Recurrence]
        """
        super().__init__(**kwargs)
        self.effective_from = effective_from
        self.effective_until = effective_until
        self.time_zone = time_zone
        self.recurrences = recurrences


class SmartGroup(Resource):  # pylint: disable=too-many-instance-attributes
    """Set of related alerts grouped together smartly by AMS.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar alerts_count: Total number of alerts in smart group.
    :vartype alerts_count: int
    :ivar smart_group_state: Smart group state. Known values are: "New", "Acknowledged", and
     "Closed".
    :vartype smart_group_state: str or ~azure.mgmt.alertsmanagement.models.State
    :ivar severity: Severity of smart group is the highest(Sev0 >... > Sev4) severity of all the
     alerts in the group. Known values are: "Sev0", "Sev1", "Sev2", "Sev3", and "Sev4".
    :vartype severity: str or ~azure.mgmt.alertsmanagement.models.Severity
    :ivar start_date_time: Creation time of smart group. Date-Time in ISO-8601 format.
    :vartype start_date_time: ~datetime.datetime
    :ivar last_modified_date_time: Last updated time of smart group. Date-Time in ISO-8601 format.
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar last_modified_user_name: Last modified by user name.
    :vartype last_modified_user_name: str
    :ivar resources: Summary of target resources in the smart group.
    :vartype resources: list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
    :ivar resource_types: Summary of target resource types in the smart group.
    :vartype resource_types: list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
    :ivar resource_groups: Summary of target resource groups in the smart group.
    :vartype resource_groups:
     list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
    :ivar monitor_services: Summary of monitorServices in the smart group.
    :vartype monitor_services:
     list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
    :ivar monitor_conditions: Summary of monitorConditions in the smart group.
    :vartype monitor_conditions:
     list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
    :ivar alert_states: Summary of alertStates in the smart group.
    :vartype alert_states: list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
    :ivar alert_severities: Summary of alertSeverities in the smart group.
    :vartype alert_severities:
     list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
    :ivar next_link: The URI to fetch the next page of alerts. Call ListNext() with this URI to
     fetch the next page alerts.
    :vartype next_link: str
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
        "smart_group_state": {"readonly": True},
        "severity": {"readonly": True},
        "start_date_time": {"readonly": True},
        "last_modified_date_time": {"readonly": True},
        "last_modified_user_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "alerts_count": {"key": "properties.alertsCount", "type": "int"},
        "smart_group_state": {"key": "properties.smartGroupState", "type": "str"},
        "severity": {"key": "properties.severity", "type": "str"},
        "start_date_time": {"key": "properties.startDateTime", "type": "iso-8601"},
        "last_modified_date_time": {"key": "properties.lastModifiedDateTime", "type": "iso-8601"},
        "last_modified_user_name": {"key": "properties.lastModifiedUserName", "type": "str"},
        "resources": {"key": "properties.resources", "type": "[SmartGroupAggregatedProperty]"},
        "resource_types": {"key": "properties.resourceTypes", "type": "[SmartGroupAggregatedProperty]"},
        "resource_groups": {"key": "properties.resourceGroups", "type": "[SmartGroupAggregatedProperty]"},
        "monitor_services": {"key": "properties.monitorServices", "type": "[SmartGroupAggregatedProperty]"},
        "monitor_conditions": {"key": "properties.monitorConditions", "type": "[SmartGroupAggregatedProperty]"},
        "alert_states": {"key": "properties.alertStates", "type": "[SmartGroupAggregatedProperty]"},
        "alert_severities": {"key": "properties.alertSeverities", "type": "[SmartGroupAggregatedProperty]"},
        "next_link": {"key": "properties.nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        alerts_count: Optional[int] = None,
        resources: Optional[List["_models.SmartGroupAggregatedProperty"]] = None,
        resource_types: Optional[List["_models.SmartGroupAggregatedProperty"]] = None,
        resource_groups: Optional[List["_models.SmartGroupAggregatedProperty"]] = None,
        monitor_services: Optional[List["_models.SmartGroupAggregatedProperty"]] = None,
        monitor_conditions: Optional[List["_models.SmartGroupAggregatedProperty"]] = None,
        alert_states: Optional[List["_models.SmartGroupAggregatedProperty"]] = None,
        alert_severities: Optional[List["_models.SmartGroupAggregatedProperty"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword alerts_count: Total number of alerts in smart group.
        :paramtype alerts_count: int
        :keyword resources: Summary of target resources in the smart group.
        :paramtype resources: list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
        :keyword resource_types: Summary of target resource types in the smart group.
        :paramtype resource_types:
         list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
        :keyword resource_groups: Summary of target resource groups in the smart group.
        :paramtype resource_groups:
         list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
        :keyword monitor_services: Summary of monitorServices in the smart group.
        :paramtype monitor_services:
         list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
        :keyword monitor_conditions: Summary of monitorConditions in the smart group.
        :paramtype monitor_conditions:
         list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
        :keyword alert_states: Summary of alertStates in the smart group.
        :paramtype alert_states: list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
        :keyword alert_severities: Summary of alertSeverities in the smart group.
        :paramtype alert_severities:
         list[~azure.mgmt.alertsmanagement.models.SmartGroupAggregatedProperty]
        :keyword next_link: The URI to fetch the next page of alerts. Call ListNext() with this URI to
         fetch the next page alerts.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.alerts_count = alerts_count
        self.smart_group_state = None
        self.severity = None
        self.start_date_time = None
        self.last_modified_date_time = None
        self.last_modified_user_name = None
        self.resources = resources
        self.resource_types = resource_types
        self.resource_groups = resource_groups
        self.monitor_services = monitor_services
        self.monitor_conditions = monitor_conditions
        self.alert_states = alert_states
        self.alert_severities = alert_severities
        self.next_link = next_link


class SmartGroupAggregatedProperty(_serialization.Model):
    """Aggregated property of each type.

    :ivar name: Name of the type.
    :vartype name: str
    :ivar count: Total number of items of type.
    :vartype count: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, *, name: Optional[str] = None, count: Optional[int] = None, **kwargs):
        """
        :keyword name: Name of the type.
        :paramtype name: str
        :keyword count: Total number of items of type.
        :paramtype count: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.count = count


class SmartGroupModification(Resource):
    """Alert Modification details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar properties: Properties of the smartGroup modification item.
    :vartype properties: ~azure.mgmt.alertsmanagement.models.SmartGroupModificationProperties
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "SmartGroupModificationProperties"},
    }

    def __init__(self, *, properties: Optional["_models.SmartGroupModificationProperties"] = None, **kwargs):
        """
        :keyword properties: Properties of the smartGroup modification item.
        :paramtype properties: ~azure.mgmt.alertsmanagement.models.SmartGroupModificationProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class SmartGroupModificationItem(_serialization.Model):
    """smartGroup modification item.

    :ivar modification_event: Reason for the modification. Known values are: "SmartGroupCreated",
     "StateChange", "AlertAdded", and "AlertRemoved".
    :vartype modification_event: str or
     ~azure.mgmt.alertsmanagement.models.SmartGroupModificationEvent
    :ivar old_value: Old value.
    :vartype old_value: str
    :ivar new_value: New value.
    :vartype new_value: str
    :ivar modified_at: Modified date and time.
    :vartype modified_at: str
    :ivar modified_by: Modified user details (Principal client name).
    :vartype modified_by: str
    :ivar comments: Modification comments.
    :vartype comments: str
    :ivar description: Description of the modification.
    :vartype description: str
    """

    _attribute_map = {
        "modification_event": {"key": "modificationEvent", "type": "str"},
        "old_value": {"key": "oldValue", "type": "str"},
        "new_value": {"key": "newValue", "type": "str"},
        "modified_at": {"key": "modifiedAt", "type": "str"},
        "modified_by": {"key": "modifiedBy", "type": "str"},
        "comments": {"key": "comments", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        modification_event: Optional[Union[str, "_models.SmartGroupModificationEvent"]] = None,
        old_value: Optional[str] = None,
        new_value: Optional[str] = None,
        modified_at: Optional[str] = None,
        modified_by: Optional[str] = None,
        comments: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword modification_event: Reason for the modification. Known values are:
         "SmartGroupCreated", "StateChange", "AlertAdded", and "AlertRemoved".
        :paramtype modification_event: str or
         ~azure.mgmt.alertsmanagement.models.SmartGroupModificationEvent
        :keyword old_value: Old value.
        :paramtype old_value: str
        :keyword new_value: New value.
        :paramtype new_value: str
        :keyword modified_at: Modified date and time.
        :paramtype modified_at: str
        :keyword modified_by: Modified user details (Principal client name).
        :paramtype modified_by: str
        :keyword comments: Modification comments.
        :paramtype comments: str
        :keyword description: Description of the modification.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.modification_event = modification_event
        self.old_value = old_value
        self.new_value = new_value
        self.modified_at = modified_at
        self.modified_by = modified_by
        self.comments = comments
        self.description = description


class SmartGroupModificationProperties(_serialization.Model):
    """Properties of the smartGroup modification item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar smart_group_id: Unique Id of the smartGroup for which the history is being retrieved.
    :vartype smart_group_id: str
    :ivar modifications: Modification details.
    :vartype modifications: list[~azure.mgmt.alertsmanagement.models.SmartGroupModificationItem]
    :ivar next_link: URL to fetch the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "smart_group_id": {"readonly": True},
    }

    _attribute_map = {
        "smart_group_id": {"key": "smartGroupId", "type": "str"},
        "modifications": {"key": "modifications", "type": "[SmartGroupModificationItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        modifications: Optional[List["_models.SmartGroupModificationItem"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword modifications: Modification details.
        :paramtype modifications: list[~azure.mgmt.alertsmanagement.models.SmartGroupModificationItem]
        :keyword next_link: URL to fetch the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.smart_group_id = None
        self.modifications = modifications
        self.next_link = next_link


class SmartGroupsList(_serialization.Model):
    """List the alerts.

    :ivar next_link: URL to fetch the next set of alerts.
    :vartype next_link: str
    :ivar value: List of alerts.
    :vartype value: list[~azure.mgmt.alertsmanagement.models.SmartGroup]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[SmartGroup]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.SmartGroup"]] = None, **kwargs
    ):
        """
        :keyword next_link: URL to fetch the next set of alerts.
        :paramtype next_link: str
        :keyword value: List of alerts.
        :paramtype value: list[~azure.mgmt.alertsmanagement.models.SmartGroup]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.alertsmanagement.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.alertsmanagement.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.alertsmanagement.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.alertsmanagement.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class WeeklyRecurrence(Recurrence):
    """Weekly recurrence object.

    All required parameters must be populated in order to send to Azure.

    :ivar recurrence_type: Specifies when the recurrence should be applied. Required. Known values
     are: "Daily", "Weekly", and "Monthly".
    :vartype recurrence_type: str or ~azure.mgmt.alertsmanagement.models.RecurrenceType
    :ivar start_time: Start time for recurrence.
    :vartype start_time: str
    :ivar end_time: End time for recurrence.
    :vartype end_time: str
    :ivar days_of_week: Specifies the values for weekly recurrence pattern. Required.
    :vartype days_of_week: list[str or ~azure.mgmt.alertsmanagement.models.DaysOfWeek]
    """

    _validation = {
        "recurrence_type": {"required": True},
        "days_of_week": {"required": True},
    }

    _attribute_map = {
        "recurrence_type": {"key": "recurrenceType", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "end_time": {"key": "endTime", "type": "str"},
        "days_of_week": {"key": "daysOfWeek", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        days_of_week: List[Union[str, "_models.DaysOfWeek"]],
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword start_time: Start time for recurrence.
        :paramtype start_time: str
        :keyword end_time: End time for recurrence.
        :paramtype end_time: str
        :keyword days_of_week: Specifies the values for weekly recurrence pattern. Required.
        :paramtype days_of_week: list[str or ~azure.mgmt.alertsmanagement.models.DaysOfWeek]
        """
        super().__init__(start_time=start_time, end_time=end_time, **kwargs)
        self.recurrence_type: str = "Weekly"
        self.days_of_week = days_of_week
