# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AssignmentInfo(_serialization.Model):
    """Information about the guest configuration assignment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the guest configuration assignment.
    :vartype name: str
    :ivar configuration: Information about the configuration.
    :vartype configuration: ~azure.mgmt.guestconfig.models.ConfigurationInfo
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "configuration": {"key": "configuration", "type": "ConfigurationInfo"},
    }

    def __init__(self, *, configuration: Optional["_models.ConfigurationInfo"] = None, **kwargs):
        """
        :keyword configuration: Information about the configuration.
        :paramtype configuration: ~azure.mgmt.guestconfig.models.ConfigurationInfo
        """
        super().__init__(**kwargs)
        self.name = None
        self.configuration = configuration


class AssignmentReport(_serialization.Model):
    """AssignmentReport.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: ARM resource id of the report for the guest configuration assignment.
    :vartype id: str
    :ivar report_id: GUID that identifies the guest configuration assignment report under a
     subscription, resource group.
    :vartype report_id: str
    :ivar assignment: Configuration details of the guest configuration assignment.
    :vartype assignment: ~azure.mgmt.guestconfig.models.AssignmentInfo
    :ivar vm: Information about the VM.
    :vartype vm: ~azure.mgmt.guestconfig.models.VMInfo
    :ivar start_time: Start date and time of the guest configuration assignment compliance status
     check.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End date and time of the guest configuration assignment compliance status
     check.
    :vartype end_time: ~datetime.datetime
    :ivar compliance_status: A value indicating compliance status of the machine for the assigned
     guest configuration. Known values are: "Compliant", "NonCompliant", and "Pending".
    :vartype compliance_status: str or ~azure.mgmt.guestconfig.models.ComplianceStatus
    :ivar operation_type: Type of report, Consistency or Initial. Known values are: "Consistency"
     and "Initial".
    :vartype operation_type: str or ~azure.mgmt.guestconfig.models.Type
    :ivar resources: The list of resources for which guest configuration assignment compliance is
     checked.
    :vartype resources: list[~azure.mgmt.guestconfig.models.AssignmentReportResource]
    """

    _validation = {
        "id": {"readonly": True},
        "report_id": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "compliance_status": {"readonly": True},
        "operation_type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "report_id": {"key": "reportId", "type": "str"},
        "assignment": {"key": "assignment", "type": "AssignmentInfo"},
        "vm": {"key": "vm", "type": "VMInfo"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "compliance_status": {"key": "complianceStatus", "type": "str"},
        "operation_type": {"key": "operationType", "type": "str"},
        "resources": {"key": "resources", "type": "[AssignmentReportResource]"},
    }

    def __init__(
        self,
        *,
        assignment: Optional["_models.AssignmentInfo"] = None,
        vm: Optional["_models.VMInfo"] = None,
        resources: Optional[List["_models.AssignmentReportResource"]] = None,
        **kwargs
    ):
        """
        :keyword assignment: Configuration details of the guest configuration assignment.
        :paramtype assignment: ~azure.mgmt.guestconfig.models.AssignmentInfo
        :keyword vm: Information about the VM.
        :paramtype vm: ~azure.mgmt.guestconfig.models.VMInfo
        :keyword resources: The list of resources for which guest configuration assignment compliance
         is checked.
        :paramtype resources: list[~azure.mgmt.guestconfig.models.AssignmentReportResource]
        """
        super().__init__(**kwargs)
        self.id = None
        self.report_id = None
        self.assignment = assignment
        self.vm = vm
        self.start_time = None
        self.end_time = None
        self.compliance_status = None
        self.operation_type = None
        self.resources = resources


class AssignmentReportDetails(_serialization.Model):
    """Details of the guest configuration assignment report.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar compliance_status: A value indicating compliance status of the machine for the assigned
     guest configuration. Known values are: "Compliant", "NonCompliant", and "Pending".
    :vartype compliance_status: str or ~azure.mgmt.guestconfig.models.ComplianceStatus
    :ivar start_time: Start date and time of the guest configuration assignment compliance status
     check.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End date and time of the guest configuration assignment compliance status
     check.
    :vartype end_time: ~datetime.datetime
    :ivar job_id: GUID of the report.
    :vartype job_id: str
    :ivar operation_type: Type of report, Consistency or Initial. Known values are: "Consistency"
     and "Initial".
    :vartype operation_type: str or ~azure.mgmt.guestconfig.models.Type
    :ivar resources: The list of resources for which guest configuration assignment compliance is
     checked.
    :vartype resources: list[~azure.mgmt.guestconfig.models.AssignmentReportResource]
    """

    _validation = {
        "compliance_status": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "job_id": {"readonly": True},
        "operation_type": {"readonly": True},
    }

    _attribute_map = {
        "compliance_status": {"key": "complianceStatus", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "job_id": {"key": "jobId", "type": "str"},
        "operation_type": {"key": "operationType", "type": "str"},
        "resources": {"key": "resources", "type": "[AssignmentReportResource]"},
    }

    def __init__(self, *, resources: Optional[List["_models.AssignmentReportResource"]] = None, **kwargs):
        """
        :keyword resources: The list of resources for which guest configuration assignment compliance
         is checked.
        :paramtype resources: list[~azure.mgmt.guestconfig.models.AssignmentReportResource]
        """
        super().__init__(**kwargs)
        self.compliance_status = None
        self.start_time = None
        self.end_time = None
        self.job_id = None
        self.operation_type = None
        self.resources = resources


class AssignmentReportResource(_serialization.Model):
    """The guest configuration assignment resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar compliance_status: A value indicating compliance status of the machine for the assigned
     guest configuration. Known values are: "Compliant", "NonCompliant", and "Pending".
    :vartype compliance_status: str or ~azure.mgmt.guestconfig.models.ComplianceStatus
    :ivar resource_id: Name of the guest configuration assignment resource setting.
    :vartype resource_id: str
    :ivar reasons: Compliance reason and reason code for a resource.
    :vartype reasons: list[~azure.mgmt.guestconfig.models.AssignmentReportResourceComplianceReason]
    :ivar properties: Properties of a guest configuration assignment resource.
    :vartype properties: JSON
    """

    _validation = {
        "compliance_status": {"readonly": True},
        "resource_id": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "compliance_status": {"key": "complianceStatus", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "reasons": {"key": "reasons", "type": "[AssignmentReportResourceComplianceReason]"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(self, *, reasons: Optional[List["_models.AssignmentReportResourceComplianceReason"]] = None, **kwargs):
        """
        :keyword reasons: Compliance reason and reason code for a resource.
        :paramtype reasons:
         list[~azure.mgmt.guestconfig.models.AssignmentReportResourceComplianceReason]
        """
        super().__init__(**kwargs)
        self.compliance_status = None
        self.resource_id = None
        self.reasons = reasons
        self.properties = None


class AssignmentReportResourceComplianceReason(_serialization.Model):
    """Reason and code for the compliance of the guest configuration assignment resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar phrase: Reason for the compliance of the guest configuration assignment resource.
    :vartype phrase: str
    :ivar code: Code for the compliance of the guest configuration assignment resource.
    :vartype code: str
    """

    _validation = {
        "phrase": {"readonly": True},
        "code": {"readonly": True},
    }

    _attribute_map = {
        "phrase": {"key": "phrase", "type": "str"},
        "code": {"key": "code", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.phrase = None
        self.code = None


class ConfigurationInfo(_serialization.Model):
    """Information about the configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the configuration.
    :vartype name: str
    :ivar version: Version of the configuration.
    :vartype version: str
    """

    _validation = {
        "name": {"readonly": True},
        "version": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.version = None


class ConfigurationParameter(_serialization.Model):
    """Represents a configuration parameter.

    :ivar name: Name of the configuration parameter.
    :vartype name: str
    :ivar value: Value of the configuration parameter.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs):
        """
        :keyword name: Name of the configuration parameter.
        :paramtype name: str
        :keyword value: Value of the configuration parameter.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class ConfigurationSetting(_serialization.Model):
    """Configuration setting of LCM (Local Configuration Manager).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar configuration_mode: Specifies how the LCM(Local Configuration Manager) actually applies
     the configuration to the target nodes. Possible values are ApplyOnly, ApplyAndMonitor, and
     ApplyAndAutoCorrect. Known values are: "ApplyOnly", "ApplyAndMonitor", and
     "ApplyAndAutoCorrect".
    :vartype configuration_mode: str or ~azure.mgmt.guestconfig.models.ConfigurationMode
    :ivar allow_module_overwrite: If true - new configurations downloaded from the pull service are
     allowed to overwrite the old ones on the target node. Otherwise, false.
    :vartype allow_module_overwrite: bool
    :ivar action_after_reboot: Specifies what happens after a reboot during the application of a
     configuration. The possible values are ContinueConfiguration and StopConfiguration. Known
     values are: "ContinueConfiguration" and "StopConfiguration".
    :vartype action_after_reboot: str or ~azure.mgmt.guestconfig.models.ActionAfterReboot
    :ivar refresh_frequency_mins: The time interval, in minutes, at which the LCM checks a pull
     service to get updated configurations. This value is ignored if the LCM is not configured in
     pull mode. The default value is 30.
    :vartype refresh_frequency_mins: float
    :ivar reboot_if_needed: Set this to true to automatically reboot the node after a configuration
     that requires reboot is applied. Otherwise, you will have to manually reboot the node for any
     configuration that requires it. The default value is false. To use this setting when a reboot
     condition is enacted by something other than DSC (such as Windows Installer), combine this
     setting with the xPendingReboot module.
    :vartype reboot_if_needed: bool
    :ivar configuration_mode_frequency_mins: How often, in minutes, the current configuration is
     checked and applied. This property is ignored if the ConfigurationMode property is set to
     ApplyOnly. The default value is 15.
    :vartype configuration_mode_frequency_mins: float
    """

    _validation = {
        "configuration_mode": {"readonly": True},
        "allow_module_overwrite": {"readonly": True},
        "action_after_reboot": {"readonly": True},
        "refresh_frequency_mins": {"readonly": True},
        "reboot_if_needed": {"readonly": True},
        "configuration_mode_frequency_mins": {"readonly": True},
    }

    _attribute_map = {
        "configuration_mode": {"key": "configurationMode", "type": "str"},
        "allow_module_overwrite": {"key": "allowModuleOverwrite", "type": "bool"},
        "action_after_reboot": {"key": "actionAfterReboot", "type": "str"},
        "refresh_frequency_mins": {"key": "refreshFrequencyMins", "type": "float"},
        "reboot_if_needed": {"key": "rebootIfNeeded", "type": "bool"},
        "configuration_mode_frequency_mins": {"key": "configurationModeFrequencyMins", "type": "float"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.configuration_mode = None
        self.allow_module_overwrite = None
        self.action_after_reboot = None
        self.refresh_frequency_mins = None
        self.reboot_if_needed = None
        self.configuration_mode_frequency_mins = None


class ErrorResponse(_serialization.Model):
    """Error response of an operation failure.

    :ivar error:
    :vartype error: ~azure.mgmt.guestconfig.models.ErrorResponseError
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponseError"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponseError"] = None, **kwargs):
        """
        :keyword error:
        :paramtype error: ~azure.mgmt.guestconfig.models.ErrorResponseError
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseError(_serialization.Model):
    """ErrorResponseError.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Detail error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs):
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Detail error message indicating why the operation failed.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class Resource(_serialization.Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: ARM resource id of the guest configuration assignment.
    :vartype id: str
    :ivar name: Name of the guest configuration assignment.
    :vartype name: str
    :ivar location: Region where the VM is located.
    :vartype location: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, location: Optional[str] = None, **kwargs):
        """
        :keyword name: Name of the guest configuration assignment.
        :paramtype name: str
        :keyword location: Region where the VM is located.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = name
        self.location = location
        self.type = None


class ProxyResource(Resource):
    """ARM proxy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: ARM resource id of the guest configuration assignment.
    :vartype id: str
    :ivar name: Name of the guest configuration assignment.
    :vartype name: str
    :ivar location: Region where the VM is located.
    :vartype location: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, location: Optional[str] = None, **kwargs):
        """
        :keyword name: Name of the guest configuration assignment.
        :paramtype name: str
        :keyword location: Region where the VM is located.
        :paramtype location: str
        """
        super().__init__(name=name, location=location, **kwargs)


class GuestConfigurationAssignment(ProxyResource):
    """Guest configuration assignment is an association between a machine and guest configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: ARM resource id of the guest configuration assignment.
    :vartype id: str
    :ivar name: Name of the guest configuration assignment.
    :vartype name: str
    :ivar location: Region where the VM is located.
    :vartype location: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar properties: Properties of the Guest configuration assignment.
    :vartype properties: ~azure.mgmt.guestconfig.models.GuestConfigurationAssignmentProperties
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.guestconfig.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "GuestConfigurationAssignmentProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        location: Optional[str] = None,
        properties: Optional["_models.GuestConfigurationAssignmentProperties"] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the guest configuration assignment.
        :paramtype name: str
        :keyword location: Region where the VM is located.
        :paramtype location: str
        :keyword properties: Properties of the Guest configuration assignment.
        :paramtype properties: ~azure.mgmt.guestconfig.models.GuestConfigurationAssignmentProperties
        """
        super().__init__(name=name, location=location, **kwargs)
        self.properties = properties
        self.system_data = None


class GuestConfigurationAssignmentList(_serialization.Model):
    """The response of the list guest configuration assignment operation.

    :ivar value: Result of the list guest configuration assignment operation.
    :vartype value: list[~azure.mgmt.guestconfig.models.GuestConfigurationAssignment]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GuestConfigurationAssignment]"},
    }

    def __init__(self, *, value: Optional[List["_models.GuestConfigurationAssignment"]] = None, **kwargs):
        """
        :keyword value: Result of the list guest configuration assignment operation.
        :paramtype value: list[~azure.mgmt.guestconfig.models.GuestConfigurationAssignment]
        """
        super().__init__(**kwargs)
        self.value = value


class GuestConfigurationAssignmentProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Guest configuration assignment properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_resource_id: VM resource Id.
    :vartype target_resource_id: str
    :ivar guest_configuration: The guest configuration to assign.
    :vartype guest_configuration: ~azure.mgmt.guestconfig.models.GuestConfigurationNavigation
    :ivar compliance_status: A value indicating compliance status of the machine for the assigned
     guest configuration. Known values are: "Compliant", "NonCompliant", and "Pending".
    :vartype compliance_status: str or ~azure.mgmt.guestconfig.models.ComplianceStatus
    :ivar last_compliance_status_checked: Date and time when last compliance status was checked.
    :vartype last_compliance_status_checked: ~datetime.datetime
    :ivar latest_report_id: Id of the latest report for the guest configuration assignment.
    :vartype latest_report_id: str
    :ivar parameter_hash: parameter hash for the guest configuration assignment.
    :vartype parameter_hash: str
    :ivar latest_assignment_report: Last reported guest configuration assignment report.
    :vartype latest_assignment_report: ~azure.mgmt.guestconfig.models.AssignmentReport
    :ivar context: The source which initiated the guest configuration assignment. Ex: Azure Policy.
    :vartype context: str
    :ivar assignment_hash: Combined hash of the configuration package and parameters.
    :vartype assignment_hash: str
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Succeeded", "Failed", "Canceled", and "Created".
    :vartype provisioning_state: str or ~azure.mgmt.guestconfig.models.ProvisioningState
    :ivar resource_type: Type of the resource - VMSS / VM.
    :vartype resource_type: str
    :ivar vmss_vm_list: The list of VM Compliance data for VMSS.
    :vartype vmss_vm_list: list[~azure.mgmt.guestconfig.models.VMSSVMInfo]
    """

    _validation = {
        "target_resource_id": {"readonly": True},
        "compliance_status": {"readonly": True},
        "last_compliance_status_checked": {"readonly": True},
        "latest_report_id": {"readonly": True},
        "parameter_hash": {"readonly": True},
        "assignment_hash": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "resource_type": {"readonly": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "guest_configuration": {"key": "guestConfiguration", "type": "GuestConfigurationNavigation"},
        "compliance_status": {"key": "complianceStatus", "type": "str"},
        "last_compliance_status_checked": {"key": "lastComplianceStatusChecked", "type": "iso-8601"},
        "latest_report_id": {"key": "latestReportId", "type": "str"},
        "parameter_hash": {"key": "parameterHash", "type": "str"},
        "latest_assignment_report": {"key": "latestAssignmentReport", "type": "AssignmentReport"},
        "context": {"key": "context", "type": "str"},
        "assignment_hash": {"key": "assignmentHash", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "vmss_vm_list": {"key": "vmssVMList", "type": "[VMSSVMInfo]"},
    }

    def __init__(
        self,
        *,
        guest_configuration: Optional["_models.GuestConfigurationNavigation"] = None,
        latest_assignment_report: Optional["_models.AssignmentReport"] = None,
        context: Optional[str] = None,
        vmss_vm_list: Optional[List["_models.VMSSVMInfo"]] = None,
        **kwargs
    ):
        """
        :keyword guest_configuration: The guest configuration to assign.
        :paramtype guest_configuration: ~azure.mgmt.guestconfig.models.GuestConfigurationNavigation
        :keyword latest_assignment_report: Last reported guest configuration assignment report.
        :paramtype latest_assignment_report: ~azure.mgmt.guestconfig.models.AssignmentReport
        :keyword context: The source which initiated the guest configuration assignment. Ex: Azure
         Policy.
        :paramtype context: str
        :keyword vmss_vm_list: The list of VM Compliance data for VMSS.
        :paramtype vmss_vm_list: list[~azure.mgmt.guestconfig.models.VMSSVMInfo]
        """
        super().__init__(**kwargs)
        self.target_resource_id = None
        self.guest_configuration = guest_configuration
        self.compliance_status = None
        self.last_compliance_status_checked = None
        self.latest_report_id = None
        self.parameter_hash = None
        self.latest_assignment_report = latest_assignment_report
        self.context = context
        self.assignment_hash = None
        self.provisioning_state = None
        self.resource_type = None
        self.vmss_vm_list = vmss_vm_list


class GuestConfigurationAssignmentReport(_serialization.Model):
    """Report for the guest configuration assignment. Report contains information such as compliance status, reason, and more.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: ARM resource id of the report for the guest configuration assignment.
    :vartype id: str
    :ivar name: GUID that identifies the guest configuration assignment report under a
     subscription, resource group.
    :vartype name: str
    :ivar properties: Properties of the guest configuration report.
    :vartype properties:
     ~azure.mgmt.guestconfig.models.GuestConfigurationAssignmentReportProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "GuestConfigurationAssignmentReportProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.GuestConfigurationAssignmentReportProperties"] = None, **kwargs
    ):
        """
        :keyword properties: Properties of the guest configuration report.
        :paramtype properties:
         ~azure.mgmt.guestconfig.models.GuestConfigurationAssignmentReportProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.properties = properties


class GuestConfigurationAssignmentReportList(_serialization.Model):
    """List of guest configuration assignment reports.

    :ivar value: List of reports for the guest configuration. Report contains information such as
     compliance status, reason and more.
    :vartype value: list[~azure.mgmt.guestconfig.models.GuestConfigurationAssignmentReport]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GuestConfigurationAssignmentReport]"},
    }

    def __init__(self, *, value: Optional[List["_models.GuestConfigurationAssignmentReport"]] = None, **kwargs):
        """
        :keyword value: List of reports for the guest configuration. Report contains information such
         as compliance status, reason and more.
        :paramtype value: list[~azure.mgmt.guestconfig.models.GuestConfigurationAssignmentReport]
        """
        super().__init__(**kwargs)
        self.value = value


class GuestConfigurationAssignmentReportProperties(_serialization.Model):
    """Report for the guest configuration assignment. Report contains information such as compliance status, reason, and more.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar compliance_status: A value indicating compliance status of the machine for the assigned
     guest configuration. Known values are: "Compliant", "NonCompliant", and "Pending".
    :vartype compliance_status: str or ~azure.mgmt.guestconfig.models.ComplianceStatus
    :ivar report_id: GUID that identifies the guest configuration assignment report under a
     subscription, resource group.
    :vartype report_id: str
    :ivar assignment: Configuration details of the guest configuration assignment.
    :vartype assignment: ~azure.mgmt.guestconfig.models.AssignmentInfo
    :ivar vm: Information about the VM.
    :vartype vm: ~azure.mgmt.guestconfig.models.VMInfo
    :ivar start_time: Start date and time of the guest configuration assignment compliance status
     check.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End date and time of the guest configuration assignment compliance status
     check.
    :vartype end_time: ~datetime.datetime
    :ivar details: Details of the assignment report.
    :vartype details: ~azure.mgmt.guestconfig.models.AssignmentReportDetails
    :ivar vmss_resource_id: Azure resource Id of the VMSS.
    :vartype vmss_resource_id: str
    """

    _validation = {
        "compliance_status": {"readonly": True},
        "report_id": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "vmss_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "compliance_status": {"key": "complianceStatus", "type": "str"},
        "report_id": {"key": "reportId", "type": "str"},
        "assignment": {"key": "assignment", "type": "AssignmentInfo"},
        "vm": {"key": "vm", "type": "VMInfo"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "details": {"key": "details", "type": "AssignmentReportDetails"},
        "vmss_resource_id": {"key": "vmssResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        assignment: Optional["_models.AssignmentInfo"] = None,
        vm: Optional["_models.VMInfo"] = None,
        details: Optional["_models.AssignmentReportDetails"] = None,
        **kwargs
    ):
        """
        :keyword assignment: Configuration details of the guest configuration assignment.
        :paramtype assignment: ~azure.mgmt.guestconfig.models.AssignmentInfo
        :keyword vm: Information about the VM.
        :paramtype vm: ~azure.mgmt.guestconfig.models.VMInfo
        :keyword details: Details of the assignment report.
        :paramtype details: ~azure.mgmt.guestconfig.models.AssignmentReportDetails
        """
        super().__init__(**kwargs)
        self.compliance_status = None
        self.report_id = None
        self.assignment = assignment
        self.vm = vm
        self.start_time = None
        self.end_time = None
        self.details = details
        self.vmss_resource_id = None


class GuestConfigurationNavigation(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Guest configuration is an artifact that encapsulates DSC configuration and its dependencies. The artifact is a zip file containing DSC configuration (as MOF) and dependent resources and other dependencies like modules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kind: Kind of the guest configuration. For example:DSC. "DSC"
    :vartype kind: str or ~azure.mgmt.guestconfig.models.Kind
    :ivar name: Name of the guest configuration.
    :vartype name: str
    :ivar version: Version of the guest configuration.
    :vartype version: str
    :ivar content_uri: Uri of the storage where guest configuration package is uploaded.
    :vartype content_uri: str
    :ivar content_hash: Combined hash of the guest configuration package and configuration
     parameters.
    :vartype content_hash: str
    :ivar assignment_type: Specifies the assignment type and execution of the configuration.
     Possible values are Audit, DeployAndAutoCorrect, ApplyAndAutoCorrect and ApplyAndMonitor. Known
     values are: "Audit", "DeployAndAutoCorrect", "ApplyAndAutoCorrect", and "ApplyAndMonitor".
    :vartype assignment_type: str or ~azure.mgmt.guestconfig.models.AssignmentType
    :ivar assignment_source: Specifies the origin of the configuration.
    :vartype assignment_source: str
    :ivar content_type: Specifies the content type of the configuration. Possible values could be
     Builtin or Custom.
    :vartype content_type: str
    :ivar configuration_parameter: The configuration parameters for the guest configuration.
    :vartype configuration_parameter: list[~azure.mgmt.guestconfig.models.ConfigurationParameter]
    :ivar configuration_protected_parameter: The protected configuration parameters for the guest
     configuration.
    :vartype configuration_protected_parameter:
     list[~azure.mgmt.guestconfig.models.ConfigurationParameter]
    :ivar configuration_setting: The configuration setting for the guest configuration.
    :vartype configuration_setting: ~azure.mgmt.guestconfig.models.ConfigurationSetting
    """

    _validation = {
        "assignment_source": {"readonly": True},
        "content_type": {"readonly": True},
        "configuration_setting": {"readonly": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "content_uri": {"key": "contentUri", "type": "str"},
        "content_hash": {"key": "contentHash", "type": "str"},
        "assignment_type": {"key": "assignmentType", "type": "str"},
        "assignment_source": {"key": "assignmentSource", "type": "str"},
        "content_type": {"key": "contentType", "type": "str"},
        "configuration_parameter": {"key": "configurationParameter", "type": "[ConfigurationParameter]"},
        "configuration_protected_parameter": {
            "key": "configurationProtectedParameter",
            "type": "[ConfigurationParameter]",
        },
        "configuration_setting": {"key": "configurationSetting", "type": "ConfigurationSetting"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.Kind"]] = None,
        name: Optional[str] = None,
        version: Optional[str] = None,
        content_uri: Optional[str] = None,
        content_hash: Optional[str] = None,
        assignment_type: Optional[Union[str, "_models.AssignmentType"]] = None,
        configuration_parameter: Optional[List["_models.ConfigurationParameter"]] = None,
        configuration_protected_parameter: Optional[List["_models.ConfigurationParameter"]] = None,
        **kwargs
    ):
        """
        :keyword kind: Kind of the guest configuration. For example:DSC. "DSC"
        :paramtype kind: str or ~azure.mgmt.guestconfig.models.Kind
        :keyword name: Name of the guest configuration.
        :paramtype name: str
        :keyword version: Version of the guest configuration.
        :paramtype version: str
        :keyword content_uri: Uri of the storage where guest configuration package is uploaded.
        :paramtype content_uri: str
        :keyword content_hash: Combined hash of the guest configuration package and configuration
         parameters.
        :paramtype content_hash: str
        :keyword assignment_type: Specifies the assignment type and execution of the configuration.
         Possible values are Audit, DeployAndAutoCorrect, ApplyAndAutoCorrect and ApplyAndMonitor. Known
         values are: "Audit", "DeployAndAutoCorrect", "ApplyAndAutoCorrect", and "ApplyAndMonitor".
        :paramtype assignment_type: str or ~azure.mgmt.guestconfig.models.AssignmentType
        :keyword configuration_parameter: The configuration parameters for the guest configuration.
        :paramtype configuration_parameter: list[~azure.mgmt.guestconfig.models.ConfigurationParameter]
        :keyword configuration_protected_parameter: The protected configuration parameters for the
         guest configuration.
        :paramtype configuration_protected_parameter:
         list[~azure.mgmt.guestconfig.models.ConfigurationParameter]
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.name = name
        self.version = version
        self.content_uri = content_uri
        self.content_hash = content_hash
        self.assignment_type = assignment_type
        self.assignment_source = None
        self.content_type = None
        self.configuration_parameter = configuration_parameter
        self.configuration_protected_parameter = configuration_protected_parameter
        self.configuration_setting = None


class Operation(_serialization.Model):
    """GuestConfiguration REST API operation.

    :ivar name: Operation name: For ex.
     providers/Microsoft.GuestConfiguration/guestConfigurationAssignments/write or read.
    :vartype name: str
    :ivar display: Provider, Resource, Operation and description values.
    :vartype display: ~azure.mgmt.guestconfig.models.OperationDisplay
    :ivar status_code: Service provider: Microsoft.GuestConfiguration.
    :vartype status_code: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "status_code": {"key": "properties.statusCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        status_code: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Operation name: For ex.
         providers/Microsoft.GuestConfiguration/guestConfigurationAssignments/write or read.
        :paramtype name: str
        :keyword display: Provider, Resource, Operation and description values.
        :paramtype display: ~azure.mgmt.guestconfig.models.OperationDisplay
        :keyword status_code: Service provider: Microsoft.GuestConfiguration.
        :paramtype status_code: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.status_code = status_code


class OperationDisplay(_serialization.Model):
    """Provider, Resource, Operation and description values.

    :ivar provider: Service provider: Microsoft.GuestConfiguration.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed:  For ex.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    :ivar description: Description about operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Service provider: Microsoft.GuestConfiguration.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed:  For ex.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        :keyword description: Description about operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationList(_serialization.Model):
    """The response model for the list of Automation operations.

    :ivar value: List of Automation operations supported by the Automation resource provider.
    :vartype value: list[~azure.mgmt.guestconfig.models.Operation]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, **kwargs):
        """
        :keyword value: List of Automation operations supported by the Automation resource provider.
        :paramtype value: list[~azure.mgmt.guestconfig.models.Operation]
        """
        super().__init__(**kwargs)
        self.value = value


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.guestconfig.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.guestconfig.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.guestconfig.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.guestconfig.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class VMInfo(_serialization.Model):
    """Information about the VM.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id of the VM.
    :vartype id: str
    :ivar uuid: UUID(Universally Unique Identifier) of the VM.
    :vartype uuid: str
    """

    _validation = {
        "id": {"readonly": True},
        "uuid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "uuid": {"key": "uuid", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.uuid = None


class VMSSVMInfo(_serialization.Model):
    """Information about VMSS VM.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vm_id: UUID of the VM.
    :vartype vm_id: str
    :ivar vm_resource_id: Azure resource Id of the VM.
    :vartype vm_resource_id: str
    :ivar compliance_status: A value indicating compliance status of the machine for the assigned
     guest configuration. Known values are: "Compliant", "NonCompliant", and "Pending".
    :vartype compliance_status: str or ~azure.mgmt.guestconfig.models.ComplianceStatus
    :ivar latest_report_id: Id of the latest report for the guest configuration assignment.
    :vartype latest_report_id: str
    :ivar last_compliance_checked: Date and time when last compliance status was checked.
    :vartype last_compliance_checked: ~datetime.datetime
    """

    _validation = {
        "vm_id": {"readonly": True},
        "vm_resource_id": {"readonly": True},
        "compliance_status": {"readonly": True},
        "latest_report_id": {"readonly": True},
        "last_compliance_checked": {"readonly": True},
    }

    _attribute_map = {
        "vm_id": {"key": "vmId", "type": "str"},
        "vm_resource_id": {"key": "vmResourceId", "type": "str"},
        "compliance_status": {"key": "complianceStatus", "type": "str"},
        "latest_report_id": {"key": "latestReportId", "type": "str"},
        "last_compliance_checked": {"key": "lastComplianceChecked", "type": "iso-8601"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.vm_id = None
        self.vm_resource_id = None
        self.compliance_status = None
        self.latest_report_id = None
        self.last_compliance_checked = None
