# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.oracledatabase import OracleDatabaseMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestOracleDatabaseMgmtAutonomousDatabaseBackupsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(OracleDatabaseMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_autonomous_database_backups_begin_create_or_update(self, resource_group):
        response = self.client.autonomous_database_backups.begin_create_or_update(
            resource_group_name=resource_group.name,
            autonomousdatabasename="str",
            adbbackupid="str",
            resource={
                "id": "str",
                "name": "str",
                "properties": {
                    "autonomousDatabaseOcid": "str",
                    "backupType": "str",
                    "databaseSizeInTbs": 0.0,
                    "dbVersion": "str",
                    "displayName": "str",
                    "isAutomatic": bool,
                    "isRestorable": bool,
                    "lifecycleDetails": "str",
                    "lifecycleState": "str",
                    "ocid": "str",
                    "provisioningState": "str",
                    "retentionPeriodInDays": 0,
                    "sizeInTbs": 0.0,
                    "timeAvailableTil": "2020-02-20 00:00:00",
                    "timeEnded": "str",
                    "timeStarted": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_autonomous_database_backups_get(self, resource_group):
        response = self.client.autonomous_database_backups.get(
            resource_group_name=resource_group.name,
            autonomousdatabasename="str",
            adbbackupid="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_autonomous_database_backups_begin_delete(self, resource_group):
        response = self.client.autonomous_database_backups.begin_delete(
            resource_group_name=resource_group.name,
            autonomousdatabasename="str",
            adbbackupid="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_autonomous_database_backups_begin_update(self, resource_group):
        response = self.client.autonomous_database_backups.begin_update(
            resource_group_name=resource_group.name,
            autonomousdatabasename="str",
            adbbackupid="str",
            properties={"properties": {"retentionPeriodInDays": 0}},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_autonomous_database_backups_list_by_parent(self, resource_group):
        response = self.client.autonomous_database_backups.list_by_parent(
            resource_group_name=resource_group.name,
            autonomousdatabasename="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
