# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.settings import settings
from azure.mgmt.core import AsyncARMPipelineClient
from azure.mgmt.core.policies import AsyncARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints

from .. import models as _models
from .._utils.serialization import Deserializer, Serializer
from ._configuration import PaloAltoNetworksNgfwMgmtClientConfiguration
from .operations import (
    CertificateObjectGlobalRulestackOperations,
    CertificateObjectLocalRulestackOperations,
    FirewallStatusOperations,
    FirewallsOperations,
    FqdnListGlobalRulestackOperations,
    FqdnListLocalRulestackOperations,
    GlobalRulestackOperations,
    LocalRulesOperations,
    LocalRulestacksOperations,
    MetricsObjectFirewallOperations,
    Operations,
    PaloAltoNetworksCloudngfwOperationsOperations,
    PostRulesOperations,
    PreRulesOperations,
    PrefixListGlobalRulestackOperations,
    PrefixListLocalRulestackOperations,
)

if TYPE_CHECKING:
    from azure.core import AzureClouds
    from azure.core.credentials_async import AsyncTokenCredential


class PaloAltoNetworksNgfwMgmtClient:  # pylint: disable=too-many-instance-attributes
    """PaloAltoNetworksNgfwMgmtClient.

    :ivar global_rulestack: GlobalRulestackOperations operations
    :vartype global_rulestack:
     azure.mgmt.paloaltonetworksngfw.aio.operations.GlobalRulestackOperations
    :ivar certificate_object_global_rulestack: CertificateObjectGlobalRulestackOperations
     operations
    :vartype certificate_object_global_rulestack:
     azure.mgmt.paloaltonetworksngfw.aio.operations.CertificateObjectGlobalRulestackOperations
    :ivar fqdn_list_global_rulestack: FqdnListGlobalRulestackOperations operations
    :vartype fqdn_list_global_rulestack:
     azure.mgmt.paloaltonetworksngfw.aio.operations.FqdnListGlobalRulestackOperations
    :ivar post_rules: PostRulesOperations operations
    :vartype post_rules: azure.mgmt.paloaltonetworksngfw.aio.operations.PostRulesOperations
    :ivar pre_rules: PreRulesOperations operations
    :vartype pre_rules: azure.mgmt.paloaltonetworksngfw.aio.operations.PreRulesOperations
    :ivar prefix_list_global_rulestack: PrefixListGlobalRulestackOperations operations
    :vartype prefix_list_global_rulestack:
     azure.mgmt.paloaltonetworksngfw.aio.operations.PrefixListGlobalRulestackOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.paloaltonetworksngfw.aio.operations.Operations
    :ivar palo_alto_networks_cloudngfw_operations: PaloAltoNetworksCloudngfwOperationsOperations
     operations
    :vartype palo_alto_networks_cloudngfw_operations:
     azure.mgmt.paloaltonetworksngfw.aio.operations.PaloAltoNetworksCloudngfwOperationsOperations
    :ivar firewalls: FirewallsOperations operations
    :vartype firewalls: azure.mgmt.paloaltonetworksngfw.aio.operations.FirewallsOperations
    :ivar local_rulestacks: LocalRulestacksOperations operations
    :vartype local_rulestacks:
     azure.mgmt.paloaltonetworksngfw.aio.operations.LocalRulestacksOperations
    :ivar metrics_object_firewall: MetricsObjectFirewallOperations operations
    :vartype metrics_object_firewall:
     azure.mgmt.paloaltonetworksngfw.aio.operations.MetricsObjectFirewallOperations
    :ivar firewall_status: FirewallStatusOperations operations
    :vartype firewall_status:
     azure.mgmt.paloaltonetworksngfw.aio.operations.FirewallStatusOperations
    :ivar certificate_object_local_rulestack: CertificateObjectLocalRulestackOperations operations
    :vartype certificate_object_local_rulestack:
     azure.mgmt.paloaltonetworksngfw.aio.operations.CertificateObjectLocalRulestackOperations
    :ivar fqdn_list_local_rulestack: FqdnListLocalRulestackOperations operations
    :vartype fqdn_list_local_rulestack:
     azure.mgmt.paloaltonetworksngfw.aio.operations.FqdnListLocalRulestackOperations
    :ivar local_rules: LocalRulesOperations operations
    :vartype local_rules: azure.mgmt.paloaltonetworksngfw.aio.operations.LocalRulesOperations
    :ivar prefix_list_local_rulestack: PrefixListLocalRulestackOperations operations
    :vartype prefix_list_local_rulestack:
     azure.mgmt.paloaltonetworksngfw.aio.operations.PrefixListLocalRulestackOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is None.
    :type base_url: str
    :keyword cloud_setting: The cloud setting for which to get the ARM endpoint. Default value is
     None.
    :paramtype cloud_setting: ~azure.core.AzureClouds
    :keyword api_version: Api Version. Default value is "2025-10-08". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        *,
        cloud_setting: Optional["AzureClouds"] = None,
        **kwargs: Any
    ) -> None:
        _cloud = cloud_setting or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = PaloAltoNetworksNgfwMgmtClientConfiguration(
            credential=credential,
            subscription_id=subscription_id,
            cloud_setting=cloud_setting,
            credential_scopes=credential_scopes,
            **kwargs
        )

        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                AsyncARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(
            base_url=cast(str, base_url), policies=_policies, **kwargs
        )

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.global_rulestack = GlobalRulestackOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.certificate_object_global_rulestack = CertificateObjectGlobalRulestackOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.fqdn_list_global_rulestack = FqdnListGlobalRulestackOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.post_rules = PostRulesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.pre_rules = PreRulesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.prefix_list_global_rulestack = PrefixListGlobalRulestackOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.palo_alto_networks_cloudngfw_operations = PaloAltoNetworksCloudngfwOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.firewalls = FirewallsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.local_rulestacks = LocalRulestacksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.metrics_object_firewall = MetricsObjectFirewallOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.firewall_status = FirewallStatusOperations(self._client, self._config, self._serialize, self._deserialize)
        self.certificate_object_local_rulestack = CertificateObjectLocalRulestackOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.fqdn_list_local_rulestack = FqdnListLocalRulestackOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.local_rules = LocalRulesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.prefix_list_local_rulestack = PrefixListLocalRulestackOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(
        self, request: HttpRequest, *, stream: bool = False, **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> Self:
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
