# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.workloadssapvirtualinstance import WorkloadsSapVirtualInstanceMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-workloadssapvirtualinstance
# USAGE
    python sap_virtual_instances_create_infra_disk_os_single_server_recommended.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = WorkloadsSapVirtualInstanceMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.sap_virtual_instances.begin_create(
        resource_group_name="test-rg",
        sap_virtual_instance_name="X00",
        resource={
            "location": "westcentralus",
            "properties": {
                "configuration": {
                    "appLocation": "eastus",
                    "configurationType": "DeploymentWithOSConfig",
                    "infrastructureConfiguration": {
                        "appResourceGroup": "X00-RG",
                        "databaseType": "HANA",
                        "dbDiskConfiguration": {
                            "diskVolumeConfigurations": {
                                "backup": {"count": 2, "sizeGB": 256, "sku": {"name": "StandardSSD_LRS"}},
                                "hana/data": {"count": 4, "sizeGB": 128, "sku": {"name": "Premium_LRS"}},
                                "hana/log": {"count": 3, "sizeGB": 128, "sku": {"name": "Premium_LRS"}},
                                "hana/shared": {"count": 1, "sizeGB": 256, "sku": {"name": "StandardSSD_LRS"}},
                                "os": {"count": 1, "sizeGB": 64, "sku": {"name": "StandardSSD_LRS"}},
                                "usr/sap": {"count": 1, "sizeGB": 128, "sku": {"name": "Premium_LRS"}},
                            }
                        },
                        "deploymentType": "SingleServer",
                        "networkConfiguration": {"isSecondaryIpEnabled": True},
                        "subnetId": "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
                        "virtualMachineConfiguration": {
                            "imageReference": {
                                "offer": "RHEL-SAP",
                                "publisher": "RedHat",
                                "sku": "84sapha-gen2",
                                "version": "latest",
                            },
                            "osProfile": {
                                "adminUsername": "{your-username}",
                                "osConfiguration": {
                                    "disablePasswordAuthentication": True,
                                    "osType": "Linux",
                                    "sshKeyPair": {"privateKey": "xyz", "publicKey": "abc"},
                                },
                            },
                            "vmSize": "Standard_E32ds_v4",
                        },
                    },
                    "osSapConfiguration": {"sapFqdn": "xyz.test.com"},
                },
                "environment": "NonProd",
                "sapProduct": "S4HANA",
            },
            "tags": {},
        },
    ).result()
    print(response)


# x-ms-original-file: 2024-09-01/SapVirtualInstances_CreateInfraDiskOsSingleServerRecommended.json
if __name__ == "__main__":
    main()
