import os
import unittest

from tools.stats.upload_test_stats import get_tests, summarize_test_cases

IN_CI = os.environ.get("CI")


class TestUploadTestStats(unittest.TestCase):
    @unittest.skipIf(
        IN_CI,
        "don't run in CI as this does a lot of network calls and uses up GH API rate limit",
    )
    def test_existing_job(self) -> None:
        """Run on a known-good job and make sure we don't error and get basically okay reults."""
        test_cases, _ = get_tests(2561394934, 1)
        self.assertEqual(len(test_cases), 609873)
        summary = summarize_test_cases(test_cases)
        self.assertEqual(len(summary), 5068)


if __name__ == "__main__":
    unittest.main()
