// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

#pragma once

namespace QmlProjectManager::Constants {

const char customFileSelectorsData[] = "CustomFileSelectorsData";
const char supportedLanguagesData[] = "SupportedLanguagesData";
const char primaryLanguageData[] = "PrimaryLanguageData";
const char customForceFreeTypeData[] = "CustomForceFreeType";
const char customQtForMCUs[] = "CustomQtForMCUs";
const char customQt6Project[] = "CustomQt6Project";
const char customDefaultFontFamilyMCU[] = "CustomDefaultFontFamilyMCU";

const char mainFilePath[] = "MainFilePath";
const char canonicalProjectDir[] ="CanonicalProjectDir";

const char ALWAYS_OPEN_UI_MODE[] = "J.QtQuick/QmlJSEditor.openUiQmlMode";
const char QML_RESOURCE_PATH[] = "qmldesigner/propertyEditorQmlSources/imports";
const char LANDING_PAGE_PATH[] = "qmldesigner/landingpage";

const char QML_PROJECT_ID[] = "QmlProjectManager.QmlProject";
const char QML_RUNCONFIG_ID[] = "QmlProjectManager.QmlRunConfiguration.Qml";
const char QML_VIEWER_KEY[] = "QmlProjectManager.QmlRunConfiguration.QDeclarativeViewer";
const char QML_VIEWER_ARGUMENTS_KEY[] = "QmlProjectManager.QmlRunConfiguration.QDeclarativeViewerArguments";
const char QML_VIEWER_TARGET_DISPLAY_NAME[] = "QML Viewer";
const char QML_MAINSCRIPT_KEY[] = "QmlProjectManager.QmlRunConfiguration.MainScript";
const char USE_MULTILANGUAGE_KEY[] = "QmlProjectManager.QmlRunConfiguration.UseMultiLanguage";
const char LAST_USED_LANGUAGE[] = "QmlProjectManager.QmlRunConfiguration.LastUsedLanguage";
const char USER_ENVIRONMENT_CHANGES_KEY[] = "QmlProjectManager.QmlRunConfiguration.UserEnvironmentChanges";

const char EXPORT_MENU[] = "QmlDesigner.ExportMenu";
const char G_EXPORT_GENERATE[] = "QmlDesigner.Group.GenerateProject";
const char G_EXPORT_CONVERT[] = "QmlDesigner.Group.ConvertProject";

const char fakeProjectName[] = "fake85673.qmlproject";

inline constexpr const char *QDS_FONT_FILES_FILTERS[] = {
    "*.afm", "*.bdf", "*.ccc", "*.cff", "*.fmp",  "*.fnt", "*.otc", "*.otf",  "*.pcf",   "*.pfa",
    "*.pfb", "*.pfm", "*.pfr", "*.ttc", "*.ttcf", "*.tte", "*.ttf", "*.woff", "*.woff2",
};
constexpr char FALLBACK_MCU_FONT_FAMILY[] = "DejaVu Sans";
// These constants should be kept in sync with their counterparts in qmlbase.h
constexpr char QMLPUPPET_ENV_MCU_FONTS_DIR[] = "QMLPUPPET_MCU_FONTS_DIR";
constexpr char QMLPUPPET_ENV_DEFAULT_FONT_FAMILY[] = "QMLPUPPET_DEFAULT_FONT_FAMILY";
constexpr char QMLPUPPET_ENV_PROJECT_ROOT[] = "QMLPUPPET_PROJECT_ROOT";

} // QmlProjectManager::Constants
