<!-- markdownlint-disable first-line-h1 -->
<!-- markdownlint-disable no-duplicate-header -->
### What's new in this release

#### HIP enhancements

The ROCm v5.5 release consists of the following HIP enhancements:

##### Enhanced stack size limit

In this release, the stack size limit is increased from 16k to 131056 bytes (or 128K - 16).
Applications requiring to update the stack size can use hipDeviceSetLimit API.

##### `hipcc` changes

The following hipcc changes are implemented in this release:

* `hipcc` will not implicitly link to `libpthread` and `librt`, as they are no longer a link time dependence
  for HIP programs.  Applications that depend on these libraries must explicitly link to them.
* `-use-staticlib` and `-use-sharedlib` options are deprecated.

##### Future changes

* Separation of `hipcc` binaries (Perl scripts) from HIP to `hipcc` project. Users will access separate
  `hipcc` package for installing `hipcc` binaries in future ROCm releases.

* In a future ROCm release, the following samples will be removed from the `hip-tests` project.
  * `hipBusbandWidth` at <https://github.com/ROCm/hip-tests/tree/752f3295baddeb122aa8dc18d254cb9df6fd619d/samples/1_Utils/hipBusBandwidth>
  * `hipCommander` at <https://github.com/ROCm/hip-tests/tree/752f3295baddeb122aa8dc18d254cb9df6fd619d/samples/1_Utils/hipCommander>

  Note that the samples will continue to be available in previous release branches.
* Removal of gcnarch from hipDeviceProp_t structure
* Addition of new fields in hipDeviceProp_t structure
  * maxTexture1D
  * maxTexture2D
  * maxTexture1DLayered
  * maxTexture2DLayered
  * sharedMemPerMultiprocessor
  * deviceOverlap
  * asyncEngineCount
  * surfaceAlignment
  * unifiedAddressing
  * computePreemptionSupported
  * hostRegisterSupported
  * uuid
* Removal of deprecated code
  * hip-hcc codes from hip code tree
* Correct hipArray usage in HIP APIs such as hipMemcpyAtoH and hipMemcpyHtoA
* HIPMEMCPY_3D fields correction to avoid truncation of "size_t" to "unsigned int" inside hipMemcpy3D()
* Renaming of 'memoryType' in hipPointerAttribute_t structure to 'type'
* Correct hipGetLastError to return the last error instead of last API call's return code
* Update hipExternalSemaphoreHandleDesc to add "unsigned int reserved\[16]"
* Correct handling of flag values in hipIpcOpenMemHandle for hipIpcMemLazyEnablePeerAccess
* Remove hiparray* and make it opaque with hipArray_t

##### New HIP APIs in this release

:::{note}
This is a pre-official version (beta) release of the new APIs and may contain unresolved issues.
:::

###### Memory management HIP APIs

The new memory management HIP API is as follows:

* Sets information on the specified pointer \[BETA].

  ```cpp
  hipError_t hipPointerSetAttribute(const void* value, hipPointer_attribute attribute, hipDeviceptr_t ptr);
  ```

###### Module management HIP APIs

The new module management HIP APIs are as follows:

* Launches kernel $f$ with launch parameters and shared memory on stream with arguments passed
  to `kernelParams`, where thread blocks can cooperate and synchronize as they run.

  ```cpp
  hipError_t hipModuleLaunchCooperativeKernel(hipFunction_t f, unsigned int gridDimX, unsigned int gridDimY, unsigned int gridDimZ, unsigned int blockDimX, unsigned int blockDimY, unsigned int blockDimZ, unsigned int sharedMemBytes, hipStream_t stream, void** kernelParams);
  ```

* Launches kernels on multiple devices where thread blocks can cooperate and synchronize as they
  run.

  ```cpp
  hipError_t hipModuleLaunchCooperativeKernelMultiDevice(hipFunctionLaunchParams* launchParamsList, unsigned int numDevices, unsigned int flags);
  ```

###### HIP graph management APIs

The new HIP graph management APIs are as follows:

* Creates a memory allocation node and adds it to a graph \[BETA]

  ```cpp
  hipError_t hipGraphAddMemAllocNode(hipGraphNode_t* pGraphNode, hipGraph_t graph, const hipGraphNode_t* pDependencies, size_t numDependencies, hipMemAllocNodeParams* pNodeParams);
  ```

* Return parameters for memory allocation node \[BETA]

  ```cpp
  hipError_t hipGraphMemAllocNodeGetParams(hipGraphNode_t node, hipMemAllocNodeParams* pNodeParams);
  ```

* Creates a memory free node and adds it to a graph \[BETA]

  ```cpp
  hipError_t hipGraphAddMemFreeNode(hipGraphNode_t* pGraphNode, hipGraph_t graph, const hipGraphNode_t* pDependencies, size_t numDependencies, void* dev_ptr);
  ```

* Returns parameters for memory free node \[BETA].

  ```cpp
  hipError_t hipGraphMemFreeNodeGetParams(hipGraphNode_t node, void* dev_ptr);
  ```

* Write a DOT file describing graph structure \[BETA].

  ```cpp
  hipError_t hipGraphDebugDotPrint(hipGraph_t graph, const char* path, unsigned int flags);
  ```

* Copies attributes from source node to destination node \[BETA].

  ```cpp
  hipError_t hipGraphKernelNodeCopyAttributes(hipGraphNode_t hSrc, hipGraphNode_t hDst);
  ```

* Enables or disables the specified node in the given graphExec \[BETA]

  ```cpp
  hipError_t hipGraphNodeSetEnabled(hipGraphExec_t hGraphExec, hipGraphNode_t hNode, unsigned int isEnabled);
  ```

* Query whether a node in the given graphExec is enabled \[BETA]

  ```cpp
  hipError_t hipGraphNodeGetEnabled(hipGraphExec_t hGraphExec, hipGraphNode_t hNode, unsigned int* isEnabled);
  ```

##### OpenMP enhancements

This release consists of the following OpenMP enhancements:

* Additional support for OMPT functions `get_device_time` and `get_record_type`
* Added support for min/max fast fp atomics on AMD GPUs
* Fixed the use of the abs function in C device regions

### Deprecations and warnings

#### HIP deprecation

The `hipcc` and `hipconfig` Perl scripts are deprecated. In a future release, compiled binaries will be
available as `hipcc.bin` and `hipconfig.bin` as replacements for the Perl scripts.

:::{note}
There will be a transition period where the Perl scripts and compiled binaries are available before the
scripts are removed. There will be no functional difference between the Perl scripts and their compiled
binary counterpart. No user action is required. Once these are available, users can optionally switch to
`hipcc.bin` and `hipconfig.bin`. The `hipcc`/`hipconfig` soft link will be assimilated to point from
`hipcc`/`hipconfig` to the respective compiled binaries as the default option.
:::

##### Linux file system hierarchy standard for ROCm

ROCm packages have adopted the Linux foundation file system hierarchy standard in this release to ensure ROCm components follow open source conventions for Linux-based distributions. While moving to a new file system hierarchy, ROCm ensures backward compatibility with its 5.1 version or older file system hierarchy. See below for a detailed explanation of the new file system hierarchy and backward compatibility.

##### New file system hierarchy

The following is the new file system hierarchy:4

```text
/opt/rocm-<ver>
    | --bin
      | --All externally exposed Binaries
    | --libexec
        | --<component>
            | -- Component specific private non-ISA executables (architecture independent)
    | --include
        | -- <component>
            | --<header files>
    | --lib
        | --lib<soname>.so -> lib<soname>.so.major -> lib<soname>.so.major.minor.patch
            (public libraries linked with application)
        | --<component> (component specific private library, executable data)
        | --<cmake>
            | --components
                | --<component>.config.cmake
    | --share
        | --html/<component>/*.html
        | --info/<component>/*.[pdf, md, txt]
        | --man
        | --doc
            | --<component>
                | --<licenses>
        | --<component>
            | --<misc files> (arch independent non-executable)
            | --samples

```

:::{note}
ROCm will not support backward compatibility with the v5.1(old) file system hierarchy in its next major
release.
:::

For more information, refer to <https://refspecs.linuxfoundation.org/fhs.shtml>.

##### Backward compatibility with older file systems

ROCm has moved header files and libraries to its new location as indicated in the above structure and
included symbolic-link and wrapper header files in its old location for backward compatibility.

:::{note}
ROCm will continue supporting backward compatibility until the next major release.
:::
##### Wrapper header files

Wrapper header files are placed in the old location (`/opt/rocm-xxx/<component>/include`) with a
warning message to include files from the new location (`/opt/rocm-xxx/include`) as shown in the
example below:

```cpp
// Code snippet from hip_runtime.h
#pragma message “This file is deprecated. Use file from include path /opt/rocm-ver/include/ and prefix with hip”.
#include "hip/hip_runtime.h"
```

The wrapper header files’ backward compatibility deprecation is as follows:

* `#pragma` message announcing deprecation -- ROCm v5.2 release
* `#pragma` message changed to `#warning` -- Future release
* `#warning` changed to `#error` -- Future release
* Backward compatibility wrappers removed -- Future release

##### Library files

Library files are available in the `/opt/rocm-xxx/lib` folder. For backward compatibility, the old library
location (`/opt/rocm-xxx/<component>/lib`) has a soft link to the library at the new location.

Example:

```bash
$ ls -l /opt/rocm/hip/lib/
total 4
drwxr-xr-x 4 root root 4096 May 12 10:45 cmake
lrwxrwxrwx 1 root root   24 May 10 23:32 libamdhip64.so -> ../../lib/libamdhip64.so
```

##### CMake config files

All CMake configuration files are available in the `/opt/rocm-xxx/lib/cmake/<component>` folder.
For backward compatibility, the old CMake locations (`/opt/rocm-xxx/<component>/lib/cmake`)
consist of a soft link to the new CMake config.

Example:

```bash
$ ls -l /opt/rocm/hip/lib/cmake/hip/
total 0
lrwxrwxrwx 1 root root 42 May 10 23:32 hip-config.cmake -> ../../../../lib/cmake/hip/hip-config.cmake
```

#### ROCm support for Code Object V3 deprecated

Support for Code Object v3 is deprecated and will be removed in a future release.

#### Comgr V3.0 changes

The following APIs and macros have been marked as deprecated. These are expected to be removed in
a future ROCm release and coincides with the release of Comgr v3.0.

##### API changes

* `amd_comgr_action_info_set_options()`
* `amd_comgr_action_info_get_options()`

##### Actions and data types

* `AMD_COMGR_ACTION_ADD_DEVICE_LIBRARIES`
* `AMD_COMGR_ACTION_COMPILE_SOURCE_TO_FATBIN`

For replacements, see the `AMD_COMGR_ACTION_INFO_GET`/`SET_OPTION_LIST APIs`, and the
`AMD_COMGR_ACTION_COMPILE_SOURCE_(WITH_DEVICE_LIBS)_TO_BC` macros.

#### Deprecated environment variables

The following environment variables are removed in this ROCm release:

* `GPU_MAX_COMMAND_QUEUES`
* `GPU_MAX_WORKGROUP_SIZE_2D_X`
* `GPU_MAX_WORKGROUP_SIZE_2D_Y`
* `GPU_MAX_WORKGROUP_SIZE_3D_X`
* `GPU_MAX_WORKGROUP_SIZE_3D_Y`
* `GPU_MAX_WORKGROUP_SIZE_3D_Z`
* `GPU_BLIT_ENGINE_TYPE`
* `GPU_USE_SYNC_OBJECTS`
* `AMD_OCL_SC_LIB`
* `AMD_OCL_ENABLE_MESSAGE_BOX`
* `GPU_FORCE_64BIT_PTR`
* `GPU_FORCE_OCL20_32BIT`
* `GPU_RAW_TIMESTAMP`
* `GPU_SELECT_COMPUTE_RINGS_ID`
* `GPU_USE_SINGLE_SCRATCH`
* `GPU_ENABLE_LARGE_ALLOCATION`
* `HSA_LOCAL_MEMORY_ENABLE`
* `HSA_ENABLE_COARSE_GRAIN_SVM`
* `GPU_IFH_MODE`
* `OCL_SYSMEM_REQUIREMENT`
* `OCL_CODE_CACHE_ENABLE`
* `OCL_CODE_CACHE_RESET`

### Known issues in this release

The following are the known issues in this release.

#### `DISTRIBUTED`/`TEST_DISTRIBUTED_SPAWN` fails

When user applications call `ncclCommAbort` to destruct communicators and then create new
communicators repeatedly, subsequent communicators may fail to initialize.

This issue is under investigation and will be resolved in a future release.
