/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

 // Disable symbol overrides so that we can use system headers.
#define FORBIDDEN_SYMBOL_ALLOW_ALL

// HACK to allow building with the SDL backend on MinGW
// see bug #1800764 "TOOLS: MinGW tools building broken"
#ifdef main
#undef main
#endif // main

#include "file.h"
#include "script_ranges.h"

const uint BARBOT_RANGE1[] = { 250062, 250064, 250065, 250066, 250067, 250068, 250069, 250070, 250071, 250063, 0 };
const uint BARBOT_RANGE2[] = { 250200, 250201, 250202, 250203, 250204, 250205, 250206, 250207, 0 };
const uint BARBOT_RANGE3[] = { 250160, 250161, 250162, 250163, 0 };
const uint BARBOT_RANGE4[] = { 250175, 250176, 250177, 250178, 250179, 250180, 250181, 250182, 250183, 0 };
const uint BARBOT_RANGE5[] = { 250114, 250004, 0 };
const uint BARBOT_RANGE6[] = { 250042, 250009, 250010, 250011, 251692, 251693, 251694, 0 };
const uint BARBOT_RANGE7[] = { 250012, 250111, 0 };
const uint BARBOT_RANGE8[] = { 250013, 250119, 0 };
const uint BARBOT_RANGE9[] = { 250027, 250126, 250055, 0 };
const uint BARBOT_RANGE10[] = { 250032, 250130, 0 };
const uint BARBOT_RANGE11[] = { 250038, 250134, 0 };
const uint BARBOT_RANGE12[] = { 250039, 250135, 250050, 0 };
const uint BARBOT_RANGE13[] = { 250016, 250120, 250136, 250145, 250143, 0 };
const uint BARBOT_RANGE14[] = { 250040, 250138, 250139, 0 };
const uint BARBOT_RANGE15[] = { 250037, 250133, 250617, 0 };
const uint BARBOT_RANGE16[] = { 250031, 250129, 0 };
const uint BARBOT_RANGE17[] = { 250036, 250132, 0 };
const uint BARBOT_RANGE18[] = { 250035, 250137, 0 };
const uint BARBOT_RANGE19[] = { 250021, 250123, 0 };
const uint BARBOT_RANGE20[] = { 250006, 250117, 0 };
const uint BARBOT_RANGE21[] = { 250024, 250124, 0 };
const uint BARBOT_RANGE22[] = { 250002, 250113, 0 };
const uint BARBOT_RANGE23[] = { 250152, 250153, 250079, 250194, 250149, 250151, 250150,
250208, 250209, 250157, 250195, 250076, 250156, 250074,
250075, 250080, 250192, 250109, 250159, 250110, 250148,
250053, 250155, 250197, 250072, 250077, 250001, 250154,
250196, 250198, 250199, 250158, 250073, 0 };
const uint BARBOT_RANGE24[] = { 251831, 251832, 251833, 251834, 251835, 250617, 0 };
const uint BARBOT_RANGE25[] = { 250033, 251838, 0 };
const uint BARBOT_RANGE26[] = { 250014, 251827, 251781, 250617, 0 };
const uint BARBOT_RANGE27[] = { 251855, 251856, 0 };
const uint BARBOT_RANGE28[] = { 251852, 251853, 0 };
const uint BARBOT_RANGE29[] = { 251250, 251261, 251272, 251277, 251278, 251279, 251280,
251281, 251282, 251251, 251252, 251253, 251254, 251255,
251256, 251257, 251258, 251259, 251260, 251262, 251263,
251264, 251265, 251266, 251267, 251268, 251269, 251270,
251271, 251273, 251274, 251275, 251276, 0 };
const uint BARBOT_RANGE30[] = { 251283, 251284, 251285, 251286, 0 };
const uint BARBOT_RANGE31[] = { 250527, 250530, 250531, 250532, 250533, 250534, 250535,
250536, 250537, 250528, 250529, 0 };
const uint BARBOT_RANGE32[] = { 250593, 250594, 0 };
const uint BARBOT_RANGE33[] = { 250263, 250264, 250265, 250266, 0 };
const uint BARBOT_RANGE34[] = { 250227, 250228, 250229, 250230, 0 };
const uint BARBOT_RANGE35[] = { 250239, 250240, 250241, 250242, 250243, 0 };
const uint BARBOT_RANGE36[] = { 250507, 250222, 250678, 250588, 0 };
const uint BARBOT_RANGE37[] = { 250365, 250366, 250367, 250368, 0 };
const uint BARBOT_RANGE38[] = { 250936, 250937, 250938, 0 };
const uint BARBOT_RANGE39[] = { 250610, 250611, 0 };
const uint BARBOT_RANGE40[] = { 250082, 250093, 250102, 250104, 250105, 250106, 250107,
250108, 250091, 250092, 250094, 250095, 250096, 250097,
250098, 250099, 250100, 250101, 251700, 251701, 251702,
251703, 251704, 251862, 250617, 250268, 250272, 0 };
const uint BARBOT_RANGE41[] = { 250584, 250585, 0 };
const uint BARBOT_RANGE42[] = { 250579, 251142, 0 };
const uint BARBOT_RANGE43[] = { 250577, 250578, 0 };
const uint BARBOT_RANGE44[] = { 250244, 250245, 250246, 250247, 250248, 250249, 250250,
250251, 250252, 250253, 250254, 250255, 250256, 250257,
250258, 250259, 250260, 250261, 250262, 0 };
const uint BARBOT_RANGE45[] = { 250286, 250288, 250289, 250290, 250291, 250292, 250293,
250294, 250295, 250287, 0 };
const uint BARBOT_RANGE46[] = { 250296, 250299, 250300, 250301, 250302, 250303, 250304,
250305, 250306, 250297, 250298, 0 };
const uint BARBOT_RANGE47[] = { 250307, 250309, 250310, 250311, 250312, 250313, 250314,
250315, 250316, 0 };
const uint BARBOT_RANGE48[] = { 251682, 251683, 251684, 251685, 251686, 251687, 251688,
251689, 250756, 250757, 250758, 250759, 0 };
const uint BARBOT_RANGE49[] = { 250738, 250742, 250743, 250744, 250745, 250746, 250747,
250748, 250749, 250739, 250740, 250741, 0 };
const uint BARBOT_RANGE50[] = { 250659, 250660, 250661, 250379, 0 };
const uint BARBOT_RANGE51[] = { 251761, 251762, 251763, 251764, 0 };
const uint BARBOT_RANGE52[] = { 251754, 251755, 251756, 251757, 251758, 251759, 0 };
const uint BARBOT_RANGE53[] = { 250482, 250504, 250424, 250463, 250466, 250467, 250468,
250478, 250501, 250502, 250503, 250506, 250413, 251014,
250614, 250756, 250758, 250759, 250223, 250737, 250658,
251027, 250633, 250935, 250237, 251618, 0 };
const uint BARBOT_RANGE54[] = { 250504, 250434, 250436, 250466, 250467, 250468, 250469,
250470, 250472, 250501, 250502, 250503, 250505, 250413,
251681, 250756, 250758, 250759, 250223, 251027, 250633,
250935, 250237, 251618, 250371, 0 };
const uint BARBOT_RANGE55[] = { 250952, 250953, 0 };
const uint BARBOT_RANGE56[] = { 251777, 250951, 0 };
const uint BARBOT_RANGE57[] = { 251871, 251877, 251878, 251879, 251880, 251883, 251884,
251872, 251873, 0 };
const uint BARBOT_RANGE58[] = { 250228, 250236, 250258, 250259, 250378, 250465, 250536,
251016, 251048, 251068, 0 };
const uint BARBOT_RANGE59[] = { 250141, 250378, 251048, 0 };
const uint BARBOT_RANGE60[] = { 251621, 251622, 251623, 251624, 251625, 251626, 0 };
const uint BARBOT_RANGE61[] = { 251650, 251651, 0 };
const uint BARBOT_RANGE62[] = { 251305, 251306, 251307, 251308, 0 };
const uint BARBOT_RANGE63[] = { 251836, 251890, 251891, 251892, 0 };
const uint BARBOT_RANGE64[] = { 250760, 251246, 251156, 251335, 251510, 251059, 251097,
251136, 250374, 250375, 250376, 250377, 251015, 251016,
251017, 251018, 0 };
const uint BARBOT_RANGE65[] = { 250899, 250906, 250948, 250713, 250690, 0 };
const uint BARBOT_RANGE66[] = { 250906, 250948, 250713, 250899, 250690, 0 };
const uint BARBOT_RANGE67[] = { 250949, 250713, 250711, 250152, 250153, 250690, 250906, 0 };
const uint BARBOT_RANGE68[] = { 251815, 250711, 0 };
const uint BARBOT_RANGE69[] = { 251829, 250711, 0 };
const uint BARBOT_RANGE70[] = { 251779, 250712, 0 };

#define BARBOT_RANGE_COUNT 70
const ScriptRange BARBOT_RANGES[70] = {
	{ 250062, BARBOT_RANGE1, false, false },
	{ 250200, BARBOT_RANGE2, false, false },
	{ 250160, BARBOT_RANGE3, false, false },
	{ 250175, BARBOT_RANGE4, false, false },
	{ 250004, BARBOT_RANGE5, false, false },
	{ 250042, BARBOT_RANGE6, true, false },
	{ 250012, BARBOT_RANGE7, false, false },
	{ 250013, BARBOT_RANGE8, false, false },
	{ 250027, BARBOT_RANGE9, false, false },
	{ 250032, BARBOT_RANGE10, false, false },
	{ 250038, BARBOT_RANGE11, false, false },
	{ 250039, BARBOT_RANGE12, false, false },
	{ 250016, BARBOT_RANGE13, false, false },
	{ 250040, BARBOT_RANGE14, false, false },
	{ 250037, BARBOT_RANGE15, false, false },
	{ 250031, BARBOT_RANGE16, false, false },
	{ 250036, BARBOT_RANGE17, false, false },
	{ 250035, BARBOT_RANGE18, false, false },
	{ 250021, BARBOT_RANGE19, false, false },
	{ 250006, BARBOT_RANGE20, false, false },

	{ 250024, BARBOT_RANGE21, false, false },
	{ 250002, BARBOT_RANGE22, false, false },
	{ 250210, BARBOT_RANGE23, false, false },
	{ 251831, BARBOT_RANGE24, false, false },
	{ 250033, BARBOT_RANGE25, false, false },
	{ 250014, BARBOT_RANGE26, false, false },
	{ 251855, BARBOT_RANGE27, false, false },
	{ 251852, BARBOT_RANGE28, false, false },
	{ 251250, BARBOT_RANGE29, false, false },
	{ 251283, BARBOT_RANGE30, false, false },
	{ 250527, BARBOT_RANGE31, false, false },
	{ 250593, BARBOT_RANGE32, false, false },
	{ 250263, BARBOT_RANGE33, false, false },
	{ 250227, BARBOT_RANGE34, false, false },
	{ 250239, BARBOT_RANGE35, false, false },
	{ 250507, BARBOT_RANGE36, false, false },
	{ 250365, BARBOT_RANGE37, false, false },
	{ 250936, BARBOT_RANGE38, false, false },
	{ 250610, BARBOT_RANGE39, false, false },
	{ 250082, BARBOT_RANGE40, true, false },

	{ 250584, BARBOT_RANGE41, false, false },
	{ 250579, BARBOT_RANGE42, false, false },
	{ 250577, BARBOT_RANGE43, false, false },
	{ 250244, BARBOT_RANGE44, true, false },
	{ 250286, BARBOT_RANGE45, true, false },
	{ 250296, BARBOT_RANGE46, true, false },
	{ 250307, BARBOT_RANGE47, true, false },
	{ 251682, BARBOT_RANGE48, true, false },
	{ 250738, BARBOT_RANGE49, true, false },
	{ 250659, BARBOT_RANGE50, true, false },
	{ 251761, BARBOT_RANGE51, false, false },
	{ 251754, BARBOT_RANGE52, false, false },
	{ 251896, BARBOT_RANGE53, true, false },
	{ 251897, BARBOT_RANGE54, true, false },
	{ 250952, BARBOT_RANGE55, false, false },
	{ 251777, BARBOT_RANGE56, false, false },
	{ 251871, BARBOT_RANGE57, true, false },
	{ 250140, BARBOT_RANGE58, true, false },
	{ 250141, BARBOT_RANGE59, false, false },
	{ 251621, BARBOT_RANGE60, false, false },

	{ 251650, BARBOT_RANGE61, false, false },
	{ 251305, BARBOT_RANGE62, false, false },
	{ 251836, BARBOT_RANGE63, false, false },
	{ 251018, BARBOT_RANGE64, true, false },
	{ 250899, BARBOT_RANGE65, false, false },
	{ 250899, BARBOT_RANGE66, false, false },
	{ 251899, BARBOT_RANGE67, false, false },
	{ 251815, BARBOT_RANGE68, false, false },
	{ 251829, BARBOT_RANGE69, false, false },
	{ 251779, BARBOT_RANGE70, false, false }
};

const uint BELLBOT_RANGE1[] = { 200059, 200637, 0 };
const uint BELLBOT_RANGE2[] = { 200001, 200002, 200003, 200004, 200005, 200006, 0 };
const uint BELLBOT_RANGE3[] = { 200020, 200021, 202117, 202118, 0 };
const uint BELLBOT_RANGE4[] = { 200023, 200024, 200025, 0 };
const uint BELLBOT_RANGE5[] = { 200029, 0 };
const uint BELLBOT_RANGE6[] = { 200034, 200035, 0 };
const uint BELLBOT_RANGE7[] = { 200038, 200039, 0 };
const uint BELLBOT_RANGE8[] = { 200061, 200062, 200063, 200064, 200065, 200066, 200201, 200202, 200203, 200204,
	200205, 0 };
const uint BELLBOT_RANGE9[] = { 200068, 200069, 200070, 200071, 200072, 0 };
const uint BELLBOT_RANGE10[] = { 200076, 200077, 0 };

const uint BELLBOT_RANGE11[] = { 200079, 200080, 200081, 200082, 200083, 200084, 0 };
const uint BELLBOT_RANGE12[] = { 200119, 200120, 200121, 200122, 200123, 200124, 200125, 200126, 0 };
const uint BELLBOT_RANGE13[] = { 200134, 200135, 0 };
const uint BELLBOT_RANGE14[] = { 200141, 200149, 200150, 200151, 200152, 200153, 200154, 200155, 200156, 200142,
200143, 200144, 200145, 200147, 200148, 0 };
const uint BELLBOT_RANGE15[] = { 200158, 200168, 200169, 200170, 200171, 200172, 200173, 200174, 200175, 200159,
200160, 200161, 200162, 200146, 200163, 200164, 200165, 200166, 200167, 0 };
const uint BELLBOT_RANGE16[] = {
	200177, 200182, 200183, 200184, 200185, 200186, 200187, 200188, 200189, 200191,
	200178, 200179, 200180, 200181, 0
};
const uint BELLBOT_RANGE17[] = { 200194, 200195, 200196, 200197, 200198, 200199, 0 };
const uint BELLBOT_RANGE18[] = { 200201, 200202, 200203, 200204, 200205, 200078, 0 };
const uint BELLBOT_RANGE19[] = { 200236, 200237, 200238, 200239, 200240, 0 };
const uint BELLBOT_RANGE20[] = { 200244, 200245, 200246, 200247, 200248, 0 };

const uint BELLBOT_RANGE21[] = { 200262, 200263, 200264, 200265, 200266, 200267, 200268, 200269, 200270, 200271, 0 };
const uint BELLBOT_RANGE22[] = { 200280, 200281, 200282, 0 };
const uint BELLBOT_RANGE23[] = { 200284, 200285, 200286, 200287, 200288, 200289, 0 };
const uint BELLBOT_RANGE24[] = { 200291, 200292, 202254, 0 };
const uint BELLBOT_RANGE25[] = { 200294, 200295, 200296, 200297, 200298, 200299, 200300, 200301, 200481, 200481,
200481, 0 };
const uint BELLBOT_RANGE26[] = { 200307, 200308, 200309, 0 };
const uint BELLBOT_RANGE27[] = { 200312, 200313, 0 };
const uint BELLBOT_RANGE28[] = { 200324, 200325, 200326, 200327, 200328, 0 };
const uint BELLBOT_RANGE29[] = { 200331, 200332, 200722, 200723, 0 };
const uint BELLBOT_RANGE30[] = { 200337, 200338, 200339, 200340, 200341, 200342, 200343, 200344, 200345, 200346, 0 };

const uint BELLBOT_RANGE31[] = { 200351, 200352, 200353, 200354, 200355, 200356, 200357, 200358, 0 };
const uint BELLBOT_RANGE32[] = { 200360, 200361, 0 };
const uint BELLBOT_RANGE33[] = { 200363, 200364, 0 };
const uint BELLBOT_RANGE34[] = { 200371, 200372, 200373, 0 };
const uint BELLBOT_RANGE35[] = { 200375, 200376, 0 };
const uint BELLBOT_RANGE36[] = { 200394, 200395, 200396, 0 };
const uint BELLBOT_RANGE37[] = { 200406, 200407, 0 };
const uint BELLBOT_RANGE38[] = { 200414, 200415, 0 };
const uint BELLBOT_RANGE39[] = { 200423, 200424, 0 };
const uint BELLBOT_RANGE40[] = { 200433, 200434, 200435, 0 };

const uint BELLBOT_RANGE41[] = { 200437, 200440, 200441, 200442, 200443, 200444, 200445, 200446, 200447, 200438,
200439, 0 };
const uint BELLBOT_RANGE42[] = { 200449, 200450, 200451, 200452, 200453, 200454, 0 };
const uint BELLBOT_RANGE43[] = { 200456, 200457, 200458, 0 };
const uint BELLBOT_RANGE44[] = {
	201036, 201037, 200997, 200998, 200999, 201000, 201009, 201010, 200482, 200483,
	200484, 200485, 200486, 200487, 200488, 200489, 200490, 200691, 202215, 200666,
	200665, 200375, 200788, 200687, 200985, 200986, 201011, 201021, 0
};
const uint BELLBOT_RANGE45[] = { 200497, 200498, 200499, 200500, 200501, 200502, 200503, 0 };
const uint BELLBOT_RANGE46[] = { 200508, 200509, 200510, 202219, 0 };
const uint BELLBOT_RANGE47[] = { 200517, 200518, 200519, 200520, 200521, 200522, 200523, 200524, 0 };
const uint BELLBOT_RANGE48[] = { 200529, 200530, 200531, 0 };
const uint BELLBOT_RANGE49[] = { 200540, 200541, 0 };
const uint BELLBOT_RANGE50[] = { 200558, 200559, 200560, 200561, 0 };

const uint BELLBOT_RANGE51[] = { 200563, 200564, 200565, 200566, 200567, 200568, 200569, 0 };
const uint BELLBOT_RANGE52[] = { 200572, 200573, 200574, 0 };
const uint BELLBOT_RANGE53[] = { 200584, 200586, 200587, 200588, 200589, 0 };
const uint BELLBOT_RANGE54[] = { 200591, 200592, 200593, 0 };
const uint BELLBOT_RANGE55[] = { 200602, 200603, 200604, 0 };
const uint BELLBOT_RANGE56[] = { 200606, 200607, 0 };
const uint BELLBOT_RANGE57[] = { 200619, 200620, 200621, 200622, 200623, 200624, 200625, 200626, 0 };
const uint BELLBOT_RANGE58[] = { 200636, 200637, 0 };
const uint BELLBOT_RANGE59[] = { 200672, 200671, 0 };
const uint BELLBOT_RANGE60[] = { 200679, 201977, 0 };

const uint BELLBOT_RANGE61[] = { 200687, 200688, 200689, 200690, 200691, 200692, 0 };
const uint BELLBOT_RANGE62[] = { 200699, 200700, 0 };
const uint BELLBOT_RANGE63[] = { 200705, 200706, 200707, 0 };
const uint BELLBOT_RANGE64[] = { 200711, 200712, 200713, 0 };
const uint BELLBOT_RANGE65[] = { 200717, 200718, 0 };
const uint BELLBOT_RANGE66[] = { 200724, 200725, 200726, 200727, 200728, 0 };
const uint BELLBOT_RANGE67[] = { 200734, 200735, 200736, 0 };
const uint BELLBOT_RANGE68[] = { 200749, 200750, 200751, 200752, 200753, 200481, 200481, 200481, 0 };
const uint BELLBOT_RANGE69[] = { 200758, 200759, 0 };
const uint BELLBOT_RANGE70[] = { 200774, 200775, 200776, 201820, 0 };

const uint BELLBOT_RANGE71[] = { 200778, 200779, 200780, 200781, 200481, 200481, 0 };
const uint BELLBOT_RANGE72[] = { 200783, 200784, 200785, 200786, 200787, 200481, 200481, 0 };
const uint BELLBOT_RANGE73[] = { 200800, 200801, 200802, 200803, 200804, 200805, 200806, 200807, 200808, 200809,
	200481, 200481, 0 };
const uint BELLBOT_RANGE74[] = { 200815, 200816, 200481, 0 };
const uint BELLBOT_RANGE75[] = { 200827, 200828, 200829, 200481, 0 };
const uint BELLBOT_RANGE76[] = { 200867, 200868, 200869, 200481, 0 };
const uint BELLBOT_RANGE77[] = { 200875, 200876, 0 };
const uint BELLBOT_RANGE78[] = { 200878, 200879, 200880, 200481, 0 };
const uint BELLBOT_RANGE79[] = { 200889, 200890, 200891, 200481, 0 };
const uint BELLBOT_RANGE80[] = { 200893, 200894, 200895, 200896, 200897, 200898, 200481, 0 };

const uint BELLBOT_RANGE81[] = { 200400, 200399, 0 };
const uint BELLBOT_RANGE82[] = { 200114, 200115, 0 };
const uint BELLBOT_RANGE83[] = { 200660, 200659, 0 };
const uint BELLBOT_RANGE84[] = { 200303, 200304, 0 };
const uint BELLBOT_RANGE85[] = { 200837, 200838, 0 };
const uint BELLBOT_RANGE86[] = { 200790, 200791, 0 };
const uint BELLBOT_RANGE87[] = { 200771, 200772, 0 };
const uint BELLBOT_RANGE88[] = { 200137, 200138, 0 };
const uint BELLBOT_RANGE89[] = { 200548, 200551, 200555, 200549, 200547, 200553, 200552, 200545, 200550, 200554,
200546, 200556, 0 };
const uint BELLBOT_RANGE90[] = {
	200906, 200907, 200908, 200909, 200910, 200911, 200912, 200913, 200914, 200915,
	200916, 200917, 200918, 200919, 200922, 200923, 200924, 200925, 200926, 200927,
	200928, 200929, 200930, 0
};

const uint BELLBOT_RANGE91[] = {
	200931, 200932, 200933, 200934, 200935, 200936, 200937, 200938, 200939, 200940,
	200941, 200942, 200943, 200944, 200947, 200948, 200949, 200950, 200951, 200952,
	200953, 200954, 200955, 200956, 200957, 200958, 200959, 200960, 200962, 200965,
	200966, 201028, 201029, 201030, 201033, 202051, 0
};
const uint BELLBOT_RANGE92[] = {
	200967, 200968, 200969, 200970, 200971, 200972, 200973, 200974, 200975, 200976,
	200977, 200978, 200979, 200980, 200981, 200982, 200983, 200984, 200985, 200986,
	200987, 200988, 200989, 201036, 201037, 0
};
const uint BELLBOT_RANGE93[] = { 200991, 200992, 200993, 200994, 200995, 200996, 201001, 201002, 201003, 201004,
201007, 0 };
const uint BELLBOT_RANGE94[] = { 200997, 200998, 200999, 201000, 201009, 201010, 0 };
const uint BELLBOT_RANGE95[] = { 201014, 201015, 201016, 201017, 201018, 201019, 201020, 201023, 201024, 0 };
const uint BELLBOT_RANGE96[] = { 201025, 201026, 201027, 0 };
const uint BELLBOT_RANGE97[] = { 201044, 201045, 201046, 201047, 0 };
const uint BELLBOT_RANGE98[] = { 201048, 201051, 201059, 201063, 201065, 201068, 201069, 200236, 200237, 200238,
200239, 201882, 0 };
const uint BELLBOT_RANGE99[] = { 201060, 201061, 201062, 0 };
const uint BELLBOT_RANGE100[] = { 201053, 201054, 0 };

const uint BELLBOT_RANGE101[] = { 201055, 201056, 201057, 201058, 0 };
const uint BELLBOT_RANGE102[] = { 201073, 201074, 201075, 0 };
const uint BELLBOT_RANGE103[] = { 202158, 201076, 201077, 201078, 202159, 0 };
const uint BELLBOT_RANGE104[] = { 201079, 201080, 201081, 201082, 201087, 201088, 0 };
const uint BELLBOT_RANGE105[] = { 201084, 201085, 0 };
const uint BELLBOT_RANGE106[] = { 201090, 201091, 201092, 201093, 201094, 201095, 201096, 201097, 0 };
const uint BELLBOT_RANGE107[] = { 201098, 201099, 201100, 201101, 201102, 201105, 201106, 201107, 201108, 0 };
const uint BELLBOT_RANGE108[] = {
	201111, 201112, 201113, 201114, 201115, 201116, 201117, 201118, 201119, 201120,
	201121, 201122, 201123, 201124, 201125, 201126, 201127, 201128, 201130, 201131,
	201132, 201133, 0
};
const uint BELLBOT_RANGE109[] = { 201134, 201136, 201137, 201138, 0 };
const uint BELLBOT_RANGE110[] = { 201139, 201140, 201141, 201142, 201143, 201144, 201145, 201146, 201147, 201148, 0 };

const uint BELLBOT_RANGE111[] = { 201149, 201150, 201151, 201152, 201153, 201154, 201155, 201156, 201157, 0 };
const uint BELLBOT_RANGE112[] = { 201158, 201159, 201160, 201161, 201162, 201163, 201164, 201165, 201166, 0 };
const uint BELLBOT_RANGE113[] = {
	201170, 201171, 201172, 201173, 201174, 201175, 201176, 201177, 201178, 201179,
	201180, 201181, 201182, 201183, 201184, 201185, 201186, 201187, 201188, 201189,
	201190, 201191, 201192, 201193, 201194, 201195, 201196, 201197, 201198, 201199,
	201200, 201201, 201202, 201203, 201204, 201205, 201206, 201207, 201208, 201209,
	201210, 201211, 201212, 201213, 201214, 201215, 0
};
const uint BELLBOT_RANGE114[] = { 201170, 0 };
const uint BELLBOT_RANGE115[] = { 201239, 201240, 201241, 0 };
const uint BELLBOT_RANGE116[] = { 201242, 201243, 0 };
const uint BELLBOT_RANGE117[] = { 201245, 201246, 201247, 201248, 0 };
const uint BELLBOT_RANGE118[] = { 201249, 201250, 201251, 201252, 0 };
const uint BELLBOT_RANGE119[] = { 201253, 201254, 201255, 0 };
const uint BELLBOT_RANGE120[] = { 201258, 201259, 202138, 201260, 202139, 201261, 202138, 0 };

const uint BELLBOT_RANGE121[] = { 201265, 201266, 201267, 201268, 0 };
const uint BELLBOT_RANGE122[] = { 201310, 201312, 0 };
const uint BELLBOT_RANGE123[] = { 201313, 201314, 201315, 201316, 201317, 201318, 201319, 201320, 201321, 0 };
const uint BELLBOT_RANGE124[] = { 201340, 201342, 0 };
const uint BELLBOT_RANGE125[] = { 201344, 201432, 0 };
const uint BELLBOT_RANGE126[] = { 201345, 201458, 0 };
const uint BELLBOT_RANGE127[] = { 201346, 201484, 0 };
const uint BELLBOT_RANGE128[] = { 201444, 0 };
const uint BELLBOT_RANGE129[] = { 201348, 201406, 201456, 0 };
const uint BELLBOT_RANGE130[] = { 201350, 201351, 0 };

const uint BELLBOT_RANGE131[] = { 201398, 201352, 201429, 0 };
const uint BELLBOT_RANGE132[] = { 201354, 201460, 0 };
const uint BELLBOT_RANGE133[] = { 201355, 201465, 0 };
const uint BELLBOT_RANGE134[] = { 201356, 201415, 0 };
const uint BELLBOT_RANGE135[] = { 201357, 201358, 0 };
const uint BELLBOT_RANGE136[] = { 201359, 201410, 0 };
const uint BELLBOT_RANGE137[] = { 201360, 201477, 0 };
const uint BELLBOT_RANGE138[] = { 201361, 201422, 0 };
const uint BELLBOT_RANGE139[] = { 201362, 201481, 0 };
const uint BELLBOT_RANGE140[] = { 201363, 201364, 201440, 0 };

const uint BELLBOT_RANGE141[] = { 201365, 201366, 0 };
const uint BELLBOT_RANGE142[] = { 201367, 201390, 0 };
const uint BELLBOT_RANGE143[] = { 201368, 201461, 0 };
const uint BELLBOT_RANGE144[] = { 201370, 201419, 0 };
const uint BELLBOT_RANGE145[] = { 201371, 201462, 0 };
const uint BELLBOT_RANGE146[] = { 201372, 201423, 201453, 0 };
const uint BELLBOT_RANGE147[] = { 201374, 201443, 0 };
const uint BELLBOT_RANGE148[] = { 201376, 201420, 0 };
const uint BELLBOT_RANGE149[] = { 201377, 201409, 0 };
const uint BELLBOT_RANGE150[] = { 201378, 201434, 0 };

const uint BELLBOT_RANGE151[] = { 201380, 201381, 0 };
const uint BELLBOT_RANGE152[] = { 201382, 201396, 201414, 201446, 201463, 0 };
const uint BELLBOT_RANGE153[] = { 201383, 201413, 0 };
const uint BELLBOT_RANGE154[] = { 201401, 201402, 0 };
const uint BELLBOT_RANGE155[] = { 201438, 201439, 0 };
const uint BELLBOT_RANGE156[] = { 201493, 201494, 201495, 201496, 201497, 201498, 201499, 201500, 0 };
const uint BELLBOT_RANGE157[] = { 201502, 201503, 201504, 201505, 201506, 201507, 201508, 201509, 0 };
const uint BELLBOT_RANGE158[] = { 201513, 201514, 201515, 201516, 201517, 201518, 201519, 201520, 0 };
const uint BELLBOT_RANGE159[] = { 201628, 201629, 0 };
const uint BELLBOT_RANGE160[] = { 201640, 201641, 0 };

const uint BELLBOT_RANGE161[] = { 201663, 201664, 0 };
const uint BELLBOT_RANGE162[] = { 201031, 201032, 0 };
const uint BELLBOT_RANGE163[] = { 201442, 0 };
const uint BELLBOT_RANGE164[] = { 201384, 201442, 0 };
const uint BELLBOT_RANGE165[] = {
	200451, 200452, 200056, 200057, 200228, 201686, 201687, 201688, 201025, 201028,
	201029, 201030, 201033, 201051, 201060, 201061, 201086, 201703, 201315, 201316,
	201497, 201533, 201529, 201525, 201537, 201543, 201546, 201547, 201550, 201559,
	201565, 201573, 201580, 201584, 201594, 201595, 201596, 201597, 201598, 201599,
	201602, 201601, 201605, 201607, 201620, 201625, 201639, 201684, 0 };
const uint BELLBOT_RANGE166[] = { 200083, 200084, 201335, 0 };
const uint BELLBOT_RANGE167[] = { 200951, 200952, 200953, 200956, 201029, 200660, 201003, 201060, 201066, 201111,
201115, 0 };
const uint BELLBOT_RANGE168[] = { 200109, 200110, 0 };
const uint BELLBOT_RANGE169[] = { 200864, 200865, 0 };
const uint BELLBOT_RANGE170[] = { 200090, 200091, 0 };

const uint BELLBOT_RANGE171[] = { 200675, 200676, 0 };
const uint BELLBOT_RANGE172[] = {
	201979, 201980, 201981, 201982, 201983, 200442, 200238, 200236, 201098, 201101,
	201102, 201105, 201108, 201270, 201510, 0
};
const uint BELLBOT_RANGE173[] = { 202134, 202135, 202136, 202137, 202138, 202139, 0 };
const uint BELLBOT_RANGE174[] = { 202276, 202232, 200858, 202276, 202276, 202276, 0 };
const uint BELLBOT_RANGE175[] = { 202214, 202215, 200845, 0 };
const uint BELLBOT_RANGE176[] = { 201852, 201853, 0 };
const uint BELLBOT_RANGE177[] = { 202017, 202018, 0 };
const uint BELLBOT_RANGE178[] = { 202023, 202024, 0 };
const uint BELLBOT_RANGE179[] = { 202028, 202029, 0 };
const uint BELLBOT_RANGE180[] = { 202031, 202032, 202033, 202034, 0 };

const uint BELLBOT_RANGE181[] = { 202036, 202037, 0 };
const uint BELLBOT_RANGE182[] = { 202039, 202040, 202041, 0 };
const uint BELLBOT_RANGE183[] = { 201810, 201811, 0 };
const uint BELLBOT_RANGE184[] = { 201817, 201818, 201819, 0 };
const uint BELLBOT_RANGE185[] = { 201823, 201824, 201825, 201826, 201827, 0 };
const uint BELLBOT_RANGE186[] = { 201829, 201830, 201831, 0 };
const uint BELLBOT_RANGE187[] = { 201833, 201834, 201838, 200273, 201840, 0 };
const uint BELLBOT_RANGE188[] = { 201836, 201837, 201838, 0 };
const uint BELLBOT_RANGE189[] = { 201842, 201843, 0 };
const uint BELLBOT_RANGE190[] = { 201845, 201846, 0 };

const uint BELLBOT_RANGE191[] = { 201860, 201861, 201862, 201867, 201866, 0 };
const uint BELLBOT_RANGE192[] = { 201866, 201867, 0 };
const uint BELLBOT_RANGE193[] = { 201871, 201872, 201873, 201874, 0 };
const uint BELLBOT_RANGE194[] = { 201878, 201879, 0 };
const uint BELLBOT_RANGE195[] = { 201907, 201908, 201909, 201910, 0 };
const uint BELLBOT_RANGE196[] = { 201917, 201918, 201919, 201920, 0 };
const uint BELLBOT_RANGE197[] = { 201925, 201926, 201927, 201808, 0 };
const uint BELLBOT_RANGE198[] = { 201931, 201932, 201810, 201811, 0 };
const uint BELLBOT_RANGE199[] = { 201989, 201990, 0 };
const uint BELLBOT_RANGE200[] = { 202049, 202050, 0 };

const uint BELLBOT_RANGE201[] = { 202053, 202054, 0 };
const uint BELLBOT_RANGE202[] = { 202057, 202058, 202068, 200274, 0 };
const uint BELLBOT_RANGE203[] = { 202060, 202061, 202062, 202063, 202064, 0 };
const uint BELLBOT_RANGE204[] = { 202093, 202094, 200275, 202095, 0 };
const uint BELLBOT_RANGE205[] = { 202097, 202098, 202099, 202100, 202101, 0 };
const uint BELLBOT_RANGE206[] = { 202104, 202105, 202106, 0 };
const uint BELLBOT_RANGE207[] = { 202112, 202113, 202114, 200277, 0 };
const uint BELLBOT_RANGE208[] = { 200020, 200021, 202117, 202118, 200276, 0 };
const uint BELLBOT_RANGE209[] = { 202120, 202121, 202122, 202123, 202124, 202125, 202126, 0 };
const uint BELLBOT_RANGE210[] = { 202128, 202129, 202130, 0 };

const uint BELLBOT_RANGE211[] = { 202146, 202147, 202148, 201116, 0 };
const uint BELLBOT_RANGE212[] = { 202151, 202152, 202153, 202154, 202155, 0 };
const uint BELLBOT_RANGE213[] = { 202163, 202164, 200325, 202023, 202024, 202189, 0 };
const uint BELLBOT_RANGE214[] = { 202166, 202167, 202168, 0 };
const uint BELLBOT_RANGE215[] = { 202172, 202173, 0 };
const uint BELLBOT_RANGE216[] = { 202176, 202177, 0 };
const uint BELLBOT_RANGE217[] = { 202186, 202187, 0 };
const uint BELLBOT_RANGE218[] = { 202192, 202193, 0 };
const uint BELLBOT_RANGE219[] = { 202195, 202196, 202197, 202198, 202199, 202200, 0 };
const uint BELLBOT_RANGE220[] = { 202158, 202159, 201076, 201077, 201078, 0 };

const uint BELLBOT_RANGE221[] = { 200849, 202001, 0 };
const uint BELLBOT_RANGE222[] = { 202000, 200844, 0 };
const uint BELLBOT_RANGE223[] = { 201915, 200272, 0 };
const uint BELLBOT_RANGE224[] = { 200239, 201049, 201063, 201089, 201113, 202150, 201062, 0 };
const uint BELLBOT_RANGE225[] = { 201984, 201985, 201049, 201065, 201068, 0 };
const uint BELLBOT_RANGE226[] = { 200001, 200003, 200004, 200005, 200121, 200122, 200351, 200352, 200353, 200354,
200355, 200356, 200357, 200358, 202174, 201085, 200510, 202261, 0 };
const uint BELLBOT_RANGE227[] = { 202134, 202135, 202136, 202137, 202138, 202139, 200352, 200358, 201084, 0 };
const uint BELLBOT_RANGE228[] = { 200444, 200081, 200082, 200083, 200084, 200923, 201331, 201343, 202109, 0 };
const uint BELLBOT_RANGE229[] = { 200280, 200080, 200287, 200922, 201337, 201338, 201339, 201908, 201909, 0 };
const uint BELLBOT_RANGE230[] = { 201324, 200917, 200281, 200282, 200727, 200924, 200926, 0 };

const uint BELLBOT_RANGE231[] = { 201323, 200925, 200927, 200928, 200919, 200906, 201333, 202176, 202178, 202177,
201987, 201989, 201990, 0 };
const uint BELLBOT_RANGE232[] = {
	200916, 200915, 200918, 200907, 200908, 200909, 200910, 200911, 200912, 200913,
	201325, 201326, 201327, 201328, 201329, 201330, 201332, 201334, 201335, 201336,
	201340, 201341, 201342, 201833, 201834, 0
};
const uint BELLBOT_RANGE233[] = {
	200125, 200205, 200264, 200419, 200440, 200443, 200445, 200446, 200447, 200438,
	200420, 200620, 200621, 200622, 200624, 200669, 200771, 200787, 200093, 201026,
	201047, 201088, 201271, 201086, 200664, 2006642, 0 };
const uint BELLBOT_RANGE234[] = { 200729, 0 };
const uint BELLBOT_RANGE235[] = { 200252, 200766, 201105, 201106, 201107, 201108, 0 };
const uint BELLBOT_RANGE236[] = { 202220, 200537, 0 };
const uint BELLBOT_RANGE237[] = { 202230, 202144, 0 };
const uint BELLBOT_RANGE238[] = { 202019, 202018, 202017, 201049, 201050, 200891, 201043, 201521, 0 };
const uint BELLBOT_RANGE239[] = { 200476, 202203, 0 };
const uint BELLBOT_RANGE240[] = { 200475, 201856, 0 };

#define BELLBOT_RANGE_COUNT 283
static ScriptRange BELLBOT_RANGES[283] = {
	{ 200058, BELLBOT_RANGE1, false, false },
	{ 200000, BELLBOT_RANGE2, true, false },
	{ 200019, BELLBOT_RANGE3, true, false },
	{ 200022, BELLBOT_RANGE4, true, false },
	{ 200027, BELLBOT_RANGE5, false, false },
	{ 200033, BELLBOT_RANGE6, false, false },
	{ 200037, BELLBOT_RANGE7, false, false },
	{ 200060, BELLBOT_RANGE8, true, false },
	{ 200067, BELLBOT_RANGE9, true, false },
	{ 200075, BELLBOT_RANGE10, false, false },

	{ 200078, BELLBOT_RANGE11, false, false },
	{ 200118, BELLBOT_RANGE12, false, false },
	{ 200133, BELLBOT_RANGE13, false, false },
	{ 200140, BELLBOT_RANGE14, true, false },
	{ 200157, BELLBOT_RANGE15, true, false },
	{ 200176, BELLBOT_RANGE16, true, false },
	{ 200193, BELLBOT_RANGE17, true, false },
	{ 200200, BELLBOT_RANGE18, false, false },
	{ 200235, BELLBOT_RANGE19, false, false },
	{ 200243, BELLBOT_RANGE20, false, false },

	{ 200261, BELLBOT_RANGE21, false, false },
	{ 200279, BELLBOT_RANGE22, false, false },
	{ 200283, BELLBOT_RANGE23, false, false },
	{ 200290, BELLBOT_RANGE24, true, false },
	{ 200293, BELLBOT_RANGE25, false, false },
	{ 200306, BELLBOT_RANGE26, false, false },
	{ 200311, BELLBOT_RANGE27, false, false },
	{ 200323, BELLBOT_RANGE28, false, false },
	{ 200330, BELLBOT_RANGE29, true, false },
	{ 200336, BELLBOT_RANGE30, false, false },

	{ 200350, BELLBOT_RANGE31, false, false },
	{ 200359, BELLBOT_RANGE32, false, false },
	{ 200362, BELLBOT_RANGE33, false, false },
	{ 200370, BELLBOT_RANGE34, false, false },
	{ 200374, BELLBOT_RANGE35, false, false },
	{ 200393, BELLBOT_RANGE36, false, false },
	{ 200405, BELLBOT_RANGE37, false, false },
	{ 200413, BELLBOT_RANGE38, false, false },
	{ 200422, BELLBOT_RANGE39, false, false },
	{ 200432, BELLBOT_RANGE40, true, false },

	{ 200436, BELLBOT_RANGE41, true, false },
	{ 200448, BELLBOT_RANGE42, true, false },
	{ 200455, BELLBOT_RANGE43, false, false },
	{ 200481, BELLBOT_RANGE44, true, false },
	{ 200496, BELLBOT_RANGE45, false, false },
	{ 200507, BELLBOT_RANGE46, true, false },
	{ 200516, BELLBOT_RANGE47, true, false },
	{ 200528, BELLBOT_RANGE48, true, false },
	{ 200539, BELLBOT_RANGE49, true, false },
	{ 200557, BELLBOT_RANGE50, true, false },

	{ 200562, BELLBOT_RANGE51, true, false },
	{ 200571, BELLBOT_RANGE52, true, false },
	{ 200585, BELLBOT_RANGE53, true, false },
	{ 200590, BELLBOT_RANGE54, true, false },
	{ 200601, BELLBOT_RANGE55, true, false },
	{ 200605, BELLBOT_RANGE56, true, false },
	{ 200617, BELLBOT_RANGE57, true, false },
	{ 200635, BELLBOT_RANGE58, false, false },
	{ 200670, BELLBOT_RANGE59, false, false },
	{ 200677, BELLBOT_RANGE60, true, false },

	{ 200686, BELLBOT_RANGE61, false, false },
	{ 200698, BELLBOT_RANGE62, false, false },
	{ 200704, BELLBOT_RANGE63, false, false },
	{ 200710, BELLBOT_RANGE64, true, false },
	{ 200716, BELLBOT_RANGE65, false, false },
	{ 200723, BELLBOT_RANGE66, true, false },
	{ 200733, BELLBOT_RANGE67, false, false },
	{ 200748, BELLBOT_RANGE68, true, false },
	{ 200757, BELLBOT_RANGE69, false, false },
	{ 200773, BELLBOT_RANGE70, true, false },

	{ 200777, BELLBOT_RANGE71, true, false },
	{ 200782, BELLBOT_RANGE72, true, false },
	{ 200799, BELLBOT_RANGE73, true, false },
	{ 200814, BELLBOT_RANGE74, true, false },
	{ 200826, BELLBOT_RANGE75, true, false },
	{ 200866, BELLBOT_RANGE76, true, false },
	{ 200874, BELLBOT_RANGE77, false, false },
	{ 200877, BELLBOT_RANGE78, true, false },
	{ 200888, BELLBOT_RANGE79, true, false },
	{ 200892, BELLBOT_RANGE80, true, false },

	{ 200398, BELLBOT_RANGE81, false, false },
	{ 200113, BELLBOT_RANGE82, false, false },
	{ 200658, BELLBOT_RANGE83, false, false },
	{ 200302, BELLBOT_RANGE84, false, false },
	{ 200836, BELLBOT_RANGE85, false, false },
	{ 200789, BELLBOT_RANGE86, false, false },
	{ 200770, BELLBOT_RANGE87, false, false },
	{ 200136, BELLBOT_RANGE88, false, false },
	{ 200544, BELLBOT_RANGE89, false, false },
	{ 201685, BELLBOT_RANGE90, false, false },

	{ 201686, BELLBOT_RANGE91, true, false },
	{ 201687, BELLBOT_RANGE92, true, false },
	{ 201688, BELLBOT_RANGE93, true, false },
	{ 201689, BELLBOT_RANGE94, false, false },
	{ 201690, BELLBOT_RANGE95, false, false },
	{ 201691, BELLBOT_RANGE96, false, false },
	{ 201692, BELLBOT_RANGE97, true, false },
	{ 201693, BELLBOT_RANGE98, true, false },
	{ 201694, BELLBOT_RANGE99, false, false },
	{ 201695, BELLBOT_RANGE100, true, false },

	{ 201696, BELLBOT_RANGE101, true, false },
	{ 201697, BELLBOT_RANGE102, true, false },
	{ 201698, BELLBOT_RANGE103, false, false },
	{ 201699, BELLBOT_RANGE104, true, false },
	{ 201700, BELLBOT_RANGE105, true, false },
	{ 201701, BELLBOT_RANGE106, false, false },
	{ 201702, BELLBOT_RANGE107, false, false },
	{ 201703, BELLBOT_RANGE108, true, false },
	{ 201704, BELLBOT_RANGE109, true, false },
	{ 201705, BELLBOT_RANGE110, true, false },

	{ 201706, BELLBOT_RANGE111, true, false },
	{ 201707, BELLBOT_RANGE112, true, false },
	{ 201708, BELLBOT_RANGE113, false, false },

	{ 201709, BELLBOT_RANGE114, false, false },
	{ 201710, BELLBOT_RANGE114, false, false },
	{ 201711, BELLBOT_RANGE114, false, false },
	{ 201712, BELLBOT_RANGE114, false, false },
	{ 201713, BELLBOT_RANGE114, false, false },
	{ 201714, BELLBOT_RANGE114, false, false },
	{ 201715, BELLBOT_RANGE114, false, false },
	{ 201716, BELLBOT_RANGE114, false, false },
	{ 201717, BELLBOT_RANGE114, false, false },
	{ 201718, BELLBOT_RANGE114, false, false },
	{ 201719, BELLBOT_RANGE114, false, false },
	{ 201720, BELLBOT_RANGE114, false, false },
	{ 201721, BELLBOT_RANGE114, false, false },
	{ 201722, BELLBOT_RANGE114, false, false },
	{ 201723, BELLBOT_RANGE114, false, false },
	{ 201724, BELLBOT_RANGE114, false, false },
	{ 201725, BELLBOT_RANGE114, false, false },
	{ 201726, BELLBOT_RANGE114, false, false },
	{ 201727, BELLBOT_RANGE114, false, false },
	{ 201728, BELLBOT_RANGE114, false, false },
	{ 201729, BELLBOT_RANGE114, false, false },
	{ 201730, BELLBOT_RANGE114, false, false },
	{ 201731, BELLBOT_RANGE114, false, false },
	{ 201732, BELLBOT_RANGE114, false, false },
	{ 201733, BELLBOT_RANGE114, false, false },
	{ 201735, BELLBOT_RANGE114, false, false },
	{ 201736, BELLBOT_RANGE114, false, false },
	{ 201737, BELLBOT_RANGE114, false, false },
	{ 201738, BELLBOT_RANGE114, false, false },
	{ 201739, BELLBOT_RANGE114, false, false },
	{ 201740, BELLBOT_RANGE114, false, false },
	{ 201741, BELLBOT_RANGE114, false, false },
	{ 201743, BELLBOT_RANGE114, false, false },
	{ 201744, BELLBOT_RANGE114, false, false },
	{ 201745, BELLBOT_RANGE114, false, false },
	{ 201746, BELLBOT_RANGE114, false, false },
	{ 201747, BELLBOT_RANGE114, false, false },
	{ 201748, BELLBOT_RANGE114, false, false },
	{ 201749, BELLBOT_RANGE114, false, false },
	{ 201750, BELLBOT_RANGE114, false, false },
	{ 201751, BELLBOT_RANGE114, false, false },
	{ 201752, BELLBOT_RANGE114, false, false },
	{ 201753, BELLBOT_RANGE114, false, false },
	{ 201754, BELLBOT_RANGE114, false, false },

	{ 201755, BELLBOT_RANGE115, true, false },
	{ 201756, BELLBOT_RANGE116, true, false },
	{ 201757, BELLBOT_RANGE117, true, false },
	{ 201758, BELLBOT_RANGE118, true, false },
	{ 201759, BELLBOT_RANGE119, true, false },
	{ 201760, BELLBOT_RANGE120, false, false },

	{ 201761, BELLBOT_RANGE121, true, false },
	{ 201762, BELLBOT_RANGE122, true, false },
	{ 201763, BELLBOT_RANGE123, true, false },
	{ 201764, BELLBOT_RANGE124, false, false },
	{ 201765, BELLBOT_RANGE125, false, false },
	{ 201766, BELLBOT_RANGE126, false, false },
	{ 201767, BELLBOT_RANGE127, false, false },
	{ 201768, BELLBOT_RANGE128, false, false },
	{ 201769, BELLBOT_RANGE129, false, false },
	{ 201770, BELLBOT_RANGE130, false, false },

	{ 201771, BELLBOT_RANGE131, true, false },
	{ 201772, BELLBOT_RANGE132, false, false },
	{ 201773, BELLBOT_RANGE133, false, false },
	{ 201774, BELLBOT_RANGE134, false, false },
	{ 201775, BELLBOT_RANGE135, false, false },
	{ 201776, BELLBOT_RANGE136, false, false },
	{ 201777, BELLBOT_RANGE137, false, false },
	{ 201778, BELLBOT_RANGE138, false, false },
	{ 201779, BELLBOT_RANGE139, false, false },
	{ 201780, BELLBOT_RANGE140, false, false },

	{ 201781, BELLBOT_RANGE141, false, false },
	{ 201782, BELLBOT_RANGE142, false, false },
	{ 201783, BELLBOT_RANGE143, false, false },
	{ 201784, BELLBOT_RANGE144, false, false },
	{ 201785, BELLBOT_RANGE145, false, false },
	{ 201786, BELLBOT_RANGE146, false, false },
	{ 201787, BELLBOT_RANGE147, false, false },
	{ 201788, BELLBOT_RANGE148, false, false },
	{ 201789, BELLBOT_RANGE149, false, false },
	{ 201790, BELLBOT_RANGE150, false, false },

	{ 201791, BELLBOT_RANGE151, false, false },
	{ 201792, BELLBOT_RANGE152, false, false },
	{ 201793, BELLBOT_RANGE153, false, false },
	{ 201794, BELLBOT_RANGE154, false, false },
	{ 201795, BELLBOT_RANGE155, false, false },
	{ 201796, BELLBOT_RANGE156, true, false },
	{ 201797, BELLBOT_RANGE157, false, false },
	{ 201798, BELLBOT_RANGE158, false, false },
	{ 201799, BELLBOT_RANGE159, false, false },
	{ 201800, BELLBOT_RANGE160, false, false },

	{ 201801, BELLBOT_RANGE161, false, false },
	{ 201802, BELLBOT_RANGE162, false, false },
	{ 201803, BELLBOT_RANGE163, false, false },
	{ 201804, BELLBOT_RANGE164, true, false },
	{ 201805, BELLBOT_RANGE165, true, false },
	{ 201806, BELLBOT_RANGE166, true, false },
	{ 201807, BELLBOT_RANGE167, true, false },
	{ 200108, BELLBOT_RANGE168, false, false },
	{ 200863, BELLBOT_RANGE169, false, false },
	{ 200089, BELLBOT_RANGE170, false, false },

	{ 200674, BELLBOT_RANGE171, false, false },
	{ 201978, BELLBOT_RANGE172, true, false },
	{ 202133, BELLBOT_RANGE173, true, false },
	{ 202231, BELLBOT_RANGE174, true, false },
	{ 202213, BELLBOT_RANGE175, true, false },
	{ 201851, BELLBOT_RANGE176, true, false },
	{ 202016, BELLBOT_RANGE177, false, false },
	{ 202022, BELLBOT_RANGE178, false, false },
	{ 202027, BELLBOT_RANGE179, false, false },
	{ 202030, BELLBOT_RANGE180, true, false },

	{ 202035, BELLBOT_RANGE181, false, false },
	{ 202038, BELLBOT_RANGE182, false, false },
	{ 201809, BELLBOT_RANGE183, true, false },
	{ 201816, BELLBOT_RANGE184, true, false },
	{ 201822, BELLBOT_RANGE185, false, false },
	{ 201828, BELLBOT_RANGE186, true, false },
	{ 201832, BELLBOT_RANGE187, true, false },
	{ 201835, BELLBOT_RANGE188, true, false },
	{ 201841, BELLBOT_RANGE189, true, false },
	{ 201844, BELLBOT_RANGE190, true, false },

	{ 201859, BELLBOT_RANGE191, true, false },
	{ 201865, BELLBOT_RANGE192, true, false },
	{ 201870, BELLBOT_RANGE193, false, false },
	{ 201877, BELLBOT_RANGE194, false, false },
	{ 201906, BELLBOT_RANGE195, true, false },
	{ 201916, BELLBOT_RANGE196, true, false },
	{ 201924, BELLBOT_RANGE197, true, false },
	{ 201930, BELLBOT_RANGE198, true, false },
	{ 201988, BELLBOT_RANGE199, true, false },
	{ 202048, BELLBOT_RANGE200, true, false },

	{ 202052, BELLBOT_RANGE201, true, false },
	{ 202056, BELLBOT_RANGE202, true, false },
	{ 202059, BELLBOT_RANGE203, true, false },
	{ 202092, BELLBOT_RANGE204, true, false },
	{ 202096, BELLBOT_RANGE205, false, false },
	{ 202103, BELLBOT_RANGE206, true, false },
	{ 202111, BELLBOT_RANGE207, true, false },
	{ 202116, BELLBOT_RANGE208, true, true },
	{ 202119, BELLBOT_RANGE209, true, false },
	{ 202127, BELLBOT_RANGE210, true, false },

	{ 202145, BELLBOT_RANGE211, true, false },
	{ 202150, BELLBOT_RANGE212, true, false },
	{ 202162, BELLBOT_RANGE213, true, false },
	{ 202165, BELLBOT_RANGE214, true, false },
	{ 202171, BELLBOT_RANGE215, true, false },
	{ 202175, BELLBOT_RANGE216, false, false },
	{ 202185, BELLBOT_RANGE217, false, false },
	{ 202191, BELLBOT_RANGE218, false, false },
	{ 202194, BELLBOT_RANGE219, false, false },
	{ 202157, BELLBOT_RANGE220, false, false },

	{ 202256, BELLBOT_RANGE221, true, false },
	{ 202255, BELLBOT_RANGE222, true, false },
	{ 202257, BELLBOT_RANGE223, true, false },
	{ 202258, BELLBOT_RANGE224, true, false },
	{ 202259, BELLBOT_RANGE225, true, false },
	{ 202260, BELLBOT_RANGE226, true, false },
	{ 202261, BELLBOT_RANGE227, true, false },
	{ 202262, BELLBOT_RANGE228, true, false },
	{ 202263, BELLBOT_RANGE229, true, false },
	{ 202264, BELLBOT_RANGE230, true, false },

	{ 202265, BELLBOT_RANGE231, true, false },
	{ 202266, BELLBOT_RANGE232, true, false },
	{ 202267, BELLBOT_RANGE233, true, false },
	{ 202268, BELLBOT_RANGE234, true, false },
	{ 202269, BELLBOT_RANGE235, true, false },
	{ 202270, BELLBOT_RANGE236, true, false },
	{ 202271, BELLBOT_RANGE237, true, false },
	{ 202272, BELLBOT_RANGE238, true, false },
	{ 202273, BELLBOT_RANGE239, true, false },
	{ 202274, BELLBOT_RANGE240, true, false }
};

const uint DESKBOT_RANGE1[] = { 240002, 240003, 240006, 240007, 0 };
const uint DESKBOT_RANGE2[] = { 240008, 240009, 240010, 240011, 240012, 240013, 240004, 240005, 0 };
const uint DESKBOT_RANGE3[] = { 240336, 240337, 240338, 240339, 240340, 240341, 240342, 240343, 240344, 0 };
const uint DESKBOT_RANGE4[] = { 240345, 240346, 240347, 0 };
const uint DESKBOT_RANGE5[] = { 240348, 240349, 240350, 0 };
const uint DESKBOT_RANGE6[] = { 240351, 240352, 240353, 0 };
const uint DESKBOT_RANGE7[] = { 240355, 240356, 240357, 0 };
const uint DESKBOT_RANGE8[] = { 240359, 240360, 240361, 0 };
const uint DESKBOT_RANGE9[] = { 240362, 240363, 240364, 240365, 240366, 240367, 0 };
const uint DESKBOT_RANGE10[] = { 240368, 240369, 240370, 240371, 0 };

const uint DESKBOT_RANGE11[] = { 240372, 240373, 240374, 0 };
const uint DESKBOT_RANGE12[] = { 240375, 240376, 240377, 0 };
const uint DESKBOT_RANGE13[] = { 240378, 240379, 240380, 0 };
const uint DESKBOT_RANGE14[] = { 240381, 240382, 240383, 240384, 0 };
const uint DESKBOT_RANGE15[] = { 240385, 240386, 240387, 0 };
const uint DESKBOT_RANGE16[] = { 240388, 240389, 240390, 0 };
const uint DESKBOT_RANGE17[] = { 240391, 240392, 240393, 0 };
const uint DESKBOT_RANGE18[] = { 240394, 240395, 240396, 240397, 0 };
const uint DESKBOT_RANGE19[] = { 240399, 0 };
const uint DESKBOT_RANGE20[] = { 240401, 240402, 240403, 0 };

const uint DESKBOT_RANGE21[] = { 240404, 240405, 240406, 0 };
const uint DESKBOT_RANGE22[] = { 240407, 240408, 240409, 240900, 240410, 240411, 240412, 240900, 241671, 241672,
241673, 241671, 241672, 241673, 241671, 241672, 241673, 0 };
const uint DESKBOT_RANGE23[] = { 240421, 240422, 0 };
const uint DESKBOT_RANGE24[] = { 240451, 240424, 240425, 240426, 240452, 240455, 240456, 240457, 240458, 240459, 240460, 0 };
const uint DESKBOT_RANGE25[] = { 240451, 240424, 240425, 240426, 240452, 240455, 240456, 240457, 240458, 0 };
const uint DESKBOT_RANGE26[] = { 240428, 240429, 240430, 0 };
const uint DESKBOT_RANGE27[] = { 240431, 240432, 0 };
const uint DESKBOT_RANGE28[] = { 240435, 240436, 240437, 240438, 240439, 0 };
const uint DESKBOT_RANGE29[] = { 240440, 240441, 240442, 240443, 240444, 0 };
const uint DESKBOT_RANGE30[] = { 240451, 240452, 0 };

const uint DESKBOT_RANGE31[] = { 240455, 240456, 240457, 240458, 240459, 240460, 0 };
const uint DESKBOT_RANGE32[] = { 240461, 240462, 240463, 240464, 240977, 240978, 240979, 240980, 240804, 240806,
	240807, 240808, 0 };
const uint DESKBOT_RANGE33[] = { 241742, 241743, 241744, 241745, 241746, 241747, 241748, 240954, 0 };
const uint DESKBOT_RANGE34[] = { 240480, 240481, 240482, 0 };
const uint DESKBOT_RANGE35[] = { 241117, 241515, 0 };
const uint DESKBOT_RANGE36[] = { 240486, 241585, 240487, 241585, 240488, 241585, 0 };
const uint DESKBOT_RANGE37[] = { 240490, 240491, 0 };
const uint DESKBOT_RANGE38[] = { 240496, 240507, 240518, 240529, 240540, 240542, 240543, 240544, 240545, 240497,
	240498, 240499, 240500, 240501, 240502, 240503, 240504, 240505, 240506, 240508,
	240509, 240510, 240511, 240512, 240513, 240514, 240515, 240516, 240517, 240519,
	240520, 240521, 240522, 240523, 240524, 240525, 240526, 240527, 240528, 240530,
	240531, 240532, 240533, 240534, 240535, 240536, 240537, 240538, 240539, 240541, 0 };
const uint DESKBOT_RANGE39[] = { 240587, 240588, 0 };
const uint DESKBOT_RANGE40[] = { 240589, 240590, 240591, 241652, 0 };

const uint DESKBOT_RANGE41[] = { 240592, 240593, 240594, 241653, 0 };
const uint DESKBOT_RANGE42[] = { 240595, 240596, 0 };
const uint DESKBOT_RANGE43[] = { 240597, 240598, 0 };
const uint DESKBOT_RANGE44[] = { 240602, 240613, 240622, 240623, 240624, 240627, 240603, 240606, 240609, 0 };
const uint DESKBOT_RANGE45[] = { 240629, 240630, 240354, 0 };
const uint DESKBOT_RANGE46[] = { 240635, 240636, 240637, 0 };
const uint DESKBOT_RANGE47[] = {
	240640, 240656, 240667, 240678, 240689, 240699, 240710, 240721, 240732, 240641,
	240647, 240648, 240649, 240650, 240651, 240652, 240653, 240654, 240655, 240657,
	240658, 240659, 240660, 240661, 240662, 240663, 240664, 240665, 240666, 240668,
	240669, 240670, 240671, 240672, 240673, 240674, 240675, 240676, 240677, 240679,
	240680, 240681, 240682, 240683, 240684, 240685, 240686, 240687, 240688, 240690,
	240691, 240692, 240693, 240694, 240695, 240696, 240697, 240698, 240700, 240701,
	240702, 240703, 240704, 240705, 240706, 240707, 240708, 240709, 240711, 240712,
	240713, 240714, 240715, 240716, 240717, 240718, 240719, 240720, 240722, 240723,
	240724, 240725, 240726, 240727, 240728, 240729, 240730, 240731, 240733, 240734,
	240735, 240736, 240737, 240738, 240739, 240740, 240741, 240742, 240642, 240643,
	240644, 240645, 240646, 0
};
const uint DESKBOT_RANGE48[] = { 240758, 240759, 240760, 0 };
const uint DESKBOT_RANGE49[] = { 240761, 240762, 240764, 240766, 0 };
const uint DESKBOT_RANGE50[] = { 240335, 240776, 240778, 240779, 240780, 240781, 0 };

const uint DESKBOT_RANGE51[] = { 240335, 240776, 240777, 240778, 240779, 240780, 240781, 0 };
const uint DESKBOT_RANGE52[] = { 240782, 240783, 240834, 240592, 240589, 240768, 240770, 240771, 240769, 240772,
240773, 240590, 240593, 240595, 240587, 240597, 240591, 240594, 240596, 240588,
240598, 241120, 240675, 241124, 0 };
const uint DESKBOT_RANGE53[] = { 240787, 240788, 240789, 240790, 240791, 241635, 0 };
const uint DESKBOT_RANGE54[] = { 240792, 240793, 240794, 240795, 240796, 240797, 241635, 0 };
const uint DESKBOT_RANGE55[] = { 240798, 240799, 240800, 241635, 0 };
const uint DESKBOT_RANGE56[] = { 240804, 240806, 240807, 240808, 0 };
const uint DESKBOT_RANGE57[] = { 240809, 240820, 240822, 240823, 240824, 240825, 240826, 240827, 240828, 240829,
240810, 240811, 240812, 240813, 240814, 240815, 240816, 240817, 240818, 240819,
240821, 0 };
const uint DESKBOT_RANGE58[] = { 240835, 240836, 240837, 240838, 240839, 240840, 0 };
const uint DESKBOT_RANGE59[] = { 240861, 240862, 240863, 0 };
const uint DESKBOT_RANGE60[] = { 240881, 240883, 240884, 240885, 240886, 240887, 240888, 240889, 240890, 240882, 0 };

const uint DESKBOT_RANGE61[] = { 240894, 240895, 240896, 240897, 240898, 240899, 240900, 240901, 240902, 0 };
const uint DESKBOT_RANGE62[] = { 240904, 240905, 240906, 240907, 240908, 241342, 0 };
const uint DESKBOT_RANGE63[] = { 240911, 240922, 240930, 240932, 240933, 240934, 240935, 240936, 240937, 240912,
	240913, 240914, 240915, 240916, 240917, 240918, 240919, 240920, 240921, 240923,
	240931, 240925, 240926, 240927, 240928, 240929, 0
};
const uint DESKBOT_RANGE64[] = { 240948, 240949, 240950, 240951, 0 };
const uint DESKBOT_RANGE65[] = { 240959, 240960, 240961, 240962, 0 };
const uint DESKBOT_RANGE66[] = { 240965, 240966, 0 };
const uint DESKBOT_RANGE67[] = { 240972, 240973, 240974, 0 };
const uint DESKBOT_RANGE68[] = { 240977, 240978, 240979, 240980, 0 };
const uint DESKBOT_RANGE69[] = { 240982, 240983, 240984, 240985, 0 };
const uint DESKBOT_RANGE70[] = { 240988, 240989, 240990, 240991, 0 };

const uint DESKBOT_RANGE71[] = { 240992, 240994, 240995, 240996, 240997, 240998, 241000, 241001, 0 };
const uint DESKBOT_RANGE72[] = { 241002, 241004, 241005, 241006, 241007, 241008, 241009, 241010, 241011, 241003, 0 };
const uint DESKBOT_RANGE73[] = {
	241012, 241023, 241034, 241045, 241050, 241051, 241052, 241053, 241054, 241013,
	241014, 241015, 241016, 241017, 241018, 241019, 241020, 241021, 241022, 241024,
	241025, 241026, 241027, 241028, 241029, 241030, 241031, 241032, 241033, 241035,
	241036, 241037, 241038, 241039, 241040, 241041, 241042, 241043, 241044, 241046,
	241047, 241048, 241049, 0
};
const uint DESKBOT_RANGE74[] = { 241055, 241057, 241058, 241059, 241060, 241061, 241062, 241063, 241064, 241056, 0 };
const uint DESKBOT_RANGE75[] = { 241078, 241079, 241080, 241081, 241082, 241083, 241084, 241085, 0 };
const uint DESKBOT_RANGE76[] = { 241091, 241092, 241093, 241094, 241095, 0 };
const uint DESKBOT_RANGE77[] = { 241103, 241104, 241105, 241106, 241107, 0 };
const uint DESKBOT_RANGE78[] = {
	241132, 241127, 241133, 241140, 241151, 241152, 241153, 241154, 241155, 241156,
	241157, 241128, 241129, 241130, 241131, 241136, 241137, 241138, 241139, 241141,
	241142, 241143, 241144, 241145, 241146, 241147, 241148, 241149, 241150, 0
};
const uint DESKBOT_RANGE79[] = { 240404, 241099, 0 };
const uint DESKBOT_RANGE80[] = { 241125, 241124, 241125, 241125, 240649, 240729, 241686, 241680, 241738, 0 };

const uint DESKBOT_RANGE81[] = { 241096, 241112, 240727, 241679, 241738, 0 };
const uint DESKBOT_RANGE82[] = { 240833, 240845, 241464, 241465, 241674, 241738, 0 };
const uint DESKBOT_RANGE83[] = { 240726, 241684, 241738, 0 };
const uint DESKBOT_RANGE84[] = { 240728, 240728, 240728, 240644, 240953, 240728, 240601, 240728, 241075, 240728,
240952, 240728, 240600, 241120, 241683, 241738, 241738, 241738, 0 };
const uint DESKBOT_RANGE85[] = { 240730, 241738, 0 };
const uint DESKBOT_RANGE86[] = { 240008, 240009, 240010, 240011, 240012, 240013, 240004, 240005, 0 };
const uint DESKBOT_RANGE87[] = { 240677, 240680, 240766, 241109, 240633, 240747, 240940, 241187, 241120, 240665,
240669, 240620, 0 };
const uint DESKBOT_RANGE88[] = {
	240948, 240602, 240613, 240622, 240624, 240625, 240626, 240627, 240603, 240605,
	240607, 240609, 240610, 241150, 240925, 240882, 240864, 241072, 240942, 240867,
	241096, 240971, 240785, 240868, 240833, 240955, 241077, 240877, 240754, 241163,
	241071, 241161, 240871, 241114, 240963, 240956, 240750, 240958, 240851, 240866,
	241100, 240941, 241115, 241088, 240628, 240846, 240857, 241164, 241165, 240954,
	241087, 240869, 240784, 240637, 240700, 240701, 240704, 240929, 240716, 240717,
	240720, 240689, 240732, 240648, 240653, 240664, 240676, 0
};
const uint DESKBOT_RANGE89[] = { 241012, 0 };
const uint DESKBOT_RANGE90[] = { 240775, 240419, 240701, 240642, 240802, 240891, 241110, 241568, 241569, 241570, 241571, 0 };

const uint DESKBOT_RANGE91[] = { 241338, 240831, 0 };
const uint DESKBOT_RANGE92[] = { 240416, 241343, 0 };
const uint DESKBOT_RANGE93[] = { 241577, 241578, 241579, 241580, 241581, 241582, 0 };
const uint DESKBOT_RANGE94[] = { 241383, 241586, 0 };
const uint DESKBOT_RANGE95[] = { 241446, 241447, 241448, 0 };
const uint DESKBOT_RANGE96[] = { 241443, 241444, 241445, 0 };
const uint DESKBOT_RANGE97[] = { 241116, 241365, 0 };
const uint DESKBOT_RANGE98[] = {
	241522, 241523, 241524, 241525, 241526, 241527, 241528, 241529, 241530, 241531,
	241532, 241533, 241534, 241535, 241536, 241537, 241538, 241539, 241540, 241541,
	241542, 241543, 241544, 241545, 241546, 241547, 241548, 241549, 241550, 241551,
	241552, 241553, 241554, 0
};
const uint DESKBOT_RANGE99[] = { 241341, 241634, 0 };
const uint DESKBOT_RANGE100[] = { 241449, 241635, 241450, 241635, 0 };

const uint DESKBOT_RANGE101[] = { 241638, 241639, 241640, 241654, 241655, 241643, 0 };
const uint DESKBOT_RANGE102[] = { 241702, 241703, 241704, 0 };
const uint DESKBOT_RANGE103[] = { 240465, 241641, 0 };
const uint DESKBOT_RANGE104[] = { 241371, 241111, 0 };

#define DESKBOT_RANGE_COUNT 146
const ScriptRange DESKBOT_RANGES[146] = {
	{ 240546, DESKBOT_RANGE1, false, false },
	{ 240547, DESKBOT_RANGE2, false, false },
	{ 240548, DESKBOT_RANGE3, false, false },
	{ 240549, DESKBOT_RANGE4, false, false },
	{ 240550, DESKBOT_RANGE5, false, false },
	{ 240551, DESKBOT_RANGE6, false, false },
	{ 240552, DESKBOT_RANGE7, false, false },
	{ 240553, DESKBOT_RANGE8, false, false },
	{ 240554, DESKBOT_RANGE9, false, false },
	{ 240555, DESKBOT_RANGE10, false, false },

	{ 240556, DESKBOT_RANGE11, false, false },
	{ 240557, DESKBOT_RANGE12, false, false },
	{ 240558, DESKBOT_RANGE13, false, false },
	{ 240559, DESKBOT_RANGE14, false, false },
	{ 240560, DESKBOT_RANGE15, false, false },
	{ 240561, DESKBOT_RANGE16, false, false },
	{ 240562, DESKBOT_RANGE17, false, false },
	{ 240563, DESKBOT_RANGE18, false, false },
	{ 240564, DESKBOT_RANGE19, false, false },
	{ 240565, DESKBOT_RANGE20, false, false },

	{ 240566, DESKBOT_RANGE21, false, false },
	{ 240567, DESKBOT_RANGE22, true, false },
	{ 240568, DESKBOT_RANGE23, false, false },
	{ 240569, DESKBOT_RANGE24, false, false },
	{ 240570, DESKBOT_RANGE25, false, false },
	{ 240571, DESKBOT_RANGE26, false, false },
	{ 240572, DESKBOT_RANGE27, false, false },
	{ 240573, DESKBOT_RANGE28, true, false },
	{ 240574, DESKBOT_RANGE29, false, false },
	{ 240575, DESKBOT_RANGE30, false, false },

	{ 240576, DESKBOT_RANGE31, false, false },
	{ 240577, DESKBOT_RANGE32, true, false },
	{ 240578, DESKBOT_RANGE33, true, false },
	{ 240579, DESKBOT_RANGE34, false, false },
	{ 240580, DESKBOT_RANGE35, true, false },
	{ 240581, DESKBOT_RANGE36, false, false },
	{ 240582, DESKBOT_RANGE37, false, false },
	{ 240583, DESKBOT_RANGE38, false, false },
	{ 241167, DESKBOT_RANGE39, false, false },
	{ 241168, DESKBOT_RANGE40, true, false },

	{ 241169, DESKBOT_RANGE41, true, false },
	{ 241170, DESKBOT_RANGE42, false, false },
	{ 241171, DESKBOT_RANGE43, false, false },
	{ 241172, DESKBOT_RANGE44, false, false },
	{ 241173, DESKBOT_RANGE45, false, false },
	{ 241174, DESKBOT_RANGE46, false, false },
	{ 241175, DESKBOT_RANGE47, false, false },
	{ 241176, DESKBOT_RANGE48, false, false },
	{ 241177, DESKBOT_RANGE49, false, false },
	{ 241178, DESKBOT_RANGE50, true, false },

	{ 241179, DESKBOT_RANGE51, true, false },
	{ 241180, DESKBOT_RANGE52, true, false },
	{ 241181, DESKBOT_RANGE53, true, false },
	{ 241182, DESKBOT_RANGE54, true, false },
	{ 241183, DESKBOT_RANGE55, true, false },
	{ 241184, DESKBOT_RANGE56, true, false },
	{ 241185, DESKBOT_RANGE57, false, false },
	{ 241186, DESKBOT_RANGE58, false, false },
	{ 241187, DESKBOT_RANGE59, false, false },
	{ 241188, DESKBOT_RANGE60, true, false },

	{ 241189, DESKBOT_RANGE61, false, false },
	{ 241190, DESKBOT_RANGE62, true, false },
	{ 241191, DESKBOT_RANGE63, true, false },
	{ 241192, DESKBOT_RANGE64, false, false },
	{ 241193, DESKBOT_RANGE65, false, false },
	{ 241194, DESKBOT_RANGE66, false, false },
	{ 241195, DESKBOT_RANGE67, false, false },
	{ 241196, DESKBOT_RANGE68, false, false },
	{ 241197, DESKBOT_RANGE69, true, false },
	{ 241198, DESKBOT_RANGE70, true, false },

	{ 241199, DESKBOT_RANGE71, false, false },
	{ 241200, DESKBOT_RANGE72, false, false },
	{ 241201, DESKBOT_RANGE73, false, false },
	{ 241202, DESKBOT_RANGE74, false, false },
	{ 241203, DESKBOT_RANGE75, false, false },
	{ 241204, DESKBOT_RANGE76, false, false },
	{ 241205, DESKBOT_RANGE77, false, false },
	{ 241166, DESKBOT_RANGE78, false, false },
	{ 241206, DESKBOT_RANGE79, false, false },
	{ 241207, DESKBOT_RANGE80, true, false },

	{ 241208, DESKBOT_RANGE81, true, false },
	{ 241209, DESKBOT_RANGE82, true, false },
	{ 241210, DESKBOT_RANGE83, true, false },
	{ 241211, DESKBOT_RANGE84, true, false },
	{ 241212, DESKBOT_RANGE85, true, false },
	{ 241213, DESKBOT_RANGE86, true, false },
	{ 241214, DESKBOT_RANGE87, true, false },
	{ 241215, DESKBOT_RANGE88, true, false },

	{ 241217, DESKBOT_RANGE89, false, false },
	{ 241218, DESKBOT_RANGE89, false, false },
	{ 241219, DESKBOT_RANGE89, false, false },
	{ 241220, DESKBOT_RANGE89, false, false },
	{ 241221, DESKBOT_RANGE89, false, false },
	{ 241222, DESKBOT_RANGE89, false, false },
	{ 241223, DESKBOT_RANGE89, false, false },
	{ 241224, DESKBOT_RANGE89, false, false },
	{ 241225, DESKBOT_RANGE89, false, false },
	{ 241226, DESKBOT_RANGE89, false, false },
	{ 241227, DESKBOT_RANGE89, false, false },
	{ 241228, DESKBOT_RANGE89, false, false },
	{ 241229, DESKBOT_RANGE89, false, false },
	{ 241230, DESKBOT_RANGE89, false, false },
	{ 241231, DESKBOT_RANGE89, false, false },
	{ 241232, DESKBOT_RANGE89, false, false },
	{ 241233, DESKBOT_RANGE89, false, false },
	{ 241234, DESKBOT_RANGE89, false, false },
	{ 241235, DESKBOT_RANGE89, false, false },
	{ 241236, DESKBOT_RANGE89, false, false },
	{ 241237, DESKBOT_RANGE89, false, false },
	{ 241238, DESKBOT_RANGE89, false, false },
	{ 241239, DESKBOT_RANGE89, false, false },
	{ 241240, DESKBOT_RANGE89, false, false },
	{ 241241, DESKBOT_RANGE89, false, false },
	{ 241242, DESKBOT_RANGE89, false, false },
	{ 241243, DESKBOT_RANGE89, false, false },
	{ 241244, DESKBOT_RANGE89, false, false },
	{ 241245, DESKBOT_RANGE89, false, false },
	{ 241246, DESKBOT_RANGE89, false, false },
	{ 241247, DESKBOT_RANGE89, false, false },
	{ 241248, DESKBOT_RANGE89, false, false },
	{ 241249, DESKBOT_RANGE89, false, false },
	{ 241250, DESKBOT_RANGE89, false, false },
	{ 241251, DESKBOT_RANGE89, false, false },
	{ 241252, DESKBOT_RANGE89, false, false },
	{ 241253, DESKBOT_RANGE89, false, false },
	{ 241254, DESKBOT_RANGE89, false, false },
	{ 241255, DESKBOT_RANGE89, false, false },
	{ 241256, DESKBOT_RANGE89, false, false },
	{ 241257, DESKBOT_RANGE89, false, false },
	{ 241258, DESKBOT_RANGE89, false, false },
	{ 241259, DESKBOT_RANGE89, false, false },

	{ 241216, DESKBOT_RANGE90, true, false },
	{ 241625, DESKBOT_RANGE91, false, false },
	{ 241626, DESKBOT_RANGE92, true, false },
	{ 241627, DESKBOT_RANGE93, false, false },
	{ 241628, DESKBOT_RANGE94, true, false },
	{ 241629, DESKBOT_RANGE95, true, false },
	{ 241630, DESKBOT_RANGE96, true, false },
	{ 241631, DESKBOT_RANGE97, true, false },
	{ 241632, DESKBOT_RANGE98, true, false },
	{ 241633, DESKBOT_RANGE99, true, false },
	{ 241634, DESKBOT_RANGE100, true, false },

	{ 241738, DESKBOT_RANGE101, true, false },
	{ 241739, DESKBOT_RANGE102, true, false },
	{ 241740, DESKBOT_RANGE103, true, false },
	{ 241741, DESKBOT_RANGE104, true, false }
};

const uint DOORBOT_RANGE1[] = { 220075, 220078, 220080, 220081, 220082, 220083, 220084, 0 };
const uint DOORBOT_RANGE2[] = { 220077, 220079, 220076, 0 };
const uint DOORBOT_RANGE3[] = {
	220008, 220009, 220010, 220011, 220012, 220013, 220014,
	220015, 220016, 221053, 221054, 221055, 221056, 221057,
	221058, 221059, 221060, 221061, 0
};
const uint DOORBOT_RANGE4[] = {
	221062, 221063, 221064, 221065, 221066, 221067, 221068,
	221069, 221070, 221071, 221072, 221073, 221074, 221075,
	221076, 221077, 221078, 221079, 221080, 221081, 221082,
	0
};
const uint DOORBOT_RANGE5[] = { 220737, 220738, 220739, 220740, 0 };
const uint DOORBOT_RANGE6[] = { 220759, 220760, 220761, 0 };
const uint DOORBOT_RANGE7[] = { 220771, 220772, 220773, 220774, 220775, 0 };
const uint DOORBOT_RANGE8[] = { 220792, 220793, 220794, 220795, 220796, 220797, 220798, 0 };
const uint DOORBOT_RANGE9[] = { 220017, 220018, 220019, 220020, 220833, 0 };
const uint DOORBOT_RANGE10[] = { 220035, 220036, 220038, 0 };

const uint DOORBOT_RANGE11[] = { 220093, 220094, 220095, 0 };
const uint DOORBOT_RANGE12[] = { 220109, 220117, 0 };
const uint DOORBOT_RANGE13[] = { 220837, 220838, 220839, 0 };
const uint DOORBOT_RANGE14[] = { 220849, 220850, 220851, 220852, 0 };
const uint DOORBOT_RANGE15[] = { 220858, 220860, 0 };
const uint DOORBOT_RANGE16[] = { 221043, 221045, 221046, 221047, 221048, 221049, 221050,
	221051, 221052, 221044, 0 };
const uint DOORBOT_RANGE17[] = { 221140, 221141, 221142, 221143, 221144, 221145, 221146,
	221147, 0 };
const uint DOORBOT_RANGE18[] = { 220885, 220886, 220887, 220888, 220890, 220883, 220884,
	220889, 0 };
const uint DOORBOT_RANGE19[] = {
	221356, 221364, 221365, 221366, 221129, 221367, 221368,
	221132, 221369, 221357, 221359, 221363, 220902, 0
};
const uint DOORBOT_RANGE20[] = { 221129, 221130, 221131, 221132, 221133, 221136, 221137,
	221138, 0 };
const uint DOORBOT_RANGE21[] = { 221157, 221165, 221166, 221167, 221130, 221168, 221169,
	221132, 221170, 221171, 221158, 220910, 0 };
const uint DOORBOT_RANGE22[] = { 221356, 221364, 221366, 221129, 221368, 221132, 221369,
	221357, 221359, 221363, 220902, 220919, 220911, 220936,
	220942, 220946, 220988, 0
};
const uint DOORBOT_RANGE23[] = {
	221157, 221165, 221166, 221167, 221130, 221168, 221169,
	221132, 221170, 221171, 221158, 220910, 220911, 220929,
	220944, 220948, 220909, 0
};
const uint DOORBOT_RANGE24[] = { 220980, 220981, 220982, 220984, 220956, 220931, 220926,
	220916, 220914, 220913, 220974, 220952, 0 };
const uint DOORBOT_RANGE25[] = { 220873, 220874, 220875, 220876, 220877, 0 };
const uint DOORBOT_RANGE26[] = { 221242, 221243, 221244, 221242, 221243, 221244, 221251, 0 };
const uint DOORBOT_RANGE27[] = { 221245, 221246, 221247, 221248, 221249, 221250, 0 };
const uint DOORBOT_RANGE28[] = { 221777, 221780, 0 };
const uint DOORBOT_RANGE29[] = { 221966, 221967, 0 };
const uint DOORBOT_RANGE30[] = { 220986, 222096, 222099, 222102, 0 };
const uint DOORBOT_RANGE31[] = { 222193, 222197, 222198, 222199, 222200, 222201, 222202,
	222203, 222204, 222194, 222195, 222196, 0 };
const uint DOORBOT_RANGE32[] = { 221927, 221931, 0 };
const uint DOORBOT_RANGE33[] = { 221945, 221948, 0 };
const uint DOORBOT_RANGE34[] = { 222004, 222001, 0 };
const uint DOORBOT_RANGE35[] = { 222259, 222262, 222265, 222268, 222271, 222274, 222277,
	222280, 222283, 222254, 222257, 0 };
const uint DOORBOT_RANGE36[] = { 221364, 221365, 221360, 221252, 220952, 220916, 220996,
	220924, 220926, 220931, 220956, 220967, 220968, 220980,
	220981, 220982, 220984, 220988, 0 };
const uint DOORBOT_RANGE37[] = {
	221166, 221252, 220984, 220952, 220996, 220916, 220926,
	220931, 220948, 220965, 220967, 220980, 220981, 220982,
	220983, 220988, 220903, 221019, 221355, 0 };
const uint DOORBOT_RANGE38[] = { 222248, 220081, 220082, 220083, 220084, 0 };
const uint DOORBOT_RANGE39[] = { 221095, 222202, 222239, 221758, 221759, 221762, 221763,
	221766, 221767, 221768, 0 };

#define DOORBOT_RANGE_COUNT 39
const ScriptRange DOORBOT_RANGES[39] = {
	{ 220074, DOORBOT_RANGE1, false, false },
	{ 221381, DOORBOT_RANGE2, false, false },
	{ 220000, DOORBOT_RANGE3, true, false },
	{ 221380, DOORBOT_RANGE4, true, false },
	{ 220736, DOORBOT_RANGE5, false, false },
	{ 220759, DOORBOT_RANGE6, false, false },
	{ 220771, DOORBOT_RANGE7, false, false },
	{ 220792, DOORBOT_RANGE8, false, false },
	{ 220017, DOORBOT_RANGE9, false, false },
	{ 220037, DOORBOT_RANGE10, false, false },

	{ 220093, DOORBOT_RANGE11, false, false },
	{ 220109, DOORBOT_RANGE12, false, false },
	{ 220837, DOORBOT_RANGE13, false, false },
	{ 220849, DOORBOT_RANGE14, false, false },
	{ 220858, DOORBOT_RANGE15, false, false },
	{ 221043, DOORBOT_RANGE16, false, false },
	{ 221140, DOORBOT_RANGE17, false, false },
	{ 220883, DOORBOT_RANGE18, false, false },
	{ 221375, DOORBOT_RANGE19, true, false },
	{ 221129, DOORBOT_RANGE20, true, false },

	{ 221376, DOORBOT_RANGE21, true, false },
	{ 221377, DOORBOT_RANGE22, true, false },
	{ 221378, DOORBOT_RANGE23, true, false },
	{ 221379, DOORBOT_RANGE24, true, false },
	{ 220873, DOORBOT_RANGE25, false, false },
	{ 221242, DOORBOT_RANGE26, false, false },
	{ 221245, DOORBOT_RANGE27, false, false },
	{ 221777, DOORBOT_RANGE28, false, false },
	{ 221966, DOORBOT_RANGE29, false, false },
	{ 220986, DOORBOT_RANGE30, false, false },

	{ 222193, DOORBOT_RANGE31, false, false },
	{ 221927, DOORBOT_RANGE32, false, false },
	{ 221948, DOORBOT_RANGE33, false, true },
	{ 222000, DOORBOT_RANGE34, false, false },
	{ 222259, DOORBOT_RANGE35, false, false },
	{ 222415, DOORBOT_RANGE36, true, false },
	{ 222416, DOORBOT_RANGE37, true, false },
	{ 222248, DOORBOT_RANGE38, false, false },
	{ 221095, DOORBOT_RANGE39, true, false }
};

const uint LIFTBOT_RANGE1[] = { 210028, 210034, 210039, 210044, 210049, 210054, 0 };
const uint LIFTBOT_RANGE2[] = { 210321, 210322, 210323, 210324, 210792, 210794, 210796, 210793, 210795, 210797, 0 };
const uint LIFTBOT_RANGE3[] = {
	210572, 210568, 210338, 210341, 210355, 210419, 210430, 210441, 210460, 210463,
	210464, 210475, 210477, 210496, 210497, 210503, 210357, 210359, 210372, 210382,
	210388, 210393, 210394, 210400, 210415, 0
};
const uint LIFTBOT_RANGE4[] = {
	210568, 210342, 210555, 210551, 210534, 210557, 210334, 210474, 210504, 210505,
	210517, 210358, 210359, 210360, 210376, 210378, 210379, 210382, 210396, 210398,
	210402, 0
};
const uint LIFTBOT_RANGE5[] = {
	210572, 210568, 210397, 210408, 210419, 210430, 210441, 210460, 210463, 210464,
	210475, 210477, 210496, 210497, 210503, 210357, 210359, 210372, 210382, 210388,
	210393, 210394, 210400, 210415, 0
};
const uint LIFTBOT_RANGE6[] = {
	210555, 210551, 210534, 210557, 210334, 210474, 210504, 210505, 210517, 210358,
	210359, 210360, 210376, 210378, 210379, 210382, 210396, 210398, 210402, 0
};
const uint LIFTBOT_RANGE7[] = { 210344, 210447, 210529, 210530, 210351, 210356, 210378, 0 };
const uint LIFTBOT_RANGE8[] = { 210512, 210513, 210345, 0 };
const uint LIFTBOT_RANGE9[] = { 210847, 210848, 210153, 0 };
const uint LIFTBOT_RANGE10[] = { 210846, 210153, 0 };

const uint LIFTBOT_RANGE11[] = { 210595, 210601, 210602, 210603, 210604, 210605, 210606, 210607, 210608, 210596,
	210597, 210598, 210599, 210600, 0 };
const uint LIFTBOT_RANGE12[] = { 210489, 210570, 210610, 210610, 210610, 210610, 210610, 0 };
const uint LIFTBOT_RANGE13[] = { 210819, 210822, 210823, 210824, 210825, 210827, 210828, 210829, 210820, 210821,
	210965, 210969, 210965, 210969, 0 };
const uint LIFTBOT_RANGE14[] = { 210869, 210870, 210871, 210872, 210873, 0 };
const uint LIFTBOT_RANGE15[] = { 210875, 210876, 210877, 210878, 210879, 0 };
const uint LIFTBOT_RANGE16[] = { 210866, 210867, 0 };
const uint LIFTBOT_RANGE17[] = { 210853, 210854, 0 };
const uint LIFTBOT_RANGE18[] = { 210858, 210859, 0 };
const uint LIFTBOT_RANGE19[] = { 210860, 210861, 210862, 210863, 210864, 210865, 0 };
const uint LIFTBOT_RANGE20[] = { 210771, 210914, 0 };

const uint LIFTBOT_RANGE21[] = { 210764, 210765, 210766, 210767, 210768, 210769, 210770, 0 };
const uint LIFTBOT_RANGE22[] = { 210607, 210799, 210800, 210801, 210802, 210815, 210890, 210892, 0 };
const uint LIFTBOT_RANGE23[] = { 210355, 210359, 210376, 210388, 210416, 210568, 210551, 0 };
const uint LIFTBOT_RANGE24[] = { 210511, 210522, 210382, 210383, 210392, 210337, 210546, 210576, 0 };
const uint LIFTBOT_RANGE25[] = { 210775, 210777, 210778, 210779, 210780, 210781, 210782, 210783, 210784, 210776,
	210459, 210789, 210790, 210791, 0 };
const uint LIFTBOT_RANGE26[] = { 210780, 210781, 210782, 210783, 210784, 210780, 210781, 210782, 210783, 210784,
	210789, 210790, 210791, 0 };
const uint LIFTBOT_RANGE27[] = { 210440, 210442, 0 };
const uint LIFTBOT_RANGE28[] = { 210906, 210907, 210908, 210909, 210910, 210911, 210912, 0 };
const uint LIFTBOT_RANGE29[] = { 210901, 210902, 210903, 210904, 210905, 0 };
const uint LIFTBOT_RANGE30[] = { 210970, 210971, 210974, 210975, 210976, 210977, 210978, 210979, 210980, 210981,
	210972, 210973, 0 };

const uint LIFTBOT_RANGE31[] = { 210830, 210831, 210832, 210833, 210834, 210835, 210836, 210837, 0 };
const uint LIFTBOT_RANGE32[] = { 210692, 210695, 210696, 210697, 210698, 210699, 210700, 210701, 210702, 210693, 210694, 0 };
const uint LIFTBOT_RANGE33[] = { 210915, 210916, 210917, 0 };
const uint LIFTBOT_RANGE34[] = { 210688, 210689, 210690, 0 };
const uint LIFTBOT_RANGE35[] = { 210946, 210947, 210948, 210949, 210950, 210951, 210952, 210953, 210954, 0 };
const uint LIFTBOT_RANGE36[] = { 210923, 210924, 0 };
const uint LIFTBOT_RANGE37[] = { 210925, 210926, 210927, 210928, 210929, 210930, 210931, 210932, 210933, 0 };
const uint LIFTBOT_RANGE38[] = { 210413, 210799, 210800, 210801, 210802, 210888, 210889, 210890, 210891, 210892, 0 };
const uint LIFTBOT_RANGE39[] = { 210682, 210684, 210028, 210034, 210683, 210039, 210685, 210044, 210049, 210686,
	210054, 0 };

#define LIFTBOT_RANGE_COUNT 39
const ScriptRange LIFTBOT_RANGES[39] = {
	{ 210033, LIFTBOT_RANGE1, false, false },
	{ 210321, LIFTBOT_RANGE2, true, false },
	{ 210580, LIFTBOT_RANGE3, true, false },
	{ 210581, LIFTBOT_RANGE4, true, false },
	{ 210582, LIFTBOT_RANGE5, true, false },
	{ 210583, LIFTBOT_RANGE6, true, false },
	{ 210584, LIFTBOT_RANGE7, true, false },
	{ 210585, LIFTBOT_RANGE8, true, false },
	{ 210586, LIFTBOT_RANGE9, false, false },
	{ 210587, LIFTBOT_RANGE10, false, false },

	{ 210588, LIFTBOT_RANGE11, true, false },
	{ 210589, LIFTBOT_RANGE12, true, false },
	{ 210590, LIFTBOT_RANGE13, true, false },
	{ 210869, LIFTBOT_RANGE14, false, false },
	{ 210875, LIFTBOT_RANGE15, false, false },
	{ 210866, LIFTBOT_RANGE16, false, false },
	{ 210853, LIFTBOT_RANGE17, false, false },
	{ 210858, LIFTBOT_RANGE18, false, false },
	{ 210860, LIFTBOT_RANGE19, false, false },
	{ 210771, LIFTBOT_RANGE20, false, false },

	{ 210764, LIFTBOT_RANGE21, false, false },
	{ 210958, LIFTBOT_RANGE22, true, false },
	{ 210591, LIFTBOT_RANGE23, true, false },
	{ 210592, LIFTBOT_RANGE24, true, false },
	{ 210594, LIFTBOT_RANGE25, true, false },
	{ 210593, LIFTBOT_RANGE26, true, false },
	{ 210440, LIFTBOT_RANGE27, false, false },
	{ 210906, LIFTBOT_RANGE28, true, false },
	{ 210901, LIFTBOT_RANGE29, true, false },
	{ 210970, LIFTBOT_RANGE30, false, false },

	{ 210830, LIFTBOT_RANGE31, true, false },
	{ 210692, LIFTBOT_RANGE32, false, false },
	{ 210915, LIFTBOT_RANGE33, false, false },
	{ 210688, LIFTBOT_RANGE34, false, false },
	{ 210946, LIFTBOT_RANGE35, true, false },
	{ 210923, LIFTBOT_RANGE36, false, false },
	{ 210925, LIFTBOT_RANGE37, true, false },
	{ 210413, LIFTBOT_RANGE38, true, false },
	{ 210682, LIFTBOT_RANGE39, false, false }
};

const uint MAITRED_RANGE1[] = { 260009, 260010, 260011, 260012, 0 };
const uint MAITRED_RANGE2[] = {
	260043, 260013, 260044, 260014, 260017, 260015, 260016, 260040, 260042, 260019,
	260029, 260021, 260018, 260020, 260022, 260023, 260041, 260028, 260045, 260031,
	260032, 260033, 260030, 260046, 260034, 260039, 0
};
const uint MAITRED_RANGE3[] = {
	260013, 260014, 260029, 260040, 260041, 260042, 260043, 260044, 260045, 260046,
	260015, 260016, 260017, 260018, 260019, 260020, 260021, 260022, 260023, 260028,
	260030, 260031, 260032, 260033, 260034, 260035, 260039, 0
};
const uint MAITRED_RANGE4[] = {
	260013, 260014, 260029, 260040, 260041, 260042, 260043, 260044, 260045, 260046,
	260015, 260016, 260017, 260018, 260019, 260020, 260021, 260022, 260023, 260025,
	260028, 260030, 260031, 260032, 260033, 260034, 260036, 260039, 0
};
const uint MAITRED_RANGE5[] = {
	260013, 260014, 260029, 260040, 260041, 260042, 260043, 260044, 260045, 260046,
	260015, 260016, 260017, 260018, 260019, 260020, 260021, 260022, 260023, 260026,
	260028, 260030, 260031, 260032, 260033, 260034, 260037, 260039, 0
};
const uint MAITRED_RANGE6[] = {
	260013, 260014, 260029, 260040, 260041, 260042, 260043, 260044, 260045, 260046,
	260015, 260016, 260017, 260018, 260019, 260020, 260021, 260022, 260023, 260027,
	260028, 260030, 260031, 260032, 260033, 260034, 260038, 260039, 0
};
const uint MAITRED_RANGE7[] = { 260048, 260049, 260050, 0 };
const uint MAITRED_RANGE8[] = { 260054, 260055, 260056, 260057, 260058, 260059, 260060, 0 };
const uint MAITRED_RANGE9[] = { 260061, 260062, 0 };
const uint MAITRED_RANGE10[] = { 260064, 260065, 260066, 0 };
const uint MAITRED_RANGE11[] = { 260068, 260110, 260069, 260070, 260075, 261010, 260181, 260076, 0 };
const uint MAITRED_RANGE12[] = { 260068, 260110, 260069, 260070, 260075, 261010, 260181, 260076, 0 };
const uint MAITRED_RANGE13[] = { 260068, 260110, 260069, 260071, 260075, 261010, 260181, 260076, 0 };
const uint MAITRED_RANGE14[] = { 260068, 260110, 260069, 260072, 260075, 261010, 260181, 260076, 0 };
const uint MAITRED_RANGE15[] = { 260068, 260110, 260069, 260073, 260075, 261010, 260181, 260076, 0 };
const uint MAITRED_RANGE16[] = { 260068, 260110, 260069, 260074, 260075, 261010, 260181, 260076, 0 };
const uint MAITRED_RANGE17[] = { 260078, 260079, 260080, 0 };
const uint MAITRED_RANGE18[] = { 260081, 260082, 260083, 260084, 260085, 0 };
const uint MAITRED_RANGE19[] = { 260103, 260104, 260105, 0 };
const uint MAITRED_RANGE20[] = { 260092, 260093, 260088, 260090, 0 };
const uint MAITRED_RANGE21[] = {
	260132, 260133, 260134, 260135, 260136, 260137, 260138, 260139, 260140, 260141,
	260142, 260143, 260144, 260145, 260146, 260147, 260148, 260149, 260150, 260151,
	260152, 260153, 260154, 260155, 260156, 0
};
const uint MAITRED_RANGE22[] = {
	260158, 260159, 260160, 260161, 260162, 260163, 260164, 260165, 260166, 260167,
	260168, 260169, 260170, 260171, 260172, 260173, 260174, 260175, 260176, 260177,
	260178, 260179, 260180, 0
};
const uint MAITRED_RANGE23[] = { 260185, 260186, 260187, 260188, 0 };
const uint MAITRED_RANGE24[] = { 260191, 260192, 260193, 0 };
const uint MAITRED_RANGE25[] = { 260203, 260204, 0 };
const uint MAITRED_RANGE26[] = { 260217, 260218, 260219, 260220, 0 };
const uint MAITRED_RANGE27[] = { 260263, 260264, 260265, 260427, 260053, 0 };
const uint MAITRED_RANGE28[] = { 260266, 260267, 260268, 0 };
const uint MAITRED_RANGE29[] = { 260274, 260278, 260287, 260288, 0 };
const uint MAITRED_RANGE30[] = { 260275, 260276, 260281, 260283, 260289, 260361, 0 };
const uint MAITRED_RANGE31[] = { 260277, 260280, 260284, 260286, 260359, 0 };
const uint MAITRED_RANGE32[] = { 260279, 260285, 0 };
const uint MAITRED_RANGE33[] = { 260275, 260276, 260281, 260283, 260289, 260361, 0 };
const uint MAITRED_RANGE34[] = { 260282, 260360, 0 };
const uint MAITRED_RANGE35[] = { 260432, 260306, 0 };
const uint MAITRED_RANGE36[] = { 260319, 260320, 260321, 0 };
const uint MAITRED_RANGE37[] = { 260322, 260485, 0 };
const uint MAITRED_RANGE38[] = { 260324, 260325, 0 };
const uint MAITRED_RANGE39[] = { 260326, 260327, 0 };
const uint MAITRED_RANGE40[] = { 260338, 260339, 260340, 260341, 260342, 260343, 0 };
const uint MAITRED_RANGE41[] = {
	260054, 260055, 260056, 260057, 260058, 260059, 260345, 260346, 260347, 260348,
	260349, 260350, 260351, 260352, 260353, 260354, 260355, 260356, 260357, 260358, 0
};
const uint MAITRED_RANGE42[] = { 260369, 260370, 0 };
const uint MAITRED_RANGE43[] = { 260207, 260375, 260767, 0 };
const uint MAITRED_RANGE44[] = { 260381, 260382, 260383, 260384, 260385, 0 };
const uint MAITRED_RANGE45[] = { 260389, 260390, 260391, 260392, 260393, 260394, 260395, 260396, 260397, 260398, 0 };
const uint MAITRED_RANGE46[] = { 260403, 260404, 260763, 0 };
const uint MAITRED_RANGE47[] = { 260424, 260425, 260426, 0 };
const uint MAITRED_RANGE48[] = { 260450, 260451, 0 };
const uint MAITRED_RANGE49[] = { 260521, 260501, 0 };
const uint MAITRED_RANGE50[] = { 260526, 260429, 0 };
const uint MAITRED_RANGE51[] = { 260527, 260430, 0 };
const uint MAITRED_RANGE52[] = { 260528, 260431, 0 };
const uint MAITRED_RANGE53[] = { 260567, 260568, 0 };
const uint MAITRED_RANGE54[] = { 260495, 260496, 0 };
const uint MAITRED_RANGE55[] = { 260511, 260512, 0 };
const uint MAITRED_RANGE56[] = { 260573, 260572, 0 };
const uint MAITRED_RANGE57[] = { 260595, 260596, 260597, 260598, 260599, 260600, 0 };
const uint MAITRED_RANGE58[] = { 260620, 260621, 0 };
const uint MAITRED_RANGE59[] = { 260623, 260630, 260636, 0 };
const uint MAITRED_RANGE60[] = { 260215, 260690, 260223, 260691, 0 };
const uint MAITRED_RANGE61[] = { 260000, 260212, 0 };
const uint MAITRED_RANGE62[] = { 260213, 260252, 0 };
const uint MAITRED_RANGE63[] = {
	260700, 260701, 260702, 260703, 260704, 260705, 260706, 260707, 260708, 260709,
	260710, 260711, 260712, 260713, 260714, 260715, 260716, 260717, 260718, 260719,
	260720, 260721, 260731, 260732, 260733, 260734, 260735, 260736, 260737, 260738,
	260739, 260740, 260741, 260742, 260743, 260744, 260745, 260746, 260747, 260748,
	260749, 260750, 260751, 260752, 260753, 260754, 260755, 260756, 260757, 260758,
	260759, 260760, 0
};
const uint MAITRED_RANGE64[] = { 260723, 260724, 260725, 260726, 260727, 260728, 260729, 260730, 0 };
const uint MAITRED_RANGE65[] = { 260765, 260766, 0 };
const uint MAITRED_RANGE66[] = { 260770, 260771, 0 };
const uint MAITRED_RANGE67[] = { 260773, 260774, 260775, 260776, 260271, 0 };
const uint MAITRED_RANGE68[] = { 260801, 260802, 0 };
const uint MAITRED_RANGE69[] = { 260804, 260805, 260806, 260807, 260808, 0 };
const uint MAITRED_RANGE70[] = { 260810, 260811, 0 };
const uint MAITRED_RANGE71[] = { 260813, 260814, 260815, 0 };
const uint MAITRED_RANGE72[] = { 260818, 260819, 0 };
const uint MAITRED_RANGE73[] = { 260844, 260845, 260846, 260847, 260848, 0 };
const uint MAITRED_RANGE74[] = { 260857, 260858, 260859, 0 };
const uint MAITRED_RANGE75[] = { 260861, 260862, 0 };
const uint MAITRED_RANGE76[] = { 260864, 260865, 260866, 260867, 260868, 260869, 260870, 260871, 260872, 0 };
const uint MAITRED_RANGE77[] = { 260876, 260877, 260878, 260879, 0 };
const uint MAITRED_RANGE78[] = { 260881, 260882, 260883, 260884, 0 };
const uint MAITRED_RANGE79[] = { 260899, 260900, 260901, 260902, 260903, 260904, 260905, 260906, 260907, 260908,
260909, 260910, 260911, 260912, 0 };
const uint MAITRED_RANGE80[] = { 260914, 260915, 0 };
const uint MAITRED_RANGE81[] = { 260917, 260918, 260919, 0 };
const uint MAITRED_RANGE82[] = { 260921, 260922, 260923, 260924, 260925, 260926, 260927, 260928, 260929, 260930,
	260931, 0 };
const uint MAITRED_RANGE83[] = { 260933, 260946, 0 };
const uint MAITRED_RANGE84[] = { 260935, 260947, 0 };
const uint MAITRED_RANGE85[] = { 260939, 260948, 0 };
const uint MAITRED_RANGE86[] = { 260941, 260949, 0 };
const uint MAITRED_RANGE87[] = { 260943, 260950, 0 };
const uint MAITRED_RANGE88[] = { 260945, 260951, 0 };
const uint MAITRED_RANGE89[] = { 260953, 260954, 260955, 0 };
const uint MAITRED_RANGE90[] = { 260957, 260958, 0 };
const uint MAITRED_RANGE91[] = { 260962, 260963, 260964, 260965, 0 };
const uint MAITRED_RANGE92[] = { 260967, 260968, 260969, 260970, 260971, 260972, 260973, 0 };
const uint MAITRED_RANGE93[] = { 260982, 260983, 260984, 0 };
const uint MAITRED_RANGE94[] = { 260993, 260994, 260995, 0 };
const uint MAITRED_RANGE95[] = { 261013, 261014, 261015, 0 };
const uint MAITRED_RANGE96[] = { 260798, 260211, 0 };
const uint MAITRED_RANGE97[] = { 260790, 260416, 260417, 0 };

#define MAITRED_RANGE_COUNT 97
const ScriptRange MAITRED_RANGES[97] = {
	{ 260112, MAITRED_RANGE1, true, false },
	{ 260131, MAITRED_RANGE2, false, false },
	{ 260113, MAITRED_RANGE3, true, false },
	{ 260114, MAITRED_RANGE4, true, false },
	{ 260115, MAITRED_RANGE5, true, false },
	{ 260116, MAITRED_RANGE6, true, false },
	{ 260117, MAITRED_RANGE7, false, false },
	{ 260118, MAITRED_RANGE8, true, false },
	{ 260120, MAITRED_RANGE9, false, false },
	{ 260119, MAITRED_RANGE10, false, false },

	{ 260121, MAITRED_RANGE11, false, false },
	{ 260122, MAITRED_RANGE12, false, false },
	{ 260123, MAITRED_RANGE13, false, false },
	{ 260124, MAITRED_RANGE14, false, false },
	{ 260125, MAITRED_RANGE15, false, false },
	{ 260126, MAITRED_RANGE16, false, false },
	{ 260127, MAITRED_RANGE17, false, false },
	{ 260128, MAITRED_RANGE18, true, false },
	{ 260129, MAITRED_RANGE19, false, false },
	{ 260130, MAITRED_RANGE20, false, false },

	{ 260674, MAITRED_RANGE21, true, false },
	{ 260675, MAITRED_RANGE22, true, false },
	{ 260676, MAITRED_RANGE23, false, false },
	{ 260677, MAITRED_RANGE24, false, false },
	{ 260678, MAITRED_RANGE25, false, false },
	{ 260679, MAITRED_RANGE26, false, false },
	{ 260680, MAITRED_RANGE27, true, false },
	{ 260681, MAITRED_RANGE28, false, false },
	{ 260682, MAITRED_RANGE29, true, false },
	{ 260644, MAITRED_RANGE30, true, false },

	{ 260645, MAITRED_RANGE31, true, false },
	{ 260646, MAITRED_RANGE32, true, false },
	{ 260647, MAITRED_RANGE33, true, false },
	{ 260648, MAITRED_RANGE34, true, false },
	{ 260649, MAITRED_RANGE35, true, false },
	{ 260650, MAITRED_RANGE36, false, false },
	{ 260651, MAITRED_RANGE37, false, false },
	{ 260652, MAITRED_RANGE38, false, false },
	{ 260653, MAITRED_RANGE39, false, false },
	{ 260654, MAITRED_RANGE40, true, false },

	{ 260655, MAITRED_RANGE41, true, false },
	{ 260656, MAITRED_RANGE42, false, false },
	{ 260657, MAITRED_RANGE43, true, false },
	{ 260658, MAITRED_RANGE44, false, false },
	{ 260659, MAITRED_RANGE45, false, false },
	{ 260660, MAITRED_RANGE46, true, false },
	{ 260661, MAITRED_RANGE47, false, false },
	{ 260662, MAITRED_RANGE48, false, false },
	{ 260663, MAITRED_RANGE49, false, false },
	{ 260664, MAITRED_RANGE50, false, false },

	{ 260665, MAITRED_RANGE51, false, false },
	{ 260666, MAITRED_RANGE52, false, false },
	{ 260667, MAITRED_RANGE53, false, false },
	{ 260668, MAITRED_RANGE54, false, false },
	{ 260669, MAITRED_RANGE55, false, false },
	{ 260670, MAITRED_RANGE56, false, false },
	{ 260671, MAITRED_RANGE57, false, false },
	{ 260672, MAITRED_RANGE58, false, false },
	{ 260673, MAITRED_RANGE59, false, false },
	{ 260683, MAITRED_RANGE60, false, false },

	{ 260684, MAITRED_RANGE61, false, false },
	{ 260685, MAITRED_RANGE62, false, false },
	{ 260699, MAITRED_RANGE63, true, false },
	{ 260722, MAITRED_RANGE64, true, false },
	{ 260764, MAITRED_RANGE65, true, false },
	{ 260769, MAITRED_RANGE66, true, false },
	{ 260772, MAITRED_RANGE67, true, false },
	{ 260800, MAITRED_RANGE68, true, false },
	{ 260803, MAITRED_RANGE69, true, false },
	{ 260809, MAITRED_RANGE70, true, false },

	{ 260812, MAITRED_RANGE71, true, false },
	{ 260817, MAITRED_RANGE72, true, false },
	{ 260843, MAITRED_RANGE73, true, false },
	{ 260856, MAITRED_RANGE74, true, false },
	{ 260860, MAITRED_RANGE75, true, false },
	{ 260863, MAITRED_RANGE76, true, false },
	{ 260875, MAITRED_RANGE77, true, false },
	{ 260880, MAITRED_RANGE78, true, false },
	{ 260898, MAITRED_RANGE79, true, false },
	{ 260913, MAITRED_RANGE80, true, false },

	{ 260916, MAITRED_RANGE81, true, false },
	{ 260920, MAITRED_RANGE82, true, false },
	{ 260932, MAITRED_RANGE83, true, false },
	{ 260934, MAITRED_RANGE84, true, false },
	{ 260938, MAITRED_RANGE85, true, false },
	{ 260940, MAITRED_RANGE86, true, false },
	{ 260942, MAITRED_RANGE87, true, false },
	{ 260944, MAITRED_RANGE88, true, false },
	{ 260952, MAITRED_RANGE89, true, false },
	{ 260956, MAITRED_RANGE90, true, false },

	{ 260961, MAITRED_RANGE91, true, false },
	{ 260966, MAITRED_RANGE92, true, false },
	{ 260981, MAITRED_RANGE93, false, false },
	{ 260992, MAITRED_RANGE94, true, false },
	{ 261012, MAITRED_RANGE95, true, false },
	{ 261016, MAITRED_RANGE96, true, false },
	{ 261017, MAITRED_RANGE97, true, false }
};

const uint PARROT_RANGE1[] = { 280171, 280172, 280173, 280174, 280175, 280176, 280153, 280154, 280155, 0 };
const uint PARROT_RANGE2[] = { 280004, 280005, 280006, 280007, 280008, 280009, 280010, 280011, 280012, 0 };
const uint PARROT_RANGE3[] = { 280000, 280001, 280002, 0 };
const uint PARROT_RANGE4[] = { 280161, 280162, 280163, 280164, 280165, 0 };
const uint PARROT_RANGE5[] = { 280156, 280157, 0 };
const uint PARROT_RANGE6[] = { 280158, 280159, 280160, 0 };
const uint PARROT_RANGE7[] = { 280166, 280167, 280168, 0 };
const uint PARROT_RANGE8[] = { 280179, 280180, 280181, 0 };
const uint PARROT_RANGE9[] = { 280086, 280087, 280088, 280089, 280090, 280091, 0 };
const uint PARROT_RANGE10[] = { 280153, 280154, 280155, 0 };
const uint PARROT_RANGE11[] = { 280043, 280044, 280045, 280046, 280047, 280048, 280049, 280050, 280051, 280052, 0 };
const uint PARROT_RANGE12[] = { 280014, 280015, 280016, 0 };
const uint PARROT_RANGE13[] = { 280217, 280039, 280040, 280041, 280042, 0 };
const uint PARROT_RANGE14[] = { 280119, 280120, 280121, 280122, 280028, 280029, 280030, 280031, 280116, 280117,
	280118, 0 };
const uint PARROT_RANGE15[] = { 280028, 280029, 280030, 280031, 0 };
const uint PARROT_RANGE16[] = { 280123, 280124, 280125, 280126, 280127, 280128, 0 };
const uint PARROT_RANGE17[] = { 280129, 280130, 280131, 280132, 280133, 280134, 280135, 280136, 280137, 280138, 0 };
const uint PARROT_RANGE18[] = { 280035, 280036, 280037, 280038, 0 };
const uint PARROT_RANGE19[] = { 280094, 280095, 280096, 280097, 280098, 280099, 280100, 280101, 280102, 280103,
	280104, 0 };
const uint PARROT_RANGE20[] = { 280078, 280079, 280080, 280081, 280082, 280083, 280084, 0 };
const uint PARROT_RANGE21[] = { 280067, 280068, 0 };
const uint PARROT_RANGE22[] = { 280139, 280140, 280141, 0 };
const uint PARROT_RANGE23[] = { 280017, 280018, 280019, 280020, 280021, 280022, 280023, 280024, 280025, 280026,
	280027, 0 };
const uint PARROT_RANGE24[] = { 280065, 280143, 280142, 280190, 280144, 280066, 280145, 280146, 280147, 0 };
const uint PARROT_RANGE25[] = { 280148, 280062, 280063, 0 };
const uint PARROT_RANGE26[] = { 280071, 280072, 280073, 280074, 280075, 280076, 280077, 0 };
const uint PARROT_RANGE27[] = { 280218, 280219, 0 };
const uint PARROT_RANGE28[] = { 280057, 280058, 280059, 280060, 280061, 0 };
const uint PARROT_RANGE29[] = { 280196, 280197, 280198, 280199, 280200, 0 };
const uint PARROT_RANGE30[] = { 280202, 280203, 280204, 280205, 0 };
const uint PARROT_RANGE31[] = { 280193, 280194, 280195, 0 };
const uint PARROT_RANGE32[] = { 280149, 280069, 280070, 0 };
const uint PARROT_RANGE33[] = { 280222, 280223, 280224, 280225, 280226, 280227, 280228, 280229, 280230, 280231,
	280232, 280233, 280234, 0 };
const uint PARROT_RANGE34[] = { 280268, 280269, 280270, 280271, 280272, 280273, 280274, 0 };

#define PARROT_RANGE_COUNT 34
const ScriptRange PARROT_RANGES[34] = {
	{ 280235, PARROT_RANGE1, true, false },
	{ 280236, PARROT_RANGE2, false, false },
	{ 280237, PARROT_RANGE3, false, false },
	{ 280238, PARROT_RANGE4, false, false },
	{ 280239, PARROT_RANGE5, false, false },
	{ 280240, PARROT_RANGE6, false, false },
	{ 280241, PARROT_RANGE7, false, false },
	{ 280242, PARROT_RANGE8, false, false },
	{ 280243, PARROT_RANGE9, false, false },
	{ 280244, PARROT_RANGE10, false, false },

	{ 280245, PARROT_RANGE11, false, false },
	{ 280246, PARROT_RANGE12, false, false },
	{ 280247, PARROT_RANGE13, false, false },
	{ 280248, PARROT_RANGE14, false, false },
	{ 280249, PARROT_RANGE15, false, false },
	{ 280250, PARROT_RANGE16, false, false },
	{ 280251, PARROT_RANGE17, false, false },
	{ 280252, PARROT_RANGE18, false, false },
	{ 280253, PARROT_RANGE19, false, false },
	{ 280254, PARROT_RANGE20, false, false },

	{ 280255, PARROT_RANGE21, false, false },
	{ 280256, PARROT_RANGE22, false, false },
	{ 280257, PARROT_RANGE23, true, false },
	{ 280258, PARROT_RANGE24, false, true },
	{ 280259, PARROT_RANGE25, false, false },
	{ 280260, PARROT_RANGE26, false, false },
	{ 280261, PARROT_RANGE27, false, false },
	{ 280262, PARROT_RANGE28, false, false },
	{ 280263, PARROT_RANGE29, false, false },
	{ 280264, PARROT_RANGE30, false, false },

	{ 280265, PARROT_RANGE31, false, false },
	{ 280266, PARROT_RANGE32, false, false },
	{ 280222, PARROT_RANGE33, true, false },
	{ 280267, PARROT_RANGE34, true, false }
};

const uint SUCCUBUS_RANGE1[] = { 230001, 230149, 230078, 230002, 230033, 230067, 230003, 230079, 230034, 230055,
	230080, 230081, 230064, 230035, 0 };
const uint SUCCUBUS_RANGE2[] = { 230005, 230085, 230006, 230091, 0 };
const uint SUCCUBUS_RANGE3[] = { 230009, 230010, 230011, 0 };
const uint SUCCUBUS_RANGE4[] = { 230030, 230031, 230032, 230033, 230034, 230035, 230036, 230037, 230038, 230142,
	230097, 0 };
const uint SUCCUBUS_RANGE5[] = { 230100, 230101, 230102, 230104, 230105, 230113, 0 };
const uint SUCCUBUS_RANGE6[] = { 230106, 230107, 230108, 230109, 230110, 0 };
const uint SUCCUBUS_RANGE7[] = { 230119, 230120, 0 };
const uint SUCCUBUS_RANGE8[] = { 230150, 230152, 230153, 230151, 0 };
const uint SUCCUBUS_RANGE9[] = { 230154, 230155, 0 };
const uint SUCCUBUS_RANGE10[] = { 230163, 230164, 230167, 230165, 230166, 230168, 0 };
const uint SUCCUBUS_RANGE11[] = { 230123, 230124, 230126, 230127, 230128, 230129, 230130, 230131, 0 };
const uint SUCCUBUS_RANGE12[] = { 230117, 230115, 0 };
const uint SUCCUBUS_RANGE13[] = { 230179, 230180, 230057, 230181, 230068, 230182, 230118, 230048, 230058, 0 };
const uint SUCCUBUS_RANGE14[] = { 230191, 230192, 230193, 230194, 0 };
const uint SUCCUBUS_RANGE15[] = { 230239, 230240, 230241, 0 };
const uint SUCCUBUS_RANGE16[] = { 230200, 230201, 230202, 230203, 230204, 230205, 230206, 0 };
const uint SUCCUBUS_RANGE17[] = { 230122, 230073, 230074, 230075, 230076, 230077, 0 };
const uint SUCCUBUS_RANGE18[] = { 230103, 230114, 230125, 230136, 230147, 230158, 230169, 230079, 230080, 230081,
	230082, 0 };
const uint SUCCUBUS_RANGE19[] = { 230207, 230072, 0 };

#define SUCCUBUS_RANGE_COUNT 19
const ScriptRange SUCCUBUS_RANGES[19] = {
	{ 230001, SUCCUBUS_RANGE1, false, false },
	{ 230005, SUCCUBUS_RANGE2, false, false },
	{ 230009, SUCCUBUS_RANGE3, false, false },
	{ 230030, SUCCUBUS_RANGE4, false, false },
	{ 230244, SUCCUBUS_RANGE5, false, false },
	{ 230106, SUCCUBUS_RANGE6, false, false },
	{ 230119, SUCCUBUS_RANGE7, false, false },
	{ 230150, SUCCUBUS_RANGE8, false, false },
	{ 230154, SUCCUBUS_RANGE9, false, false },
	{ 230163, SUCCUBUS_RANGE10, false, false },

	{ 230123, SUCCUBUS_RANGE11, false, false },
	{ 230117, SUCCUBUS_RANGE12, false, false },
	{ 230179, SUCCUBUS_RANGE13, false, false },
	{ 230191, SUCCUBUS_RANGE14, false, false },
	{ 230239, SUCCUBUS_RANGE15, false, false },
	{ 230200, SUCCUBUS_RANGE16, false, false },
	{ 230122, SUCCUBUS_RANGE17, false, false },
	{ 230103, SUCCUBUS_RANGE18, false, false },
	{ 230207, SUCCUBUS_RANGE19, false, false }
};

void writeScriptRange(const char *name, const ScriptRange *ranges, int count) {
	outputFile.seek(dataOffset);

	for (int idx = 0; idx < count; ++idx) {
		outputFile.writeLong(ranges[idx]._id);
		outputFile.writeByte(ranges[idx]._isRandom);
		outputFile.writeByte(ranges[idx]._isSequential);

		const uint *v = ranges[idx]._array;
		do {
			outputFile.writeLong(*v);
		} while (*v++ != 0);
	}

	uint size = outputFile.size() - dataOffset;
	writeEntryHeader(name, dataOffset, size);
	dataOffset += size;
}

void writeAllScriptRanges() {
	writeScriptRange("Ranges/Barbot", BARBOT_RANGES, BARBOT_RANGE_COUNT);
	writeScriptRange("Ranges/Bellbot", BELLBOT_RANGES, BELLBOT_RANGE_COUNT);
	writeScriptRange("Ranges/Deskbot", DESKBOT_RANGES, DESKBOT_RANGE_COUNT);
	writeScriptRange("Ranges/Doorbot", DOORBOT_RANGES, DOORBOT_RANGE_COUNT);
	writeScriptRange("Ranges/Liftbot", LIFTBOT_RANGES, LIFTBOT_RANGE_COUNT);
	writeScriptRange("Ranges/MaitreD", MAITRED_RANGES, MAITRED_RANGE_COUNT);
	writeScriptRange("Ranges/Parrot", PARROT_RANGES, PARROT_RANGE_COUNT);
	writeScriptRange("Ranges/SuccUBus", SUCCUBUS_RANGES, SUCCUBUS_RANGE_COUNT);
}
