/*
 * Copyright (C) 2022 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "CSSOMColorValue.h"

namespace WebCore {

class CSSHSL final : public CSSOMColorValue {
    WTF_MAKE_TZONE_ALLOCATED(CSSHSL);
public:
    static ExceptionOr<Ref<CSSHSL>> create(CSSColorAngle&& hue, CSSColorPercent&& saturation, CSSColorPercent&& lightness, CSSColorPercent&& alpha);

    CSSColorAngle h() const;
    ExceptionOr<void> setH(CSSColorAngle&&);
    CSSColorPercent s() const;
    ExceptionOr<void> setS(CSSColorPercent&&);
    CSSColorPercent l() const;
    ExceptionOr<void> setL(CSSColorPercent&&);
    CSSColorPercent alpha() const;
    ExceptionOr<void> setAlpha(CSSColorPercent&&);

private:
    CSSHSL(RectifiedCSSColorAngle&&, RectifiedCSSColorPercent&&, RectifiedCSSColorPercent&&, RectifiedCSSColorPercent&&);

    CSSStyleValueType styleValueType() const final { return CSSStyleValueType::CSSColorHSL; }

    RectifiedCSSColorAngle m_hue;
    RectifiedCSSColorPercent m_saturation;
    RectifiedCSSColorPercent m_lightness;
    RectifiedCSSColorPercent m_alpha;
};
    
} // namespace WebCore

SPECIALIZE_TYPE_TRAITS_BEGIN(WebCore::CSSHSL)
    static bool isType(const WebCore::CSSStyleValue& value) { return value.styleValueType() == WebCore::CSSStyleValueType::CSSColorHSL; }
SPECIALIZE_TYPE_TRAITS_END()
