/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.util.MyVector;
import rene.zirkel.Zirkel;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.BasicExpression;
import rene.zirkel.expression.ConvexMin;
import rene.zirkel.expression.CumSumExpression;
import rene.zirkel.expression.DExpression;
import rene.zirkel.expression.ExpressionText;
import rene.zirkel.expression.FindObjectExpression;
import rene.zirkel.expression.IfExpression;
import rene.zirkel.expression.InvalidException;
import rene.zirkel.expression.ObjectExpression;
import rene.zirkel.expression.Romberg;
import rene.zirkel.expression.Secant;
import rene.zirkel.expression.SimulationExpression;
import rene.zirkel.expression.TopExpression;
import rene.zirkel.expression.UserFunctionExpression;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.FunctionObject;
import rene.zirkel.objects.InsideObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.SimulationObject;
import rene.zirkel.objects.TrackObject;
import rene.zirkel.objects.UserFunctionObject;

class FunctionExpression
extends BasicExpression {
    int F;
    BasicExpression[] E;
    int NParams;
    static final String[] Functions = new String[]{"sin", "cos", "tan", "arcsin", "arccos", "arctan", "sqrt", "exp", "log", "round", "x", "y", "floor", "ceil", "d", "a", "angle180", "angle360", "abs", "scale", "sign", "d", "sum", "if", "deg", "rad", "integrate", "zero", "diff", "min", "max", "length", "rsin", "rcos", "rtan", "rarcsin", "rarccos", "rarctan", "sinhyp", "coshyp", "z", "simulate", "inside"};
    static final int NX = 10;
    static final int NY = 11;
    static final int ND = 14;
    static final int NA = 15;
    static final int NS = 19;
    static final int NSUM = 22;
    static final int NIF = 23;
    static final int NINT = 26;
    static final int NZERO = 27;
    static final int NDIFF = 28;
    static final int NMIN = 29;
    static final int NMAX = 30;
    static final int NLENGTH = 31;
    static final int NZ = 40;
    static final int NSIM = 41;
    static final int NINSIDE = 42;

    public FunctionExpression(int n, BasicExpression basicExpression) {
        this.F = n;
        this.E = new BasicExpression[1];
        this.E[0] = basicExpression;
        this.NParams = 1;
    }

    public FunctionExpression(int n, BasicExpression basicExpression, BasicExpression basicExpression2) {
        this.F = n;
        this.E = new BasicExpression[2];
        this.E[0] = basicExpression;
        this.E[1] = basicExpression2;
        this.NParams = 2;
    }

    public FunctionExpression(int n, BasicExpression basicExpression, BasicExpression basicExpression2, BasicExpression basicExpression3) {
        this.F = n;
        this.E = new BasicExpression[3];
        this.E[0] = basicExpression;
        this.E[1] = basicExpression2;
        this.E[2] = basicExpression3;
        this.NParams = 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BasicExpression scan(ExpressionText expressionText, String string) throws ConstructionException {
        int n;
        int n2 = -1;
        for (n = 0; n < Functions.length; ++n) {
            if (!string.equals(Functions[n])) continue;
            n2 = n;
            break;
        }
        if (n2 < 0) {
            Object[] objectArray;
            n = 0;
            ConstructionObject constructionObject = expressionText.getConstruction().find(string, expressionText.getObject());
            if (constructionObject == null) {
                constructionObject = expressionText.getConstruction().find(string);
                n = 1;
            }
            if (constructionObject == null || !(constructionObject instanceof FunctionObject) && !(constructionObject instanceof UserFunctionObject) || constructionObject == expressionText.getObject() || expressionText.getConstruction().dependsOn(constructionObject, expressionText.getObject())) throw new ConstructionException(Zirkel.name("exception.function") + " (" + string + ")");
            if (expressionText.next() != '(') {
                throw new ConstructionException(Zirkel.name("exception.parameter"));
            }
            expressionText.advance();
            MyVector myVector = new MyVector();
            while (true) {
                objectArray = TopExpression.scan(expressionText);
                myVector.addElement(objectArray);
                if (expressionText.next() == ')') break;
                if (expressionText.next() != ',') {
                    throw new ConstructionException(Zirkel.name("exception.parameter"));
                }
                expressionText.advance();
            }
            expressionText.advance();
            expressionText.getDepList().add(constructionObject);
            if (n != 0) {
                expressionText.getConstruction().needsOrdering();
            }
            objectArray = new BasicExpression[myVector.size()];
            myVector.copyInto(objectArray);
            return new UserFunctionExpression(constructionObject, (BasicExpression[])objectArray);
        }
        if (expressionText.next() != '(') {
            throw new ConstructionException(Zirkel.name("exception.parameter"));
        }
        expressionText.advance();
        BasicExpression basicExpression = TopExpression.scan(expressionText);
        if (n2 == 10 || n2 == 11 || n2 == 40) {
            if (basicExpression instanceof FindObjectExpression) {
                basicExpression = new FunctionExpression(n2, basicExpression);
            } else {
                if (!(basicExpression instanceof ObjectExpression) || !(((ObjectExpression)basicExpression).getObject() instanceof PointObject)) throw new ConstructionException(Zirkel.name("exception.parameter") + " (" + Functions[n2] + ")");
                basicExpression = new FunctionExpression(n2, basicExpression);
            }
        } else if (n2 == 14) {
            if (expressionText.next() != ',') {
                basicExpression = new DExpression(basicExpression);
            } else {
                expressionText.advance();
                BasicExpression basicExpression2 = TopExpression.scan(expressionText);
                if ((!(basicExpression instanceof ObjectExpression) || !(((ObjectExpression)basicExpression).getObject() instanceof PointObject)) && !(basicExpression instanceof FindObjectExpression) || (!(basicExpression2 instanceof ObjectExpression) || !(((ObjectExpression)basicExpression2).getObject() instanceof PointObject)) && !(basicExpression2 instanceof FindObjectExpression)) throw new ConstructionException(Zirkel.name("exception.parameter") + " (" + Functions[n2] + ")");
                basicExpression = new FunctionExpression(n2, basicExpression, basicExpression2);
            }
        } else if (n2 == 15) {
            if (expressionText.next() != ',') {
                throw new ConstructionException(Zirkel.name("exception.parameter"));
            }
            expressionText.advance();
            BasicExpression basicExpression3 = TopExpression.scan(expressionText);
            if (expressionText.next() != ',') {
                throw new ConstructionException(Zirkel.name("exception.parameter"));
            }
            expressionText.advance();
            BasicExpression basicExpression4 = TopExpression.scan(expressionText);
            if ((!(basicExpression instanceof ObjectExpression) || !(((ObjectExpression)basicExpression).getObject() instanceof PointObject)) && !(basicExpression instanceof FindObjectExpression) || (!(basicExpression3 instanceof ObjectExpression) || !(((ObjectExpression)basicExpression3).getObject() instanceof PointObject)) && !(basicExpression3 instanceof FindObjectExpression) || (!(basicExpression4 instanceof ObjectExpression) || !(((ObjectExpression)basicExpression4).getObject() instanceof PointObject)) && !(basicExpression4 instanceof FindObjectExpression)) throw new ConstructionException(Zirkel.name("exception.parameter") + " (" + Functions[n2] + ")");
            basicExpression = new FunctionExpression(n2, basicExpression, basicExpression3, basicExpression4);
        } else if (n2 == 19) {
            if (expressionText.next() != ',') {
                throw new ConstructionException(Zirkel.name("exception.parameter"));
            }
            expressionText.advance();
            BasicExpression basicExpression5 = TopExpression.scan(expressionText);
            if (expressionText.next() != ',') {
                throw new ConstructionException(Zirkel.name("exception.parameter"));
            }
            expressionText.advance();
            BasicExpression basicExpression6 = TopExpression.scan(expressionText);
            basicExpression = new FunctionExpression(n2, basicExpression, basicExpression5, basicExpression6);
        } else if (n2 == 22) {
            if (expressionText.next() != ',') {
                basicExpression = new CumSumExpression(basicExpression);
            } else {
                expressionText.advance();
                BasicExpression basicExpression7 = TopExpression.scan(expressionText);
                basicExpression = new CumSumExpression(basicExpression, basicExpression7);
            }
        } else if (n2 == 23) {
            if (expressionText.next() != ',') {
                throw new ConstructionException(Zirkel.name("exception.parameter"));
            }
            expressionText.advance();
            BasicExpression basicExpression8 = TopExpression.scan(expressionText);
            if (expressionText.next() != ',') {
                throw new ConstructionException(Zirkel.name("exception.parameter"));
            }
            expressionText.advance();
            BasicExpression basicExpression9 = TopExpression.scan(expressionText);
            basicExpression = new IfExpression(basicExpression, basicExpression8, basicExpression9);
        } else if (n2 == 26 || n2 == 27 || n2 == 29 || n2 == 30 || n2 == 31) {
            if (!(basicExpression instanceof ObjectExpression)) {
                if (n2 != 30 && n2 != 29) throw new ConstructionException(Zirkel.name("exception.parameter") + " (" + Functions[n2] + ")");
                if (expressionText.next() != ',') {
                    throw new ConstructionException(Zirkel.name("exception.parameter"));
                }
                expressionText.advance();
                BasicExpression basicExpression10 = TopExpression.scan(expressionText);
                basicExpression = new FunctionExpression(n2, basicExpression, basicExpression10);
            } else {
                boolean bl;
                boolean bl2 = bl = ((ObjectExpression)basicExpression).getObject() instanceof FunctionObject || ((ObjectExpression)basicExpression).getObject() instanceof TrackObject;
                if ((n2 == 26 || n2 == 31) && expressionText.next() == ')') {
                    if (!bl) {
                        throw new ConstructionException(Zirkel.name("exception.parameter") + " (" + Functions[n2] + ")");
                    }
                    basicExpression = new FunctionExpression(n2, basicExpression);
                } else {
                    if (n2 == 31) {
                        throw new ConstructionException(Zirkel.name("exception.parameter"));
                    }
                    if (expressionText.next() != ',') {
                        throw new ConstructionException(Zirkel.name("exception.parameter"));
                    }
                    expressionText.advance();
                    BasicExpression basicExpression11 = TopExpression.scan(expressionText);
                    if (bl) {
                        if (expressionText.next() != ',') {
                            throw new ConstructionException(Zirkel.name("exception.parameter"));
                        }
                        expressionText.advance();
                        BasicExpression basicExpression12 = TopExpression.scan(expressionText);
                        basicExpression = new FunctionExpression(n2, basicExpression, basicExpression11, basicExpression12);
                    } else {
                        if (n2 != 29 && n2 != 30) throw new ConstructionException(Zirkel.name("exception.parameter") + " (" + Functions[n2] + ")");
                        basicExpression = new FunctionExpression(n2, basicExpression, basicExpression11);
                    }
                }
            }
        } else if (n2 == 28) {
            if (!(basicExpression instanceof ObjectExpression) || !(((ObjectExpression)basicExpression).getObject() instanceof FunctionObject)) {
                throw new ConstructionException(Zirkel.name("exception.parameter") + " (" + Functions[n2] + ")");
            }
            if (expressionText.next() != ',') {
                throw new ConstructionException(Zirkel.name("exception.parameter"));
            }
            expressionText.advance();
            BasicExpression basicExpression13 = TopExpression.scan(expressionText);
            basicExpression = new FunctionExpression(n2, basicExpression, basicExpression13);
        } else if (n2 == 41) {
            if (expressionText.next() != ',') {
                throw new ConstructionException(Zirkel.name("exception.parameter"));
            }
            expressionText.advance();
            BasicExpression basicExpression14 = TopExpression.scan(expressionText);
            if (expressionText.next() != ',') {
                throw new ConstructionException(Zirkel.name("exception.parameter"));
            }
            expressionText.advance();
            BasicExpression basicExpression15 = TopExpression.scan(expressionText);
            if ((!(basicExpression instanceof ObjectExpression) || !(((ObjectExpression)basicExpression).getObject() instanceof SimulationObject)) && basicExpression15 instanceof ObjectExpression) throw new ConstructionException(Zirkel.name("exception.parameter") + " (" + Functions[n2] + ")");
            ConstructionObject constructionObject = ((ObjectExpression)basicExpression).getObject();
            if (expressionText.getConstruction().dependsOn(constructionObject, expressionText.getObject())) {
                throw new ConstructionException(Zirkel.name("exception.parameter") + " (" + Functions[n2] + ")");
            }
            basicExpression = new SimulationExpression(((ObjectExpression)basicExpression).getObject(), expressionText.getObject(), basicExpression14, ((ObjectExpression)basicExpression15).getObject());
        } else if (n2 == 42) {
            if (expressionText.next() != ',') {
                throw new ConstructionException(Zirkel.name("exception.parameter"));
            }
            expressionText.advance();
            BasicExpression basicExpression16 = TopExpression.scan(expressionText);
            if ((!(basicExpression instanceof ObjectExpression) || !(((ObjectExpression)basicExpression).getObject() instanceof PointObject)) && !(basicExpression instanceof FindObjectExpression) || (!(basicExpression16 instanceof ObjectExpression) || !(((ObjectExpression)basicExpression16).getObject() instanceof InsideObject)) && !(basicExpression16 instanceof FindObjectExpression)) throw new ConstructionException(Zirkel.name("exception.parameter") + " (" + Functions[n2] + ")");
            basicExpression = new FunctionExpression(n2, basicExpression, basicExpression16);
        } else {
            basicExpression = new FunctionExpression(n2, basicExpression);
        }
        if (expressionText.next() != ')') {
            throw new ConstructionException(Zirkel.name("exception.parameter"));
        }
        expressionText.advance();
        return basicExpression;
    }

    public double getValue() throws ConstructionException {
        switch (this.F) {
            case 10: {
                PointObject pointObject = this.getPoint(0);
                if (!pointObject.valid()) {
                    throw new InvalidException(Zirkel.name("exception.invalid"));
                }
                return pointObject.getX();
            }
            case 11: {
                PointObject pointObject = this.getPoint(0);
                if (!pointObject.valid()) {
                    throw new InvalidException(Zirkel.name("exception.invalid"));
                }
                return pointObject.getY();
            }
            case 40: {
                PointObject pointObject = this.getPoint(0);
                if (!pointObject.valid()) {
                    throw new InvalidException(Zirkel.name("exception.invalid"));
                }
                return pointObject.getZ();
            }
            case 14: {
                PointObject pointObject = this.getPoint(0);
                PointObject pointObject2 = this.getPoint(1);
                if (!pointObject.valid() || !pointObject2.valid()) {
                    throw new InvalidException(Zirkel.name("exception.invalid"));
                }
                double d2 = pointObject.getX() - pointObject2.getX();
                double d3 = pointObject.getY() - pointObject2.getY();
                return Math.sqrt(d2 * d2 + d3 * d3);
            }
            case 15: {
                PointObject pointObject = this.getPoint(0);
                PointObject pointObject3 = this.getPoint(1);
                PointObject pointObject4 = this.getPoint(2);
                if (!(pointObject.valid() && pointObject3.valid() && pointObject4.valid())) {
                    throw new InvalidException(Zirkel.name("exception.invalid"));
                }
                double d4 = pointObject.getX() - pointObject3.getX();
                double d5 = pointObject.getY() - pointObject3.getY();
                double d6 = pointObject4.getX() - pointObject3.getX();
                double d7 = pointObject4.getY() - pointObject3.getY();
                double d8 = Math.atan2(d4, d5) - Math.atan2(d6, d7);
                if ((d8 = d8 / Math.PI * 180.0) < 0.0) {
                    d8 += 360.0;
                }
                if (d8 > 360.0) {
                    d8 -= 360.0;
                }
                return d8;
            }
            case 19: {
                double d9 = this.E[0].getValue();
                double d10 = this.E[1].getValue();
                double d11 = this.E[2].getValue();
                if (d9 < d10 || d9 >= d11 || d11 <= d10) {
                    throw new InvalidException(Zirkel.name("exception.invalid"));
                }
                return (d9 - d10) / (d11 - d10);
            }
            case 26: {
                if (((ObjectExpression)this.E[0]).getObject() instanceof FunctionObject) {
                    FunctionObject functionObject = (FunctionObject)((ObjectExpression)this.E[0]).getObject();
                    if (this.E.length > 1) {
                        double d12 = this.E[1].getValue();
                        double d13 = this.E[2].getValue();
                        return Romberg.compute(functionObject, d12, d13, 10, 1.0E-10, 10);
                    }
                    return functionObject.getIntegral();
                }
                TrackObject trackObject = (TrackObject)((ObjectExpression)this.E[0]).getObject();
                if (this.E.length > 1) {
                    double d14 = this.E[1].getValue();
                    double d15 = this.E[2].getValue();
                    return trackObject.getSum(d14, d15);
                }
                return trackObject.getSum();
            }
            case 31: {
                if (((ObjectExpression)this.E[0]).getObject() instanceof FunctionObject) {
                    FunctionObject functionObject = (FunctionObject)((ObjectExpression)this.E[0]).getObject();
                    return functionObject.getLength();
                }
                TrackObject trackObject = (TrackObject)((ObjectExpression)this.E[0]).getObject();
                return trackObject.getLength();
            }
            case 27: {
                FunctionObject functionObject = (FunctionObject)((ObjectExpression)this.E[0]).getObject();
                double d16 = this.E[1].getValue();
                double d17 = this.E[2].getValue();
                return Secant.compute(functionObject, d16, d17, 1.0E-10);
            }
            case 28: {
                FunctionObject functionObject = (FunctionObject)((ObjectExpression)this.E[0]).getObject();
                double d18 = this.E[1].getValue();
                return (functionObject.evaluateF(d18 + 0.001) - functionObject.evaluateF(d18 - 0.001)) / 0.002;
            }
            case 29: {
                if (this.NParams == 2) {
                    return Math.min(this.E[0].getValue(), this.E[1].getValue());
                }
                FunctionObject functionObject = (FunctionObject)((ObjectExpression)this.E[0]).getObject();
                double d19 = this.E[1].getValue();
                double d20 = this.E[2].getValue();
                return ConvexMin.computeMin(functionObject, d19, d20, 1.0E-10);
            }
            case 30: {
                if (this.NParams == 2) {
                    return Math.max(this.E[0].getValue(), this.E[1].getValue());
                }
                FunctionObject functionObject = (FunctionObject)((ObjectExpression)this.E[0]).getObject();
                double d21 = this.E[1].getValue();
                double d22 = this.E[2].getValue();
                return ConvexMin.computeMax(functionObject, d21, d22, 1.0E-10);
            }
            case 42: {
                PointObject pointObject = this.getPoint(0);
                InsideObject insideObject = (InsideObject)((Object)((ObjectExpression)this.E[1]).getObject());
                return insideObject.containsInside(pointObject);
            }
        }
        double d23 = this.E[0].getValue();
        switch (this.F) {
            case 0: {
                return Math.sin(d23 / 180.0 * Math.PI);
            }
            case 1: {
                return Math.cos(d23 / 180.0 * Math.PI);
            }
            case 2: {
                return Math.tan(d23 / 180.0 * Math.PI);
            }
            case 3: {
                return Math.asin(d23) / Math.PI * 180.0;
            }
            case 4: {
                return Math.acos(d23) / Math.PI * 180.0;
            }
            case 5: {
                return Math.atan(d23) / Math.PI * 180.0;
            }
            case 6: {
                return Math.sqrt(d23);
            }
            case 7: {
                return Math.exp(d23);
            }
            case 8: {
                return Math.log(d23);
            }
            case 9: {
                return Math.round(d23);
            }
            case 12: {
                return Math.floor(d23);
            }
            case 13: {
                return Math.ceil(d23);
            }
            case 16: {
                d23 /= 360.0;
                d23 -= Math.floor(d23);
                d23 *= 360.0;
                if (d23 < 180.0) {
                    return d23;
                }
                return d23 - 360.0;
            }
            case 17: {
                d23 /= 360.0;
                d23 -= Math.floor(d23);
                return d23 * 360.0;
            }
            case 18: {
                return Math.abs(d23);
            }
            case 20: {
                if (d23 > 0.0) {
                    return 1.0;
                }
                if (d23 == 0.0) {
                    return 0.0;
                }
                return -1.0;
            }
            case 24: {
                return d23 / Math.PI * 180.0;
            }
            case 25: {
                return d23 / 180.0 * Math.PI;
            }
            case 32: {
                return Math.sin(d23);
            }
            case 33: {
                return Math.cos(d23);
            }
            case 34: {
                return Math.tan(d23);
            }
            case 35: {
                return Math.asin(d23);
            }
            case 36: {
                return Math.acos(d23);
            }
            case 37: {
                return Math.atan(d23);
            }
            case 38: {
                return (Math.exp(d23) - Math.exp(-d23)) / 2.0;
            }
            case 39: {
                return (Math.exp(d23) + Math.exp(-d23)) / 2.0;
            }
        }
        throw new ConstructionException("");
    }

    public PointObject getPoint(int n) throws ConstructionException {
        PointObject pointObject;
        try {
            pointObject = (PointObject)((ObjectExpression)this.E[n]).getObject();
        }
        catch (Exception exception) {
            throw new ConstructionException("exception.notfound");
        }
        if (!pointObject.valid()) {
            throw new ConstructionException("exception.invalid");
        }
        return pointObject;
    }

    public void translate() {
        for (int i = 0; i < this.NParams; ++i) {
            this.E[i].translate();
        }
    }

    public void reset() {
        for (int i = 0; i < this.NParams; ++i) {
            this.E[i].reset();
        }
    }

    public String toString() {
        String string = Functions[this.F] + "(";
        for (int i = 0; i < this.NParams; ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + this.E[i];
        }
        return string + ")";
    }
}

