/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto.ratchet;

import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.crypto.TagSetHandle;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.router.crypto.ratchet.RatchetEntry;
import net.i2p.router.crypto.ratchet.RatchetSKM;
import net.i2p.router.crypto.ratchet.RatchetSessionTag;
import net.i2p.router.crypto.ratchet.SessionKeyAndNonce;

public class MuxedPQSKM
extends SessionKeyManager {
    private final RatchetSKM _ec;
    private final RatchetSKM _pq;
    private final AtomicInteger _ecCounter = new AtomicInteger();
    private final AtomicInteger _pqCounter = new AtomicInteger();
    private static final int PQ_SLOW_FACTOR = 2;
    private static final int RESTART_COUNTERS = 500;

    public MuxedPQSKM(RatchetSKM ec, RatchetSKM pq) {
        this._ec = ec;
        this._pq = pq;
    }

    public RatchetSKM getECSKM() {
        return this._ec;
    }

    public RatchetSKM getPQSKM() {
        return this._pq;
    }

    boolean preferRatchet() {
        int ec = this._ecCounter.get();
        int pq = this._pqCounter.get();
        if (ec > 50 && pq > 50 && ec + pq > 500) {
            this._ecCounter.set(0);
            this._pqCounter.set(0);
            return true;
        }
        return ec >= pq / 2;
    }

    void reportDecryptResult(boolean isRatchet, boolean success) {
        if (success) {
            if (isRatchet) {
                this._ecCounter.incrementAndGet();
            } else {
                this._pqCounter.incrementAndGet();
            }
        }
    }

    @Override
    public SessionKey getCurrentKey(PublicKey target) {
        return null;
    }

    @Override
    public SessionKey getCurrentOrNewKey(PublicKey target) {
        return null;
    }

    @Override
    public void createSession(PublicKey target, SessionKey key) {
    }

    @Override
    public SessionKey createSession(PublicKey target) {
        return null;
    }

    @Override
    public SessionTag consumeNextAvailableTag(PublicKey target, SessionKey key) {
        return null;
    }

    public RatchetEntry consumeNextAvailableTag(PublicKey target) {
        EncType type = target.getType();
        if (type == EncType.ECIES_X25519) {
            return this._ec.consumeNextAvailableTag(target);
        }
        return this._pq.consumeNextAvailableTag(target);
    }

    @Override
    public int getTagsToSend() {
        return 0;
    }

    @Override
    public int getLowThreshold() {
        return 0;
    }

    @Override
    public boolean shouldSendTags(PublicKey target, SessionKey key) {
        return false;
    }

    @Override
    public boolean shouldSendTags(PublicKey target, SessionKey key, int lowThreshold) {
        return false;
    }

    @Override
    public int getAvailableTags(PublicKey target, SessionKey key) {
        EncType type = target.getType();
        if (type == EncType.ECIES_X25519) {
            return this._ec.getAvailableTags(target, key);
        }
        return this._pq.getAvailableTags(target, key);
    }

    @Override
    public long getAvailableTimeLeft(PublicKey target, SessionKey key) {
        EncType type = target.getType();
        if (type == EncType.ECIES_X25519) {
            return this._ec.getAvailableTimeLeft(target, key);
        }
        return this._pq.getAvailableTimeLeft(target, key);
    }

    @Override
    public TagSetHandle tagsDelivered(PublicKey target, SessionKey key, Set<SessionTag> sessionTags) {
        return null;
    }

    @Override
    public void tagsReceived(SessionKey key, Set<SessionTag> sessionTags) {
    }

    @Override
    public void tagsReceived(SessionKey key, Set<SessionTag> sessionTags, long expire) {
    }

    public void tagsReceived(SessionKey key, RatchetSessionTag tag, long expire) {
        this._ec.tagsReceived(key, tag, expire);
    }

    @Override
    public SessionKey consumeTag(SessionTag tag) {
        RatchetSessionTag rstag = new RatchetSessionTag(tag.getData());
        SessionKeyAndNonce rv = this._ec.consumeTag(rstag);
        if (rv == null) {
            rv = this._pq.consumeTag(rstag);
        }
        return rv;
    }

    @Override
    public void shutdown() {
        this._ec.shutdown();
        this._pq.shutdown();
    }

    @Override
    public void renderStatusHTML(Writer out) throws IOException {
        this._ec.renderStatusHTML(out);
        this._pq.renderStatusHTML(out);
    }

    @Override
    public void failTags(PublicKey target, SessionKey key, TagSetHandle ts) {
    }

    @Override
    public void tagsAcked(PublicKey target, SessionKey key, TagSetHandle ts) {
    }
}

