/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.health;

import java.security.AccessController;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.spi.HealthCheckResponseProvider;

public class HealthCheckResponse {
    private static final Logger LOGGER = Logger.getLogger(HealthCheckResponse.class.getName());
    private static volatile HealthCheckResponseProvider provider = null;
    private final String name;
    private final Status status;
    private final Optional<Map<String, Object>> data;

    public HealthCheckResponse(String name, Status status, Optional<Map<String, Object>> data) {
        this.name = name;
        this.status = status;
        this.data = data;
    }

    public HealthCheckResponse() {
        this.name = null;
        this.status = null;
        this.data = null;
    }

    public static void setResponseProvider(HealthCheckResponseProvider provider) {
        HealthCheckResponse.provider = provider;
    }

    public static HealthCheckResponseBuilder named(String name) {
        return HealthCheckResponse.getProvider().createResponseBuilder().name(name);
    }

    public static HealthCheckResponseBuilder builder() {
        return HealthCheckResponse.getProvider().createResponseBuilder();
    }

    public static HealthCheckResponse up(String name) {
        return HealthCheckResponse.named(name).up().build();
    }

    public static HealthCheckResponse down(String name) {
        return HealthCheckResponse.named(name).down().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HealthCheckResponseProvider getProvider() {
        if (provider != null) return provider;
        Class<HealthCheckResponse> clazz = HealthCheckResponse.class;
        synchronized (HealthCheckResponse.class) {
            if (provider != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return provider;
            }
            HealthCheckResponseProvider newInstance = HealthCheckResponse.find(HealthCheckResponseProvider.class);
            if (newInstance == null) {
                throw new IllegalStateException("No HealthCheckResponseProvider implementation found!");
            }
            provider = newInstance;
            // ** MonitorExit[var0] (shouldn't be in output)
            return provider;
        }
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public Optional<Map<String, Object>> getData() {
        return this.data;
    }

    private static <T> T find(Class<T> service) {
        T serviceInstance = HealthCheckResponse.find(service, HealthCheckResponse.getContextClassLoader());
        if (null == serviceInstance) {
            serviceInstance = HealthCheckResponse.find(service, HealthCheckResponse.class.getClassLoader());
        }
        if (null == serviceInstance) {
            throw new IllegalStateException("Unable to find service " + service.getName());
        }
        return serviceInstance;
    }

    private static <T> T find(Class<T> service, ClassLoader cl) {
        Object serviceInstance = null;
        try {
            ServiceLoader<T> services = ServiceLoader.load(service, cl);
            for (T spi : services) {
                if (serviceInstance != null) {
                    throw new IllegalStateException("Multiple service implementations found: " + spi.getClass().getName() + " and " + serviceInstance.getClass().getName());
                }
                serviceInstance = spi;
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Error loading service " + service.getName() + ".", t);
        }
        return (T)serviceInstance;
    }

    private static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(() -> {
            ClassLoader cl = null;
            try {
                cl = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException ex) {
                LOGGER.log(Level.WARNING, "Unable to get context classloader instance.", ex);
            }
            return cl;
        });
    }

    public static enum Status {
        UP,
        DOWN;

    }
}

