<?php
/**
 * CellsService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * CellsService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CellsService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation deleteDashboardsIDCellsID
     *
     * Delete a dashboard cell
     *
     * @param  string $dashboard_id The ID of the dashboard to delete. (required)
     * @param  string $cell_id The ID of the cell to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteDashboardsIDCellsID($dashboard_id, $cell_id, $zap_trace_span = null)
    {
        $this->deleteDashboardsIDCellsIDWithHttpInfo($dashboard_id, $cell_id, $zap_trace_span);
    }

    /**
     * Operation deleteDashboardsIDCellsIDWithHttpInfo
     *
     * Delete a dashboard cell
     *
     * @param  string $dashboard_id The ID of the dashboard to delete. (required)
     * @param  string $cell_id The ID of the cell to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDashboardsIDCellsIDWithHttpInfo($dashboard_id, $cell_id, $zap_trace_span = null)
    {
        $request = $this->deleteDashboardsIDCellsIDRequest($dashboard_id, $cell_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteDashboardsIDCellsID'
     *
     * @param  string $dashboard_id The ID of the dashboard to delete. (required)
     * @param  string $cell_id The ID of the cell to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteDashboardsIDCellsIDRequest($dashboard_id, $cell_id, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling deleteDashboardsIDCellsID'
            );
        }
        // verify the required parameter 'cell_id' is set
        if ($cell_id === null || (is_array($cell_id) && count($cell_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cell_id when calling deleteDashboardsIDCellsID'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/cells/{cellID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }
        // path params
        if ($cell_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cellID' . '}',
                ObjectSerializer::toPathValue($cell_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getDashboardsIDCellsIDView
     *
     * Retrieve the view for a cell
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $cell_id The cell ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\View|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function getDashboardsIDCellsIDView($dashboard_id, $cell_id, $zap_trace_span = null)
    {
        list($response) = $this->getDashboardsIDCellsIDViewWithHttpInfo($dashboard_id, $cell_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getDashboardsIDCellsIDViewWithHttpInfo
     *
     * Retrieve the view for a cell
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $cell_id The cell ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\View|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDashboardsIDCellsIDViewWithHttpInfo($dashboard_id, $cell_id, $zap_trace_span = null)
    {
        $request = $this->getDashboardsIDCellsIDViewRequest($dashboard_id, $cell_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\View';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getDashboardsIDCellsIDView'
     *
     * @param  string $dashboard_id The dashboard ID. (required)
     * @param  string $cell_id The cell ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getDashboardsIDCellsIDViewRequest($dashboard_id, $cell_id, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling getDashboardsIDCellsIDView'
            );
        }
        // verify the required parameter 'cell_id' is set
        if ($cell_id === null || (is_array($cell_id) && count($cell_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cell_id when calling getDashboardsIDCellsIDView'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/cells/{cellID}/view';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }
        // path params
        if ($cell_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cellID' . '}',
                ObjectSerializer::toPathValue($cell_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchDashboardsIDCellsID
     *
     * Update the non-positional information related to a cell
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $cell_id The ID of the cell to update. (required)
     * @param  \InfluxDB2\Model\CellUpdate $cell_update cell_update (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Cell|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function patchDashboardsIDCellsID($dashboard_id, $cell_id, $cell_update, $zap_trace_span = null)
    {
        list($response) = $this->patchDashboardsIDCellsIDWithHttpInfo($dashboard_id, $cell_id, $cell_update, $zap_trace_span);
        return $response;
    }

    /**
     * Operation patchDashboardsIDCellsIDWithHttpInfo
     *
     * Update the non-positional information related to a cell
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $cell_id The ID of the cell to update. (required)
     * @param  \InfluxDB2\Model\CellUpdate $cell_update (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Cell|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchDashboardsIDCellsIDWithHttpInfo($dashboard_id, $cell_id, $cell_update, $zap_trace_span = null)
    {
        $request = $this->patchDashboardsIDCellsIDRequest($dashboard_id, $cell_id, $cell_update, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Cell';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchDashboardsIDCellsID'
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $cell_id The ID of the cell to update. (required)
     * @param  \InfluxDB2\Model\CellUpdate $cell_update (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchDashboardsIDCellsIDRequest($dashboard_id, $cell_id, $cell_update, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling patchDashboardsIDCellsID'
            );
        }
        // verify the required parameter 'cell_id' is set
        if ($cell_id === null || (is_array($cell_id) && count($cell_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cell_id when calling patchDashboardsIDCellsID'
            );
        }
        // verify the required parameter 'cell_update' is set
        if ($cell_update === null || (is_array($cell_update) && count($cell_update) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cell_update when calling patchDashboardsIDCellsID'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/cells/{cellID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }
        // path params
        if ($cell_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cellID' . '}',
                ObjectSerializer::toPathValue($cell_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($cell_update)) {
            $_tempBody = $cell_update;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchDashboardsIDCellsIDView
     *
     * Update the view for a cell
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $cell_id The ID of the cell to update. (required)
     * @param  \InfluxDB2\Model\View $view view (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\View|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function patchDashboardsIDCellsIDView($dashboard_id, $cell_id, $view, $zap_trace_span = null)
    {
        list($response) = $this->patchDashboardsIDCellsIDViewWithHttpInfo($dashboard_id, $cell_id, $view, $zap_trace_span);
        return $response;
    }

    /**
     * Operation patchDashboardsIDCellsIDViewWithHttpInfo
     *
     * Update the view for a cell
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $cell_id The ID of the cell to update. (required)
     * @param  \InfluxDB2\Model\View $view (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\View|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchDashboardsIDCellsIDViewWithHttpInfo($dashboard_id, $cell_id, $view, $zap_trace_span = null)
    {
        $request = $this->patchDashboardsIDCellsIDViewRequest($dashboard_id, $cell_id, $view, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\View';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchDashboardsIDCellsIDView'
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  string $cell_id The ID of the cell to update. (required)
     * @param  \InfluxDB2\Model\View $view (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchDashboardsIDCellsIDViewRequest($dashboard_id, $cell_id, $view, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling patchDashboardsIDCellsIDView'
            );
        }
        // verify the required parameter 'cell_id' is set
        if ($cell_id === null || (is_array($cell_id) && count($cell_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cell_id when calling patchDashboardsIDCellsIDView'
            );
        }
        // verify the required parameter 'view' is set
        if ($view === null || (is_array($view) && count($view) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $view when calling patchDashboardsIDCellsIDView'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/cells/{cellID}/view';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }
        // path params
        if ($cell_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cellID' . '}',
                ObjectSerializer::toPathValue($cell_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($view)) {
            $_tempBody = $view;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postDashboardsIDCells
     *
     * Create a dashboard cell
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  \InfluxDB2\Model\CreateCell $create_cell Cell that will be added (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Cell|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function postDashboardsIDCells($dashboard_id, $create_cell, $zap_trace_span = null)
    {
        list($response) = $this->postDashboardsIDCellsWithHttpInfo($dashboard_id, $create_cell, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postDashboardsIDCellsWithHttpInfo
     *
     * Create a dashboard cell
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  \InfluxDB2\Model\CreateCell $create_cell Cell that will be added (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Cell|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postDashboardsIDCellsWithHttpInfo($dashboard_id, $create_cell, $zap_trace_span = null)
    {
        $request = $this->postDashboardsIDCellsRequest($dashboard_id, $create_cell, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Cell';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postDashboardsIDCells'
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  \InfluxDB2\Model\CreateCell $create_cell Cell that will be added (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postDashboardsIDCellsRequest($dashboard_id, $create_cell, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling postDashboardsIDCells'
            );
        }
        // verify the required parameter 'create_cell' is set
        if ($create_cell === null || (is_array($create_cell) && count($create_cell) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_cell when calling postDashboardsIDCells'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/cells';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($create_cell)) {
            $_tempBody = $create_cell;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation putDashboardsIDCells
     *
     * Replace cells in a dashboard
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  \InfluxDB2\Model\Cell[] $cell cell (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Dashboard|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function putDashboardsIDCells($dashboard_id, $cell, $zap_trace_span = null)
    {
        list($response) = $this->putDashboardsIDCellsWithHttpInfo($dashboard_id, $cell, $zap_trace_span);
        return $response;
    }

    /**
     * Operation putDashboardsIDCellsWithHttpInfo
     *
     * Replace cells in a dashboard
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  \InfluxDB2\Model\Cell[] $cell (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Dashboard|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function putDashboardsIDCellsWithHttpInfo($dashboard_id, $cell, $zap_trace_span = null)
    {
        $request = $this->putDashboardsIDCellsRequest($dashboard_id, $cell, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Dashboard';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'putDashboardsIDCells'
     *
     * @param  string $dashboard_id The ID of the dashboard to update. (required)
     * @param  \InfluxDB2\Model\Cell[] $cell (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function putDashboardsIDCellsRequest($dashboard_id, $cell, $zap_trace_span = null)
    {
        // verify the required parameter 'dashboard_id' is set
        if ($dashboard_id === null || (is_array($dashboard_id) && count($dashboard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dashboard_id when calling putDashboardsIDCells'
            );
        }
        // verify the required parameter 'cell' is set
        if ($cell === null || (is_array($cell) && count($cell) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cell when calling putDashboardsIDCells'
            );
        }

        $resourcePath = '/api/v2/dashboards/{dashboardID}/cells';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($dashboard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dashboardID' . '}',
                ObjectSerializer::toPathValue($dashboard_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($cell)) {
            $_tempBody = $cell;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PUT', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
