/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.page;

import java.util.Map;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.CounterStore;
import org.jfree.layouting.renderer.StringStore;
import org.jfree.layouting.renderer.model.page.DefaultPageGrid;
import org.jfree.layouting.renderer.model.page.PageGrid;

public class RenderPageContext
implements StatefullComponent {
    private PageContext pageContext;
    private CounterStore counterStore;
    private StringStore stringStore;

    public RenderPageContext(LayoutProcess layoutProcess, PageContext pageContext) {
        if (pageContext == null) {
            throw new NullPointerException();
        }
        if (layoutProcess == null) {
            throw new NullPointerException();
        }
        this.pageContext = pageContext;
        this.counterStore = new CounterStore();
        this.stringStore = new StringStore();
        this.counterStore.add("page", new Integer(layoutProcess.getOutputProcessor().getPageCursor() + 1));
        this.counterStore.add("pages", new Integer(layoutProcess.getOutputProcessor().getLogicalPageCount()));
    }

    protected RenderPageContext() {
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public RenderPageContext update(PageContext pageContext, OutputProcessor outputProcessor) {
        RenderPageContext renderPageContext = new RenderPageContext();
        renderPageContext.pageContext = pageContext;
        renderPageContext.counterStore = (CounterStore)this.counterStore.derive();
        renderPageContext.stringStore = (StringStore)this.stringStore.derive();
        renderPageContext.counterStore.add("page", new Integer(outputProcessor.getPageCursor() + 1));
        return renderPageContext;
    }

    public RenderPageContext update(LayoutContext layoutContext) {
        Object object;
        Map map = layoutContext.getCounters();
        Map map2 = layoutContext.getStrings();
        for (Map.Entry object2 : map.entrySet()) {
            String string = (String)object2.getKey();
            object = (Integer)object2.getValue();
            this.counterStore.add(string, (Integer)object);
        }
        for (Map.Entry entry : map2.entrySet()) {
            object = (String)entry.getKey();
            String string = (String)entry.getValue();
            this.stringStore.add((String)object, string);
        }
        return this;
    }

    public PageGrid createPageGrid(OutputProcessorMetaData outputProcessorMetaData) {
        return new DefaultPageGrid(this.pageContext, outputProcessorMetaData);
    }

    public String getString(String string, CSSValue cSSValue) {
        return this.stringStore.get(string, cSSValue);
    }

    public Integer getCounter(String string, CSSValue cSSValue) {
        return this.counterStore.get(string, cSSValue);
    }

    public Object clone() {
        try {
            RenderPageContext renderPageContext = (RenderPageContext)super.clone();
            renderPageContext.counterStore = (CounterStore)this.counterStore.clone();
            renderPageContext.stringStore = (StringStore)this.stringStore.clone();
            return renderPageContext;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone must be supported.");
        }
    }

    @Override
    public State saveState() throws StateException {
        return new RenderPageContextState(this);
    }

    private static class RenderPageContextState
    implements State {
        private CounterStore counterStore;
        private StringStore stringStore;
        private PageContext pageContext;

        private RenderPageContextState(RenderPageContext renderPageContext) throws StateException {
            try {
                this.pageContext = renderPageContext.pageContext;
                this.counterStore = (CounterStore)renderPageContext.counterStore.clone();
                this.stringStore = (StringStore)renderPageContext.stringStore.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new StateException("Clone failed.");
            }
        }

        @Override
        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            try {
                RenderPageContext renderPageContext = new RenderPageContext();
                renderPageContext.pageContext = this.pageContext;
                renderPageContext.counterStore = (CounterStore)this.counterStore.clone();
                renderPageContext.stringStore = (StringStore)this.stringStore.clone();
                renderPageContext.counterStore.add("pages", new Integer(layoutProcess.getOutputProcessor().getLogicalPageCount()));
                return renderPageContext;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new StateException("Clone failed.");
            }
        }
    }
}

