/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISequentialRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegmentDiff;

public class SequentialRegionDiff
implements Comparable<SequentialRegionDiff>,
ITextSegmentDiff {
    private final ITextSegment originalFirst;
    private final ITextSegment originalLast;
    private final ITextSegment substituteFirst;
    private final ITextSegment substituteLast;

    public SequentialRegionDiff(ISequentialRegion originalFirst, ISequentialRegion originalLast) {
        this(originalFirst, originalLast, null, null);
    }

    public SequentialRegionDiff(ITextSegment originalFirst, ITextSegment originalLast, ITextSegment substituteFirst, ITextSegment substituteLast) {
        this.originalFirst = originalFirst;
        this.originalLast = originalLast;
        this.substituteFirst = substituteFirst;
        this.substituteLast = substituteLast;
    }

    @Override
    public int compareTo(SequentialRegionDiff o) {
        return this.originalFirst.compareTo(o.originalFirst);
    }

    @Override
    public ITextSegment getModifiedFirstRegion() {
        return this.substituteFirst;
    }

    @Override
    public ITextSegment getModifiedLastRegion() {
        return this.substituteLast;
    }

    @Override
    public ITextSegment getModifiedRegion() {
        if (this.isSingleSemanticRegion()) {
            return this.substituteFirst;
        }
        return this.getRegion(this.substituteFirst, this.substituteLast);
    }

    @Override
    public ITextSegment getOriginalFirstRegion() {
        return this.originalFirst;
    }

    @Override
    public ITextSegment getOriginalLastRegion() {
        return this.originalLast;
    }

    @Override
    public ITextSegment getOriginalRegion() {
        if (this.isSingleSemanticRegion()) {
            return this.originalFirst;
        }
        return this.getRegion(this.originalFirst, this.originalLast);
    }

    protected ITextSegment getRegion(ITextSegment first, ITextSegment last) {
        int offset = first instanceof IHiddenRegion ? first.getOffset() : first.getEndOffset();
        int endOffset = last instanceof IHiddenRegion ? last.getEndOffset() : last.getOffset();
        return first.getTextRegionAccess().regionForOffset(offset, endOffset - offset);
    }

    protected boolean isSingleSemanticRegion() {
        return this.originalFirst == this.originalLast && this.substituteFirst == this.substituteLast && this.originalFirst instanceof ISemanticRegion && this.substituteFirst instanceof ISemanticRegion;
    }
}

