/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.osgi;

import java.io.Closeable;
import java.util.HashMap;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.CommandSessionListener;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class EventAdminListener
implements CommandSessionListener,
Closeable {
    private ServiceTracker<EventAdmin, EventAdmin> tracker;

    public EventAdminListener(BundleContext bundleContext) {
        this.tracker = new ServiceTracker(bundleContext, EventAdmin.class.getName(), null);
        this.tracker.open();
    }

    @Override
    public void close() {
        this.tracker.close();
    }

    @Override
    public void beforeExecute(CommandSession session, CharSequence command) {
    }

    @Override
    public void afterExecute(CommandSession session, CharSequence command, Exception exception) {
        this.sendEvent(session, command, null, exception);
    }

    @Override
    public void afterExecute(CommandSession session, CharSequence command, Object result) {
        this.sendEvent(session, command, result, null);
    }

    private void sendEvent(CommandSession session, CharSequence command, Object result, Exception exception) {
        EventAdmin admin = (EventAdmin)this.tracker.getService();
        if (admin != null) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            Object script = session.get("script");
            if (script != null) {
                props.put("script", script.toString());
            } else if (command.toString().trim().length() > 0) {
                props.put("command", command.toString());
            }
            if (result != null) {
                props.put("result", result);
            }
            if (exception != null) {
                props.put("exception", exception);
            }
            Event event = new Event("org/apache/karaf/shell/console/EXECUTED", props);
            admin.postEvent(event);
        }
    }
}

