/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.types;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.internal.types.StateDescriptionFragmentImpl;
import org.openhab.core.types.StateDescription;
import org.openhab.core.types.StateDescriptionFragment;
import org.openhab.core.types.StateOption;

@NonNullByDefault
public class StateDescriptionFragmentBuilder {
    private @Nullable BigDecimal minimum;
    private @Nullable BigDecimal maximum;
    private @Nullable BigDecimal step;
    private @Nullable String pattern;
    private @Nullable Boolean readOnly;
    private @Nullable List<StateOption> options;

    private StateDescriptionFragmentBuilder() {
    }

    private StateDescriptionFragmentBuilder(StateDescriptionFragment fragment) {
        this.minimum = fragment.getMinimum();
        this.maximum = fragment.getMaximum();
        this.step = fragment.getStep();
        this.pattern = fragment.getPattern();
        this.readOnly = fragment.isReadOnly();
        List<StateOption> stateOptions = fragment.getOptions();
        if (stateOptions != null && !stateOptions.isEmpty()) {
            this.options = new ArrayList<StateOption>(stateOptions);
        }
    }

    private StateDescriptionFragmentBuilder(StateDescription legacy) {
        this.minimum = legacy.getMinimum();
        this.maximum = legacy.getMaximum();
        this.step = legacy.getStep();
        this.pattern = legacy.getPattern();
        this.readOnly = legacy.isReadOnly();
        if (!legacy.getOptions().isEmpty()) {
            this.options = new ArrayList<StateOption>(legacy.getOptions());
        }
    }

    public static StateDescriptionFragmentBuilder create() {
        return new StateDescriptionFragmentBuilder();
    }

    public static StateDescriptionFragmentBuilder create(StateDescriptionFragment fragment) {
        return new StateDescriptionFragmentBuilder(fragment);
    }

    public static StateDescriptionFragmentBuilder create(StateDescription legacy) {
        return new StateDescriptionFragmentBuilder(legacy);
    }

    public StateDescriptionFragment build() {
        return new StateDescriptionFragmentImpl(this.minimum, this.maximum, this.step, this.pattern, this.readOnly, this.options);
    }

    public StateDescriptionFragmentBuilder withMaximum(BigDecimal maximum) {
        this.maximum = maximum;
        return this;
    }

    public StateDescriptionFragmentBuilder withMinimum(BigDecimal minimum) {
        this.minimum = minimum;
        return this;
    }

    public StateDescriptionFragmentBuilder withStep(BigDecimal step) {
        this.step = step;
        return this;
    }

    public StateDescriptionFragmentBuilder withPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public StateDescriptionFragmentBuilder withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public StateDescriptionFragmentBuilder withOption(StateOption option) {
        if (this.options == null) {
            this.options = new ArrayList<StateOption>();
        }
        this.options.add(option);
        return this;
    }

    public StateDescriptionFragmentBuilder withOptions(List<StateOption> options) {
        this.options = options;
        return this;
    }
}

