/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.commands;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.internal.commands.AbstractCommandProvider;
import org.openhab.core.automation.parser.Parser;
import org.openhab.core.automation.parser.ParsingException;
import org.openhab.core.automation.parser.ParsingNestedException;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.ModuleTypeProvider;
import org.openhab.core.automation.type.ModuleTypeRegistry;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.common.registry.ProviderChangeListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

@NonNullByDefault
public class CommandlineModuleTypeProvider
extends AbstractCommandProvider<ModuleType>
implements ModuleTypeProvider {
    protected @Nullable ServiceRegistration mtpReg;
    private final ModuleTypeRegistry moduleTypeRegistry;

    public CommandlineModuleTypeProvider(BundleContext bundleContext, ModuleTypeRegistry moduleTypeRegistry) {
        super(bundleContext);
        this.mtpReg = bundleContext.registerService(ModuleTypeProvider.class.getName(), (Object)this, null);
        this.moduleTypeRegistry = moduleTypeRegistry;
    }

    @Override
    public @Nullable Object addingService(@Nullable ServiceReference reference) {
        if (reference != null && "parser.module.type".equals(reference.getProperty("parser.type"))) {
            return super.addingService(reference);
        }
        return null;
    }

    public String exportModuleTypes(String parserType, Set<ModuleType> set, File file) throws Exception {
        return super.exportData(parserType, set, file);
    }

    public Set<ModuleType> importModuleTypes(String parserType, URL url) throws IOException, ParsingException {
        Parser parser = (Parser)this.parsers.get(parserType);
        if (parser != null) {
            InputStream is = url.openStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            try (InputStreamReader inputStreamReader = new InputStreamReader(bis);){
                Set<ModuleType> set = this.importData(url, parser, inputStreamReader);
                return set;
            }
        }
        throw new ParsingException(new ParsingNestedException(1, null, new IllegalArgumentException("Parser " + parserType + " not available")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable ModuleType getModuleType(String uid, @Nullable Locale locale) {
        Map map = this.providedObjectsHolder;
        synchronized (map) {
            return (ModuleType)this.providedObjectsHolder.get(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ModuleType> getModuleTypes(@Nullable Locale locale) {
        Map map = this.providedObjectsHolder;
        synchronized (map) {
            return !this.providedObjectsHolder.isEmpty() ? this.providedObjectsHolder.values() : List.of();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String remove(URL url) {
        List portfolio;
        Map map = this.providerPortfolio;
        synchronized (map) {
            portfolio = (List)this.providerPortfolio.remove(url);
        }
        if (portfolio != null && !portfolio.isEmpty()) {
            map = this.providedObjectsHolder;
            synchronized (map) {
                for (String uid : portfolio) {
                    this.notifyListeners((ModuleType)this.providedObjectsHolder.remove(uid));
                }
            }
        }
        return "SUCCESS";
    }

    @Override
    public void close() {
        if (this.mtpReg != null) {
            this.mtpReg.unregister();
            this.mtpReg = null;
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<ModuleType> importData(URL url, Parser<ModuleType> parser, InputStreamReader inputStreamReader) throws ParsingException {
        Set<ModuleType> providedObjects = parser.parse(inputStreamReader);
        if (providedObjects != null && !providedObjects.isEmpty()) {
            ArrayList<String> portfolio = new ArrayList<String>();
            Map map = this.providerPortfolio;
            synchronized (map) {
                this.providerPortfolio.put(url, portfolio);
            }
            ArrayList<ParsingNestedException> importDataExceptions = new ArrayList<ParsingNestedException>();
            for (ModuleType providedObject : providedObjects) {
                ArrayList<ParsingNestedException> exceptions = new ArrayList<ParsingNestedException>();
                String uid = providedObject.getUID();
                this.checkExistence(uid, exceptions);
                if (exceptions.isEmpty()) {
                    portfolio.add(uid);
                    Map map2 = this.providedObjectsHolder;
                    synchronized (map2) {
                        this.notifyListeners(this.providedObjectsHolder.put(uid, providedObject), providedObject);
                        continue;
                    }
                }
                importDataExceptions.addAll(exceptions);
            }
            if (!importDataExceptions.isEmpty()) {
                throw new ParsingException(importDataExceptions);
            }
        }
        return providedObjects;
    }

    protected void checkExistence(String uid, List<ParsingNestedException> exceptions) {
        if (this.moduleTypeRegistry == null) {
            exceptions.add(new ParsingNestedException(1, uid, new IllegalArgumentException("Failed to create Module Type with UID \"" + uid + "\"! Can't guarantee yet that other Module Type with the same UID does not exist.")));
        }
        if (this.moduleTypeRegistry.get(uid) != null) {
            exceptions.add(new ParsingNestedException(1, uid, new IllegalArgumentException("Module Type with UID \"" + uid + "\" already exists! Failed to create a second with the same UID!")));
        }
    }

    public Collection<ModuleType> getAll() {
        return new LinkedList<ModuleType>(this.providedObjectsHolder.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(@Nullable ModuleType oldElement, ModuleType newElement) {
        List list = this.listeners;
        synchronized (list) {
            for (ProviderChangeListener listener : this.listeners) {
                if (oldElement != null) {
                    listener.updated((Provider)this, (Object)oldElement, (Object)newElement);
                }
                listener.added((Provider)this, (Object)newElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(@Nullable ModuleType removedObject) {
        if (removedObject != null) {
            List list = this.listeners;
            synchronized (list) {
                for (ProviderChangeListener listener : this.listeners) {
                    listener.removed((Provider)this, (Object)removedObject);
                }
            }
        }
    }
}

