/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.server.data;

import com.projectlibre1.pm.key.uniqueid.UniqueIdException;
import com.projectlibre1.server.data.DataObject;
import com.projectlibre1.server.data.IDGenerator;
import com.projectlibre1.session.SessionFactory;

public class CommonDataObject
implements DataObject {
    static final long serialVersionUID = 182832738299990L;
    protected long uniqueId = -1L;
    protected String name;

    @Override
    public long getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void setUniqueId(long l) {
        this.uniqueId = l;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public boolean isLocal() {
        return CommonDataObject.isLocal(this);
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void setDirty(boolean bl) {
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DataObject)) {
            return false;
        }
        return ((DataObject)object).getUniqueId() == this.getUniqueId();
    }

    public static boolean isLocal(DataObject dataObject) {
        return CommonDataObject.isLocal(dataObject.getUniqueId());
    }

    public static boolean isLocal(long l) {
        return l < 1000000000L;
    }

    public static void makeGlobal(DataObject dataObject) throws UniqueIdException {
        if (CommonDataObject.isLocal(dataObject)) {
            dataObject.setUniqueId(SessionFactory.getInstance().getSession(false).getId());
        }
    }

    public void renumber(IDGenerator iDGenerator) {
        this.setUniqueId(iDGenerator.getId(this.getUniqueId()));
    }
}

