/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.Servlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.plus.jaas.JAASUserRealm;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.www.AddExportServlet;
import org.pentaho.di.www.AddJobServlet;
import org.pentaho.di.www.AddTransServlet;
import org.pentaho.di.www.AllocateServerSocketServlet;
import org.pentaho.di.www.CleanupTransServlet;
import org.pentaho.di.www.GetJobStatusServlet;
import org.pentaho.di.www.GetRootServlet;
import org.pentaho.di.www.GetSlavesServlet;
import org.pentaho.di.www.GetStatusServlet;
import org.pentaho.di.www.GetTransStatusServlet;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.Messages;
import org.pentaho.di.www.PauseTransServlet;
import org.pentaho.di.www.PrepareExecutionTransServlet;
import org.pentaho.di.www.RegisterSlaveServlet;
import org.pentaho.di.www.SlaveServerDetection;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.StartExecutionTransServlet;
import org.pentaho.di.www.StartJobServlet;
import org.pentaho.di.www.StartTransServlet;
import org.pentaho.di.www.StopJobServlet;
import org.pentaho.di.www.StopTransServlet;
import org.pentaho.di.www.TransformationMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServer {
    private static LogWriter log = LogWriter.getInstance();
    public static final int PORT = 80;
    private Server server;
    private TransformationMap transformationMap;
    private JobMap jobMap;
    private List<SlaveServerDetection> detections;
    private SocketRepository socketRepository;
    private String hostname;
    private int port;

    public WebServer(TransformationMap transformationMap, JobMap jobMap, SocketRepository socketRepository, List<SlaveServerDetection> detections, String hostname, int port, boolean join) throws Exception {
        this.transformationMap = transformationMap;
        this.jobMap = jobMap;
        this.socketRepository = socketRepository;
        this.detections = detections;
        this.hostname = hostname;
        this.port = port;
        this.startServer();
        this.startSlaveMonitoring();
        if (join) {
            this.server.join();
        }
    }

    public WebServer(TransformationMap transformationMap, JobMap jobMap, SocketRepository socketRepository, List<SlaveServerDetection> slaveServers, String hostname, int port) throws Exception {
        this(transformationMap, jobMap, socketRepository, slaveServers, hostname, port, true);
    }

    public Server getServer() {
        return this.server;
    }

    public void startServer() throws Exception {
        this.server = new Server();
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"*"});
        constraint.setAuthenticate(true);
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec("/*");
        SecurityHandler securityHandler = new SecurityHandler();
        if (System.getProperty("loginmodulename") != null && System.getProperty("java.security.auth.login.config") != null) {
            JAASUserRealm jaasRealm = new JAASUserRealm("Kettle");
            jaasRealm.setLoginModuleName(System.getProperty("loginmodulename"));
            securityHandler.setUserRealm((UserRealm)jaasRealm);
        } else {
            File homePwdFile = new File(Const.getKettleCartePasswordFile());
            if (homePwdFile.exists()) {
                securityHandler.setUserRealm((UserRealm)new HashUserRealm("Kettle", Const.getKettleCartePasswordFile()));
            } else {
                securityHandler.setUserRealm((UserRealm)new HashUserRealm("Kettle", Const.getKettleLocalCartePasswordFile()));
            }
        }
        securityHandler.setConstraintMappings(new ConstraintMapping[]{constraintMapping});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        Context root = new Context((HandlerContainer)contexts, "/", 1);
        root.addServlet(new ServletHolder((Servlet)new GetRootServlet()), "/*");
        Context status = new Context((HandlerContainer)contexts, "/kettle/status", 1);
        status.addServlet(new ServletHolder((Servlet)new GetStatusServlet(this.transformationMap, this.jobMap)), "/*");
        Context transStatus = new Context((HandlerContainer)contexts, "/kettle/transStatus", 1);
        transStatus.addServlet(new ServletHolder((Servlet)new GetTransStatusServlet(this.transformationMap)), "/*");
        Context prepareExecution = new Context((HandlerContainer)contexts, "/kettle/prepareExec", 1);
        prepareExecution.addServlet(new ServletHolder((Servlet)new PrepareExecutionTransServlet(this.transformationMap)), "/*");
        Context startExecution = new Context((HandlerContainer)contexts, "/kettle/startExec", 1);
        startExecution.addServlet(new ServletHolder((Servlet)new StartExecutionTransServlet(this.transformationMap)), "/*");
        Context startTrans = new Context((HandlerContainer)contexts, "/kettle/startTrans", 1);
        startTrans.addServlet(new ServletHolder((Servlet)new StartTransServlet(this.transformationMap)), "/*");
        Context pauseTrans = new Context((HandlerContainer)contexts, "/kettle/pauseTrans", 1);
        pauseTrans.addServlet(new ServletHolder((Servlet)new PauseTransServlet(this.transformationMap)), "/*");
        Context stopTrans = new Context((HandlerContainer)contexts, "/kettle/stopTrans", 1);
        stopTrans.addServlet(new ServletHolder((Servlet)new StopTransServlet(this.transformationMap)), "/*");
        Context cleanupTrans = new Context((HandlerContainer)contexts, "/kettle/cleanupTrans", 1);
        cleanupTrans.addServlet(new ServletHolder((Servlet)new CleanupTransServlet(this.transformationMap)), "/*");
        Context addTrans = new Context((HandlerContainer)contexts, "/kettle/addTrans", 1);
        addTrans.addServlet(new ServletHolder((Servlet)new AddTransServlet(this.transformationMap, this.socketRepository)), "/*");
        Context getPort = new Context((HandlerContainer)contexts, "/kettle/allocateSocket", 1);
        getPort.addServlet(new ServletHolder((Servlet)new AllocateServerSocketServlet(this.transformationMap)), "/*");
        Context startJob = new Context((HandlerContainer)contexts, "/kettle/startJob", 1);
        startJob.addServlet(new ServletHolder((Servlet)new StartJobServlet(this.jobMap)), "/*");
        Context stopJob = new Context((HandlerContainer)contexts, "/kettle/stopJob", 1);
        stopJob.addServlet(new ServletHolder((Servlet)new StopJobServlet(this.jobMap)), "/*");
        Context jobStatus = new Context((HandlerContainer)contexts, "/kettle/jobStatus", 1);
        jobStatus.addServlet(new ServletHolder((Servlet)new GetJobStatusServlet(this.jobMap)), "/*");
        Context addJob = new Context((HandlerContainer)contexts, "/kettle/addJob", 1);
        addJob.addServlet(new ServletHolder((Servlet)new AddJobServlet(this.jobMap, this.socketRepository)), "/*");
        Context registerSlave = new Context((HandlerContainer)contexts, "/kettle/registerSlave", 1);
        registerSlave.addServlet(new ServletHolder((Servlet)new RegisterSlaveServlet(this.detections)), "/*");
        Context getSlaves = new Context((HandlerContainer)contexts, "/kettle/getSlaves", 1);
        getSlaves.addServlet(new ServletHolder((Servlet)new GetSlavesServlet(this.detections)), "/*");
        Context addExport = new Context((HandlerContainer)contexts, "/kettle/addExport", 1);
        addExport.addServlet(new ServletHolder((Servlet)new AddExportServlet(this.jobMap, this.transformationMap)), "/*");
        this.server.setHandlers(new Handler[]{securityHandler, contexts});
        this.createListeners();
        this.server.start();
    }

    public void stopServer() {
        try {
            if (this.server != null) {
                this.socketRepository.closeAll();
                this.server.stop();
            }
        }
        catch (Exception e) {
            log.logError(Messages.getString("WebServer.Error.FailedToStop.Title"), Messages.getString("WebServer.Error.FailedToStop.Msg", "" + e), new Object[0]);
        }
    }

    private void createListeners() {
        SocketConnector connector = new SocketConnector();
        connector.setPort(this.port);
        connector.setHost(this.hostname);
        connector.setName(Messages.getString("WebServer.Log.KettleHTTPListener", this.hostname));
        log.logBasic(this.toString(), Messages.getString("WebServer.Log.CreateListener", this.hostname, "" + this.port), new Object[0]);
        this.server.setConnectors(new Connector[]{connector});
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public List<SlaveServerDetection> getDetections() {
        return this.detections;
    }

    private void startSlaveMonitoring() {
        Timer timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            public void run() {
                for (SlaveServerDetection slaveServerDetection : WebServer.this.detections) {
                    SlaveServer slaveServer = slaveServerDetection.getSlaveServer();
                    try {
                        slaveServer.getStatus();
                        slaveServerDetection.setActive(true);
                        slaveServerDetection.setLastActiveDate(new Date());
                    }
                    catch (Exception e) {
                        slaveServerDetection.setActive(false);
                        slaveServerDetection.setLastInactiveDate(new Date());
                    }
                }
            }
        };
        timer.schedule(timerTask, 20000L, 20000L);
    }

    public SocketRepository getSocketRepository() {
        return this.socketRepository;
    }

    public void setSocketRepository(SocketRepository socketRepository) {
        this.socketRepository = socketRepository;
    }
}

