/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.events;

import org.gradle.internal.logging.events.PromptOutputEvent;

public class TextQuestionPromptEvent
extends PromptOutputEvent {
    private final String question;
    private final String defaultValue;

    public TextQuestionPromptEvent(long timestamp, String question, String defaultValue) {
        super(timestamp);
        this.question = question;
        this.defaultValue = defaultValue;
    }

    public String getQuestion() {
        return this.question;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getPrompt() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.question);
        builder.append(" (default: ");
        builder.append(this.defaultValue);
        builder.append("): ");
        return builder.toString();
    }

    public PromptOutputEvent.PromptResult<String> convert(String text) {
        if (text.isEmpty()) {
            return PromptOutputEvent.PromptResult.response(this.defaultValue);
        }
        return PromptOutputEvent.PromptResult.response(text);
    }
}

