/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.assignment.plugin.k2.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.assignment.plugin.k2.FirAssignAnnotationMatchingServiceKt;
import org.jetbrains.kotlin.assignment.plugin.k2.diagnostics.FirErrorsAssignmentPlugin;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbolKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u0002H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/assignment/plugin/k2/diagnostics/FirAssignmentPluginFunctionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isAssignMethod", "", "kotlin-assignment-compiler-plugin.k2"})
public final class FirAssignmentPluginFunctionChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    public static final FirAssignmentPluginFunctionChecker INSTANCE = new FirAssignmentPluginFunctionChecker();

    private FirAssignmentPluginFunctionChecker() {
        super(MppCheckerKind.Common);
    }

    public void check(@NotNull FirSimpleFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirRegularClassSymbol receiverClassSymbol;
        FirRegularClassSymbol firRegularClassSymbol;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)FirDeclarationOrigin.Source.INSTANCE)) {
            return;
        }
        if (!this.isAssignMethod(declaration)) {
            return;
        }
        if (FirCallableSymbolKt.isExtension((FirCallableSymbol)((FirCallableSymbol)declaration.getSymbol()))) {
            FirResolvedTypeRef firResolvedTypeRef = declaration.getSymbol().getResolvedReceiverTypeRef();
            firRegularClassSymbol = firResolvedTypeRef != null ? FirHelpersKt.toRegularClassSymbol((FirTypeRef)((FirTypeRef)firResolvedTypeRef), (FirSession)context.getSession()) : null;
        } else {
            ConeSimpleKotlinType coneSimpleKotlinType = declaration.getDispatchReceiverType();
            firRegularClassSymbol = receiverClassSymbol = coneSimpleKotlinType != null ? TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)((ConeKotlinType)coneSimpleKotlinType), (FirSession)context.getSession()) : null;
        }
        if (!FirAssignAnnotationMatchingServiceKt.getAnnotationMatchingService(context.getSession()).isAnnotated(receiverClassSymbol)) {
            return;
        }
        if (!ConeBuiltinTypeUtilsKt.isUnit((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)declaration.getReturnTypeRef()))) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirErrorsAssignmentPlugin.INSTANCE.getDECLARATION_ERROR_ASSIGN_METHOD_SHOULD_RETURN_UNIT(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
        }
    }

    private final boolean isAssignMethod(FirSimpleFunction $this$isAssignMethod) {
        return $this$isAssignMethod.getValueParameters().size() == 1 && Intrinsics.areEqual((Object)$this$isAssignMethod.getName(), (Object)OperatorConventions.ASSIGN_METHOD);
    }
}

