/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto.ratchet;

import net.i2p.data.SessionKey;
import net.i2p.router.crypto.ratchet.RatchetSessionTag;
import net.i2p.router.crypto.ratchet.RatchetTagSet;
import net.i2p.router.crypto.ratchet.SessionKeyAndNonce;
import net.i2p.router.crypto.ratchet.SessionTagListener;

class SingleTagSet
extends RatchetTagSet {
    private final RatchetSessionTag _tag;
    private boolean _isUsed;

    public SingleTagSet(SessionTagListener lsnr, SessionKey key, RatchetSessionTag tag, long date, long timeout) {
        super(lsnr, key, date, timeout);
        this._tag = tag;
        lsnr.addTag(tag, this);
    }

    @Override
    public int size() {
        return this._isUsed ? 0 : 1;
    }

    @Override
    public int remaining() {
        return this._isUsed ? 0 : 1;
    }

    @Override
    public SessionKeyAndNonce consume(RatchetSessionTag tag) {
        if (this._isUsed || !tag.equals(this._tag)) {
            return null;
        }
        this._isUsed = true;
        return new SessionKeyAndNonce(this._key.getData(), 0);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[SingleTagSet: 0 ");
        buf.append(this._tag.toBase64());
        buf.append(' ').append(this._key.toBase64());
        buf.append(']');
        return buf.toString();
    }
}

