/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubySymbol;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.targets.simple.ConstantLookupSite;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class LexicalSearchConstInstr
extends OneOperandResultBaseInstr
implements FixedArityInstr {
    private RubySymbol constantName;
    private final ConstantLookupSite site;

    public LexicalSearchConstInstr(Variable result2, Operand definingScope, RubySymbol constantName) {
        super(Operation.LEXICAL_SEARCH_CONST, result2, definingScope);
        assert (result2 != null) : "LexicalSearchConstInstr result is null";
        this.constantName = constantName;
        this.site = new ConstantLookupSite(constantName);
    }

    public Operand getDefiningScope() {
        return this.getOperand1();
    }

    public String getId() {
        return this.constantName.idString();
    }

    public RubySymbol getName() {
        return this.constantName;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + String.valueOf(this.constantName)};
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new LexicalSearchConstInstr(ii.getRenamedVariable(this.result), this.getDefiningScope().cloneForInlining(ii), this.constantName);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getName());
    }

    public static LexicalSearchConstInstr decode(IRReaderDecoder d) {
        return new LexicalSearchConstInstr(d.decodeVariable(), d.decodeOperand(), d.decodeSymbol());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        return this.site.lexicalSearchConst(context, (StaticScope)this.getDefiningScope().retrieve(context, self2, currScope, currDynScope, temp));
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.LexicalSearchConstInstr(this);
    }
}

