/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;

public abstract class ContextAwareBlockBody
extends BlockBody {
    protected StaticScope scope;

    public ContextAwareBlockBody(StaticScope scope, Signature signature) {
        super(signature);
        this.scope = scope;
    }

    protected Frame pre(ThreadContext context, Block block) {
        return context.preYieldSpecificBlock(block.getBinding(), this.scope);
    }

    protected void post(ThreadContext context, Block block, Visibility vis, Frame lastFrame) {
        block.getBinding().getFrame().setVisibility(vis);
        context.postYield(block.getBinding(), lastFrame);
    }

    @Override
    public StaticScope getStaticScope() {
        return this.scope;
    }

    @Override
    public void setStaticScope(StaticScope newScope) {
        this.scope = newScope;
    }
}

