/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.x509;

import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.authenticators.util.AuthenticatorUtils;
import org.keycloak.authentication.authenticators.x509.AbstractX509ClientCertificateAuthenticator;
import org.keycloak.authentication.authenticators.x509.CertificateValidator;
import org.keycloak.authentication.authenticators.x509.X509AuthenticatorConfigModel;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.services.ServicesLogger;

public class X509ClientCertificateAuthenticator
extends AbstractX509ClientCertificateAuthenticator {
    private static final Logger logger = Logger.getLogger(X509ClientCertificateAuthenticator.class);

    @Override
    public void close() {
    }

    public void authenticate(AuthenticationFlowContext context) {
        try {
            UserModel user;
            this.dumpContainerAttributes(context);
            X509Certificate[] certs = this.getCertificateChain(context);
            if (certs == null || certs.length == 0) {
                logger.debug((Object)"[authenticate] x509 client certificate is not available for mutual SSL.");
                context.attempted();
                return;
            }
            this.saveX509CertificateAuditDataToAuthSession(context, certs[0]);
            this.recordX509CertificateAuditDataViaContextEvent(context);
            X509AuthenticatorConfigModel config = null;
            if (context.getAuthenticatorConfig() != null && context.getAuthenticatorConfig().getConfig() != null) {
                config = new X509AuthenticatorConfigModel(context.getAuthenticatorConfig());
            }
            if (config == null) {
                logger.warn((Object)"[authenticate] x509 Client Certificate Authentication configuration is not available.");
                context.challenge(this.createInfoResponse(context, "X509 client authentication has not been configured yet", new Object[0]));
                context.attempted();
                return;
            }
            try {
                CertificateValidator.CertificateValidatorBuilder builder = this.certificateValidationParameters(context.getSession(), config);
                CertificateValidator validator = builder.build(certs);
                validator.checkRevocationStatus().validateTrust().validateKeyUsage().validateExtendedKeyUsage().validatePolicy().validateTimestamps();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                String errorMessage = "Certificate validation's failed.";
                context.challenge(this.createErrorResponse(context, certs[0].getSubjectDN().getName(), errorMessage, "Certificate revoked or incorrect."));
                context.attempted();
                return;
            }
            Object userIdentity = this.getUserIdentityExtractor(config).extractUserIdentity(certs);
            if (userIdentity == null) {
                context.getEvent().error("invalid_user_credentials");
                logger.warnf("[authenticate] Unable to extract user identity from certificate.", new Object[0]);
                String errorMessage = "Unable to extract user identity from specified certificate";
                context.challenge(this.createErrorResponse(context, certs[0].getSubjectDN().getName(), errorMessage, new String[0]));
                context.attempted();
                return;
            }
            try {
                context.getEvent().detail("username", userIdentity.toString());
                context.getAuthenticationSession().setAuthNote("ATTEMPTED_USERNAME", userIdentity.toString());
                user = this.getUserIdentityToModelMapper(config).find(context, userIdentity);
            }
            catch (ModelDuplicateException e) {
                ServicesLogger.LOGGER.modelDuplicateException(e);
                String errorMessage = "X509 certificate authentication's failed.";
                context.challenge(this.createErrorResponse(context, certs[0].getSubjectDN().getName(), errorMessage, e.getMessage()));
                context.attempted();
                return;
            }
            if (this.invalidUser(context, user)) {
                String errorMessage = "X509 certificate authentication's failed.";
                context.challenge(this.createErrorResponse(context, certs[0].getSubjectDN().getName(), errorMessage, "Invalid user"));
                context.attempted();
                return;
            }
            String bruteForceError = AuthenticatorUtils.getDisabledByBruteForceEventError(context, user);
            if (bruteForceError != null) {
                context.getEvent().user(user);
                context.getEvent().error(bruteForceError);
                String errorMessage = "X509 certificate authentication's failed.";
                context.challenge(this.createErrorResponse(context, certs[0].getSubjectDN().getName(), errorMessage, "Invalid user"));
                context.attempted();
                return;
            }
            if (!this.userEnabled(context, user)) {
                String errorMessage = "X509 certificate authentication's failed.";
                context.challenge(this.createErrorResponse(context, certs[0].getSubjectDN().getName(), errorMessage, "User is disabled"));
                context.attempted();
                return;
            }
            context.setUser(user);
            if (!config.getConfirmationPageDisallowed()) {
                context.forceChallenge(this.createSuccessResponse(context, certs[0].getSubjectDN().toString()));
            } else {
                context.success("cert");
            }
        }
        catch (Exception e) {
            logger.errorf((Throwable)e, "[authenticate] Exception: %s", (Object)e.getMessage());
            context.attempted();
        }
    }

    private Response createErrorResponse(AuthenticationFlowContext context, String subjectDN, String errorMessage, String ... errorParameters) {
        return this.createResponse(context, subjectDN, false, errorMessage, errorParameters);
    }

    private Response createSuccessResponse(AuthenticationFlowContext context, String subjectDN) {
        return this.createResponse(context, subjectDN, true, null, null);
    }

    private Response createResponse(AuthenticationFlowContext context, String subjectDN, boolean isUserEnabled, String errorMessage, Object[] errorParameters) {
        LoginFormsProvider form = context.form();
        if (errorMessage != null && errorMessage.trim().length() > 0) {
            LinkedList<FormMessage> errors = new LinkedList<FormMessage>();
            errors.add(new FormMessage(errorMessage, new Object[0]));
            if (errorParameters != null) {
                for (Object errorParameter : errorParameters) {
                    if (errorParameter == null) continue;
                    for (String part : errorParameter.toString().split("\n")) {
                        errors.add(new FormMessage(part, new Object[0]));
                    }
                }
            }
            form.setErrors(errors);
        }
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)"username", (Object)(context.getUser() != null ? context.getUser().getUsername() : "unknown user"));
        formData.add((Object)"subjectDN", (Object)subjectDN);
        formData.add((Object)"isUserEnabled", (Object)String.valueOf(isUserEnabled));
        form.setFormData((MultivaluedMap)formData);
        return form.createX509ConfirmPage();
    }

    private void dumpContainerAttributes(AuthenticationFlowContext context) {
        Map attributeNames = context.getSession().getAttributes();
        for (String name : attributeNames.keySet()) {
            logger.tracef("[dumpContainerAttributes] \"%s\"", (Object)name);
        }
    }

    private boolean userEnabled(AuthenticationFlowContext context, UserModel user) {
        if (!user.isEnabled()) {
            context.getEvent().user(user);
            context.getEvent().error("user_disabled");
            return false;
        }
        return true;
    }

    private boolean invalidUser(AuthenticationFlowContext context, UserModel user) {
        if (user == null) {
            context.getEvent().error("user_not_found");
            return true;
        }
        return false;
    }

    public void action(AuthenticationFlowContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        if (formData.containsKey((Object)"cancel")) {
            context.clearUser();
            context.attempted();
            return;
        }
        if (context.getUser() != null) {
            this.recordX509CertificateAuditDataViaContextEvent(context);
            context.success("cert");
            return;
        }
        context.attempted();
    }
}

