/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.kerberos.impl;

import java.security.PrivilegedExceptionAction;
import java.util.Base64;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.jboss.logging.Logger;
import org.keycloak.common.constants.KerberosConstants;
import org.keycloak.common.util.KerberosSerializationUtils;
import org.keycloak.federation.kerberos.CommonKerberosConfig;
import org.keycloak.federation.kerberos.KerberosPrincipal;
import org.keycloak.federation.kerberos.impl.KerberosServerSubjectAuthenticator;

public class SPNEGOAuthenticator {
    private static final Logger log = Logger.getLogger(SPNEGOAuthenticator.class);
    private final KerberosServerSubjectAuthenticator kerberosSubjectAuthenticator;
    private final String spnegoToken;
    private final CommonKerberosConfig kerberosConfig;
    private boolean authenticated = false;
    private String authenticatedKerberosPrincipal = null;
    private GSSCredential delegationCredential;
    private KerberosTicket kerberosTicket;
    private String responseToken = null;

    public SPNEGOAuthenticator(CommonKerberosConfig kerberosConfig, KerberosServerSubjectAuthenticator kerberosSubjectAuthenticator, String spnegoToken) {
        this.kerberosConfig = kerberosConfig;
        this.kerberosSubjectAuthenticator = kerberosSubjectAuthenticator;
        this.spnegoToken = spnegoToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("SPNEGO Login with token: " + this.spnegoToken));
        }
        try {
            Subject serverSubject = this.kerberosSubjectAuthenticator.authenticateServerSubject();
            this.authenticated = Subject.doAs(serverSubject, new AcceptSecContext());
            Set<KerberosTicket> kerberosTickets = serverSubject.getPrivateCredentials(KerberosTicket.class);
            Iterator<KerberosTicket> iterator = kerberosTickets.iterator();
            if (iterator.hasNext()) {
                this.kerberosTicket = iterator.next();
            }
        }
        catch (Exception e) {
            log.warn((Object)"SPNEGO login failed", (Throwable)e);
        }
        finally {
            this.kerberosSubjectAuthenticator.logoutServerSubject();
        }
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public String getResponseToken() {
        return this.responseToken;
    }

    public String getSerializedDelegationCredential() {
        if (this.delegationCredential == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"No delegation credential available.");
            }
            return null;
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Serializing credential " + String.valueOf(this.delegationCredential)));
            }
            return KerberosSerializationUtils.serializeCredential((KerberosTicket)this.kerberosTicket, (GSSCredential)this.delegationCredential);
        }
        catch (KerberosSerializationUtils.KerberosSerializationException kse) {
            log.warn((Object)("Couldn't serialize credential: " + String.valueOf(this.delegationCredential)), (Throwable)kse);
            return null;
        }
    }

    public KerberosPrincipal getAuthenticatedKerberosPrincipal() {
        return new KerberosPrincipal(this.authenticatedKerberosPrincipal);
    }

    protected GSSContext establishContext() throws GSSException {
        GSSManager manager = GSSManager.getInstance();
        Oid[] supportedMechs = new Oid[]{KerberosConstants.KRB5_OID, KerberosConstants.SPNEGO_OID};
        GSSCredential gssCredential = manager.createCredential(null, Integer.MAX_VALUE, supportedMechs, 2);
        GSSContext gssContext = manager.createContext(gssCredential);
        byte[] inputToken = Base64.getMimeDecoder().decode(this.spnegoToken);
        byte[] respToken = gssContext.acceptSecContext(inputToken, 0, inputToken.length);
        this.responseToken = Base64.getEncoder().encodeToString(respToken);
        return gssContext;
    }

    protected void logAuthDetails(GSSContext gssContext) throws GSSException {
        if (log.isDebugEnabled()) {
            String message = "SPNEGO Security context accepted with token: " + this.responseToken + ", established: " + gssContext.isEstablished() + ", credDelegState: " + gssContext.getCredDelegState() + ", mutualAuthState: " + gssContext.getMutualAuthState() + ", lifetime: " + gssContext.getLifetime() + ", confState: " + gssContext.getConfState() + ", integState: " + gssContext.getIntegState() + ", srcName: " + gssContext.getSrcName() + ", targName: " + gssContext.getTargName();
            log.debug((Object)message);
        }
    }

    private class AcceptSecContext
    implements PrivilegedExceptionAction<Boolean> {
        private AcceptSecContext() {
        }

        @Override
        public Boolean run() throws Exception {
            GSSContext gssContext = null;
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Going to establish security context");
                }
                gssContext = SPNEGOAuthenticator.this.establishContext();
                SPNEGOAuthenticator.this.logAuthDetails(gssContext);
                if (gssContext.isEstablished()) {
                    if (gssContext.getSrcName() == null) {
                        log.warn((Object)"GSS Context accepted, but no context initiator recognized. Check your kerberos configuration and reverse DNS lookup configuration");
                        Boolean bl = false;
                        return bl;
                    }
                    SPNEGOAuthenticator.this.authenticatedKerberosPrincipal = gssContext.getSrcName().toString();
                    if (gssContext.getCredDelegState()) {
                        SPNEGOAuthenticator.this.delegationCredential = gssContext.getDelegCred();
                    }
                    Boolean bl = true;
                    return bl;
                }
                Boolean bl = false;
                return bl;
            }
            finally {
                if (gssContext != null) {
                    gssContext.dispose();
                }
            }
        }
    }
}

