/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process.valign;

import org.jfree.layouting.input.style.keys.line.BaselineShift;
import org.jfree.layouting.input.style.keys.line.VerticalAlign;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.process.BoxShifter;
import org.jfree.layouting.renderer.process.InfiniteMajorAxisLayoutStep;
import org.jfree.layouting.renderer.process.valign.AlignContext;
import org.jfree.layouting.renderer.process.valign.BoxAlignContext;
import org.jfree.layouting.renderer.process.valign.InlineBlockAlignContext;
import org.jfree.layouting.renderer.text.TextUtility;

public class VerticalAlignmentProcessor {
    private long lineHeight;
    private long minTopPos;
    private long maxBottomPos;
    private BoxAlignContext rootContext;
    private long sourcePosition;

    public void align(BoxAlignContext boxAlignContext, long l, long l2) {
        this.minTopPos = Long.MAX_VALUE;
        this.maxBottomPos = Long.MIN_VALUE;
        this.lineHeight = l2;
        this.rootContext = boxAlignContext;
        this.sourcePosition = l;
        this.performAlignment(boxAlignContext);
        this.performExtendedAlignment(boxAlignContext, boxAlignContext);
        this.normalizeAlignment(boxAlignContext);
        boxAlignContext.setAfterEdge(this.maxBottomPos);
        boxAlignContext.shift(-this.minTopPos + l);
        this.apply(boxAlignContext);
        this.rootContext = null;
    }

    private void performAlignment(BoxAlignContext boxAlignContext) {
        for (AlignContext alignContext = boxAlignContext.getFirstChild(); alignContext != null; alignContext = alignContext.getNext()) {
            Object object;
            AlignContext alignContext2;
            if (alignContext instanceof InlineBlockAlignContext) {
                alignContext2 = (InlineBlockAlignContext)alignContext;
                object = new InfiniteMajorAxisLayoutStep();
                ((InfiniteMajorAxisLayoutStep)object).continueComputation((RenderBox)alignContext2.getNode());
            }
            alignContext2 = boxAlignContext;
            object = alignContext.getNode().getVerticalAlignment();
            if (VerticalAlign.TOP.equals(object) || VerticalAlign.BOTTOM.equals(object)) {
                alignContext2 = this.rootContext;
            }
            long l = this.computeShift(alignContext, (BoxAlignContext)alignContext2);
            int n = TextUtility.translateAlignmentBaseline(alignContext.getNode().getAlignmentBaseline(), alignContext.getDominantBaseline());
            long l2 = this.computeAlignmentAdjust(alignContext, n);
            long l3 = alignContext.getBaselineDistance(0);
            long l4 = -l3 + l2 + alignContext.getBeforeEdge();
            long l5 = ((BoxAlignContext)alignContext2).getBaselineDistance(n);
            long l6 = ((BoxAlignContext)alignContext2).getBaselineDistance(0);
            long l7 = -l6 + l5 + ((BoxAlignContext)alignContext2).getBeforeEdge();
            long l8 = l7 - l4;
            long l9 = l + l8;
            alignContext.shift(l9);
            if (this.rootContext.getBeforeEdge() > alignContext.getBeforeEdge()) {
                this.rootContext.setBeforeEdge(alignContext.getBeforeEdge());
            }
            if (this.rootContext.getAfterEdge() < alignContext.getAfterEdge()) {
                this.rootContext.setAfterEdge(alignContext.getAfterEdge());
            }
            if (!(alignContext instanceof BoxAlignContext)) continue;
            this.performAlignment((BoxAlignContext)alignContext);
        }
    }

    private void normalizeAlignment(BoxAlignContext boxAlignContext) {
        this.minTopPos = Math.min(this.minTopPos, boxAlignContext.getBeforeEdge());
        this.maxBottomPos = Math.max(this.maxBottomPos, boxAlignContext.getAfterEdge());
        for (AlignContext alignContext = boxAlignContext.getFirstChild(); alignContext != null; alignContext = alignContext.getNext()) {
            if (!(alignContext instanceof BoxAlignContext)) continue;
            this.normalizeAlignment((BoxAlignContext)alignContext);
        }
    }

    private long computeShift(AlignContext alignContext, BoxAlignContext boxAlignContext) {
        RenderNode renderNode = alignContext.getNode();
        CSSValue cSSValue = renderNode.getBaselineShift();
        if (cSSValue == null || BaselineShift.BASELINE.equals(cSSValue)) {
            return 0L;
        }
        if (BaselineShift.SUB.equals(cSSValue)) {
            return alignContext.getBaselineDistance(6) - alignContext.getBaselineDistance(5);
        }
        if (BaselineShift.SUPER.equals(cSSValue)) {
            return boxAlignContext.getBaselineDistance(5) - boxAlignContext.getBaselineDistance(6);
        }
        RenderLength renderLength = renderNode.getBaselineShiftResolved();
        if (renderLength != null) {
            return renderLength.resolve(this.lineHeight);
        }
        return 0L;
    }

    private long computeAlignmentAdjust(AlignContext alignContext, int n) {
        RenderNode renderNode = alignContext.getNode();
        CSSValue cSSValue = renderNode.getAlignmentAdjust();
        if (CSSAutoValue.getInstance().equals(cSSValue)) {
            return alignContext.getBaselineDistance(n);
        }
        if (cSSValue instanceof CSSConstant) {
            int n2 = TextUtility.translateAlignmentBaseline(cSSValue, n);
            return alignContext.getBaselineDistance(n2);
        }
        RenderLength renderLength = renderNode.getAlignmentAdjustResolved();
        if (renderLength != null) {
            return renderLength.resolve(this.lineHeight);
        }
        return alignContext.getBaselineDistance(n);
    }

    private void apply(BoxAlignContext boxAlignContext) {
        RenderNode renderNode = boxAlignContext.getNode();
        renderNode.setY(boxAlignContext.getBeforeEdge());
        renderNode.setHeight(boxAlignContext.getAfterEdge() - boxAlignContext.getBeforeEdge());
        for (AlignContext alignContext = boxAlignContext.getFirstChild(); alignContext != null; alignContext = alignContext.getNext()) {
            Object object;
            if (alignContext instanceof BoxAlignContext) {
                this.apply((BoxAlignContext)alignContext);
                continue;
            }
            if (alignContext instanceof InlineBlockAlignContext) {
                object = new BoxShifter();
                long l = alignContext.getBeforeEdge() - this.sourcePosition;
                ((BoxShifter)object).shiftBox((RenderBox)alignContext.getNode(), l);
                continue;
            }
            object = alignContext.getNode();
            ((RenderNode)object).setY(alignContext.getBeforeEdge());
            ((RenderNode)object).setHeight(alignContext.getAfterEdge() - alignContext.getBeforeEdge());
        }
    }

    protected void print(BoxAlignContext boxAlignContext, int n) {
        for (AlignContext alignContext = boxAlignContext.getFirstChild(); alignContext != null; alignContext = alignContext.getNext()) {
            if (!(alignContext instanceof BoxAlignContext)) continue;
            this.print((BoxAlignContext)alignContext, n + 1);
        }
    }

    private void performExtendedAlignment(BoxAlignContext boxAlignContext, BoxAlignContext boxAlignContext2) {
        for (AlignContext alignContext = boxAlignContext.getFirstChild(); alignContext != null; alignContext = alignContext.getNext()) {
            long l;
            long l2;
            CSSValue cSSValue = alignContext.getNode().getVerticalAlignment();
            if (VerticalAlign.TOP.equals(cSSValue)) {
                l2 = alignContext.getBeforeEdge();
                l = boxAlignContext2.getBeforeEdge();
                alignContext.shift(l - l2);
            } else if (VerticalAlign.BOTTOM.equals(cSSValue)) {
                l2 = alignContext.getAfterEdge();
                l = boxAlignContext2.getAfterEdge();
                alignContext.shift(l - l2);
            }
            if (!(alignContext instanceof BoxAlignContext)) continue;
            this.performExtendedAlignment((BoxAlignContext)alignContext, boxAlignContext2);
        }
    }
}

